/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp.r3;

import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.replication.imp.adapters.r3.UmSyncR3;
import com.sap.security.core.util.IUMTrace;
import java.util.Map;
import java.util.Vector;

public class UmSusRegistration {
    public static final String VERSIONSTRING = "$Id: //sapmarkets/UserManagement/30_SP_COR/src/_core/java/com/sapmarkets/usermanagement/sapmimp/persistence/r3/UmSusRegistration.java#2 $ from $DateTime: 2003/07/25 14:37:40 $ ($Change: 140352 $)";
    private static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //sapmarkets/UserManagement/30_SP_COR/src/_core/java/com/sapmarkets/usermanagement/sapmimp/persistence/r3/UmSusRegistration.java#2 $ from $DateTime: 2003/07/25 14:37:40 $ ($Change: 140352 $)");
    public static final String SELFREG_SUS_ADAPTERID = "ume.admin.selfreg_sus.adapterid";
    public static final String SELFREG_SUS_SYSID_DEFAULT = "SUS";
    private static final String EV_BPARTNER = "EV_BPARTNER";
    private static final String EV_RETURNCODE = "EV_RETURNCODE";
    private static final String ERROR_TYPE = "ERROR_TYPE";
    private static final String ERROR_ID = "ERROR_ID";
    private static final String ERROR_NUMBER = "ERROR_NUMBER";
    private static final String ERROR_MSG = "ERROR_MSG";
    private String r3_id = null;

    public UmSusRegistration() {
        IUMParameters mySAPProperties = UMFactory.getProperties();
        this.r3_id = mySAPProperties.get(SELFREG_SUS_ADAPTERID, SELFREG_SUS_SYSID_DEFAULT);
        trace.debugT("UmSusRegistration", "adapterid=" + this.r3_id);
    }

    public String susRegistrationCheck(String regid) throws UMException {
        String methodname = "susRegistrationCheck";
        trace.entering(methodname, new String[]{regid});
        UmSyncR3 syncR3 = new UmSyncR3(this.r3_id);
        Map info = syncR3.crm_sup_register_check(regid);
        String bpartner = (String)info.get(EV_BPARTNER);
        if (info == null || info.isEmpty()) {
            throw new UMException("Unknow error: no data returned...check trace file");
        }
        Integer rc = (Integer)info.get(EV_RETURNCODE);
        if (rc == 0) {
            trace.exiting(methodname, new Object[]{bpartner});
            return bpartner;
        }
        Vector vErrorType = (Vector)info.get(ERROR_TYPE);
        Vector vErrorId = (Vector)info.get(ERROR_ID);
        Vector vErrorNum = (Vector)info.get(ERROR_NUMBER);
        Vector vErrorMsg = (Vector)info.get(ERROR_MSG);
        StringBuffer errmsg = new StringBuffer(100);
        errmsg.append("RC=").append(rc);
        if (!vErrorMsg.isEmpty()) {
            errmsg.append(" type=").append((String)vErrorType.get(0));
            errmsg.append(" id=").append((String)vErrorId.get(0));
            errmsg.append(" num=").append((String)vErrorNum.get(0));
            errmsg.append(" msg=").append((String)vErrorMsg.get(0));
        }
        trace.debugT(methodname, "Error: ", new String[]{errmsg.toString()});
        trace.exiting(methodname);
        throw new UMException(errmsg.toString());
    }

    public void susRegistrationDelete(String uid) throws UMException {
        String methodname = "susRegistrationDelete";
        UmSyncR3 syncR3 = new UmSyncR3(this.r3_id);
        trace.debugT(methodname, "uid=" + uid);
        Map info = syncR3.crm_mom_user_delete(uid);
        Integer rc = (Integer)info.get(EV_RETURNCODE);
        if (rc == null || rc != 0) {
            Vector vErrorType = (Vector)info.get(ERROR_TYPE);
            Vector vErrorId = (Vector)info.get(ERROR_ID);
            Vector vErrorNum = (Vector)info.get(ERROR_NUMBER);
            Vector vErrorMsg = (Vector)info.get(ERROR_MSG);
            StringBuffer errmsg = new StringBuffer(100);
            errmsg.append("RC=").append(rc);
            if (!vErrorMsg.isEmpty()) {
                errmsg.append(" type=").append((String)vErrorType.get(0));
                errmsg.append(" id=").append((String)vErrorId.get(0));
                errmsg.append(" num=").append((String)vErrorNum.get(0));
                errmsg.append(" msg=").append((String)vErrorMsg.get(0));
            }
            trace.debugT(methodname, "Error: ", new String[]{errmsg.toString()});
            trace.exiting(methodname);
            throw new UMException(errmsg.toString());
        }
        trace.exiting(methodname);
    }
}

