/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp.r3;

import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.JCO;
import com.sap.security.api.UMFactory;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.IInternalPrincipalDatabag;
import com.sap.security.core.persistence.datasource.imp.r3.R3ConnectionSAP;
import com.sap.security.core.persistence.datasource.imp.r3.SAPUserIdMapping;
import com.sap.security.core.persistence.replication.imp.adapters.r3.ParseXML;
import com.sap.security.core.persistence.replication.imp.adapters.r3.ProcessR3RespDoc;
import com.sap.security.core.persistence.replication.imp.adapters.r3.UmR3Properties;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.cache.ICache;
import com.sap.security.um.r3.R3User;
import com.sap.security.um.r3.R3UserFactory;
import com.sap.security.usermanagement.FeatureNotAvailableException;
import com.sap.security.usermanagement.IUser;
import com.sap.security.usermanagement.IUserAccount;
import com.sap.security.usermanagement.NoSuchUserException;
import com.sap.security.usermanagement.UMException;
import com.sap.security.util.SAPBasis;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;

public class UmR3UserFactory
extends R3UserFactory {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/r3/UmR3UserFactory.java#2 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)";
    private static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/r3/UmR3UserFactory.java#2 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)");
    private static final IUMParameters mySAPProperties = UMFactory.getProperties();
    private static ICache mCache = InternalUMFactory.getCache(2, 100, 60, (class$com$sap$security$core$persistence$datasource$imp$r3$UmR3UserFactory == null ? (class$com$sap$security$core$persistence$datasource$imp$r3$UmR3UserFactory = UmR3UserFactory.class$("com.sap.security.core.persistence.datasource.imp.r3.UmR3UserFactory")) : class$com$sap$security$core$persistence$datasource$imp$r3$UmR3UserFactory).getName() + "_mCache");
    public static String XML_SENDER_USERID_KEY = "ume.r3.sync.sender";
    public static String XML_SENDER_USERID_DEFAULT = "SAPMUM";
    private static String USER_KEY = "user_";
    private static String ACNT_KEY = "acnt_";
    private static String USE_EBP_SP2 = "ume.use.ebp.sp2";
    private final IRepository _repository;
    private final JCO.PoolManager _poolManager;
    private final String _poolId;
    static /* synthetic */ Class class$com$sap$security$core$persistence$datasource$imp$r3$UmR3UserFactory;

    public UmR3UserFactory(SAPBasis sapBasis, Properties pOptions) throws UMException {
        super(sapBasis, pOptions, R3ConnectionSAP.securityKey);
        this._repository = sapBasis.getRepository();
        this._poolManager = sapBasis.getPoolManager();
        this._poolId = sapBasis.getPoolID();
    }

    public UmR3UserFactory(SAPBasis sapBasis, Properties pOptions, String key) throws UMException {
        super(sapBasis, pOptions, key);
        this._repository = sapBasis.getRepository();
        this._poolManager = sapBasis.getPoolManager();
        this._poolId = sapBasis.getPoolID();
    }

    public void SMUM_TPUser(byte[] iBytes, String r3system) throws UMException {
        String methodname = "SMUM_TPUser";
        trace.entering(methodname, new Object[]{r3system});
        String rfcName = "SMUM_TPUSER";
        JCO.Client client = null;
        SAPBasis sapBasis = this.getSAPBasis();
        UmR3Properties umProp = new UmR3Properties(r3system);
        try {
            try {
                String sender = mySAPProperties.get(XML_SENDER_USERID_KEY, XML_SENDER_USERID_DEFAULT);
                String receiver = umProp.getReceiverId();
                String requestmode = "SYNC";
                trace.debugT(methodname, "Get JCO client on: " + sapBasis.getSystemID());
                client = sapBasis.getClient();
                JCO.Function function = sapBasis.getRepository().getFunctionTemplate(rfcName).getFunction();
                JCO.ParameterList inputparm = function.getImportParameterList();
                inputparm.appendValue("SENDER", 0, 255, sender);
                trace.debugT(methodname, "SENDER=" + sender);
                inputparm.appendValue("RECEIVER", 0, 255, receiver);
                trace.debugT(methodname, "RECEIVER=" + receiver);
                inputparm.appendValue("REQUESTMODE", 0, 10, requestmode);
                trace.debugT(methodname, "REQUESTMODE=" + requestmode);
                inputparm.appendValue("CORRELATIONID", 0, 36, "1234567890");
                int iSize = iBytes.length;
                inputparm.appendValue("DOCSTRING", 30, iSize, iBytes);
                JCO.ParameterList outputparm = JCO.createParameterList();
                outputparm.addInfo("RETDOCTYPE", 0, 255);
                outputparm.addInfo("RETDOCSTRING", 30, 0);
                client.execute(rfcName, inputparm, outputparm);
                byte[] retdocstring = outputparm.getByteArray(1);
                ParseXML respParser = new ParseXML(retdocstring);
                ProcessR3RespDoc r3RespDoc = new ProcessR3RespDoc(respParser, iBytes);
                int nErrDocs = r3RespDoc.createXML();
                int i = 0;
                while (i < nErrDocs) {
                    if (r3RespDoc.getErrMsg(i) != null) {
                        String errmsg = r3RespDoc.getUserid(i) + "-" + r3RespDoc.getErrMsg(i);
                        trace.errorT(methodname, errmsg);
                        throw new UMException(errmsg);
                    }
                    ++i;
                }
            }
            catch (JCO.AbapException e) {
                trace.errorT(methodname, e.getMessage(), new Object[]{e});
                throw new UMException(e.getMessage());
            }
            catch (Exception ex) {
                trace.errorT(methodname, "R/3 SMUM_TPUser failed: " + ex.getMessage(), ex);
                throw new UMException(ex.getMessage());
            }
            Object var22_23 = null;
        }
        catch (Throwable throwable) {
            Object var22_24 = null;
            sapBasis.releaseClient(client);
            throw throwable;
        }
        sapBasis.releaseClient(client);
        trace.exiting(methodname);
    }

    public IUserAccount getUserAccount(String userid) throws UMException {
        String methodname = "getUserAccount";
        trace.entering(methodname, new Object[]{userid});
        String key = ACNT_KEY + userid;
        IUserAccount useraccount = (IUserAccount)mCache.get(key);
        if (useraccount == null) {
            try {
                useraccount = super.getUserAccount(userid);
                mCache.put(key, useraccount);
            }
            catch (UMException ex) {
                throw new UMException(ex.getMessage());
            }
        }
        trace.exiting(methodname);
        return useraccount;
    }

    public IUser getUser(String userid) throws NoSuchUserException {
        String methodname = "getUser";
        trace.entering(methodname, new Object[]{userid});
        String key = USER_KEY + userid;
        IUser user = (IUser)mCache.get(key);
        if (user == null) {
            try {
                user = super.getUser(userid);
                mCache.put(key, user);
            }
            catch (NoSuchUserException ex) {
                throw new NoSuchUserException(ex.getMessage());
            }
        }
        trace.exiting(methodname);
        return user;
    }

    public void getOtherSAPInfo(String nameSpace, IInternalPrincipalDatabag principal) {
        String methodname = "getOtherSAPInfo";
        trace.entering(methodname);
        try {
            if (SAPUserIdMapping.isSAPSystem("EBP")) {
                trace.debugT(methodname, "get EBP user data: " + principal.getUniqueID());
                this.getEBPInfo(nameSpace, principal);
            }
            if (SAPUserIdMapping.isSAPSystem("CRM")) {
                trace.debugT(methodname, "get CRM user data: " + principal.getUniqueID());
                this.getCRMInfo(nameSpace, principal);
            }
        }
        catch (Exception e) {
            trace.errorT(methodname, e.getMessage(), e);
        }
        trace.exiting(methodname);
    }

    protected void getOtherSAPInfo(R3User user) {
        String methodname = "getOtherSAPInfo";
        trace.entering(methodname);
        try {
            if (SAPUserIdMapping.isSAPSystem("EBP")) {
                trace.debugT(methodname, "get EBP user data: " + user.getUniqueID());
                this.getEBPInfo(user);
            }
            if (SAPUserIdMapping.isSAPSystem("CRM")) {
                trace.debugT(methodname, "get CRM user data: " + user.getUniqueID());
                this.getCRMInfo(user);
            }
        }
        catch (Exception e) {
            trace.errorT(methodname, e.getMessage(), e);
        }
        trace.exiting(methodname);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String assignR3Roles(String username, Vector vRoles) {
        String methodname = "assignR3Roles";
        trace.entering(methodname, new Object[]{username, vRoles});
        String rfcName = "BAPI_USER_ACTGROUPS_ASSIGN";
        String errmsg = "";
        JCO.Client client = null;
        SAPBasis sapBasis = this.getSAPBasis();
        try {
            try {
                trace.debugT(methodname, "Get JCO client on: " + sapBasis.getSystemID());
                client = sapBasis.getClient();
                JCO.Function function = sapBasis.getRepository().getFunctionTemplate(rfcName).getFunction();
                function.getImportParameterList().setValue(username, "USERNAME");
                JCO.Table tRoles = function.getTableParameterList().getTable("ACTIVITYGROUPS");
                int i = 0;
                while (i < vRoles.size()) {
                    String roleName = (String)vRoles.get(i);
                    tRoles.appendRow();
                    tRoles.setValue(roleName, "AGR_NAME");
                    tRoles.nextRow();
                    ++i;
                }
                client.execute(function);
                JCO.Table tReturn = function.getTableParameterList().getTable("RETURN");
                int i2 = 0;
                while (i2 < tReturn.getNumRows()) {
                    tReturn.setRow(i2);
                    String msgType = tReturn.getString("TYPE");
                    if (!msgType.equalsIgnoreCase("S")) {
                        errmsg = errmsg + "/" + tReturn.getString("MESSAGE");
                    }
                    ++i2;
                }
            }
            catch (Exception e) {
                trace.errorT(methodname, e.getMessage(), e);
                Object var15_16 = null;
                sapBasis.releaseClient(client);
            }
            Object var15_15 = null;
            sapBasis.releaseClient(client);
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            sapBasis.releaseClient(client);
            throw throwable;
        }
        trace.exiting(methodname);
        return errmsg;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getEBPInfo(R3User user) {
        String methodname;
        block81: {
            methodname = "getEBPInfo";
            trace.entering(methodname);
            String rfcName = null;
            JCO.Client client = null;
            String uid = user.getUniqueID().toUpperCase();
            trace.debugT(methodname, "Get EBP user data: " + uid);
            SAPBasis sapBasis = this.getSAPBasis();
            user.prepare();
            try {
                try {
                    block79: {
                        JCO.Function function;
                        block70: {
                            JCO.Structure address;
                            block69: {
                                block68: {
                                    block67: {
                                        trace.debugT(methodname, "Get JCO client on: " + sapBasis.getSystemID());
                                        client = sapBasis.getClient();
                                        rfcName = "BBP_USER_ORGASSIGNMENT_GET";
                                        function = sapBasis.getRepository().getFunctionTemplate(rfcName).getFunction();
                                        function.getImportParameterList().setValue(uid, "UNAME");
                                        client.execute(function);
                                        address = function.getExportParameterList().getStructure("ADDRESSES");
                                        if (address.getString("CITY") != null) {
                                            try {
                                                user.setCity(address.getString("CITY"));
                                            }
                                            catch (FeatureNotAvailableException ex) {
                                                if (!trace.beDebug()) break block67;
                                                trace.debugT(methodname, ex);
                                            }
                                        }
                                    }
                                    if (address.getString("COUNTRYISO") != null) {
                                        try {
                                            user.setCountry(address.getString("COUNTRYISO"));
                                        }
                                        catch (FeatureNotAvailableException ex) {
                                            if (!trace.beDebug()) break block68;
                                            trace.debugT(methodname, ex);
                                        }
                                    }
                                }
                                if (address.getString("REGION") != null) {
                                    try {
                                        user.setState(address.getString("REGION"));
                                    }
                                    catch (FeatureNotAvailableException ex) {
                                        if (!trace.beDebug()) break block69;
                                        trace.debugT(methodname, ex);
                                    }
                                }
                            }
                            if (address.getString("STREET") != null) {
                                try {
                                    user.setStreet(address.getString("STREET"));
                                }
                                catch (FeatureNotAvailableException ex) {
                                    if (!trace.beDebug()) break block70;
                                    trace.debugT(methodname, ex);
                                }
                            }
                        }
                        JCO.Table tOrgunits = function.getTableParameterList().getTable("OBJ_TAB");
                        Vector<String> vOrgunits = new Vector<String>();
                        int i = 0;
                        while (true) {
                            if (i >= tOrgunits.getNumRows()) {
                                if (vOrgunits.isEmpty()) break;
                                String[] orgunits = vOrgunits.toArray(new String[1]);
                                try {
                                    user.setAttribute("UM", "ORGUNIT", orgunits);
                                }
                                catch (FeatureNotAvailableException ex) {
                                    if (!trace.beDebug()) break;
                                    trace.debugT(methodname, ex);
                                }
                                break;
                            }
                            tOrgunits.setRow(i);
                            vOrgunits.add(tOrgunits.getString("OBJID"));
                            ++i;
                        }
                        String[] sArray = new String[1];
                        rfcName = "BBP_USER_GET_DETAIL_FIELDS";
                        function = sapBasis.getRepository().getFunctionTemplate(rfcName).getFunction();
                        function.getImportParameterList().setValue(uid, "USERNAME");
                        client.execute(function);
                        String userType = function.getExportParameterList().getString("USER_TYPE");
                        trace.debugT(methodname, uid + "-user type=" + userType);
                        if (userType.equalsIgnoreCase("BUYER")) {
                            JCO.ParameterList exportParmList;
                            block78: {
                                block77: {
                                    block76: {
                                        block75: {
                                            block74: {
                                                block73: {
                                                    block72: {
                                                        block71: {
                                                            exportParmList = function.getExportParameterList();
                                                            if (exportParmList.getString("LASTNAME") != null) {
                                                                user.setLastName(exportParmList.getString("LASTNAME"));
                                                            }
                                                            if (exportParmList.getString("FIRSTNAME") != null) {
                                                                user.setFirstName(exportParmList.getString("FIRSTNAME"));
                                                            }
                                                            if (exportParmList.getString("E_MAIL") != null) {
                                                                user.setEmail(exportParmList.getString("E_MAIL"));
                                                            }
                                                            if (exportParmList.getString("ACADEMIC_TITLE_TEXT") != null) {
                                                                sArray[0] = exportParmList.getString("ACADEMIC_TITLE_TEXT");
                                                                try {
                                                                    user.setAttribute("UM", "AcademicTitle", sArray);
                                                                }
                                                                catch (FeatureNotAvailableException ex) {
                                                                    if (!trace.beDebug()) break block71;
                                                                    trace.debugT(methodname, ex);
                                                                }
                                                            }
                                                        }
                                                        if (exportParmList.getString("FORM_OF_ADDRESS_TEXT") != null) {
                                                            user.setTitle(exportParmList.getString("FORM_OF_ADDRESS_TEXT"));
                                                        }
                                                        if (exportParmList.getString("BUILDING") != null) {
                                                            sArray[0] = exportParmList.getString("BUILDING");
                                                            try {
                                                                user.setAttribute("UM", "BUILDING", sArray);
                                                            }
                                                            catch (FeatureNotAvailableException ex) {
                                                                if (!trace.beDebug()) break block72;
                                                                trace.debugT(methodname, ex);
                                                            }
                                                        }
                                                    }
                                                    if (exportParmList.getString("FLOOR") != null) {
                                                        sArray[0] = exportParmList.getString("FLOOR");
                                                        try {
                                                            user.setAttribute("UM", "FLOOR", sArray);
                                                        }
                                                        catch (FeatureNotAvailableException ex) {
                                                            if (!trace.beDebug()) break block73;
                                                            trace.debugT(methodname, ex);
                                                        }
                                                    }
                                                }
                                                if (exportParmList.getString("ROOM_NUMBER") != null) {
                                                    sArray[0] = exportParmList.getString("ROOM_NUMBER");
                                                    try {
                                                        user.setAttribute("UM", "ROOM", sArray);
                                                    }
                                                    catch (FeatureNotAvailableException ex) {
                                                        if (!trace.beDebug()) break block74;
                                                        trace.debugT(methodname, ex);
                                                    }
                                                }
                                            }
                                            if (exportParmList.getString("INHOUSE_MAIL") != null) {
                                                sArray[0] = exportParmList.getString("INHOUSE_MAIL");
                                                try {
                                                    user.setAttribute("UM", "InHouseMail", sArray);
                                                }
                                                catch (FeatureNotAvailableException ex) {
                                                    if (!trace.beDebug()) break block75;
                                                    trace.debugT(methodname, ex);
                                                }
                                            }
                                        }
                                        String pNumber = null;
                                        String pExt = null;
                                        if (exportParmList.getString("TELEPHONE_NUMBER") != null) {
                                            pNumber = exportParmList.getString("TELEPHONE_NUMBER");
                                        }
                                        if (exportParmList.getString("TELEPHONE_EXTENSION") != null) {
                                            pExt = exportParmList.getString("TELEPHONE_EXTENSION");
                                        }
                                        if (this.hasValue(pNumber)) {
                                            if (this.hasValue(pExt)) {
                                                pNumber = pNumber + "+" + pExt;
                                            }
                                        } else if (this.hasValue(pExt)) {
                                            pNumber = pExt;
                                        }
                                        if (this.hasValue(pNumber)) {
                                            user.setTelephone(pNumber);
                                        }
                                        pNumber = null;
                                        pExt = null;
                                        if (exportParmList.getString("FAX_NUMBER") != null) {
                                            pNumber = exportParmList.getString("FAX_NUMBER");
                                        }
                                        if (exportParmList.getString("FAX_EXTENSION") != null) {
                                            pExt = exportParmList.getString("FAX_EXTENSION");
                                        }
                                        if (this.hasValue(pNumber)) {
                                            if (this.hasValue(pExt)) {
                                                pNumber = pNumber + "+" + pExt;
                                            }
                                        } else if (this.hasValue(pExt)) {
                                            pNumber = pExt;
                                        }
                                        if (this.hasValue(pNumber)) {
                                            user.setFax(pNumber);
                                        }
                                        if (exportParmList.getString("MANAGER_FLAG") != null) {
                                            sArray[0] = exportParmList.getString("MANAGER_FLAG");
                                            try {
                                                user.setAttribute("UM", "MANAGER", sArray);
                                            }
                                            catch (FeatureNotAvailableException ex) {
                                                if (!trace.beDebug()) break block76;
                                                trace.debugT(methodname, ex);
                                            }
                                        }
                                    }
                                    if (exportParmList.getString("ORGUNIT") != null) {
                                        sArray[0] = exportParmList.getString("ORGUNIT");
                                        try {
                                            user.setAttribute("UM", "ORGUNIT", sArray);
                                        }
                                        catch (FeatureNotAvailableException ex) {
                                            if (!trace.beDebug()) break block77;
                                            trace.debugT(methodname, ex);
                                        }
                                    }
                                }
                                if (exportParmList.getString("DATE_FORMAT") != null) {
                                    sArray[0] = exportParmList.getString("DATE_FORMAT");
                                    try {
                                        user.setAttribute("UM", "DATE_FORMAT", sArray);
                                    }
                                    catch (FeatureNotAvailableException ex) {
                                        if (!trace.beDebug()) break block78;
                                        trace.debugT(methodname, ex);
                                    }
                                }
                            }
                            if (exportParmList.getString("DECIMAL_FORMAT") != null) {
                                sArray[0] = exportParmList.getString("DECIMAL_FORMAT");
                                try {
                                    user.setAttribute("UM", "DECIMAL_FORMAT", sArray);
                                }
                                catch (FeatureNotAvailableException ex) {
                                    if (!trace.beDebug()) break block79;
                                    trace.debugT(methodname, ex);
                                }
                            }
                        }
                    }
                    Object var19_34 = null;
                }
                catch (JCO.AbapException ae) {
                    trace.debugT(methodname, "AbapException: " + rfcName + "(" + uid + ")" + "-" + ae.getMessage(), ae);
                    Object var19_35 = null;
                    sapBasis.releaseClient(client);
                    break block81;
                }
                catch (Exception e) {
                    trace.errorT(methodname, "Exception: " + rfcName + "(" + uid + ")" + "-" + e.getMessage(), e);
                    Object var19_36 = null;
                    sapBasis.releaseClient(client);
                    break block81;
                }
            }
            catch (Throwable throwable) {
                Object var19_37 = null;
                sapBasis.releaseClient(client);
                throw throwable;
            }
            sapBasis.releaseClient(client);
        }
        trace.exiting(methodname);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getEBPInfo(String nameSpace, IInternalPrincipalDatabag principal) {
        String methodname;
        block47: {
            methodname = "getEBPInfo";
            trace.entering(methodname);
            String rfcName = null;
            JCO.Client client = null;
            String uid = principal.getUniqueID().toUpperCase();
            uid = uid.substring(uid.lastIndexOf(".") + 1);
            trace.debugT(methodname, "Get EBP user data: " + uid);
            SAPBasis sapBasis = this.getSAPBasis();
            try {
                block46: {
                    try {
                        JCO.Structure i_body;
                        trace.debugT(methodname, "Get JCO client on: " + sapBasis.getSystemID());
                        client = sapBasis.getClient();
                        rfcName = "BBP_USER_ORGASSIGNMENT_GET";
                        JCO.Function function = sapBasis.getRepository().getFunctionTemplate(rfcName).getFunction();
                        function.getImportParameterList().setValue(uid, "UNAME");
                        client.execute(function);
                        JCO.Structure address = function.getExportParameterList().getStructure("ADDRESSES");
                        if (address.getString("CITY") != null) {
                            this.addPrincipalValue(nameSpace, "city", address.getString("CITY"), principal);
                        }
                        if (address.getString("COUNTRYISO") != null) {
                            this.addPrincipalValue(nameSpace, "country", address.getString("COUNTRYISO"), principal);
                        }
                        if (address.getString("REGION") != null) {
                            this.addPrincipalValue(nameSpace, "state", address.getString("REGION"), principal);
                        }
                        if (address.getString("STREET") != null) {
                            this.addPrincipalValue(nameSpace, "streetaddress", address.getString("STREET"), principal);
                        }
                        JCO.Table tOrgunits = function.getTableParameterList().getTable("OBJ_TAB");
                        String orgunit = null;
                        int i = 0;
                        while (i < tOrgunits.getNumRows()) {
                            tOrgunits.setRow(i);
                            orgunit = tOrgunits.getString("OBJID");
                            ++i;
                        }
                        if (orgunit != null) {
                            this.addPrincipalValue(nameSpace, "ORGUNIT", orgunit, principal);
                        }
                        rfcName = "BBP_USER_GET_DETAIL_FIELDS";
                        function = sapBasis.getRepository().getFunctionTemplate(rfcName).getFunction();
                        function.getImportParameterList().setValue(uid, "USERNAME");
                        client.execute(function);
                        String userType = function.getExportParameterList().getString("USER_TYPE");
                        trace.debugT(methodname, uid + "-user type=" + userType);
                        if (userType.equalsIgnoreCase("BUYER")) {
                            JCO.ParameterList exportParmList = function.getExportParameterList();
                            if (exportParmList.getString("LASTNAME") != null) {
                                this.addPrincipalValue(nameSpace, "lastname", exportParmList.getString("LASTNAME"), principal);
                            }
                            if (exportParmList.getString("FIRSTNAME") != null) {
                                this.addPrincipalValue(nameSpace, "firstname", exportParmList.getString("FIRSTNAME"), principal);
                            }
                            if (exportParmList.getString("E_MAIL") != null) {
                                this.addPrincipalValue(nameSpace, "email", exportParmList.getString("E_MAIL"), principal);
                            }
                            if (exportParmList.getString("ACADEMIC_TITLE_TEXT") != null) {
                                this.addPrincipalValue(nameSpace, "salutation", exportParmList.getString("ACADEMIC_TITLE_TEXT"), principal);
                            }
                            if (exportParmList.getString("FORM_OF_ADDRESS_TEXT") != null) {
                                this.addPrincipalValue(nameSpace, "title", exportParmList.getString("FORM_OF_ADDRESS_TEXT"), principal);
                            }
                            if (exportParmList.getString("BUILDING") != null) {
                                this.addPrincipalValue(nameSpace, "BUILDING", exportParmList.getString("BUILDING"), principal);
                            }
                            if (exportParmList.getString("FLOOR") != null) {
                                this.addPrincipalValue(nameSpace, "FLOOR", exportParmList.getString("FLOOR"), principal);
                            }
                            if (exportParmList.getString("ROOM_NUMBER") != null) {
                                this.addPrincipalValue(nameSpace, "ROOM", exportParmList.getString("ROOM_NUMBER"), principal);
                            }
                            if (exportParmList.getString("INHOUSE_MAIL") != null) {
                                this.addPrincipalValue(nameSpace, "INHOUSE_MAIL", exportParmList.getString("INHOUSE_MAIL"), principal);
                            }
                            String pNumber = null;
                            String pExt = null;
                            if (exportParmList.getString("TELEPHONE_NUMBER") != null) {
                                pNumber = exportParmList.getString("TELEPHONE_NUMBER");
                            }
                            if (exportParmList.getString("TELEPHONE_EXTENSION") != null) {
                                pExt = exportParmList.getString("TELEPHONE_EXTENSION");
                            }
                            if (this.hasValue(pNumber)) {
                                if (this.hasValue(pExt)) {
                                    pNumber = pNumber + "+" + pExt;
                                }
                            } else if (this.hasValue(pExt)) {
                                pNumber = pExt;
                            }
                            if (this.hasValue(pNumber)) {
                                this.addPrincipalValue(nameSpace, "telephone", pNumber, principal);
                            }
                            pNumber = null;
                            pExt = null;
                            if (exportParmList.getString("FAX_NUMBER") != null) {
                                pNumber = exportParmList.getString("FAX_NUMBER");
                            }
                            if (exportParmList.getString("FAX_EXTENSION") != null) {
                                pExt = exportParmList.getString("FAX_EXTENSION");
                            }
                            if (this.hasValue(pNumber)) {
                                if (this.hasValue(pExt)) {
                                    pNumber = pNumber + "+" + pExt;
                                }
                            } else if (this.hasValue(pExt)) {
                                pNumber = pExt;
                            }
                            if (this.hasValue(pNumber)) {
                                this.addPrincipalValue(nameSpace, "fax", pNumber, principal);
                            }
                            if (exportParmList.getString("MANAGER_FLAG") != null) {
                                this.addPrincipalValue(nameSpace, "MANAGER", exportParmList.getString("MANAGER_FLAG"), principal);
                            }
                            if (exportParmList.getString("ORGUNIT") != null) {
                                this.addPrincipalValue(nameSpace, "ORGUNIT", exportParmList.getString("ORGUNIT"), principal);
                            }
                            if (exportParmList.getString("DATE_FORMAT") != null) {
                                this.addPrincipalValue(nameSpace, "DATE_FORMAT", exportParmList.getString("DATE_FORMAT"), principal);
                            }
                            if (exportParmList.getString("DECIMAL_FORMAT") != null) {
                                this.addPrincipalValue(nameSpace, "DECIMAL_FORMAT", exportParmList.getString("DECIMAL_FORMAT"), principal);
                            }
                        }
                        String companyId = null;
                        if (mySAPProperties.getBoolean(USE_EBP_SP2, true)) {
                            try {
                                rfcName = "BBP_OM_DETERMINE_COMPANY_EXT";
                                function = sapBasis.getRepository().getFunctionTemplate(rfcName).getFunction();
                                JCO.Structure is_compdetreq = function.getImportParameterList().getStructure("IS_COMPDETREQ");
                                i_body = is_compdetreq.getStructure("BODY");
                                JCO.Structure user_identifier = i_body.getStructure("USER_IDENTIFIER");
                                user_identifier.setValue(uid, "USER_ID");
                                client.execute(function);
                                JCO.Structure es_compdetrsp = function.getExportParameterList().getStructure("ES_COMPDETRSP");
                                JCO.Structure o_body = es_compdetrsp.getStructure("BODY");
                                JCO.Structure company_identifier = o_body.getStructure("COMPANY_IDENTIFIER");
                                companyId = company_identifier.getString("PARTNER_ID");
                            }
                            catch (Exception e) {
                                trace.infoT(methodname, "Error in RFC: " + rfcName + "(" + uid + ")", e);
                            }
                        } else {
                            rfcName = "BBP_PARTNER_GET_LIST_IN";
                            trace.debugT(methodname, "Get JCO client on: " + sapBasis.getSystemID());
                            client = sapBasis.getClient();
                            function = sapBasis.getRepository().getFunctionTemplate(rfcName).getFunction();
                            JCO.Structure i_export = function.getImportParameterList().getStructure("IS_PRTGLREQ");
                            i_body = i_export.getStructure("BODY");
                            JCO.Structure partner_selection = i_body.getStructure("PARTNER_SELECTION");
                            partner_selection.setValue("Requestor", "PARTNER_TYPE");
                            JCO.Structure partner_identifier = partner_selection.getStructure("PARTNER_IDENTIFIER");
                            partner_identifier.setValue(uid, "USER_ID");
                            client.execute(function);
                            JCO.Structure o_import = function.getExportParameterList().getStructure("ETS_PRTGL_RSP");
                            JCO.Structure o_body = o_import.getStructure("BODY");
                            JCO.Table partner_list_item = o_body.getTable("PARTNER_LIST_ITEM");
                            JCO.Structure company_identifier = null;
                            int i2 = 0;
                            while (i2 < partner_list_item.getNumRows()) {
                                partner_list_item.setRow(i2);
                                company_identifier = partner_list_item.getStructure("COMPANY_IDENTIFIER");
                                companyId = company_identifier.getString("COMPANY_ID");
                                ++i2;
                            }
                            if (companyId == null) {
                                function = sapBasis.getRepository().getFunctionTemplate(rfcName).getFunction();
                                i_export = function.getImportParameterList().getStructure("IS_PRTGLREQ");
                                i_body = i_export.getStructure("BODY");
                                partner_selection = i_body.getStructure("PARTNER_SELECTION");
                                partner_selection.setValue("ContactPerson", "PARTNER_TYPE");
                                partner_identifier = partner_selection.getStructure("PARTNER_IDENTIFIER");
                                partner_identifier.setValue(uid, "USER_ID");
                                client.execute(function);
                                o_import = function.getExportParameterList().getStructure("ETS_PRTGL_RSP");
                                o_body = o_import.getStructure("BODY");
                                partner_list_item = o_body.getTable("PARTNER_LIST_ITEM");
                                int i3 = 0;
                                while (i3 < partner_list_item.getNumRows()) {
                                    partner_list_item.setRow(i3);
                                    company_identifier = partner_list_item.getStructure("COMPANY_IDENTIFIER");
                                    companyId = company_identifier.getString("COMPANY_ID");
                                    ++i3;
                                }
                            }
                        }
                        if (companyId == null) break block46;
                        this.addPrincipalValue(nameSpace, "companyid", companyId, principal);
                        this.addPrincipalValue(nameSpace, "company", companyId, principal);
                    }
                    catch (JCO.AbapException ae) {
                        trace.debugT(methodname, "AbapException: " + rfcName + "(" + uid + ")" + "-" + ae.getMessage(), ae);
                        Object var26_33 = null;
                        sapBasis.releaseClient(client);
                        break block47;
                    }
                    catch (Exception e) {
                        trace.errorT(methodname, "Exception: " + rfcName + "(" + uid + ")" + "-" + e.getMessage(), e);
                        Object var26_34 = null;
                        sapBasis.releaseClient(client);
                    }
                }
                Object var26_32 = null;
                sapBasis.releaseClient(client);
            }
            catch (Throwable throwable) {
                Object var26_35 = null;
                sapBasis.releaseClient(client);
                throw throwable;
            }
        }
        trace.exiting(methodname);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getCRMInfo(R3User user) {
        String methodname;
        block31: {
            methodname = "getCRMInfo";
            trace.entering(methodname);
            String rfcName = null;
            JCO.Client client = null;
            String uid = user.getUniqueID().toUpperCase();
            trace.debugT(methodname, "Get CRM user data: " + uid);
            SAPBasis sapBasis = this.getSAPBasis();
            String companyId = null;
            try {
                try {
                    int i;
                    String lang;
                    trace.debugT(methodname, "Get JCO client on: " + sapBasis.getSystemID());
                    client = sapBasis.getClient();
                    JCO.Function function = null;
                    String displayId = this.getDisplayId(uid);
                    user.setDisplayName(displayId);
                    rfcName = "CRM_ICSS_BPARTNER_FROM_USER";
                    function = sapBasis.getRepository().getFunctionTemplate(rfcName).getFunction();
                    function.getImportParameterList().setValue(uid, "USERID");
                    client.execute(function);
                    companyId = function.getExportParameterList().getString("BPARTNER");
                    if (this.hasValue(companyId)) {
                        user.setCompanyId(companyId);
                    }
                    String[] sArray = new String[1];
                    rfcName = "CRM_ISA_UA_IUSER_GET_DETAIL";
                    function = sapBasis.getRepository().getFunctionTemplate(rfcName).getFunction();
                    JCO.ParameterList importParameter = function.getImportParameterList();
                    importParameter.setValue(uid, "IUSERNAME");
                    importParameter.setValue("X", "WITH_ROLES");
                    client.execute(function);
                    JCO.ParameterList exportParameter = function.getExportParameterList();
                    JCO.Structure iuser_data = exportParameter.getStructure("IUSER_DATA");
                    if (iuser_data.getString("LASTNAME") != null) {
                        user.setLastName(iuser_data.getString("LASTNAME"));
                    }
                    if (iuser_data.getString("FIRSTNAME") != null) {
                        user.setFirstName(iuser_data.getString("FIRSTNAME"));
                    }
                    if (iuser_data.getString("CITY") != null) {
                        user.setCity(iuser_data.getString("CITY"));
                    }
                    if (iuser_data.getString("COUNTRYISO") != null) {
                        user.setCountry(iuser_data.getString("COUNTRYISO"));
                    }
                    if (iuser_data.getString("REGION") != null) {
                        user.setState(iuser_data.getString("REGION"));
                    }
                    if (iuser_data.getString("STREET") != null) {
                        user.setStreet(iuser_data.getString("STREET"));
                    }
                    if (iuser_data.getString("E_MAIL") != null) {
                        user.setEmail(iuser_data.getString("E_MAIL"));
                    }
                    if (iuser_data.getString("TITLE_ACA1") != null) {
                        sArray[0] = iuser_data.getString("TITLE_ACA1");
                        user.setAttribute("UM", "AcademicTitle", sArray);
                    }
                    if (iuser_data.getString("TITLE_KEY") != null) {
                        user.setTitle(iuser_data.getString("TITLE_KEY"));
                    }
                    if (iuser_data.getString("BUILDING") != null) {
                        sArray[0] = iuser_data.getString("BUILDING");
                        user.setAttribute("UM", "BUILDING", sArray);
                    }
                    if (iuser_data.getString("FLOOR") != null) {
                        sArray[0] = iuser_data.getString("FLOOR");
                        user.setAttribute("UM", "FLOOR", sArray);
                    }
                    if (iuser_data.getString("ROOM_NO") != null) {
                        sArray[0] = iuser_data.getString("ROOM_NO");
                        user.setAttribute("UM", "ROOM", sArray);
                    }
                    if (iuser_data.getString("TEL_NO") != null) {
                        user.setTelephone(iuser_data.getString("TEL_NO"));
                    }
                    if (iuser_data.getString("FAX_NO") != null) {
                        user.setFax(iuser_data.getString("FAX_NO"));
                    }
                    if (iuser_data.getString("POSTL_COD1") != null) {
                        user.setZip(iuser_data.getString("POSTL_COD1"));
                    }
                    if (iuser_data.getString("TIME_ZONE") != null) {
                        user.setTimeZone(TimeZone.getTimeZone(iuser_data.getString("TIME_ZONE")));
                    }
                    if ((lang = iuser_data.getString("LANGUISO")) != null && lang.length() > 0) {
                        Locale[] locales = Locale.getAvailableLocales();
                        String country = null;
                        i = 0;
                        while (i < locales.length) {
                            if (locales[i].getLanguage().equalsIgnoreCase(lang)) {
                                country = locales[i].getCountry();
                                break;
                            }
                            ++i;
                        }
                        user.setLocale(new Locale(lang, country));
                    }
                    if (user.getCurrency() == null) {
                        user.setCurrency("USD");
                    }
                    Vector<String> vRoles = new Vector<String>();
                    JCO.Table tRoles = function.getTableParameterList().getTable("IUSER_ROLES");
                    i = 0;
                    while (true) {
                        if (i >= tRoles.getNumRows()) {
                            if (vRoles.isEmpty()) break;
                            String[] roles = vRoles.toArray(new String[1]);
                            try {
                                user.setAttribute("UM_READONLY", "EXTERNAL_ROLES", roles);
                            }
                            catch (FeatureNotAvailableException ex) {
                                if (!trace.beDebug()) break;
                                trace.debugT(methodname, ex);
                            }
                            break;
                        }
                        tRoles.setRow(i);
                        String role = tRoles.getString("AGR_NAME");
                        vRoles.add(role);
                        ++i;
                    }
                    Object var21_22 = null;
                }
                catch (JCO.AbapException ae) {
                    trace.debugT(methodname, "AbapException: " + rfcName + "(" + uid + ")" + "-" + ae.getMessage(), ae);
                    Object var21_23 = null;
                    sapBasis.releaseClient(client);
                    break block31;
                }
                catch (Exception e) {
                    trace.errorT(methodname, "Exception: " + rfcName + "(" + uid + ")" + "-" + e.getMessage(), e);
                    Object var21_24 = null;
                    sapBasis.releaseClient(client);
                    break block31;
                }
            }
            catch (Throwable throwable) {
                Object var21_25 = null;
                sapBasis.releaseClient(client);
                throw throwable;
            }
            sapBasis.releaseClient(client);
        }
        trace.exiting(methodname);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getCRMInfo(String nameSpace, IInternalPrincipalDatabag principal) {
        String methodname;
        block25: {
            methodname = "getCRMInfo";
            trace.entering(methodname);
            String rfcName = null;
            JCO.Client client = null;
            String uid = principal.getUniqueID().toUpperCase();
            uid = uid.substring(uid.lastIndexOf(".") + 1);
            trace.debugT(methodname, "Get CRM user data: " + uid);
            SAPBasis sapBasis = this.getSAPBasis();
            String companyId = null;
            try {
                try {
                    String lang;
                    trace.debugT(methodname, "Get JCO client on: " + sapBasis.getSystemID());
                    client = sapBasis.getClient();
                    JCO.Function function = null;
                    String displayId = this.getDisplayId(uid);
                    this.addPrincipalValue(nameSpace, "displayname", displayId, principal);
                    rfcName = "CRM_ICSS_BPARTNER_FROM_USER";
                    function = sapBasis.getRepository().getFunctionTemplate(rfcName).getFunction();
                    function.getImportParameterList().setValue(uid, "USERID");
                    client.execute(function);
                    companyId = function.getExportParameterList().getString("BPARTNER");
                    if (this.hasValue(companyId)) {
                        this.addPrincipalValue(nameSpace, "company", companyId, principal);
                        this.addPrincipalValue(nameSpace, "companyid", companyId, principal);
                    }
                    rfcName = "CRM_ISA_UA_IUSER_GET_DETAIL";
                    function = sapBasis.getRepository().getFunctionTemplate(rfcName).getFunction();
                    JCO.ParameterList importParameter = function.getImportParameterList();
                    importParameter.setValue(uid, "IUSERNAME");
                    importParameter.setValue("X", "WITH_ROLES");
                    client.execute(function);
                    JCO.ParameterList exportParameter = function.getExportParameterList();
                    JCO.Structure iuser_data = exportParameter.getStructure("IUSER_DATA");
                    if (iuser_data.getString("LASTNAME") != null) {
                        this.addPrincipalValue(nameSpace, "lastname", iuser_data.getString("LASTNAME"), principal);
                    }
                    if (iuser_data.getString("FIRSTNAME") != null) {
                        this.addPrincipalValue(nameSpace, "firstname", iuser_data.getString("FIRSTNAME"), principal);
                    }
                    if (iuser_data.getString("CITY") != null) {
                        this.addPrincipalValue(nameSpace, "city", iuser_data.getString("CITY"), principal);
                    }
                    if (iuser_data.getString("COUNTRYISO") != null) {
                        this.addPrincipalValue(nameSpace, "country", iuser_data.getString("COUNTRYISO"), principal);
                    }
                    if (iuser_data.getString("REGION") != null) {
                        this.addPrincipalValue(nameSpace, "state", iuser_data.getString("REGION"), principal);
                    }
                    if (iuser_data.getString("STREET") != null) {
                        this.addPrincipalValue(nameSpace, "streetaddress", iuser_data.getString("STREET"), principal);
                    }
                    if (iuser_data.getString("E_MAIL") != null) {
                        this.addPrincipalValue(nameSpace, "email", iuser_data.getString("E_MAIL"), principal);
                    }
                    if (iuser_data.getString("TITLE_ACA1") != null) {
                        this.addPrincipalValue(nameSpace, "AcademicTitle", iuser_data.getString("TITLE_ACA1"), principal);
                    }
                    if (iuser_data.getString("TITLE_KEY") != null) {
                        this.addPrincipalValue(nameSpace, "title", iuser_data.getString("TITLE_KEY"), principal);
                    }
                    if (iuser_data.getString("BUILDING") != null) {
                        this.addPrincipalValue(nameSpace, "BUILDING", iuser_data.getString("BUILDING"), principal);
                    }
                    if (iuser_data.getString("FLOOR") != null) {
                        this.addPrincipalValue(nameSpace, "FLOOR", iuser_data.getString("FLOOR"), principal);
                    }
                    if (iuser_data.getString("ROOM_NO") != null) {
                        this.addPrincipalValue(nameSpace, "ROOM", iuser_data.getString("ROOM_NO"), principal);
                    }
                    if (iuser_data.getString("TEL_NO") != null) {
                        this.addPrincipalValue(nameSpace, "telephone", iuser_data.getString("TEL_NO"), principal);
                    }
                    if (iuser_data.getString("FAX_NO") != null) {
                        this.addPrincipalValue(nameSpace, "fax", iuser_data.getString("FAX_NO"), principal);
                    }
                    if (iuser_data.getString("POSTL_COD1") != null) {
                        this.addPrincipalValue(nameSpace, "zip", iuser_data.getString("POSTL_COD1"), principal);
                    }
                    if (iuser_data.getString("TIME_ZONE") != null) {
                        this.addPrincipalValue(nameSpace, "timezone", iuser_data.getString("TIME_ZONE"), principal);
                    }
                    if ((lang = iuser_data.getString("LANGUISO")) != null && lang.length() > 0) {
                        this.addPrincipalValue(nameSpace, "locale", iuser_data.getString("LANGUISO"), principal);
                    }
                    if (principal.getAttributeValues(nameSpace, "currency") == null) {
                        this.addPrincipalValue(nameSpace, "currency", "USD", principal);
                    }
                    Vector<String> vRoles = new Vector<String>();
                    JCO.Table tRoles = function.getTableParameterList().getTable("IUSER_ROLES");
                    int i = 0;
                    while (i < tRoles.getNumRows()) {
                        tRoles.setRow(i);
                        String role = tRoles.getString("AGR_NAME");
                        vRoles.add(role);
                        ++i;
                    }
                }
                catch (JCO.AbapException ae) {
                    trace.debugT(methodname, "AbapException: " + rfcName + "(" + uid + ")" + "-" + ae.getMessage(), ae);
                    Object var20_22 = null;
                    sapBasis.releaseClient(client);
                    break block25;
                }
                catch (Exception e) {
                    trace.errorT(methodname, "Exception: " + rfcName + "(" + uid + ")" + "-" + e.getMessage(), e);
                    Object var20_23 = null;
                    sapBasis.releaseClient(client);
                    break block25;
                }
                Object var20_21 = null;
            }
            catch (Throwable throwable) {
                Object var20_24 = null;
                sapBasis.releaseClient(client);
                throw throwable;
            }
            sapBasis.releaseClient(client);
        }
        trace.exiting(methodname);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getDisplayId(String uid) {
        String displayId;
        String methodname;
        block7: {
            methodname = "getDisplayId";
            displayId = uid;
            JCO.Client client = null;
            if (SAPUserIdMapping.isSAPSystem("CRM")) {
                String rfcName = null;
                SAPBasis sapBasis = this.getSAPBasis();
                try {
                    try {
                        trace.debugT(methodname, "Get JCO client on: " + sapBasis.getSystemID());
                        client = sapBasis.getClient();
                        rfcName = "CRM_ISA_SEARCH_IUSERS";
                        JCO.Function function = sapBasis.getRepository().getFunctionTemplate(rfcName).getFunction();
                        JCO.Structure iuser_search = function.getImportParameterList().getStructure("IUSER_SEARCH");
                        iuser_search.setValue(uid, "USERNAME");
                        client.execute(function);
                        JCO.Table userList = function.getTableParameterList().getTable("USERLIST");
                        int i = 0;
                        while (i < userList.getNumRows()) {
                            userList.setRow(i);
                            displayId = userList.getString("USERALIAS");
                            ++i;
                        }
                    }
                    catch (JCO.AbapException ae) {
                        trace.debugT(methodname, "AbapException: " + rfcName + "(" + uid + ")" + "-" + ae.getMessage(), ae);
                        Object var12_14 = null;
                        sapBasis.releaseClient(client);
                        break block7;
                    }
                    catch (Exception e) {
                        trace.errorT(methodname, "Exception: " + rfcName + "(" + uid + ")" + "-" + e.getMessage(), e);
                        Object var12_15 = null;
                        sapBasis.releaseClient(client);
                        break block7;
                    }
                    Object var12_13 = null;
                }
                catch (Throwable throwable) {
                    Object var12_16 = null;
                    sapBasis.releaseClient(client);
                    throw throwable;
                }
                sapBasis.releaseClient(client);
            }
        }
        trace.debugT(methodname, "UserId: " + displayId + "==" + uid);
        return displayId;
    }

    private boolean hasValue(String val) {
        return val != null && !val.equals("");
    }

    public void deactivatePassword(String uid) throws Exception {
        String methodname = "deactivatePassword";
        trace.entering(methodname, new Object[]{uid});
        String rfcName = "BAPI_USER_CHANGE";
        JCO.Client client = null;
        SAPBasis sapBasis = this.getSAPBasis();
        try {
            try {
                trace.debugT(methodname, "Get JCO client on: " + sapBasis.getSystemID());
                client = sapBasis.getClient();
                JCO.Function function = sapBasis.getRepository().getFunctionTemplate(rfcName).getFunction();
                JCO.ParameterList inputparm = function.getImportParameterList();
                inputparm.setValue(uid, "USERNAME");
                JCO.Structure logondata = inputparm.getStructure("LOGONDATA");
                logondata.setValue("X", "CODVN");
                JCO.Structure logondatax = inputparm.getStructure("LOGONDATAX");
                logondatax.setValue("X", "BCODE");
                logondatax.setValue("X", "CODVN");
                client.execute(function);
                trace.debugT(methodname, "Deactivated password for user: " + uid);
            }
            catch (JCO.AbapException e) {
                trace.errorT(methodname, e.getMessage(), new Object[]{e});
                throw new Exception(e.getMessage());
            }
            catch (Exception e) {
                trace.errorT(methodname, e.getMessage(), new Object[]{e});
                throw new Exception(e.getMessage());
            }
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            sapBasis.releaseClient(client);
            throw throwable;
        }
        sapBasis.releaseClient(client);
        trace.exiting(methodname);
    }

    private void addPrincipalValue(String nameSpace, String name, Object value, IInternalPrincipalDatabag principal) throws Exception {
        String method = "addPrincipalValue";
        trace.entering("addPrincipalValue", new Object[]{nameSpace, name, principal});
        String sValue = null;
        principal.deleteAttributeValues(nameSpace, name);
        if (value instanceof String) {
            sValue = (String)value;
            principal.addAttributeValue(nameSpace, name, sValue);
        } else if (value instanceof Vector) {
            Vector vValue = (Vector)value;
            int i = 0;
            while (i < vValue.size()) {
                sValue = (String)vValue.get(i);
                principal.addAttributeValue(nameSpace, name, sValue);
                ++i;
            }
        } else {
            principal.addAttributeValue(nameSpace, name, value);
        }
        Vector<String> allNames = principal.getAttributeValues("ALL", "NAMES");
        if (allNames == null) {
            allNames = new Vector<String>();
        }
        allNames.add(nameSpace + "." + name);
        principal.setAttributeValues("ALL", "NAMES", allNames);
        trace.exiting("addPrincipalValue");
    }

    public IRepository getRepository() {
        return this._repository;
    }

    public JCO.PoolManager getPoolManager() {
        return this._poolManager;
    }

    public String getPoolId() {
        return this._poolId;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

