/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp.r3;

import com.sap.security.Security;
import com.sap.security.api.UMFactory;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.datasource.imp.r3.UmR3UserFactory;
import com.sap.security.core.persistence.replication.imp.adapters.r3.UmR3Properties;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.usermanagement.UMRuntimeException;
import com.sap.security.util.SAPBasis;
import java.util.Properties;

public class R3ConnectionSAP {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/r3/R3ConnectionSAP.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";
    private static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/r3/R3ConnectionSAP.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)");
    private static final IUMParameters mySAPProperties = UMFactory.getProperties();
    public static String securityKey = "SAPAG_UM";

    public static UmR3UserFactory getR3Factory(String r3name) {
        String methodname = "getR3Factory";
        trace.entering(methodname, new Object[]{r3name});
        if (r3name == null) {
            trace.debugT(methodname, "AdapterID not provided");
            trace.exiting(methodname);
            return null;
        }
        String key = securityKey + "_" + r3name;
        UmR3UserFactory m_factory = null;
        try {
            m_factory = (UmR3UserFactory)Security.getUserFactory((String)key);
            if (m_factory == null) {
                Properties pOptions = new Properties();
                UmR3Properties r3Prop = new UmR3Properties(r3name);
                r3Prop.setPassword(r3Prop.getPasswd());
                SAPBasis sapBasis = new SAPBasis(r3Prop.getSAPProperties());
                trace.debugT(methodname, "Get R3UserFactory");
                m_factory = new UmR3UserFactory(sapBasis, pOptions, key);
                trace.debugT(methodname, "R3UserFactory initialized: " + key);
            } else {
                trace.debugT(methodname, "Use existing R3UserFactory: " + key);
            }
        }
        catch (Exception e) {
            throw new UMRuntimeException((Throwable)e, e.getMessage());
        }
        trace.exiting(methodname);
        return m_factory;
    }

    public static boolean isMaster(String r3Name) {
        String sysName;
        boolean isMasterStorage = false;
        String umMaster = mySAPProperties.get("UM_MASTER_STORAGE");
        int i = (umMaster = umMaster.toUpperCase()).indexOf("ADAPTERID");
        if (i < 0) {
            i = umMaster.indexOf("SYSID");
        }
        if (i > 0 && r3Name.equalsIgnoreCase(sysName = umMaster.substring((i = umMaster.indexOf("=", i)) + 1).trim())) {
            isMasterStorage = true;
        }
        return isMasterStorage;
    }
}

