/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp.r3;

import com.sap.mw.jco.IFunctionTemplate;
import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.JCO;
import com.sap.security.api.UMFactory;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.replication.imp.adapters.r3.UmR3Connect;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.usermanagement.UMException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class EBPOrgUnitsR3 {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/r3/EBPOrgUnitsR3.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";
    private static IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/r3/EBPOrgUnitsR3.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)");
    public static final String UM_ORGUNIT_ADAPTERID = "ume.r3.orgunit.adapterid";
    private String r3_id = null;
    private Map mOrgs = null;
    private String[] orgids = null;
    private IRepository repository = null;

    public EBPOrgUnitsR3(String r3id) {
        this.r3_id = r3id;
    }

    public EBPOrgUnitsR3() {
        this(UMFactory.getProperties().get(UM_ORGUNIT_ADAPTERID));
    }

    public String getOrgUnitName(String id) {
        return (String)this.mOrgs.get(id);
    }

    public int searchOrgUnits(String name, String companyId, int max_row) {
        String methodname = "searchOrgUnits";
        trace.entering(methodname);
        this.mOrgs = new HashMap();
        try {
            if (this.r3_id == null) {
                trace.debugT(methodname, "*** Error: R3 id has not been set..search aborted ***");
            } else {
                trace.infoT(methodname, "Search key=" + name + "   companyId=" + companyId);
                this.mOrgs = this.Bbp_Org_Search(name, companyId, max_row);
                Set keyOrgIds = this.mOrgs.keySet();
                String[] a = new String[1];
                this.orgids = keyOrgIds.toArray(a);
            }
        }
        catch (Exception ex) {
            trace.errorT(methodname, ex.getMessage(), ex);
        }
        trace.exiting(methodname);
        return this.mOrgs.size();
    }

    public boolean orgUnitValid(String companyId, String orgUnitId) {
        String methodname = "orgUnitValid";
        trace.entering(methodname, new Object[]{companyId, orgUnitId});
        boolean valid = false;
        if (this.r3_id == null) {
            trace.debugT(methodname, "*** Error: R3 id has not been set..search aborted ***");
        } else {
            trace.debugT(methodname, "companyId=" + companyId + "\torgUnitId=" + orgUnitId);
            valid = this.Bbp_Om_Company_Check_Assignment(companyId, orgUnitId);
            trace.debugT(methodname, "orgUnit valid=" + valid);
        }
        trace.exiting(methodname);
        return valid;
    }

    public Map getOrgUnits() {
        return this.mOrgs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean Bbp_Om_Company_Check_Assignment(String companyId, String orgunitId) {
        boolean valid;
        String methodname;
        block11: {
            JCO.Client client;
            block10: {
                boolean bl;
                block9: {
                    methodname = "Bbp_Om_Company_Check_Assignment";
                    trace.entering(methodname, new Object[]{companyId, orgunitId});
                    String RFCName = "BBP_OM_COMPANY_CHECK_ASSIGNMNT";
                    valid = false;
                    client = null;
                    try {
                        try {
                            client = this.getClient();
                            if (null == client) {
                                bl = false;
                                Object var15_9 = null;
                                if (client == null) return bl;
                                break block9;
                            }
                            IFunctionTemplate ftemplate = this.repository.getFunctionTemplate(RFCName);
                            JCO.Function function = new JCO.Function(ftemplate);
                            JCO.ParameterList parm = function.getImportParameterList();
                            JCO.Structure struct1 = parm.getStructure("IV_OBJECT_1");
                            JCO.Structure struct2 = parm.getStructure("IV_OBJECT_2");
                            struct1.setValue("O", "OTYPE");
                            struct1.setValue(companyId, "OBJID");
                            struct2.setValue("O", "OTYPE");
                            struct2.setValue(orgunitId, "OBJID");
                            trace.debugT(methodname, "companyId=" + companyId + "\torgUnitId=" + orgunitId);
                            client.execute(function);
                            String companyEqual = function.getExportParameterList().getString("COMPANY_EQUAL");
                            trace.debugT(methodname, "COMPANY_EQUAL=" + companyEqual);
                            if (companyEqual.equals("X")) {
                                valid = true;
                            }
                            break block10;
                        }
                        catch (Exception ex) {
                            trace.errorT(methodname, ex.getMessage(), new Object[]{ex});
                            Object var15_11 = null;
                            if (client != null) {
                                UmR3Connect.disconnectR3(this.r3_id, client);
                            }
                            break block11;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var15_12 = null;
                        if (client != null) {
                            UmR3Connect.disconnectR3(this.r3_id, client);
                        }
                        throw throwable;
                    }
                }
                UmR3Connect.disconnectR3(this.r3_id, client);
                return bl;
            }
            Object var15_10 = null;
            if (client != null) {
                UmR3Connect.disconnectR3(this.r3_id, client);
            }
        }
        trace.exiting(methodname);
        return valid;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map Bbp_Org_Search(String searchName, String companyId, int max_row) throws Exception, UMException {
        HashMap<String, String> mOrgunits;
        String methodname;
        block15: {
            JCO.Client client;
            block14: {
                HashMap<String, String> hashMap;
                block13: {
                    methodname = "Bbp_Org_Search";
                    trace.entering(methodname, new Object[]{searchName});
                    String RFCName = "BBP_ORG_SEARCH";
                    mOrgunits = new HashMap<String, String>();
                    client = null;
                    try {
                        try {
                            client = this.getClient();
                            if (null == client) {
                                hashMap = mOrgunits;
                                Object var16_10 = null;
                                if (client == null) return hashMap;
                                break block13;
                            }
                            IFunctionTemplate ftemplate = this.repository.getFunctionTemplate(RFCName);
                            JCO.Function function = new JCO.Function(ftemplate);
                            if (searchName != null) {
                                function.getImportParameterList().setValue(searchName, "SEARK");
                            }
                            if (companyId != null) {
                                function.getImportParameterList().setValue(companyId, "COMPANY_ID");
                            }
                            if (max_row != 0) {
                                function.getImportParameterList().setValue(max_row, "MAX_NUM");
                            }
                            client.execute(function);
                            JCO.Table tSelObjects = function.getTableParameterList().getTable("SEL_OBJECTS");
                            int i = 0;
                            while (true) {
                                if (i >= tSelObjects.getNumRows()) {
                                    trace.debugT(methodname, "Number OrgId retrieved=" + tSelObjects.getNumRows());
                                    break block14;
                                }
                                tSelObjects.setRow(i);
                                String objId = tSelObjects.getString("OBJID");
                                String sText = tSelObjects.getString("STEXT");
                                mOrgunits.put(objId, sText);
                                ++i;
                            }
                        }
                        catch (Exception ex) {
                            trace.errorT(methodname, ex.getMessage(), new Object[]{ex});
                            Object var16_12 = null;
                            if (client != null) {
                                UmR3Connect.disconnectR3(this.r3_id, client);
                            }
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var16_13 = null;
                        if (client != null) {
                            UmR3Connect.disconnectR3(this.r3_id, client);
                        }
                        throw throwable;
                    }
                }
                UmR3Connect.disconnectR3(this.r3_id, client);
                return hashMap;
            }
            Object var16_11 = null;
            if (client != null) {
                UmR3Connect.disconnectR3(this.r3_id, client);
            }
        }
        trace.exiting(methodname);
        return mOrgunits;
    }

    private JCO.Client getClient() {
        JCO.Client client = null;
        try {
            client = UmR3Connect.connectR3(this.r3_id);
            this.repository = new JCO.Repository("R3Repository", client);
        }
        catch (Exception ex) {
            trace.errorT("getClient", "R/3 Create repository failed", ex);
            if (client != null) {
                UmR3Connect.disconnectR3(this.r3_id, client);
            }
            return null;
        }
        return client;
    }
}

