/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.ISearchAttribute;
import com.sap.security.api.UMFactory;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.IInternalPrincipalDatabag;
import com.sap.security.core.persistence.IInternalPrincipalDatabagMaint;
import com.sap.security.core.persistence.IPrincipalDatabag;
import com.sap.security.core.persistence.datasource.IDataSource;
import com.sap.security.core.persistence.datasource.IDataSourceTransaction;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.datasource.imp.DSConfigurationModel;
import com.sap.security.core.persistence.datasource.imp.DSPrincipalModel;
import com.sap.security.core.persistence.datasource.imp.DataSourceBaseImplementation;
import com.sap.security.core.persistence.datasource.imp.TextFileDataSourceTransaction;
import com.sap.security.core.persistence.imp.PrincipalDatabag;
import com.sap.security.core.persistence.imp.SearchCriteria;
import com.sap.security.core.util.Base64;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.cache.ICache;
import com.sap.security.core.util.imp.PasswordHash;
import com.sap.security.core.util.imp.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class TextFilePersistence
extends DataSourceBaseImplementation
implements IDataSource {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/TextFilePersistence.java#2 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)";
    public static final String DEFAULT_TEXTFILE_CACHING_TIME = "ume.cache.datasource.textfile.default_caching_time";
    public static final String INITIAL_TEXTFILE_CACHE_SIZE = "ume.cache.datasource.textfile.initial_cache_size";
    public static final String ROOT_PATH = "ume.textfile.root_path";
    private static final String DATAFILE_EXTENSION = ".dat";
    private static final String PERSISTENCE_INLINE_SEPARATOR = "~";
    private static final String PERSISTENCE_MULITVALUE_SEPARATOR = "~";
    private static final String OBJECTNAME_SEPARATOR = "_";
    private static final String PERSISTENCE_DATA_TYPE_STRING = "STRING";
    private static final String PERSISTENCE_DATA_TYPE_BLOB = "BLOB";
    private Hashtable lockedObjects;
    private String datasourceRootPath;
    private ICache mCache;
    private boolean humanReadableStorage;
    private static IUMTrace mTrace;

    public TextFilePersistence() {
        mTrace = InternalUMFactory.getTrace(VERSIONSTRING);
        if (mTrace.bePath()) {
            mTrace.entering("constructor");
        }
        if (mTrace.bePath()) {
            mTrace.exiting("constructor");
        }
    }

    public boolean checkCredentials(Hashtable credentials) throws PersistenceException {
        boolean u_pwdLogon;
        X509Certificate cert;
        if (mTrace.bePath()) {
            mTrace.entering("checkCredentials", new Object[]{credentials});
        }
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        String[] dsToSearch = (String[])credentials.get("dataSourceIDs");
        if (dsToSearch != null) {
            boolean found = false;
            int k = 0;
            int s = dsToSearch.length;
            while (k < s && !found) {
                if (this.getId().equals(dsToSearch[k])) {
                    found = true;
                }
                ++k;
            }
            if (!found) {
                return false;
            }
        }
        boolean certLogon = (cert = (X509Certificate)credentials.get("javax.servlet.request.X509Certificate")) != null;
        String login = (String)credentials.get("j_user");
        String password = (String)credentials.get("j_password");
        boolean bl = u_pwdLogon = login != null;
        if (!(this.feelsResponsible("com.sap.security.core.usermanagement", "certificatehash") && this.feelsResponsible("com.sap.security.core.usermanagement", "javax.servlet.request.X509Certificate") || !certLogon)) {
            if (mTrace.bePath()) {
                mTrace.exiting("checkCredentials", new Boolean(false));
            }
            return false;
        }
        if (!(this.feelsResponsible("com.sap.security.core.usermanagement", "j_user") && this.feelsResponsible("com.sap.security.core.usermanagement", "j_password") || !u_pwdLogon)) {
            if (mTrace.bePath()) {
                mTrace.exiting("checkCredentials", new Boolean(false));
            }
            return false;
        }
        if (u_pwdLogon && password == null) {
            if (mTrace.bePath()) {
                mTrace.exiting("checkCredentials", new Boolean(false));
            }
            return false;
        }
        if (!u_pwdLogon && !certLogon) {
            if (mTrace.bePath()) {
                mTrace.exiting("checkCredentials", new Boolean(false));
            }
            return false;
        }
        SearchCriteria mySearchCriteria = null;
        if (u_pwdLogon) {
            mySearchCriteria = new SearchCriteria(false, "UACC");
            mySearchCriteria.addEqualsElement("com.sap.security.core.usermanagement", "j_user", login, false);
        }
        if (certLogon) {
            mySearchCriteria = new SearchCriteria(false, "UACC");
            try {
                mySearchCriteria.addEqualsElement("com.sap.security.core.usermanagement", "certificatehash", Base64.encode(Util.createMD5HashValue(cert.getEncoded())), true);
            }
            catch (CertificateEncodingException cee) {
                throw new PersistenceException(cee);
            }
        }
        File searchDir = new File(this.datasourceRootPath + File.separator + "UACC");
        Vector results = new Vector();
        boolean result = false;
        this.doSearch(searchDir, mySearchCriteria, results);
        if (results != null && results.size() > 0) {
            String accoutId = (String)results.firstElement();
            if (u_pwdLogon) {
                String passwordHash;
                PrincipalDatabag db = new PrincipalDatabag(accoutId);
                this.populatePrincipalDatabag(db, "com.sap.security.core.usermanagement", "j_password");
                Vector passwordHashs = db.getAttributeValues("com.sap.security.core.usermanagement", "j_password");
                if (passwordHashs != null && passwordHashs.size() > 0 && (passwordHash = (String)passwordHashs.firstElement()) != null) {
                    result = new PasswordHash(login, password).checkHash(passwordHash);
                }
            }
            if (certLogon) {
                result = true;
            }
        }
        if (mTrace.bePath()) {
            mTrace.exiting("checkCredentials", new Boolean(result));
        }
        return result;
    }

    public void init(DSConfigurationModel dsConf) throws PersistenceException {
        int initialSize;
        File principalDir;
        File rootPathFile;
        boolean fileOk;
        if (mTrace.bePath()) {
            mTrace.entering("init", new Object[]{dsConf});
        }
        super.init(dsConf);
        mTrace = InternalUMFactory.getTrace(VERSIONSTRING, this.mConfigurationModel.getDataSourceID());
        String rootPath = dsConf.getPrivateAttributeFileValue(ROOT_PATH);
        if (rootPath == null) {
            rootPath = UMFactory.getProperties().getFile(ROOT_PATH, ".");
        }
        try {
            this.humanReadableStorage = dsConf.getPrivateAttributeBooleanValue("humanReadableStorage");
        }
        catch (PersistenceException pex) {
            if (mTrace.beInfo()) {
                mTrace.infoT("init", "Private property humanReadableStorage not found, using default: true!", (Throwable)((Object)pex));
            }
            this.humanReadableStorage = true;
        }
        if (mTrace.beInfo()) {
            mTrace.infoT("init", "RootPath for TextFilePersistence is: " + rootPath);
        }
        boolean bl = fileOk = (rootPathFile = new File(rootPath)).exists() && rootPathFile.isDirectory();
        if (!fileOk) {
            rootPath = UMFactory.getProperties().getFile("this-file-doesnt-exist-use-default", rootPath);
            if (mTrace.beInfo()) {
                mTrace.infoT("init", "RootPath for TextFilePersistence is: " + rootPath);
            }
            boolean bl2 = fileOk = (rootPathFile = new File(rootPath)).exists() && rootPathFile.isDirectory();
        }
        if (fileOk) {
            try {
                this.datasourceRootPath = rootPathFile.getCanonicalPath();
            }
            catch (IOException ioex) {
                throw new PersistenceException(ioex);
            }
        } else {
            String errorMessage = "Given rootPath is not existing or is not a directory!";
            throw new PersistenceException(errorMessage);
        }
        Enumeration en = dsConf.getHomeFor().elements();
        while (en.hasMoreElements()) {
            principalDir = new File(this.datasourceRootPath + File.separator + ((DSPrincipalModel)en.nextElement()).getType());
            if (principalDir.exists()) continue;
            principalDir.mkdirs();
        }
        Enumeration en2 = dsConf.getAttributeMapping().elements();
        while (en2.hasMoreElements()) {
            principalDir = new File(this.datasourceRootPath + File.separator + ((DSPrincipalModel)en2.nextElement()).getType());
            if (principalDir.exists()) continue;
            principalDir.mkdirs();
        }
        Enumeration en3 = dsConf.getResponsibleFor().elements();
        while (en3.hasMoreElements()) {
            principalDir = new File(this.datasourceRootPath + File.separator + ((DSPrincipalModel)en3.nextElement()).getType());
            if (principalDir.exists()) continue;
            principalDir.mkdirs();
        }
        this.lockedObjects = new Hashtable();
        IUMParameters props = UMFactory.getProperties();
        int maxLifeTime = dsConf.getPrivateAttributeIntValue(DEFAULT_TEXTFILE_CACHING_TIME);
        if (maxLifeTime == -1) {
            maxLifeTime = props.getNumber(DEFAULT_TEXTFILE_CACHING_TIME, -1);
        }
        if ((initialSize = dsConf.getPrivateAttributeIntValue(INITIAL_TEXTFILE_CACHE_SIZE)) == -1) {
            initialSize = props.getNumber(INITIAL_TEXTFILE_CACHE_SIZE, 500);
        }
        this.mCache = InternalUMFactory.getCache(1, initialSize, maxLifeTime, this.getClass().getName() + "_mCache");
        this.isInitialized = true;
        if (mTrace.bePath()) {
            mTrace.exiting("init");
        }
    }

    public IInternalPrincipalDatabag[] initPrincipalDatabags(IInternalPrincipalDatabag[] principals) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("initPrincipalDatabags", new Object[]{principals});
        }
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        int size = principals.length;
        int i = 0;
        while (i < size) {
            if (principals[i] != null && this.isHomeForPrincipalDatabag(principals[i])) {
                this.populatePrincipalDatabag(principals[i], null);
            }
            ++i;
        }
        if (mTrace.bePath()) {
            mTrace.exiting("initPrincipalDatabags", principals);
        }
        return principals;
    }

    public void populatePrincipalDatabags(IInternalPrincipalDatabag[] principals, AttributeList populateAttributes) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("populatePrincipalDatabags", new Object[]{principals, populateAttributes});
        }
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        int size = principals.length;
        int i = 0;
        while (i < size) {
            if (principals[i] != null && this.isHomeForPrincipalDatabag(principals[i])) {
                this.populatePrincipalDatabag(principals[i], null);
            }
            ++i;
        }
        if (mTrace.bePath()) {
            mTrace.exiting("populatePrincipalDatabags", principals);
        }
    }

    public void populatePrincipalDatabag(IInternalPrincipalDatabag principal, AttributeList populateAttributes) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("populatePrincipalDatabag", new Object[]{principal, populateAttributes});
        }
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        if (!this.feelsResponsible(principal)) {
            if (mTrace.bePath()) {
                mTrace.exiting("populatePrincipalDatabag", principal);
            }
            return;
        }
        String dataFileName = this.calculateObjectFileName(principal.getUniqueID());
        Properties object = (Properties)this.mCache.get(dataFileName);
        if (object == null) {
            if (!this.principalDatabagExists(principal)) {
                if (this.isHomeForPrincipalDatabag(principal)) {
                    principal = null;
                }
                return;
            }
            object = new Properties();
            try {
                FileInputStream fis = new FileInputStream(dataFileName);
                object.load(fis);
                fis.close();
                this.mCache.put(dataFileName, object);
            }
            catch (FileNotFoundException fnfex) {
                String errorMessage = "Objectfile " + dataFileName + " not found: " + fnfex.getMessage();
                if (mTrace.beInfo()) {
                    mTrace.infoT("populatePrincipalDatabag", errorMessage, fnfex);
                }
                return;
            }
            catch (IOException ioex) {
                throw new PersistenceException(ioex);
            }
        }
        Enumeration en = ((Hashtable)object).keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = (String)((Hashtable)object).get(key);
            this.addValuesToPrincipalDatabag(key, value, principal);
        }
        if (mTrace.bePath()) {
            mTrace.exiting("populatePrincipalDatabag", principal);
        }
    }

    public boolean populatePrincipalDatabag(IInternalPrincipalDatabag principal, String nameSpace, String attribute) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("populatePrincipalDatabag", new Object[]{principal, nameSpace, attribute});
        }
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        if (!this.feelsResponsible(principal, nameSpace, attribute)) {
            if (mTrace.bePath()) {
                mTrace.exiting("populatePrincipalDatabag", new Boolean(false));
            }
            return false;
        }
        String id = principal.getUniqueID();
        String[] idParts = principal.getIDParts();
        String type = idParts[0];
        String dataFileName = this.calculateObjectFileName(id);
        Properties object = (Properties)this.mCache.get(dataFileName);
        if (object == null) {
            object = new Properties();
            try {
                FileInputStream fis = new FileInputStream(dataFileName);
                object.load(fis);
                fis.close();
                this.mCache.put(dataFileName, object);
            }
            catch (FileNotFoundException fnfex) {
                String errorMessage = "Objectfile " + dataFileName + " not found: " + fnfex.getMessage();
                if (mTrace.beInfo()) {
                    mTrace.infoT("populatePrincipalDatabag", errorMessage, fnfex);
                }
                return false;
            }
            catch (IOException ioex) {
                throw new PersistenceException(ioex);
            }
        }
        attribute = this.getPhysicalAttribute(type, nameSpace, attribute);
        String baseSearchKey = Util.encode(nameSpace, this.humanReadableStorage) + "~" + Util.encode(attribute, this.humanReadableStorage) + "~";
        String searchedKey_STRING = baseSearchKey + Util.encode(PERSISTENCE_DATA_TYPE_STRING, this.humanReadableStorage);
        String searchedKey_BLOB = baseSearchKey + Util.encode(PERSISTENCE_DATA_TYPE_BLOB, this.humanReadableStorage);
        String value_STRING = (String)((Hashtable)object).get(searchedKey_STRING);
        String value_BLOB = (String)((Hashtable)object).get(searchedKey_BLOB);
        boolean stringSet = false;
        boolean blobSet = false;
        if (value_STRING != null && !value_STRING.equalsIgnoreCase("")) {
            this.addValuesToPrincipalDatabag(searchedKey_STRING, value_STRING, principal);
            stringSet = true;
        }
        if (value_BLOB != null && !value_BLOB.equalsIgnoreCase("")) {
            this.addValuesToPrincipalDatabag(searchedKey_BLOB, value_BLOB, principal);
            blobSet = true;
        }
        if (!stringSet && !blobSet) {
            principal.setAttributeValues(nameSpace, attribute, new Vector());
        }
        if (mTrace.bePath()) {
            mTrace.exiting("populatePrincipalDatabag", new Boolean(true));
        }
        return true;
    }

    private void addValuesToPrincipalDatabag(String header, String values, IInternalPrincipalDatabag principal) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("addValuesToPrincipalDatabag", new Object[]{header, values, principal});
        }
        String id = principal.getUniqueID();
        String[] idparts = principal.getIDParts();
        String principalType = idparts[0];
        String[] decodedHeader = this.readPersistenceLineHeader(header);
        String[] encodedValues = this.splitValueString(values);
        String type = decodedHeader[2];
        int length = encodedValues.length;
        Vector<Object> data = new Vector<Object>();
        int i = 0;
        while (i < length) {
            if (type.equalsIgnoreCase(PERSISTENCE_DATA_TYPE_STRING)) {
                data.add(Util.decode(encodedValues[i], this.humanReadableStorage));
            } else if (type.equalsIgnoreCase(PERSISTENCE_DATA_TYPE_BLOB)) {
                data.add(Util.decodeToByteArray(encodedValues[i]));
            } else {
                String errorMessage = "Unsupported object type " + type;
                throw new PersistenceException(errorMessage);
            }
            ++i;
        }
        decodedHeader[1] = this.getLogicalAttribute(principalType, decodedHeader[0], decodedHeader[1]);
        Vector alreadySetValues = principal.getAttributeValues(decodedHeader[0], decodedHeader[1]);
        principal.setAttributeValues(decodedHeader[0], decodedHeader[1], this.buildUnion(new Vector[]{data, alreadySetValues}));
        if (mTrace.bePath()) {
            mTrace.exiting("addValuesToPrincipalDatabag");
        }
    }

    public IDataSourceTransaction beginTransaction() throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("beginTransaction");
        }
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        TextFileDataSourceTransaction newTFTransaction = new TextFileDataSourceTransaction(this);
        if (mTrace.bePath()) {
            mTrace.exiting("beginTransaction", newTFTransaction);
        }
        return newTFTransaction;
    }

    public boolean principalDatabagExists(IPrincipalDatabag principal) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("principalDatabagExists", new Object[]{principal});
        }
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        String principalID = principal.getUniqueID();
        if (this.isHomeForPrincipalDatabag((IInternalPrincipalDatabag)principal)) {
            String dataFileName = this.calculateObjectFileName(principalID);
            File objectFile = new File(dataFileName);
            boolean exists = objectFile.exists();
            if (mTrace.bePath()) {
                mTrace.exiting("principalDatabagExists", new Boolean(exists));
            }
            return exists;
        }
        if (mTrace.bePath()) {
            mTrace.exiting("principalDatabagExists", new Boolean(false));
        }
        return false;
    }

    protected String getPrivateIDPart(IPrincipalDatabag principal) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("getPrivateIDPart", new Object[]{principal});
        }
        String guid = Util.createGUID();
        if (mTrace.bePath()) {
            mTrace.exiting("getPrivateIDPart", guid);
        }
        return guid;
    }

    public Vector searchPrincipalDatabags(SearchCriteria criteria) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("searchPrincipalDatabags", new Object[]{criteria});
        }
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        int size = criteria.getElementSize();
        File searchDir = new File(this.datasourceRootPath);
        String type = criteria.getPrincipalType();
        boolean found = type != null;
        searchDir = new File(this.datasourceRootPath + File.separator + type);
        SearchCriteria dsCriteria = new SearchCriteria(criteria.isOrMode(), criteria.getPrincipalType());
        int i = 0;
        while (i < size) {
            boolean checkResult;
            ISearchAttribute se = criteria.getAttribute(i);
            String nameSpace = se.getAttributeNameSpace();
            String attribute = se.getAttributeName();
            if ((!nameSpace.equals("com.sap.security.core.usermanagement") || !attribute.equals("PRINCIPAL_TYPE_ATTRIBUTE") && !attribute.equals("oldpassword")) && (checkResult = found ? this.feelsResponsible(type, nameSpace, attribute) : this.feelsResponsible(nameSpace, attribute))) {
                int op = se.getOperator();
                Object value = se.getAttributeValue();
                boolean cs = se.isCaseSensitive();
                if (found) {
                    attribute = this.getPhysicalAttribute(type, nameSpace, attribute);
                }
                if (!(value instanceof X509Certificate)) {
                    switch (op) {
                        case 1: {
                            dsCriteria.addLikeElement(nameSpace, attribute, value, cs);
                            break;
                        }
                        case 0: {
                            dsCriteria.addEqualsElement(nameSpace, attribute, value, cs);
                            break;
                        }
                        case 2: {
                            dsCriteria.addGreaterThanElement(nameSpace, attribute, value, cs);
                            break;
                        }
                        case 3: {
                            dsCriteria.addLessThanElement(nameSpace, attribute, value, cs);
                        }
                    }
                }
            }
            ++i;
        }
        if (dsCriteria.getElementSize() == 1) {
            if (mTrace.beInfo()) {
                mTrace.infoT("searchPrincipalDatabags", "Not responsible for any search element.");
            }
            if (mTrace.bePath()) {
                mTrace.exiting("searchPrincipalDatabags", null);
            }
            return null;
        }
        if (!searchDir.exists()) {
            return new Vector();
        }
        if (!searchDir.isDirectory()) {
            String errorMessage = "Search directory " + searchDir + " has to be a directory!";
            throw new PersistenceException(errorMessage);
        }
        Vector searchResults = new Vector();
        this.doSearch(searchDir, dsCriteria, searchResults);
        if (mTrace.bePath()) {
            mTrace.exiting("searchPrincipalDatabags", searchResults);
        }
        return searchResults;
    }

    private void doSearch(File searchDir, SearchCriteria criteria, Vector searchResults) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("doSearch", new Object[]{searchDir, criteria, searchResults});
        }
        File[] filesInDir = searchDir.listFiles();
        int i = 0;
        while (i < filesInDir.length) {
            if (filesInDir[i].isDirectory()) {
                this.doSearch(filesInDir[i], criteria, searchResults);
            } else if (this.objectMatchesSearch(filesInDir[i].getPath(), criteria)) {
                searchResults.add(this.getUniqueIdFromObjectFile(filesInDir[i].getPath()));
            }
            ++i;
        }
        if (mTrace.bePath()) {
            mTrace.exiting("doSearch", searchResults);
        }
    }

    private boolean objectMatchesSearch(String objectFileName, SearchCriteria criteria) throws PersistenceException {
        ISearchAttribute se;
        if (mTrace.bePath()) {
            mTrace.entering("objectMatchesSearch", new Object[]{objectFileName, criteria});
        }
        String id = this.getUniqueIdFromObjectFile(objectFileName);
        String[] idParts = this.splitPrincipalDatabagID(id);
        String type = idParts[0];
        boolean orMode = criteria.isOrMode();
        Properties object = (Properties)this.mCache.get(objectFileName);
        if (object == null) {
            object = new Properties();
            try {
                FileInputStream fis = new FileInputStream(objectFileName);
                object.load(fis);
                fis.close();
                this.mCache.put(objectFileName, object);
            }
            catch (FileNotFoundException fnfex) {
                String errorMessage = "Objectfile " + objectFileName + " not found: " + fnfex.getMessage();
                if (mTrace.beInfo()) {
                    mTrace.infoT("objectMatchesSearch", errorMessage, fnfex);
                }
                return false;
            }
            catch (IOException ioex) {
                throw new PersistenceException(ioex);
            }
        }
        int size = criteria.getElementSize();
        if (orMode) {
            boolean found = false;
            int counter = 0;
            while (!found && counter < size) {
                se = criteria.getAttribute(counter);
                if (!se.getAttributeNameSpace().equals("com.sap.security.core.usermanagement") || !se.getAttributeName().equals("PRINCIPAL_TYPE_ATTRIBUTE") && !se.getAttributeName().equals("oldpassword")) {
                    if (se.getAttributeValue() != null) {
                        found = this.objectMatchesSearchElement(type, object, se);
                    } else {
                        SearchCriteria searchC = new SearchCriteria(criteria.getPrincipalType());
                        searchC.addLikeElement(se.getAttributeNameSpace(), se.getAttributeName(), "*", se.isCaseSensitive());
                        searchC.addEqualsElement(se.getAttributeNameSpace(), se.getAttributeName(), new byte[0], se.isCaseSensitive());
                        found = !this.objectMatchesSearchElement(type, object, searchC.getAttribute(0)) && !this.objectMatchesSearchElement(type, object, searchC.getAttribute(1));
                    }
                }
                ++counter;
            }
            if (mTrace.bePath()) {
                mTrace.exiting("objectMatchesSearch", new Boolean(found));
            }
            return found;
        }
        boolean allMatched = true;
        int counter = 0;
        while (allMatched && counter < size) {
            se = criteria.getAttribute(counter);
            if (!se.getAttributeNameSpace().equals("com.sap.security.core.usermanagement") || !se.getAttributeName().equals("PRINCIPAL_TYPE_ATTRIBUTE") && !se.getAttributeName().equals("oldpassword")) {
                if (se.getAttributeValue() != null) {
                    allMatched = allMatched && this.objectMatchesSearchElement(type, object, se);
                } else {
                    SearchCriteria searchC = new SearchCriteria(criteria.getPrincipalType());
                    searchC.addLikeElement(se.getAttributeNameSpace(), se.getAttributeName(), "*", se.isCaseSensitive());
                    searchC.addEqualsElement(se.getAttributeNameSpace(), se.getAttributeName(), new byte[0], se.isCaseSensitive());
                    allMatched = allMatched && !this.objectMatchesSearchElement(type, object, searchC.getAttribute(0)) && !this.objectMatchesSearchElement(type, object, searchC.getAttribute(1));
                }
            } else if (criteria.getElementSize() == 1) {
                return false;
            }
            ++counter;
        }
        if (mTrace.bePath()) {
            mTrace.exiting("objectMatchesSearch", new Boolean(allMatched));
        }
        return allMatched;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private boolean objectMatchesSearchElement(String type, Properties p, ISearchAttribute se) throws PersistenceException {
        block22: {
            if (TextFilePersistence.mTrace.bePath()) {
                TextFilePersistence.mTrace.entering("objectMatchesSearchElement", new Object[]{type, p, se});
            }
            o = se.getAttributeValue();
            caseSensitive = se.isCaseSensitive();
            header = this.createPersistenceLineHeader(se.getAttributeNameSpace(), this.getPhysicalAttribute(type, se.getAttributeNameSpace(), se.getAttributeName()), o);
            values = (String)p.get(header);
            if (values == null) break block22;
            splitValues = this.splitValueString(values);
            found = false;
            size = splitValues.length;
            counter = 0;
            if (true) ** GOTO lbl84
        }
        if (TextFilePersistence.mTrace.bePath()) {
            TextFilePersistence.mTrace.exiting("objectMatchesSearchElement", new Boolean(false));
        }
        return false;
        do {
            block24: {
                block23: {
                    if (!(o instanceof String)) break block23;
                    value = Util.decode(splitValues[counter], this.humanReadableStorage);
                    block0 : switch (se.getOperator()) {
                        case 0: {
                            if (caseSensitive) {
                                found = value.equals((String)o);
                                break;
                            }
                            found = value.equalsIgnoreCase((String)o);
                            break;
                        }
                        case 1: {
                            if (o.equals("*")) {
                                found = true;
                                break;
                            }
                            strt = caseSensitive != false ? new StringTokenizer((String)o, "*", false) : new StringTokenizer(((String)o).toUpperCase(), "*", false);
                            startsWith = ((String)o).startsWith("*") == false;
                            endsWith = ((String)o).endsWith("*") == false;
                            lastIndex = -1;
                            found = true;
                            isFirstElement = true;
                            while (strt.hasMoreTokens()) {
                                if (!found) break block0;
                                currentToken = strt.nextToken();
                                currentIndex = caseSensitive != false ? value.indexOf(currentToken) : value.toUpperCase().indexOf(currentToken);
                                found = isFirstElement && startsWith ? (caseSensitive ? value.startsWith(currentToken) : value.toUpperCase().startsWith(currentToken)) : (!strt.hasMoreTokens() && endsWith ? (caseSensitive ? value.endsWith(currentToken) : value.toUpperCase().endsWith(currentToken)) : currentIndex > lastIndex);
                                lastIndex = currentIndex;
                                isFirstElement = false;
                            }
                            break block24;
                        }
                        case 2: {
                            if (caseSensitive) {
                                found = value.compareTo((String)o) > 0;
                                break;
                            }
                            found = value.toLowerCase().compareTo(((String)o).toLowerCase()) > 0;
                            break;
                        }
                        case 3: {
                            if (caseSensitive) {
                                found = value.compareTo((String)o) < 0;
                                break;
                            }
                            found = value.toLowerCase().compareTo(((String)o).toLowerCase()) < 0;
                            break;
                        }
                        default: {
                            errorMessage = "Unsupported search element operator found!";
                            throw new PersistenceException(errorMessage);
                        }
                    }
                    break block24;
                }
                if (!(o instanceof byte[])) {
                    errorMessage = "Unsupported object type: " + o.getClass();
                    throw new PersistenceException(errorMessage);
                }
                blob = Util.decodeToByteArray(splitValues[counter]);
                switch (se.getOperator()) {
                    case 0: {
                        found = blob.equals((byte[])o);
                        ** break;
                    }
                    case 1: {
                        errorMessage = "Unsupported search element operator found: like cannot be used for blobs!";
                        throw new PersistenceException(errorMessage);
                    }
                    case 2: {
                        errorMessage = "Unsupported search element operator found: greater than cannot be used for blobs!";
                        throw new PersistenceException(errorMessage);
                    }
                    case 3: {
                        errorMessage = "Unsupported search element operator found: less than cannot be used for blobs!";
                        throw new PersistenceException(errorMessage);
                    }
                }
                errorMessage = "Unsupported search element operator found!";
                throw new PersistenceException(errorMessage);
            }
            ++counter;
lbl84:
            // 2 sources

        } while (!found && counter < size);
        if (TextFilePersistence.mTrace.bePath()) {
            TextFilePersistence.mTrace.exiting("objectMatchesSearchElement", new Boolean(found));
        }
        return found;
    }

    private String getUniqueIdFromObjectFile(String objectFileName) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("getUniqueIdFromObjectFile", new Object[]{objectFileName});
        }
        if (objectFileName != null) {
            if (objectFileName.endsWith(DATAFILE_EXTENSION)) {
                String shortObjectFileName = objectFileName.substring(objectFileName.lastIndexOf(File.separator) + 1);
                int sepIndex = shortObjectFileName.indexOf(OBJECTNAME_SEPARATOR);
                String objectID = shortObjectFileName.substring(0, sepIndex);
                String dataSourceID = shortObjectFileName.substring(sepIndex + 1, shortObjectFileName.length() - DATAFILE_EXTENSION.length());
                String principalType = objectFileName.substring(this.datasourceRootPath.length() + 1, objectFileName.lastIndexOf(File.separator));
                objectID = Util.decode(objectID, false);
                String id = principalType + "." + dataSourceID + "." + objectID;
                if (mTrace.bePath()) {
                    mTrace.exiting("getUniqueIdFromObjectFile", id);
                }
                return id;
            }
            String errorMessage = "Unknown ojectfile extension of objectfile " + objectFileName;
            throw new PersistenceException(errorMessage);
        }
        String errorMessage = "Cannot create unique id because object file name is null!";
        throw new PersistenceException(errorMessage);
    }

    public void deletePrincipalDatabag(IPrincipalDatabag principal) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("deletePrincipalDatabag", new Object[]{principal});
        }
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        if (this.isReadonly()) {
            if (mTrace.beInfo()) {
                mTrace.infoT("deletePrincipalDatabag", "This datasource is readonly... do not try to delete principal databag.");
            }
            if (mTrace.bePath()) {
                mTrace.exiting("deletePrincipalDatabag");
            }
            return;
        }
        String principalID = principal.getUniqueID();
        if (this.feelsResponsible(principal)) {
            String dataFileName = this.calculateObjectFileName(principalID);
            this.lockObject(dataFileName);
            File objectFile = new File(dataFileName);
            if (objectFile.exists()) {
                objectFile.delete();
                this.mCache.invalidate(dataFileName);
            } else if (mTrace.beInfo()) {
                StringBuffer sb = new StringBuffer();
                sb.append("file ").append(dataFileName).append(" doesn't exist.");
                mTrace.infoT("deletePrincipalDatabag", sb.toString());
            }
            this.unlockObject(dataFileName);
        }
        if (mTrace.bePath()) {
            mTrace.exiting("deletePrincipalDatabag");
        }
    }

    private String calculateObjectFileName(String principalID) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("calculateObjectFileName", new Object[]{principalID});
        }
        String[] idParts = this.splitPrincipalDatabagID(principalID);
        String principalType = idParts[0];
        String objectID = Util.encode(idParts[2], false);
        String dataFileName = this.datasourceRootPath + File.separator + principalType + File.separator + objectID + OBJECTNAME_SEPARATOR + idParts[1] + DATAFILE_EXTENSION;
        if (mTrace.bePath()) {
            mTrace.exiting("calculateObjectFileName", dataFileName);
        }
        return dataFileName;
    }

    public void createPrincipalDatabag(IInternalPrincipalDatabag principal) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("createPrincipalDatabag", new Object[]{principal});
        }
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        if (this.isReadonly()) {
            if (mTrace.beInfo()) {
                mTrace.infoT("createPrincipalDatabag", "This datasource is readonly... do not try to create principal databag.");
            }
            if (mTrace.bePath()) {
                mTrace.exiting("createPrincipalDatabag");
            }
            return;
        }
        String principalID = principal.getUniqueID();
        if (principalID == null) {
            String errorMessage = "A principal databag has to be bound before it can be created!";
            throw new PersistenceException(errorMessage);
        }
        if (this.feelsResponsible(principal)) {
            String dataFileName = this.calculateObjectFileName(principalID);
            File objectFile = new File(dataFileName);
            File parentDirectory = objectFile.getParentFile();
            if (!parentDirectory.exists() && !parentDirectory.mkdirs()) {
                String errorMessage = "Cannot create directory: " + parentDirectory;
                throw new PersistenceException(errorMessage);
            }
            if (objectFile.exists()) {
                String errorMessage = "Principal databag " + principalID + " is already exists!";
                throw new PersistenceException(errorMessage);
            }
            try {
                if (!objectFile.createNewFile()) {
                    String errorMessage = "Objectfile " + dataFileName + " cannot be created!";
                    throw new PersistenceException(errorMessage);
                }
            }
            catch (IOException ioex) {
                throw new PersistenceException(ioex);
            }
            this.setValuesInPersistenceFile(principal, dataFileName);
            principal.deleteAttributeValues("com.sap.security.core.usermanagement", "j_password");
        }
        if (mTrace.bePath()) {
            mTrace.exiting("createPrincipalDatabag");
        }
    }

    private synchronized void lockObject(String objectFileName) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("lockObject", new Object[]{objectFileName});
        }
        boolean lockFound = false;
        lockFound = this.lockedObjects.containsKey(objectFileName);
        while (lockFound) {
            try {
                if (mTrace.beInfo()) {
                    mTrace.infoT("lockObject", "Waiting for lock for " + objectFileName);
                }
                this.wait(600000L);
            }
            catch (InterruptedException irex) {
                throw new PersistenceException(irex);
            }
            lockFound = this.lockedObjects.containsKey(objectFileName);
        }
        this.lockedObjects.put(objectFileName, "LOCKED");
        if (mTrace.beInfo()) {
            mTrace.infoT("lockObject", "Got lock for " + objectFileName);
        }
        if (mTrace.bePath()) {
            mTrace.exiting("lockObject");
        }
    }

    private synchronized void unlockObject(String objectFileName) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("unlockObject", new Object[]{objectFileName});
        }
        if (this.lockedObjects.containsKey(objectFileName)) {
            this.lockedObjects.remove(objectFileName);
            if (mTrace.beInfo()) {
                mTrace.infoT("unlockObject", "Released lock for " + objectFileName);
            }
        } else {
            this.lockedObjects.put(objectFileName, "ERROR");
            String errorMessage = "Object " + objectFileName + " not found in locked objects!";
            throw new PersistenceException(errorMessage);
        }
        this.notifyAll();
        if (mTrace.bePath()) {
            mTrace.exiting("unlockObject");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setValuesInPersistenceFile(IInternalPrincipalDatabag principal, String dataFileName) throws PersistenceException {
        StringBuffer valueLine;
        int vectorSize;
        if (mTrace.bePath()) {
            mTrace.entering("setValuesInPersistenceFile", new Object[]{principal, dataFileName});
        }
        if (principal == null) {
            String errorMessage = "Cannot store null principal to data file " + dataFileName;
            throw new PersistenceException(errorMessage);
        }
        String principalID = principal.getUniqueID();
        String[] idParts = principal.getIDParts();
        String type = idParts[0];
        Vector<String> headers = new Vector<String>();
        Vector<String> values = new Vector<String>();
        String nameSpace = "";
        String attribute = "";
        Vector respNameSpaces = this.mConfigurationModel.getResponsibleNameSpaces(type);
        if (respNameSpaces == null) {
            respNameSpaces = new Vector();
            Enumeration en = principal.getNameSpaces();
            while (en.hasMoreElements()) {
                respNameSpaces.add(en.nextElement());
            }
        }
        int j = 0;
        while (j < respNameSpaces.size()) {
            nameSpace = (String)respNameSpaces.elementAt(j);
            Enumeration attrsEn = principal.getAttributesOnNamespace(nameSpace);
            while (attrsEn.hasMoreElements()) {
                Vector v;
                attribute = (String)attrsEn.nextElement();
                if (nameSpace.equals("com.sap.security.core.usermanagement") && (attribute.equals("PRINCIPAL_TYPE_ATTRIBUTE") || attribute.equals("oldpassword")) || !this.feelsResponsible(type, nameSpace, attribute) || (v = principal.getAttributeValues(nameSpace, attribute)) == null) continue;
                vectorSize = v.size();
                Object o = null;
                if (vectorSize > 0) {
                    o = v.firstElement();
                }
                if (o == null) continue;
                attribute = this.getPhysicalAttribute(type, nameSpace, attribute);
                headers.add(this.createPersistenceLineHeader(nameSpace, attribute, o));
                valueLine = new StringBuffer();
                int i = 0;
                while (i < vectorSize) {
                    block28: {
                        if (attribute.equals("j_password") && nameSpace.equals("com.sap.security.core.usermanagement") && v.elementAt(i) instanceof String && !((String)v.elementAt(i)).startsWith("{SHA}") && !((String)v.elementAt(i)).startsWith("{SSHA}") && !((String)v.elementAt(i)).startsWith("{SAPSHA}")) {
                            Vector logonIDs = principal.getAttributeValues("com.sap.security.core.usermanagement", "j_user");
                            if (logonIDs != null && logonIDs.size() > 0) {
                                String logonID = (String)logonIDs.firstElement();
                                String hashedPassword = new PasswordHash(logonID, (String)v.elementAt(i)).getHash();
                                valueLine.append(this.createPersistenceLineValues(hashedPassword));
                                break block28;
                            } else {
                                String errorMessage = "Cannot set password for principal " + principal.getUniqueID() + " without logon id!";
                                throw new PersistenceException(errorMessage);
                            }
                        }
                        valueLine.append(this.createPersistenceLineValues(v.elementAt(i)));
                    }
                    valueLine.append("~");
                    ++i;
                }
                values.add(valueLine.substring(0, valueLine.length() - "~".length()));
            }
            ++j;
        }
        Hashtable respNameSpaceAttributes = this.mConfigurationModel.getResponsibleNameSpaceAttributes(type);
        if (respNameSpaceAttributes != null) {
            Enumeration en = respNameSpaceAttributes.keys();
            while (en.hasMoreElements()) {
                nameSpace = (String)en.nextElement();
                Vector attributes = (Vector)respNameSpaceAttributes.get(nameSpace);
                if (attributes == null) continue;
                int newVectorSize = attributes.size();
                int j2 = 0;
                while (j2 < newVectorSize) {
                    Vector v;
                    attribute = (String)attributes.elementAt(j2);
                    if ((!nameSpace.equals("com.sap.security.core.usermanagement") || !attribute.equals("PRINCIPAL_TYPE_ATTRIBUTE") && !attribute.equals("oldpassword")) && this.feelsResponsible(type, nameSpace, attribute) && (v = principal.getAttributeValues(nameSpace, attribute)) != null) {
                        vectorSize = v.size();
                        Object o = null;
                        if (vectorSize > 0) {
                            o = v.firstElement();
                        }
                        if (o != null) {
                            attribute = this.getPhysicalAttribute(type, nameSpace, attribute);
                            headers.add(this.createPersistenceLineHeader(nameSpace, attribute, o));
                            valueLine = new StringBuffer();
                            int i = 0;
                            while (i < vectorSize) {
                                block29: {
                                    if (attribute.equals("j_password") && nameSpace.equals("com.sap.security.core.usermanagement") && v.elementAt(i) instanceof String && !((String)v.elementAt(i)).startsWith("{SHA}") && !((String)v.elementAt(i)).startsWith("{SSHA}") && !((String)v.elementAt(i)).startsWith("{SAPSHA}")) {
                                        Vector logonIDs = principal.getAttributeValues("com.sap.security.core.usermanagement", "j_user");
                                        if (logonIDs != null && logonIDs.size() > 0) {
                                            String logonID = (String)logonIDs.firstElement();
                                            String hashedPassword = new PasswordHash(logonID, (String)v.elementAt(i)).getHash();
                                            valueLine.append(this.createPersistenceLineValues(hashedPassword));
                                            break block29;
                                        } else {
                                            String errorMessage = "Cannot set password for principal " + principal.getUniqueID() + " without logon id!";
                                            throw new PersistenceException(errorMessage);
                                        }
                                    }
                                    valueLine.append(this.createPersistenceLineValues(v.elementAt(i)));
                                }
                                valueLine.append("~");
                                ++i;
                            }
                            values.add(valueLine.substring(0, valueLine.length() - "~".length()));
                        }
                    }
                    ++j2;
                }
            }
        }
        int size = headers.size();
        this.lockObject(dataFileName);
        Properties object = new Properties();
        int i = 0;
        while (i < size) {
            object.setProperty((String)headers.elementAt(i), (String)values.elementAt(i));
            ++i;
        }
        try {
            File df = new File(dataFileName);
            if (!df.exists()) {
                df.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(dataFileName);
            object.store(fos, dataFileName + " data file");
            this.mCache.put(dataFileName, object);
            fos.close();
        }
        catch (FileNotFoundException fnfex) {
            String errorMessage = "Objectfile " + dataFileName + " not found: " + fnfex.getMessage();
            if (mTrace.beInfo()) {
                mTrace.infoT("setValuesInPersistenceFile", errorMessage, fnfex);
            }
            this.unlockObject(dataFileName);
            return;
        }
        catch (IOException ioex) {
            this.unlockObject(dataFileName);
            throw new PersistenceException(ioex);
        }
        this.unlockObject(dataFileName);
        if (mTrace.bePath()) {
            mTrace.exiting("setValuesInPersistenceFile");
        }
    }

    protected String removeValuesFromValueString(String valueString, String[] valuesToRemove) {
        if (mTrace.bePath()) {
            mTrace.entering("removeValuesFromValueString", new Object[]{valueString, valuesToRemove});
        }
        Hashtable<String, String> ht = new Hashtable<String, String>();
        int i = 0;
        while (i < valuesToRemove.length) {
            ht.put(valuesToRemove[i], "");
            ++i;
        }
        StringTokenizer strt = new StringTokenizer(valueString, "~", false);
        StringBuffer result = new StringBuffer();
        while (strt.hasMoreTokens()) {
            String element = strt.nextToken();
            if (ht.containsKey(element)) continue;
            result.append(element);
            result.append("~");
        }
        String res = result.substring(0, result.length() - "~".length());
        if (mTrace.bePath()) {
            mTrace.exiting("removeValuesFromValueString", res);
        }
        return res;
    }

    private String[] splitValueString(String valueString) {
        if (mTrace.bePath()) {
            mTrace.entering("splitValueString", new Object[]{valueString});
        }
        StringTokenizer strt = new StringTokenizer(valueString, "~", false);
        int counter = 0;
        String[] result = new String[strt.countTokens()];
        while (strt.hasMoreTokens()) {
            result[counter] = strt.nextToken();
            ++counter;
        }
        if (mTrace.bePath()) {
            mTrace.exiting("splitValueString", result);
        }
        return result;
    }

    protected void deleteValuesInPersistenceFile(String nameSpace, String attributeName, String objectFileName) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("deleteValuesInPersistenceFile", new Object[]{nameSpace, attributeName, objectFileName});
        }
        String id = this.getUniqueIdFromObjectFile(objectFileName);
        String[] idParts = this.splitPrincipalDatabagID(id);
        String type = idParts[0];
        attributeName = this.getPhysicalAttribute(type, nameSpace, attributeName);
        String stringHeader = this.createPersistenceLineHeader(nameSpace, attributeName, new String());
        String blobHeader = this.createPersistenceLineHeader(nameSpace, attributeName, new byte[0]);
        this.lockObject(objectFileName);
        Properties object = (Properties)this.mCache.get(objectFileName);
        if (object == null) {
            object = new Properties();
            try {
                FileInputStream fis = new FileInputStream(objectFileName);
                object.load(fis);
                fis.close();
            }
            catch (FileNotFoundException fnfex) {
                String errorMessage = "Objectfile " + objectFileName + " not found: " + fnfex.getMessage();
                if (mTrace.beInfo()) {
                    mTrace.infoT("deleteValuesInPersistenceFile", errorMessage, fnfex);
                }
                this.unlockObject(objectFileName);
                return;
            }
            catch (IOException ioex) {
                this.unlockObject(objectFileName);
                throw new PersistenceException(ioex);
            }
        }
        ((Hashtable)object).remove(stringHeader);
        ((Hashtable)object).remove(blobHeader);
        this.mCache.put(objectFileName, object);
        try {
            FileOutputStream fos = new FileOutputStream(objectFileName);
            object.store(fos, objectFileName + " data file");
            fos.close();
        }
        catch (FileNotFoundException fnfex) {
            String errorMessage = "Objectfile " + objectFileName + " not found: " + fnfex.getMessage();
            if (mTrace.beInfo()) {
                mTrace.infoT("deleteValuesInPersistenceFile", errorMessage, fnfex);
            }
            this.unlockObject(objectFileName);
            return;
        }
        catch (IOException ioex) {
            this.unlockObject(objectFileName);
            throw new PersistenceException(ioex);
        }
        this.unlockObject(objectFileName);
        if (mTrace.bePath()) {
            mTrace.exiting("deleteValuesInPersistenceFile");
        }
    }

    private String[] readPersistenceLineHeader(String persistenceLineHeader) {
        if (mTrace.bePath()) {
            mTrace.entering("readPersistenceLineHeader", new Object[]{persistenceLineHeader});
        }
        StringTokenizer strt = new StringTokenizer(persistenceLineHeader, "~", false);
        String[] headerParts = new String[strt.countTokens()];
        int counter = 0;
        while (strt.hasMoreTokens()) {
            headerParts[counter] = Util.decode(strt.nextToken(), this.humanReadableStorage);
            ++counter;
        }
        if (mTrace.bePath()) {
            mTrace.exiting("readPersistenceLineHeader", headerParts);
        }
        return headerParts;
    }

    private String createPersistenceLineHeader(String nameSpace, String attributeName, Object o) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("createPersistenceLineHeader", new Object[]{nameSpace, attributeName, o});
        }
        StringBuffer header = new StringBuffer();
        if (this.humanReadableStorage && nameSpace.indexOf("~") != -1) {
            throw new PersistenceException("\"~\" is not allowed in namespace when <humanReadableStorage> parameter is true (default: not set meanstrue)!");
        }
        header.append(Util.encode(nameSpace, this.humanReadableStorage));
        header.append("~");
        if (this.humanReadableStorage && attributeName.indexOf("~") != -1) {
            throw new PersistenceException("\"~\" is not allowed in attribute name when <humanReadableStorage> parameter is true (default: not set meanstrue)!");
        }
        header.append(Util.encode(attributeName, this.humanReadableStorage));
        header.append("~");
        if (o instanceof String) {
            if (this.humanReadableStorage && ((String)o).indexOf("~") != -1) {
                throw new PersistenceException("\"~\" is not allowed in string when <humanReadableStorage> parameter is true (default: not set meanstrue)!");
            }
            header.append(Util.encode(PERSISTENCE_DATA_TYPE_STRING, this.humanReadableStorage));
        } else if (o instanceof byte[]) {
            header.append(Util.encode(PERSISTENCE_DATA_TYPE_BLOB, this.humanReadableStorage));
        } else {
            String errorMessage = "Object type " + o.getClass() + " not supported!";
            throw new PersistenceException(errorMessage);
        }
        if (mTrace.bePath()) {
            mTrace.exiting("createPersistenceLineHeader", header.toString());
        }
        return header.toString();
    }

    private String createPersistenceLineValues(Object o) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("createPersistenceLineValues", new Object[]{o});
        }
        StringBuffer persistenceLine = new StringBuffer();
        if (o instanceof String) {
            if (this.humanReadableStorage && ((String)o).indexOf("~") != -1) {
                throw new PersistenceException("\"~\" is not allowed in strings when <humanReadableStorage> parameter is true (default: not set meanstrue)!");
            }
            persistenceLine.append(Util.encode((String)o, this.humanReadableStorage));
        } else if (o instanceof byte[]) {
            persistenceLine.append(Util.encode((byte[])o));
        } else {
            String errorMessage = "Object type " + o.getClass() + " not supported!";
            throw new PersistenceException(errorMessage);
        }
        if (mTrace.bePath()) {
            mTrace.exiting("createPersistenceLineValues", persistenceLine.toString());
        }
        return persistenceLine.toString();
    }

    public void updatePrincipalDatabag(IInternalPrincipalDatabagMaint principalMaint) throws PersistenceException {
        String attributeName;
        String nameSpace;
        if (mTrace.bePath()) {
            mTrace.entering("updatePrincipalDatabag", new Object[]{principalMaint});
        }
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        if (this.isReadonly()) {
            if (mTrace.beInfo()) {
                mTrace.infoT("updatePrincipalDatabag", "This datasource is readonly... do not try to update principal databag.");
            }
            if (mTrace.bePath()) {
                mTrace.exiting("updatePrincipalDatabag");
            }
            return;
        }
        String id = principalMaint.getUniqueID();
        String[] idParts = principalMaint.getIDParts();
        String type = idParts[0];
        PrincipalDatabag p = new PrincipalDatabag(id);
        this.populatePrincipalDatabag(p, null);
        Vector addValues = null;
        Vector removeValues = null;
        Enumeration en = principalMaint.getNameSpaces(2);
        while (en.hasMoreElements()) {
            nameSpace = (String)en.nextElement();
            Enumeration innerEn = principalMaint.getAttributesOnNamespace(nameSpace, 2);
            while (innerEn.hasMoreElements()) {
                attributeName = (String)innerEn.nextElement();
                if (nameSpace.equals("com.sap.security.core.usermanagement") && (attributeName.equals("PRINCIPAL_TYPE_ATTRIBUTE") || attributeName.equals("oldpassword")) || !this.feelsResponsible(type, nameSpace, attributeName)) continue;
                p.setAttributeValues(nameSpace, attributeName, principalMaint.getAttributeValues(nameSpace, attributeName, 2));
            }
        }
        Enumeration en2 = principalMaint.getNameSpaces(3);
        while (en2.hasMoreElements()) {
            nameSpace = (String)en2.nextElement();
            Enumeration innerEn = principalMaint.getAttributesOnNamespace(nameSpace, 3);
            while (innerEn.hasMoreElements()) {
                attributeName = (String)innerEn.nextElement();
                if (nameSpace.equals("com.sap.security.core.usermanagement") && (attributeName.equals("PRINCIPAL_TYPE_ATTRIBUTE") || attributeName.equals("oldpassword")) || !this.feelsResponsible(type, nameSpace, attributeName)) continue;
                p.deleteAttributeValues(nameSpace, attributeName);
            }
        }
        Enumeration en3 = principalMaint.getNameSpaces(0);
        while (en3.hasMoreElements()) {
            nameSpace = (String)en3.nextElement();
            Enumeration innerEn = principalMaint.getAttributesOnNamespace(nameSpace, 0);
            while (innerEn.hasMoreElements()) {
                attributeName = (String)innerEn.nextElement();
                if (nameSpace.equals("com.sap.security.core.usermanagement") && (attributeName.equals("PRINCIPAL_TYPE_ATTRIBUTE") || attributeName.equals("oldpassword")) || !this.feelsResponsible(type, nameSpace, attributeName) || (addValues = principalMaint.getAttributeValues(nameSpace, attributeName, 0)) == null) continue;
                int i = 0;
                while (i < addValues.size()) {
                    p.addAttributeValue(nameSpace, attributeName, addValues.elementAt(i));
                    ++i;
                }
            }
        }
        Enumeration en4 = principalMaint.getNameSpaces(1);
        while (en4.hasMoreElements()) {
            nameSpace = (String)en4.nextElement();
            Enumeration innerEn = principalMaint.getAttributesOnNamespace(nameSpace, 1);
            while (innerEn.hasMoreElements()) {
                attributeName = (String)innerEn.nextElement();
                if (nameSpace.equals("com.sap.security.core.usermanagement") && (attributeName.equals("PRINCIPAL_TYPE_ATTRIBUTE") || attributeName.equals("oldpassword")) || !this.feelsResponsible(type, nameSpace, attributeName) || (removeValues = principalMaint.getAttributeValues(nameSpace, attributeName, 1)) == null) continue;
                int i = 0;
                while (i < removeValues.size()) {
                    p.removeAttributeValue(nameSpace, attributeName, removeValues.elementAt(i));
                    ++i;
                }
            }
        }
        String dataFileName = this.calculateObjectFileName(p.getUniqueID());
        this.setValuesInPersistenceFile(p, dataFileName);
        principalMaint.deleteAttributeMaintValues("com.sap.security.core.usermanagement", "j_password");
        if (mTrace.bePath()) {
            mTrace.exiting("updatePrincipalDatabag");
        }
    }

    public Vector getAttributeNamespaces(IPrincipalDatabag principal) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("getAttributeNamespaces", new Object[]{principal});
        }
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        if (!this.feelsResponsible(principal)) {
            if (mTrace.bePath()) {
                mTrace.exiting("getAttributeNamespaces", new Vector());
            }
            return new Vector();
        }
        String dataFileName = this.calculateObjectFileName(principal.getUniqueID());
        Properties object = (Properties)this.mCache.get(dataFileName);
        if (object == null) {
            if (!this.principalDatabagExists(principal)) {
                if (mTrace.bePath()) {
                    mTrace.exiting("getAttributeNamespaces", new Vector());
                }
                return new Vector();
            }
            object = new Properties();
            try {
                FileInputStream fis = new FileInputStream(dataFileName);
                object.load(fis);
                fis.close();
                this.mCache.put(dataFileName, object);
            }
            catch (FileNotFoundException fnfex) {
                String errorMessage = "Objectfile " + dataFileName + " not found: " + fnfex.getMessage();
                if (mTrace.beInfo()) {
                    mTrace.infoT("getAttributeNamespaces", errorMessage, fnfex);
                }
                return new Vector();
            }
            catch (IOException ioex) {
                throw new PersistenceException(ioex);
            }
        }
        Vector<String> result = new Vector<String>();
        Enumeration en = ((Hashtable)object).keys();
        while (en.hasMoreElements()) {
            String encodedHeader = (String)en.nextElement();
            String[] parts = this.getLineHeaderParts(encodedHeader);
            String nameSpace = parts[0];
            if (result.contains(nameSpace)) continue;
            result.add(nameSpace);
        }
        if (mTrace.bePath()) {
            mTrace.exiting("getAttributeNamespaces", result);
        }
        return result;
    }

    private String[] getLineHeaderParts(String encodedHeader) {
        if (mTrace.bePath()) {
            mTrace.entering("getLineHeaderParts", new Object[]{encodedHeader});
        }
        StringTokenizer strt = new StringTokenizer(encodedHeader, "~", false);
        int size = strt.countTokens();
        String[] parts = new String[size];
        int i = 0;
        while (i < size) {
            parts[i] = Util.decode(strt.nextToken(), this.humanReadableStorage);
            ++i;
        }
        if (mTrace.bePath()) {
            mTrace.exiting("getLineHeaderParts", parts);
        }
        return parts;
    }

    public Vector getAttributeNames(IPrincipalDatabag principal, String nameSpace) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("getAttributeNames", new Object[]{principal, nameSpace});
        }
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        if (!this.feelsResponsible(principal)) {
            if (mTrace.bePath()) {
                mTrace.exiting("getAttributeNames", new Vector());
            }
            return new Vector();
        }
        String dataFileName = this.calculateObjectFileName(principal.getUniqueID());
        Properties object = (Properties)this.mCache.get(dataFileName);
        if (object == null) {
            if (!this.principalDatabagExists(principal)) {
                if (mTrace.bePath()) {
                    mTrace.exiting("getAttributeNames", new Vector());
                }
                return new Vector();
            }
            object = new Properties();
            try {
                FileInputStream fis = new FileInputStream(dataFileName);
                object.load(fis);
                fis.close();
                this.mCache.put(dataFileName, object);
            }
            catch (FileNotFoundException fnfex) {
                String errorMessage = "Objectfile " + dataFileName + " not found: " + fnfex.getMessage();
                if (mTrace.beInfo()) {
                    mTrace.infoT("getAttributeNames", errorMessage, fnfex);
                }
                return new Vector();
            }
            catch (IOException ioex) {
                throw new PersistenceException(ioex);
            }
        }
        Vector<String> result = new Vector<String>();
        Enumeration en = ((Hashtable)object).keys();
        while (en.hasMoreElements()) {
            String encodedHeader = (String)en.nextElement();
            String[] parts = this.getLineHeaderParts(encodedHeader);
            String namesp = parts[0];
            String attributeName = parts[1];
            if (nameSpace != null && !nameSpace.equals(namesp) || result.contains(attributeName)) continue;
            result.add(attributeName);
        }
        if (mTrace.bePath()) {
            mTrace.exiting("getAttributeNames", result);
        }
        return result;
    }
}

