/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp;

import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.IInternalPrincipalDatabag;
import com.sap.security.core.persistence.IInternalPrincipalDatabagMaint;
import com.sap.security.core.persistence.IPrincipalDatabag;
import com.sap.security.core.persistence.datasource.IDataSourceTransaction;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.datasource.imp.TextFilePersistence;
import com.sap.security.core.util.IUMTrace;
import java.util.Vector;

public class TextFileDataSourceTransaction
implements IDataSourceTransaction {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/TextFileDataSourceTransaction.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";
    private static final int ADD_ACTION = 0;
    private static final int UPDATE_ACTION = 1;
    private static final int DELETE_ACTION = 2;
    private TextFilePersistence mTextFilePersistence;
    private Vector mActions;
    private static IUMTrace mTrace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/TextFileDataSourceTransaction.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)");

    public TextFileDataSourceTransaction(TextFilePersistence textFilePersistence) {
        if (mTrace.bePath()) {
            mTrace.entering("constructor", new Object[]{textFilePersistence});
        }
        this.mActions = new Vector();
        this.mTextFilePersistence = textFilePersistence;
        if (mTrace.bePath()) {
            mTrace.exiting("constructor");
        }
    }

    public void createPrincipalDatabag(IInternalPrincipalDatabag principal) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("createPrincipalDatabag", new Object[]{principal});
        }
        this.mActions.add(new ActionWrapper(0, principal));
        if (mTrace.bePath()) {
            mTrace.exiting("createPrincipalDatabag");
        }
    }

    public void deletePrincipalDatabag(IPrincipalDatabag principal) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("deletePrincipalDatabag", new Object[]{principal});
        }
        this.mActions.add(new ActionWrapper(2, principal));
        if (mTrace.bePath()) {
            mTrace.exiting("deletePrincipalDatabag");
        }
    }

    public void updatePrincipalDatabag(IInternalPrincipalDatabagMaint principalMaint) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("updatePrincipalDatabag", new Object[]{principalMaint});
        }
        this.mActions.add(new ActionWrapper(1, principalMaint));
        if (mTrace.bePath()) {
            mTrace.exiting("updatePrincipalDatabag");
        }
    }

    public void commit() throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("commit");
        }
        int size = this.mActions.size();
        int i = 0;
        while (i < size) {
            ActionWrapper aw = (ActionWrapper)this.mActions.elementAt(i);
            switch (aw.getActionType()) {
                case 0: {
                    this.mTextFilePersistence.createPrincipalDatabag((IInternalPrincipalDatabag)aw.getPrincipalDatabag());
                    break;
                }
                case 2: {
                    this.mTextFilePersistence.deletePrincipalDatabag(aw.getPrincipalDatabag());
                    break;
                }
                case 1: {
                    this.mTextFilePersistence.updatePrincipalDatabag((IInternalPrincipalDatabagMaint)aw.getPrincipalDatabag());
                    break;
                }
            }
            ++i;
        }
        if (mTrace.bePath()) {
            mTrace.exiting("commit");
        }
    }

    public void rollback() {
        if (mTrace.bePath()) {
            mTrace.entering("rollback");
        }
        this.mActions = new Vector();
        if (mTrace.bePath()) {
            mTrace.exiting("rollback");
        }
    }

    public boolean bindNewPrincipalDatabag(IInternalPrincipalDatabag principal) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("bindNewPrincipalDatabag", new Object[]{principal});
        }
        boolean result = this.mTextFilePersistence.bindNewPrincipalDatabag(principal);
        if (mTrace.bePath()) {
            mTrace.exiting("bindNewPrincipalDatabag", new Boolean(result));
        }
        return result;
    }

    public class ActionWrapper {
        private int mActionType;
        private IPrincipalDatabag mPrincipalDatabag;

        public ActionWrapper(int actionType, IPrincipalDatabag principal) {
            this.mActionType = actionType;
            this.mPrincipalDatabag = principal;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ActionWrapper)) {
                return false;
            }
            ActionWrapper aw = (ActionWrapper)o;
            return aw.getActionType() == this.mActionType && aw.getPrincipalDatabag().equals(this.mPrincipalDatabag);
        }

        public IPrincipalDatabag getPrincipalDatabag() {
            return this.mPrincipalDatabag;
        }

        public int getActionType() {
            return this.mActionType;
        }

        public String toString() {
            StringBuffer res = new StringBuffer();
            switch (this.mActionType) {
                case 0: {
                    res.append("ADD:\n");
                    break;
                }
                case 2: {
                    res.append("DELETE:\n");
                    break;
                }
                case 1: {
                    res.append("UPDATE:\n");
                    break;
                }
            }
            res.append(this.mPrincipalDatabag.toString());
            return res.toString();
        }
    }
}

