/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.ISearchAttribute;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.IInternalPrincipalDatabag;
import com.sap.security.core.persistence.IPrincipalDatabag;
import com.sap.security.core.persistence.datasource.IDataSource;
import com.sap.security.core.persistence.datasource.IDataSourceTransaction;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.datasource.imp.DSAttributeModel;
import com.sap.security.core.persistence.datasource.imp.DSConfigurationModel;
import com.sap.security.core.persistence.datasource.imp.DSNameSpaceModel;
import com.sap.security.core.persistence.datasource.imp.DSPrincipalModel;
import com.sap.security.core.persistence.datasource.imp.DataSourceBaseImplementation;
import com.sap.security.core.persistence.datasource.imp.SuperUserTransaction;
import com.sap.security.core.persistence.imp.SearchCriteria;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.imp.Util;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class SuperUser
extends DataSourceBaseImplementation
implements IDataSource {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/SuperUser.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";
    public static final String SUPERADMIN_ACTIVATED = "ume.superadmin.activated";
    public static final String SUPERADMIN_PASSWORD = "ume.superadmin.password";
    private static final String IMPLEMENTATION_CLASS = "com.sap.security.core.persistence.datasource.imp.SuperUser";
    private static final String SUPERADMIN_ROLES = "ume.superadmin.roles";
    private static final String SUPERADMIN_DEFAULT_ROLES = "Administrator,pcd:portal_content/administrator/super_admin/super_admin_role";
    private static final String mDisplayName = "Built-in User Adapter";
    private static final String mID = "SUPERUSER_DATASOURCE";
    private static final String mPrivateIDPart = "SAPASTERISK";
    private static final String mLogin = "SAP*";
    private static String mPassword = "";
    private static final String mUserDescription = "Built-in Super Administrator";
    private static final String mUserDisplayName = "SAP*";
    private static final String mUserUniqueName = "SAP*";
    private static final String mUserFirstName = "";
    private static final String mUserLastName = "SAP*";
    private static final String mUserAccountDescription = "Built-in Super Administrator Account";
    private static final String mUserAccountDisplayName = "SAP*";
    private static final String mUserAccountUniqueName = "SAP*";
    private static final String mSuperUserID = "USER.SUPERUSER_DATASOURCE.SAPASTERISK";
    private static final String mSuperUserAccountID = "UACC.SUPERUSER_DATASOURCE.SAPASTERISK";
    public static final String SUPERUSER_ID = "USER.SUPERUSER_DATASOURCE.SAPASTERISK";
    public static final String SUPERUSER_ACCOUNT_ID = "UACC.SUPERUSER_DATASOURCE.SAPASTERISK";
    public static final String SUPERUSER_LOGON_UID_ALIAS = "SAP*";
    public static boolean SUPERUSER_IS_ACTIVE = false;
    private Vector mRoleIDs;
    private static IUMTrace mTrace;

    public SuperUser() {
        mTrace = InternalUMFactory.getTrace(VERSIONSTRING);
        mPassword = UMFactory.getProperties().getPassword(SUPERADMIN_PASSWORD);
        if (mPassword == null) {
            mPassword = mUserFirstName;
        }
    }

    public static boolean checkPassword(String password) {
        if (!mPassword.equals(mUserFirstName)) {
            return mPassword.equals(password);
        }
        return false;
    }

    public String getId() {
        return mID;
    }

    public void init(DSConfigurationModel dsConf) throws PersistenceException {
        DSConfigurationModel newConfig = new DSConfigurationModel(mID, IMPLEMENTATION_CLASS, true, true, mDisplayName);
        DSPrincipalModel principalModel1 = new DSPrincipalModel("UACC");
        DSPrincipalModel principalModel2 = new DSPrincipalModel("USER");
        DSPrincipalModel principalModel3 = new DSPrincipalModel("ROLE");
        DSNameSpaceModel namespaceModel1 = new DSNameSpaceModel("com.sap.security.core.usermanagement.relation");
        DSAttributeModel attributeModel1 = new DSAttributeModel("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", 1, true);
        namespaceModel1.setAttribute(attributeModel1);
        principalModel3.setNameSpace(namespaceModel1);
        newConfig.setResponsibleFor(principalModel1);
        newConfig.setResponsibleFor(principalModel2);
        newConfig.setResponsibleFor(principalModel3);
        super.init(newConfig);
        this.isInitialized = true;
    }

    public boolean checkCredentials(Hashtable credentials) {
        String[] dsToSearch = (String[])credentials.get("dataSourceIDs");
        if (dsToSearch != null) {
            boolean found = false;
            int k = 0;
            int s = dsToSearch.length;
            while (k < s && !found) {
                if (this.getId().equals(dsToSearch[k])) {
                    found = true;
                }
                ++k;
            }
            if (!found) {
                return false;
            }
        }
        String login = (String)credentials.get("j_user");
        String password = (String)credentials.get("j_password");
        if (login != null && login.equalsIgnoreCase("SAP*") && password != null) {
            return SuperUser.checkPassword(password);
        }
        return false;
    }

    private Vector getRoleNames() throws PersistenceException {
        Vector<String> result = new Vector<String>();
        String roles = UMFactory.getProperties().get(SUPERADMIN_ROLES, SUPERADMIN_DEFAULT_ROLES);
        StringTokenizer strt = new StringTokenizer(roles, ",", false);
        while (strt.hasMoreTokens()) {
            String name = strt.nextToken();
            if (name == null) continue;
            result.add(name.trim());
        }
        return result;
    }

    protected String getPrivateIDPart(IPrincipalDatabag principal) throws PersistenceException {
        return mPrivateIDPart;
    }

    public IInternalPrincipalDatabag[] initPrincipalDatabags(IInternalPrincipalDatabag[] principals) throws PersistenceException {
        int length = principals.length;
        int i = 0;
        while (i < length) {
            if (principals[i] != null) {
                this.populatePrincipalDatabag(principals[i], null);
            }
            ++i;
        }
        return principals;
    }

    public void populatePrincipalDatabags(IInternalPrincipalDatabag[] principals, AttributeList populateAttributes) throws PersistenceException {
        principals = this.initPrincipalDatabags(principals);
    }

    public boolean populatePrincipalDatabag(IInternalPrincipalDatabag principal, String nameSpace, String attribute) throws PersistenceException {
        if (principal != null) {
            Vector names;
            String principalID = principal.getUniqueID();
            String[] idParts = principal.getIDParts();
            if (principalID.equals("UACC.SUPERUSER_DATASOURCE.SAPASTERISK")) {
                principal.setAttributeValues(nameSpace, attribute, new Vector());
                principal.setAttributeValues("com.sap.security.core.usermanagement", "userid", this.convertToVector("USER.SUPERUSER_DATASOURCE.SAPASTERISK"));
                principal.setAttributeValues("com.sap.security.core.usermanagement", "internalid", this.convertToVector("UACC.SUPERUSER_DATASOURCE.SAPASTERISK"));
                principal.setAttributeValues("com.sap.security.core.usermanagement", "j_user", this.convertToVector("SAP*"));
                principal.setAttributeValues("com.sap.security.core.usermanagement", "description", this.convertToVector(mUserAccountDescription));
                principal.setAttributeValues("com.sap.security.core.usermanagement", "displayname", this.convertToVector("SAP*"));
                String now = Util.getTimeStamp();
                principal.setAttributeValues("com.sap.security.core.usermanagement", "PRINCIPAL_CREATION_DATE", this.convertToVector(now));
                principal.setAttributeValues("com.sap.security.core.usermanagement", "PRINCIPAL_MODIFY_DATE", this.convertToVector(now));
                principal.setAttributeValues("com.sap.security.core.usermanagement", "uniquename", this.convertToVector("SAP*"));
                if (principal.getAttributeValues(nameSpace, attribute) == null) {
                    principal.setAttributeValues(nameSpace, attribute, new Vector());
                }
                if (principal.getIDParts()[1].equals(this.getId())) {
                    principal.setExists(true);
                }
                return true;
            }
            if (principalID.equals("USER.SUPERUSER_DATASOURCE.SAPASTERISK")) {
                principal.setAttributeValues(nameSpace, attribute, new Vector());
                principal.setAttributeValues("com.sap.security.core.usermanagement", "description", this.convertToVector(mUserDescription));
                principal.setAttributeValues("com.sap.security.core.usermanagement", "displayname", this.convertToVector("SAP*"));
                String now = Util.getTimeStamp();
                principal.setAttributeValues("com.sap.security.core.usermanagement", "PRINCIPAL_CREATION_DATE", this.convertToVector(now));
                principal.setAttributeValues("com.sap.security.core.usermanagement", "PRINCIPAL_MODIFY_DATE", this.convertToVector(now));
                principal.setAttributeValues("com.sap.security.core.usermanagement", "uniquename", this.convertToVector("SAP*"));
                if (principal.getAttributeValues(nameSpace, attribute) == null) {
                    principal.setAttributeValues(nameSpace, attribute, new Vector());
                }
                if (principal.getIDParts()[1].equals(this.getId())) {
                    principal.setExists(true);
                }
                return true;
            }
            if (idParts[0].equals("ROLE") && nameSpace.equals("com.sap.security.core.usermanagement.relation") && attribute.equals("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE") && (names = principal.getAttributeValues("com.sap.security.core.usermanagement", "uniquename")) != null) {
                if (this.mRoleIDs == null) {
                    this.mRoleIDs = this.getRoleNames();
                }
                if (this.mRoleIDs != null) {
                    int roleSize = this.mRoleIDs.size();
                    int j = 0;
                    while (j < roleSize) {
                        if (names.contains(this.mRoleIDs.elementAt(j))) {
                            Vector oldMembers = principal.getAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE");
                            Vector<String> newMember = new Vector<String>();
                            newMember.add("USER.SUPERUSER_DATASOURCE.SAPASTERISK");
                            principal.setAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", this.buildUnion(new Vector[]{oldMembers, newMember}));
                            return true;
                        }
                        ++j;
                    }
                }
            }
        }
        return false;
    }

    public IDataSourceTransaction beginTransaction() {
        return new SuperUserTransaction();
    }

    public boolean principalDatabagExists(IPrincipalDatabag principal) throws PersistenceException {
        String principalID;
        boolean exists = false;
        if (principal != null && (principalID = principal.getUniqueID()) != null) {
            if (principalID.equals("UACC.SUPERUSER_DATASOURCE.SAPASTERISK")) {
                exists = true;
            } else if (principalID.equals("USER.SUPERUSER_DATASOURCE.SAPASTERISK")) {
                exists = true;
            }
        }
        return exists;
    }

    public Vector searchPrincipalDatabags(SearchCriteria criteria) throws PersistenceException {
        String methodName = "searchPrincipalDatabags";
        String type = criteria.getPrincipalType();
        SearchCriteria newSc = new SearchCriteria(criteria.isOrMode(), type);
        int size = criteria.getElementSize();
        boolean notResponsibleAttributeFound = false;
        int i = 0;
        while (i < size && (criteria.isOrMode() || !notResponsibleAttributeFound)) {
            block33: {
                String attribute;
                String namespace;
                ISearchAttribute se;
                block30: {
                    block34: {
                        int operatore;
                        block31: {
                            block32: {
                                se = criteria.getAttribute(i);
                                namespace = se.getAttributeNameSpace();
                                attribute = se.getAttributeName();
                                if (!namespace.equals("com.sap.security.core.usermanagement")) break block30;
                                if (!type.equals("USER")) break block31;
                                if (!attribute.equals("description") && !attribute.equals("displayname") && !attribute.equals("firstname") && !attribute.equals("lastname") && !attribute.equals("uniquename")) break block32;
                                operatore = se.getOperator();
                                switch (operatore) {
                                    case 0: {
                                        newSc.addEqualsElement(namespace, attribute, se.getAttributeValue(), se.isCaseSensitive());
                                        break block33;
                                    }
                                    case 1: {
                                        newSc.addLikeElement(namespace, attribute, se.getAttributeValue(), se.isCaseSensitive());
                                        break block33;
                                    }
                                    case 2: {
                                        newSc.addGreaterThanElement(namespace, attribute, se.getAttributeValue(), se.isCaseSensitive());
                                        break block33;
                                    }
                                    case 3: {
                                        newSc.addLessThanElement(namespace, attribute, se.getAttributeValue(), se.isCaseSensitive());
                                        break block33;
                                    }
                                    default: {
                                        throw new PersistenceException("Unknown search operator!");
                                    }
                                }
                            }
                            if (se.getAttributeValue() != null && !attribute.equals("PRINCIPAL_TYPE_ATTRIBUTE")) {
                                notResponsibleAttributeFound = true;
                            }
                            break block33;
                        }
                        if (!type.equals("UACC")) break block33;
                        if (!attribute.equals("userid") && !attribute.equals("internalid") && !attribute.equals("j_user") && !attribute.equals("description") && !attribute.equals("displayname") && !attribute.equals("uniquename")) break block34;
                        operatore = se.getOperator();
                        switch (operatore) {
                            case 0: {
                                newSc.addEqualsElement(namespace, attribute, se.getAttributeValue(), se.isCaseSensitive());
                                break block33;
                            }
                            case 1: {
                                newSc.addLikeElement(namespace, attribute, se.getAttributeValue(), se.isCaseSensitive());
                                break block33;
                            }
                            case 2: {
                                newSc.addGreaterThanElement(namespace, attribute, se.getAttributeValue(), se.isCaseSensitive());
                                break block33;
                            }
                            case 3: {
                                newSc.addLessThanElement(namespace, attribute, se.getAttributeValue(), se.isCaseSensitive());
                                break block33;
                            }
                            default: {
                                throw new PersistenceException("Unknown search operator!");
                            }
                        }
                    }
                    if (se.getAttributeValue() != null && !attribute.equals("PRINCIPAL_TYPE_ATTRIBUTE")) {
                        notResponsibleAttributeFound = true;
                    }
                    break block33;
                }
                if (type.equals("ROLE") && namespace.equals("com.sap.security.core.usermanagement.relation") && attribute.equals("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE") && se.getAttributeValue().equals("USER.SUPERUSER_DATASOURCE.SAPASTERISK")) {
                    Vector<String> res = null;
                    boolean enabled = UMFactory.getProperties().getBoolean(SUPERADMIN_ACTIVATED, false);
                    if (enabled) {
                        if (this.mRoleIDs == null) {
                            this.mRoleIDs = this.getRoleNames();
                        }
                        if (this.mRoleIDs != null) {
                            res = new Vector<String>();
                            int roleSize = this.mRoleIDs.size();
                            int j = 0;
                            while (j < roleSize) {
                                block29: {
                                    try {
                                        res.add(UMFactory.getRoleFactory().getRoleByUniqueName((String)this.mRoleIDs.elementAt(j)).getUniqueID());
                                    }
                                    catch (UMException umex) {
                                        if (!mTrace.beInfo()) break block29;
                                        String errorMessage = "Couldn't get role with unique name \"" + (String)this.mRoleIDs.elementAt(j) + "\" for SAP*.";
                                        mTrace.infoT(methodName, errorMessage, umex);
                                    }
                                }
                                ++j;
                            }
                        }
                    }
                    return res;
                }
            }
            ++i;
        }
        if (!criteria.isOrMode() && notResponsibleAttributeFound) {
            return null;
        }
        Vector<String> result = new Vector<String>();
        if (type.equals("USER")) {
            if (newSc.getElementSize() == 1) {
                return null;
            }
            Properties p = new Properties();
            ((Hashtable)p).put("com.sap.security.core.usermanagement.description", new String[]{mUserDescription});
            ((Hashtable)p).put("com.sap.security.core.usermanagement.displayname", new String[]{"SAP*"});
            ((Hashtable)p).put("com.sap.security.core.usermanagement.uniquename", new String[]{"SAP*"});
            ((Hashtable)p).put("com.sap.security.core.usermanagement.firstname", new String[]{mUserFirstName});
            ((Hashtable)p).put("com.sap.security.core.usermanagement.lastname", new String[]{"SAP*"});
            if (this.objectMatchesSearch(p, newSc)) {
                result.add("USER.SUPERUSER_DATASOURCE.SAPASTERISK");
            }
            return result;
        }
        if (type.equals("UACC")) {
            if (newSc.getElementSize() == 1) {
                return null;
            }
            Properties p = new Properties();
            ((Hashtable)p).put("com.sap.security.core.usermanagement.userid", new String[]{"USER.SUPERUSER_DATASOURCE.SAPASTERISK"});
            ((Hashtable)p).put("com.sap.security.core.usermanagement.internalid", new String[]{"UACC.SUPERUSER_DATASOURCE.SAPASTERISK"});
            ((Hashtable)p).put("com.sap.security.core.usermanagement.j_user", new String[]{"SAP*"});
            ((Hashtable)p).put("com.sap.security.core.usermanagement.description", new String[]{mUserAccountDescription});
            ((Hashtable)p).put("com.sap.security.core.usermanagement.displayname", new String[]{"SAP*"});
            ((Hashtable)p).put("com.sap.security.core.usermanagement.uniquename", new String[]{"SAP*"});
            if (this.objectMatchesSearch(p, newSc)) {
                result.add("UACC.SUPERUSER_DATASOURCE.SAPASTERISK");
            }
            return result;
        }
        return null;
    }

    private boolean objectMatchesSearch(Properties object, SearchCriteria criteria) throws PersistenceException {
        if (object == null) {
            return false;
        }
        int size = criteria.getElementSize();
        boolean orMode = criteria.isOrMode();
        if (orMode) {
            boolean found = false;
            int counter = 0;
            while (!found && counter < size) {
                ISearchAttribute se = criteria.getAttribute(counter);
                if (!se.getAttributeNameSpace().equals("com.sap.security.core.usermanagement") || !se.getAttributeName().equals("PRINCIPAL_TYPE_ATTRIBUTE")) {
                    if (se.getAttributeValue() != null) {
                        found = this.objectMatchesSearchElement(object, se);
                    } else {
                        SearchCriteria searchC = new SearchCriteria(criteria.getPrincipalType());
                        searchC.addLikeElement(se.getAttributeNameSpace(), se.getAttributeName(), "*", se.isCaseSensitive());
                        searchC.addEqualsElement(se.getAttributeNameSpace(), se.getAttributeName(), new byte[0], se.isCaseSensitive());
                        found = !this.objectMatchesSearchElement(object, searchC.getAttribute(0)) && !this.objectMatchesSearchElement(object, searchC.getAttribute(1));
                    }
                }
                ++counter;
            }
            return found;
        }
        boolean allMatched = true;
        int counter = 0;
        while (allMatched && counter < size) {
            ISearchAttribute se = criteria.getAttribute(counter);
            if (!se.getAttributeNameSpace().equals("com.sap.security.core.usermanagement") || !se.getAttributeName().equals("PRINCIPAL_TYPE_ATTRIBUTE")) {
                if (se.getAttributeValue() != null) {
                    allMatched = allMatched && this.objectMatchesSearchElement(object, se);
                } else {
                    SearchCriteria searchC = new SearchCriteria(criteria.getPrincipalType());
                    searchC.addLikeElement(se.getAttributeNameSpace(), se.getAttributeName(), "*", se.isCaseSensitive());
                    searchC.addEqualsElement(se.getAttributeNameSpace(), se.getAttributeName(), new byte[0], se.isCaseSensitive());
                    allMatched = allMatched && !this.objectMatchesSearchElement(object, searchC.getAttribute(0)) && !this.objectMatchesSearchElement(object, searchC.getAttribute(1));
                }
            } else if (criteria.getElementSize() == 1) {
                return false;
            }
            ++counter;
        }
        return allMatched;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private boolean objectMatchesSearchElement(Properties p, ISearchAttribute se) throws PersistenceException {
        o = se.getAttributeValue();
        caseSensitive = se.isCaseSensitive();
        header = se.getAttributeNameSpace() + "." + se.getAttributeName();
        splitValues = (String[])p.get(header);
        found = false;
        size = splitValues.length;
        counter = 0;
        while (!found && counter < size) {
            block20: {
                block21: {
                    if (!(o instanceof String)) break block21;
                    value = splitValues[counter];
                    switch (se.getOperator()) {
                        case 0: {
                            if (caseSensitive) {
                                found = value.equals((String)o);
                                break;
                            }
                            found = value.equalsIgnoreCase((String)o);
                            break;
                        }
                        case 1: {
                            if (o.equals("*")) {
                                found = true;
                                break;
                            }
                            strt = caseSensitive != false ? new StringTokenizer((String)o, "*", false) : new StringTokenizer(((String)o).toUpperCase(), "*", false);
                            startsWith = ((String)o).startsWith("*") == false;
                            endsWith = ((String)o).endsWith("*") == false;
                            lastIndex = -1;
                            found = true;
                            isFirstElement = true;
                            while (strt.hasMoreTokens()) {
                                if (found) {
                                    currentToken = strt.nextToken();
                                    currentIndex = caseSensitive != false ? value.indexOf(currentToken) : value.toUpperCase().indexOf(currentToken);
                                    found = isFirstElement && startsWith ? (caseSensitive ? value.startsWith(currentToken) : value.toUpperCase().startsWith(currentToken)) : (!strt.hasMoreTokens() && endsWith ? (caseSensitive ? value.endsWith(currentToken) : value.toUpperCase().endsWith(currentToken)) : currentIndex > lastIndex);
                                    lastIndex = currentIndex;
                                    isFirstElement = false;
                                    continue;
                                }
                                break block20;
                            }
                            break block20;
                        }
                        case 2: {
                            if (caseSensitive) {
                                found = value.compareTo((String)o) > 0;
                                break;
                            }
                            found = value.toLowerCase().compareTo(((String)o).toLowerCase()) > 0;
                            break;
                        }
                        case 3: {
                            if (caseSensitive) {
                                found = value.compareTo((String)o) < 0;
                                break;
                            }
                            found = value.toLowerCase().compareTo(((String)o).toLowerCase()) < 0;
                            break;
                        }
                        default: {
                            errorMessage = "Unsupported search element operator found!";
                            throw new PersistenceException(errorMessage);
                        }
                    }
                    break block20;
                }
                if (!(o instanceof byte[])) {
                    errorMessage = "Unsupported object type: " + o.getClass();
                    throw new PersistenceException(errorMessage);
                }
                blob = Util.decodeToByteArray(splitValues[counter]);
                switch (se.getOperator()) {
                    case 0: {
                        found = blob.equals((byte[])o);
                        ** break;
                    }
                    case 1: {
                        errorMessage = "Unsupported search element operator found: like cannot be used for blobs!";
                        throw new PersistenceException(errorMessage);
                    }
                    case 2: {
                        errorMessage = "Unsupported search element operator found: greater than cannot be used for blobs!";
                        throw new PersistenceException(errorMessage);
                    }
                    case 3: {
                        errorMessage = "Unsupported search element operator found: less than cannot be used for blobs!";
                        throw new PersistenceException(errorMessage);
                    }
                }
                errorMessage = "Unsupported search element operator found!";
                throw new PersistenceException(errorMessage);
            }
            ++counter;
        }
        return found;
    }

    public void populatePrincipalDatabag(IInternalPrincipalDatabag principal, AttributeList populateAttributes) throws PersistenceException {
        if (principal != null) {
            Vector names;
            String principalID = principal.getUniqueID();
            String[] idParts = principal.getIDParts();
            if (principalID.equals("UACC.SUPERUSER_DATASOURCE.SAPASTERISK")) {
                principal.setAttributeValues("com.sap.security.core.usermanagement", "userid", this.convertToVector("USER.SUPERUSER_DATASOURCE.SAPASTERISK"));
                principal.setAttributeValues("com.sap.security.core.usermanagement", "internalid", this.convertToVector("UACC.SUPERUSER_DATASOURCE.SAPASTERISK"));
                principal.setAttributeValues("com.sap.security.core.usermanagement", "j_user", this.convertToVector("SAP*"));
                principal.setAttributeValues("com.sap.security.core.usermanagement", "description", this.convertToVector(mUserAccountDescription));
                principal.setAttributeValues("com.sap.security.core.usermanagement", "displayname", this.convertToVector("SAP*"));
                String now = Util.getTimeStamp();
                principal.setAttributeValues("com.sap.security.core.usermanagement", "PRINCIPAL_CREATION_DATE", this.convertToVector(now));
                principal.setAttributeValues("com.sap.security.core.usermanagement", "PRINCIPAL_MODIFY_DATE", this.convertToVector(now));
                principal.setAttributeValues("com.sap.security.core.usermanagement", "uniquename", this.convertToVector("SAP*"));
                if (populateAttributes != null) {
                    int size = populateAttributes.getSize();
                    String attributeName = null;
                    String nameSpace = null;
                    int i = 0;
                    while (i < size) {
                        attributeName = populateAttributes.getAttributeNameOfAttributeAt(i);
                        nameSpace = populateAttributes.getNameSpaceOfAttributeAt(i);
                        if (principal.getAttributeValues(nameSpace, attributeName) == null) {
                            principal.setAttributeValues(nameSpace, attributeName, new Vector());
                        }
                        ++i;
                    }
                }
                if (principal.getIDParts()[1].equals(this.getId())) {
                    principal.setExists(true);
                }
            } else if (principalID.equals("USER.SUPERUSER_DATASOURCE.SAPASTERISK")) {
                principal.setAttributeValues("com.sap.security.core.usermanagement", "description", this.convertToVector(mUserDescription));
                principal.setAttributeValues("com.sap.security.core.usermanagement", "displayname", this.convertToVector("SAP*"));
                String now = Util.getTimeStamp();
                principal.setAttributeValues("com.sap.security.core.usermanagement", "PRINCIPAL_CREATION_DATE", this.convertToVector(now));
                principal.setAttributeValues("com.sap.security.core.usermanagement", "PRINCIPAL_MODIFY_DATE", this.convertToVector(now));
                principal.setAttributeValues("com.sap.security.core.usermanagement", "uniquename", this.convertToVector("SAP*"));
                principal.setAttributeValues("com.sap.security.core.usermanagement", "firstname", this.convertToVector(mUserFirstName));
                principal.setAttributeValues("com.sap.security.core.usermanagement", "lastname", this.convertToVector("SAP*"));
                if (populateAttributes != null) {
                    int size = populateAttributes.getSize();
                    String attributeName = null;
                    String nameSpace = null;
                    int i = 0;
                    while (i < size) {
                        attributeName = populateAttributes.getAttributeNameOfAttributeAt(i);
                        nameSpace = populateAttributes.getNameSpaceOfAttributeAt(i);
                        if (principal.getAttributeValues(nameSpace, attributeName) == null) {
                            principal.setAttributeValues(nameSpace, attributeName, new Vector());
                        }
                        ++i;
                    }
                }
                if (principal.getIDParts()[1].equals(this.getId())) {
                    principal.setExists(true);
                }
            } else if (idParts[0].equals("ROLE") && (names = principal.getAttributeValues("com.sap.security.core.usermanagement", "uniquename")) != null) {
                if (this.mRoleIDs == null) {
                    this.mRoleIDs = this.getRoleNames();
                }
                if (this.mRoleIDs != null) {
                    int roleSize = this.mRoleIDs.size();
                    int j = 0;
                    while (j < roleSize) {
                        if (names.contains(this.mRoleIDs.elementAt(j))) {
                            Vector oldMembers = principal.getAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE");
                            Vector<String> newMember = new Vector<String>();
                            newMember.add("USER.SUPERUSER_DATASOURCE.SAPASTERISK");
                            principal.setAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", this.buildUnion(new Vector[]{oldMembers, newMember}));
                            return;
                        }
                        ++j;
                    }
                }
            }
        }
    }

    public Vector getAttributeNamespaces(IPrincipalDatabag principal) throws PersistenceException {
        Vector<String> namespaces = new Vector<String>();
        if (principal != null) {
            if (principal.getUniqueID().equals("UACC.SUPERUSER_DATASOURCE.SAPASTERISK")) {
                namespaces.add("com.sap.security.core.usermanagement");
            } else if (principal.getUniqueID().equals("USER.SUPERUSER_DATASOURCE.SAPASTERISK")) {
                namespaces.add("com.sap.security.core.usermanagement");
            }
        }
        return namespaces;
    }

    public Vector getAttributeNames(IPrincipalDatabag principal, String nameSpace) throws PersistenceException {
        Vector<String> attributes = new Vector<String>();
        if (principal != null) {
            if (principal.getUniqueID().equals("UACC.SUPERUSER_DATASOURCE.SAPASTERISK") && nameSpace.equals("com.sap.security.core.usermanagement")) {
                attributes.add("userid");
                attributes.add("internalid");
                attributes.add("j_user");
                attributes.add("description");
                attributes.add("displayname");
                attributes.add("PRINCIPAL_CREATION_DATE");
                attributes.add("PRINCIPAL_MODIFY_DATE");
                attributes.add("uniquename");
            } else if (principal.getUniqueID().equals("USER.SUPERUSER_DATASOURCE.SAPASTERISK") && nameSpace.equals("com.sap.security.core.usermanagement")) {
                attributes.add("description");
                attributes.add("displayname");
                attributes.add("PRINCIPAL_CREATION_DATE");
                attributes.add("PRINCIPAL_MODIFY_DATE");
                attributes.add("uniquename");
                attributes.add("firstname");
                attributes.add("lastname");
            }
        }
        return attributes;
    }

    protected Vector convertToVector(Object o) {
        Vector<Object> newVector = new Vector<Object>();
        if (o == null) {
            return newVector;
        }
        newVector.add(o);
        return newVector;
    }
}

