/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.ISearchAttribute;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.logon.imp.AnonymousUser;
import com.sap.security.core.persistence.IInternalPrincipalDatabag;
import com.sap.security.core.persistence.IPrincipalDatabag;
import com.sap.security.core.persistence.datasource.IDataSource;
import com.sap.security.core.persistence.datasource.IDataSourceTransaction;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.datasource.imp.DSAttributeModel;
import com.sap.security.core.persistence.datasource.imp.DSConfigurationModel;
import com.sap.security.core.persistence.datasource.imp.DSNameSpaceModel;
import com.sap.security.core.persistence.datasource.imp.DSPrincipalModel;
import com.sap.security.core.persistence.datasource.imp.DataSourceBaseImplementation;
import com.sap.security.core.persistence.datasource.imp.SuperGroupsTransaction;
import com.sap.security.core.persistence.imp.SearchCriteria;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.imp.Util;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class SuperGroups
extends DataSourceBaseImplementation
implements IDataSource {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/SuperGroups.java#2 $ from $DateTime: 2004/07/30 14:01:42 $ ($Change: 16956 $)";
    private static IUMTrace mTrace;
    public static final String SUPERGROUPS_ACTIVATED = "ume.supergroups.activated";
    public static final String propEveryoneDesc = "ume.supergroups.everyone.description";
    public static final String propEveryoneDisplayName = "ume.supergroups.everyone.displayname";
    public static final String propEveryoneUniqueName = "ume.supergroups.everyone.uniquename";
    public static final String propAuthDesc = "ume.supergroups.authenticated_group.description";
    public static final String propAuthDisplayName = "ume.supergroups.authenticated_group.displayname";
    public static final String propAuthUniqueName = "ume.supergroups.authenticated_group.uniquename";
    public static final String propAnonymDesc = "ume.supergroups.anonymous_group.description";
    public static final String propAnonymDisplayName = "ume.supergroups.anonymous_group.displayname";
    public static final String propAnonymUniqueName = "ume.supergroups.anonymous_group.uniquename";
    private static final String IMPLEMENTATION_CLASS = "com.sap.security.core.persistence.datasource.imp.SuperGroups";
    private static final String mID = "SUPER_GROUPS_DATASOURCE";
    private static final String mDisplayName = "Built-in Groups Adapter";
    private static final String mEveryoneDescription = "Built-in Group Everyone";
    private static final String mEveryoneDisplayName = "Everyone";
    private static final String mEveryoneUniqueName = "Everyone";
    private static final String mEveryonePrivateIDPart = "EVERYONE";
    private static final String mEveryoneID = "GRUP.SUPER_GROUPS_DATASOURCE.EVERYONE";
    public static final String GROUP_EVERYONE_UNIQUEID = "GRUP.SUPER_GROUPS_DATASOURCE.EVERYONE";
    private static final String mAuthUserDescription = "Built-in Group Authenticated Users";
    private static final String mAuthUserDisplayName = "Authenticated Users";
    private static final String mAuthUserUniqueName = "Authenticated Users";
    private static final String mAuthUserID = "GRUP.SUPER_GROUPS_DATASOURCE.AUTHENTICATED_USERS";
    public static final String GROUP_AUTHENTICATED_USERS_UNIQUEID = "GRUP.SUPER_GROUPS_DATASOURCE.AUTHENTICATED_USERS";
    private static final String mGuestsDescription = "Built-in Group Anonymous Users";
    private static final String mGuestsDisplayName = "Anonymous Users";
    private static final String mGuestsUniqueName = "Anonymous Users";
    private static final String mGuestsID = "GRUP.SUPER_GROUPS_DATASOURCE.Anonymous Users";
    public static final String GROUP_ANONYMOUS_USERS_UNIQUEID = "GRUP.SUPER_GROUPS_DATASOURCE.Anonymous Users";
    private static final String[] mSuperGroups;
    private static final String[] mSuperGroupsDescription;
    private static final String[] mSuperGroupsDisplayName;
    private static final String[] mSuperGroupsUniqueName;

    public SuperGroups() {
        SuperGroups.mSuperGroupsDescription[0] = UMFactory.getProperties().get(propEveryoneDesc, mEveryoneDescription);
        SuperGroups.mSuperGroupsDisplayName[0] = UMFactory.getProperties().get(propEveryoneDisplayName, "Everyone");
        SuperGroups.mSuperGroupsUniqueName[0] = UMFactory.getProperties().get(propEveryoneUniqueName, "Everyone");
        SuperGroups.mSuperGroupsDescription[1] = UMFactory.getProperties().get(propAuthDesc, mAuthUserDescription);
        SuperGroups.mSuperGroupsDisplayName[1] = UMFactory.getProperties().get(propAuthDisplayName, "Authenticated Users");
        SuperGroups.mSuperGroupsUniqueName[1] = UMFactory.getProperties().get(propAuthUniqueName, "Authenticated Users");
        SuperGroups.mSuperGroupsDescription[2] = UMFactory.getProperties().get(propAnonymDesc, mGuestsDescription);
        SuperGroups.mSuperGroupsDisplayName[2] = UMFactory.getProperties().get(propAnonymDisplayName, "Anonymous Users");
        SuperGroups.mSuperGroupsUniqueName[2] = UMFactory.getProperties().get(propAnonymUniqueName, "Anonymous Users");
    }

    public String getId() {
        return mID;
    }

    public void init(DSConfigurationModel dsConf) throws PersistenceException {
        DSConfigurationModel newConfig = new DSConfigurationModel(mID, IMPLEMENTATION_CLASS, true, true, mDisplayName);
        DSPrincipalModel principalModel = new DSPrincipalModel("GRUP");
        DSNameSpaceModel nsModel1 = new DSNameSpaceModel("com.sap.security.core.usermanagement");
        DSNameSpaceModel nsModel2 = new DSNameSpaceModel("com.sap.security.core.usermanagement.relation");
        DSAttributeModel attrModel1 = new DSAttributeModel("displayname", 1, true);
        DSAttributeModel attrModel2 = new DSAttributeModel("description", 1, true);
        DSAttributeModel attrModel3 = new DSAttributeModel("uniquename", 1, true);
        DSAttributeModel attrModel4 = new DSAttributeModel("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", 1, true);
        nsModel1.setAttribute(attrModel1);
        nsModel1.setAttribute(attrModel2);
        nsModel1.setAttribute(attrModel3);
        nsModel2.setAttribute(attrModel4);
        principalModel.setNameSpace(nsModel1);
        principalModel.setNameSpace(nsModel2);
        newConfig.setResponsibleFor(principalModel);
        super.init(newConfig);
        this.isInitialized = true;
    }

    public boolean checkCredentials(Hashtable credentials) {
        return false;
    }

    protected String getPrivateIDPart(IPrincipalDatabag principal) throws PersistenceException {
        return mEveryonePrivateIDPart;
    }

    public IInternalPrincipalDatabag[] initPrincipalDatabags(IInternalPrincipalDatabag[] principals) throws PersistenceException {
        int length = principals.length;
        int i = 0;
        while (i < length) {
            if (principals[i] != null) {
                this.populatePrincipalDatabag(principals[i], null);
            }
            ++i;
        }
        return principals;
    }

    public void populatePrincipalDatabags(IInternalPrincipalDatabag[] principals, AttributeList populateAttributes) throws PersistenceException {
        principals = this.initPrincipalDatabags(principals);
    }

    private Collection getGuestUsers() {
        Collection col = null;
        try {
            AnonymousUser anonym = AnonymousUser.getInstance();
            if (anonym != null) {
                col = anonym.getGuestUserUniqueIds();
            }
        }
        catch (UMException umex) {
            mTrace.infoT("getGuestList", "Can't receive Guest List from AnonymousUserFactory.", umex);
        }
        return col;
    }

    public boolean populatePrincipalDatabag(IInternalPrincipalDatabag principal, String nameSpace, String attribute) throws PersistenceException {
        boolean found = false;
        if (principal != null) {
            this.populatePrincipalDatabag(principal, null);
            if (nameSpace.equalsIgnoreCase("com.sap.security.core.usermanagement.relation") && attribute.equalsIgnoreCase("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE") && principal.getUniqueID().equalsIgnoreCase("GRUP.SUPER_GROUPS_DATASOURCE.Anonymous Users")) {
                Vector vec = new Vector();
                Collection col = this.getGuestUsers();
                if (col != null) {
                    vec.addAll(col);
                }
                principal.setAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", vec);
                if (principal.getIDParts()[1].equals(this.getId())) {
                    principal.setExists(true);
                }
            }
            int i = 0;
            while (i < mSuperGroups.length) {
                if (principal.getUniqueID().equals(mSuperGroups[i])) {
                    if (principal.getIDParts()[1].equals(this.getId())) {
                        principal.setExists(true);
                    }
                    found = true;
                    break;
                }
                ++i;
            }
        }
        return found;
    }

    public IDataSourceTransaction beginTransaction() {
        return new SuperGroupsTransaction();
    }

    public boolean principalDatabagExists(IPrincipalDatabag principal) throws PersistenceException {
        boolean found = false;
        if (principal != null) {
            int i = 0;
            while (i < mSuperGroups.length) {
                if (principal.getUniqueID().equals(mSuperGroups[i])) {
                    found = true;
                    break;
                }
                ++i;
            }
        }
        return found;
    }

    public Vector searchPrincipalDatabags(SearchCriteria criteria) throws PersistenceException {
        String type = criteria.getPrincipalType();
        SearchCriteria newSc = new SearchCriteria(criteria.isOrMode(), type);
        int size = criteria.getElementSize();
        int i = 0;
        while (i < size) {
            block18: {
                String attribute;
                String namespace;
                ISearchAttribute se;
                block17: {
                    se = criteria.getAttribute(i);
                    namespace = se.getAttributeNameSpace();
                    attribute = se.getAttributeName();
                    if (!namespace.equals("com.sap.security.core.usermanagement")) break block17;
                    if (!type.equals("GRUP") || !attribute.equals("description") && !attribute.equals("displayname") && !attribute.equals("uniquename")) break block18;
                    int operatore = se.getOperator();
                    switch (operatore) {
                        case 0: {
                            newSc.addEqualsElement(namespace, attribute, se.getAttributeValue(), se.isCaseSensitive());
                            break block18;
                        }
                        case 1: {
                            newSc.addLikeElement(namespace, attribute, se.getAttributeValue(), se.isCaseSensitive());
                            break block18;
                        }
                        case 2: {
                            newSc.addGreaterThanElement(namespace, attribute, se.getAttributeValue(), se.isCaseSensitive());
                            break block18;
                        }
                        case 3: {
                            newSc.addLessThanElement(namespace, attribute, se.getAttributeValue(), se.isCaseSensitive());
                            break block18;
                        }
                        default: {
                            throw new PersistenceException("Unknown search operator!");
                        }
                    }
                }
                if (type.equals("GRUP") && namespace.equals("com.sap.security.core.usermanagement.relation") && attribute.equals("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE")) {
                    Vector<String> res = new Vector<String>();
                    String attributeValue = (String)se.getAttributeValue();
                    if (attributeValue != null) {
                        if (attributeValue.startsWith("USER")) {
                            res.add(mSuperGroups[0]);
                            Collection guestUsers = this.getGuestUsers();
                            if (guestUsers != null) {
                                if (guestUsers.contains(attributeValue)) {
                                    res.add(mSuperGroups[2]);
                                } else {
                                    res.add(mSuperGroups[1]);
                                }
                            }
                        }
                        return res;
                    }
                    return res;
                }
            }
            ++i;
        }
        Vector<String> result = new Vector<String>();
        if (type.equals("GRUP")) {
            if (newSc.getElementSize() == 1) {
                return null;
            }
            Properties p = new Properties();
            int i2 = 0;
            while (i2 < mSuperGroups.length) {
                ((Hashtable)p).put("com.sap.security.core.usermanagement.description", new String[]{mSuperGroupsDescription[i2]});
                ((Hashtable)p).put("com.sap.security.core.usermanagement.displayname", new String[]{mSuperGroupsDisplayName[i2]});
                ((Hashtable)p).put("com.sap.security.core.usermanagement.uniquename", new String[]{mSuperGroupsUniqueName[i2]});
                if (this.objectMatchesSearch(p, newSc)) {
                    result.add(mSuperGroups[i2]);
                }
                ++i2;
            }
            return result;
        }
        return null;
    }

    private boolean objectMatchesSearch(Properties object, SearchCriteria criteria) throws PersistenceException {
        if (object == null) {
            return false;
        }
        int size = criteria.getElementSize();
        boolean orMode = criteria.isOrMode();
        if (orMode) {
            boolean found = false;
            int counter = 0;
            while (!found && counter < size) {
                ISearchAttribute se = criteria.getAttribute(counter);
                if (!se.getAttributeNameSpace().equals("com.sap.security.core.usermanagement") || !se.getAttributeName().equals("PRINCIPAL_TYPE_ATTRIBUTE")) {
                    found = this.objectMatchesSearchElement(object, se);
                }
                ++counter;
            }
            return found;
        }
        boolean allMatched = true;
        int counter = 0;
        while (allMatched && counter < size) {
            ISearchAttribute se = criteria.getAttribute(counter);
            if (!se.getAttributeNameSpace().equals("com.sap.security.core.usermanagement") || !se.getAttributeName().equals("PRINCIPAL_TYPE_ATTRIBUTE")) {
                allMatched = allMatched && this.objectMatchesSearchElement(object, se);
            } else if (criteria.getElementSize() == 1) {
                return false;
            }
            ++counter;
        }
        return allMatched;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private boolean objectMatchesSearchElement(Properties p, ISearchAttribute se) throws PersistenceException {
        o = se.getAttributeValue();
        caseSensitive = se.isCaseSensitive();
        header = se.getAttributeNameSpace() + "." + se.getAttributeName();
        splitValues = (String[])p.get(header);
        found = false;
        size = splitValues.length;
        counter = 0;
        while (!found && counter < size) {
            block20: {
                block21: {
                    if (!(o instanceof String)) break block21;
                    value = splitValues[counter];
                    switch (se.getOperator()) {
                        case 0: {
                            if (caseSensitive) {
                                found = value.equals((String)o);
                                break;
                            }
                            found = value.equalsIgnoreCase((String)o);
                            break;
                        }
                        case 1: {
                            if (o.equals("*")) {
                                found = true;
                                break;
                            }
                            strt = caseSensitive != false ? new StringTokenizer((String)o, "*", false) : new StringTokenizer(((String)o).toUpperCase(), "*", false);
                            startsWith = ((String)o).startsWith("*") == false;
                            endsWith = ((String)o).endsWith("*") == false;
                            lastIndex = -1;
                            found = true;
                            isFirstElement = true;
                            while (strt.hasMoreTokens()) {
                                if (found) {
                                    currentToken = strt.nextToken();
                                    currentIndex = caseSensitive != false ? value.indexOf(currentToken) : value.toUpperCase().indexOf(currentToken);
                                    found = isFirstElement && startsWith ? (caseSensitive ? value.startsWith(currentToken) : value.toUpperCase().startsWith(currentToken)) : (!strt.hasMoreTokens() && endsWith ? (caseSensitive ? value.endsWith(currentToken) : value.toUpperCase().endsWith(currentToken)) : currentIndex > lastIndex);
                                    lastIndex = currentIndex;
                                    isFirstElement = false;
                                    continue;
                                }
                                break block20;
                            }
                            break block20;
                        }
                        case 2: {
                            if (caseSensitive) {
                                found = value.compareTo((String)o) > 0;
                                break;
                            }
                            found = value.toLowerCase().compareTo(((String)o).toLowerCase()) > 0;
                            break;
                        }
                        case 3: {
                            if (caseSensitive) {
                                found = value.compareTo((String)o) < 0;
                                break;
                            }
                            found = value.toLowerCase().compareTo(((String)o).toLowerCase()) < 0;
                            break;
                        }
                        default: {
                            errorMessage = "Unsupported search element operator found!";
                            throw new PersistenceException(errorMessage);
                        }
                    }
                    break block20;
                }
                if (!(o instanceof byte[])) {
                    errorMessage = "Unsupported object type: " + o.getClass();
                    throw new PersistenceException(errorMessage);
                }
                blob = Util.decodeToByteArray(splitValues[counter]);
                switch (se.getOperator()) {
                    case 0: {
                        found = blob.equals((byte[])o);
                        ** break;
                    }
                    case 1: {
                        errorMessage = "Unsupported search element operator found: like cannot be used for blobs!";
                        throw new PersistenceException(errorMessage);
                    }
                    case 2: {
                        errorMessage = "Unsupported search element operator found: greater than cannot be used for blobs!";
                        throw new PersistenceException(errorMessage);
                    }
                    case 3: {
                        errorMessage = "Unsupported search element operator found: less than cannot be used for blobs!";
                        throw new PersistenceException(errorMessage);
                    }
                }
                errorMessage = "Unsupported search element operator found!";
                throw new PersistenceException(errorMessage);
            }
            ++counter;
        }
        return found;
    }

    public void populatePrincipalDatabag(IInternalPrincipalDatabag principal, AttributeList populateAttributes) throws PersistenceException {
        if (principal != null) {
            int i = 0;
            while (i < mSuperGroups.length) {
                if (principal.getUniqueID().equalsIgnoreCase(mSuperGroups[i])) {
                    principal.setAttributeValues("com.sap.security.core.usermanagement", "description", this.convertToVector(mSuperGroupsDescription[i]));
                    principal.setAttributeValues("com.sap.security.core.usermanagement", "displayname", this.convertToVector(mSuperGroupsDisplayName[i]));
                    String now = Util.getTimeStamp();
                    principal.setAttributeValues("com.sap.security.core.usermanagement", "PRINCIPAL_CREATION_DATE", this.convertToVector(now));
                    principal.setAttributeValues("com.sap.security.core.usermanagement", "PRINCIPAL_MODIFY_DATE", this.convertToVector(now));
                    principal.setAttributeValues("com.sap.security.core.usermanagement", "uniquename", this.convertToVector(mSuperGroupsUniqueName[i]));
                    if (populateAttributes != null) {
                        int size = populateAttributes.getSize();
                        String attributeName = null;
                        String nameSpace = null;
                        int j = 0;
                        while (j < size) {
                            attributeName = populateAttributes.getAttributeNameOfAttributeAt(j);
                            nameSpace = populateAttributes.getNameSpaceOfAttributeAt(j);
                            if (principal.getAttributeValues(nameSpace, attributeName) == null) {
                                principal.setAttributeValues(nameSpace, attributeName, new Vector());
                            }
                            ++j;
                        }
                    }
                    if (principal.getIDParts()[1].equals(this.getId())) {
                        principal.setExists(true);
                    }
                }
                ++i;
            }
        }
    }

    public Vector getAttributeNamespaces(IPrincipalDatabag principal) throws PersistenceException {
        Vector<String> namespaces = new Vector<String>();
        if (principal != null) {
            int i = 0;
            while (i < mSuperGroups.length) {
                if (principal.getUniqueID().equals(mSuperGroups[i])) {
                    namespaces.add("com.sap.security.core.usermanagement");
                }
                ++i;
            }
        }
        return namespaces;
    }

    public Vector getAttributeNames(IPrincipalDatabag principal, String nameSpace) throws PersistenceException {
        Vector<String> attributes = new Vector<String>();
        if (principal != null) {
            int i = 0;
            while (i < mSuperGroups.length) {
                if (principal.getUniqueID().equals(mSuperGroups[i]) && nameSpace.equals("com.sap.security.core.usermanagement")) {
                    attributes.add("description");
                    attributes.add("displayname");
                    attributes.add("PRINCIPAL_CREATION_DATE");
                    attributes.add("PRINCIPAL_MODIFY_DATE");
                    attributes.add("uniquename");
                }
                ++i;
            }
        }
        return attributes;
    }

    protected Vector convertToVector(Object o) {
        Vector<Object> newVector = new Vector<Object>();
        if (o == null) {
            return newVector;
        }
        newVector.add(o);
        return newVector;
    }

    static {
        mSuperGroups = new String[]{"GRUP.SUPER_GROUPS_DATASOURCE.EVERYONE", "GRUP.SUPER_GROUPS_DATASOURCE.AUTHENTICATED_USERS", "GRUP.SUPER_GROUPS_DATASOURCE.Anonymous Users"};
        mSuperGroupsDescription = new String[]{mEveryoneDescription, mAuthUserDescription, mGuestsDescription};
        mSuperGroupsDisplayName = new String[]{"Everyone", "Authenticated Users", "Anonymous Users"};
        mSuperGroupsUniqueName = new String[]{"Everyone", "Authenticated Users", "Anonymous Users"};
        mTrace = InternalUMFactory.getTrace(VERSIONSTRING);
    }
}

