/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp;

import com.sap.security.core.persistence.datasource.imp.JNDIUtils;
import com.sap.security.core.util.imp.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;
import javax.transaction.UserTransaction;

public class SP0_TO_SP1 {
    public static final String ORA = "Oracle";
    public static final String MSS = "Microsoft SQL Server";
    public static final String ADA = "SAP DB";
    public static final String PRINCIPAL_ID_SEPARATOR = ".";
    public static final int MAX_ACTIONS_IN_BATCH = 5000;
    private static String[] SQL_STATEMENTS_PHASE1_MSS = new String[]{"DROP INDEX UME_STRINGS.UME_IX_STRINGS1", "DROP INDEX UME_STRINGS.UME_IX_STRINGS2", "DROP INDEX UME_STRINGS.UME_IX_STRINGS3", "DROP INDEX UME_BLOBS.UME_IX_BLOBS1", "DROP INDEX UME_BLOBS.UME_IX_BLOBS2", "DROP INDEX UME_ACL_MANAGER.UME_UQ_ACL_MGR", "DROP INDEX UME_ACL_PERM.UME_UQ_ACLPERM_2", "DROP INDEX UME_ACL_SUP_PERM.UME_UQ_ACL_SUPP2", "DROP INDEX UME_ACL_ACLENTRY.UME_IX_ACE_RIDST", "DROP INDEX UME_ACL_OWNER.UME_IX_ACLOWNER3", "DROP INDEX UME_ACL_ACL.UME_IX_ACL_RIDST", "DROP INDEX UME_USERSYNC.UME_IX_USERSYNC1", "DROP INDEX UME_USERSYNC.UME_IX_USERSYNC2", "DROP INDEX UME_USERSYNCTEMP.UME_UQ_SYNCTEMP", "ALTER TABLE UME_STRINGS ALTER COLUMN PID NVARCHAR(255) NULL", "ALTER TABLE UME_STRINGS ALTER COLUMN NAMESP NVARCHAR(255) NULL", "ALTER TABLE UME_STRINGS ALTER COLUMN ATTR NVARCHAR(255) NULL", "ALTER TABLE UME_STRINGS ALTER COLUMN VAL NVARCHAR(255) NULL", "ALTER TABLE UME_STRINGS ALTER COLUMN UPPERVAL NVARCHAR(255) NULL", "ALTER TABLE UME_BLOBS ALTER COLUMN PID NVARCHAR(255) NULL", "ALTER TABLE UME_BLOBS ALTER COLUMN NAMESP NVARCHAR(255) NULL", "ALTER TABLE UME_BLOBS ALTER COLUMN ATTR NVARCHAR(255) NULL", "ALTER TABLE UME_STRINGS ADD PIDH BIGINT", "ALTER TABLE UME_STRINGS ADD NAMESPH BIGINT", "ALTER TABLE UME_STRINGS ADD ATTRH BIGINT", "ALTER TABLE UME_STRINGS ADD VALH BIGINT", "ALTER TABLE UME_STRINGS ADD UPPERVALH BIGINT", "ALTER TABLE UME_BLOBS ADD PIDH BIGINT", "ALTER TABLE UME_BLOBS ADD NAMESPH BIGINT", "ALTER TABLE UME_BLOBS ADD ATTRH BIGINT", "ALTER TABLE UME_ACL_ACL ADD RIDSTARTH BIGINT", "ALTER TABLE UME_ACL_ACLENTRY ADD RIDSTARTH BIGINT", "ALTER TABLE UME_ACL_OWNER ADD RIDSTARTH BIGINT", "ALTER TABLE UME_ACL_PERM ADD PERMISSION_NAMEH BIGINT", "ALTER TABLE UME_ACL_SUP_PERM ADD PERMISSION_NAMEH BIGINT", "ALTER TABLE UME_ACL_SUP_PERM ADD OBJECT_TYPEH BIGINT", "ALTER TABLE UME_ACL_ACLENTRY ALTER COLUMN PRINCIPAL_NAME NVARCHAR(255) NULL", "ALTER TABLE UME_ACL_OWNER ALTER COLUMN PRINCIPAL_NAME NVARCHAR(255) NULL", "ALTER TABLE UME_USERSYNC ADD USER_IDH BIGINT", "ALTER TABLE UME_USERSYNC ADD ADAPTER_IDH BIGINT", "ALTER TABLE UME_USERSYNC ADD ADAPTER_CLASSH BIGINT", "ALTER TABLE UME_USERSYNC ADD OPERATION_NAMEH BIGINT", "ALTER TABLE UME_USERSYNCTEMP ADD USER_IDH BIGINT", "ALTER TABLE UME_USERSYNCTEMP ADD OPERATION_NAMEH BIGINT", "ALTER TABLE UME_USERSYNC ALTER COLUMN USER_ID NVARCHAR (255) NULL", "ALTER TABLE UME_USERSYNC ALTER COLUMN ADAPTER_CLASS NVARCHAR (255) NULL", "ALTER TABLE UME_USERSYNC ALTER COLUMN ERROR NVARCHAR (255) NULL", "ALTER TABLE UME_USERSYNCTEMP ALTER COLUMN USER_ID NVARCHAR (255) NULL", "CREATE INDEX UME_IX_BLOBS1 ON UME_BLOBS (PIDH, NAMESPH, ATTRH)", "CREATE INDEX UME_IX_BLOBS2 ON UME_BLOBS (NAMESPH, ATTRH)", "CREATE INDEX UME_IX_STRINGS1 ON UME_STRINGS (PIDH, NAMESPH, ATTRH)", "CREATE INDEX UME_IX_STRINGS2 ON UME_STRINGS (NAMESPH, ATTRH, VALH)", "CREATE INDEX UME_IX_STRINGS3 ON UME_STRINGS (NAMESPH, ATTRH, UPPERVALH)", "CREATE INDEX UME_IX_ACLPERM_2 ON UME_ACL_PERM (OWNERID, PERMISSION_NAMEH)", "CREATE INDEX UME_IX_ACL_SUPP2 ON UME_ACL_SUP_PERM (OWNERID, PERMISSION_NAMEH, OBJECT_TYPEH)", "CREATE INDEX UME_IX_ACE_RIDST ON UME_ACL_ACLENTRY (RIDSTARTH)", "CREATE INDEX UME_IX_ACLOWNER3 ON UME_ACL_OWNER (RIDSTARTH)", "CREATE INDEX UME_IX_ACL_RIDST ON UME_ACL_ACL (RIDSTARTH)", "CREATE INDEX UME_IX_USERSYNC2 ON UME_USERSYNC (USER_IDH)", "CREATE INDEX UME_IX_USERSYNC1 ON UME_USERSYNC (ADAPTER_IDH, ADAPTER_CLASSH, OPERATION_NAMEH)", "CREATE INDEX UME_IX_SYNCTEMP ON UME_USERSYNCTEMP (USER_IDH, OPERATION_NAMEH)", "UPDATE UME_STRINGS SET VAL=' ',UPPERVAL=' ' WHERE VAL='EMPTYSTRINGREPLACEMENT'"};
    private static String[] SQL_STATEMENTS_PHASE1_ORA = new String[]{"DROP INDEX UME_IX_STRINGS1", "DROP INDEX UME_IX_STRINGS2", "DROP INDEX UME_IX_STRINGS3", "DROP INDEX UME_IX_BLOBS1", "DROP INDEX UME_IX_BLOBS2", "DROP INDEX UME_UQ_ACL_MGR", "DROP INDEX UME_UQ_ACLPERM_2", "DROP INDEX UME_UQ_ACL_SUPP2", "DROP INDEX UME_IX_ACE_RIDST", "DROP INDEX UME_IX_ACLOWNER3", "DROP INDEX UME_IX_ACL_RIDST", "DROP INDEX UME_IX_USERSYNC1", "DROP INDEX UME_IX_USERSYNC2", "DROP INDEX UME_UQ_SYNCTEMP", "ALTER TABLE UME_STRINGS MODIFY(PID NVARCHAR2(255) NULL)", "ALTER TABLE UME_STRINGS MODIFY(NAMESP NVARCHAR2(255) NULL)", "ALTER TABLE UME_STRINGS MODIFY(ATTR NVARCHAR2(255) NULL)", "ALTER TABLE UME_STRINGS MODIFY(VAL NVARCHAR2(255) NULL)", "ALTER TABLE UME_STRINGS MODIFY(UPPERVAL NVARCHAR2(255))", "ALTER TABLE UME_BLOBS MODIFY(PID NVARCHAR2(255) NULL)", "ALTER TABLE UME_BLOBS MODIFY(NAMESP NVARCHAR2(255) NULL)", "ALTER TABLE UME_BLOBS MODIFY(ATTR NVARCHAR2(255) NULL)", "ALTER TABLE UME_STRINGS ADD PIDH NUMBER(19,0)", "ALTER TABLE UME_STRINGS ADD NAMESPH NUMBER(19,0)", "ALTER TABLE UME_STRINGS ADD ATTRH NUMBER(19,0)", "ALTER TABLE UME_STRINGS ADD VALH NUMBER(19,0)", "ALTER TABLE UME_STRINGS ADD UPPERVALH NUMBER(19,0)", "ALTER TABLE UME_BLOBS ADD PIDH NUMBER(19,0)", "ALTER TABLE UME_BLOBS ADD NAMESPH NUMBER(19,0)", "ALTER TABLE UME_BLOBS ADD ATTRH NUMBER(19,0)", "ALTER TABLE UME_ACL_ACL ADD RIDSTARTH NUMBER(19,0)", "ALTER TABLE UME_ACL_ACLENTRY ADD RIDSTARTH NUMBER(19,0)", "ALTER TABLE UME_ACL_OWNER ADD RIDSTARTH NUMBER(19,0)", "ALTER TABLE UME_ACL_PERM ADD PERMISSION_NAMEH NUMBER(19,0)", "ALTER TABLE UME_ACL_SUP_PERM ADD PERMISSION_NAMEH NUMBER(19,0)", "ALTER TABLE UME_ACL_SUP_PERM ADD OBJECT_TYPEH NUMBER(19,0)", "ALTER TABLE UME_USERSYNC ADD USER_IDH NUMBER(19,0)", "ALTER TABLE UME_USERSYNC ADD ADAPTER_IDH NUMBER(19,0)", "ALTER TABLE UME_USERSYNC ADD ADAPTER_CLASSH NUMBER(19,0)", "ALTER TABLE UME_USERSYNC ADD OPERATION_NAMEH NUMBER(19,0)", "ALTER TABLE UME_USERSYNCTEMP ADD USER_IDH NUMBER(19,0)", "ALTER TABLE UME_USERSYNCTEMP ADD OPERATION_NAMEH NUMBER(19,0)", "ALTER TABLE UME_ACL_ACLENTRY MODIFY(PRINCIPAL_NAME NVARCHAR2(255) NULL)", "ALTER TABLE UME_ACL_OWNER MODIFY(PRINCIPAL_NAME NVARCHAR2(255) NULL)", "ALTER TABLE UME_USERSYNC MODIFY(USER_ID NVARCHAR2 (255) NULL)", "ALTER TABLE UME_USERSYNC MODIFY(ADAPTER_CLASS NVARCHAR2 (255) NULL)", "ALTER TABLE UME_USERSYNC MODIFY(ERROR NVARCHAR2 (255) NULL)", "ALTER TABLE UME_USERSYNCTEMP MODIFY(USER_ID NVARCHAR2 (255) NULL)", "CREATE INDEX UME_IX_BLOBS1 ON UME_BLOBS (PIDH, NAMESPH, ATTRH)", "CREATE INDEX UME_IX_BLOBS2 ON UME_BLOBS (NAMESPH, ATTRH)", "CREATE INDEX UME_IX_STRINGS1 ON UME_STRINGS (PIDH, NAMESPH, ATTRH)", "CREATE INDEX UME_IX_STRINGS2 ON UME_STRINGS (NAMESPH, ATTRH, VALH)", "CREATE INDEX UME_IX_STRINGS3 ON UME_STRINGS (NAMESPH, ATTRH, UPPERVALH)", "CREATE INDEX UME_IX_ACLPERM_2 ON UME_ACL_PERM (OWNERID, PERMISSION_NAMEH)", "CREATE INDEX UME_IX_ACL_SUPP2 ON UME_ACL_SUP_PERM (OWNERID, PERMISSION_NAMEH, OBJECT_TYPEH)", "CREATE INDEX UME_IX_ACE_RIDST ON UME_ACL_ACLENTRY (RIDSTARTH)", "CREATE INDEX UME_IX_ACLOWNER3 ON UME_ACL_OWNER (RIDSTARTH)", "CREATE INDEX UME_IX_ACL_RIDST ON UME_ACL_ACL (RIDSTARTH)", "CREATE INDEX UME_IX_USERSYNC2 ON UME_USERSYNC (USER_IDH)", "CREATE INDEX UME_IX_USERSYNC1 ON UME_USERSYNC (ADAPTER_IDH, ADAPTER_CLASSH, OPERATION_NAMEH)", "CREATE INDEX UME_IX_SYNCTEMP ON UME_USERSYNCTEMP (USER_IDH, OPERATION_NAMEH)", "UPDATE UME_STRINGS SET VAL=' ',UPPERVAL=' ' WHERE VAL='EMPTYSTRINGREPLACEMENT'", "ALTER TABLE UME_USERSYNC ADD DETAILSTEMP NCLOB", "UPDATE UME_USERSYNC SET DETAILSTEMP=TO_NCLOB(DETAILS)", "ALTER TABLE UME_USERSYNC DROP COLUMN DETAILS", "ALTER TABLE UME_USERSYNC ADD DETAILS NCLOB", "UPDATE UME_USERSYNC SET DETAILS=DETAILSTEMP", "ALTER TABLE UME_USERSYNC DROP COLUMN DETAILSTEMP"};
    private static String[] SQL_STATEMENTS_PHASE2 = new String[]{"SELECT ATTRGUID,PID,NAMESP,ATTR,VAL,UPPERVAL FROM UME_STRINGS", "SELECT ATTRGUID,PID,NAMESP,ATTR FROM UME_BLOBS", "SELECT RIDSTART,OWNERID,RID FROM UME_ACL_ACL", "SELECT RIDSTART,OWNERID,RID FROM UME_ACL_ACLENTRY", "SELECT RIDSTART,OWNERID,RID FROM UME_ACL_OWNER", "SELECT PERMISSION_NAME,OWNERID FROM UME_ACL_PERM", "SELECT PERMISSION_NAME,OWNERID,OBJECT_TYPE FROM UME_ACL_SUP_PERM", "SELECT ID,USER_ID,ADAPTER_ID,ADAPTER_CLASS,OPERATION_NAME FROM UME_USERSYNC", "SELECT ID,USER_ID,OPERATION_NAME FROM UME_USERSYNCTEMP", "SELECT ATTRGUID,PID,ATTR,VAL FROM UME_BLOBS WHERE NAMESP=?", "SELECT ATTRGUID,VAL FROM UME_STRINGS WHERE ((NAMESP=? AND ATTR=?) AND (VAL LIKE ? OR VAL LIKE ? OR VAL LIKE ?))", "SELECT ATTRGUID,PID FROM UME_STRINGS WHERE PID LIKE ? OR PID LIKE ? OR PID LIKE ?", "SELECT ATTRGUID,PID FROM UME_BLOBS WHERE PID LIKE ? OR PID LIKE ? OR PID LIKE ?", "SELECT ID,PRINCIPAL_NAME FROM UME_ACL_ACLENTRY WHERE PRINCIPAL_NAME LIKE ? OR PRINCIPAL_NAME LIKE ? OR PRINCIPAL_NAME LIKE ?", "SELECT OWNERID,RID,PRINCIPAL_NAME FROM UME_ACL_OWNER WHERE PRINCIPAL_NAME LIKE ? OR PRINCIPAL_NAME LIKE ? OR PRINCIPAL_NAME LIKE ?"};
    private static String[] SQL_STATEMENTS_PHASE3 = new String[]{"UPDATE UME_STRINGS SET PIDH=?,NAMESPH=?,ATTRH=?,VALH=?,UPPERVALH=? WHERE ATTRGUID=?", "UPDATE UME_BLOBS SET PIDH=?,NAMESPH=?,ATTRH=? WHERE ATTRGUID=?", "UPDATE UME_ACL_ACL SET RIDSTARTH=? WHERE OWNERID=? AND RID=?", "UPDATE UME_ACL_ACLENTRY SET RIDSTARTH=? WHERE OWNERID=? AND RID=?", "UPDATE UME_ACL_OWNER SET RIDSTARTH=? WHERE OWNERID=? AND RID=?", "UPDATE UME_ACL_PERM SET PERMISSION_NAMEH=? WHERE OWNERID=? AND PERMISSION_NAME=?", "UPDATE UME_ACL_SUP_PERM SET PERMISSION_NAMEH=?,OBJECT_TYPEH=? WHERE OWNERID=? AND PERMISSION_NAME=?", "UPDATE UME_USERSYNC SET USER_IDH=?,ADAPTER_IDH=?,ADAPTER_CLASSH=?,OPERATION_NAMEH=? WHERE ID=?", "UPDATE UME_USERSYNCTEMP SET USER_IDH=?,OPERATION_NAMEH=? WHERE ID=?", "UPDATE UME_BLOBS SET ATTR=?,ATTRH=? WHERE ATTRGUID=?", "INSERT INTO UME_STRINGS (PID,PIDH,NAMESP,NAMESPH,ATTR,ATTRH,ATTRGUID,VAL,VALH,UPPERVAL,UPPERVALH) VALUES (?,?,?,?,?,?,?,?,?,?,?)", "DELETE FROM UME_STRINGS WHERE NAMESP=?", "UPDATE UME_STRINGS SET VAL=?, UPPERVAL=? WHERE ATTRGUID=?", "UPDATE UME_STRINGS SET PID=? WHERE ATTRGUID=?", "UPDATE UME_BLOBS SET PID=? WHERE ATTRGUID=?", "UPDATE UME_ACL_ACLENTRY SET PRINCIPAL_NAME=? WHERE ID=?", "UPDATE UME_ACL_OWNER SET PRINCIPAL_NAME=? WHERE OWNERID=? AND RID=? AND PRINCIPAL_NAME=?"};

    /*
     * Unable to fully structure code
     */
    public static Vector changeSchema(Connection dbConnection, UserTransaction userTransaction, String dbVendor) {
        result = new Vector<String>();
        SQL_STATEMENTS_PHASE1 = new String[]{};
        if (dbVendor.equalsIgnoreCase("Oracle") || dbVendor.equalsIgnoreCase("ORA")) {
            SQL_STATEMENTS_PHASE1 = SP0_TO_SP1.SQL_STATEMENTS_PHASE1_ORA;
        } else if (dbVendor.equalsIgnoreCase("Microsoft SQL Server") || dbVendor.equalsIgnoreCase("MSS")) {
            SQL_STATEMENTS_PHASE1 = SP0_TO_SP1.SQL_STATEMENTS_PHASE1_MSS;
        } else {
            result.add("WARNING: unsupported db vendor found (vendor=" + dbVendor + ")");
            return result;
        }
        stmt = null;
        result.add("INFO: start changing DB schema (vendor=" + dbVendor + ")");
        i = 0;
        while (i < SQL_STATEMENTS_PHASE1.length) {
            block22: {
                try {
                    stmt = dbConnection.prepareStatement(SQL_STATEMENTS_PHASE1[i]);
                    stmt.executeUpdate();
                    var9_10 = null;
                    ** if (stmt == null) goto lbl-1000
                }
                catch (Throwable var8_12) {
                    var9_10 = null;
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException sqlex) {
                            result.add("WARNING: Error while closing statement: " + sqlex.getMessage());
                        }
                    }
                    throw var8_12;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqlex) {
                        result.add("WARNING: Error while closing statement: " + sqlex.getMessage());
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block22;
                    catch (SQLException sqlex) {
                        result.add("WARNING: " + sqlex.getMessage());
                        var9_10 = null;
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (SQLException sqlex) {
                                result.add("WARNING: Error while closing statement: " + sqlex.getMessage());
                            }
                        }
                    }
                }
            }
            ++i;
        }
        try {
            if (userTransaction == null) {
                dbConnection.commit();
                result.add("INFO: changing DB schema finished successfully.");
            } else {
                try {
                    userTransaction.commit();
                    result.add("INFO: changing DB schema finished successfully.");
                }
                catch (Exception ex) {
                    result.add("ERROR: error occured while changing DB schema :" + ex.getMessage());
                }
            }
        }
        catch (SQLException sqlex) {
            result.add("ERROR: error occured while changing DB schema :" + sqlex.getMessage());
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static Vector convertData(Connection dbConnection, UserTransaction userTransaction) {
        result = new Vector<String>();
        try {
            result.add("INFO: start processing usermapping entries in table UME_BLOBS");
            stmt = dbConnection.prepareStatement(SP0_TO_SP1.SQL_STATEMENTS_PHASE2[9]);
            stmt.setString(1, "$usermapping$");
            updateStatement = dbConnection.prepareStatement(SP0_TO_SP1.SQL_STATEMENTS_PHASE3[9]);
            insertStatement = dbConnection.prepareStatement(SP0_TO_SP1.SQL_STATEMENTS_PHASE3[10]);
            deleteStatement = dbConnection.prepareStatement(SP0_TO_SP1.SQL_STATEMENTS_PHASE3[11]);
            deleteStatement.setString(1, "$inverse_usermapping$");
            deleteStatement.executeUpdate();
            rs = stmt.executeQuery();
            counter = 0;
            objectNumber = 0;
            insertNumber = 0;
            is = null;
            mappedUser = null;
            userMapp = null;
            while (rs.next()) {
                block80: {
                    mappedUser = null;
                    attrguid = rs.getString("ATTRGUID");
                    attr = rs.getString("ATTR");
                    pid = rs.getString("PID");
                    try {
                        is = rs.getBinaryStream("VAL");
                        aReadBuffer = new byte[1024];
                        iBytesRead = 0;
                        bBuffer = new ByteArrayOutputStream();
                        while ((iBytesRead = is.read(aReadBuffer)) >= 0) {
                            bBuffer.write(aReadBuffer, 0, iBytesRead);
                        }
                        userMapp = SP0_TO_SP1.deserializeMap(bBuffer.toByteArray());
                        mappedUser = (String)userMapp.get("user");
                        var30_29 = null;
                        ** if (is == null) goto lbl-1000
                    }
                    catch (Throwable var29_31) {
                        var30_29 = null;
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException ioex) {
                                result.add("WARNING: Error while closing input stream: " + ioex.getMessage());
                            }
                        }
                        throw var29_31;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            is.close();
                        }
                        catch (IOException ioex) {
                            result.add("WARNING: Error while closing input stream: " + ioex.getMessage());
                        }
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block80;
                        catch (IOException ioex) {
                            result.add("ERROR: " + ioex.getMessage());
                            var30_29 = null;
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException ioex) {
                                    result.add("WARNING: Error while closing input stream: " + ioex.getMessage());
                                }
                            }
                            break block80;
                        }
                        catch (NullPointerException npex) {
                            result.add("ERROR: " + npex.getMessage());
                            var30_29 = null;
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException ioex) {
                                    result.add("WARNING: Error while closing input stream: " + ioex.getMessage());
                                }
                            }
                        }
                    }
                }
                if (!attr.startsWith("ep6_sl_alias:")) {
                    attr = "ep6_sl_alias:" + attr;
                }
                updateStatement.setString(1, attr);
                updateStatement.setLong(2, Util.getHash(attr));
                updateStatement.setString(3, attrguid);
                updateStatement.addBatch();
                if (mappedUser != null) {
                    insertStatement.setString(1, pid);
                    insertStatement.setLong(2, Util.getHash(pid));
                    namesp = "$inverse_usermapping$";
                    insertStatement.setString(3, namesp);
                    insertStatement.setLong(4, Util.getHash(namesp));
                    insertStatement.setString(5, attr);
                    insertStatement.setLong(6, Util.getHash(attr));
                    insertStatement.setString(7, Util.createGUID());
                    val = mappedUser.equals("") != false ? " " : mappedUser;
                    insertStatement.setString(8, val);
                    insertStatement.setLong(9, Util.getHash(val));
                    upperval = val.toUpperCase();
                    insertStatement.setString(10, upperval);
                    insertStatement.setLong(11, Util.getHash(upperval));
                    insertStatement.addBatch();
                    ++insertNumber;
                } else {
                    result.add("WARNING: no user found in map (ATTRGUID=\"" + attrguid + "\")");
                }
                ++objectNumber;
                if (++counter != 5000) continue;
                counter = 0;
                updateStatement.executeBatch();
                insertStatement.executeBatch();
                if (userTransaction == null) {
                    dbConnection.commit();
                    continue;
                }
                userTransaction.commit();
            }
            updateStatement.executeBatch();
            insertStatement.executeBatch();
            if (userTransaction == null) {
                dbConnection.commit();
            } else {
                userTransaction.commit();
            }
            result.add("INFO: " + objectNumber + " usermapping entries in table UME_BLOBS successfully converted.");
            result.add("INFO: " + insertNumber + " usermapping entries in table UME_STRINGS successfully created.");
            updateStatement.close();
            rs.close();
            stmt.close();
            result.add("INFO: start processing LDAP members in table UME_STRINGS");
            stmt = dbConnection.prepareStatement(SP0_TO_SP1.SQL_STATEMENTS_PHASE2[10]);
            stmt.setString(1, "com.sap.security.core.usermanagement.relation");
            stmt.setString(2, "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE");
            stmt.setString(3, "USER%");
            stmt.setString(4, "UACC%");
            stmt.setString(5, "GRUP%");
            updateStatement = dbConnection.prepareStatement(SP0_TO_SP1.SQL_STATEMENTS_PHASE3[12]);
            rs = stmt.executeQuery();
            counter = 0;
            objectNumber = 0;
            ldapDN = null;
            while (rs.next()) {
                attrguid = rs.getString("ATTRGUID");
                val = rs.getString("VAL");
                ldapDN = SP0_TO_SP1.convertLDAPDN(val);
                if (ldapDN == null) continue;
                updateStatement.setString(1, ldapDN);
                updateStatement.setString(2, ldapDN.toUpperCase());
                updateStatement.setString(3, attrguid);
                updateStatement.addBatch();
                ++objectNumber;
                if (++counter != 5000) continue;
                counter = 0;
                updateStatement.executeBatch();
                if (userTransaction == null) {
                    dbConnection.commit();
                    continue;
                }
                userTransaction.commit();
            }
            updateStatement.executeBatch();
            if (userTransaction == null) {
                dbConnection.commit();
            } else {
                userTransaction.commit();
            }
            result.add("INFO: " + objectNumber + " members in table UME_STRINGS successfully converted.");
            updateStatement.close();
            rs.close();
            stmt.close();
            result.add("INFO: start processing LDAP pids in table UME_STRINGS");
            stmt = dbConnection.prepareStatement(SP0_TO_SP1.SQL_STATEMENTS_PHASE2[11]);
            stmt.setString(1, "USER%");
            stmt.setString(2, "UACC%");
            stmt.setString(3, "GRUP%");
            updateStatement = dbConnection.prepareStatement(SP0_TO_SP1.SQL_STATEMENTS_PHASE3[13]);
            rs = stmt.executeQuery();
            counter = 0;
            objectNumber = 0;
            ldapDN = null;
            while (rs.next()) {
                attrguid = rs.getString("ATTRGUID");
                pid = rs.getString("PID");
                ldapDN = SP0_TO_SP1.convertLDAPDN(pid);
                if (ldapDN == null) continue;
                updateStatement.setString(1, ldapDN);
                updateStatement.setString(2, attrguid);
                updateStatement.addBatch();
                ++objectNumber;
                if (++counter != 5000) continue;
                counter = 0;
                updateStatement.executeBatch();
                if (userTransaction == null) {
                    dbConnection.commit();
                    continue;
                }
                userTransaction.commit();
            }
            updateStatement.executeBatch();
            if (userTransaction == null) {
                dbConnection.commit();
            } else {
                userTransaction.commit();
            }
            result.add("INFO: " + objectNumber + " ids in table UME_STRINGS successfully converted.");
            updateStatement.close();
            rs.close();
            stmt.close();
            result.add("INFO: start processing LDAP pids in table UME_BLOBS");
            stmt = dbConnection.prepareStatement(SP0_TO_SP1.SQL_STATEMENTS_PHASE2[12]);
            stmt.setString(1, "USER%");
            stmt.setString(2, "UACC%");
            stmt.setString(3, "GRUP%");
            updateStatement = dbConnection.prepareStatement(SP0_TO_SP1.SQL_STATEMENTS_PHASE3[14]);
            rs = stmt.executeQuery();
            counter = 0;
            objectNumber = 0;
            ldapDN = null;
            while (rs.next()) {
                attrguid = rs.getString("ATTRGUID");
                pid = rs.getString("PID");
                ldapDN = SP0_TO_SP1.convertLDAPDN(pid);
                if (ldapDN == null) continue;
                updateStatement.setString(1, ldapDN);
                updateStatement.setString(2, attrguid);
                updateStatement.addBatch();
                ++objectNumber;
                if (++counter != 5000) continue;
                counter = 0;
                updateStatement.executeBatch();
                if (userTransaction == null) {
                    dbConnection.commit();
                    continue;
                }
                userTransaction.commit();
            }
            updateStatement.executeBatch();
            if (userTransaction == null) {
                dbConnection.commit();
            } else {
                userTransaction.commit();
            }
            result.add("INFO: " + objectNumber + " ids in table UME_BLOBS successfully converted.");
            updateStatement.close();
            rs.close();
            stmt.close();
            result.add("INFO: start processing LDAP pids in table UME_ACL_ACLENTRY");
            stmt = dbConnection.prepareStatement(SP0_TO_SP1.SQL_STATEMENTS_PHASE2[13]);
            stmt.setString(1, "USER%");
            stmt.setString(2, "UACC%");
            stmt.setString(3, "GRUP%");
            updateStatement = dbConnection.prepareStatement(SP0_TO_SP1.SQL_STATEMENTS_PHASE3[15]);
            rs = stmt.executeQuery();
            counter = 0;
            objectNumber = 0;
            ldapDN = null;
            while (rs.next()) {
                id = rs.getString("ID");
                principal_name = rs.getString("PRINCIPAL_NAME");
                ldapDN = SP0_TO_SP1.convertLDAPDN(principal_name);
                if (ldapDN == null) continue;
                updateStatement.setString(1, ldapDN);
                updateStatement.setString(2, id);
                updateStatement.addBatch();
                ++objectNumber;
                if (++counter != 5000) continue;
                counter = 0;
                updateStatement.executeBatch();
                if (userTransaction == null) {
                    dbConnection.commit();
                    continue;
                }
                userTransaction.commit();
            }
            updateStatement.executeBatch();
            if (userTransaction == null) {
                dbConnection.commit();
            } else {
                userTransaction.commit();
            }
            result.add("INFO: " + objectNumber + " ids in table UME_ACL_ACLENTRY successfully converted.");
            updateStatement.close();
            rs.close();
            stmt.close();
            result.add("INFO: start processing LDAP pids in table UME_ACL_OWNER");
            stmt = dbConnection.prepareStatement(SP0_TO_SP1.SQL_STATEMENTS_PHASE2[14]);
            stmt.setString(1, "USER%");
            stmt.setString(2, "UACC%");
            stmt.setString(3, "GRUP%");
            updateStatement = dbConnection.prepareStatement(SP0_TO_SP1.SQL_STATEMENTS_PHASE3[16]);
            rs = stmt.executeQuery();
            counter = 0;
            objectNumber = 0;
            ldapDN = null;
            while (rs.next()) {
                ownerid = rs.getInt("OWNERID");
                rid = rs.getString("RID");
                principal_name = rs.getString("PRINCIPAL_NAME");
                ldapDN = SP0_TO_SP1.convertLDAPDN(principal_name);
                if (ldapDN == null) continue;
                updateStatement.setString(1, ldapDN);
                updateStatement.setInt(2, ownerid);
                updateStatement.setString(3, rid);
                updateStatement.setString(4, principal_name);
                updateStatement.addBatch();
                ++objectNumber;
                if (++counter != 5000) continue;
                counter = 0;
                updateStatement.executeBatch();
                if (userTransaction == null) {
                    dbConnection.commit();
                    continue;
                }
                userTransaction.commit();
            }
            updateStatement.executeBatch();
            if (userTransaction == null) {
                dbConnection.commit();
            } else {
                userTransaction.commit();
            }
            result.add("INFO: " + objectNumber + " ids in table UME_ACL_OWNER successfully converted.");
            updateStatement.close();
            rs.close();
            stmt.close();
            result.add("INFO: start processing data in table UME_STRINGS");
            stmt = dbConnection.prepareStatement(SP0_TO_SP1.SQL_STATEMENTS_PHASE2[0]);
            updateStatement = dbConnection.prepareStatement(SP0_TO_SP1.SQL_STATEMENTS_PHASE3[0]);
            rs = stmt.executeQuery();
            counter = 0;
            objectNumber = 0;
            while (rs.next()) {
                attrguid = rs.getString("ATTRGUID");
                pid = rs.getString("PID");
                namesp = rs.getString("NAMESP");
                attr = rs.getString("ATTR");
                val = rs.getString("VAL");
                upperval = rs.getString("UPPERVAL");
                updateStatement.setLong(1, Util.getHash(pid));
                updateStatement.setLong(2, Util.getHash(namesp));
                updateStatement.setLong(3, Util.getHash(attr));
                updateStatement.setLong(4, Util.getHash(val));
                updateStatement.setLong(5, Util.getHash(upperval));
                updateStatement.setString(6, attrguid);
                updateStatement.addBatch();
                ++objectNumber;
                if (++counter != 5000) continue;
                counter = 0;
                updateStatement.executeBatch();
                if (userTransaction == null) {
                    dbConnection.commit();
                    continue;
                }
                userTransaction.commit();
            }
            updateStatement.executeBatch();
            if (userTransaction == null) {
                dbConnection.commit();
            } else {
                userTransaction.commit();
            }
            result.add("INFO: " + objectNumber + " rows in table UME_STRINGS successfully converted.");
            updateStatement.close();
            rs.close();
            stmt.close();
            result.add("INFO: start processing data in table UME_BLOBS");
            stmt = dbConnection.prepareStatement(SP0_TO_SP1.SQL_STATEMENTS_PHASE2[1]);
            updateStatement = dbConnection.prepareStatement(SP0_TO_SP1.SQL_STATEMENTS_PHASE3[1]);
            rs = stmt.executeQuery();
            counter = 0;
            objectNumber = 0;
            while (rs.next()) {
                attrguid = rs.getString("ATTRGUID");
                pid = rs.getString("PID");
                namesp = rs.getString("NAMESP");
                attr = rs.getString("ATTR");
                updateStatement.setLong(1, Util.getHash(pid));
                updateStatement.setLong(2, Util.getHash(namesp));
                updateStatement.setLong(3, Util.getHash(attr));
                updateStatement.setString(4, attrguid);
                updateStatement.addBatch();
                ++objectNumber;
                if (++counter != 5000) continue;
                counter = 0;
                updateStatement.executeBatch();
                if (userTransaction == null) {
                    dbConnection.commit();
                    continue;
                }
                userTransaction.commit();
            }
            updateStatement.executeBatch();
            if (userTransaction == null) {
                dbConnection.commit();
            } else {
                userTransaction.commit();
            }
            result.add("INFO: " + objectNumber + " rows in table UME_BLOBS successfully converted.");
            updateStatement.close();
            rs.close();
            stmt.close();
            result.add("INFO: start processing data in table UME_ACL_ACL");
            stmt = dbConnection.prepareStatement(SP0_TO_SP1.SQL_STATEMENTS_PHASE2[2]);
            updateStatement = dbConnection.prepareStatement(SP0_TO_SP1.SQL_STATEMENTS_PHASE3[2]);
            rs = stmt.executeQuery();
            counter = 0;
            objectNumber = 0;
            while (rs.next()) {
                ridstart = rs.getString("RIDSTART");
                ownerid = rs.getInt("OWNERID");
                rid = rs.getString("RID");
                updateStatement.setLong(1, Util.getHash(ridstart));
                updateStatement.setInt(2, ownerid);
                updateStatement.setString(3, rid);
                updateStatement.addBatch();
                ++objectNumber;
                if (++counter != 5000) continue;
                counter = 0;
                updateStatement.executeBatch();
                if (userTransaction == null) {
                    dbConnection.commit();
                    continue;
                }
                userTransaction.commit();
            }
            updateStatement.executeBatch();
            if (userTransaction == null) {
                dbConnection.commit();
            } else {
                userTransaction.commit();
            }
            result.add("INFO: " + objectNumber + " rows in table UME_ACL_ACL successfully converted.");
            updateStatement.close();
            rs.close();
            stmt.close();
            result.add("INFO: start processing data in table UME_ACL_ACLENTRY");
            stmt = dbConnection.prepareStatement(SP0_TO_SP1.SQL_STATEMENTS_PHASE2[3]);
            updateStatement = dbConnection.prepareStatement(SP0_TO_SP1.SQL_STATEMENTS_PHASE3[3]);
            rs = stmt.executeQuery();
            counter = 0;
            objectNumber = 0;
            while (rs.next()) {
                ridstart = rs.getString("RIDSTART");
                ownerid = rs.getInt("OWNERID");
                rid = rs.getString("RID");
                updateStatement.setLong(1, Util.getHash(ridstart));
                updateStatement.setInt(2, ownerid);
                updateStatement.setString(3, rid);
                updateStatement.addBatch();
                ++objectNumber;
                if (++counter != 5000) continue;
                counter = 0;
                updateStatement.executeBatch();
                if (userTransaction == null) {
                    dbConnection.commit();
                    continue;
                }
                userTransaction.commit();
            }
            updateStatement.executeBatch();
            if (userTransaction == null) {
                dbConnection.commit();
            } else {
                userTransaction.commit();
            }
            result.add("INFO: " + objectNumber + " rows in table UME_ACL_ACLENTRY successfully converted.");
            updateStatement.close();
            rs.close();
            stmt.close();
            result.add("INFO: start processing data in table UME_ACL_OWNER");
            stmt = dbConnection.prepareStatement(SP0_TO_SP1.SQL_STATEMENTS_PHASE2[4]);
            updateStatement = dbConnection.prepareStatement(SP0_TO_SP1.SQL_STATEMENTS_PHASE3[4]);
            rs = stmt.executeQuery();
            counter = 0;
            objectNumber = 0;
            while (rs.next()) {
                ridstart = rs.getString("RIDSTART");
                ownerid = rs.getInt("OWNERID");
                rid = rs.getString("RID");
                updateStatement.setLong(1, Util.getHash(ridstart));
                updateStatement.setInt(2, ownerid);
                updateStatement.setString(3, rid);
                updateStatement.addBatch();
                ++objectNumber;
                if (++counter != 5000) continue;
                counter = 0;
                updateStatement.executeBatch();
                if (userTransaction == null) {
                    dbConnection.commit();
                    continue;
                }
                userTransaction.commit();
            }
            updateStatement.executeBatch();
            if (userTransaction == null) {
                dbConnection.commit();
            } else {
                userTransaction.commit();
            }
            result.add("INFO: " + objectNumber + " rows in table UME_ACL_OWNER successfully converted.");
            updateStatement.close();
            rs.close();
            stmt.close();
            result.add("INFO: start processing data in table UME_ACL_PERM");
            stmt = dbConnection.prepareStatement(SP0_TO_SP1.SQL_STATEMENTS_PHASE2[5]);
            updateStatement = dbConnection.prepareStatement(SP0_TO_SP1.SQL_STATEMENTS_PHASE3[5]);
            rs = stmt.executeQuery();
            counter = 0;
            objectNumber = 0;
            while (rs.next()) {
                permission_name = rs.getString("PERMISSION_NAME");
                ownerid = rs.getInt("OWNERID");
                updateStatement.setLong(1, Util.getHash(permission_name));
                updateStatement.setInt(2, ownerid);
                updateStatement.setString(3, permission_name);
                updateStatement.addBatch();
                ++objectNumber;
                if (++counter != 5000) continue;
                counter = 0;
                updateStatement.executeBatch();
                if (userTransaction == null) {
                    dbConnection.commit();
                    continue;
                }
                userTransaction.commit();
            }
            updateStatement.executeBatch();
            if (userTransaction == null) {
                dbConnection.commit();
            } else {
                userTransaction.commit();
            }
            result.add("INFO: " + objectNumber + " rows in table UME_ACL_PERM successfully converted.");
            updateStatement.close();
            rs.close();
            stmt.close();
            result.add("INFO: start processing data in table UME_ACL_SUP_PERM");
            stmt = dbConnection.prepareStatement(SP0_TO_SP1.SQL_STATEMENTS_PHASE2[6]);
            updateStatement = dbConnection.prepareStatement(SP0_TO_SP1.SQL_STATEMENTS_PHASE3[6]);
            rs = stmt.executeQuery();
            counter = 0;
            objectNumber = 0;
            while (rs.next()) {
                permission_name = rs.getString("PERMISSION_NAME");
                object_type = rs.getString("OBJECT_TYPE");
                ownerid = rs.getInt("OWNERID");
                updateStatement.setLong(1, Util.getHash(permission_name));
                updateStatement.setLong(2, Util.getHash(object_type));
                updateStatement.setInt(3, ownerid);
                updateStatement.setString(4, permission_name);
                updateStatement.addBatch();
                ++objectNumber;
                if (++counter != 5000) continue;
                counter = 0;
                updateStatement.executeBatch();
                if (userTransaction == null) {
                    dbConnection.commit();
                    continue;
                }
                userTransaction.commit();
            }
            updateStatement.executeBatch();
            if (userTransaction == null) {
                dbConnection.commit();
            } else {
                userTransaction.commit();
            }
            result.add("INFO: " + objectNumber + " rows in table UME_ACL_SUP_PERM successfully converted.");
            updateStatement.close();
            rs.close();
            stmt.close();
            result.add("INFO: start processing data in table UME_USERSYNC");
            stmt = dbConnection.prepareStatement(SP0_TO_SP1.SQL_STATEMENTS_PHASE2[7]);
            updateStatement = dbConnection.prepareStatement(SP0_TO_SP1.SQL_STATEMENTS_PHASE3[7]);
            rs = stmt.executeQuery();
            counter = 0;
            objectNumber = 0;
            while (rs.next()) {
                id = rs.getString("ID");
                user_id = rs.getString("USER_ID");
                adapter_id = rs.getString("ADAPTER_ID");
                adapter_class = rs.getString("ADAPTER_CLASS");
                operation_name = rs.getString("OPERATION_NAME");
                updateStatement.setLong(1, Util.getHash(user_id));
                updateStatement.setLong(2, Util.getHash(adapter_id));
                updateStatement.setLong(3, Util.getHash(adapter_class));
                updateStatement.setLong(4, Util.getHash(operation_name));
                updateStatement.setString(5, id);
                updateStatement.addBatch();
                ++objectNumber;
                if (++counter != 5000) continue;
                counter = 0;
                updateStatement.executeBatch();
                if (userTransaction == null) {
                    dbConnection.commit();
                    continue;
                }
                userTransaction.commit();
            }
            updateStatement.executeBatch();
            if (userTransaction == null) {
                dbConnection.commit();
            } else {
                userTransaction.commit();
            }
            result.add("INFO: " + objectNumber + " rows in table UME_USERSYNC successfully converted.");
            updateStatement.close();
            rs.close();
            stmt.close();
            result.add("INFO: start processing data in table UME_USERSYNCTEMP");
            stmt = dbConnection.prepareStatement(SP0_TO_SP1.SQL_STATEMENTS_PHASE2[8]);
            updateStatement = dbConnection.prepareStatement(SP0_TO_SP1.SQL_STATEMENTS_PHASE3[8]);
            rs = stmt.executeQuery();
            counter = 0;
            objectNumber = 0;
            while (rs.next()) {
                id = rs.getString("ID");
                user_id = rs.getString("USER_ID");
                operation_name = rs.getString("OPERATION_NAME");
                updateStatement.setLong(1, Util.getHash(user_id));
                updateStatement.setLong(2, Util.getHash(operation_name));
                updateStatement.setString(3, id);
                updateStatement.addBatch();
                ++objectNumber;
                if (++counter != 5000) continue;
                counter = 0;
                updateStatement.executeBatch();
                if (userTransaction == null) {
                    dbConnection.commit();
                    continue;
                }
                userTransaction.commit();
            }
            updateStatement.executeBatch();
            if (userTransaction == null) {
                dbConnection.commit();
            } else {
                userTransaction.commit();
            }
            result.add("INFO: " + objectNumber + " rows in table UME_USERSYNCTEMP successfully converted.");
            updateStatement.close();
            rs.close();
            stmt.close();
        }
        catch (Exception ex) {
            result.add("ERROR: error while converting data: " + ex.getMessage());
        }
        return result;
    }

    public static void main(String[] args) {
        if (args == null || args.length < 5) {
            System.out.println("ERROR: Usage: go [ORA|MSS] <hostname:port> <dbname> <user> <password>");
            System.exit(1);
        }
        String dbVendor = args[0];
        String dbHostPort = args[1];
        String dbName = args[2];
        String user = args[3];
        String pass = args[4];
        String driver = "";
        String url = "";
        if (dbVendor.equalsIgnoreCase("ORA")) {
            driver = "oracle.jdbc.OracleDriver";
            url = "jdbc:oracle:thin:@" + dbHostPort + ":" + dbName;
            dbVendor = ORA;
        } else if (dbVendor.equalsIgnoreCase("MSS")) {
            driver = "com.inet.tds.TdsDriver";
            url = "jdbc:inetdae7:" + dbHostPort + "?database=" + dbName + "&useCursorsAlways=true";
            dbVendor = MSS;
        } else {
            System.out.println("ERROR: Unsupported DB vendor:" + dbVendor);
            System.exit(1);
        }
        try {
            Driver dr = (Driver)Class.forName(driver).newInstance();
            DriverManager.registerDriver(dr);
            Connection con = DriverManager.getConnection(url, user, pass);
            boolean errorOccured = false;
            Vector result = SP0_TO_SP1.changeSchema(con, null, dbVendor);
            int i = 0;
            while (i < result.size()) {
                System.out.println((String)result.elementAt(i));
                if (((String)result.elementAt(i)).startsWith("ERROR:")) {
                    errorOccured = true;
                }
                ++i;
            }
            if (errorOccured) {
                System.exit(1);
            }
            result = SP0_TO_SP1.convertData(con, null);
            int i2 = 0;
            while (i2 < result.size()) {
                System.out.println((String)result.elementAt(i2));
                if (((String)result.elementAt(i2)).startsWith("ERROR:")) {
                    errorOccured = true;
                }
                ++i2;
            }
            if (errorOccured) {
                System.exit(1);
            }
            System.exit(0);
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.getMessage());
            System.exit(1);
        }
    }

    public static String convertLDAPDN(String original) {
        String[] idparts = SP0_TO_SP1.splitPrincipalDatabagID(original);
        if (idparts == null) {
            return null;
        }
        if (idparts[2].indexOf(61) != -1) {
            StringBuffer result = new StringBuffer(original.length());
            result.append(idparts[0]);
            result.append(PRINCIPAL_ID_SEPARATOR);
            result.append(idparts[1]);
            result.append(PRINCIPAL_ID_SEPARATOR);
            result.append(JNDIUtils.trimDN(idparts[2]).toLowerCase());
            return result.toString();
        }
        return null;
    }

    public static String[] splitPrincipalDatabagID(String principalID) {
        if (principalID == null) {
            return null;
        }
        int firstOccurrence = principalID.indexOf(PRINCIPAL_ID_SEPARATOR);
        String[] idParts = new String[3];
        boolean valid = false;
        if (firstOccurrence != -1) {
            idParts[0] = principalID.substring(0, firstOccurrence);
            if ((firstOccurrence = (principalID = principalID.substring(firstOccurrence + 1, principalID.length())).indexOf(PRINCIPAL_ID_SEPARATOR)) != -1) {
                idParts[1] = principalID.substring(0, firstOccurrence);
                idParts[2] = principalID.substring(firstOccurrence + 1, principalID.length());
                boolean bl = valid = idParts[0].length() == 4;
            }
        }
        if (!valid) {
            return null;
        }
        return idParts;
    }

    private static Map deserializeMap(byte[] v) throws IOException {
        if (v == null) {
            throw new NullPointerException("Argument must not be null in deserializeMap");
        }
        ByteArrayInputStream is = new ByteArrayInputStream(v);
        ObjectInputStream ois = new ObjectInputStream(is);
        Map m = null;
        try {
            m = (Map)ois.readObject();
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("" + cnfe);
        }
        ois.close();
        is.close();
        return m;
    }
}

