/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.IGroupFactory;
import com.sap.security.api.ISearchAttribute;
import com.sap.security.api.UMFactory;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.imp.GroupFactory;
import com.sap.security.core.persistence.IInternalPrincipalDatabag;
import com.sap.security.core.persistence.IInternalPrincipalDatabagMaint;
import com.sap.security.core.persistence.IPrincipalDatabag;
import com.sap.security.core.persistence.datasource.IDataSourceTransaction;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.datasource.imp.DSConfigurationModel;
import com.sap.security.core.persistence.datasource.imp.DSPrincipalModel;
import com.sap.security.core.persistence.datasource.imp.R3JCoProxy;
import com.sap.security.core.persistence.datasource.imp.R3PersistenceBase;
import com.sap.security.core.util.IUMTrace;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;

public class R3RoleDataSource
extends R3PersistenceBase {
    private static final IUMTrace LOG = InternalUMFactory.getTrace((class$com$sap$security$core$persistence$datasource$imp$R3RoleDataSource == null ? (class$com$sap$security$core$persistence$datasource$imp$R3RoleDataSource = R3RoleDataSource.class$("com.sap.security.core.persistence.datasource.imp.R3RoleDataSource")) : class$com$sap$security$core$persistence$datasource$imp$R3RoleDataSource).getName());
    private String PRINCIPAL_TYPE;
    private static final String USER_DATASOURCE_ID = "ume.r3.roles.user_datasource_id";
    private String _userDatasourceID = null;
    private static final String REFRESH_INTERVAL_MINS = "ume.r3.roles.refresh_interval_mins";
    private int _bufferRefreshIntervalMinutes = 30;
    private static final String NO_DERIVED = "ume.r3.roles.no_derived";
    private boolean _noDerivedRoles = false;
    public static final String COLLECTIVE_GROUPS_AS_PARENTS = "ume.r3.roles.sp_zero_hierarchy";
    private boolean _collectiveGroupsAsParents = false;
    private NameCreator _nameCreator;
    private R3JCoProxy.FunctionTemplate _prgnJ2eeGetRoles = null;
    private R3JCoProxy.FunctionTemplate _prgnJ2eeUserGetRolenames = null;
    private R3JCoProxy.FunctionTemplate _bapiUserGetList = null;
    private static LinkedList _instances = new LinkedList();
    private static final String MEMBER_NS = "com.sap.security.core.usermanagement.relation";
    private static final String MEMBER_ATT = "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE";
    private Buffer _activeBuffer = null;
    static /* synthetic */ Class class$com$sap$security$core$persistence$datasource$imp$R3RoleDataSource;

    public R3RoleDataSource() {
        this.LOG_BASE = LOG;
        _instances.add(this);
    }

    protected void assertResponsibility(DSConfigurationModel configuration) throws Exception {
        Hashtable typeHash = configuration.getResponsibleFor();
        Enumeration typeEnum = typeHash.keys();
        while (typeEnum.hasMoreElements()) {
            String typeKey = (String)typeEnum.nextElement();
            if (!"GRUP".equals(typeKey) && !"ROLE".equals(typeKey)) {
                throw new PersistenceException("Datasource " + this.getId() + ": Unsupported principal type \"" + typeKey + "\".");
            }
            DSPrincipalModel principal = (DSPrincipalModel)typeHash.get(typeKey);
            Hashtable nsHash = principal.getResponsibleNameSpaceAttributes();
            Enumeration nsEnum = nsHash.keys();
            while (nsEnum.hasMoreElements()) {
                String nsKey = (String)nsEnum.nextElement();
                Vector attributes = (Vector)nsHash.get(nsKey);
                int numAttributes = attributes.size();
                int i = 0;
                while (i < numAttributes) {
                    String attr = (String)attributes.get(i);
                    boolean supported = false;
                    if ("com.sap.security.core.usermanagement".equals(nsKey)) {
                        if ("description".equals(attr) || "displayname".equals(attr) || "uniquename".equals(attr)) {
                            supported = true;
                        }
                    } else if (MEMBER_NS.equals(nsKey)) {
                        if (MEMBER_ATT.equals(attr)) {
                            supported = true;
                        }
                    } else {
                        throw new PersistenceException("Datasource " + this.getId() + ": Unsupported namespace \"" + nsKey + "\"");
                    }
                    if (!supported) {
                        throw new PersistenceException("Datasource " + this.getId() + ": Unsupported attribute name \"" + attr + "\". " + "Principal type: " + typeKey + ", namespace: " + nsKey);
                    }
                    ++i;
                }
            }
        }
    }

    protected void localInitialization(DSConfigurationModel dsConf) throws Exception {
        String METHOD = "localInitialization()";
        String confValue = dsConf.getPrivateAttribute(USER_DATASOURCE_ID);
        if (confValue == null) {
            throw new PersistenceException("Datasource " + dsConf.getDataSourceID() + " cannot be initialized because " + "the required property " + USER_DATASOURCE_ID + " is not specified");
        }
        this._userDatasourceID = confValue;
        LOG.debugT("localInitialization()", "User Data Source ID: " + this._userDatasourceID);
        this.doInitRfc(dsConf, this._userDatasourceID);
        Vector responsiblePrincipals = dsConf.getResponsiblePrincipalTypes();
        if (responsiblePrincipals.contains("GRUP")) {
            if (responsiblePrincipals.contains("ROLE")) {
                throw new PersistenceException("R3RoleDataSource cannot be responsible for groups and rolesat the same time");
            }
            this.PRINCIPAL_TYPE = "GRUP";
            LOG.logInfoT("R3RoleDataSource representing backend roles as UME groups", null);
        } else if (responsiblePrincipals.contains("ROLE")) {
            this.PRINCIPAL_TYPE = "ROLE";
            LOG.logInfoT("R3RoleDataSource representing backend single roles as UME roles and ignoring backend collective roles", null);
        } else {
            throw new PersistenceException("R3RoleDataSource not responsible for either GRUP or ROLE");
        }
        this._nameCreator = new NameCreator(this.getId(), this._userDatasourceID);
        confValue = dsConf.getPrivateAttribute(REFRESH_INTERVAL_MINS);
        if (confValue != null) {
            try {
                this._bufferRefreshIntervalMinutes = Integer.parseInt(confValue);
            }
            catch (NumberFormatException nfe) {
                throw new PersistenceException("Optional property ume.r3.roles.refresh_interval_mins must be numeric (actual: " + confValue + ")");
            }
            if (this._bufferRefreshIntervalMinutes < 1) {
                throw new PersistenceException("Optional property ume.r3.roles.refresh_interval_mins has a minimum value of 1 (actual: " + confValue + ")");
            }
        }
        LOG.debugT("localInitialization()", "Refreshing cache every " + this._bufferRefreshIntervalMinutes + " minutes");
        confValue = dsConf.getPrivateAttribute(NO_DERIVED);
        if (confValue != null) {
            this._noDerivedRoles = "true".equalsIgnoreCase(confValue);
        }
        LOG.debugT("localInitialization()", "Derived ABAP roles will " + (this._noDerivedRoles ? "NOT " : "") + "be used as UME groups");
        if (this.PRINCIPAL_TYPE == "GRUP") {
            confValue = dsConf.getPrivateAttribute(COLLECTIVE_GROUPS_AS_PARENTS);
            if (confValue != null) {
                this._collectiveGroupsAsParents = "true".equalsIgnoreCase(confValue);
            }
            LOG.debugT("localInitialization()", "Representing ABAP composite roles as " + (this._collectiveGroupsAsParents ? "parent " : "child ") + "groups of the ABAP single roles which they contain");
        }
        this._prgnJ2eeGetRoles = this._backendProxy.getRepository().getFunctionTemplate("PRGN_J2EE_GET_ROLES");
        this._prgnJ2eeUserGetRolenames = this._backendProxy.getRepository().getFunctionTemplate("PRGN_J2EE_USER_GET_ROLENAMES");
        this._bapiUserGetList = this._backendProxy.getRepository().getFunctionTemplate("BAPI_USER_GETLIST");
        if (this._prgnJ2eeGetRoles == null || this._prgnJ2eeUserGetRolenames == null) {
            throw new PersistenceException("Function modules PRGN_J2EE_GET_ROLES and PRGN_J2EE_USER_GET_ROLENAMES must be present in the backend system to use R3RoleDataSource.");
        }
        this.checkBufferRefresh(false, false, true);
        Runnable r = new Runnable(){

            public void run() {
                String METHOD = "Runnable.run()";
                while (true) {
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    try {
                        R3RoleDataSource.this.checkBufferRefresh(false, true, false);
                        continue;
                    }
                    catch (Exception e) {
                        R3PersistenceBase.LogUtil.logThrowable(1, LOG, "Runnable.run()", "Exception during background update of role data buffer", null, e);
                        continue;
                    }
                    break;
                }
            }
        };
        Thread refreshThread = new Thread(r, "R3RoleDataSource_UpdateThread[" + System.identityHashCode(this) + "]");
        refreshThread.setDaemon(true);
        refreshThread.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public R3PersistenceBase.IPersistenceCollection getAllAttributes(IPrincipalDatabag principal, String nameSpace) throws PersistenceException {
        R3PersistenceBase.PersistenceCollection persistenceCollection;
        String METHOD = "getAttributeNames()";
        R3PersistenceBase.PersistenceCollection result = null;
        try {
            try {
                block8: {
                    block10: {
                        R3PersistenceBase.LogUtil.logEntering(LOG, "getAttributeNames()", new Object[]{principal, nameSpace});
                        String type = principal.getIDParts()[0];
                        if (!this.PRINCIPAL_TYPE.equals(type)) break block10;
                        if ("com.sap.security.core.usermanagement".equals(nameSpace)) {
                            result = new R3PersistenceBase.PersistenceCollection(3);
                            result.add("uniquename");
                            result.add("description");
                            result.add("displayname");
                            break block8;
                        } else if (MEMBER_NS.equals(nameSpace)) {
                            result = new R3PersistenceBase.PersistenceCollection(1);
                            result.add(MEMBER_ATT);
                            break block8;
                        } else {
                            result = new R3PersistenceBase.PersistenceCollection();
                        }
                        break block8;
                    }
                    result = new R3PersistenceBase.PersistenceCollection();
                }
                R3RoleDataSource.refreshUser("Hallo");
                persistenceCollection = result;
                Object var8_9 = null;
            }
            catch (Exception e) {
                PersistenceException pe = this.newPersistenceException(LOG, "getAttributeNames()", e);
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "getAttributeNames()", (Throwable)((Object)pe));
                throw pe;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "getAttributeNames()", result);
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "getAttributeNames()", result);
        return persistenceCollection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public R3PersistenceBase.IPersistenceCollection getAllNamespaces(IPrincipalDatabag principal) throws PersistenceException {
        R3PersistenceBase.PersistenceCollection persistenceCollection;
        String METHOD = "getAttributeNamespaces()";
        R3PersistenceBase.PersistenceCollection result = null;
        try {
            try {
                R3PersistenceBase.LogUtil.logEntering(LOG, "getAttributeNamespaces()", new Object[]{principal});
                String type = principal.getIDParts()[0];
                if (this.PRINCIPAL_TYPE.equals(type)) {
                    this.assertInitialization();
                    result = new R3PersistenceBase.PersistenceCollection(2);
                    result.add("com.sap.security.core.usermanagement");
                    result.add(MEMBER_NS);
                } else {
                    result = new R3PersistenceBase.PersistenceCollection();
                }
                persistenceCollection = result;
                Object var7_8 = null;
            }
            catch (Exception e) {
                PersistenceException pe = this.newPersistenceException(LOG, "getAttributeNamespaces()", e);
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "getAttributeNamespaces()", (Throwable)((Object)pe));
                throw pe;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "getAttributeNamespaces()", result);
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "getAttributeNamespaces()", result);
        return persistenceCollection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getPrivateIDPart(IPrincipalDatabag principal) throws PersistenceException {
        String string;
        String METHOD = "getPrivateIDPart";
        String result = null;
        try {
            try {
                R3PersistenceBase.LogUtil.logEntering(LOG, "getPrivateIDPart", new Object[]{principal});
                LOG.debugT("getPrivateIDPart", "R3RoleDataSource cannot create new roles. Method getPrivateIDPart() is pointless in this case. As it was called by UME persistence manager anyway, returning dummy data");
                string = result = "DUMMY";
                Object var7_6 = null;
            }
            catch (Exception e) {
                PersistenceException pe = this.newPersistenceException(LOG, "getPrivateIDPart", e);
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "getPrivateIDPart", (Throwable)((Object)pe));
                throw pe;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "getPrivateIDPart", result);
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "getPrivateIDPart", result);
        return string;
    }

    public void populatePrincipalDatabag(IInternalPrincipalDatabag principal, AttributeList populateAttributes) throws PersistenceException {
        String METHOD = "populatePrincipalDatabag(AttributeList)";
        try {
            block5: {
                try {
                    R3PersistenceBase.LogUtil.logEntering(LOG, "populatePrincipalDatabag(AttributeList)", new Object[]{populateAttributes});
                    this.assertInitialization();
                    if (populateAttributes == null) break block5;
                    int i = 0;
                    while (i < populateAttributes.getSize()) {
                        this.populatePrincipalDatabag(principal, populateAttributes.getNameSpaceOfAttributeAt(i), populateAttributes.getAttributeNameOfAttributeAt(i));
                        ++i;
                    }
                }
                catch (Exception e) {
                    PersistenceException pe = this.newPersistenceException(LOG, "populatePrincipalDatabag(AttributeList)", e);
                    R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "populatePrincipalDatabag(AttributeList)", (Throwable)((Object)pe));
                    throw pe;
                }
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "populatePrincipalDatabag(AttributeList)");
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "populatePrincipalDatabag(AttributeList)");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean populatePrincipalDatabag(IInternalPrincipalDatabag principal, String nameSpace, String attribute) throws PersistenceException {
        boolean bl;
        boolean result;
        block16: {
            boolean bl2;
            block15: {
                boolean bl3;
                block14: {
                    String METHOD = "populatePrincipalDatabag(String, String)";
                    result = false;
                    try {
                        try {
                            R3PersistenceBase.LogUtil.logEntering(LOG, "populatePrincipalDatabag(String, String)", new Object[]{principal, nameSpace, attribute});
                            this.assertInitialization();
                            Buffer currentBuffer = this._activeBuffer;
                            String[] parts = principal.getIDParts();
                            if (!(this.PRINCIPAL_TYPE.equals(parts[0]) && this.getId().equals(parts[1]) && this.feelsResponsible(parts[0], nameSpace, attribute))) {
                                LOG.debugT("populatePrincipalDatabag(String, String)", "Not responsible for populating this attribute");
                                bl3 = result = false;
                                Object var14_12 = null;
                                break block14;
                            }
                            String roleName = parts[2];
                            RoleData roleData = (RoleData)currentBuffer.roles.get(roleName);
                            if (roleData == null) {
                                principal.setExists(false);
                                bl2 = result = false;
                                break block15;
                            }
                            principal.setExists(true);
                            if ("com.sap.security.core.usermanagement".equals(nameSpace) && ("uniquename".equals(attribute) || "displayname".equals(attribute))) {
                                R3PersistenceBase.Util.populateEmptyIfNeeded(principal, nameSpace, attribute);
                                principal.addAttributeValue(nameSpace, attribute, roleName);
                            } else if ("com.sap.security.core.usermanagement".equals(nameSpace) && "description".equals(attribute)) {
                                R3PersistenceBase.Util.populateEmptyIfNeeded(principal, nameSpace, attribute);
                                principal.addAttributeValue(nameSpace, attribute, roleData.description);
                            } else {
                                Set usersInRole;
                                if (!MEMBER_NS.equals(nameSpace)) throw new PersistenceException("R3RoleDataSource does not know attribute " + attribute);
                                if (!MEMBER_ATT.equals(attribute)) throw new PersistenceException("R3RoleDataSource does not know attribute " + attribute);
                                R3PersistenceBase.Util.populateEmptyIfNeeded(principal, nameSpace, attribute);
                                if (this.PRINCIPAL_TYPE == "GRUP" && roleData.members != null) {
                                    Iterator roleIterator = roleData.members.iterator();
                                    while (roleIterator.hasNext()) {
                                        RoleData memberRole = (RoleData)roleIterator.next();
                                        principal.addAttributeValue(nameSpace, attribute, this._nameCreator.getExternalRoleName(memberRole.name));
                                    }
                                }
                                if ((usersInRole = this.getUsersInRole(roleName)) != null) {
                                    Iterator userIterator = usersInRole.iterator();
                                    while (userIterator.hasNext()) {
                                        String userName = (String)userIterator.next();
                                        principal.addAttributeValue(nameSpace, attribute, this._nameCreator.getExternalUserName(userName));
                                    }
                                }
                            }
                            bl = result = true;
                            break block16;
                        }
                        catch (Exception e) {
                            PersistenceException pe = this.newPersistenceException(LOG, "populatePrincipalDatabag(String, String)", e);
                            R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "populatePrincipalDatabag(String, String)", (Throwable)((Object)pe));
                            throw pe;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var14_15 = null;
                        R3PersistenceBase.LogUtil.logExiting(LOG, "populatePrincipalDatabag(String, String)", new Boolean(result), new Object[]{principal});
                        throw throwable;
                    }
                }
                R3PersistenceBase.LogUtil.logExiting(LOG, "populatePrincipalDatabag(String, String)", new Boolean(result), new Object[]{principal});
                return bl3;
            }
            Object var14_13 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "populatePrincipalDatabag(String, String)", new Boolean(result), new Object[]{principal});
            return bl2;
        }
        Object var14_14 = null;
        R3PersistenceBase.LogUtil.logExiting(LOG, "populatePrincipalDatabag(String, String)", new Boolean(result), new Object[]{principal});
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set getUsersInRole(String roleName) throws Exception {
        Set set;
        HashSet<String> result;
        block16: {
            HashSet<String> hashSet;
            block15: {
                String METHOD = "getUsersInRole()";
                result = null;
                try {
                    try {
                        RoleData role;
                        R3PersistenceBase.LogUtil.logEntering(LOG, "getUsersInRole()", new Object[]{roleName});
                        if (this._bapiUserGetList != null) {
                            LOG.debugT("getUsersInRole()", "Using BAPI_USER_GETLIST for reading users in role");
                            R3JCoProxy.Client client = this._backendProxy.getClient();
                            try {
                                Calendar calendar = Calendar.getInstance();
                                int year = calendar.get(1);
                                int month = calendar.get(2) + 1;
                                int day = calendar.get(5);
                                String todayABAPFormat = year + (month < 10 ? "0" : "") + month + (day < 10 ? "0" : "") + day;
                                LOG.debugT("getUsersInRole()", "Current date in ABAP format: {0}", new Object[]{todayABAPFormat});
                                R3JCoProxy.Function func = this._bapiUserGetList.getFunction();
                                R3JCoProxy.Table selectionRange = func.getTableParameterList().getTable("SELECTION_RANGE");
                                selectionRange.appendRow();
                                selectionRange.setValue((Object)"ACTIVITYGROUPS", "PARAMETER");
                                selectionRange.setValue((Object)"AGR_NAME", "FIELD");
                                selectionRange.setValue((Object)"I", "SIGN");
                                selectionRange.setValue((Object)"EQ", "OPTION");
                                selectionRange.setValue((Object)roleName, "LOW");
                                selectionRange.appendRow();
                                selectionRange.setValue((Object)"ACTIVITYGROUPS", "PARAMETER");
                                selectionRange.setValue((Object)"FROM_DAT", "FIELD");
                                selectionRange.setValue((Object)"I", "SIGN");
                                selectionRange.setValue((Object)"LE", "OPTION");
                                selectionRange.setValue((Object)todayABAPFormat, "LOW");
                                selectionRange.appendRow();
                                selectionRange.setValue((Object)"ACTIVITYGROUPS", "PARAMETER");
                                selectionRange.setValue((Object)"TO_DAT", "FIELD");
                                selectionRange.setValue((Object)"I", "SIGN");
                                selectionRange.setValue((Object)"GE", "OPTION");
                                selectionRange.setValue((Object)todayABAPFormat, "LOW");
                                client.execute(func);
                                this.logFunction("getUsersInRole()", func);
                                R3JCoProxy.Table returnTab = func.getTableParameterList().getTable("RETURN");
                                this.handleBapiRet2Table("getUsersInRole()", "BAPI_USER_GETLIST", returnTab);
                                R3JCoProxy.Table userlist = func.getTableParameterList().getTable("USERLIST");
                                if (userlist.getNumRows() != 0) {
                                    result = new HashSet<String>();
                                    int i = 0;
                                    while (true) {
                                        if (i >= userlist.getNumRows()) break;
                                        userlist.setRow(i);
                                        String userName = userlist.getString("USERNAME");
                                        result.add(userName);
                                        ++i;
                                    }
                                    HashSet directUsers = new HashSet(result);
                                    int numberDirectUsers = directUsers.size();
                                    LOG.debugT("getUsersInRole()", "{0} directly assigned users found. Search users that have one of them as reference user", new Object[]{new Integer(numberDirectUsers)});
                                    func = this._bapiUserGetList.getFunction();
                                    int BLOCKSIZE = 100;
                                    Iterator directUserIterator = directUsers.iterator();
                                    int userNr = 0;
                                    while (true) {
                                        if (userNr > numberDirectUsers) break;
                                        if (userNr != numberDirectUsers) {
                                            String userName = (String)directUserIterator.next();
                                            selectionRange = func.getTableParameterList().getTable("SELECTION_RANGE");
                                            selectionRange.appendRow();
                                            selectionRange.setValue((Object)"REF_USER", "PARAMETER");
                                            selectionRange.setValue((Object)"REF_USER", "FIELD");
                                            selectionRange.setValue((Object)"I", "SIGN");
                                            selectionRange.setValue((Object)"EQ", "OPTION");
                                            selectionRange.setValue((Object)userName, "LOW");
                                        }
                                        if (userNr == numberDirectUsers || (userNr + 1) % 100 == 0) {
                                            client.execute(func);
                                            this.logFunction("getUsersInRole()", func);
                                            returnTab = func.getTableParameterList().getTable("RETURN");
                                            this.handleBapiRet2Table("getUsersInRole()", "BAPI_USER_GETLIST", returnTab);
                                            R3JCoProxy.Table refUserList = func.getTableParameterList().getTable("USERLIST");
                                            int refUserNr = 0;
                                            while (true) {
                                                if (refUserNr >= refUserList.getNumRows()) {
                                                    if (userNr == numberDirectUsers) break;
                                                    func = this._bapiUserGetList.getFunction();
                                                    break;
                                                }
                                                refUserList.setRow(refUserNr);
                                                String userName = refUserList.getString("USERNAME");
                                                result.add(userName);
                                                ++refUserNr;
                                            }
                                        }
                                        ++userNr;
                                    }
                                    HashSet<String> hashSet2 = result;
                                    Object var24_21 = null;
                                    this._backendProxy.releaseClient(client);
                                    Object var26_24 = null;
                                    R3PersistenceBase.LogUtil.logExiting(LOG, "getUsersInRole()", result);
                                    return hashSet2;
                                }
                                LOG.debugT("getUsersInRole()", "No users assigned to role");
                                hashSet = result = null;
                                Object var24_20 = null;
                                this._backendProxy.releaseClient(client);
                            }
                            catch (Throwable throwable) {
                                Object var24_22 = null;
                                this._backendProxy.releaseClient(client);
                                throw throwable;
                            }
                            Object var26_23 = null;
                            break block15;
                        }
                        Buffer readBuffer = this._activeBuffer;
                        if (!readBuffer.userCacheFilled) {
                            this.checkBufferRefresh(true, false, true);
                            readBuffer = this._activeBuffer;
                        }
                        set = (role = (RoleData)readBuffer.roles.get(roleName)) != null ? role.memberUsers : null;
                        break block16;
                    }
                    catch (Exception e) {
                        R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "getUsersInRole()", e);
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    Object var26_26 = null;
                    R3PersistenceBase.LogUtil.logExiting(LOG, "getUsersInRole()", result);
                    throw throwable;
                }
            }
            R3PersistenceBase.LogUtil.logExiting(LOG, "getUsersInRole()", result);
            return hashSet;
        }
        Object var26_25 = null;
        R3PersistenceBase.LogUtil.logExiting(LOG, "getUsersInRole()", result);
        return set;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean principalDatabagExists(IPrincipalDatabag principal) throws PersistenceException {
        boolean bl;
        String METHOD = "principalDatabagExists()";
        boolean result = false;
        try {
            try {
                R3PersistenceBase.LogUtil.logEntering(LOG, "principalDatabagExists()", new Object[]{principal});
                this.assertInitialization();
                Buffer currentBuffer = this._activeBuffer;
                String[] parts = principal.getIDParts();
                if (this.PRINCIPAL_TYPE.equals(parts[0]) && this.getId().equals(parts[1]) && currentBuffer.roles.containsKey(parts[2])) {
                    result = true;
                }
                bl = result;
                Object var8_9 = null;
            }
            catch (Exception e) {
                PersistenceException pe = this.newPersistenceException(LOG, "principalDatabagExists()", e);
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "principalDatabagExists()", (Throwable)((Object)pe));
                throw pe;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "principalDatabagExists()", new Boolean(result));
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "principalDatabagExists()", new Boolean(result));
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public R3PersistenceBase.IPersistenceCollection searchPrincipalDatabags(R3PersistenceBase.ISearchCriteria criteria) throws PersistenceException {
        R3PersistenceBase.IPersistenceCollection iPersistenceCollection;
        R3PersistenceBase.IPersistenceCollection result;
        block22: {
            ISearchAttribute attribute;
            block21: {
                R3PersistenceBase.IPersistenceCollection iPersistenceCollection2;
                block20: {
                    String METHOD = "searchPrincipalDatabags()";
                    result = null;
                    try {
                        try {
                            R3PersistenceBase.LogUtil.logEntering(LOG, "searchPrincipalDatabags()", new Object[]{criteria});
                            this.assertInitialization();
                            String searchType = criteria.getPrincipalType();
                            if (!this.PRINCIPAL_TYPE.equals(searchType)) {
                                LOG.debugT("searchPrincipalDatabags()", "Not responsible for objects of type {0}, but for {1}", new Object[]{searchType, this.PRINCIPAL_TYPE});
                                iPersistenceCollection2 = result = null;
                                Object var16_9 = null;
                                break block20;
                            }
                            LinkedList<R3PersistenceBase.IPersistenceCollection> searchResults = new LinkedList<R3PersistenceBase.IPersistenceCollection>();
                            int i = 0;
                            while (true) {
                                if (i >= criteria.getElementSize()) {
                                    if (searchResults.size() != 0) break;
                                    LOG.debugT("searchPrincipalDatabags()", "No responsible attributes to search for found");
                                    result = null;
                                    attribute = result;
                                    break block21;
                                }
                                attribute = criteria.getAttribute(i);
                                String namespace = attribute.getAttributeNameSpace();
                                String name = attribute.getAttributeName();
                                Object searchObject = attribute.getAttributeValue();
                                int operator = attribute.getOperator();
                                boolean caseSensitive = attribute.isCaseSensitive();
                                if (!this.feelsResponsible(searchType, namespace, name)) {
                                    LOG.debugT("searchPrincipalDatabags()", "Not responsible for type {0} namespace {1} name {2}. Ignoring.", new Object[]{searchType, namespace, name});
                                } else {
                                    R3PersistenceBase.IPersistenceCollection singleResult;
                                    if (searchObject == null) {
                                        throw new PersistenceException("R3RoleDataSource asked to search for attribute " + name + " with value <null>");
                                    }
                                    if (!(searchObject instanceof String)) {
                                        throw new PersistenceException("Attribute " + name + " should be searched with value that is no string, but of type \"" + searchObject.getClass().getName() + "\" with value \"" + searchObject.toString() + "\"");
                                    }
                                    String searchString = (String)searchObject;
                                    if ("com.sap.security.core.usermanagement".equals(namespace) && ("uniquename".equals(name) || "displayname".equals(name))) {
                                        singleResult = this.doSearchByName(searchString, operator, caseSensitive);
                                    } else if ("com.sap.security.core.usermanagement".equals(namespace) && "description".equals(name)) {
                                        singleResult = this.doSearchByDescription(searchString, operator, caseSensitive);
                                    } else {
                                        if (!MEMBER_NS.equals(namespace)) throw new PersistenceException("Search for attribute " + name + " in namespace " + namespace + " is not supported by R3RoleDataSource");
                                        if (!MEMBER_ATT.equals(name)) throw new PersistenceException("Search for attribute " + name + " in namespace " + namespace + " is not supported by R3RoleDataSource");
                                        singleResult = this.doSearchByMember(searchString);
                                    }
                                    searchResults.add(singleResult);
                                }
                                ++i;
                            }
                            if (searchResults.size() == 1) {
                                result = (R3PersistenceBase.IPersistenceCollection)searchResults.getFirst();
                            } else {
                                R3PersistenceBase.IPersistenceCollection[] results = searchResults.toArray(new R3PersistenceBase.IPersistenceCollection[0]);
                                result = criteria.isOrMode() ? this.buildUnion(results) : this.buildIntersection(results);
                            }
                            int actualResults = result.size();
                            int maxResults = criteria.getSearchSizeLimit();
                            if (maxResults > 0 && actualResults > maxResults) {
                                LOG.debugT("searchPrincipalDatabags()", "Search delivered " + actualResults + " records but only " + maxResults + " shall be returned. Discarding the rest.");
                                R3PersistenceBase.PersistenceCollection newResult = new R3PersistenceBase.PersistenceCollection(maxResults);
                                Iterator it = result.iterator();
                                int i2 = 0;
                                while (true) {
                                    if (i2 >= maxResults) {
                                        result = newResult;
                                        criteria.errorOccurred(4);
                                        break;
                                    }
                                    newResult.add(it.next());
                                    ++i2;
                                }
                            }
                            iPersistenceCollection = result;
                            break block22;
                        }
                        catch (Exception e) {
                            PersistenceException pe = this.newPersistenceException(LOG, "searchPrincipalDatabags()", e);
                            LOG.logWarningT("Search in the backend resulted in an exception. The search result returned to the application might be incomplete. Reason: {0}.", new Object[]{e.getMessage() != null ? e.getMessage() : e.getLocalizedMessage()});
                            R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "searchPrincipalDatabags()", (Throwable)((Object)pe));
                            throw pe;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var16_12 = null;
                        R3PersistenceBase.LogUtil.logExiting(LOG, "searchPrincipalDatabags()", result);
                        throw throwable;
                    }
                }
                R3PersistenceBase.LogUtil.logExiting(LOG, "searchPrincipalDatabags()", result);
                return iPersistenceCollection2;
            }
            Object var16_10 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "searchPrincipalDatabags()", result);
            return attribute;
        }
        Object var16_11 = null;
        R3PersistenceBase.LogUtil.logExiting(LOG, "searchPrincipalDatabags()", result);
        return iPersistenceCollection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private R3PersistenceBase.IPersistenceCollection doSearchByName(String searchNameIn, int operator, boolean caseSensitive) throws Exception {
        String METHOD = "doSearchByName()";
        R3PersistenceBase.PersistenceCollection result = null;
        try {
            try {
                String searchName;
                R3PersistenceBase.LogUtil.logEntering(LOG, "doSearchByName()", new Object[]{searchNameIn, new Integer(operator), new Boolean(caseSensitive)});
                Buffer currentBuffer = this._activeBuffer;
                result = new R3PersistenceBase.PersistenceCollection();
                String string = searchName = caseSensitive ? searchNameIn : R3PersistenceBase.Util.charWiseUpperCase(searchNameIn);
                if (operator == 0) {
                    if (currentBuffer.roles.containsKey(searchName)) {
                        result.add(this._nameCreator.getExternalRoleName(searchName));
                    }
                } else {
                    R3PersistenceBase.PatternMatcher patternMatcher = new R3PersistenceBase.PatternMatcher(searchName, false, caseSensitive);
                    Iterator roleIterator = currentBuffer.roles.keySet().iterator();
                    block9: while (roleIterator.hasNext()) {
                        String roleName = (String)roleIterator.next();
                        switch (operator) {
                            case 1: {
                                if (!patternMatcher.matches(roleName)) continue block9;
                                result.add(this._nameCreator.getExternalRoleName(roleName));
                                break;
                            }
                            case 2: {
                                if (roleName.compareTo(searchName) <= 0) continue block9;
                                result.add(this._nameCreator.getExternalRoleName(roleName));
                                break;
                            }
                            case 3: {
                                if (roleName.compareTo(searchName) >= 0) continue block9;
                                result.add(this._nameCreator.getExternalRoleName(roleName));
                                break;
                            }
                            default: {
                                throw new PersistenceException("Search operator " + operator + " unknown");
                            }
                        }
                    }
                }
                R3PersistenceBase.PersistenceCollection persistenceCollection = result;
                Object var12_12 = null;
                R3PersistenceBase.LogUtil.logExiting(LOG, "doSearchByName()", result);
                return persistenceCollection;
            }
            catch (Exception e) {
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "doSearchByName()", e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "doSearchByName()", result);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private R3PersistenceBase.IPersistenceCollection doSearchByDescription(String searchDescriptionIn, int operator, boolean caseSensitive) throws Exception {
        String METHOD = "doSearchByDescription()";
        R3PersistenceBase.PersistenceCollection result = null;
        try {
            try {
                R3PersistenceBase.LogUtil.logEntering(LOG, "doSearchByDescription()", new Object[]{searchDescriptionIn, new Integer(operator), new Boolean(caseSensitive)});
                Buffer currentBuffer = this._activeBuffer;
                result = new R3PersistenceBase.PersistenceCollection();
                String searchDescription = caseSensitive ? searchDescriptionIn : R3PersistenceBase.Util.charWiseUpperCase(searchDescriptionIn);
                R3PersistenceBase.PatternMatcher patternMatcher = new R3PersistenceBase.PatternMatcher(searchDescription, false, caseSensitive);
                Iterator roleIterator = currentBuffer.roles.keySet().iterator();
                block10: while (roleIterator.hasNext()) {
                    String roleName = (String)roleIterator.next();
                    RoleData roleData = (RoleData)currentBuffer.roles.get(roleName);
                    String description = caseSensitive ? roleData.description : R3PersistenceBase.Util.charWiseUpperCase(roleData.description);
                    switch (operator) {
                        case 0: {
                            if (!description.equals(searchDescription)) continue block10;
                            result.add(this._nameCreator.getExternalRoleName(roleName));
                            break;
                        }
                        case 1: {
                            if (!patternMatcher.matches(description)) continue block10;
                            result.add(this._nameCreator.getExternalRoleName(roleName));
                            break;
                        }
                        case 2: {
                            if (description.compareTo(searchDescription) <= 0) continue block10;
                            result.add(this._nameCreator.getExternalRoleName(roleName));
                            break;
                        }
                        case 3: {
                            if (description.compareTo(searchDescription) >= 0) continue block10;
                            result.add(this._nameCreator.getExternalRoleName(roleName));
                            break;
                        }
                        default: {
                            throw new PersistenceException("Search operator " + operator + " unknown");
                        }
                    }
                }
                R3PersistenceBase.PersistenceCollection persistenceCollection = result;
                Object var14_14 = null;
                R3PersistenceBase.LogUtil.logExiting(LOG, "doSearchByDescription()", result);
                return persistenceCollection;
            }
            catch (Exception e) {
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "doSearchByDescription()", e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "doSearchByDescription()", result);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private R3PersistenceBase.IPersistenceCollection doSearchByMember(String member) throws Exception {
        R3PersistenceBase.PersistenceCollection persistenceCollection;
        String METHOD = "doSearchByDescription()";
        R3PersistenceBase.PersistenceCollection result = null;
        try {
            try {
                R3PersistenceBase.LogUtil.logEntering(LOG, "doSearchByDescription()", new Object[]{member});
                Buffer currentBuffer = this._activeBuffer;
                result = new R3PersistenceBase.PersistenceCollection();
                String[] parts = this.splitPrincipalDatabagID(member);
                String type = parts[0];
                String dataSourceID = parts[1];
                String name = parts[2];
                if (this.PRINCIPAL_TYPE.equals(type) && this.getId().equals(dataSourceID)) {
                    RoleData roleData = (RoleData)currentBuffer.roles.get(name);
                    if (roleData != null && roleData.memberOf != null) {
                        Iterator parentIterator = roleData.memberOf.iterator();
                        while (parentIterator.hasNext()) {
                            RoleData parent = (RoleData)parentIterator.next();
                            result.add(this._nameCreator.getExternalRoleName(parent.name));
                        }
                    }
                } else if ("USER".equals(type) && this._userDatasourceID.equals(dataSourceID)) {
                    R3JCoProxy.Function func = this._prgnJ2eeUserGetRolenames.getFunction();
                    R3JCoProxy.ParameterList imports = func.getImportParameterList();
                    imports.setValue(name, "IF_UNAME");
                    if (this._noDerivedRoles) {
                        imports.setValue("X", "IF_REPLACE_DERIVED");
                    }
                    R3JCoProxy.Client client = this._backendProxy.getClient();
                    try {
                        client.execute(func);
                        this.logFunction("doSearchByDescription()", func);
                        Object var13_15 = null;
                        this._backendProxy.releaseClient(client);
                    }
                    catch (Throwable throwable) {
                        Object var13_16 = null;
                        this._backendProxy.releaseClient(client);
                        throw throwable;
                    }
                    R3JCoProxy.ParameterList tables = func.getTableParameterList();
                    R3JCoProxy.Table tabReturn = tables.getTable("ET_RETURN");
                    this.handleBapiRet2Table("doSearchByDescription()", func.getName(), tabReturn);
                    R3JCoProxy.Table roleTab = tables.getTable("ET_AGR");
                    int numRoles = roleTab.getNumRows();
                    int i = 0;
                    while (i < numRoles) {
                        roleTab.setRow(i);
                        String roleName = roleTab.getString("AGR_NAME");
                        if (currentBuffer.roles.containsKey(roleName)) {
                            result.add(this._nameCreator.getExternalRoleName(roleName));
                        }
                        ++i;
                    }
                } else {
                    LOG.debugT("doSearchByDescription()", "Search request for principal type " + type + " in data source " + dataSourceID + ". Returning empty result.");
                }
                persistenceCollection = result;
                Object var19_23 = null;
            }
            catch (Exception e) {
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "doSearchByDescription()", e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var19_24 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "doSearchByDescription()", result);
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "doSearchByDescription()", result);
        return persistenceCollection;
    }

    public IDataSourceTransaction beginTransaction() throws PersistenceException {
        return new R3RoleDataSourceTransaction();
    }

    public boolean checkCredentials(R3PersistenceBase.IPersistenceMap credentials) throws PersistenceException {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void checkBufferRefresh(boolean fillUserAssignments, boolean invalidateGroupFactoryCache, boolean forceRefresh) throws Exception {
        block30: {
            String METHOD = "checkBufferRefresh()";
            R3JCoProxy.Client client = null;
            try {
                block32: {
                    try {
                        HashMap<String, RoleData> newRoleBuffer;
                        int numRoles;
                        R3JCoProxy.Table roleTab;
                        R3JCoProxy.Table tabReturn;
                        R3JCoProxy.ParameterList tables;
                        R3JCoProxy.ParameterList imports;
                        R3JCoProxy.Function func;
                        block31: {
                            int i;
                            int numColl;
                            R3JCoProxy.Table collTab;
                            String language;
                            R3PersistenceBase.LogUtil.logEntering(LOG, "checkBufferRefresh()");
                            if (!(this._activeBuffer == null || forceRefresh || System.currentTimeMillis() >= this._activeBuffer.creationTime + (long)this._bufferRefreshIntervalMinutes * 60000L || fillUserAssignments && !this._activeBuffer.userCacheFilled)) {
                                LOG.debugT("checkBufferRefresh()", "Buffer does not need to be refreshed");
                                Object var37_6 = null;
                                this._backendProxy.releaseClient(client);
                                break block30;
                            }
                            client = this._backendProxy.getClient();
                            func = this._prgnJ2eeGetRoles.getFunction();
                            imports = func.getImportParameterList();
                            Locale loc = Locale.getDefault();
                            if (loc != null && (language = loc.getLanguage()) != null) {
                                imports.setValue(R3PersistenceBase.Util.charWiseUpperCase(language), "IF_LAISO");
                            }
                            if (this._noDerivedRoles) {
                                imports.setValue("X", "IF_REPLACE_DERIVED");
                            }
                            client.execute(func);
                            this.logFunction("checkBufferRefresh()", func);
                            tables = func.getTableParameterList();
                            tabReturn = tables.getTable("ET_RETURN");
                            this.handleBapiRet2Table("checkBufferRefresh()", func.getName(), tabReturn);
                            roleTab = tables.getTable("ET_AGR");
                            numRoles = roleTab.getNumRows();
                            newRoleBuffer = new HashMap<String, RoleData>();
                            int i2 = 0;
                            while (true) {
                                boolean isCollective;
                                if (i2 >= numRoles) {
                                    if (this.PRINCIPAL_TYPE == "GRUP") {
                                        collTab = tables.getTable("ET_COLL_AGR");
                                        numColl = collTab.getNumRows();
                                        i = 0;
                                        break;
                                    }
                                    break block31;
                                }
                                roleTab.setRow(i2);
                                String roleName = roleTab.getString("AGR_NAME");
                                String description = roleTab.getString("TEXT");
                                boolean bl = isCollective = roleTab.getChar("FLAG_COLL") == 'X';
                                if (!isCollective || this.PRINCIPAL_TYPE == "GRUP") {
                                    newRoleBuffer.put(roleName, new RoleData(roleName, description));
                                }
                                ++i2;
                            }
                            while (i < numColl) {
                                collTab.setRow(i);
                                String collAgr = collTab.getString("COLL_AGR");
                                String childAgr = collTab.getString("CHILD_AGR");
                                RoleData collData = (RoleData)newRoleBuffer.get(collAgr);
                                RoleData childData = (RoleData)newRoleBuffer.get(childAgr);
                                if (collData == null || childData == null) {
                                    LOG.logInfoT("Function module PRGN_J2EE_GET_ROLES specifies that collective role {0} has child role {1}, but the role {2} does not exist in table ET_AGR. Ignoring this relation.", new Object[]{collAgr, childAgr, collData == null ? collAgr : childAgr});
                                } else if (!this._collectiveGroupsAsParents) {
                                    collData.addMemberOf(childData);
                                    childData.addMember(collData);
                                } else {
                                    childData.addMemberOf(collData);
                                    collData.addMember(childData);
                                }
                                ++i;
                            }
                        }
                        Buffer newBuffer = new Buffer();
                        newBuffer.roles = newRoleBuffer;
                        if (fillUserAssignments) {
                            LOG.logInfoT("The version of the ABAP backend system " + this._systemId + " is below SAP_BASIS 6.20 Support Package 38. " + "Some operations of the R3RoleDataSource therefore " + "require a workaround that is unfavourable regarding " + "performance. See SAP Note 757064 for further " + "details.", null);
                            R3JCoProxy.Function helpFunc = this._backendProxy.getRepository().getFunctionTemplate("BAPI_HELPVALUES_GET").getFunction();
                            imports = helpFunc.getImportParameterList();
                            imports.setValue("USER", "OBJNAME");
                            imports.setValue("GetDetail", "METHOD");
                            imports.setValue("UserName", "PARAMETER");
                            imports.getStructure("EXPLICIT_SHLP").setValue("USER_ADDR", "SHLPNAME");
                            imports.getStructure("EXPLICIT_SHLP").setValue("SH", "SHLPTYPE");
                            R3JCoProxy.Table selection = helpFunc.getTableParameterList().getTable("SELECTION_FOR_HELPVALUES");
                            selection.appendRow();
                            selection.setValue((Object)"BNAME", "SELECT_FLD");
                            selection.setValue((Object)"I", "SIGN");
                            selection.setValue((Object)"CP", "OPTION");
                            selection.setValue((Object)"*", "LOW");
                            client.execute(helpFunc);
                            this.logFunction("checkBufferRefresh()", helpFunc);
                            R3JCoProxy.Structure strucReturn = helpFunc.getExportParameterList().getStructure("RETURN");
                            String msgType = strucReturn.getString("TYPE");
                            String msgCode = strucReturn.getString("CODE");
                            String msgText = strucReturn.getString("MESSAGE");
                            if ("E".equals(msgType)) throw new PersistenceException("Function module BAPI_HEPLVALUES_GET has thrown an exception: TYPE " + msgType + ", CODE " + msgCode + ", MESSAGE " + msgText);
                            if ("A".equals(msgType)) throw new PersistenceException("Function module BAPI_HEPLVALUES_GET has thrown an exception: TYPE " + msgType + ", CODE " + msgCode + ", MESSAGE " + msgText);
                            if ("X".equals(msgType)) {
                                throw new PersistenceException("Function module BAPI_HEPLVALUES_GET has thrown an exception: TYPE " + msgType + ", CODE " + msgCode + ", MESSAGE " + msgText);
                            }
                            R3JCoProxy.Table descTab = helpFunc.getTableParameterList().getTable("DESCRIPTION_FOR_HELPVALUES");
                            int startIndex = -1;
                            int length = 0;
                            int i = 0;
                            while (i < descTab.getNumRows()) {
                                descTab.setRow(i);
                                if ("BNAME".equals(descTab.getString("FIELDNAME"))) {
                                    startIndex = descTab.getInt("OFFSET");
                                    length = descTab.getInt("LENG");
                                    break;
                                }
                                ++i;
                            }
                            if (startIndex == -1) {
                                throw new PersistenceException("BAPI_HELPVALUES_GET does not return location of BNAME field in result list");
                            }
                            R3JCoProxy.Table helpvalues = helpFunc.getTableParameterList().getTable("HELPVALUES");
                            int numUsers = helpvalues.getNumRows();
                            int userNr = 0;
                            block7: while (true) {
                                if (userNr >= numUsers) {
                                    newBuffer.userCacheFilled = true;
                                    break;
                                }
                                helpvalues.setRow(userNr);
                                String line = helpvalues.getString("HELPVALUES");
                                int linelen = line.length();
                                if (startIndex >= linelen) {
                                    throw new PersistenceException("Position of BNAME (" + startIndex + ") exceeds line length (" + linelen + ") for line " + userNr);
                                }
                                int endIndex = startIndex + length;
                                if (endIndex > linelen) {
                                    endIndex = linelen;
                                }
                                String userName = R3PersistenceBase.Util.trimTrailing(line.substring(startIndex, endIndex));
                                func = this._prgnJ2eeUserGetRolenames.getFunction();
                                imports = func.getImportParameterList();
                                imports.setValue(userName, "IF_UNAME");
                                if (this._noDerivedRoles) {
                                    imports.setValue("X", "IF_REPLACE_DERIVED");
                                }
                                client.execute(func);
                                this.logFunction("checkBufferRefresh()", func);
                                tables = func.getTableParameterList();
                                tabReturn = tables.getTable("ET_RETURN");
                                this.handleBapiRet2Table("checkBufferRefresh()", func.getName(), tabReturn);
                                roleTab = tables.getTable("ET_AGR");
                                numRoles = roleTab.getNumRows();
                                int roleNr = 0;
                                while (true) {
                                    if (roleNr >= numRoles) {
                                        ++userNr;
                                        continue block7;
                                    }
                                    roleTab.setRow(roleNr);
                                    String roleName = roleTab.getString("AGR_NAME");
                                    RoleData role = (RoleData)newBuffer.roles.get(roleName);
                                    if (role != null) {
                                        if (role.memberUsers == null) {
                                            role.memberUsers = new HashSet();
                                        }
                                        role.memberUsers.add(userName);
                                    }
                                    ++roleNr;
                                }
                                break;
                            }
                        }
                        newBuffer.creationTime = System.currentTimeMillis();
                        this._activeBuffer = newBuffer;
                        if (!invalidateGroupFactoryCache) break block32;
                        Thread umeGroupRefreshThread = new Thread(new Runnable(){

                            /*
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            public void run() {
                                String METHOD = "groupCacheRefresh.run()";
                                try {
                                    try {
                                        R3PersistenceBase.LogUtil.logEntering(LOG, "groupCacheRefresh.run()");
                                        IGroupFactory gf = UMFactory.getGroupFactory();
                                        if (!(gf instanceof GroupFactory)) {
                                            String string;
                                            StringBuffer stringBuffer = new StringBuffer().append("Got unknown group factory object from UME: ");
                                            if (gf != null) {
                                                string = gf.getClass().getName();
                                                throw new Exception(stringBuffer.append(string).toString());
                                            }
                                            string = "NULL";
                                            throw new Exception(stringBuffer.append(string).toString());
                                        }
                                        GroupFactory.invalidateCache(false);
                                        LOG.debugT("groupCacheRefresh.run()", "UME group cache invalidated");
                                        Object var4_4 = null;
                                    }
                                    catch (Exception e) {
                                        R3PersistenceBase.LogUtil.logThrowable(2, LOG, "groupCacheRefresh.run()", "Exception during refresh of UME role cache", new Object[0], e);
                                        Object var4_5 = null;
                                        R3PersistenceBase.LogUtil.logExiting(LOG, "groupCacheRefresh.run()");
                                        return;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var4_6 = null;
                                    R3PersistenceBase.LogUtil.logExiting(LOG, "groupCacheRefresh.run()");
                                    throw throwable;
                                }
                                R3PersistenceBase.LogUtil.logExiting(LOG, "groupCacheRefresh.run()");
                            }
                        }, "UMEGroupCacheRefresh");
                        umeGroupRefreshThread.start();
                    }
                    catch (Exception e) {
                        R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "checkBufferRefresh()", e);
                        throw e;
                    }
                }
                Object var37_7 = null;
                this._backendProxy.releaseClient(client);
                R3PersistenceBase.LogUtil.logExiting(LOG, "checkBufferRefresh()");
                return;
            }
            catch (Throwable throwable) {
                Object var37_8 = null;
                this._backendProxy.releaseClient(client);
                R3PersistenceBase.LogUtil.logExiting(LOG, "checkBufferRefresh()");
                throw throwable;
            }
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "checkBufferRefresh()");
    }

    public static void refreshUser(String uniqueName) throws PersistenceException {
    }

    public static synchronized void refreshRoleBuffer(boolean invalidateUMEGroupCache) {
        String METHOD = "refreshRoleBuffer()";
        Iterator instanceIterator = _instances.iterator();
        while (instanceIterator.hasNext()) {
            R3RoleDataSource dataSource = (R3RoleDataSource)instanceIterator.next();
            LOG.logInfoT("Explicit refresh of backend role cache in R3RoleDataSource requested", null);
            try {
                dataSource.checkBufferRefresh(false, invalidateUMEGroupCache, true);
            }
            catch (Exception e) {
                R3PersistenceBase.LogUtil.logThrowable(1, LOG, "refreshRoleBuffer()", "Exception during refresh of role cache in R3RoleDataSource on explicit request", null, e);
            }
        }
    }

    private void updatePrincipalDatabag(IInternalPrincipalDatabagMaint principalMaint) throws PersistenceException {
        R3PersistenceBase.InternalPrincipalDatabagMaintWrapper principalMaintX = new R3PersistenceBase.InternalPrincipalDatabagMaintWrapper(principalMaint);
        String METHOD = "updatePrincipalDatabag()";
        try {
            try {
                R3PersistenceBase.LogUtil.logEntering(LOG, "updatePrincipalDatabag()", new Object[]{principalMaint});
                if (LOG.beDebug()) {
                    LOG.debugT("updatePrincipalDatabag()", R3RoleDataSource.getUpdateDump(principalMaint));
                }
                String type = principalMaint.getIDParts()[0];
                String dsId = principalMaint.getIDParts()[1];
                String uniquename = principalMaint.getIDParts()[2];
                if (!"ROLE".equals(type) || !this.getId().equals(dsId) || this.isReadonly() || !this.feelsResponsible(MEMBER_NS, MEMBER_ATT)) {
                    throw new PersistenceException("Datasource \"" + this.getId() + "\" cannot update principal \"" + principalMaint.getUniqueID() + "\" because of either configuration settings " + "or wrong type");
                }
                if (!this._activeBuffer.roles.containsKey(uniquename)) {
                    throw new PersistenceException("Role \"" + uniquename + "\" cannot be updated because it is not visible " + "for R3RoleDataSource");
                }
                R3PersistenceBase.IPersistenceCollection currentUsers = principalMaintX.getReadValues(MEMBER_NS, MEMBER_ATT);
                if (currentUsers == null) {
                    this.populatePrincipalDatabag(principalMaint, MEMBER_NS, MEMBER_ATT);
                    currentUsers = principalMaintX.getReadValues(MEMBER_NS, MEMBER_ATT);
                }
                currentUsers = (R3PersistenceBase.IPersistenceCollection)currentUsers.clone();
                R3PersistenceBase.IPersistenceCollection finalUsers = principalMaintX.getValues(MEMBER_NS, MEMBER_ATT);
                if (finalUsers == null) {
                    finalUsers = new R3PersistenceBase.PersistenceCollection();
                }
                R3JCoProxy.Client client = null;
                try {
                    client = this._backendProxy.getClient();
                    Iterator it = finalUsers.iterator();
                    while (it.hasNext()) {
                        String finalUser = (String)it.next();
                        if (currentUsers.contains(finalUser)) continue;
                        this.doAssignmentChange(client, uniquename, finalUser, false);
                    }
                    Iterator it2 = currentUsers.iterator();
                    while (it2.hasNext()) {
                        String currentUser = (String)it2.next();
                        if (finalUsers.contains(currentUser)) continue;
                        this.doAssignmentChange(client, uniquename, currentUser, true);
                    }
                    Object var14_15 = null;
                    this._backendProxy.releaseClient(client);
                }
                catch (Throwable throwable) {
                    Object var14_16 = null;
                    this._backendProxy.releaseClient(client);
                    throw throwable;
                }
                Object var16_18 = null;
            }
            catch (Exception e) {
                PersistenceException pe = this.newPersistenceException(LOG, "updatePrincipalDatabag()", e);
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "updatePrincipalDatabag()", (Throwable)((Object)pe));
                throw pe;
            }
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "updatePrincipalDatabag()", new Object[]{principalMaint});
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "updatePrincipalDatabag()", new Object[]{principalMaint});
    }

    private void doAssignmentChange(R3JCoProxy.Client client, String rolename, String memberID, boolean remove) throws Exception {
        RoleData role;
        String[] memberParts = this.splitPrincipalDatabagID(memberID);
        if (!"USER".equals(memberParts[0])) {
            throw new PersistenceException("Unable to change assignment of " + memberID + " to role " + rolename + ". Only users can be added/removed from roles.");
        }
        if (!this._userDatasourceID.equals(memberParts[1])) {
            throw new PersistenceException("R3RoleDataSource with ID \"" + this.getId() + "\" can only process " + "members located in the attached user data " + "source with ID \"" + this._userDatasourceID + "\". Incoming member: " + memberID + ".");
        }
        String userName = memberParts[2];
        R3JCoProxy.Function bugd = this._backendProxy.getRepository().getFunctionTemplate("BAPI_USER_GET_DETAIL").getFunction();
        bugd.getImportParameterList().setValue(userName, "USERNAME");
        R3JCoProxy.ParameterList tables = bugd.getTableParameterList();
        int fieldCnt = tables.getFieldCount();
        int i = 0;
        while (i < fieldCnt) {
            tables.setActive(false, i);
            ++i;
        }
        tables.setActive(true, "RETURN");
        tables.setActive(true, "ACTIVITYGROUPS");
        client.execute(bugd);
        this.logFunction("doAssignmentChange", bugd);
        R3JCoProxy.Table ret = tables.getTable("RETURN");
        this.handleBapiRet2Table("doAssignmentChange", "BAPI_USER_GET_DETAIL", ret);
        R3JCoProxy.Table roleTab = tables.getTable("ACTIVITYGROUPS");
        String refUser = bugd.getExportParameterList().getStructure("REF_USER").getString("REF_USER");
        int currentRoleNum = roleTab.getNumRows();
        boolean deletionDone = false;
        int i2 = 0;
        while (i2 < currentRoleNum) {
            roleTab.setRow(i2);
            String thisRole = roleTab.getString("AGR_NAME");
            char orgFlag = roleTab.getChar("ORG_FLAG");
            String fromDat = roleTab.getString("FROM_DAT");
            String toDat = roleTab.getString("TO_DAT");
            if (thisRole.equals(rolename)) {
                if (!remove) {
                    throw new PersistenceException("Role " + rolename + " cannot be added to user " + userName + " because this role is already assigned " + " with validity " + fromDat + " to " + toDat);
                }
                if (orgFlag != ' ') {
                    throw new PersistenceException("Role " + rolename + " cannot be removed from user " + userName + " because it is assigned to the user via " + "collective role " + "or Organization Management (ORG_FLAG = '" + orgFlag + "')");
                }
                if (deletionDone) {
                    throw new PersistenceException("Role " + rolename + " cannot be removed from user " + userName + " because it is assigned to this user " + "multiple times in the backend");
                }
                roleTab.deleteRow();
                deletionDone = true;
            }
            ++i2;
        }
        if (!remove) {
            roleTab.appendRow();
            roleTab.setValue((Object)rolename, "AGR_NAME");
        } else if (!deletionDone) {
            throw new PersistenceException("Role " + rolename + " cannot be removed from user " + userName + " because it is assigned to this user " + "via reference user " + refUser);
        }
        R3JCoProxy.Function buaa = this._backendProxy.getRepository().getFunctionTemplate("BAPI_USER_ACTGROUPS_ASSIGN").getFunction();
        buaa.getImportParameterList().setValue(userName, "USERNAME");
        buaa.getTableParameterList().setValue(roleTab, "ACTIVITYGROUPS");
        client.execute(buaa);
        this.logFunction("doAssignmentChange", buaa);
        ret = buaa.getTableParameterList().getTable("RETURN");
        this.handleBapiRet2Table("doAssignmentChange", "BAPI_USER_ACTGROUPS_ASSIGN", ret);
        Buffer currentBuffer = this._activeBuffer;
        if (currentBuffer.userCacheFilled && (role = (RoleData)currentBuffer.roles.get(rolename)) != null) {
            if (remove) {
                role.memberUsers.remove(userName);
            } else {
                role.memberUsers.add(userName);
            }
        }
    }

    private static String getUpdateDump(IInternalPrincipalDatabagMaint p) {
        R3PersistenceBase.InternalPrincipalDatabagMaintWrapper pX = new R3PersistenceBase.InternalPrincipalDatabagMaintWrapper(p);
        StringBuffer sb = new StringBuffer();
        R3PersistenceBase.IPersistenceCollection values = pX.getValues(MEMBER_NS, MEMBER_ATT, 2);
        sb.append("SET values: " + (values != null ? values.toString() : "<null>") + "\n");
        R3PersistenceBase.IPersistenceCollection attributes = pX.getAllAttributes(MEMBER_NS, 3);
        sb.append("DELETE values: " + (attributes != null && attributes.contains(MEMBER_ATT) ? "Yes" : "No") + "\n");
        values = pX.getValues(MEMBER_NS, MEMBER_ATT, 0);
        sb.append("ADD values: " + (values != null ? values.toString() : "<null>") + "\n");
        values = pX.getValues(MEMBER_NS, MEMBER_ATT, 1);
        sb.append("REMOVE values: " + (values != null ? values.toString() : "<null>") + "\n");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class R3RoleDataSourceTransaction
    implements IDataSourceTransaction {
        private static final int UPDATE = 3;
        private LinkedList _actions = new LinkedList();

        public boolean bindNewPrincipalDatabag(IInternalPrincipalDatabag principal) throws PersistenceException {
            return false;
        }

        public void createPrincipalDatabag(IInternalPrincipalDatabag principal) throws PersistenceException {
            String type = principal.getIDParts()[0];
            String dsID = principal.getIDParts()[1];
            if (R3RoleDataSource.this.PRINCIPAL_TYPE.equals(type) && R3RoleDataSource.this.getId().equals(dsID) && !R3RoleDataSource.this.isReadonly()) {
                throw new PersistenceException("Creation of new roles in ABAP not possible");
            }
        }

        public void updatePrincipalDatabag(IInternalPrincipalDatabagMaint principalMaint) throws PersistenceException {
            LOG.debugT("R3RoleDataSourceTransaction.updatePrincipalDatabag()", "Storing incoming principal only");
            this._actions.add(new R3RoleDataSourceAction(3, principalMaint));
        }

        public void deletePrincipalDatabag(IPrincipalDatabag principal) throws PersistenceException {
            String type = principal.getIDParts()[0];
            String dsID = principal.getIDParts()[1];
            if (R3RoleDataSource.this.PRINCIPAL_TYPE.equals(type) && R3RoleDataSource.this.getId().equals(dsID) && !R3RoleDataSource.this.isReadonly()) {
                throw new PersistenceException("Deletion of ABAP roles not possible");
            }
        }

        public void commit() throws PersistenceException {
            String METHOD = "R3RoleDataSourceTransaction.commit()";
            try {
                LOG.entering("R3RoleDataSourceTransaction.commit()");
                Iterator iter = this._actions.iterator();
                while (iter.hasNext()) {
                    R3RoleDataSourceAction action = (R3RoleDataSourceAction)iter.next();
                    switch (action.action) {
                        case 3: {
                            R3RoleDataSource.this.updatePrincipalDatabag((IInternalPrincipalDatabagMaint)action.principal);
                            break;
                        }
                        default: {
                            throw new PersistenceException("Unknown action type " + action.action + " stored");
                        }
                    }
                }
                Object var5_4 = null;
                this._actions.clear();
                LOG.exiting("R3RoleDataSourceTransaction.commit()");
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this._actions.clear();
                LOG.exiting("R3RoleDataSourceTransaction.commit()");
                throw throwable;
            }
        }

        public void rollback() throws PersistenceException {
            String METHOD = "R3RoleDataSourceTransaction.rollback()";
            R3PersistenceBase.LogUtil.logEntering(LOG, "R3RoleDataSourceTransaction.rollback()");
            this._actions.clear();
            R3PersistenceBase.LogUtil.logExiting(LOG, "R3RoleDataSourceTransaction.rollback()");
        }

        private final class R3RoleDataSourceAction {
            public int action;
            public IPrincipalDatabag principal;

            public R3RoleDataSourceAction(int action, IPrincipalDatabag principal) {
                this.action = action;
                this.principal = principal;
            }
        }
    }

    private class NameCreator {
        final StringBuffer roleBuffer = new StringBuffer();
        final int roleLength;
        final StringBuffer userBuffer;
        final int userLength;

        public NameCreator(String roleDsID, String userDsID) throws Exception {
            this.roleBuffer.append(R3RoleDataSource.this.PRINCIPAL_TYPE);
            this.roleBuffer.append(".");
            this.roleBuffer.append(roleDsID);
            this.roleBuffer.append(".");
            this.roleLength = this.roleBuffer.length();
            this.userBuffer = new StringBuffer();
            this.userBuffer.append("USER");
            this.userBuffer.append(".");
            this.userBuffer.append(userDsID);
            this.userBuffer.append(".");
            this.userLength = this.userBuffer.length();
        }

        public synchronized String getExternalRoleName(String roleName) {
            this.roleBuffer.replace(this.roleLength, this.roleBuffer.length(), roleName);
            return this.roleBuffer.toString();
        }

        public synchronized String getExternalUserName(String userName) {
            this.userBuffer.replace(this.userLength, this.userBuffer.length(), userName);
            return this.userBuffer.toString();
        }
    }

    private static class Buffer {
        public HashMap roles = new HashMap();
        public long creationTime = 0L;
        public boolean userCacheFilled = false;

        private Buffer() {
        }

        public String toString() {
            return "Buffer created " + new Date(this.creationTime).toString() + "\n" + "Contains " + this.roles.size() + " roles" + "\n" + "User buffer read: " + this.userCacheFilled;
        }
    }

    private static class RoleData {
        public final String name;
        public final String description;
        public LinkedList memberOf = null;
        public LinkedList members = null;
        public Set memberUsers = null;

        public RoleData(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public void addMemberOf(RoleData parent) {
            if (this.memberOf == null) {
                this.memberOf = new LinkedList();
            }
            this.memberOf.add(parent);
        }

        public void addMember(RoleData member) {
            if (this.members == null) {
                this.members = new LinkedList();
            }
            this.members.add(member);
        }

        public String toString() {
            return "Name: " + this.name + "\n" + "Description: " + this.description + "\n" + "MemberOf   : " + (this.memberOf != null ? this.memberOf.toString() : "none") + "\n" + "Members: " + (this.members != null ? this.members.toString() : "none") + "\n" + "MemberUsers: " + (this.memberUsers != null ? "" + this.memberUsers.size() : "none or not read");
        }
    }
}

