/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.ISearchAttribute;
import com.sap.security.api.IUserAccount;
import com.sap.security.api.IUserMaint;
import com.sap.security.api.UMFactory;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.imp.UserMaint;
import com.sap.security.core.persistence.IInternalPrincipalDatabag;
import com.sap.security.core.persistence.IInternalPrincipalDatabagMaint;
import com.sap.security.core.persistence.IPrincipalDatabag;
import com.sap.security.core.persistence.datasource.IDataSource;
import com.sap.security.core.persistence.datasource.IDataSourceTransaction;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.datasource.imp.DSConfigurationModel;
import com.sap.security.core.persistence.datasource.imp.DataSourceBaseImplementation;
import com.sap.security.core.persistence.datasource.imp.R3DataSourceXMLTransaction;
import com.sap.security.core.persistence.datasource.imp.r3.R3ConnectionSAP;
import com.sap.security.core.persistence.datasource.imp.r3.UmR3UserFactory;
import com.sap.security.core.persistence.imp.SearchCriteria;
import com.sap.security.core.persistence.replication.imp.adapters.r3.CreateSyncXML;
import com.sap.security.core.persistence.replication.imp.adapters.r3.UmR3Properties;
import com.sap.security.core.persistence.replication.imp.usersync.Utils;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.cache.ICache;
import com.sap.security.um.r3.R3User;
import com.sap.security.um.r3.R3UserAccount;
import com.sap.security.usermanagement.ISearchResult;
import com.sap.security.usermanagement.IUser;
import com.sap.security.usermanagement.UMException;
import com.sap.security.usermanagement.UserSearchFilter;
import java.sql.Connection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;

public class R3PersistenceXML
extends DataSourceBaseImplementation
implements IDataSource {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/R3PersistenceXML.java#2 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)";
    private static final IUMParameters mySAPProperties = UMFactory.getProperties();
    private static ICache mCache = InternalUMFactory.getCache(2, 100, 600, (class$com$sap$security$core$persistence$datasource$imp$R3PersistenceXML == null ? (class$com$sap$security$core$persistence$datasource$imp$R3PersistenceXML = R3PersistenceXML.class$("com.sap.security.core.persistence.datasource.imp.R3PersistenceXML")) : class$com$sap$security$core$persistence$datasource$imp$R3PersistenceXML).getName() + "_mCache");
    public static String R3_APPL = "r3application";
    private static final String R3_ROLES = "R3ROLES";
    private static final String ATTR_ALL = "ALL";
    private static final String ATTR_NAMES = "NAMES";
    private static final String UM_READONLY = "UM_READONLY";
    private static final String EXTERNAL_ROLES_ATTRIBUTE = "EXTERNAL_ROLES";
    public static final String MASTER_ADAPTERID = "ume.logon.r3master.adapterid";
    private String r3_adapterid = "master";
    private String DELETED = "deleted_";
    private UmR3Properties r3Properties = null;
    private Vector r3Roles;
    private UmR3UserFactory mFactory;
    private static IUMTrace mTrace;
    static /* synthetic */ Class class$com$sap$security$core$persistence$datasource$imp$R3PersistenceXML;

    public R3PersistenceXML() {
        mTrace = InternalUMFactory.getTrace(VERSIONSTRING);
        if (mTrace.bePath()) {
            mTrace.entering("constructor");
        }
        if (mTrace.bePath()) {
            mTrace.exiting("constructor");
        }
    }

    public void init(DSConfigurationModel dsConf) throws PersistenceException {
        String methodname;
        block4: {
            methodname = "init";
            if (mTrace.bePath()) {
                mTrace.entering(methodname, new Object[]{dsConf});
            }
            super.init(dsConf);
            mTrace = InternalUMFactory.getTrace(VERSIONSTRING, this.mConfigurationModel.getDataSourceID());
            this.r3_adapterid = mySAPProperties.get(MASTER_ADAPTERID, "master");
            this.r3Properties = new UmR3Properties(this.r3_adapterid);
            try {
                R3ConnectionSAP.getR3Factory(this.r3_adapterid);
                this.isInitialized = true;
            }
            catch (Exception e) {
                this.isInitialized = false;
                if (!mTrace.beDebug()) break block4;
                mTrace.debugT("init", e);
            }
        }
        if (mTrace.bePath()) {
            mTrace.exiting(methodname);
        }
    }

    public IInternalPrincipalDatabag[] initPrincipalDatabags(IInternalPrincipalDatabag[] principals) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("initPrincipalDatabags", new Object[]{principals});
        }
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        int size = principals.length;
        int i = 0;
        while (i < size) {
            if (principals[i] != null && this.isHomeForPrincipalDatabag(principals[i])) {
                this.populatePrincipalDatabag(principals[i], null);
            }
            ++i;
        }
        if (mTrace.bePath()) {
            mTrace.exiting("initPrincipalDatabags", principals);
        }
        return principals;
    }

    public void populatePrincipalDatabags(IInternalPrincipalDatabag[] principals, AttributeList populateAttributes) throws PersistenceException {
        String methodname = "populatePrincipalDatabags-3";
        if (mTrace.bePath()) {
            mTrace.entering(methodname, new Object[]{"principals[], populateAttributes"});
        }
        int i = 0;
        while (i < principals.length) {
            this.populatePrincipalDatabag(principals[i], populateAttributes);
            ++i;
        }
        if (mTrace.bePath()) {
            mTrace.exiting(methodname, principals);
        }
    }

    public void populatePrincipalDatabag(IInternalPrincipalDatabag principal, AttributeList populateAttributes) throws PersistenceException {
        String methodname = "populatePrincipalDatabag-1";
        if (mTrace.bePath()) {
            mTrace.entering(methodname, new Object[]{"principal, populateAttributes"});
        }
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        if (!this.feelsResponsible(principal)) {
            if (mTrace.bePath()) {
                mTrace.exiting("populatePrincipalDatabag", principal);
            }
            return;
        }
        String[] idParts = principal.getIDParts();
        String type = idParts[0];
        String userid = idParts[2];
        Hashtable nameSpaces = this.mConfigurationModel.getPopulateInitially(type);
        if (populateAttributes != null) {
            int i = 0;
            while (i < populateAttributes.getSize()) {
                String myAttributeName;
                String myNameSpace = populateAttributes.getNameSpaceOfAttributeAt(i);
                if (this.feelsResponsible(type, myNameSpace, myAttributeName = populateAttributes.getAttributeNameOfAttributeAt(i))) {
                    Vector<String> dummy = (Vector<String>)nameSpaces.get(myNameSpace);
                    if (dummy == null) {
                        dummy = new Vector<String>();
                    }
                    dummy.add(myAttributeName);
                    nameSpaces.put(myNameSpace, dummy);
                }
                ++i;
            }
        }
        if (!nameSpaces.isEmpty()) {
            Enumeration en;
            String nameSpace = null;
            if (type.equals("USER")) {
                this.mFactory = R3ConnectionSAP.getR3Factory(this.r3_adapterid);
                R3User r3user = null;
                en = nameSpaces.keys();
                while (en.hasMoreElements()) {
                    nameSpace = (String)en.nextElement();
                    try {
                        mTrace.debugT(methodname, "--***--Get R/3 user (USER): " + userid);
                        r3user = (R3User)this.mFactory.getUser(userid);
                        this.retrieveR3UserData(nameSpace, principal, r3user);
                        mTrace.debugT(methodname, "--***--Get R/3 user - appl data (USER): " + userid);
                        this.mFactory.getOtherSAPInfo(nameSpace, principal);
                    }
                    catch (Exception e) {
                        throw new PersistenceException(e);
                    }
                }
            } else if (type.equals("UACC")) {
                this.mFactory = R3ConnectionSAP.getR3Factory(this.r3_adapterid);
                R3UserAccount r3account = null;
                en = nameSpaces.keys();
                while (en.hasMoreElements()) {
                    nameSpace = (String)en.nextElement();
                    try {
                        mTrace.debugT(methodname, "--***--Get R/3 account (UACC): " + userid);
                        r3account = (R3UserAccount)this.mFactory.getUserAccount(userid);
                        this.retrieveR3AccountData(nameSpace, principal, r3account);
                    }
                    catch (Exception e) {
                        throw new PersistenceException(e);
                    }
                }
            } else if (type.equals("ROLE")) {
                Enumeration en2 = nameSpaces.keys();
                while (en2.hasMoreElements()) {
                    nameSpace = (String)en2.nextElement();
                    R3PersistenceXML.addPrincipalValue(nameSpace, "description", userid, principal);
                    R3PersistenceXML.addPrincipalValue(nameSpace, "displayname", userid, principal);
                    R3PersistenceXML.addPrincipalValue(nameSpace, "uniquename", userid, principal);
                }
            }
        }
        if (mTrace.bePath()) {
            mTrace.exiting("populatePrincipalDatabag");
        }
    }

    public boolean populatePrincipalDatabag(IInternalPrincipalDatabag principal, String nameSpace, String attribute) throws PersistenceException {
        String methodname = "populatePrincipalDatabag-2";
        boolean exist = false;
        if (mTrace.bePath()) {
            mTrace.entering(methodname, new Object[]{nameSpace, attribute});
        }
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        String[] idParts = principal.getIDParts();
        String type = idParts[0];
        String userid = idParts[2];
        if (mCache.get(this.DELETED + userid) != null) {
            return true;
        }
        if (!this.feelsResponsible(principal, nameSpace, attribute)) {
            if (mTrace.bePath()) {
                mTrace.exiting(methodname, new Boolean(false));
            }
            return false;
        }
        if (principal.getAttributeValues(nameSpace, attribute) == null) {
            if (type.equals("USER")) {
                this.mFactory = R3ConnectionSAP.getR3Factory(this.r3_adapterid);
                R3User r3user = null;
                try {
                    mTrace.debugT(methodname, "--***--Get R/3 user (USER): " + userid);
                    r3user = (R3User)this.mFactory.getUser(userid);
                    exist = this.retrieveR3UserData(nameSpace, attribute, principal, r3user);
                }
                catch (Exception e) {
                    throw new PersistenceException(e);
                }
            } else if (type.equals("UACC")) {
                this.mFactory = R3ConnectionSAP.getR3Factory(this.r3_adapterid);
                R3UserAccount r3account = null;
                try {
                    mTrace.debugT(methodname, "--***--Get R/3 account (UACC): " + userid);
                    r3account = (R3UserAccount)this.mFactory.getUserAccount(userid);
                    exist = this.retrieveR3AccountData(nameSpace, attribute, principal, r3account);
                }
                catch (Exception e) {
                    throw new PersistenceException(e);
                }
            } else if (type.equals("ROLE")) {
                // empty if block
            }
        }
        if (mTrace.bePath()) {
            mTrace.exiting(methodname, new Boolean(exist));
        }
        return exist;
    }

    public IDataSourceTransaction beginTransaction() throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("beginTransaction");
        }
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        R3DataSourceXMLTransaction newDBDStrans = new R3DataSourceXMLTransaction(this);
        if (mTrace.bePath()) {
            mTrace.exiting("beginTransaction", newDBDStrans);
        }
        return newDBDStrans;
    }

    public boolean principalDatabagExists(IPrincipalDatabag principal) throws PersistenceException {
        String methodname = "principalDatabagExists";
        if (mTrace.bePath()) {
            mTrace.entering("principalDatabagExists", new Object[]{principal});
        }
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        String[] idParts = principal.getIDParts();
        String userid = idParts[2];
        boolean exists = false;
        if (this.isHomeForPrincipalDatabag((IInternalPrincipalDatabag)principal)) {
            try {
                UserSearchFilter searchFilter = new UserSearchFilter();
                searchFilter.setUniqueID(userid.toUpperCase());
                this.mFactory = R3ConnectionSAP.getR3Factory(this.r3_adapterid);
                mTrace.debugT(methodname, "--***--searchUser: " + userid);
                ISearchResult result = this.mFactory.searchUsers(searchFilter);
                if (result.hasNext()) {
                    exists = true;
                }
            }
            catch (Exception e) {
                throw new PersistenceException(e);
            }
        }
        if (mTrace.bePath()) {
            mTrace.exiting("principalDatabagExists", new Boolean(exists));
        }
        return exists;
    }

    protected String getPrivateIDPart(IPrincipalDatabag principal) throws PersistenceException {
        Vector vIds;
        if (mTrace.bePath()) {
            mTrace.entering("getPrivateIDPart", new Object[]{principal});
        }
        if ((vIds = principal.getAttributeValues("com.sap.security.core.usermanagement", "uniquename")) == null) {
            vIds = principal.getAttributeValues("com.sap.security.core.usermanagement", "j_user");
        }
        String guid = null;
        if (vIds != null && vIds.size() != 0) {
            int i = 0;
            if (i < vIds.size()) {
                guid = (String)vIds.get(i);
            }
        }
        if (mTrace.bePath()) {
            mTrace.exiting("getPrivateIDPart", guid);
        }
        return guid;
    }

    public Vector searchPrincipalDatabags(SearchCriteria criteria) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("searchPrincipalDatabags", new Object[]{criteria});
        }
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        int size = criteria.getElementSize();
        boolean found = true;
        String type = criteria.getPrincipalType();
        SearchCriteria dsCriteria = new SearchCriteria(criteria.isOrMode(), criteria.getPrincipalType());
        int i = 0;
        while (i < size) {
            boolean checkResult;
            ISearchAttribute se = criteria.getAttribute(i);
            String nameSpace = se.getAttributeNameSpace();
            String attribute = se.getAttributeName();
            if (!(nameSpace.equals("com.sap.security.core.usermanagement") && attribute.equals("PRINCIPAL_TYPE_ATTRIBUTE") || !(checkResult = found ? this.feelsResponsible(type, nameSpace, attribute) : this.feelsResponsible(nameSpace, attribute)))) {
                int op = se.getOperator();
                Object value = se.getAttributeValue();
                boolean cs = se.isCaseSensitive();
                switch (op) {
                    case 1: {
                        dsCriteria.addLikeElement(nameSpace, attribute, value, cs);
                        break;
                    }
                    case 0: {
                        dsCriteria.addEqualsElement(nameSpace, attribute, value, cs);
                        break;
                    }
                    case 2: {
                        dsCriteria.addGreaterThanElement(nameSpace, attribute, value, cs);
                        break;
                    }
                    case 3: {
                        dsCriteria.addLessThanElement(nameSpace, attribute, value, cs);
                    }
                }
            }
            ++i;
        }
        if (dsCriteria.getElementSize() == 0) {
            if (mTrace.beInfo()) {
                mTrace.infoT("searchPrincipalDatabags", "Not responsible for any search element.");
            }
            if (mTrace.bePath()) {
                mTrace.exiting("searchPrincipalDatabags", null);
            }
            return null;
        }
        Vector searchResults = new Vector();
        if (found) {
            this.doSearch(dsCriteria, searchResults, type);
        } else {
            this.doSearch(dsCriteria, searchResults, null);
        }
        if (mTrace.bePath()) {
            mTrace.exiting("searchPrincipalDatabags", searchResults);
        }
        return searchResults;
    }

    public void releaseConnection(Connection connection) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("releaseConnection", new Object[]{connection});
        }
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        if (mTrace.bePath()) {
            mTrace.exiting("releaseConnection");
        }
    }

    public boolean checkCredentials(Hashtable credentials) throws PersistenceException {
        String methodname = "checkCredentials";
        if (mTrace.bePath()) {
            mTrace.entering(methodname, new Object[]{credentials});
        }
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        if (!this.feelsResponsible("com.sap.security.core.usermanagement", "j_user") || !this.feelsResponsible("com.sap.security.core.usermanagement", "j_password")) {
            if (mTrace.bePath()) {
                mTrace.exiting(methodname, new Boolean(false));
            }
            return false;
        }
        String login = (String)credentials.get("j_user");
        String password = (String)credentials.get("j_password");
        boolean success = true;
        if (login == null || password == null) {
            if (mTrace.bePath()) {
                mTrace.exiting(methodname, new Boolean(false));
            }
            return false;
        }
        R3UserAccount authaccount = null;
        try {
            this.mFactory = R3ConnectionSAP.getR3Factory(this.r3_adapterid);
            HashMap<String, String> r3Crentials = new HashMap<String, String>();
            r3Crentials.put("com.sap.security.SAPUser", login.toUpperCase());
            r3Crentials.put("com.sap.security.SAPPassword", password);
            mTrace.debugT(methodname, "--***--authenticate user: " + login);
            authaccount = (R3UserAccount)this.mFactory.getAuthenticatedUserAccount(r3Crentials);
            if (authaccount == null) {
                success = false;
            }
            mTrace.infoT(methodname, "User account verified: " + login);
        }
        catch (Exception e) {
            mTrace.debugT(methodname, e.getMessage(), e);
            success = false;
        }
        if (mTrace.bePath()) {
            mTrace.exiting(methodname, new Boolean(success));
        }
        return success;
    }

    private void doSearch(SearchCriteria criteria, Vector searchResults, String principalType) throws PersistenceException {
        String methodname = "doSearch";
        if (mTrace.bePath()) {
            mTrace.entering("doSearch", new Object[]{criteria, searchResults, principalType});
        }
        UserSearchFilter searchFilter = new UserSearchFilter();
        boolean searchEntered = false;
        if (principalType.equals("USER") || principalType.equals("UACC")) {
            int i = 0;
            while (i < criteria.getElementSize()) {
                ISearchAttribute se = criteria.getAttribute(i);
                String attrName = se.getAttributeName();
                String attrValue = (String)se.getAttributeValue();
                switch (se.getOperator()) {
                    case 1: {
                        if (attrValue.endsWith("*")) break;
                        attrValue = attrValue + "*";
                        break;
                    }
                }
                if (attrName.equals("uniquename") || attrName.equals("internalid") || attrName.equals("userid") || attrName.equals("displayname") || attrName.endsWith("j_user")) {
                    block28: {
                        searchEntered = true;
                        if (attrName.equals("userid")) {
                            try {
                                String[] idParts = this.splitPrincipalDatabagID(attrValue);
                                attrValue = idParts[2];
                            }
                            catch (Exception ex) {
                                searchEntered = false;
                                if (!mTrace.beDebug()) break block28;
                                mTrace.debugT("doSearch", ex);
                            }
                        }
                    }
                    if (searchEntered) {
                        searchFilter.setUniqueID(attrValue.toUpperCase());
                    }
                } else if (attrName.equals("lastname")) {
                    searchEntered = true;
                    searchFilter.setLastName(attrValue);
                } else if (attrName.equals("firstname")) {
                    searchEntered = true;
                    searchFilter.setFirstName(attrValue);
                } else if (attrName.equals("company")) {
                    searchEntered = true;
                    searchFilter.setCompanyId(attrValue);
                } else if (attrName.equals("department")) {
                    searchEntered = true;
                    searchFilter.setDepartment(attrValue);
                }
                ++i;
            }
            if (!searchEntered) {
                return;
            }
            if (mCache.get(this.DELETED + searchFilter.getUniqueID()) != null) {
                String sr = principalType + "." + this.mConfigurationModel.getDataSourceID() + "." + searchFilter.getUniqueID();
                searchResults.add(sr);
                if (mTrace.bePath()) {
                    mTrace.exiting("doSearch", searchResults);
                }
                return;
            }
            try {
                this.mFactory = R3ConnectionSAP.getR3Factory(this.r3_adapterid);
                mTrace.debugT(methodname, "--***--search user: " + searchFilter.getUniqueID());
                ISearchResult result = this.mFactory.searchUsers(searchFilter);
                while (result.hasNext()) {
                    IUser user = (IUser)result.next();
                    String sr = principalType + "." + this.mConfigurationModel.getDataSourceID() + "." + user.getUniqueID();
                    searchResults.add(sr);
                }
            }
            catch (Exception e) {
                throw new PersistenceException(e);
            }
        }
        if (principalType.equals("ROLE") && this.r3Roles != null) {
            int i = 0;
            while (i < this.r3Roles.size()) {
                String sr = principalType + "." + this.mConfigurationModel.getDataSourceID() + "." + this.r3Roles.get(i);
                searchResults.add(sr);
                ++i;
            }
        }
        if (mTrace.bePath()) {
            mTrace.exiting("doSearch", searchResults);
        }
    }

    public void deletePrincipalDatabag(IPrincipalDatabag principal, IDataSourceTransaction transaction) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("deletePrincipalDatabag", new Object[]{principal, transaction});
        }
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        if (this.isReadonly()) {
            if (mTrace.beInfo()) {
                mTrace.infoT("deletePrincipalDatabag", "This datasource is readonly... do not try to delete principal databag.");
            }
            if (mTrace.bePath()) {
                mTrace.exiting("deletePrincipalDatabag");
            }
            return;
        }
        if (this.feelsResponsible(principal)) {
            try {
                this.deleteR3User(principal);
            }
            catch (Exception ex) {
                throw new PersistenceException(ex);
            }
        }
        if (mTrace.bePath()) {
            mTrace.exiting("deletePrincipalDatabag");
        }
    }

    public void createPrincipalDatabag(IInternalPrincipalDatabag principal, IDataSourceTransaction transaction) throws PersistenceException {
        String methodname = "createPrincipalDatabag";
        if (mTrace.bePath()) {
            mTrace.entering(methodname, new Object[]{principal, transaction});
        }
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        if (this.isReadonly()) {
            if (mTrace.beInfo()) {
                mTrace.infoT("createPrincipalDatabag", "This datasource is readonly... do not try to create principal databag.");
            }
            if (mTrace.bePath()) {
                mTrace.exiting("createPrincipalDatabag");
            }
            return;
        }
        String principalID = principal.getUniqueID();
        if (principalID == null) {
            String errorMessage = "A principal databag has to be bound before it can be created!";
            throw new PersistenceException(errorMessage);
        }
        if (this.feelsResponsible(principal)) {
            try {
                this.createR3User(principal);
            }
            catch (Exception ex) {
                throw new PersistenceException(ex);
            }
        }
        if (mTrace.bePath()) {
            mTrace.exiting("createPrincipalDatabag");
        }
    }

    public void updatePrincipalDatabag(IInternalPrincipalDatabagMaint principalMaint, IDataSourceTransaction transaction) throws PersistenceException {
        String methodname = "updatePrincipalDatabag";
        if (mTrace.bePath()) {
            mTrace.entering(methodname, new Object[]{principalMaint, transaction});
        }
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        if (this.isReadonly()) {
            if (mTrace.beInfo()) {
                mTrace.infoT(methodname, "This datasource is readonly... do not try to update principal databag.");
            }
            if (mTrace.bePath()) {
                mTrace.exiting(methodname);
            }
            return;
        }
        try {
            this.updateR3User(principalMaint);
        }
        catch (Exception ex) {
            throw new PersistenceException(ex);
        }
        if (mTrace.bePath()) {
            mTrace.exiting(methodname);
        }
    }

    public Vector getAttributeNamespaces(IPrincipalDatabag principal) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("getAttributeNamespaces", new Object[]{principal});
        }
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        Vector<String> results = new Vector<String>();
        Vector names = principal.getAttributeValues(ATTR_ALL, ATTR_NAMES);
        if (names != null) {
            String name = (String)names.get(0);
            name = name.substring(0, name.lastIndexOf("."));
            results.add(name);
        }
        if (mTrace.bePath()) {
            mTrace.exiting("getAttributeNamespaces", results);
        }
        return results;
    }

    public Vector getAttributeNames(IPrincipalDatabag principal, String nameSpace) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("getAttributeNames", new Object[]{principal, nameSpace});
        }
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        Vector<String> results = new Vector<String>();
        Vector names = principal.getAttributeValues(ATTR_ALL, ATTR_NAMES);
        if (names != null) {
            int i = 0;
            while (i < names.size()) {
                String name = (String)names.get(i);
                results.add(name.substring(name.lastIndexOf(".") + 1));
                ++i;
            }
        }
        if (mTrace.bePath()) {
            mTrace.exiting("getAttributeNames", results);
        }
        return results;
    }

    private void retrieveR3UserData(String nameSpace, IInternalPrincipalDatabag principal, R3User r3user) {
        String methodname = "retrieveR3UserData";
        if (r3user != null) {
            try {
                R3PersistenceXML.addPrincipalValue(nameSpace, "mobile", r3user.getCellPhone(), principal);
            }
            catch (Exception e) {
                principal.setAttributeValues(nameSpace, "mobile", new Vector());
                mTrace.debugT(methodname, e.getMessage(), e);
            }
            try {
                R3PersistenceXML.addPrincipalValue(nameSpace, "city", r3user.getCity(), principal);
            }
            catch (Exception e) {
                principal.setAttributeValues(nameSpace, "city", new Vector());
                mTrace.debugT(methodname, e.getMessage(), e);
            }
            try {
                R3PersistenceXML.addPrincipalValue(nameSpace, "country", r3user.getCountry(), principal);
            }
            catch (Exception e) {
                principal.setAttributeValues(nameSpace, "country", new Vector());
                mTrace.debugT(methodname, e.getMessage(), e);
            }
            try {
                R3PersistenceXML.addPrincipalValue(nameSpace, "currency", r3user.getCurrency(), principal);
            }
            catch (Exception e) {
                R3PersistenceXML.addPrincipalValue(nameSpace, "currency", "USD", principal);
                mTrace.debugT(methodname, e.getMessage() + " - currency set to USD", e);
            }
            try {
                R3PersistenceXML.addPrincipalValue(nameSpace, "state", r3user.getState(), principal);
            }
            catch (Exception e) {
                principal.setAttributeValues(nameSpace, "state", new Vector());
                mTrace.debugT(methodname, e.getMessage(), e);
            }
            try {
                R3PersistenceXML.addPrincipalValue(nameSpace, "streetaddress", r3user.getStreet(), principal);
            }
            catch (Exception e) {
                principal.setAttributeValues(nameSpace, "streetaddress", new Vector());
                mTrace.debugT(methodname, e.getMessage(), e);
            }
            try {
                R3PersistenceXML.addPrincipalValue(nameSpace, "zip", r3user.getZip(), principal);
            }
            catch (Exception e) {
                principal.setAttributeValues(nameSpace, "zip", new Vector());
                mTrace.debugT(methodname, e.getMessage(), e);
            }
            try {
                if (r3user.getLocale() == null) {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "locale", Locale.getDefault().toString(), principal);
                } else {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "locale", r3user.getLocale().toString(), principal);
                }
            }
            catch (Exception e) {
                mTrace.debugT(methodname, e.getMessage(), e);
            }
            try {
                if (r3user.getTimeZone() == null) {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "timezone", TimeZone.getDefault().getID(), principal);
                } else {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "timezone", r3user.getTimeZone().getID(), principal);
                }
            }
            catch (Exception e) {
                mTrace.debugT(methodname, e.getMessage(), e);
            }
            try {
                R3PersistenceXML.addPrincipalValue(nameSpace, "companyid", r3user.getCompanyId(), principal);
                R3PersistenceXML.addPrincipalValue(nameSpace, "company", r3user.getCompanyId(), principal);
            }
            catch (Exception e) {
                mTrace.debugT(methodname, e.getMessage(), e);
            }
            try {
                R3PersistenceXML.addPrincipalValue(nameSpace, "department", r3user.getDepartment(), principal);
            }
            catch (Exception e) {
                mTrace.debugT(methodname, e.getMessage(), e);
            }
            try {
                R3PersistenceXML.addPrincipalValue(nameSpace, "displayname", r3user.getDisplayName(), principal);
            }
            catch (Exception e) {
                mTrace.debugT(methodname, e.getMessage(), e);
            }
            try {
                R3PersistenceXML.addPrincipalValue(nameSpace, "email", r3user.getEmail(), principal);
            }
            catch (Exception e) {
                mTrace.debugT(methodname, e.getMessage(), e);
            }
            try {
                R3PersistenceXML.addPrincipalValue(nameSpace, "fax", r3user.getFax(), principal);
            }
            catch (Exception e) {
                mTrace.debugT(methodname, e.getMessage(), e);
            }
            try {
                R3PersistenceXML.addPrincipalValue(nameSpace, "firstname", r3user.getFirstName(), principal);
            }
            catch (Exception e) {
                mTrace.debugT(methodname, e.getMessage(), e);
            }
            try {
                R3PersistenceXML.addPrincipalValue(nameSpace, "jobtitle", r3user.getJobTitle(), principal);
            }
            catch (Exception e) {
                mTrace.debugT(methodname, e.getMessage(), e);
            }
            try {
                R3PersistenceXML.addPrincipalValue(nameSpace, "lastname", r3user.getLastName(), principal);
            }
            catch (Exception e) {
                mTrace.debugT(methodname, e.getMessage(), e);
            }
            try {
                R3PersistenceXML.addPrincipalValue(nameSpace, "telephone", r3user.getTelephone(), principal);
            }
            catch (Exception e) {
                mTrace.debugT(methodname, e.getMessage(), e);
            }
            try {
                R3PersistenceXML.addPrincipalValue(nameSpace, "title", r3user.getTitle(), principal);
            }
            catch (Exception e) {
                mTrace.debugT(methodname, e.getMessage(), e);
            }
            try {
                R3PersistenceXML.addPrincipalValue(nameSpace, "salutation", r3user.getSalutation(), principal);
            }
            catch (Exception e) {
                mTrace.debugT(methodname, e.getMessage(), e);
            }
            try {
                String[] aRoles = r3user.getAttribute(UM_READONLY, EXTERNAL_ROLES_ATTRIBUTE);
                if (aRoles != null) {
                    this.r3Roles = new Vector();
                    int i = 0;
                    while (i < aRoles.length) {
                        this.r3Roles.add(aRoles[i]);
                        ++i;
                    }
                    R3PersistenceXML.addPrincipalValue(nameSpace, R3_ROLES, this.r3Roles, principal);
                }
            }
            catch (Exception e) {
                mTrace.debugT(methodname, e.getMessage(), e);
            }
            String r3Appl = this.r3Properties.getApplication();
            if (r3Appl == null) {
                r3Appl = "";
            }
            R3PersistenceXML.addPrincipalValue(nameSpace, R3_APPL, r3Appl, principal);
        }
    }

    private boolean retrieveR3UserData(String nameSpace, String attribute, IInternalPrincipalDatabag principal, R3User r3user) {
        String methodname = "retrieveR3UserData";
        boolean exist = false;
        if (r3user != null) {
            if (attribute.equals("mobile")) {
                try {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "mobile", r3user.getCellPhone(), principal);
                    exist = true;
                }
                catch (Exception e) {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "mobile", "", principal);
                    mTrace.debugT(methodname, e.getMessage(), e);
                    exist = true;
                }
            } else if (attribute.equals("city")) {
                try {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "city", r3user.getCity(), principal);
                    exist = true;
                }
                catch (Exception e) {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "city", "", principal);
                    mTrace.debugT(methodname, e.getMessage(), e);
                    exist = true;
                }
            } else if (attribute.equals("country")) {
                try {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "country", r3user.getCountry(), principal);
                    exist = true;
                }
                catch (Exception e) {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "country", "", principal);
                    mTrace.debugT(methodname, e.getMessage(), e);
                    exist = true;
                }
            } else if (attribute.equals("currency")) {
                try {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "currency", r3user.getCurrency(), principal);
                    exist = true;
                }
                catch (Exception e) {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "currency", "USD", principal);
                    mTrace.debugT(methodname, e.getMessage() + " - currency set to USD", e);
                    exist = true;
                }
            } else if (attribute.equals("state")) {
                try {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "state", r3user.getState(), principal);
                    exist = true;
                }
                catch (Exception e) {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "state", "", principal);
                    mTrace.debugT(methodname, e.getMessage(), e);
                    exist = true;
                }
            } else if (attribute.equals("streetaddress")) {
                try {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "streetaddress", r3user.getStreet(), principal);
                    exist = true;
                }
                catch (Exception e) {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "streetaddress", "", principal);
                    mTrace.debugT(methodname, e.getMessage(), e);
                    exist = true;
                }
            } else if (attribute.equals("zip")) {
                try {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "zip", r3user.getZip(), principal);
                    exist = true;
                }
                catch (Exception e) {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "zip", "", principal);
                    mTrace.debugT(methodname, e.getMessage(), e);
                    exist = true;
                }
            } else if (attribute.equals("uniquename")) {
                try {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "uniquename", r3user.getUniqueID(), principal);
                    exist = true;
                }
                catch (Exception e) {
                    mTrace.debugT(methodname, e.getMessage(), e);
                }
            } else if (attribute.equals("locale")) {
                try {
                    if (r3user.getLocale() == null) {
                        R3PersistenceXML.addPrincipalValue(nameSpace, "locale", Locale.getDefault().toString(), principal);
                    } else {
                        R3PersistenceXML.addPrincipalValue(nameSpace, "locale", r3user.getLocale().toString(), principal);
                    }
                    exist = true;
                }
                catch (Exception e) {
                    mTrace.debugT(methodname, e.getMessage(), e);
                }
            } else if (attribute.equals("timezone")) {
                try {
                    if (r3user.getTimeZone() == null) {
                        R3PersistenceXML.addPrincipalValue(nameSpace, "timezone", TimeZone.getDefault().getID(), principal);
                    } else {
                        R3PersistenceXML.addPrincipalValue(nameSpace, "timezone", r3user.getTimeZone().getID(), principal);
                    }
                    exist = true;
                }
                catch (Exception e) {
                    mTrace.debugT(methodname, e.getMessage(), e);
                }
            } else if (attribute.equals("companyid")) {
                try {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "companyid", r3user.getCompanyId(), principal);
                    R3PersistenceXML.addPrincipalValue(nameSpace, "company", r3user.getCompanyId(), principal);
                    exist = true;
                }
                catch (Exception e) {
                    mTrace.debugT(methodname, e.getMessage(), e);
                }
            } else if (attribute.equals("department")) {
                try {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "department", r3user.getDepartment(), principal);
                    exist = true;
                }
                catch (Exception e) {
                    mTrace.debugT(methodname, e.getMessage(), e);
                }
            } else if (attribute.equals("displayname")) {
                try {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "displayname", r3user.getDisplayName(), principal);
                    exist = true;
                }
                catch (Exception e) {
                    mTrace.debugT(methodname, e.getMessage(), e);
                }
            } else if (attribute.equals("email")) {
                try {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "email", r3user.getEmail(), principal);
                    exist = true;
                }
                catch (Exception e) {
                    mTrace.debugT(methodname, e.getMessage(), e);
                }
            } else if (attribute.equals("fax")) {
                try {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "fax", r3user.getFax(), principal);
                    exist = true;
                }
                catch (Exception e) {
                    mTrace.debugT(methodname, e.getMessage(), e);
                }
            } else if (attribute.equals("firstname")) {
                try {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "firstname", r3user.getFirstName(), principal);
                    exist = true;
                }
                catch (Exception e) {
                    mTrace.debugT(methodname, e.getMessage(), e);
                }
            } else if (attribute.equals("jobtitle")) {
                try {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "jobtitle", r3user.getJobTitle(), principal);
                    exist = true;
                }
                catch (Exception e) {
                    mTrace.debugT(methodname, e.getMessage(), e);
                }
            } else if (attribute.equals("lastname")) {
                try {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "lastname", r3user.getLastName(), principal);
                    exist = true;
                }
                catch (Exception e) {
                    mTrace.debugT(methodname, e.getMessage(), e);
                }
            } else if (attribute.equals("telephone")) {
                try {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "telephone", r3user.getTelephone(), principal);
                    exist = true;
                }
                catch (Exception e) {
                    mTrace.debugT(methodname, e.getMessage(), e);
                }
            } else if (attribute.equals("title")) {
                try {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "title", r3user.getTitle(), principal);
                    exist = true;
                }
                catch (Exception e) {
                    mTrace.debugT(methodname, e.getMessage(), e);
                }
            } else if (attribute.equals("salutation")) {
                try {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "salutation", r3user.getSalutation(), principal);
                    exist = true;
                }
                catch (Exception e) {
                    mTrace.debugT(methodname, e.getMessage(), e);
                }
            } else {
                mTrace.debugT(methodname, attribute + " not available on R/3");
                R3PersistenceXML.addPrincipalValue(nameSpace, attribute, "", principal);
                exist = true;
            }
        }
        return exist;
    }

    private void retrieveR3AccountData(String nameSpace, IInternalPrincipalDatabag principal, R3UserAccount r3account) {
        String methodname = "retrieveR3AccountData";
        Date d = null;
        long millis = 0L;
        String status = "false";
        if (r3account != null) {
            try {
                R3PersistenceXML.addPrincipalValue(nameSpace, "j_user", r3account.getLogonUid(), principal);
            }
            catch (Exception e) {
                mTrace.debugT(methodname, e.getMessage(), e);
            }
            try {
                d = r3account.getValidFromDate();
                if (d != null) {
                    millis = d.getTime();
                    R3PersistenceXML.addPrincipalValue(nameSpace, "validfrom", Long.toString(millis), principal);
                }
            }
            catch (Exception e) {
                mTrace.debugT(methodname, e.getMessage(), e);
            }
            try {
                d = r3account.getValidToDate();
                if (d != null) {
                    millis = d.getTime();
                    R3PersistenceXML.addPrincipalValue(nameSpace, "validto", Long.toString(millis), principal);
                }
            }
            catch (Exception e) {
                mTrace.debugT(methodname, e.getMessage(), e);
            }
            try {
                status = "false";
                if (r3account.isLocked()) {
                    status = "true";
                }
                R3PersistenceXML.addPrincipalValue(nameSpace, "islocked", status, principal);
            }
            catch (Exception e) {
                mTrace.debugT(methodname, e.getMessage(), e);
            }
            try {
                int reason = r3account.getLockReason();
                R3PersistenceXML.addPrincipalValue(nameSpace, "lockreason", Integer.toString(reason), principal);
            }
            catch (Exception e) {
                mTrace.debugT(methodname, e.getMessage(), e);
            }
            try {
                d = r3account.getLastFailedLogonDate();
                if (d != null) {
                    millis = d.getTime();
                    R3PersistenceXML.addPrincipalValue(nameSpace, "lastfailedlogon", Long.toString(millis), principal);
                }
            }
            catch (Exception e) {
                mTrace.debugT(methodname, e.getMessage(), e);
            }
            try {
                R3PersistenceXML.addPrincipalValue(nameSpace, "failedlogonattempts", Integer.toString(r3account.getFailedLogonAttempts()), principal);
            }
            catch (Exception e) {
                mTrace.debugT(methodname, e.getMessage(), e);
            }
            try {
                d = r3account.getLastSuccessfulLogonDate();
                if (d != null) {
                    millis = d.getTime();
                    R3PersistenceXML.addPrincipalValue(nameSpace, "lastsuccessfullogon", Long.toString(millis), principal);
                }
            }
            catch (Exception e) {
                mTrace.debugT(methodname, e.getMessage(), e);
            }
            try {
                d = r3account.getLastSuccessfulLogonDate();
                if (d != null) {
                    millis = d.getTime();
                    R3PersistenceXML.addPrincipalValue(nameSpace, "previoussuccessfullogon", Long.toString(millis), principal);
                }
            }
            catch (Exception e) {
                mTrace.debugT(methodname, e.getMessage(), e);
            }
            try {
                R3PersistenceXML.addPrincipalValue(nameSpace, "successfullogoncount", Integer.toString(r3account.getSuccessfulLogonCounts()), principal);
            }
            catch (Exception e) {
                mTrace.debugT(methodname, e.getMessage(), e);
            }
            try {
                status = "false";
                if (r3account.isPasswordChangeRequired()) {
                    status = "true";
                }
                R3PersistenceXML.addPrincipalValue(nameSpace, "passwordchangerequired", status, principal);
            }
            catch (Exception e) {
                mTrace.debugT(methodname, e.getMessage(), e);
            }
            try {
                d = r3account.getLastPasswordChangedDate();
                if (d != null) {
                    millis = d.getTime();
                    R3PersistenceXML.addPrincipalValue(nameSpace, "lastpasswordchange", Long.toString(millis), principal);
                }
            }
            catch (Exception e) {
                mTrace.debugT(methodname, e.getMessage(), e);
            }
            try {
                String internalId = "USER." + this.mConfigurationModel.getDataSourceID() + "." + r3account.getUniqueID();
                R3PersistenceXML.addPrincipalValue(nameSpace, "userid", internalId, principal);
            }
            catch (Exception e) {
                mTrace.debugT(methodname, e.getMessage(), e);
            }
        }
    }

    private boolean retrieveR3AccountData(String nameSpace, String attribute, IInternalPrincipalDatabag principal, R3UserAccount r3account) {
        String methodname = "retrieveR3AccountData";
        Date d = null;
        long millis = 0L;
        String status = "false";
        boolean exist = false;
        if (r3account != null) {
            if (attribute.equals("j_user")) {
                try {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "j_user", r3account.getLogonUid(), principal);
                    exist = true;
                }
                catch (Exception e) {
                    mTrace.debugT(methodname, e.getMessage(), e);
                }
            } else if (attribute.equals("validfrom")) {
                try {
                    d = r3account.getValidFromDate();
                    if (d != null) {
                        millis = d.getTime();
                        R3PersistenceXML.addPrincipalValue(nameSpace, "validfrom", Long.toString(millis), principal);
                        exist = true;
                    }
                }
                catch (Exception e) {
                    mTrace.debugT(methodname, e.getMessage(), e);
                }
            } else if (attribute.equals("validto")) {
                try {
                    d = r3account.getValidToDate();
                    if (d != null) {
                        millis = d.getTime();
                        R3PersistenceXML.addPrincipalValue(nameSpace, "validto", Long.toString(millis), principal);
                        exist = true;
                    }
                }
                catch (Exception e) {
                    mTrace.debugT(methodname, e.getMessage(), e);
                }
            } else if (attribute.equals("islocked")) {
                try {
                    status = "false";
                    if (r3account.isLocked()) {
                        status = "true";
                    }
                    R3PersistenceXML.addPrincipalValue(nameSpace, "islocked", status, principal);
                    exist = true;
                }
                catch (Exception e) {
                    mTrace.debugT(methodname, e.getMessage(), e);
                }
            } else if (attribute.equals("lockreason")) {
                try {
                    int reason = r3account.getLockReason();
                    R3PersistenceXML.addPrincipalValue(nameSpace, "lockreason", Integer.toString(reason), principal);
                    exist = true;
                }
                catch (Exception e) {
                    mTrace.debugT(methodname, e.getMessage(), e);
                }
            } else if (attribute.equals("lastfailedlogon")) {
                try {
                    d = r3account.getLastFailedLogonDate();
                    if (d != null) {
                        millis = d.getTime();
                        R3PersistenceXML.addPrincipalValue(nameSpace, "lastfailedlogon", Long.toString(millis), principal);
                        exist = true;
                    }
                }
                catch (Exception e) {
                    mTrace.debugT(methodname, e.getMessage(), e);
                }
            } else if (attribute.equals("failedlogonattempts")) {
                try {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "failedlogonattempts", Integer.toString(r3account.getFailedLogonAttempts()), principal);
                    exist = true;
                }
                catch (Exception e) {
                    mTrace.debugT(methodname, e.getMessage(), e);
                }
            } else if (attribute.equals("lastsuccessfullogon")) {
                try {
                    d = r3account.getLastSuccessfulLogonDate();
                    if (d != null) {
                        millis = d.getTime();
                        R3PersistenceXML.addPrincipalValue(nameSpace, "lastsuccessfullogon", Long.toString(millis), principal);
                        exist = true;
                    }
                }
                catch (Exception e) {
                    mTrace.debugT(methodname, e.getMessage(), e);
                }
            } else if (attribute.equals("previoussuccessfullogon")) {
                try {
                    d = r3account.getLastSuccessfulLogonDate();
                    if (d != null) {
                        millis = d.getTime();
                        R3PersistenceXML.addPrincipalValue(nameSpace, "previoussuccessfullogon", Long.toString(millis), principal);
                        exist = true;
                    }
                }
                catch (Exception e) {
                    mTrace.debugT(methodname, e.getMessage(), e);
                }
            } else if (attribute.equals("successfullogoncount")) {
                try {
                    R3PersistenceXML.addPrincipalValue(nameSpace, "successfullogoncount", Integer.toString(r3account.getSuccessfulLogonCounts()), principal);
                    exist = true;
                }
                catch (Exception e) {
                    mTrace.debugT(methodname, e.getMessage(), e);
                }
            } else if (attribute.equals("passwordchangerequired")) {
                try {
                    status = "false";
                    if (r3account.isPasswordChangeRequired()) {
                        status = "true";
                    }
                    R3PersistenceXML.addPrincipalValue(nameSpace, "passwordchangerequired", status, principal);
                    exist = true;
                }
                catch (Exception e) {
                    mTrace.debugT(methodname, e.getMessage(), e);
                }
            } else if (attribute.equals("lastpasswordchange")) {
                try {
                    d = r3account.getLastPasswordChangedDate();
                    if (d != null) {
                        millis = d.getTime();
                        R3PersistenceXML.addPrincipalValue(nameSpace, "lastpasswordchange", Long.toString(millis), principal);
                        exist = true;
                    }
                }
                catch (Exception e) {
                    mTrace.debugT(methodname, e.getMessage(), e);
                }
            } else if (attribute.equals("userid")) {
                try {
                    String internalId = "USER." + this.mConfigurationModel.getDataSourceID() + "." + r3account.getUniqueID();
                    R3PersistenceXML.addPrincipalValue(nameSpace, "userid", internalId, principal);
                    exist = true;
                }
                catch (Exception e) {
                    mTrace.debugT(methodname, e.getMessage(), e);
                }
            } else {
                mTrace.debugT(methodname, nameSpace + "/" + attribute + " not available");
            }
        }
        if (!exist) {
            principal.setAttributeValues(nameSpace, attribute, new Vector());
        }
        return true;
    }

    public static void addPrincipalValue(String nameSpace, String name, Object value, IInternalPrincipalDatabag principal) {
        String sValue = null;
        principal.deleteAttributeValues(nameSpace, name);
        if (value instanceof String) {
            sValue = (String)value;
            principal.addAttributeValue(nameSpace, name, sValue);
        } else if (value instanceof Vector) {
            Vector vValue = (Vector)value;
            int i = 0;
            while (i < vValue.size()) {
                sValue = (String)vValue.get(i);
                principal.addAttributeValue(nameSpace, name, sValue);
                ++i;
            }
        } else {
            principal.addAttributeValue(nameSpace, name, value);
        }
        Vector<String> allNames = principal.getAttributeValues(ATTR_ALL, ATTR_NAMES);
        if (allNames == null) {
            allNames = new Vector<String>();
        }
        allNames.add(nameSpace + "." + name);
        principal.setAttributeValues(ATTR_ALL, ATTR_NAMES, allNames);
    }

    public boolean bindNewPrincipalDatabag(IInternalPrincipalDatabag principal) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("bindNewPrincipalDatabag", new Object[]{principal});
        }
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        if (this.mConfigurationModel.getIsReadonly()) {
            if (mTrace.bePath()) {
                mTrace.exiting("bindNewPrincipalDatabag", new Boolean(false));
            }
            return false;
        }
        if (principal == null) {
            String errorMessage = "Given principal is null!";
            throw new PersistenceException(errorMessage);
        }
        Vector types = principal.getAttributeValues("com.sap.security.core.usermanagement", "PRINCIPAL_TYPE_ATTRIBUTE");
        if (types == null) {
            String errorMessage = "Missing attribute PRINCIPAL_TYPE_ATTRIBUTE on namespace com.sap.security.core.usermanagement in principal bind";
            throw new PersistenceException(errorMessage);
        }
        String type = (String)types.firstElement();
        if (type == null) {
            String errorMessage = "Missing attribute PRINCIPAL_TYPE_ATTRIBUTE on namespace com.sap.security.core.usermanagement in principal bind";
            throw new PersistenceException(errorMessage);
        }
        boolean responsible = this.isHomeForPrincipalDatabag(principal);
        if (responsible) {
            String id = principal.getUniqueID();
            if (id != null) {
                String errorMessage = "Principal databag " + id + " already bound!";
                throw new PersistenceException(errorMessage);
            }
            id = type + "." + this.mConfigurationModel.getDataSourceID() + "." + this.getPrivateIDPart(principal);
            if (mTrace.beInfo()) {
                mTrace.infoT("bindNewPrincipalDatabag", this.mConfigurationModel.getDataSourceID() + ": Bound principal databag, uniqueID is: " + id);
            }
            principal.setUniqueID(id);
        }
        if (mTrace.bePath()) {
            mTrace.exiting("bindNewPrincipalDatabag", new Boolean(responsible));
        }
        return responsible;
    }

    protected String getR3UserId(IInternalPrincipalDatabag principal) {
        String methodname = "getR3UserId";
        String type = null;
        try {
            String[] idParts = principal.getIDParts();
            type = idParts[0];
        }
        catch (PersistenceException e) {
            mTrace.debugT(methodname, e.getMessage(), (Throwable)((Object)e));
            return null;
        }
        Vector respNameSpaces = this.mConfigurationModel.getResponsibleNameSpaces(type);
        if (respNameSpaces == null) {
            respNameSpaces = new Vector();
            Enumeration en = principal.getNameSpaces();
            while (en.hasMoreElements()) {
                respNameSpaces.add(en.nextElement());
            }
        }
        int j = 0;
        while (j < respNameSpaces.size()) {
            String nameSpace = (String)respNameSpaces.elementAt(j);
            Enumeration attrsEn = principal.getAttributesOnNamespace(nameSpace);
            while (attrsEn.hasMoreElements()) {
                String attribute = (String)attrsEn.nextElement();
                if (type.equals("USER") && attribute.equals("uniquename")) {
                    Vector v = principal.getAttributeValues(nameSpace, attribute);
                    return (String)v.firstElement();
                }
                if (type.equals("UACC") && attribute.equals("j_user")) {
                    Vector v = principal.getAttributeValues(nameSpace, attribute);
                    return (String)v.firstElement();
                }
                if (!type.equals("ROLE") || !attribute.equals("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE")) continue;
                Vector v = principal.getAttributeValues(nameSpace, attribute);
                String princId = (String)v.firstElement();
                try {
                    String[] idParts = this.splitPrincipalDatabagID(princId);
                    return idParts[2];
                }
                catch (PersistenceException e) {
                    mTrace.debugT(methodname, e.getMessage(), (Throwable)((Object)e));
                    return null;
                }
            }
            ++j;
        }
        return null;
    }

    private void updateR3User(IInternalPrincipalDatabagMaint principal) throws PersistenceException {
        String methodname = "updateR3User";
        String principalID = principal.getUniqueID();
        String[] idParts = principal.getIDParts();
        String type = idParts[0];
        String userid = idParts[2];
        if (!this.principalDatabagExists(principal)) {
            String errorMessage = "Principal databag " + principalID + " does not exist!";
            throw new PersistenceException(errorMessage);
        }
        Vector respNameSpaces = this.mConfigurationModel.getResponsibleNameSpaces(type);
        if (respNameSpaces == null) {
            respNameSpaces = new Vector();
            Enumeration en = principal.getNameSpaces();
            while (en.hasMoreElements()) {
                respNameSpaces.add(en.nextElement());
            }
        }
        UserMaint tempUser = null;
        try {
            tempUser = new UserMaint();
            tempUser.setDisplayName(userid);
        }
        catch (Exception ex) {
            throw new PersistenceException(ex);
        }
        boolean valueChanged = false;
        int j = 0;
        while (j < respNameSpaces.size()) {
            String nameSpace = (String)respNameSpaces.elementAt(j);
            Enumeration attrsEn = principal.getAttributesOnNamespace(nameSpace);
            while (attrsEn.hasMoreElements()) {
                Vector v;
                String attribute = (String)attrsEn.nextElement();
                if (attribute.equals("PRINCIPAL_TYPE_ATTRIBUTE") || (v = principal.getAttributeValues(nameSpace, attribute)) == null || v.size() <= 0) continue;
                Object oValue = v.firstElement();
                if (type.equals("UACC")) {
                    if (!this.populateUserAccount(tempUser, oValue, attribute)) continue;
                    valueChanged = true;
                    continue;
                }
                if (!this.populateUser(tempUser, oValue, attribute)) continue;
                valueChanged = true;
            }
            ++j;
        }
        if (valueChanged) {
            try {
                CreateSyncXML createXML = new CreateSyncXML(this.r3_adapterid);
                String pwd = (String)mCache.get(userid.toUpperCase() + "j_password");
                if (pwd != null) {
                    createXML.setR3Password(pwd);
                    String pwdChgRq = (String)mCache.get(userid.toUpperCase() + "passwordchangerequired");
                    if (pwdChgRq != null) {
                        if (pwdChgRq.equalsIgnoreCase("true")) {
                            createXML.setR3ChangePasswordRequired(true);
                        } else {
                            createXML.setR3ChangePasswordRequired(false);
                        }
                    }
                }
                byte[] xmlDoc = createXML.getChangeSyncDoc(tempUser);
                mTrace.debugT(methodname, "Change XML: " + new String(xmlDoc));
                this.mFactory = R3ConnectionSAP.getR3Factory(this.r3_adapterid);
                this.mFactory.SMUM_TPUser(xmlDoc, this.r3_adapterid);
            }
            catch (UMException ex) {
                throw new PersistenceException(ex);
            }
        }
        mCache.invalidate(userid.toUpperCase() + "j_password");
        mCache.invalidate(userid.toUpperCase() + "passwordchangerequired");
    }

    private void createR3User(IInternalPrincipalDatabag principal) throws PersistenceException {
        String methodname = "createR3User";
        String principalID = principal.getUniqueID();
        String[] idParts = principal.getIDParts();
        String type = idParts[0];
        String userid = idParts[2];
        boolean valueChanged = false;
        if (this.principalDatabagExists(principal)) {
            String errorMessage = "Principal databag " + principalID + " is already existing!";
            throw new PersistenceException(errorMessage);
        }
        Vector respNameSpaces = this.mConfigurationModel.getResponsibleNameSpaces(type);
        if (respNameSpaces == null) {
            respNameSpaces = new Vector();
            Enumeration en = principal.getNameSpaces();
            while (en.hasMoreElements()) {
                respNameSpaces.add(en.nextElement());
            }
        }
        UserMaint tempUser = null;
        try {
            tempUser = new UserMaint();
            tempUser.setDisplayName(userid);
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
        int j = 0;
        while (j < respNameSpaces.size()) {
            String nameSpace = (String)respNameSpaces.elementAt(j);
            Enumeration attrsEn = principal.getAttributesOnNamespace(nameSpace);
            while (attrsEn.hasMoreElements()) {
                Vector v;
                String attribute = (String)attrsEn.nextElement();
                if (attribute.equals("PRINCIPAL_TYPE_ATTRIBUTE") || (v = principal.getAttributeValues(nameSpace, attribute)) == null || v.size() <= 0) continue;
                Object oValue = v.firstElement();
                if (type.equals("USER")) {
                    if (!this.populateUser(tempUser, oValue, attribute)) continue;
                    valueChanged = true;
                    continue;
                }
                if (!this.populateUserAccount(tempUser, oValue, attribute)) continue;
                valueChanged = true;
            }
            ++j;
        }
        if (valueChanged) {
            CreateSyncXML createXML = new CreateSyncXML(this.r3_adapterid);
            byte[] xmlDoc = null;
            String pwd = (String)mCache.get(userid.toUpperCase() + "j_password");
            if (pwd != null) {
                createXML.setR3Password(pwd);
                String pwdChgRq = (String)mCache.get(userid.toUpperCase() + "passwordchangerequired");
                if (pwdChgRq != null) {
                    if (pwdChgRq.equalsIgnoreCase("true")) {
                        createXML.setR3ChangePasswordRequired(true);
                    } else {
                        createXML.setR3ChangePasswordRequired(false);
                    }
                }
            }
            if (type.equals("USER")) {
                try {
                    xmlDoc = createXML.getCreateSyncDoc(tempUser);
                    mTrace.debugT(methodname, "Create XML: " + new String(xmlDoc));
                }
                catch (Exception ex) {
                    throw new PersistenceException(ex);
                }
            }
            try {
                xmlDoc = createXML.getChangeSyncDoc(tempUser);
                mTrace.debugT(methodname, "Change XML: " + new String(xmlDoc));
            }
            catch (Exception ex) {
                throw new PersistenceException(ex);
            }
            try {
                this.mFactory = R3ConnectionSAP.getR3Factory(this.r3_adapterid);
                this.mFactory.SMUM_TPUser(xmlDoc, this.r3_adapterid);
            }
            catch (UMException ex) {
                throw new PersistenceException(ex);
            }
        }
        mCache.invalidate(userid.toUpperCase() + "j_password");
        mCache.invalidate(userid.toUpperCase() + "passwordchangerequired");
    }

    private void deleteR3User(IPrincipalDatabag principal) throws PersistenceException {
        String methodname = "deleteR3User";
        String[] idParts = principal.getIDParts();
        String type = idParts[0];
        if (type.equals("UACC")) {
            CreateSyncXML createXML = new CreateSyncXML(this.r3_adapterid);
            com.sap.security.api.IUser user = null;
            try {
                user = UMFactory.getUserFactory().getUser(principal.getUniqueID());
            }
            catch (com.sap.security.api.UMException ex) {
                throw new PersistenceException(ex);
            }
            IUserAccount[] ua = new IUserAccount[1];
            try {
                ua = user.getUserAccounts();
            }
            catch (com.sap.security.api.UMException ex) {
                mTrace.warningT(methodname, ex.getMessage(), ex);
            }
            String logonId = user.getUniqueName();
            if (ua.length > 0) {
                logonId = ua[0].getLogonUid();
            }
            byte[] xmlDoc = createXML.getDeleteSyncDoc(logonId, Utils.getR3ID(user));
            mTrace.debugT(methodname, "Delete XML: " + new String(xmlDoc));
            try {
                this.mFactory = R3ConnectionSAP.getR3Factory(this.r3_adapterid);
                this.mFactory.SMUM_TPUser(xmlDoc, this.r3_adapterid);
            }
            catch (UMException ex) {
                throw new PersistenceException(ex);
            }
        }
    }

    private boolean populateUser(IUserMaint user, Object oValue, String attribute) {
        String methodname = "populateUser";
        String attrValue = null;
        boolean valueChanged = false;
        if (oValue instanceof String) {
            attrValue = (String)oValue;
            if (attribute.equals("uniquename")) {
                user.setDisplayName(attrValue);
                valueChanged = true;
            } else if (attribute.equals("displayname")) {
                user.setDisplayName(attrValue);
                valueChanged = true;
            } else if (attribute.equals("firstname")) {
                user.setFirstName(attrValue);
                valueChanged = true;
            } else if (attribute.equals("lastname")) {
                user.setLastName(attrValue);
                valueChanged = true;
            } else if (attribute.equals("email")) {
                user.setEmail(attrValue);
                valueChanged = true;
            } else if (attribute.equals("city")) {
                user.setCity(attrValue);
                valueChanged = true;
            } else if (attribute.equals("company")) {
                user.setCompany(attrValue);
                valueChanged = true;
            } else if (attribute.equals("companyid")) {
                user.setCompany(attrValue);
                valueChanged = true;
            } else if (attribute.equals("country")) {
                user.setCountry(attrValue);
                valueChanged = true;
            } else if (attribute.equals("currency")) {
                user.setCurrency(attrValue);
                valueChanged = true;
            } else if (attribute.equals("department")) {
                user.setDepartment(attrValue);
                valueChanged = true;
            } else if (attribute.equals("fax")) {
                user.setFax(attrValue);
                valueChanged = true;
            } else if (attribute.equals("jobtitle")) {
                user.setJobTitle(attrValue);
                valueChanged = true;
            } else if (attribute.equals("mobile")) {
                user.setCellPhone(attrValue);
                valueChanged = true;
            } else if (attribute.equals("state")) {
                user.setState(attrValue);
                valueChanged = true;
            } else if (attribute.equals("streetaddress")) {
                user.setStreet(attrValue);
                valueChanged = true;
            } else if (attribute.equals("telephone")) {
                user.setTelephone(attrValue);
                valueChanged = true;
            } else if (attribute.equals("timezone")) {
                try {
                    TimeZone tz = TimeZone.getTimeZone(attrValue);
                    user.setTimeZone(tz);
                    valueChanged = true;
                }
                catch (Exception ex) {
                    mTrace.warningT(methodname, "Error with " + attribute + "=" + attrValue);
                }
            } else if (attribute.equals("title")) {
                user.setTitle(attrValue);
                valueChanged = true;
            } else if (attribute.equals("zip")) {
                user.setZip(attrValue);
                valueChanged = true;
            } else if (attribute.equals("locale")) {
                try {
                    String lang = null;
                    String country = null;
                    int i = attrValue.indexOf("_");
                    if (i < 0) {
                        lang = attrValue;
                    } else {
                        lang = attrValue.substring(0, i);
                        country = attrValue.substring(i + 1);
                    }
                    Locale locale = new Locale(lang, country);
                    user.setLocale(locale);
                    valueChanged = true;
                }
                catch (Exception ex) {
                    mTrace.warningT(methodname, "Error with " + attribute + "=" + attrValue + ":" + ex.getMessage(), ex);
                }
            } else {
                mTrace.warningT(methodname, "Not implemented: " + attribute + "=" + oValue);
            }
        } else if (oValue instanceof Locale) {
            if (attribute.equals("locale")) {
                try {
                    user.setLocale((Locale)oValue);
                    valueChanged = true;
                }
                catch (Exception e) {
                    mTrace.warningT(methodname, e.getMessage(), e);
                }
            }
        } else if (oValue instanceof TimeZone) {
            if (attribute.equals("timezone")) {
                try {
                    user.setTimeZone((TimeZone)oValue);
                    valueChanged = true;
                }
                catch (Exception e) {
                    mTrace.warningT(methodname, e.getMessage(), e);
                }
            }
        } else {
            mTrace.warningT(methodname, "Not implemented: " + attribute + "=" + oValue);
        }
        return valueChanged;
    }

    private boolean populateUserAccount(IUserMaint user, Object oValue, String attribute) {
        String methodname = "populateUserAccount";
        String attrValue = null;
        boolean setValue = false;
        String uid = user.getUniqueName();
        if (uid == null) {
            uid = user.getDisplayName();
        }
        if (oValue instanceof String) {
            attrValue = (String)oValue;
            if (attribute.equals("j_password")) {
                mCache.put(uid.toUpperCase() + "j_password", attrValue);
                setValue = true;
            } else if (!attribute.equals("displayname")) {
                if (attribute.equals("passwordchangerequired")) {
                    mCache.put(uid.toUpperCase() + "passwordchangerequired", attrValue);
                    setValue = true;
                } else if (!attribute.equals("validfrom") && !attribute.equals("validto")) {
                    if (attribute.equals("islocked")) {
                        mCache.put(uid + "islocked", attrValue);
                        setValue = true;
                    } else if (!attribute.equals("lockreason")) {
                        mTrace.warningT(methodname, "Not implemented: " + attribute + "=" + oValue);
                    }
                }
            }
        }
        return setValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

