/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.ISearchAttribute;
import com.sap.security.api.UMFactory;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.IInternalPrincipalDatabag;
import com.sap.security.core.persistence.IInternalPrincipalDatabagMaint;
import com.sap.security.core.persistence.IPrincipalDatabag;
import com.sap.security.core.persistence.datasource.IDataSource;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.datasource.imp.DSConfigurationModel;
import com.sap.security.core.persistence.datasource.imp.DataSourceBaseImplementation;
import com.sap.security.core.persistence.datasource.imp.R3JCoProxy;
import com.sap.security.core.persistence.imp.SearchCriteria;
import com.sap.security.core.util.IUMTrace;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Array;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class R3PersistenceBase
extends DataSourceBaseImplementation
implements IDataSource {
    private static final IUMTrace LOG_STATIC = InternalUMFactory.getTrace((class$com$sap$security$core$persistence$datasource$imp$R3PersistenceBase == null ? (class$com$sap$security$core$persistence$datasource$imp$R3PersistenceBase = R3PersistenceBase.class$("com.sap.security.core.persistence.datasource.imp.R3PersistenceBase")) : class$com$sap$security$core$persistence$datasource$imp$R3PersistenceBase).getName());
    protected IUMTrace LOG_BASE = null;
    public static final String MASTER_ADAPTERID = "ume.logon.r3master.adapterid";
    protected static final String BC_MSGID = "01";
    protected static final String NO_SUCH_USER_MSGNO = "124";
    private static final String HTML_DUMP = "ume.r3.user.html_dump";
    private static final int REINIT_INTERVAL_SEC = 60;
    private static final String SAPJSF_PASSWD = "passwd";
    private boolean _htmlDumpActive = false;
    private DSConfigurationModel _dsConfigurationModel;
    private long _lastReInitAttempt = 0L;
    protected R3JCoProxy _backendProxy;
    protected String _systemId;
    protected String _communicationUser;
    private static HashMap _poolMap = new HashMap();
    protected static final String USER = "USER";
    protected static final String UACC = "UACC";
    protected static final String GRUP = "GRUP";
    protected static final String ROLE = "ROLE";
    static /* synthetic */ Class class$com$sap$security$core$persistence$datasource$imp$R3PersistenceBase;

    protected PersistenceException newPersistenceException(IUMTrace trace, String method, Throwable t) {
        PersistenceException pe = t instanceof PersistenceException ? (PersistenceException)((Object)t) : new PersistenceException(t);
        LogUtil.logThrowable(1, this.LOG_BASE, method, "An exception was thrown in the UME/ABAP user management connector. Message: {0}.", new Object[]{pe.getMessage()}, (Throwable)((Object)pe));
        return pe;
    }

    protected void logFunction(String callingMethod, R3JCoProxy.Function function) {
        String RFC_DUMP_HEADER = "-----BEGIN REMOTE FUNCTION CALL-----";
        String RFC_DUMP_FOOTER = "-----END REMOTE FUNCTION CALL-----";
        if (this._htmlDumpActive && this.LOG_BASE.beDebug()) {
            try {
                StringWriter sw = new StringWriter();
                StringBuffer sb = sw.getBuffer();
                sb.append("\n").append("-----BEGIN REMOTE FUNCTION CALL-----").append("\n");
                function.writeHTML(sw);
                sb.append("\n").append("-----END REMOTE FUNCTION CALL-----");
                this.LOG_BASE.debugT(callingMethod, sb.toString());
            }
            catch (Exception e) {
                this.LOG_BASE.debugT(callingMethod, "Logging of remote function call failed: " + LogUtil.getStackTrace(e));
            }
        }
    }

    protected String sensitiveMap2s(Map map) {
        StringBuffer sb = new StringBuffer();
        Iterator iter = map.entrySet().iterator();
        sb.append("{\n");
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            sb.append("  ").append(key).append('=');
            if (!this._htmlDumpActive && ("j_password".equals(key) || "oldpassword".equals(key) || SAPJSF_PASSWD.equals(key) || "jco.client.passwd".equals(key))) {
                sb.append("********");
            } else {
                sb.append(entry.getValue());
            }
            sb.append("\n");
        }
        sb.append("}\n");
        return sb.toString();
    }

    public void init(DSConfigurationModel dsConf) throws PersistenceException {
        String METHOD = "init()";
        String className = this.getClass().getName();
        try {
            try {
                LogUtil.logEntering(this.LOG_BASE, "init()", new Object[]{dsConf});
                this._dsConfigurationModel = dsConf;
                if (this.LOG_BASE.beDebug()) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("Detail data of DSConfigurationModel for " + className + ": ");
                    sb.append("DataSourceID = " + dsConf.getDataSourceID() + ", DisplayName = " + dsConf.getDisplayName() + ", IsPrimary = " + dsConf.getIsPrimary() + ", IsReadonly = " + dsConf.getIsReadonly() + ", AttributeMapping = " + dsConf.getAttributeMapping());
                    Vector homeFor = dsConf.getHomePrincipalTypes();
                    int i = 0;
                    while (i < homeFor.size()) {
                        String type = (String)homeFor.elementAt(i);
                        sb.append(", HomeFor = " + type);
                        ++i;
                    }
                    Vector resp = dsConf.getResponsiblePrincipalTypes();
                    int i2 = 0;
                    while (i2 < resp.size()) {
                        String type = (String)resp.elementAt(i2);
                        sb.append(", ResponsibleFor = " + type + " --> [");
                        sb.append("PopulateInitially = " + dsConf.getPopulateInitially(type));
                        sb.append(", Attributes = " + dsConf.getResponsibleNameSpaceAttributes(type));
                        sb.append("]");
                        ++i2;
                    }
                    this.LOG_BASE.debugT("init()", sb.toString());
                }
                super.init(dsConf);
                try {
                    this._htmlDumpActive = dsConf.getPrivateAttributeBooleanValue(HTML_DUMP);
                }
                catch (Exception e) {
                    this._htmlDumpActive = false;
                }
                this.assertResponsibility(dsConf);
                this.localInitialization(dsConf);
                this.LOG_BASE.debugT("init()", "ABAP data source (" + className + ") initialized");
                this.isInitialized = true;
            }
            catch (Exception e) {
                HashMap hashMap = _poolMap;
                synchronized (hashMap) {
                    _poolMap.remove(dsConf.getDataSourceID());
                }
                PersistenceException pe = this.newPersistenceException(this.LOG_BASE, "init()", e);
                this.LOG_BASE.logErrorT("User Management Engine (" + className + ") failed to initialize the " + "ABAP data source: {0}", new Object[]{pe.getMessage()});
                LogUtil.exitMethodWithException(this.LOG_BASE, "init()", (Throwable)((Object)pe));
                throw pe;
            }
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            LogUtil.logExiting(this.LOG_BASE, "init()");
            throw throwable;
        }
        LogUtil.logExiting(this.LOG_BASE, "init()");
    }

    protected abstract void assertResponsibility(DSConfigurationModel var1) throws Exception;

    protected abstract void localInitialization(DSConfigurationModel var1) throws Exception;

    protected void assertInitialization() throws Exception {
        String METHOD = "assertInitialization()";
        if (!this.isInitialized) {
            R3PersistenceBase r3PersistenceBase = this;
            synchronized (r3PersistenceBase) {
                if (this.isInitialized) {
                    return;
                }
                long currentTime = System.currentTimeMillis();
                int lastFailedSecondsAgo = (int)((currentTime - this._lastReInitAttempt) / 1000L);
                if (this._lastReInitAttempt != 0L && lastFailedSecondsAgo < 60) {
                    this.LOG_BASE.debugT("assertInitialization()", "Re-Initialization not attempted because last failed attempt was only {0} seconds ago (minimum waiting time is {1} seconds}", new Object[]{new Integer(lastFailedSecondsAgo), new Integer(60)});
                    throw new PersistenceException("ABAP data source not initialized");
                }
                this._lastReInitAttempt = currentTime;
                try {
                    this.LOG_BASE.logInfoT("Attempting lazy initialization of ABAP data source", null);
                    this.init(this._dsConfigurationModel);
                }
                catch (Exception e) {
                    this.LOG_BASE.logWarningT("Initialization of ABAP data source failed. Error message was already provided.", null);
                    throw new PersistenceException("ABAP data source not initialized");
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void doInitRfc(DSConfigurationModel dsConf, String reUseFromID) throws Exception {
        block21: {
            block20: {
                String METHOD = "doInitRfc()";
                String className = this.getClass().getName();
                try {
                    try {
                        LogUtil.logEntering(this.LOG_BASE, "doInitRfc()", new Object[]{reUseFromID});
                        if (reUseFromID != null) {
                            HashMap hashMap = _poolMap;
                            synchronized (hashMap) {
                                PoolMapEntry entry = (PoolMapEntry)_poolMap.get(reUseFromID);
                                if (entry == null) {
                                    throw new PersistenceException("Datasource " + dsConf.getDataSourceID() + " specifies that it wants to re-use " + "the connection " + "data from datasource " + reUseFromID + " which is not yet initialized");
                                }
                                this._backendProxy = entry.backendProxy;
                                this._systemId = entry.systemID;
                                this._communicationUser = entry.communicationUser;
                                this.LOG_BASE.debugT("doInitRfc()", "Datasource {0} re-uses backend connection from datasource {1}", new Object[]{dsConf.getDataSourceID(), reUseFromID});
                            }
                            Object var19_9 = null;
                            break block20;
                        }
                        HashMap hashMap = _poolMap;
                        synchronized (hashMap) {
                            if (_poolMap.containsKey(dsConf.getDataSourceID())) {
                                throw new PersistenceException("Datasource with ID " + dsConf.getDataSourceID() + " was already initialized. " + "Check datasource configuration for " + "duplicate ID's.");
                            }
                        }
                        StringBuffer namespaceOut = new StringBuffer();
                        Properties pDataSource = this.getDataSourceProperties(dsConf, namespaceOut);
                        R3JCoProxy.Client client = null;
                        try {
                            try {
                                this._backendProxy = R3JCoProxy.getInstance(pDataSource);
                                client = this._backendProxy.getClient();
                                R3JCoProxy.Attributes attributes = client.getAttributes();
                                StringBuffer systemId = new StringBuffer();
                                systemId.append(attributes.getSystemID());
                                systemId.append("CLNT");
                                systemId.append(attributes.getClient());
                                this._systemId = systemId.toString();
                                this._communicationUser = attributes.getUser();
                                HashMap hashMap2 = _poolMap;
                                synchronized (hashMap2) {
                                    PoolMapEntry entry = new PoolMapEntry();
                                    entry.backendProxy = this._backendProxy;
                                    entry.systemID = this._systemId;
                                    entry.communicationUser = this._communicationUser;
                                    _poolMap.put(dsConf.getDataSourceID(), entry);
                                }
                                this.LOG_BASE.logInfoT("User Management Engine (" + className + ") connected to client {0} of " + "ABAP backend system {1} as user {2}", new Object[]{attributes.getClient(), attributes.getSystemID(), attributes.getUser()});
                            }
                            catch (Exception e) {
                                String message = e.getMessage();
                                if (message == null || message.trim().length() == 0) {
                                    message = e.getLocalizedMessage();
                                }
                                this.LOG_BASE.logFatalT("User Management Engine (" + className + ") failed to connect to the ABAP backend system. " + "Check that connection data are correct and the " + "backend system is available. Error message: \"{0}\". " + "Connection data (obtained from properties of UME service in section \"" + namespaceOut.toString() + "\": \"{1}\".", new Object[]{message, this.sensitiveMap2s(pDataSource)});
                                throw e;
                            }
                            Object var17_21 = null;
                            if (this._backendProxy != null && client != null) {
                                this._backendProxy.releaseClient(client);
                            }
                            break block21;
                        }
                        catch (Throwable throwable) {
                            Object var17_22 = null;
                            if (this._backendProxy == null) throw throwable;
                            if (client == null) throw throwable;
                            this._backendProxy.releaseClient(client);
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        LogUtil.exitMethodWithException(this.LOG_BASE, "doInitRfc()", e);
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    Object var19_11 = null;
                    LogUtil.logExiting(this.LOG_BASE, "doInitRfc()");
                    throw throwable;
                }
            }
            LogUtil.logExiting(this.LOG_BASE, "doInitRfc()");
            return;
        }
        Object var19_10 = null;
        LogUtil.logExiting(this.LOG_BASE, "doInitRfc()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties getDataSourceProperties(DSConfigurationModel dsConf, StringBuffer namespace) throws Exception {
        String mapValue2;
        Properties properties;
        String METHOD = "getDataSourceProperties()";
        Properties result = null;
        try {
            try {
                String password;
                String passwdKey;
                LogUtil.logEntering(LOG_STATIC, "getDataSourceProperties()");
                final IUMParameters params = UMFactory.getProperties();
                if (params == null) {
                    throw new PersistenceException("UMFactory.getProperties() returned NULL");
                }
                String ns = "ume.r3.connection." + params.get(MASTER_ADAPTERID, "master") + ".";
                LOG_STATIC.debugT("getDataSourceProperties()", "ns = " + ns);
                Properties pSapum = params.getProperties();
                if (pSapum == null) {
                    throw new PersistenceException("params.getProperties() returned NULL");
                }
                Properties pInit = new Properties();
                namespace.append(ns);
                LOG_STATIC.debugT("getDataSourceProperties()", "Starting transcription of properties");
                Iterator iter = ((Hashtable)pSapum).entrySet().iterator();
                while (true) {
                    String privateValue;
                    String strippedKey;
                    String fullKey;
                    Map.Entry entry;
                    block17: {
                        block18: {
                            block16: {
                                if (!iter.hasNext()) {
                                    LOG_STATIC.debugT("getDataSourceProperties()", "Adding protected properties");
                                    passwdKey = ns + SAPJSF_PASSWD;
                                    try {
                                        password = dsConf.getPrivateAttribute(passwdKey);
                                    }
                                    catch (Exception e) {
                                        password = null;
                                    }
                                    break;
                                }
                                entry = iter.next();
                                fullKey = (String)entry.getKey();
                                LOG_STATIC.debugT("getDataSourceProperties()", "Processing key = \"" + fullKey + "\"");
                                strippedKey = null;
                                if (!fullKey.startsWith(ns) || fullKey.length() <= ns.length()) break block16;
                                strippedKey = fullKey.substring(ns.length());
                                LOG_STATIC.debugT("getDataSourceProperties()", "key = \"" + strippedKey + "\" (namespace stripped)");
                                if (!"msghost".equals(strippedKey)) break block17;
                                break block18;
                            }
                            LOG_STATIC.debugT("getDataSourceProperties()", "Skipping this entry (not my namespace)");
                            continue;
                        }
                        strippedKey = "mshost";
                    }
                    try {
                        privateValue = dsConf.getPrivateAttribute(fullKey);
                    }
                    catch (Exception e) {
                        privateValue = null;
                    }
                    String effectiveValue = privateValue != null ? privateValue : (String)entry.getValue();
                    pInit.setProperty(strippedKey, effectiveValue);
                }
                if (password == null) {
                    password = (String)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return params.getPassword(passwdKey);
                        }
                    });
                }
                pInit.setProperty(SAPJSF_PASSWD, password);
                properties = result = pInit;
                Object var16_18 = null;
                mapValue2 = null;
                if (LOG_STATIC.bePath()) {
                    mapValue2 = this.sensitiveMap2s(result);
                }
            }
            catch (Exception e) {
                LogUtil.exitMethodWithException(LOG_STATIC, "getDataSourceProperties()", e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            String mapValue2 = null;
            if (LOG_STATIC.bePath()) {
                mapValue2 = this.sensitiveMap2s(result);
            }
            LogUtil.logExiting(LOG_STATIC, "getDataSourceProperties()", mapValue2);
            throw throwable;
        }
        LogUtil.logExiting(LOG_STATIC, "getDataSourceProperties()", mapValue2);
        return properties;
    }

    public void populatePrincipalDatabags(IInternalPrincipalDatabag[] principals, AttributeList populateAttributes) throws PersistenceException {
        String METHOD = "populatePrincipalDatabags()";
        try {
            block6: {
                try {
                    LogUtil.logEntering(this.LOG_BASE, "populatePrincipalDatabags()", new Object[]{"<Parameters see calls to \"populatePrincipalDatabag()\">"});
                    if (null == principals) break block6;
                    int i = 0;
                    while (i < principals.length) {
                        if (null != principals[i]) {
                            this.populatePrincipalDatabag(principals[i], populateAttributes);
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    PersistenceException pe = this.newPersistenceException(this.LOG_BASE, "populatePrincipalDatabags()", e);
                    LogUtil.exitMethodWithException(this.LOG_BASE, "populatePrincipalDatabags()", (Throwable)((Object)pe));
                    throw pe;
                }
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            LogUtil.logExiting(this.LOG_BASE, "populatePrincipalDatabags()", "<Parameters at end of method already shown for calls to \"populatePrincipalDatabag()\">");
            throw throwable;
        }
        LogUtil.logExiting(this.LOG_BASE, "populatePrincipalDatabags()", "<Parameters at end of method already shown for calls to \"populatePrincipalDatabag()\">");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IInternalPrincipalDatabag[] initPrincipalDatabags(IInternalPrincipalDatabag[] principals) throws PersistenceException {
        IInternalPrincipalDatabag[] iInternalPrincipalDatabagArray;
        String METHOD = "initPrincipalDatabags()";
        try {
            try {
                LogUtil.logEntering(this.LOG_BASE, "initPrincipalDatabags()", new Object[]{principals});
                this.assertInitialization();
                int size = principals.length;
                int i = 0;
                while (true) {
                    if (i >= size) {
                        iInternalPrincipalDatabagArray = principals;
                        Object var7_8 = null;
                        break;
                    }
                    if (principals[i] != null) {
                        this.populatePrincipalDatabag(principals[i], null);
                        if (this.isHomeForPrincipalDatabag(principals[i]) && !this.principalDatabagExists(principals[i])) {
                            this.LOG_BASE.debugT("initPrincipalDatabags()", "Principal {0} does not exist --> setting array element to null");
                            principals[i] = null;
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                PersistenceException pe = this.newPersistenceException(this.LOG_BASE, "initPrincipalDatabags()", e);
                LogUtil.exitMethodWithException(this.LOG_BASE, "initPrincipalDatabags()", (Throwable)((Object)pe));
                throw pe;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            LogUtil.logExiting(this.LOG_BASE, "initPrincipalDatabags()", (Object)principals);
            throw throwable;
        }
        LogUtil.logExiting(this.LOG_BASE, "initPrincipalDatabags()", (Object)principals);
        return iInternalPrincipalDatabagArray;
    }

    protected void handleBapiRet2Table(String callingMethod, String rfcFunc, R3JCoProxy.Table tabBapiRet2) throws Exception {
        PersistenceException firstException = null;
        StringBuffer message = new StringBuffer();
        int i = 0;
        while (i < tabBapiRet2.getNumRows()) {
            tabBapiRet2.setRow(i);
            String msgId = tabBapiRet2.getString("ID");
            String msgNumber = tabBapiRet2.getString("NUMBER");
            int severity = Util.getMessageSeverity(tabBapiRet2.getString("TYPE"));
            if ("AM".equals(msgId) && "319".equals(msgNumber)) {
                this.LOG_BASE.debugT(callingMethod, "Warning message AM 319 skipped from log");
            } else {
                message.append(rfcFunc).append('@');
                message.append(this._systemId);
                message.append(": ID=").append(msgId);
                message.append(", NUMBER=").append(msgNumber);
                message.append(", MESSAGE=");
                message.append(tabBapiRet2.getString("MESSAGE"));
                this.LOG_BASE.debugT(callingMethod, message.toString());
                if (BC_MSGID.equals(msgId) && NO_SUCH_USER_MSGNO.equals(msgNumber)) {
                    firstException = new NoSuchPrincipalException(message.toString());
                } else if (null == firstException && (0 == severity || 1 == severity)) {
                    firstException = new PersistenceException(message.toString());
                }
                message.delete(0, message.length());
            }
            ++i;
        }
        if (null != firstException) {
            throw firstException;
        }
    }

    protected void handleBapiRet2Struct(String callingMethod, String rfcFunc, R3JCoProxy.Structure structBapiRet2) throws Exception {
        String msgType = structBapiRet2.getString("TYPE");
        String msgId = structBapiRet2.getString("ID");
        String msgNumber = structBapiRet2.getString("NUMBER");
        if (!"".equals(msgType) && !"".equals(msgId)) {
            int severity = Util.getMessageSeverity(msgType);
            StringBuffer message = new StringBuffer();
            message.append(rfcFunc).append('@');
            message.append(this._systemId);
            message.append(": ID=").append(msgId);
            message.append(", NUMBER=").append(msgNumber);
            message.append(", MESSAGE=");
            message.append(structBapiRet2.getString("MESSAGE"));
            this.LOG_BASE.debugT(callingMethod, message.toString());
            if (BC_MSGID.equals(msgId) && NO_SUCH_USER_MSGNO.equals(msgNumber)) {
                throw new NoSuchPrincipalException(message.toString());
            }
            if (0 == severity || 1 == severity) {
                throw new PersistenceException(message.toString());
            }
        }
    }

    public static void main(String[] args) throws Exception {
        PatternMatcher pm = new PatternMatcher("A*B", false, false);
        R3PersistenceBase.verify(pm.matches("AXB"));
        R3PersistenceBase.verify(pm.matches("AXYZB"));
        R3PersistenceBase.verify(pm.matches("AB"));
        R3PersistenceBase.verify(pm.matches("A*B"));
        R3PersistenceBase.verify(!pm.matches("AXBC"));
        R3PersistenceBase.verify(!pm.matches("UAXB"));
        R3PersistenceBase.verify(!pm.matches("*XBC"));
        R3PersistenceBase.verify(!pm.matches(""));
        pm = new PatternMatcher("*ABC", false, false);
        R3PersistenceBase.verify(pm.matches("ABC"));
        R3PersistenceBase.verify(pm.matches("AAABC"));
        R3PersistenceBase.verify(pm.matches("UXZABC"));
        R3PersistenceBase.verify(pm.matches("*ABC"));
        R3PersistenceBase.verify(!pm.matches("UABCA"));
        R3PersistenceBase.verify(!pm.matches(""));
        pm = new PatternMatcher("ABC*", false, false);
        R3PersistenceBase.verify(pm.matches("ABC"));
        R3PersistenceBase.verify(pm.matches("ABCA"));
        R3PersistenceBase.verify(pm.matches("ABCDEF"));
        R3PersistenceBase.verify(pm.matches("ABC*"));
        R3PersistenceBase.verify(!pm.matches("XABC"));
        R3PersistenceBase.verify(!pm.matches(""));
        pm = new PatternMatcher("*ABC*", false, false);
        R3PersistenceBase.verify(pm.matches("ABC"));
        R3PersistenceBase.verify(pm.matches("ABCX"));
        R3PersistenceBase.verify(pm.matches("XABC"));
        R3PersistenceBase.verify(pm.matches("TESTABCFOO"));
        R3PersistenceBase.verify(!pm.matches("HELLO"));
        R3PersistenceBase.verify(!pm.matches(""));
        pm = new PatternMatcher("*", false, false);
        R3PersistenceBase.verify(pm.matches("ABC"));
        R3PersistenceBase.verify(pm.matches("ABCX"));
        R3PersistenceBase.verify(pm.matches("XABC"));
        R3PersistenceBase.verify(pm.matches("TESTABCFOO"));
        R3PersistenceBase.verify(pm.matches(""));
        pm = new PatternMatcher("", false, false);
        R3PersistenceBase.verify(pm.matches("ABC"));
        R3PersistenceBase.verify(pm.matches("ABCX"));
        R3PersistenceBase.verify(pm.matches("XABC"));
        R3PersistenceBase.verify(pm.matches("TESTABCFOO"));
        R3PersistenceBase.verify(pm.matches(""));
        pm = new PatternMatcher("Test*", true, true);
        R3PersistenceBase.verify(pm.matches("Test*"));
        R3PersistenceBase.verify(!pm.matches("Testx"));
        R3PersistenceBase.verify(!pm.matches(" Test*"));
        pm = new PatternMatcher("Test*", true, false);
        R3PersistenceBase.verify(pm.matches("Test*"));
        R3PersistenceBase.verify(pm.matches("TEST*"));
        R3PersistenceBase.verify(pm.matches("teSt*"));
        R3PersistenceBase.verify(!pm.matches("est*"));
        R3PersistenceBase.verify(!pm.matches("Test"));
        R3PersistenceBase.verify(!pm.matches(""));
    }

    private static void verify(boolean condition) throws Exception {
        if (!condition) {
            throw new Exception("Local test failed. Check line to locate.");
        }
    }

    private static IPersistenceCollection toPersistenceCollection(Vector vector) {
        if (vector != null) {
            return new PersistenceCollection(vector);
        }
        return null;
    }

    private static IPersistenceCollection toPersistenceCollection(Enumeration enumeration) {
        if (enumeration != null) {
            PersistenceCollection result = new PersistenceCollection();
            while (enumeration.hasMoreElements()) {
                result.add(enumeration.nextElement());
            }
            return result;
        }
        return null;
    }

    protected IPersistenceCollection buildUnion(IPersistenceCollection[] collections) {
        Vector[] vectors;
        if (collections != null) {
            vectors = new Vector[collections.length];
            int i = 0;
            while (i < collections.length) {
                vectors[i] = collections[i] != null ? collections[i].toVector() : null;
                ++i;
            }
        } else {
            vectors = null;
        }
        Vector result = this.buildUnion(vectors);
        return result != null ? new PersistenceCollection(result) : null;
    }

    protected IPersistenceCollection buildIntersection(IPersistenceCollection[] collections) {
        Vector[] vectors;
        if (collections != null) {
            vectors = new Vector[collections.length];
            int i = 0;
            while (i < collections.length) {
                vectors[i] = collections[i] != null ? collections[i].toVector() : null;
                ++i;
            }
        } else {
            vectors = null;
        }
        Vector result = this.buildIntersection(vectors);
        return result != null ? new PersistenceCollection(result) : null;
    }

    public abstract boolean checkCredentials(IPersistenceMap var1) throws PersistenceException;

    public abstract IPersistenceCollection getAllAttributes(IPrincipalDatabag var1, String var2) throws PersistenceException;

    public abstract IPersistenceCollection getAllNamespaces(IPrincipalDatabag var1) throws PersistenceException;

    public abstract IPersistenceCollection searchPrincipalDatabags(ISearchCriteria var1) throws PersistenceException;

    public boolean checkCredentials(Hashtable credentials) throws PersistenceException {
        if (credentials != null) {
            return this.checkCredentials(new PersistenceMap(credentials));
        }
        return this.checkCredentials((IPersistenceMap)null);
    }

    public Vector getAttributeNames(IPrincipalDatabag principal, String nameSpace) throws PersistenceException {
        IPersistenceCollection result = this.getAllAttributes(principal, nameSpace);
        return result != null ? result.toVector() : null;
    }

    public Vector getAttributeNamespaces(IPrincipalDatabag principal) throws PersistenceException {
        IPersistenceCollection result = this.getAllNamespaces(principal);
        return result != null ? result.toVector() : null;
    }

    public Vector searchPrincipalDatabags(SearchCriteria criteria) throws PersistenceException {
        IPersistenceCollection result = criteria != null ? this.searchPrincipalDatabags(new MySearchCriteria(criteria)) : this.searchPrincipalDatabags((ISearchCriteria)null);
        return result != null ? result.toVector() : null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class InternalPrincipalDatabagWrapper {
        IInternalPrincipalDatabag _pd;

        public InternalPrincipalDatabagWrapper(IInternalPrincipalDatabag pd) {
            this._pd = pd;
        }

        public IPersistenceCollection getValues(String ns, String att) {
            return R3PersistenceBase.toPersistenceCollection(this._pd.getAttributeValues(ns, att));
        }

        public IPersistenceCollection getAllNameSpaces() {
            return R3PersistenceBase.toPersistenceCollection(this._pd.getNameSpaces());
        }

        public IPersistenceCollection getAllAttributes(String ns) {
            return R3PersistenceBase.toPersistenceCollection(this._pd.getAttributesOnNamespace(ns));
        }

        public String toString() {
            return this._pd.toString();
        }
    }

    protected static class PrincipalDatabagWrapper {
        IPrincipalDatabag _pd;

        public PrincipalDatabagWrapper(IPrincipalDatabag pd) {
            this._pd = pd;
        }

        public IPersistenceCollection getValues(String ns, String att) {
            return R3PersistenceBase.toPersistenceCollection(this._pd.getAttributeValues(ns, att));
        }

        public String toString() {
            return this._pd.toString();
        }
    }

    protected static class InternalPrincipalDatabagMaintWrapper {
        IInternalPrincipalDatabagMaint _pd;

        public InternalPrincipalDatabagMaintWrapper(IInternalPrincipalDatabagMaint pd) {
            this._pd = pd;
        }

        public IPersistenceCollection getReadValues(String ns, String att) {
            return R3PersistenceBase.toPersistenceCollection(this._pd.getReadAttributeValues(ns, att));
        }

        public IPersistenceCollection getValues(String ns, String att) {
            return R3PersistenceBase.toPersistenceCollection(this._pd.getAttributeValues(ns, att));
        }

        public IPersistenceCollection getValues(String ns, String att, int type) {
            return R3PersistenceBase.toPersistenceCollection(this._pd.getAttributeValues(ns, att, type));
        }

        public IPersistenceCollection getAllAttributes(String ns, int type) {
            return R3PersistenceBase.toPersistenceCollection(this._pd.getAttributesOnNamespace(ns, type));
        }

        public IPersistenceCollection getAllNameSpaces(int type) {
            return R3PersistenceBase.toPersistenceCollection(this._pd.getNameSpaces(type));
        }

        public String toString() {
            return this._pd.toString();
        }
    }

    private static class PersistenceMap
    implements IPersistenceMap {
        Hashtable _table;

        public PersistenceMap(Hashtable table) {
            this._table = table;
        }

        public Object get(Object key) {
            return this._table.get(key);
        }

        public String toString() {
            return this._table.toString();
        }
    }

    protected static interface IPersistenceMap {
        public Object get(Object var1);
    }

    private static class MySearchCriteria
    implements ISearchCriteria {
        private SearchCriteria _crit;

        public MySearchCriteria(SearchCriteria crit) {
            this._crit = crit;
        }

        public void errorOccurred(int error) {
            this._crit.errorOccurred(error);
        }

        public ISearchAttribute getAttribute(int i) {
            return this._crit.getAttribute(i);
        }

        public int getElementSize() {
            return this._crit.getElementSize();
        }

        public String getPrincipalType() {
            return this._crit.getPrincipalType();
        }

        public int getSearchSizeLimit() {
            return this._crit.getSearchSizeLimit();
        }

        public boolean isOrMode() {
            return this._crit.isOrMode();
        }

        public String toString() {
            return this._crit.toString();
        }
    }

    protected static interface ISearchCriteria {
        public String getPrincipalType();

        public int getElementSize();

        public ISearchAttribute getAttribute(int var1);

        public boolean isOrMode();

        public int getSearchSizeLimit();

        public void errorOccurred(int var1);
    }

    protected static class PersistenceCollection
    implements IPersistenceCollection {
        private Vector _vector;

        public PersistenceCollection(Vector vector) {
            this._vector = vector;
        }

        public boolean contains(Object o) {
            return this._vector.contains(o);
        }

        public int size() {
            return this._vector.size();
        }

        public Iterator iterator() {
            return ((AbstractList)this._vector).iterator();
        }

        public Object clone() {
            return new PersistenceCollection((Vector)this._vector.clone());
        }

        public PersistenceCollection(int i) {
            this._vector = new Vector(i);
        }

        public PersistenceCollection() {
            this._vector = new Vector(0);
        }

        public Vector toVector() {
            return this._vector;
        }

        public void add(Object o) {
            this._vector.add(o);
        }

        public boolean isEmpty() {
            return this._vector.isEmpty();
        }

        public Object getOnlyElement() {
            return this._vector.elementAt(0);
        }

        public String toString() {
            return this._vector.toString();
        }
    }

    protected static interface IPersistenceCollection
    extends Cloneable,
    Serializable {
        public Vector toVector();

        public void add(Object var1);

        public boolean contains(Object var1);

        public int size();

        public Iterator iterator();

        public Object clone();

        public boolean isEmpty();

        public Object getOnlyElement();
    }

    protected static class PatternMatcher {
        private final boolean __caseSensitive;
        private final boolean __exactMatch;
        private final String __exactMatchString;
        private LinkedList __fragments = null;
        private boolean __anyStart = false;
        private boolean __anyEnd = false;

        public PatternMatcher(String pattern, boolean exactMatch, boolean caseSensitive) {
            String patternString;
            this.__exactMatch = exactMatch;
            this.__caseSensitive = caseSensitive;
            String string = patternString = caseSensitive ? pattern : Util.charWiseUpperCase(pattern);
            if (exactMatch) {
                this.__exactMatchString = patternString;
                return;
            }
            this.__exactMatchString = null;
            this.__fragments = new LinkedList();
            StringTokenizer st = new StringTokenizer(patternString, "*");
            while (st.hasMoreTokens()) {
                this.__fragments.addLast(st.nextToken());
            }
            this.__anyStart = patternString.length() > 0 && patternString.charAt(0) == '*';
            this.__anyEnd = patternString.length() > 0 && patternString.charAt(patternString.length() - 1) == '*';
        }

        public boolean matches(String testee) {
            String testString;
            String string = testString = this.__caseSensitive ? testee : Util.charWiseUpperCase(testee);
            if (this.__exactMatch) {
                return this.__exactMatchString.equals(testString);
            }
            int currentPos = 0;
            int currentFragment = 0;
            Iterator fragmentsIterator = this.__fragments.iterator();
            while (fragmentsIterator.hasNext()) {
                String fragment = (String)fragmentsIterator.next();
                ++currentFragment;
                if (currentPos >= testString.length()) {
                    return false;
                }
                int fragmentPosition = testString.indexOf(fragment, currentPos);
                if (fragmentPosition == -1) {
                    return false;
                }
                if (currentFragment == 1 && !this.__anyStart && fragmentPosition != 0) {
                    return false;
                }
                currentPos = fragmentPosition + fragment.length();
                if (currentFragment != this.__fragments.size() || this.__anyEnd || currentPos == testString.length()) continue;
                return false;
            }
            return true;
        }
    }

    protected static class NoSuchPrincipalException
    extends PersistenceException {
        NoSuchPrincipalException() {
        }

        NoSuchPrincipalException(String message) {
            super(message);
        }
    }

    protected static class WeakLRUHashMap {
        private LRUHashMap _map;
        private int _secondsToLive;
        static List _instances = new LinkedList();

        public WeakLRUHashMap(int maxSize, int secondsToLive) {
            this._map = new LRUHashMap(maxSize);
            this._secondsToLive = secondsToLive;
            _instances.add(this);
        }

        public synchronized void put(Object key, Object object) {
            this._map.put(key, new SoftReference<Line>(new Line(object, this._secondsToLive)));
        }

        public synchronized Object get(Object key) {
            Reference ref = (Reference)this._map.get(key);
            if (ref == null) {
                return null;
            }
            Line line = (Line)ref.get();
            if (line == null) {
                return null;
            }
            if (line._expirationTime != 0L && System.currentTimeMillis() > line._expirationTime) {
                return null;
            }
            return line._object;
        }

        public synchronized void remove(Object key) {
            this._map.remove(key);
        }

        public static void clearAllInstances(Object key) {
            Iterator iterator = _instances.iterator();
            while (iterator.hasNext()) {
                ((WeakLRUHashMap)iterator.next()).remove(key);
            }
        }

        private static class LRUHashMap
        extends HashMap {
            private final int _maxSize;
            private LinkedListDirectAccess _LRUList;
            private String _unsupportedText = "This method is not implemented";

            public LRUHashMap(int maxSize) {
                this._maxSize = maxSize;
                this._LRUList = new LinkedListDirectAccess();
            }

            public synchronized void xclear() {
                super.clear();
                this._LRUList.clear();
            }

            public void clear() {
                super.clear();
                this._LRUList.clear();
            }

            public Object get(Object key) {
                LRUMapEntry mapEntry = (LRUMapEntry)super.get(key);
                if (mapEntry == null) {
                    return null;
                }
                LRUHashMap lRUHashMap = this;
                synchronized (lRUHashMap) {
                    this._LRUList.moveToFront(mapEntry.LRUEntry);
                }
                return mapEntry.value;
            }

            public synchronized Object put(Object key, Object value) {
                if (super.containsKey(key)) {
                    LRUMapEntry mapEntry = (LRUMapEntry)super.get(key);
                    mapEntry.value = value;
                    this._LRUList.moveToFront(mapEntry.LRUEntry);
                    LRUMapEntry oldEntry = super.put(key, mapEntry);
                    return oldEntry == null ? null : oldEntry.value;
                }
                if (super.size() == this._maxSize) {
                    Object lastKey = this._LRUList.removeLast();
                    super.remove(lastKey);
                }
                LRUMapEntry newEntry = new LRUMapEntry();
                newEntry.value = value;
                newEntry.LRUEntry = this._LRUList.addFirst(key);
                super.put(key, newEntry);
                return null;
            }

            public Object remove(Object key) {
                if (super.containsKey(key)) {
                    LRUMapEntry entry = (LRUMapEntry)super.get(key);
                    super.remove(key);
                    this._LRUList.remove(entry.LRUEntry);
                    return entry.value;
                }
                return null;
            }

            public Object clone() throws UnsupportedOperationException {
                throw new UnsupportedOperationException(this._unsupportedText);
            }

            public boolean containsValue(Object value) throws UnsupportedOperationException {
                throw new UnsupportedOperationException(this._unsupportedText);
            }

            public Set entrySet() throws UnsupportedOperationException {
                throw new UnsupportedOperationException(this._unsupportedText);
            }

            public void putAll(Map t) throws UnsupportedOperationException {
                throw new UnsupportedOperationException(this._unsupportedText);
            }

            public Collection values() throws UnsupportedOperationException {
                throw new UnsupportedOperationException(this._unsupportedText);
            }

            private static class LinkedListDirectAccess {
                private Entry header = new Entry(null, null, null);
                private int size = 0;

                public LinkedListDirectAccess() {
                    this.header.next = this.header.previous = this.header;
                }

                public Entry addFirst(Object o) {
                    return this.addBefore(o, this.header.next, null);
                }

                public Object getLast() {
                    if (this.size == 0) {
                        throw new NoSuchElementException();
                    }
                    return this.header.previous.element;
                }

                public Object removeLast() {
                    Object last = this.header.previous.element;
                    this.remove(this.header.previous);
                    return last;
                }

                public void moveToFront(Entry e) {
                    this.remove(e);
                    this.addBefore(e.element, this.header.next, e);
                }

                public void clear() {
                    this.header.next = this.header.previous = this.header;
                    this.size = 0;
                }

                public void remove(Entry e) {
                    if (e == this.header) {
                        throw new NoSuchElementException();
                    }
                    e.previous.next = e.next;
                    e.next.previous = e.previous;
                    --this.size;
                }

                private Entry addBefore(Object o, Entry e, Entry useThisEntry) {
                    Entry newEntry;
                    if (useThisEntry == null) {
                        newEntry = new Entry(o, e, e.previous);
                    } else {
                        newEntry = useThisEntry;
                        newEntry.element = o;
                        newEntry.next = e;
                        newEntry.previous = e.previous;
                    }
                    newEntry.previous.next = newEntry;
                    newEntry.next.previous = newEntry;
                    ++this.size;
                    return newEntry;
                }

                public boolean isEmpty() {
                    return this.size == 0;
                }

                public static class Entry {
                    public Object element;
                    public Entry next;
                    public Entry previous;

                    Entry(Object element, Entry next, Entry previous) {
                        this.element = element;
                        this.next = next;
                        this.previous = previous;
                    }
                }
            }

            private static class LRUMapEntry {
                public Object value;
                public LinkedListDirectAccess.Entry LRUEntry;

                private LRUMapEntry() {
                }
            }
        }

        private static class Line {
            public long _expirationTime;
            public Object _object;

            public Line(Object object, int secondsToLive) {
                this._expirationTime = secondsToLive != 0 ? System.currentTimeMillis() + 1000L * (long)secondsToLive : 0L;
                this._object = object;
            }
        }
    }

    protected static class LogUtil {
        static /* synthetic */ Class class$com$sap$security$core$persistence$datasource$imp$R3PersistenceBase;

        protected LogUtil() {
        }

        public static void exitMethodWithException(IUMTrace trace, String method, Throwable throwable) {
            trace.exiting(method, "Throwing: " + LogUtil.getStackTrace(throwable));
        }

        public static String getStackTrace(Throwable throwable) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            return stringWriter.toString();
        }

        public static void logEntering(IUMTrace trace, String method, Object[] args) {
            Object[] PARAMS_FOLLOW = new Object[]{"<Method parameters following>"};
            Object[] PARAMS_DEBUG = new Object[]{"<Method parameters shown in DEBUG level>"};
            if (trace.bePath()) {
                if (args == null) {
                    trace.entering(method);
                } else if (trace.beDebug()) {
                    trace.entering(method, PARAMS_FOLLOW);
                    trace.debugT(method, "[PARAMETERS]\n" + LogUtil.getObjectArrayString(args) + "[/PARAMETERS]");
                } else {
                    trace.entering(method, PARAMS_DEBUG);
                }
            }
        }

        public static void logEntering(IUMTrace trace, String method) {
            if (trace.bePath()) {
                LogUtil.logEntering(trace, method, null);
            }
        }

        public static void logExiting(IUMTrace trace, String method) {
            if (trace.bePath()) {
                LogUtil.logExiting(trace, method, null);
            }
        }

        public static void logExiting(IUMTrace trace, String method, Object result) {
            if (trace.bePath()) {
                LogUtil.logExiting(trace, method, result, null);
            }
        }

        public static void logExiting(IUMTrace trace, String method, Object[] args) {
            LogUtil.logExiting(trace, method, "<void>", args);
        }

        public static void logExiting(IUMTrace trace, String method, Object result, Object[] args) {
            if (trace.bePath()) {
                if (trace.beDebug()) {
                    if (args != null) {
                        trace.debugT(method, "[PARAMETERS AT END OF METHOD]\n" + LogUtil.getObjectArrayString(args) + "[/PARAMETERS AT END OF METHOD]");
                    }
                    if ("<void>".equals(result)) {
                        trace.debugT(method, "[RETURNING] <void>");
                    } else {
                        trace.debugT(method, "[RETURNING] " + LogUtil.getObjectString(result));
                    }
                } else if ("<void>".equals(result)) {
                    trace.debugT(method, "[RETURNING] <void>");
                } else {
                    trace.debugT(method, "[RETURNING] <Return value shown in DEBUG trace>");
                }
                trace.exiting(method);
            }
        }

        private static String getObjectString(Object o) {
            if (o == null) {
                return "<null>\n";
            }
            StringBuffer sb = new StringBuffer();
            Class<?> oClass = o.getClass();
            if (!oClass.isArray()) {
                String className = oClass.getName();
                className = className.substring(className.lastIndexOf(46) + 1);
                sb.append("Class \"" + className + "\"\n" + o + "\n");
            } else {
                String className = oClass.getComponentType().getName();
                className = className.substring(className.lastIndexOf(46) + 1);
                sb.append("Array of \"" + className + "\" with " + Array.getLength(o) + " elements\n");
                int i = 0;
                while (i < Array.getLength(o)) {
                    sb.append("[" + i + "]\n" + Array.get(o, i) + "\n");
                    ++i;
                }
            }
            return sb.toString();
        }

        private static String getObjectArrayString(Object[] args) {
            if (args == null) {
                return "<null>\n";
            }
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < args.length) {
                sb.append("Parameter " + i + ": ");
                sb.append(LogUtil.getObjectString(args[i]));
                ++i;
            }
            return sb.toString();
        }

        public static void logToUMTrace(IUMTrace trace, int severity, String message, Object[] args) {
            switch (severity) {
                case 3: 
                case 4: 
                case 5: {
                    trace.logInfoT(message, args);
                    break;
                }
                case 2: {
                    trace.logWarningT(message, args);
                    break;
                }
                case 1: {
                    trace.logErrorT(message, args);
                    break;
                }
                case 0: {
                    trace.logFatalT(message, args);
                    break;
                }
                default: {
                    trace.logErrorT(message, args);
                }
            }
        }

        public static void logThrowable(int severity, IUMTrace trace, String method, String message, Object[] args, Throwable t) {
            int severityAPI;
            switch (severity) {
                case 3: {
                    severityAPI = 300;
                    break;
                }
                case 2: {
                    severityAPI = 400;
                    break;
                }
                case 1: {
                    severityAPI = 500;
                    break;
                }
                case 0: {
                    severityAPI = 600;
                    break;
                }
                default: {
                    severityAPI = 500;
                }
            }
            Category CATEGORY = Category.getCategory((Category)Category.SYS_SECURITY, (String)"Usermanagement");
            Location LOCATION = Location.getLocation((Class)(class$com$sap$security$core$persistence$datasource$imp$R3PersistenceBase == null ? (class$com$sap$security$core$persistence$datasource$imp$R3PersistenceBase = LogUtil.class$("com.sap.security.core.persistence.datasource.imp.R3PersistenceBase")) : class$com$sap$security$core$persistence$datasource$imp$R3PersistenceBase));
            CATEGORY.logThrowable(severityAPI, LOCATION, method, (Object)message, args, message, t);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    protected static class SapUidFormatException
    extends Exception {
        SapUidFormatException() {
        }

        SapUidFormatException(String message) {
            super(message);
        }
    }

    protected static class Util {
        private static final int SAP_UID_MINLEN = 1;
        private static final int SAP_UID_MAXLEN = 12;
        static /* synthetic */ Class class$com$sap$security$core$persistence$datasource$imp$R3Persistence;

        protected Util() {
        }

        public static boolean isSapUidLength(String sapUid) {
            return null != sapUid && sapUid.length() >= 1 && sapUid.length() <= 12;
        }

        public static void assertSapUidLength(String sapUid) throws SapUidFormatException {
            if (!Util.isSapUidLength(sapUid)) {
                throw new SapUidFormatException("Not a valid SAP user ID: \"" + sapUid + "\". " + "Reason: SAP user ID must contain at least " + 1 + " and at most " + 12 + " characters");
            }
        }

        public static boolean isSapUidCapitals(String sapUid) {
            return null != sapUid && sapUid.equals(Util.charWiseUpperCase(sapUid));
        }

        public static void assertSapUidCapitals(String sapUid) throws SapUidFormatException {
            if (!Util.isSapUidCapitals(sapUid)) {
                throw new SapUidFormatException("Not a valid SAP user ID: \"" + sapUid + "\". " + "Reason: SAP user ID " + "must not contain lowercase letters");
            }
        }

        public static void assertSapUidFormat(String sapUid) throws SapUidFormatException {
            Util.assertSapUidLength(sapUid);
            Util.assertSapUidCapitals(sapUid);
        }

        public static void populateEmptyIfNeeded(IInternalPrincipalDatabag principal, String attribute) throws Exception {
            IPersistenceCollection values = R3PersistenceBase.toPersistenceCollection(principal.getAttributeValues("com.sap.security.core.usermanagement", attribute));
            if (null == values) {
                principal.setAttributeValues("com.sap.security.core.usermanagement", attribute, new PersistenceCollection().toVector());
            }
        }

        public static void populateEmptyIfNeeded(IInternalPrincipalDatabag principal, String nameSpace, String attribute) throws Exception {
            IPersistenceCollection values = R3PersistenceBase.toPersistenceCollection(principal.getAttributeValues(nameSpace, attribute));
            if (null == values) {
                principal.setAttributeValues(nameSpace, attribute, new PersistenceCollection().toVector());
            }
        }

        public static String[] getLocaleParts(String strLocale) {
            String[] localeParts = new String[]{"", "", null};
            int len = strLocale.length();
            StringBuffer part = new StringBuffer();
            int partsIndex = 0;
            int i = 0;
            while (i < len) {
                char c = strLocale.charAt(i);
                if (partsIndex < 2 && '_' == c) {
                    localeParts[partsIndex++] = part.toString();
                    part.delete(0, part.length());
                } else {
                    part.append(c);
                }
                ++i;
            }
            if (part.length() > 0) {
                localeParts[partsIndex] = part.toString();
            }
            return localeParts;
        }

        public static void toCanonicalForm(Map databag) throws Exception {
            Iterator iter = databag.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Object value = entry.getValue();
                if (null == value) {
                    entry.setValue("");
                    continue;
                }
                if (value instanceof String) continue;
                throw new PersistenceException("Unexpected data type: " + (value != null ? value.getClass().getName() : "null") + ". Values of attribute " + "com.sap.security.core.usermanagement" + "|->" + entry.getKey() + " must have type String" + " if any datasource of class " + (class$com$sap$security$core$persistence$datasource$imp$R3Persistence == null ? (class$com$sap$security$core$persistence$datasource$imp$R3Persistence = Util.class$("com.sap.security.core.persistence.datasource.imp.R3Persistence")) : class$com$sap$security$core$persistence$datasource$imp$R3Persistence).getName() + " is responsible for writing them.");
            }
        }

        public static int getMessageSeverity(String msgType) {
            int severity;
            if (1 == msgType.length()) {
                switch (msgType.charAt(0)) {
                    case 'A': 
                    case 'X': {
                        severity = 0;
                        break;
                    }
                    case 'E': {
                        severity = 1;
                        break;
                    }
                    case 'W': {
                        severity = 2;
                        break;
                    }
                    case 'I': 
                    case 'S': {
                        severity = 3;
                        break;
                    }
                    default: {
                        LOG_STATIC.logErrorT("Received unknown ABAP message type {0} from backend", new Object[]{msgType});
                        severity = 1;
                        break;
                    }
                }
            } else {
                LOG_STATIC.logErrorT("Received unknown ABAP message type {0} from backend", new Object[]{msgType});
                severity = 1;
            }
            return severity;
        }

        public static String charWiseUpperCase(String in) throws NullPointerException {
            if (null == in) {
                return null;
            }
            StringBuffer out = new StringBuffer(in.length());
            char[] inChars = in.toCharArray();
            int i = 0;
            while (i < inChars.length) {
                out.append(Character.toUpperCase(inChars[i]));
                ++i;
            }
            return out.toString();
        }

        public static String trimTrailing(String in) {
            if (in == null) {
                return null;
            }
            int len = in.length();
            int endPos = 0;
            int i = len - 1;
            while (i >= 0) {
                if (in.charAt(i) != ' ') {
                    endPos = i + 1;
                    break;
                }
                --i;
            }
            return in.substring(0, endPos);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    protected static class PoolMapEntry {
        public R3JCoProxy backendProxy;
        public String systemID;
        public String communicationUser;

        protected PoolMapEntry() {
        }
    }
}

