/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.FeatureNotAvailableException;
import com.sap.security.api.ISearchAttribute;
import com.sap.security.api.UMFactory;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.IInternalPrincipalDatabag;
import com.sap.security.core.persistence.IInternalPrincipalDatabagMaint;
import com.sap.security.core.persistence.IPrincipalDatabag;
import com.sap.security.core.persistence.datasource.IDataSourceTransaction;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.datasource.imp.DSConfigurationModel;
import com.sap.security.core.persistence.datasource.imp.DSPrincipalModel;
import com.sap.security.core.persistence.datasource.imp.R3JCoProxy;
import com.sap.security.core.persistence.datasource.imp.R3Persistence;
import com.sap.security.core.persistence.datasource.imp.R3PersistenceBase;
import com.sap.security.core.util.IUMTrace;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class R3Persistence
extends R3PersistenceBase {
    private static final IUMTrace LOG = InternalUMFactory.getTrace((class$com$sap$security$core$persistence$datasource$imp$R3Persistence == null ? (class$com$sap$security$core$persistence$datasource$imp$R3Persistence = R3Persistence.class$("com.sap.security.core.persistence.datasource.imp.R3Persistence")) : class$com$sap$security$core$persistence$datasource$imp$R3Persistence).getName());
    public static final String PROPERTY_MAPPING_USREXTID = "PROPERTY_MAPPING_USREXTID";
    private static final String TIMEZONE_MAPPING = "timezone.properties";
    private static final Map HASH_JAVA_TZ = new HashMap();
    private static final Map HASH_SAP_TZ = new HashMap();
    private static boolean _isTimeZoneMappingInitialized = false;
    private static final String LANGUAGE_MAPPING_FILE = "R3PersistenceLanguageMapping.properties";
    private static Properties LANGUAGE_SAP_TO_ISO;
    private static boolean _isLanguageMappingInitialized;
    private static final String EXISTENCE_CONFIRMED_MSGNO = "088";
    private static final String SUSR_LOGIN_CHECK_RFC = "SUSR_LOGIN_CHECK_RFC";
    private static final String SUSR_CHECK_LOGON_DATA = "SUSR_CHECK_LOGON_DATA";
    private static final String BAPI_USER_GETLIST = "BAPI_USER_GETLIST";
    private static final String PRGN_J2EE_TELNO_CONVERT = "PRGN_J2EE_TELNO_CONVERT";
    private static final String SUSR_GET_USREXTID_MAPPING_LIST = "SUSR_GET_USREXTID_MAPPING_LIST";
    private R3JCoProxy.FunctionTemplate _susrLoginCheckRfc = null;
    private R3JCoProxy.FunctionTemplate _susrCheckLogonData = null;
    private R3JCoProxy.FunctionTemplate _bapiUserGetlist = null;
    private R3JCoProxy.FunctionTemplate _prgnJ2EETelnoConvert = null;
    private R3JCoProxy.FunctionTemplate _susrGetUsrextidMappingList = null;
    private static final String LOCKED_ADMIN;
    private static final String LOCKED_AUTO;
    private static final String LOCKED_NO;
    private static final String BAPIADTEL_CONSNUMBER = "CONSNUMBER";
    private static final String BAPIADTEL_R_3_USER = "R_3_USER";
    private static final String BAPIADTEL_STD_NO = "STD_NO";
    private static final String BAPIADTEL_HOME_FLAG = "HOME_FLAG";
    private static final String BAPIADTEL_COUNTRY = "COUNTRY";
    private static final String BAPIADTEL_TELEPHONE = "TELEPHONE";
    private static final String BAPIADTEL_EXTENSION = "EXTENSION";
    private static final String BAPIADFAX_FAX = "FAX";
    private static final String R3USER_PHONE_DEFAULT = "1";
    private static final String R3USER_PHONE = "";
    private static final String R3USER_MOBILE_DEFAULT = "3";
    private static final String R3USER_MOBILE = "2";
    private boolean _newLockAndOutOfValidityBehavior = false;
    private int BUFFER_SIZE = 50;
    private int BUFFER_TIME_SECS = 15;
    private R3PersistenceBase.WeakLRUHashMap _susrLoginCheckRfcCache = new R3PersistenceBase.WeakLRUHashMap(this.BUFFER_SIZE, this.BUFFER_TIME_SECS);
    private R3PersistenceBase.WeakLRUHashMap _bapiUserGetDetailCache = new R3PersistenceBase.WeakLRUHashMap(this.BUFFER_SIZE, this.BUFFER_TIME_SECS);
    private R3PersistenceBase.WeakLRUHashMap _bapiUserExistenceCheckCache = new R3PersistenceBase.WeakLRUHashMap(this.BUFFER_SIZE, this.BUFFER_TIME_SECS);
    private R3PersistenceBase.WeakLRUHashMap _phoneNumberExtBuffer = new R3PersistenceBase.WeakLRUHashMap(100, 60);
    private R3PersistenceBase.WeakLRUHashMap _phoneNumberIntBuffer = new R3PersistenceBase.WeakLRUHashMap(100, 60);
    private static final String PHONE_CONVERT_CLASSIC = "ume.r3.user.phone_convert_classic";
    private boolean _phoneConvertClassic = false;
    private IMappingWithUSREXTID _mappingUSREXTID;
    private final String AbstractUserAccount_IS_PASSWORD_DISABLED = "ispassworddisabled";
    static ArrayList _instances;
    static /* synthetic */ Class class$com$sap$security$core$persistence$datasource$imp$R3Persistence;

    public R3Persistence() {
        this.LOG_BASE = LOG;
        ATSInterface atsInterface = new ATSInterface();
        _instances.add(atsInterface);
    }

    protected void localInitialization(DSConfigurationModel dsConf) throws Exception {
        String METHOD = "localInitialization()";
        this.doInitRfc(dsConf, null);
        try {
            this._phoneConvertClassic = dsConf.getPrivateAttributeBooleanValue(PHONE_CONVERT_CLASSIC);
        }
        catch (Exception e) {
            this._phoneConvertClassic = false;
        }
        R3Persistence.doInitTimeZone();
        R3Persistence.doInitLanguageMapping();
        this._susrCheckLogonData = this._backendProxy.getRepository().getFunctionTemplate(SUSR_CHECK_LOGON_DATA);
        if (this._susrCheckLogonData != null) {
            LOG.debugT("localInitialization()", "SUSR_CHECK_LOGON_DATA found in backend system");
        }
        if (this._susrCheckLogonData != null) {
            if (this._susrCheckLogonData.getFunction().getImportParameterList().hasField("USE_NEW_EXCEPTION")) {
                this._newLockAndOutOfValidityBehavior = true;
                LOG.debugT("localInitialization()", "USE_NEW_EXCEPTION parameter found");
            }
        } else {
            this._susrLoginCheckRfc = this._backendProxy.getRepository().getFunctionTemplate(SUSR_LOGIN_CHECK_RFC);
            if (this._susrLoginCheckRfc != null) {
                if (this._susrLoginCheckRfc.getFunction().getImportParameterList().hasField("USE_NEW_EXCEPTION")) {
                    this._newLockAndOutOfValidityBehavior = true;
                    LOG.debugT("localInitialization()", "USE_NEW_EXCEPTION parameter found");
                }
            } else {
                throw new PersistenceException("Unable to access either SUSR_CHECK_LOGON_DATA or SUSR_LOGIN_CHECK_RFC. R/3 user management requires at least basis release 4.6C");
            }
        }
        this._bapiUserGetlist = this._backendProxy.getRepository().getFunctionTemplate(BAPI_USER_GETLIST);
        if (this._bapiUserGetlist != null) {
            LOG.debugT("localInitialization()", "BAPI_USER_GETLIST found in backend system");
        }
        this._prgnJ2EETelnoConvert = this._backendProxy.getRepository().getFunctionTemplate(PRGN_J2EE_TELNO_CONVERT);
        if (this._prgnJ2EETelnoConvert != null) {
            LOG.debugT("localInitialization()", "PRGN_J2EE_TELNO_CONVERT found in backend system");
        }
        this._susrGetUsrextidMappingList = this._backendProxy.getRepository().getFunctionTemplate(SUSR_GET_USREXTID_MAPPING_LIST);
        if (this._susrGetUsrextidMappingList != null) {
            LOG.debugT("localInitialization()", "SUSR_GET_USREXTID_MAPPING_LIST found in backend system (RFC-callable status not checked yet)");
        }
        this._mappingUSREXTID = new IMappingWithUSREXTID(){

            public String[] getUserNamesForExtID(String extIDType, String extID) throws PersistenceException {
                return R3Persistence.this.getUserNamesForExtID(extIDType, extID);
            }

            public String getLogicalSystem() {
                return R3Persistence.this._systemId;
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void populatePrincipalDatabag(IInternalPrincipalDatabag principal, AttributeList populateAttributes) throws PersistenceException {
        block21: {
            block20: {
                block19: {
                    block18: {
                        String METHOD = "populatePrincipalDatabag(AttributeList)";
                        try {
                            try {
                                Vector attributes;
                                String attr;
                                String ns;
                                Hashtable<String, Vector> nameSpaces;
                                R3PersistenceBase.LogUtil.logEntering(LOG, "populatePrincipalDatabag(AttributeList)", new Object[]{principal, populateAttributes});
                                this.assertInitialization();
                                if (!this.isHomeForPrincipalDatabag(principal)) {
                                    LOG.debugT("populatePrincipalDatabag(AttributeList)", "Not home datasource of " + principal.getUniqueID());
                                    Object var16_4 = null;
                                    break block18;
                                }
                                String[] idParts = principal.getIDParts();
                                String principalType = idParts[0];
                                String uniqueName = idParts[2];
                                if (!this.mConfigurationModel.feelsResponsible(principalType)) {
                                    LOG.debugT("populatePrincipalDatabag(AttributeList)", "Not responsible to populate any attributes of " + principalType + " principals");
                                    break block19;
                                }
                                if (R3Persistence.isComputablePopulation(populateAttributes, principalType)) {
                                    nameSpaces = new Hashtable<String, Vector>(1, 1.0f);
                                    LOG.debugT("populatePrincipalDatabag(AttributeList)", "Computable population: Populating only requested attributes");
                                } else {
                                    nameSpaces = this.mConfigurationModel.getPopulateInitially(principalType);
                                    LOG.debugT("populatePrincipalDatabag(AttributeList)", "Non-computable population: Populating union of requested attributes and attributes configured for initial population");
                                }
                                if (null != populateAttributes) {
                                    int numPopAttrs = populateAttributes.getSize();
                                    int i = 0;
                                    while (i < numPopAttrs) {
                                        ns = populateAttributes.getNameSpaceOfAttributeAt(i);
                                        if (this.feelsResponsible(principalType, ns, attr = populateAttributes.getAttributeNameOfAttributeAt(i))) {
                                            attributes = (Vector)nameSpaces.get(ns);
                                            if (null == attributes) {
                                                attributes = new Vector(numPopAttrs);
                                                nameSpaces.put(ns, attributes);
                                            }
                                            attributes.add(attr);
                                        }
                                        ++i;
                                    }
                                }
                                if (nameSpaces.isEmpty()) {
                                    LOG.debugT("populatePrincipalDatabag(AttributeList)", "Namespace table empty: Not responsible to populate any attributes");
                                    break block20;
                                }
                                R3JCoProxy.Client client = this._backendProxy.getClient();
                                try {
                                    this.doDispatchRead(client, uniqueName, principalType, null, nameSpaces, principal);
                                    Object var14_21 = null;
                                    this._backendProxy.releaseClient(client);
                                }
                                catch (Throwable throwable) {
                                    Object var14_22 = null;
                                    this._backendProxy.releaseClient(client);
                                    throw throwable;
                                }
                                Enumeration ens = nameSpaces.keys();
                                while (ens.hasMoreElements()) {
                                    ns = (String)ens.nextElement();
                                    attributes = (Vector)nameSpaces.get(ns);
                                    if (null == attributes) continue;
                                    int i = 0;
                                    while (i < attributes.size()) {
                                        attr = (String)attributes.elementAt(i);
                                        R3PersistenceBase.Util.populateEmptyIfNeeded(principal, ns, attr);
                                        ++i;
                                    }
                                }
                                break block21;
                            }
                            catch (Exception e) {
                                PersistenceException pe = this.newPersistenceException(LOG, "populatePrincipalDatabag(AttributeList)", e);
                                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "populatePrincipalDatabag(AttributeList)", (Throwable)((Object)pe));
                                throw pe;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var16_8 = null;
                            R3PersistenceBase.LogUtil.logExiting(LOG, "populatePrincipalDatabag(AttributeList)", new Object[]{principal});
                            throw throwable;
                        }
                    }
                    R3PersistenceBase.LogUtil.logExiting(LOG, "populatePrincipalDatabag(AttributeList)", new Object[]{principal});
                    return;
                }
                Object var16_5 = null;
                R3PersistenceBase.LogUtil.logExiting(LOG, "populatePrincipalDatabag(AttributeList)", new Object[]{principal});
                return;
            }
            Object var16_6 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "populatePrincipalDatabag(AttributeList)", new Object[]{principal});
            return;
        }
        Object var16_7 = null;
        R3PersistenceBase.LogUtil.logExiting(LOG, "populatePrincipalDatabag(AttributeList)", new Object[]{principal});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean populatePrincipalDatabag(IInternalPrincipalDatabag principal, String nameSpace, String attribute) throws PersistenceException {
        boolean bl;
        String METHOD = "populatePrincipalDatabag(String,String)";
        boolean responsibleForInstance = false;
        try {
            try {
                R3PersistenceBase.LogUtil.logEntering(LOG, "populatePrincipalDatabag(String,String)", new Object[]{principal, nameSpace, attribute});
                this.assertInitialization();
                String[] idParts = principal.getIDParts();
                String principalType = idParts[0];
                String uniqueName = idParts[2];
                boolean bl2 = responsibleForInstance = this.isHomeForPrincipalDatabag(principal) && this.mConfigurationModel.feelsResponsible(principalType);
                if (responsibleForInstance) {
                    Vector<String> attributes = new Vector<String>(1);
                    attributes.add(attribute);
                    R3JCoProxy.Client client = this._backendProxy.getClient();
                    try {
                        this.doDispatchRead(client, uniqueName, principalType, attributes, null, principal);
                        Object var12_14 = null;
                        this._backendProxy.releaseClient(client);
                    }
                    catch (Throwable throwable) {
                        Object var12_15 = null;
                        this._backendProxy.releaseClient(client);
                        throw throwable;
                    }
                    R3PersistenceBase.Util.populateEmptyIfNeeded(principal, nameSpace, attribute);
                } else {
                    LOG.debugT("populatePrincipalDatabag(String,String)", "Not responsible for principal " + principal.getUniqueID());
                }
                bl = responsibleForInstance;
                Object var14_17 = null;
            }
            catch (Exception e) {
                PersistenceException pe = this.newPersistenceException(LOG, "populatePrincipalDatabag(String,String)", e);
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "populatePrincipalDatabag(String,String)", (Throwable)((Object)pe));
                throw pe;
            }
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "populatePrincipalDatabag(String,String)", new Boolean(responsibleForInstance), new Object[]{principal});
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "populatePrincipalDatabag(String,String)", new Boolean(responsibleForInstance), new Object[]{principal});
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IDataSourceTransaction beginTransaction() throws PersistenceException {
        R3PersistenceTransaction r3PersistenceTransaction;
        String METHOD = "beginTransaction()";
        R3PersistenceTransaction result = null;
        try {
            try {
                R3PersistenceBase.LogUtil.logEntering(LOG, "beginTransaction()");
                this.assertInitialization();
                r3PersistenceTransaction = result = new R3PersistenceTransaction();
                Object var6_5 = null;
            }
            catch (Exception e) {
                PersistenceException pe = this.newPersistenceException(LOG, "beginTransaction()", e);
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "beginTransaction()", (Throwable)((Object)pe));
                throw pe;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "beginTransaction()", new Object[]{result});
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "beginTransaction()", new Object[]{result});
        return r3PersistenceTransaction;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean principalDatabagExists(IPrincipalDatabag principal) throws PersistenceException {
        boolean uniqueName2;
        String METHOD = "principalDatabagExists()";
        boolean homeForAndExists = false;
        try {
            try {
                R3PersistenceBase.LogUtil.logEntering(LOG, "principalDatabagExists()", new Object[]{principal});
                this.assertInitialization();
                if (this.isHomeForPrincipalDatabag((IInternalPrincipalDatabag)principal)) {
                    LOG.debugT("principalDatabagExists()", "Home for " + principal.getUniqueID());
                    String uniqueName2 = principal.getIDParts()[2];
                    R3JCoProxy.Client client = this._backendProxy.getClient();
                    try {
                        homeForAndExists = this.doBapiUserExistenceCheck(client, uniqueName2);
                        Object var7_9 = null;
                        this._backendProxy.releaseClient(client);
                    }
                    catch (Throwable throwable) {
                        Object var7_10 = null;
                        this._backendProxy.releaseClient(client);
                        throw throwable;
                    }
                } else {
                    LOG.debugT("principalDatabagExists()", "Not home for " + principal.getUniqueID());
                }
                uniqueName2 = homeForAndExists;
                Object var9_12 = null;
            }
            catch (Exception e) {
                PersistenceException pe = this.newPersistenceException(LOG, "principalDatabagExists()", e);
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "principalDatabagExists()", (Throwable)((Object)pe));
                throw pe;
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "principalDatabagExists()", new Boolean(homeForAndExists));
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "principalDatabagExists()", new Boolean(homeForAndExists));
        return uniqueName2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public R3PersistenceBase.IPersistenceCollection searchPrincipalDatabags(R3PersistenceBase.ISearchCriteria criteria) throws PersistenceException {
        R3PersistenceBase.IPersistenceCollection iPersistenceCollection;
        String METHOD = "searchPrincipalDatabags()";
        R3PersistenceBase.IPersistenceCollection result = null;
        try {
            try {
                int actualResults;
                R3PersistenceBase.LogUtil.logEntering(LOG, "searchPrincipalDatabags()", new Object[]{criteria});
                this.assertInitialization();
                String principalType = criteria.getPrincipalType();
                List responsibleSearches = this.getResponsibleSearches(criteria);
                int numResponsibleSearches = responsibleSearches.size();
                int maxResults = criteria.getSearchSizeLimit();
                if (numResponsibleSearches == 1) {
                    ISearchAttribute search = (ISearchAttribute)responsibleSearches.get(0);
                    result = R3Persistence.isComputableSearch(search, principalType) ? this.getComputableSearchResult(search, principalType) : (R3Persistence.isExistenceCheck(search, principalType) ? this.getExistenceCheckResult(search, principalType) : this.getPersistentSearchResult(responsibleSearches, principalType, maxResults));
                } else if (!criteria.isOrMode()) {
                    result = this.getPersistentSearchResult(responsibleSearches, principalType, maxResults);
                } else {
                    Iterator iter = responsibleSearches.iterator();
                    R3PersistenceBase.IPersistenceCollection[] resultsPerQuery = new R3PersistenceBase.PersistenceCollection[numResponsibleSearches];
                    int resultIndex = 0;
                    ArrayList<ISearchAttribute> listWithOneEntry = new ArrayList<ISearchAttribute>(1);
                    listWithOneEntry.add(null);
                    while (true) {
                        block18: {
                            if (!iter.hasNext()) {
                                result = this.buildUnion(resultsPerQuery);
                                break;
                            }
                            ISearchAttribute nextSearch = (ISearchAttribute)iter.next();
                            try {
                                if (R3Persistence.isComputableSearch(nextSearch, principalType)) {
                                    resultsPerQuery[resultIndex] = this.getComputableSearchResult(nextSearch, principalType);
                                    break block18;
                                }
                                if (R3Persistence.isExistenceCheck(nextSearch, principalType)) {
                                    resultsPerQuery[resultIndex] = this.getExistenceCheckResult(nextSearch, principalType);
                                } else {
                                    listWithOneEntry.set(0, nextSearch);
                                    resultsPerQuery[resultIndex] = this.getPersistentSearchResult(listWithOneEntry, principalType, maxResults);
                                }
                            }
                            catch (Exception e) {
                                LOG.logWarningT("Search in the backend resulted in an exception. The search result returned to the application might be incomplete. Reason: {0}.", new Object[]{e.getMessage() != null ? e.getMessage() : e.getLocalizedMessage()});
                                criteria.errorOccurred(1);
                                resultsPerQuery[resultIndex] = new R3PersistenceBase.PersistenceCollection();
                            }
                        }
                        ++resultIndex;
                    }
                }
                int n = actualResults = result != null ? result.size() : 0;
                if (maxResults > 0 && actualResults > maxResults) {
                    LOG.debugT("searchPrincipalDatabags()", "Discarding " + (actualResults - maxResults) + " search results");
                    R3PersistenceBase.PersistenceCollection newResult = new R3PersistenceBase.PersistenceCollection(maxResults);
                    Iterator it = result.iterator();
                    int i = 0;
                    while (true) {
                        if (i >= maxResults) {
                            result = newResult;
                            criteria.errorOccurred(4);
                            break;
                        }
                        newResult.add(it.next());
                        ++i;
                    }
                }
                iPersistenceCollection = result;
                Object var15_19 = null;
            }
            catch (Exception e) {
                PersistenceException pe = this.newPersistenceException(LOG, "searchPrincipalDatabags()", e);
                LOG.logWarningT("Search in the backend resulted in an exception. The search result returned to the application might be incomplete. Reason: {0}.", new Object[]{e.getMessage() != null ? e.getMessage() : e.getLocalizedMessage()});
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "searchPrincipalDatabags()", (Throwable)((Object)pe));
                throw pe;
            }
        }
        catch (Throwable throwable) {
            Object var15_20 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "searchPrincipalDatabags()", result);
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "searchPrincipalDatabags()", result);
        return iPersistenceCollection;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkCredentials(R3PersistenceBase.IPersistenceMap credentials) throws PersistenceException {
        block40: {
            block37: {
                block36: {
                    block35: {
                        METHOD = "checkCredentials()";
                        result = false;
                        try {
                            try {
                                block39: {
                                    R3PersistenceBase.LogUtil.logEntering(R3Persistence.LOG, "checkCredentials()");
                                    this.assertInitialization();
                                    dsToSearch = (String[])credentials.get("dataSourceIDs");
                                    if (dsToSearch != null) {
                                        found = false;
                                        i = 0;
                                        while (i < dsToSearch.length) {
                                            if (this.getId().equals(dsToSearch[i])) {
                                                found = true;
                                                break;
                                            }
                                            ++i;
                                        }
                                        if (!found) {
                                            R3Persistence.LOG.debugT("checkCredentials()", "This datasource is not in the list of datasources. Exiting.");
                                            var7_11 = result = false;
                                            var20_16 = null;
                                            break block35;
                                        }
                                    }
                                    userID = (String)credentials.get("j_user");
                                    password = (String)credentials.get("j_password");
                                    if (userID == null || password == null || "".equals(password.trim())) {
                                        R3Persistence.LOG.debugT("checkCredentials()", "Credential check in R/3 data source called with user or password initial");
                                        var7_12 = result = false;
                                        break block36;
                                    }
                                    if (this._communicationUser.equals(userID = R3PersistenceBase.Util.charWiseUpperCase(userID))) {
                                        R3Persistence.LOG.logErrorT("User \"{0}\" is the communication user for the connection between User Management Engine and the ABAP backend system {1}. This user cannot log-on to the User Management Engine.", new Object[]{userID, this._systemId});
                                        var7_13 = result = false;
                                        break block37;
                                    }
                                    if (this._susrCheckLogonData != null) {
                                        block38: {
                                            R3Persistence.LOG.debugT("checkCredentials()", "Using SUSR_CHECK_LOGON_DATA");
                                            f = this._susrCheckLogonData.getFunction();
                                            imp = f.getImportParameterList();
                                            imp.setValue("P", "AUTH_METHOD");
                                            imp.setValue(userID, "USERID");
                                            imp.setValue(password, "PASSWORD");
                                            if (this._newLockAndOutOfValidityBehavior) {
                                                R3Persistence.LOG.debugT("checkCredentials()", "Activating new behavior with USE_NEW_EXCEPTION = 1");
                                                imp.setValue((byte)1, "USE_NEW_EXCEPTION");
                                            }
                                            exp = f.getExportParameterList();
                                            i = 0;
                                            while (true) {
                                                if (i >= exp.getFieldCount()) {
                                                    client = this._backendProxy.getClient();
                                                    ** try [egrp 2[TRYBLOCK] [1 : 382->559)] { 
lbl51:
                                                    // 1 sources

                                                    break;
                                                }
                                                exp.setActive(false, i);
                                                ++i;
                                            }
                                            {
                                                try {
                                                    client.execute(f);
                                                    result = true;
                                                }
                                                catch (R3JCoProxy.R3ABAPException abapExc) {
                                                    key = abapExc.getKey();
                                                    message = abapExc.getMessage();
                                                    if (message == null || message.trim().length() == 0) {
                                                        message = abapExc.getLocalizedMessage();
                                                    }
                                                    R3Persistence.LOG.debugT("checkCredentials()", "SUSR_CHECK_LOGON_DATA returns exception " + key + "(" + message + ")");
                                                    if ("USER_LOCKED".equals(key) && this._newLockAndOutOfValidityBehavior) {
                                                        R3Persistence.LOG.debugT("checkCredentials()", "New ABAP behavior --> credentials considered valid");
                                                        result = true;
                                                    } else if ("USER_OUTSIDE_VALIDITY".equals(key) && this._newLockAndOutOfValidityBehavior) {
                                                        R3Persistence.LOG.debugT("checkCredentials()", "New ABAP behavior --> credentials considered valid");
                                                        result = true;
                                                    } else {
                                                        result = false;
                                                    }
                                                    var16_32 = null;
                                                    this._backendProxy.releaseClient(client);
                                                    break block38;
                                                }
                                                var16_31 = null;
                                                this._backendProxy.releaseClient(client);
                                            }
lbl81:
                                            // 1 sources

                                            catch (Throwable var15_39) {
                                                var16_33 = null;
                                                this._backendProxy.releaseClient(client);
                                                throw var15_39;
                                            }
                                        }
                                        abapExc = result;
                                        var20_19 = null;
                                        R3PersistenceBase.LogUtil.logExiting(R3Persistence.LOG, "checkCredentials()", new Boolean(result));
                                        return abapExc;
                                    }
                                    R3Persistence.LOG.debugT("checkCredentials()", "Using SUSR_LOGIN_CHECK_RFC");
                                    f = this._susrLoginCheckRfc.getFunction();
                                    imp = f.getImportParameterList();
                                    imp.setValue(userID, "BNAME");
                                    imp.setValue(password, "PASSWORD");
                                    if (this._newLockAndOutOfValidityBehavior) {
                                        R3Persistence.LOG.debugT("checkCredentials()", "Activating new behavior with USE_NEW_EXCEPTION = 1");
                                        imp.setValue((byte)1, "USE_NEW_EXCEPTION");
                                    }
                                    client = this._backendProxy.getClient();
                                    try {
                                        try {
                                            client.execute(f);
                                            result = true;
                                        }
                                        catch (R3JCoProxy.R3ABAPException abapExc) {
                                            key = abapExc.getKey();
                                            message = abapExc.getMessage();
                                            if (message == null || message.trim().length() == 0) {
                                                message = abapExc.getLocalizedMessage();
                                            }
                                            R3Persistence.LOG.debugT("checkCredentials()", "SUSR_LOGIN_CHECK_RFC returns exception " + key + "(" + message + ")");
                                            if ("PASSWORD_EXPIRED".equals(key)) {
                                                result = true;
                                            } else if ("USER_LOCKED".equals(key) && this._newLockAndOutOfValidityBehavior) {
                                                R3Persistence.LOG.debugT("checkCredentials()", "New ABAP behavior --> credentials considered valid");
                                                result = true;
                                            } else if ("USER_NOT_ACTIVE".equals(key) && this._newLockAndOutOfValidityBehavior) {
                                                R3Persistence.LOG.debugT("checkCredentials()", "New ABAP behavior --> credentials considered valid");
                                                result = true;
                                            } else {
                                                result = false;
                                            }
                                            var18_41 = null;
                                            this._backendProxy.releaseClient(client);
                                            break block39;
                                        }
                                        var18_40 = null;
                                        this._backendProxy.releaseClient(client);
                                    }
                                    catch (Throwable var17_43) {
                                        var18_42 = null;
                                        this._backendProxy.releaseClient(client);
                                        throw var17_43;
                                    }
                                }
                                var10_28 = result;
                                break block40;
                            }
                            catch (Exception e) {
                                pe = this.newPersistenceException(R3Persistence.LOG, "checkCredentials()", e);
                                R3PersistenceBase.LogUtil.exitMethodWithException(R3Persistence.LOG, "checkCredentials()", e);
                                throw pe;
                            }
                        }
                        catch (Throwable var19_44) {
                            var20_21 = null;
                            R3PersistenceBase.LogUtil.logExiting(R3Persistence.LOG, "checkCredentials()", new Boolean(result));
                            throw var19_44;
                        }
                    }
                    R3PersistenceBase.LogUtil.logExiting(R3Persistence.LOG, "checkCredentials()", new Boolean(result));
                    return var7_11;
                }
                var20_17 = null;
                R3PersistenceBase.LogUtil.logExiting(R3Persistence.LOG, "checkCredentials()", new Boolean(result));
                return var7_12;
            }
            var20_18 = null;
            R3PersistenceBase.LogUtil.logExiting(R3Persistence.LOG, "checkCredentials()", new Boolean(result));
            return var7_13;
        }
        var20_20 = null;
        R3PersistenceBase.LogUtil.logExiting(R3Persistence.LOG, "checkCredentials()", new Boolean(result));
        return var10_28;
    }

    private void assertUserNameNotExcluded(String method, String userName) throws Exception {
        if (userName.equals(this._communicationUser) || "SAP*".equals(userName) || "DDIC".equals(userName) || "SAPSYS".equals(userName) || "SAPCPIC".equals(userName)) {
            LOG.logErrorT("User \"{0}\" cannot be create, updated or deleted by the Java User Management. Reason: This user is either the communication user used by the Java User Management itself, or it is a technical user of the backend system.", new Object[]{userName});
            throw new PersistenceException("User \"" + userName + "\" cannot be create, updated or deleted (either own " + "communication user or technical backend user).");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void deletePrincipalDatabag(IPrincipalDatabag principal) throws PersistenceException {
        block13: {
            block12: {
                block11: {
                    String METHOD = "deletePrincipalDatabag()";
                    try {
                        try {
                            R3PersistenceBase.LogUtil.logEntering(LOG, "deletePrincipalDatabag()", new Object[]{principal});
                            this.assertInitialization();
                            if (null == principal) {
                                Object var10_3 = null;
                                break block11;
                            }
                            if (!this.isHomeForPrincipalDatabag((IInternalPrincipalDatabag)principal)) {
                                LOG.debugT("deletePrincipalDatabag()", "Not home datasource of " + principal.getUniqueID());
                                break block12;
                            }
                            if (this.feelsResponsible(principal)) {
                                String[] idParts = principal.getIDParts();
                                String principalType = idParts[0];
                                String uniqueName = idParts[2];
                                this.assertUserNameNotExcluded("deletePrincipalDatabag()", uniqueName);
                                if ("UACC".equals(principalType)) {
                                    LOG.debugT("deletePrincipalDatabag()", "Ignoring deletion request for user account" + principal.getUniqueID() + " because in ABAP backend user and user account " + "are the same object. " + "User will be deleted when user object is deleted");
                                    break block13;
                                }
                                if (!"USER".equals(principalType)) throw new PersistenceException("Failed to delete principal " + principal.getUniqueID() + ". Reason: principal type " + principalType + " is not supported by this datasource");
                                LOG.debugT("deletePrincipalDatabag()", "Performing deletion of " + principal.getUniqueID());
                                R3JCoProxy.Client client = this._backendProxy.getClient();
                                try {
                                    this.doBapiUserDelete(client, uniqueName);
                                    Object var8_13 = null;
                                    this._backendProxy.releaseClient(client);
                                    break block13;
                                }
                                catch (Throwable throwable) {
                                    Object var8_14 = null;
                                    this._backendProxy.releaseClient(client);
                                    throw throwable;
                                }
                            }
                            LOG.debugT("deletePrincipalDatabag()", "Not home responsible for " + principal.getUniqueID());
                            break block13;
                        }
                        catch (Exception e) {
                            PersistenceException pe = this.newPersistenceException(LOG, "deletePrincipalDatabag()", e);
                            R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "deletePrincipalDatabag()", (Throwable)((Object)pe));
                            throw pe;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_6 = null;
                        R3PersistenceBase.LogUtil.logExiting(LOG, "deletePrincipalDatabag()");
                        throw throwable;
                    }
                }
                R3PersistenceBase.LogUtil.logExiting(LOG, "deletePrincipalDatabag()");
                return;
            }
            Object var10_4 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "deletePrincipalDatabag()");
            return;
        }
        Object var10_5 = null;
        R3PersistenceBase.LogUtil.logExiting(LOG, "deletePrincipalDatabag()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createPrincipalDatabag(IInternalPrincipalDatabag principal, IInternalPrincipalDatabag uacc) throws PersistenceException {
        block17: {
            block16: {
                block15: {
                    block14: {
                        String METHOD = "createPrincipalDatabag()";
                        try {
                            try {
                                R3PersistenceBase.LogUtil.logEntering(LOG, "createPrincipalDatabag()", new Object[]{principal, uacc});
                                this.assertInitialization();
                                if (principal.getUniqueID() == null) {
                                    throw new PersistenceException("Incoming databag not bound. Indicates program error.");
                                }
                                if (!this.isHomeForPrincipalDatabag(principal)) {
                                    LOG.debugT("createPrincipalDatabag()", "Not home datasource of " + principal.getUniqueID());
                                    Object var11_4 = null;
                                    break block14;
                                }
                                String principalType = principal.getIDParts()[0];
                                String uniqueName = principal.getIDParts()[2];
                                if (!this.mConfigurationModel.feelsResponsible(principalType)) {
                                    LOG.debugT("createPrincipalDatabag()", "Not responsible for creating " + principalType + " principals");
                                    break block15;
                                }
                                R3PersistenceBase.Util.assertSapUidFormat(uniqueName);
                                this.assertUserNameNotExcluded("createPrincipalDatabag()", uniqueName);
                                Map createValues = this.getCreateValues(principal);
                                if (uacc != null) {
                                    if (!"USER".equals(principalType)) {
                                        throw new PersistenceException("For combined user/account-creation, main principal " + principal.getUniqueID() + " must be of type " + "USER");
                                    }
                                    if (!"UACC".equals(uacc.getIDParts()[0])) {
                                        throw new PersistenceException("For combined user/account-creation, UACC principal " + uacc.getUniqueID() + " must be of type " + "UACC");
                                    }
                                    Map uaccValues = this.getCreateValues(uacc);
                                    createValues.putAll(uaccValues);
                                }
                                if (createValues.isEmpty()) {
                                    LOG.debugT("createPrincipalDatabag()", "Extracted no attributes for this datasource. Exiting.");
                                    break block16;
                                }
                                R3PersistenceBase.Util.toCanonicalForm(createValues);
                                R3JCoProxy.Client client = this._backendProxy.getClient();
                                try {
                                    this.doDispatchWrite(client, uniqueName, "UACC".equals(principalType), createValues);
                                    Object var9_15 = null;
                                    this._backendProxy.releaseClient(client);
                                    break block17;
                                }
                                catch (Throwable throwable) {
                                    Object var9_16 = null;
                                    this._backendProxy.releaseClient(client);
                                    throw throwable;
                                }
                            }
                            catch (Exception e) {
                                PersistenceException pe = this.newPersistenceException(LOG, "createPrincipalDatabag()", e);
                                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "createPrincipalDatabag()", (Throwable)((Object)pe));
                                throw pe;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var11_8 = null;
                            R3PersistenceBase.LogUtil.logExiting(LOG, "createPrincipalDatabag()");
                            throw throwable;
                        }
                    }
                    R3PersistenceBase.LogUtil.logExiting(LOG, "createPrincipalDatabag()");
                    return;
                }
                Object var11_5 = null;
                R3PersistenceBase.LogUtil.logExiting(LOG, "createPrincipalDatabag()");
                return;
            }
            Object var11_6 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "createPrincipalDatabag()");
            return;
        }
        Object var11_7 = null;
        R3PersistenceBase.LogUtil.logExiting(LOG, "createPrincipalDatabag()");
    }

    protected void updatePrincipalDatabag(IInternalPrincipalDatabagMaint principal) throws PersistenceException {
        String METHOD = "updatePrincipalDatabag()";
        try {
            block8: {
                try {
                    R3PersistenceBase.LogUtil.logEntering(LOG, "updatePrincipalDatabag()", new Object[]{principal});
                    this.assertInitialization();
                    String[] idParts = principal.getIDParts();
                    String principalType = idParts[0];
                    String uniqueName = idParts[2];
                    this.assertUserNameNotExcluded("updatePrincipalDatabag()", uniqueName);
                    if (this.mConfigurationModel.feelsResponsible(principalType)) {
                        R3JCoProxy.Client client = this._backendProxy.getClient();
                        try {
                            Map updateValues = this.getUpdateValues(principal, principalType, client);
                            if (!updateValues.isEmpty()) {
                                R3PersistenceBase.Util.toCanonicalForm(updateValues);
                                this.doDispatchWrite(client, uniqueName, true, updateValues);
                            }
                            Object var9_10 = null;
                            this._backendProxy.releaseClient(client);
                            break block8;
                        }
                        catch (Throwable throwable) {
                            Object var9_11 = null;
                            this._backendProxy.releaseClient(client);
                            throw throwable;
                        }
                    }
                    LOG.debugT("updatePrincipalDatabag()", "Not responsible for any attributes  of principal type " + principalType);
                }
                catch (Exception e) {
                    PersistenceException pe = this.newPersistenceException(LOG, "updatePrincipalDatabag()", e);
                    R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "updatePrincipalDatabag()", (Throwable)((Object)pe));
                    throw pe;
                }
            }
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "updatePrincipalDatabag()");
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "updatePrincipalDatabag()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public R3PersistenceBase.IPersistenceCollection getAllNamespaces(IPrincipalDatabag principal) throws PersistenceException {
        R3PersistenceBase.PersistenceCollection persistenceCollection;
        String METHOD = "getAttributeNamespaces()";
        R3PersistenceBase.PersistenceCollection result = null;
        try {
            try {
                R3PersistenceBase.LogUtil.logEntering(LOG, "getAttributeNamespaces()", new Object[]{principal});
                String type = principal.getIDParts()[0];
                if ("USER".equals(type) || "UACC".equals(type)) {
                    result = new R3PersistenceBase.PersistenceCollection(1);
                    result.add("com.sap.security.core.usermanagement");
                } else {
                    result = new R3PersistenceBase.PersistenceCollection();
                }
                persistenceCollection = result;
                Object var7_8 = null;
            }
            catch (Exception e) {
                PersistenceException pe = this.newPersistenceException(LOG, "getAttributeNamespaces()", e);
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "getAttributeNamespaces()", (Throwable)((Object)pe));
                throw pe;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "getAttributeNamespaces()", result);
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "getAttributeNamespaces()", result);
        return persistenceCollection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public R3PersistenceBase.IPersistenceCollection getAllAttributes(IPrincipalDatabag principal, String nameSpace) throws PersistenceException {
        R3PersistenceBase.PersistenceCollection i;
        String METHOD = "getAttributeNames()";
        R3PersistenceBase.PersistenceCollection result = null;
        String[] userAttributes = new String[]{"uniquename", "firstname", "lastname", "salutation", "title", "jobtitle", "department", "email", "telephone", "fax", "locale", "timezone", "referenceuser"};
        String[] accountAttributes = new String[]{"j_user", "userid", "validfrom", "validto", "islocked", "lockreason", "passwordchangerequired"};
        try {
            try {
                block12: {
                    block14: {
                        int i2;
                        R3PersistenceBase.LogUtil.logEntering(LOG, "getAttributeNames()", new Object[]{principal, nameSpace});
                        String type = principal.getIDParts()[0];
                        if (!"com.sap.security.core.usermanagement".equals(nameSpace)) break block14;
                        if ("USER".equals(type)) {
                            result = new R3PersistenceBase.PersistenceCollection(userAttributes.length);
                            i2 = 0;
                            while (i2 < userAttributes.length) {
                                if (this.feelsResponsible(type, nameSpace, userAttributes[i2])) {
                                    result.add(userAttributes[i2]);
                                }
                                ++i2;
                            }
                            break block12;
                        } else if ("UACC".equals(type)) {
                            result = new R3PersistenceBase.PersistenceCollection(accountAttributes.length);
                            i2 = 0;
                            while (i2 < accountAttributes.length) {
                                if (this.feelsResponsible(type, nameSpace, accountAttributes[i2])) {
                                    result.add(accountAttributes[i2]);
                                }
                                ++i2;
                            }
                            break block12;
                        } else {
                            result = new R3PersistenceBase.PersistenceCollection();
                        }
                        break block12;
                    }
                    result = new R3PersistenceBase.PersistenceCollection();
                }
                i = result;
                Object var10_12 = null;
            }
            catch (Exception e) {
                PersistenceException pe = this.newPersistenceException(LOG, "getAttributeNames()", e);
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "getAttributeNames()", (Throwable)((Object)pe));
                throw pe;
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "getAttributeNames()", result);
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "getAttributeNames()", result);
        return i;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getPrivateIDPart(IPrincipalDatabag principal) throws PersistenceException {
        String string;
        R3PersistenceBase.PrincipalDatabagWrapper principalX = new R3PersistenceBase.PrincipalDatabagWrapper(principal);
        String METHOD = "getPrivateIDPart()";
        String privateIDPart = null;
        try {
            try {
                R3PersistenceBase.LogUtil.logEntering(LOG, "getPrivateIDPart()", new Object[]{principal});
                this.assertInitialization();
                R3PersistenceBase.IPersistenceCollection attributeValues = principalX.getValues("com.sap.security.core.usermanagement", "uniquename");
                if (null == attributeValues || attributeValues.isEmpty()) {
                    attributeValues = principalX.getValues("com.sap.security.core.usermanagement", "j_user");
                }
                if (null == attributeValues) throw new PersistenceException("Cannot determine private ID part of " + principal + ". Reason: Neither " + "com.sap.security.core.usermanagement" + "|->" + "uniquename" + " nor " + "com.sap.security.core.usermanagement" + "|->" + "j_user" + " is set");
                if (attributeValues.isEmpty()) {
                    throw new PersistenceException("Cannot determine private ID part of " + principal + ". Reason: Neither " + "com.sap.security.core.usermanagement" + "|->" + "uniquename" + " nor " + "com.sap.security.core.usermanagement" + "|->" + "j_user" + " is set");
                }
                privateIDPart = R3PersistenceBase.Util.trimTrailing((String)attributeValues.getOnlyElement());
                R3PersistenceBase.Util.assertSapUidLength(privateIDPart);
                string = privateIDPart = R3PersistenceBase.Util.charWiseUpperCase(privateIDPart);
                Object var8_9 = null;
            }
            catch (Exception e) {
                PersistenceException pe = this.newPersistenceException(LOG, "getPrivateIDPart()", e);
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "getPrivateIDPart()", (Throwable)((Object)pe));
                throw pe;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "getPrivateIDPart()", privateIDPart);
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "getPrivateIDPart()", privateIDPart);
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List getResponsibleSearches(R3PersistenceBase.ISearchCriteria criteria) throws Exception {
        ArrayList<ISearchAttribute> arrayList;
        String METHOD = "getResponsibleSearches()";
        ArrayList<ISearchAttribute> responsibleSearches = null;
        try {
            try {
                R3PersistenceBase.LogUtil.logEntering(LOG, "getResponsibleSearches()", new Object[]{criteria});
                int numAttributes = criteria.getElementSize();
                responsibleSearches = new ArrayList<ISearchAttribute>(numAttributes);
                int i = 0;
                while (true) {
                    if (i >= numAttributes) {
                        arrayList = responsibleSearches;
                        Object var11_11 = null;
                        break;
                    }
                    ISearchAttribute searchAttribute = criteria.getAttribute(i);
                    String nameSpace = searchAttribute.getAttributeNameSpace();
                    String attribute = searchAttribute.getAttributeName();
                    if (!("com.sap.security.core.usermanagement".equals(nameSpace) && "PRINCIPAL_TYPE_ATTRIBUTE".equals(attribute) || !this.feelsResponsible(criteria.getPrincipalType(), nameSpace, attribute))) {
                        responsibleSearches.add(searchAttribute);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "getResponsibleSearches()", e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "getResponsibleSearches()", responsibleSearches);
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "getResponsibleSearches()", responsibleSearches);
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private R3PersistenceBase.IPersistenceCollection getExistenceCheckResult(ISearchAttribute searchAttribute, String principalType) throws Exception {
        R3PersistenceBase.PersistenceCollection persistenceCollection;
        String METHOD = "getExistenceCheckResult()";
        R3PersistenceBase.PersistenceCollection result = new R3PersistenceBase.PersistenceCollection();
        try {
            try {
                R3PersistenceBase.LogUtil.logEntering(LOG, "getExistenceCheckResult()", new Object[]{searchAttribute, principalType});
                String attributeName = searchAttribute.getAttributeName();
                String attributeValue = (String)searchAttribute.getAttributeValue();
                String dataSourceId = this.getId();
                StringBuffer uniqueId = new StringBuffer(5 + dataSourceId.length() + 1 + 12);
                String idForExistenceCheck = null;
                if ("j_user".equals(attributeName)) {
                    String logonId = R3PersistenceBase.Util.trimTrailing(R3PersistenceBase.Util.charWiseUpperCase(attributeValue));
                    if (R3PersistenceBase.Util.isSapUidLength(logonId)) {
                        uniqueId.append("UACC");
                        uniqueId.append(".");
                        uniqueId.append(dataSourceId);
                        uniqueId.append(".");
                        uniqueId.append(logonId);
                        idForExistenceCheck = logonId;
                    }
                } else {
                    if (!"uniquename".equals(attributeName)) throw new Exception("Search cannot be performed via existence check: " + searchAttribute);
                    String uniqueName = R3PersistenceBase.Util.trimTrailing(R3PersistenceBase.Util.charWiseUpperCase(attributeValue));
                    if (R3PersistenceBase.Util.isSapUidLength(uniqueName)) {
                        uniqueId.append("USER");
                        uniqueId.append(".");
                        uniqueId.append(dataSourceId);
                        uniqueId.append(".");
                        uniqueId.append(uniqueName);
                        idForExistenceCheck = uniqueName;
                    }
                }
                if (null != idForExistenceCheck) {
                    R3JCoProxy.Client client = this._backendProxy.getClient();
                    try {
                        if (this.doBapiUserExistenceCheck(client, idForExistenceCheck)) {
                            result.add(uniqueId.toString());
                        }
                        Object var12_12 = null;
                        this._backendProxy.releaseClient(client);
                    }
                    catch (Throwable throwable) {
                        Object var12_13 = null;
                        this._backendProxy.releaseClient(client);
                        throw throwable;
                    }
                }
                persistenceCollection = result;
                Object var14_15 = null;
            }
            catch (Exception e) {
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "getExistenceCheckResult()", e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "getExistenceCheckResult()", result);
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "getExistenceCheckResult()", result);
        return persistenceCollection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private R3PersistenceBase.IPersistenceCollection getComputableSearchResult(ISearchAttribute searchAttribute, String principalType) throws Exception {
        Object idParts;
        String METHOD = "getComputableSearchResult()";
        R3PersistenceBase.PersistenceCollection result = new R3PersistenceBase.PersistenceCollection();
        try {
            try {
                R3PersistenceBase.LogUtil.logEntering(LOG, "getComputableSearchResult()", new Object[]{searchAttribute, principalType});
                if (!"userid".equals(searchAttribute.getAttributeName())) throw new Exception("Search must access persistent storage: " + searchAttribute);
                idParts = this.splitPrincipalDatabagID((String)searchAttribute.getAttributeValue());
                String dataSourceId = this.getId();
                if ("USER".equalsIgnoreCase(idParts[0]) && dataSourceId.equalsIgnoreCase(idParts[1]) && R3PersistenceBase.Util.isSapUidLength(idParts[2])) {
                    String uniqueName = R3PersistenceBase.Util.charWiseUpperCase(idParts[2]);
                    StringBuffer uniqueId = new StringBuffer(5 + dataSourceId.length() + 1 + uniqueName.length());
                    uniqueId.append("UACC");
                    uniqueId.append(".");
                    uniqueId.append(dataSourceId);
                    uniqueId.append(".");
                    uniqueId.append(uniqueName);
                    result.add(uniqueId.toString());
                }
                idParts = result;
                Object var10_10 = null;
            }
            catch (Exception e) {
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "getComputableSearchResult()", e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "getComputableSearchResult()", result);
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "getComputableSearchResult()", result);
        return idParts;
    }

    private void addSearchTableLine(R3JCoProxy.Table table, ISearchAttribute attribute) throws Exception {
        String name = attribute.getAttributeName();
        String value = (String)attribute.getAttributeValue();
        if ("islocked".equals(name)) {
            table.appendRow();
            table.setValue((Object)"LOGONDATA", "PARAMETER");
            table.setValue((Object)"UFLAG", "FIELD");
            table.setValue((Object)"NE", "OPTION");
            table.setValue((Object)"0", "LOW");
        } else {
            String operatorBackend;
            String searchValue;
            int backendLength;
            boolean backendIsCaseSensitive;
            String field;
            String parameter;
            if ("j_user".equals(name) || "uniquename".equals(name)) {
                parameter = "USERNAME";
                field = R3USER_PHONE;
                backendIsCaseSensitive = false;
                backendLength = 12;
                searchValue = R3PersistenceBase.Util.charWiseUpperCase(value);
            } else if ("userid".equals(name)) {
                parameter = "USERNAME";
                field = R3USER_PHONE;
                backendIsCaseSensitive = false;
                backendLength = 12;
                searchValue = R3PersistenceBase.Util.charWiseUpperCase(this.splitPrincipalDatabagID(value)[2]);
            } else if ("firstname".equals(name)) {
                parameter = "ADDRESS";
                field = "FIRSTNAME";
                backendIsCaseSensitive = false;
                backendLength = 40;
                searchValue = R3PersistenceBase.Util.charWiseUpperCase(value);
            } else if ("lastname".equals(name)) {
                parameter = "ADDRESS";
                field = "LASTNAME";
                backendIsCaseSensitive = false;
                backendLength = 40;
                searchValue = R3PersistenceBase.Util.charWiseUpperCase(value);
            } else if ("department".equals(name)) {
                parameter = "ADDRESS";
                field = "DEPARTMENT";
                backendIsCaseSensitive = true;
                backendLength = 40;
                searchValue = value;
            } else if ("jobtitle".equals(name)) {
                parameter = "ADDRESS";
                field = "FUNCTION";
                backendIsCaseSensitive = true;
                backendLength = 40;
                searchValue = value;
            } else if ("email".equals(name)) {
                parameter = "ADDRESS";
                field = "E_MAIL";
                backendIsCaseSensitive = false;
                backendLength = 241;
                searchValue = R3PersistenceBase.Util.charWiseUpperCase(value);
                if (searchValue.lastIndexOf(42) < searchValue.length() - 1) {
                    LOG.logWarningT("Search for attribute eMail in ABAP backend with star (*) not as last character can give incomplete results because the searchable part of the eMail address is only the first 20 characters", null);
                }
            } else {
                throw new PersistenceException("Search attribute \"" + name + "\" is not supported for users in the ABAP backend system");
            }
            boolean searchIsCaseSensitive = attribute.isCaseSensitive();
            if (searchIsCaseSensitive != backendIsCaseSensitive) {
                LOG.logWarningT("Search for attribute \"{0}\" was requested in mode {1} but this search type is not supported by the ABAP backend system. Performing the search operation in mode {2}.", new Object[]{name, searchIsCaseSensitive ? "case-sensitive" : "not case-sensitive", backendIsCaseSensitive ? "case-sensitive" : "not case-sensitive"});
            }
            int operator = attribute.getOperator();
            switch (operator) {
                case 0: {
                    operatorBackend = "EQ";
                    break;
                }
                case 1: {
                    operatorBackend = "CP";
                    break;
                }
                case 2: {
                    operatorBackend = "GT";
                    break;
                }
                case 3: {
                    operatorBackend = "LT";
                    break;
                }
                default: {
                    throw new PersistenceException("Search operator " + operator + " not supported");
                }
            }
            table.appendRow();
            table.setValue((Object)parameter, "PARAMETER");
            table.setValue((Object)field, "FIELD");
            table.setValue((Object)operatorBackend, "OPTION");
            if (searchValue.length() > backendLength) {
                LOG.logWarningT("A search request for users in the ABAP backend system with search attribute {0} and search value \"{1}\" was issued. The length of the value exceeds the length of the searchable field length in the backend ({2}) and will therefore be clipped.", new Object[]{name, searchValue, new Integer(backendLength)});
            }
            table.setValue((Object)searchValue, "LOW");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private R3PersistenceBase.IPersistenceCollection getPersistentSearchResult(List searchAttributes, String principalType, int maxResults) throws Exception {
        R3PersistenceBase.PersistenceCollection persistenceCollection;
        R3PersistenceBase.PersistenceCollection result;
        block37: {
            ISearchAttribute attr;
            block36: {
                String METHOD = "getPersistentSearchResult()";
                result = null;
                try {
                    try {
                        Object susrBapiF4Authority;
                        R3PersistenceBase.LogUtil.logEntering(LOG, "getPersistentSearchResult()", new Object[]{searchAttributes, principalType, new Integer(maxResults)});
                        if (this._bapiUserGetlist != null) {
                            R3JCoProxy.Table selection;
                            R3JCoProxy.Function getlist;
                            block35: {
                                ISearchAttribute searchAttribute;
                                LOG.debugT("getPersistentSearchResult()", "Using BAPI_USER_GETLIST");
                                getlist = this._bapiUserGetlist.getFunction();
                                getlist.getImportParameterList().setValue(maxResults == 0 ? 0 : maxResults + 1, "MAX_ROWS");
                                selection = getlist.getTableParameterList().getTable("SELECTION_EXP");
                                selection.appendRow();
                                selection.setValue((Object)"AND", "LOGOP");
                                Iterator iter = searchAttributes.iterator();
                                while (true) {
                                    if (!iter.hasNext()) {
                                        if (selection.getNumRows() == 1) {
                                            break;
                                        }
                                        break block35;
                                    }
                                    searchAttribute = (ISearchAttribute)iter.next();
                                    this.addSearchTableLine(selection, searchAttribute);
                                }
                                searchAttribute = null;
                                Object var27_14 = null;
                                R3PersistenceBase.LogUtil.logExiting(LOG, "getPersistentSearchResult()", result);
                                return searchAttribute;
                            }
                            selection.setRow(0);
                            selection.setValue(selection.getNumRows() - 1, "ARITY");
                            R3JCoProxy.Client client = this._backendProxy.getClient();
                            try {
                                client.execute(getlist);
                                Object var11_19 = null;
                                this._backendProxy.releaseClient(client);
                            }
                            catch (Throwable throwable) {
                                Object var11_20 = null;
                                this._backendProxy.releaseClient(client);
                                throw throwable;
                            }
                            R3JCoProxy.Table tabReturn = getlist.getTableParameterList().getTable("RETURN");
                            this.handleBapiRet2Table("getPersistentSearchResult()", BAPI_USER_GETLIST, tabReturn);
                            R3JCoProxy.Table userlist = getlist.getTableParameterList().getTable("USERLIST");
                            int count = userlist.getNumRows();
                            result = new R3PersistenceBase.PersistenceCollection(count);
                            String dataSourceId = this.getId();
                            StringBuffer uniqueId = new StringBuffer(5 + dataSourceId.length() + 1 + 12);
                            uniqueId.append(principalType);
                            uniqueId.append(".");
                            uniqueId.append(dataSourceId);
                            uniqueId.append(".");
                            int uniqueNameOffset = uniqueId.length();
                            int i = 0;
                            while (i < userlist.getNumRows()) {
                                userlist.setRow(i);
                                uniqueId.replace(uniqueNameOffset, uniqueId.capacity(), (String)userlist.getValue("USERNAME"));
                                result.add(uniqueId.toString());
                                ++i;
                            }
                        } else {
                            LOG.debugT("getPersistentSearchResult()", "Using BAPI_HELPVALUES_GET");
                            susrBapiF4Authority = this._backendProxy.getRepository().getFunctionTemplate("SUSR_BAPI_F4_AUTHORITY");
                            if (susrBapiF4Authority == null) {
                                throw new PersistenceException("Search for users is only possible if SAP Note 486908 is applied to the backend system");
                            }
                            R3JCoProxy.Function function = this._backendProxy.getRepository().getFunctionTemplate("BAPI_HELPVALUES_GET").getFunction();
                            R3JCoProxy.ParameterList imp = function.getImportParameterList();
                            imp.setValue("USER", "OBJNAME");
                            imp.setValue("GetDetail", "METHOD");
                            imp.setValue("UserName", "PARAMETER");
                            imp.getStructure("EXPLICIT_SHLP").setValue("USER_ADDR", "SHLPNAME");
                            imp.getStructure("EXPLICIT_SHLP").setValue("SH", "SHLPTYPE");
                            imp.setValue(maxResults == 0 ? 0 : maxResults + 1, "MAX_OF_ROWS");
                            R3JCoProxy.Table table = function.getTableParameterList().getTable("SELECTION_FOR_HELPVALUES");
                            Iterator iter = searchAttributes.iterator();
                            while (true) {
                                String search_val;
                                String select_fld;
                                if (!iter.hasNext()) {
                                    if (table.getNumRows() != 0) break;
                                    result = null;
                                    attr = result;
                                    break block36;
                                }
                                attr = (ISearchAttribute)iter.next();
                                String name = attr.getAttributeName();
                                String value = (String)attr.getAttributeValue();
                                table.appendRow();
                                table.setValue((Object)"I", "SIGN");
                                switch (attr.getOperator()) {
                                    case 0: {
                                        table.setValue((Object)"EQ", "OPTION");
                                        break;
                                    }
                                    case 1: {
                                        table.setValue((Object)"CP", "OPTION");
                                        break;
                                    }
                                    case 2: {
                                        table.setValue((Object)"GT", "OPTION");
                                        break;
                                    }
                                    case 3: {
                                        table.setValue((Object)"LT", "OPTION");
                                        break;
                                    }
                                    default: {
                                        throw new PersistenceException("Unsupported operator " + attr.getOperator());
                                    }
                                }
                                if ("j_user".equals(name) || "uniquename".equals(name)) {
                                    select_fld = "BNAME";
                                    search_val = R3PersistenceBase.Util.charWiseUpperCase(value);
                                } else if ("userid".equals(name)) {
                                    String uniqueName = this.splitPrincipalDatabagID(value)[2];
                                    select_fld = "BNAME";
                                    search_val = R3PersistenceBase.Util.charWiseUpperCase(uniqueName);
                                } else if ("firstname".equals(name)) {
                                    select_fld = "MC_NAMEFIR";
                                    search_val = R3PersistenceBase.Util.charWiseUpperCase(value);
                                } else if ("lastname".equals(name)) {
                                    select_fld = "MC_NAMELAS";
                                    search_val = R3PersistenceBase.Util.charWiseUpperCase(value);
                                } else {
                                    if (!"department".equals(name)) throw new PersistenceException("Search attribute \"" + name + "\" is not supported for users in the ABAP backend system");
                                    select_fld = "DEPARTMENT";
                                    search_val = value;
                                }
                                table.setValue((Object)select_fld, "SELECT_FLD");
                                table.setValue((Object)search_val, "LOW");
                            }
                            R3JCoProxy.Client client = this._backendProxy.getClient();
                            try {
                                client.execute(function);
                                Object var18_35 = null;
                                this._backendProxy.releaseClient(client);
                            }
                            catch (Throwable throwable) {
                                Object var18_36 = null;
                                this._backendProxy.releaseClient(client);
                                throw throwable;
                            }
                            R3JCoProxy.Structure ret = function.getExportParameterList().getStructure("RETURN");
                            String msgty = ret.getString("TYPE");
                            if ("E".equals(msgty) || "A".equals(msgty) || "W".equals(msgty)) {
                                if (!"S&013".equals(ret.getString("CODE"))) throw new PersistenceException("Exception from BAPI_HELPVALUES_GET: Code = " + ret.getString("CODE") + ", message = " + ret.getString("MESSAGE"));
                                persistenceCollection = result = new R3PersistenceBase.PersistenceCollection();
                                break block37;
                            }
                            R3JCoProxy.Table desc = function.getTableParameterList().getTable("DESCRIPTION_FOR_HELPVALUES");
                            int offset = 0;
                            int length = 12;
                            int i = 0;
                            while (i < desc.getNumRows()) {
                                desc.setRow(i);
                                if ("BNAME".equals(desc.getValue("FIELDNAME"))) {
                                    offset = desc.getInt("OFFSET");
                                    length = desc.getInt("LENG");
                                    LOG.debugT("getPersistentSearchResult()", "Located BNAME at offset " + offset + " with length " + length);
                                    break;
                                }
                                ++i;
                            }
                            R3JCoProxy.Table helpvalues = function.getTableParameterList().getTable("HELPVALUES");
                            result = new R3PersistenceBase.PersistenceCollection();
                            int i2 = 0;
                            while (i2 < helpvalues.getNumRows()) {
                                helpvalues.setRow(i2);
                                String userName = R3PersistenceBase.Util.trimTrailing(helpvalues.getString("HELPVALUES").substring(offset, offset + length));
                                result.add(principalType + "." + this.getId() + "." + userName);
                                ++i2;
                            }
                        }
                        susrBapiF4Authority = result;
                        Object var27_17 = null;
                        R3PersistenceBase.LogUtil.logExiting(LOG, "getPersistentSearchResult()", result);
                        return susrBapiF4Authority;
                    }
                    catch (Exception e) {
                        R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "getPersistentSearchResult()", e);
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    Object var27_18 = null;
                    R3PersistenceBase.LogUtil.logExiting(LOG, "getPersistentSearchResult()", result);
                    throw throwable;
                }
            }
            Object var27_15 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "getPersistentSearchResult()", result);
            return attr;
        }
        Object var27_16 = null;
        R3PersistenceBase.LogUtil.logExiting(LOG, "getPersistentSearchResult()", result);
        return persistenceCollection;
    }

    private Map getCreateValues(IInternalPrincipalDatabag principal) throws Exception {
        R3PersistenceBase.InternalPrincipalDatabagWrapper principalX = new R3PersistenceBase.InternalPrincipalDatabagWrapper(principal);
        String METHOD = "getCreateValues()";
        HashMap<String, Object> createValues = new HashMap<String, Object>();
        try {
            try {
                R3PersistenceBase.LogUtil.logEntering(LOG, "getCreateValues()", new Object[]{principal});
                String type = principal.getIDParts()[0];
                Iterator namespaces = principalX.getAllNameSpaces().iterator();
                while (namespaces.hasNext()) {
                    String ns = (String)namespaces.next();
                    Iterator attributes = principalX.getAllAttributes(ns).iterator();
                    while (attributes.hasNext()) {
                        String att = (String)attributes.next();
                        if (!this.feelsResponsible(type, ns, att)) continue;
                        R3PersistenceBase.IPersistenceCollection values = principalX.getValues(ns, att);
                        if (values != null) {
                            createValues.put(att, values.getOnlyElement());
                            continue;
                        }
                        createValues.put(att, null);
                    }
                }
                HashMap<String, Object> hashMap = createValues;
                Object var12_12 = null;
                R3PersistenceBase.LogUtil.logExiting(LOG, "getCreateValues()", LOG.bePath() ? this.sensitiveMap2s(createValues) : null);
                return hashMap;
            }
            catch (Exception e) {
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "getCreateValues()", e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "getCreateValues()", LOG.bePath() ? this.sensitiveMap2s(createValues) : null);
            throw throwable;
        }
    }

    private Map getUpdateValues(IInternalPrincipalDatabagMaint principal, String type, R3JCoProxy.Client client) throws Exception {
        R3PersistenceBase.InternalPrincipalDatabagMaintWrapper principalX = new R3PersistenceBase.InternalPrincipalDatabagMaintWrapper(principal);
        String METHOD = "getUpdateValues()";
        HashMap<String, Object> updateValues = new HashMap<String, Object>();
        try {
            try {
                Object oRead;
                Object oUpd;
                Object o;
                R3PersistenceBase.IPersistenceCollection values;
                String attr;
                Iterator eattrs;
                String ns;
                R3PersistenceBase.LogUtil.logEntering(LOG, "getUpdateValues()", new Object[]{principal, type, client});
                HashMap readValues = new HashMap();
                Iterator ens = principalX.getAllNameSpaces(2).iterator();
                while (ens.hasNext()) {
                    ns = (String)ens.next();
                    eattrs = principalX.getAllAttributes(ns, 2).iterator();
                    while (eattrs.hasNext()) {
                        attr = (String)eattrs.next();
                        if (!this.feelsResponsible(type, ns, attr)) continue;
                        values = principalX.getValues(ns, attr, 2);
                        if (null == values) {
                            updateValues.put(attr, null);
                            continue;
                        }
                        switch (values.size()) {
                            case 0: {
                                updateValues.put(attr, null);
                                break;
                            }
                            case 1: {
                                updateValues.put(attr, values.getOnlyElement());
                                break;
                            }
                            default: {
                                throw new PersistenceException("Unexpected value count: " + values.size() + ". " + ns + "|->" + attr + " of " + type + " principals must be SINGLE-VALUED" + " if any datasource of class " + (class$com$sap$security$core$persistence$datasource$imp$R3Persistence == null ? (class$com$sap$security$core$persistence$datasource$imp$R3Persistence = R3Persistence.class$("com.sap.security.core.persistence.datasource.imp.R3Persistence")) : class$com$sap$security$core$persistence$datasource$imp$R3Persistence).getName() + " is responsible for writing it.");
                            }
                        }
                    }
                }
                if (updateValues.containsKey("j_password") && null != (values = principalX.getValues("com.sap.security.core.usermanagement", "oldpassword", 2))) {
                    switch (values.size()) {
                        case 0: {
                            LOG.logInfoT("Principal {0}: No values for attribute {1}|->{2}. No UPDATE will be done.", new Object[]{principal.getUniqueID(), "com.sap.security.core.usermanagement", "oldpassword"});
                            break;
                        }
                        case 1: {
                            updateValues.put("oldpassword", values.getOnlyElement());
                            break;
                        }
                        default: {
                            throw new PersistenceException("Unexpected value count: " + values.size() + ". " + "com.sap.security.core.usermanagement" + "|->" + "oldpassword" + " of " + type + " principals must be SINGLE-VALUED");
                        }
                    }
                }
                ens = principalX.getAllNameSpaces(3).iterator();
                while (ens.hasNext()) {
                    ns = (String)ens.next();
                    eattrs = principalX.getAllAttributes(ns, 3).iterator();
                    while (eattrs.hasNext()) {
                        attr = (String)eattrs.next();
                        if (!this.feelsResponsible(type, ns, attr)) continue;
                        updateValues.put(attr, null);
                    }
                }
                ens = principalX.getAllNameSpaces(0).iterator();
                while (ens.hasNext()) {
                    ns = (String)ens.next();
                    eattrs = principalX.getAllAttributes(ns, 0).iterator();
                    while (eattrs.hasNext()) {
                        attr = (String)eattrs.next();
                        if (!this.feelsResponsible(type, ns, attr)) continue;
                        values = principalX.getValues(ns, attr, 0);
                        if (null == values) {
                            LOG.logInfoT("Principal {0}: No values for attribute {1}|->{2}. No ADD will be done.", new Object[]{principal.getUniqueID(), ns, attr});
                            continue;
                        }
                        switch (values.size()) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                o = values.getOnlyElement();
                                if (null != o) {
                                    if (updateValues.containsKey(attr)) {
                                        oUpd = updateValues.get(attr);
                                        if (null == oUpd) {
                                            updateValues.put(attr, o);
                                            break;
                                        }
                                        throw new PersistenceException("Cannot ADD value \"" + o + "\" to " + ns + "|->" + attr + " of " + type + " principal. " + "Reason: attribute is single-valued " + "in ABAP, and storage of value \"" + oUpd + "\" is already pending");
                                    }
                                    this.doReadPersistent(readValues, attr, client);
                                    oRead = readValues.get(attr);
                                    if (null == oRead) {
                                        updateValues.put(attr, o);
                                        break;
                                    }
                                    throw new PersistenceException("Cannot ADD value \"" + o + "\" to " + ns + "|->" + attr + " of " + type + " principal. " + "Reason: attribute is single-valued " + "in ABAP, and already has a value \"" + oRead + "\" in persistent storage");
                                }
                                LOG.logInfoT("Principal {0}: No values for attribute {1}|->{2}. No ADD will be done.", new Object[]{principal.getUniqueID(), ns, attr});
                                break;
                            }
                            default: {
                                throw new PersistenceException("Unexpected value count: " + values.size() + ". " + ns + "|->" + attr + " of " + type + " principals must be SINGLE-VALUED" + " if any datasource of class " + (class$com$sap$security$core$persistence$datasource$imp$R3Persistence == null ? (class$com$sap$security$core$persistence$datasource$imp$R3Persistence = R3Persistence.class$("com.sap.security.core.persistence.datasource.imp.R3Persistence")) : class$com$sap$security$core$persistence$datasource$imp$R3Persistence).getName() + " is responsible for writing it.");
                            }
                        }
                    }
                }
                ens = principalX.getAllNameSpaces(1).iterator();
                while (ens.hasNext()) {
                    ns = (String)ens.next();
                    eattrs = principalX.getAllAttributes(ns, 1).iterator();
                    while (eattrs.hasNext()) {
                        attr = (String)eattrs.next();
                        if (!this.feelsResponsible(type, ns, attr)) continue;
                        values = principalX.getValues(ns, attr, 1);
                        if (null == values) {
                            LOG.logInfoT("Principal {0}: No values for attribute {1}|->{2}. No REMOVE will be done.", new Object[]{principal.getUniqueID(), ns, attr});
                            continue;
                        }
                        switch (values.size()) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                o = values.getOnlyElement();
                                if (null != o) {
                                    if (updateValues.containsKey(attr)) {
                                        oUpd = updateValues.get(attr);
                                        if (o.equals(oUpd)) {
                                            updateValues.remove(attr);
                                            break;
                                        }
                                        throw new PersistenceException("Cannot REMOVE value \"" + o + "\" from " + ns + "|->" + attr + " of " + type + " principal. " + "Reason: no such value (" + "storage of value \"" + oUpd + "\" is already pending)");
                                    }
                                    this.doReadPersistent(readValues, attr, client);
                                    oRead = readValues.get(attr);
                                    if (o.equals(oRead)) {
                                        updateValues.put(attr, null);
                                        break;
                                    }
                                    throw new PersistenceException("Cannot REMOVE value \"" + o + "\" from " + ns + "|->" + attr + " of " + type + " principal. " + "Reason: no such value (" + "value in persistent storage is \"" + oRead + "\")");
                                }
                                LOG.logInfoT("Principal {0}: No values for attribute {1}|->{2}. No REMOVE will be done.", new Object[]{principal.getUniqueID(), ns, attr});
                                break;
                            }
                            default: {
                                throw new PersistenceException("Unexpected value count: " + values.size() + ". " + ns + "|->" + attr + " of " + type + " principals must be SINGLE-VALUED" + " if any datasource of class " + (class$com$sap$security$core$persistence$datasource$imp$R3Persistence == null ? (class$com$sap$security$core$persistence$datasource$imp$R3Persistence = R3Persistence.class$("com.sap.security.core.persistence.datasource.imp.R3Persistence")) : class$com$sap$security$core$persistence$datasource$imp$R3Persistence).getName() + " is responsible for writing it.");
                            }
                        }
                    }
                }
                HashMap<String, Object> hashMap = updateValues;
                Object var18_18 = null;
                R3PersistenceBase.LogUtil.logExiting(LOG, "getUpdateValues()", LOG.bePath() ? this.sensitiveMap2s(updateValues) : null);
                return hashMap;
            }
            catch (Exception e) {
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "getUpdateValues()", e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "getUpdateValues()", LOG.bePath() ? this.sensitiveMap2s(updateValues) : null);
            throw throwable;
        }
    }

    private void doDispatchWrite(R3JCoProxy.Client client, String uniqueName, boolean updateMode, Map values) throws Exception {
        String METHOD = "doDispatchWrite()";
        boolean isTransaction = false;
        try {
            block12: {
                try {
                    R3PersistenceBase.LogUtil.logEntering(LOG, "doDispatchWrite()", new Object[]{client, uniqueName, new Boolean(updateMode), LOG.bePath() ? this.sensitiveMap2s(values) : null});
                    if (values.containsKey("salutation") || values.containsKey("uniquename") || values.containsKey("title") || values.containsKey("firstname") || values.containsKey("lastname") || values.containsKey("email") || values.containsKey("telephone") || values.containsKey("mobile") || values.containsKey("fax") || values.containsKey("locale") || values.containsKey("timezone") || values.containsKey("department") || values.containsKey("jobtitle") || values.containsKey("company") || values.containsKey("companyid") || values.containsKey("referenceuser") || values.containsKey("validfrom") || values.containsKey("validto") || values.containsKey("ispassworddisabled") || values.containsKey("passwordchangerequired") || values.containsKey("j_password") && !values.containsKey("oldpassword")) {
                        isTransaction = true;
                        this.doBapiUserCreateChange(client, uniqueName, updateMode, values);
                    }
                    if (values.containsKey("j_password") && values.containsKey("oldpassword")) {
                        this.doSusrUserChangePasswordRfc(client, uniqueName, values);
                    }
                    if (values.containsKey("islocked")) {
                        String locked = (String)values.get("islocked");
                        if ("true".equals(locked)) {
                            String lockReason = (String)values.get("lockreason");
                            if (lockReason == null || LOCKED_ADMIN.equals(lockReason.trim())) {
                                isTransaction = true;
                                this.doBapiUserLock(client, uniqueName);
                            } else {
                                LOG.logInfoT("The lock type {0} should be set for the backend user {1}. This request is ignored because only administrator locks can be set for users in the ABAP backend system.", new Object[]{lockReason, uniqueName});
                            }
                        } else {
                            isTransaction = true;
                            this.doBapiUserUnlock(client, uniqueName);
                        }
                    }
                    if (!isTransaction) break block12;
                    this.doBapiTransactionCommit(client);
                }
                catch (Exception e) {
                    if (isTransaction) {
                        this.doBapiTransactionRollback(client);
                    }
                    R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "doDispatchWrite()", e);
                    throw e;
                }
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "doDispatchWrite()");
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "doDispatchWrite()");
    }

    private void doDispatchRead(R3JCoProxy.Client client, String uniqueName, String principalType, Vector attributes, Hashtable nameSpaces, IInternalPrincipalDatabag principal) throws Exception {
        String METHOD = "doDispatchRead()";
        try {
            block16: {
                try {
                    boolean exists;
                    boolean existenceChecked;
                    block15: {
                        R3PersistenceBase.LogUtil.logEntering(LOG, "doDispatchRead()", new Object[]{client, uniqueName, principalType, attributes, nameSpaces, principal});
                        existenceChecked = false;
                        exists = false;
                        try {
                            if (null == attributes) {
                                attributes = (Vector)nameSpaces.get("com.sap.security.core.usermanagement");
                            }
                            if ("USER".equals(principalType)) {
                                if (attributes.contains("uniquename") && this.feelsResponsible(principalType, "com.sap.security.core.usermanagement", "uniquename")) {
                                    principal.addAttributeValue("com.sap.security.core.usermanagement", "uniquename", uniqueName);
                                }
                                if (attributes.contains("salutation") || attributes.contains("title") || attributes.contains("firstname") || attributes.contains("lastname") || attributes.contains("email") || attributes.contains("telephone") || attributes.contains("mobile") || attributes.contains("fax") || attributes.contains("locale") || attributes.contains("timezone") || attributes.contains("department") || attributes.contains("jobtitle") || attributes.contains("company") || attributes.contains("companyid") || attributes.contains("referenceuser")) {
                                    this.doBapiUserGetDetail(client, uniqueName, principalType, principal);
                                    existenceChecked = true;
                                    exists = true;
                                }
                                break block15;
                            }
                            if ("UACC".equals(principalType)) {
                                if (attributes.contains("userid") && this.feelsResponsible(principalType, "com.sap.security.core.usermanagement", "userid")) {
                                    StringBuffer sb = new StringBuffer();
                                    sb.append("USER");
                                    sb.append(".");
                                    sb.append(this.getId());
                                    sb.append(".");
                                    sb.append(uniqueName);
                                    principal.addAttributeValue("com.sap.security.core.usermanagement", "userid", sb.toString());
                                }
                                if (attributes.contains("j_user") && this.feelsResponsible(principalType, "com.sap.security.core.usermanagement", "j_user")) {
                                    principal.addAttributeValue("com.sap.security.core.usermanagement", "j_user", uniqueName);
                                }
                                if (attributes.contains("validfrom") || attributes.contains("validto") || attributes.contains("ispassworddisabled")) {
                                    this.doBapiUserGetDetail(client, uniqueName, principalType, principal);
                                    existenceChecked = true;
                                    exists = true;
                                }
                                if (attributes.contains("passwordchangerequired") || attributes.contains("islocked") || attributes.contains("lockreason")) {
                                    this.doSusrLoginCheckRfc(client, uniqueName, principal);
                                    existenceChecked = true;
                                    exists = true;
                                }
                                break block15;
                            }
                            throw new PersistenceException("This datasource cannot read attributes of " + principalType + " principals");
                        }
                        catch (R3PersistenceBase.NoSuchPrincipalException e) {
                            existenceChecked = true;
                            exists = false;
                        }
                    }
                    String principalCreatorID = principal.getIDParts()[1];
                    if (!existenceChecked || !principalCreatorID.equals(this.getId())) break block16;
                    principal.setExists(exists);
                }
                catch (Exception e) {
                    R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "doDispatchRead()", e);
                    throw e;
                }
            }
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "doDispatchRead()", new Object[]{principal});
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "doDispatchRead()", new Object[]{principal});
    }

    private void doReadPersistent(Map databag, String attribute, R3JCoProxy.Client client) throws Exception {
        throw new UnsupportedOperationException("doReadPersistent is not implemented");
    }

    private void doSusrLoginCheckRfc(R3JCoProxy.Client client, String uniqueName, IInternalPrincipalDatabag principal) throws Exception {
        String METHOD = "doSusrLoginCheckRfc()";
        try {
            block21: {
                try {
                    String isPwChangeReq;
                    String lockReason;
                    String isLocked;
                    R3PersistenceBase.LogUtil.logEntering(LOG, "doSusrLoginCheckRfc()", new Object[]{client, uniqueName, principal});
                    String rfcFunc = SUSR_LOGIN_CHECK_RFC;
                    final class LoginCheckInfo {
                        public String isLocked;
                        public String lockReason;
                        public String isPwdChangeReq;
                        private final /* synthetic */ R3Persistence this$0;

                        LoginCheckInfo(R3Persistence this$0) {
                            this.this$0 = this$0;
                        }
                    }
                    LoginCheckInfo info = (LoginCheckInfo)this._susrLoginCheckRfcCache.get(uniqueName);
                    if (info == null) {
                        try {
                            R3JCoProxy.Function checkLogin = this._backendProxy.getRepository().getFunctionTemplate(SUSR_LOGIN_CHECK_RFC).getFunction();
                            checkLogin.getImportParameterList().setValue(uniqueName, "BNAME");
                            if (this._newLockAndOutOfValidityBehavior) {
                                checkLogin.getImportParameterList().setValue((byte)1, "USE_NEW_EXCEPTION");
                            }
                            client.execute(checkLogin);
                            this.logFunction("doSusrLoginCheckRfc()", checkLogin);
                            isLocked = "false";
                            lockReason = LOCKED_NO;
                            isPwChangeReq = "false";
                        }
                        catch (R3JCoProxy.R3ABAPException ae) {
                            String key = ae.getKey();
                            if ("USER_LOCKED".equals(key)) {
                                isLocked = "true";
                                lockReason = LOCKED_ADMIN;
                                isPwChangeReq = null;
                                LOG.debugT("doSusrLoginCheckRfc()", "User " + principal.getUniqueID() + " locked by admin. Cannot determine password " + "change requirement.");
                            }
                            if ("PASSWORD_ATTEMPTS_LIMITED".equals(key)) {
                                isLocked = "true";
                                lockReason = LOCKED_AUTO;
                                isPwChangeReq = null;
                                LOG.debugT("doSusrLoginCheckRfc()", "User " + principal.getUniqueID() + " locked by password attempts. Cannot determine password " + "change requirement.");
                            }
                            if ("NO_CHECK_FOR_THIS_USER".equals(key)) {
                                isLocked = null;
                                lockReason = null;
                                isPwChangeReq = null;
                                LOG.debugT("doSusrLoginCheckRfc()", "Exception NO_CHECK_FOR_THIS_USER for user " + principal.getUniqueID() + ". Lock state and password change requirement " + "cannot be determined");
                            }
                            if ("PASSWORD_EXPIRED".equals(key)) {
                                isLocked = "false";
                                lockReason = LOCKED_NO;
                                isPwChangeReq = "true";
                            }
                            if ("USER_NOT_ACTIVE".equals(key)) {
                                isLocked = "false";
                                lockReason = LOCKED_NO;
                                isPwChangeReq = null;
                                LOG.debugT("doSusrLoginCheckRfc()", "Cannot determine password change requirement for user " + principal.getUniqueID() + " because user not in validity range");
                            }
                            throw ae;
                        }
                        info = new LoginCheckInfo(this);
                        info.isLocked = isLocked;
                        info.lockReason = lockReason;
                        info.isPwdChangeReq = isPwChangeReq;
                        this._susrLoginCheckRfcCache.put(uniqueName, info);
                    } else {
                        LOG.debugT("doSusrLoginCheckRfc()", "Using buffered data");
                        isLocked = info.isLocked;
                        lockReason = info.lockReason;
                        isPwChangeReq = info.isPwdChangeReq;
                    }
                    if (this.feelsResponsible("UACC", "com.sap.security.core.usermanagement", "islocked")) {
                        if (isLocked != null) {
                            principal.addAttributeValue("com.sap.security.core.usermanagement", "islocked", isLocked);
                        } else {
                            R3PersistenceBase.Util.populateEmptyIfNeeded(principal, "islocked");
                        }
                    }
                    if (this.feelsResponsible("UACC", "com.sap.security.core.usermanagement", "lockreason")) {
                        if (lockReason != null) {
                            principal.addAttributeValue("com.sap.security.core.usermanagement", "lockreason", lockReason);
                        } else {
                            R3PersistenceBase.Util.populateEmptyIfNeeded(principal, "lockreason");
                        }
                    }
                    if (!this.feelsResponsible("UACC", "com.sap.security.core.usermanagement", "passwordchangerequired")) break block21;
                    if (isPwChangeReq != null) {
                        principal.addAttributeValue("com.sap.security.core.usermanagement", "passwordchangerequired", isPwChangeReq);
                        break block21;
                    }
                    R3PersistenceBase.Util.populateEmptyIfNeeded(principal, "passwordchangerequired");
                }
                catch (Exception e) {
                    R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "doSusrLoginCheckRfc()", e);
                    throw e;
                }
            }
            Object var13_14 = null;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "doSusrLoginCheckRfc()", new Object[]{principal});
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "doSusrLoginCheckRfc()", new Object[]{principal});
    }

    private void doSusrUserChangePasswordRfc(R3JCoProxy.Client client, String uniqueName, Map databag) throws Exception {
        String METHOD = "doSusrUserChangePasswordRfc()";
        try {
            try {
                R3PersistenceBase.LogUtil.logEntering(LOG, "doSusrUserChangePasswordRfc()", new Object[]{client, uniqueName, LOG.bePath() ? this.sensitiveMap2s(databag) : null});
                String rfcFunc = "SUSR_USER_CHANGE_PASSWORD_RFC";
                R3JCoProxy.Function changepassword = this._backendProxy.getRepository().getFunctionTemplate("SUSR_USER_CHANGE_PASSWORD_RFC").getFunction();
                R3JCoProxy.ParameterList imports = changepassword.getImportParameterList();
                imports.setValue(uniqueName, "BNAME");
                if (!databag.containsKey("oldpassword")) {
                    throw new PersistenceException("Missing required attribute \"oldpassword\"");
                }
                String oldPassword = (String)databag.get("oldpassword");
                imports.setValue(oldPassword, "PASSWORD");
                if (!databag.containsKey("j_password")) {
                    throw new PersistenceException("Missing required attribute \"j_password\"");
                }
                String newPassword = (String)databag.get("j_password");
                imports.setValue(newPassword, "NEW_PASSWORD");
                client.execute(changepassword);
                this.logFunction("doSusrUserChangePasswordRfc()", changepassword);
                R3PersistenceBase.WeakLRUHashMap.clearAllInstances(uniqueName);
            }
            catch (Exception e) {
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "doSusrUserChangePasswordRfc()", e);
                throw e;
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "doSusrUserChangePasswordRfc()");
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "doSusrUserChangePasswordRfc()");
    }

    private R3JCoProxy.Function doBapiUserGetDetailInternal(R3JCoProxy.Client client, String userName) throws Exception {
        String METHOD = "doBapiUserGetDetailInternal()";
        R3JCoProxy.Function getdetail = (R3JCoProxy.Function)this._bapiUserGetDetailCache.get(userName);
        if (getdetail == null) {
            getdetail = this._backendProxy.getRepository().getFunctionTemplate("BAPI_USER_GET_DETAIL").getFunction();
            getdetail.getImportParameterList().setValue(userName, "USERNAME");
            R3JCoProxy.ParameterList tables = getdetail.getTableParameterList();
            int fieldCnt = tables.getFieldCount();
            int i = 0;
            while (i < fieldCnt) {
                tables.setActive(false, i);
                ++i;
            }
            tables.setActive(true, "RETURN");
            tables.setActive(true, "ADDTEL");
            tables.setActive(true, "ADDFAX");
            R3JCoProxy.ParameterList exports = getdetail.getExportParameterList();
            int exportfieldCnt = exports.getFieldCount();
            int i2 = 0;
            while (i2 < exportfieldCnt) {
                exports.setActive(false, i2);
                ++i2;
            }
            exports.setActive(true, "ADDRESS");
            exports.setActive(true, "COMPANY");
            exports.setActive(true, "LOGONDATA");
            exports.setActive(true, "DEFAULTS");
            exports.setActive(true, "REF_USER");
            LOG.debugT("doBapiUserGetDetailInternal()", "Performing backend access for BAPI_USER_GET_DETAIL for user {0}", new Object[]{userName});
            client.execute(getdetail);
            this.logFunction("doBapiUserGetDetailInternal()", getdetail);
            this._bapiUserGetDetailCache.put(userName, getdetail);
        } else {
            LOG.debugT("doBapiUserGetDetailInternal()", "Using buffered data for BAPI_USER_GET_DETAIL for user {0}", new Object[]{userName});
        }
        return getdetail;
    }

    private void setPhoneNumbers(R3JCoProxy.Client client, String userName, Map databag, R3JCoProxy.Table addtel, R3JCoProxy.Table addfax, R3JCoProxy.Structure addcomx) throws Exception {
        String METHOD = "setPhoneNumbers()";
        try {
            block49: {
                try {
                    final class ConsnumberManager {
                        private HashMap _map;
                        private final /* synthetic */ R3Persistence this$0;

                        ConsnumberManager(R3Persistence this$0) {
                            this.this$0 = this$0;
                            this._map = new HashMap<K, V>();
                        }

                        public void markNumber(int number) {
                            this._map.put(new Integer(number), null);
                        }

                        public int getNextNumber() {
                            int number = 1;
                            while (this._map.containsKey(new Integer(number))) {
                                ++number;
                            }
                            this.markNumber(number);
                            return number;
                        }
                    }
                    String fax;
                    R3PersistenceBase.LogUtil.logEntering(LOG, "setPhoneNumbers()", new Object[]{userName, databag, addtel, addfax, addcomx});
                    boolean setPhone = databag.containsKey("telephone");
                    boolean setMobile = databag.containsKey("mobile");
                    boolean setFax = databag.containsKey("fax");
                    R3JCoProxy.Table currentTel = null;
                    R3JCoProxy.Table currentFax = null;
                    if (addcomx != null && (setPhone || setMobile || setFax)) {
                        R3JCoProxy.Function getdetail = this.doBapiUserGetDetailInternal(client, userName);
                        this.handleBapiRet2Table("setPhoneNumbers()", "BAPI_USER_GET_DETAIL", getdetail.getTableParameterList().getTable("RETURN"));
                        currentTel = getdetail.getTableParameterList().getTable("ADDTEL");
                        currentFax = getdetail.getTableParameterList().getTable("ADDFAX");
                        LOG.debugT("setPhoneNumbers()", "Read current phone number state for user {0} from backend. ADDTEL:\n{1}\n\nADDFAX:\n{2}\n", new Object[]{currentTel, currentFax});
                    }
                    if (setPhone || setMobile) {
                        String mobile;
                        String phone;
                        if (addcomx != null) {
                            addcomx.setValue("X", "ADTEL");
                        }
                        boolean mobileWasStdNo = false;
                        ConsnumberManager consnumberManager = new ConsnumberManager(this);
                        int defaultPhoneConsnumber = -1;
                        int defaultMobileConsnumber = -1;
                        if (currentTel != null) {
                            int i = 0;
                            while (i < currentTel.getNumRows()) {
                                String stdNo;
                                currentTel.setRow(i);
                                String r3User = currentTel.getString(BAPIADTEL_R_3_USER).trim();
                                int consNumber = currentTel.getInt(BAPIADTEL_CONSNUMBER);
                                if (R3USER_PHONE.equals(r3User) || R3USER_MOBILE.equals(r3User) || R3USER_PHONE_DEFAULT.equals(r3User) && setMobile && !setPhone || R3USER_MOBILE_DEFAULT.equals(r3User) && setPhone && !setMobile) {
                                    addtel.appendRow();
                                    int j = 0;
                                    while (j < currentTel.getNumColumns()) {
                                        addtel.setValue(currentTel.getValue(j), j);
                                        ++j;
                                    }
                                    consnumberManager.markNumber(consNumber);
                                }
                                if (R3USER_PHONE_DEFAULT.equals(r3User)) {
                                    defaultPhoneConsnumber = consNumber;
                                }
                                if (R3USER_MOBILE_DEFAULT.equals(r3User)) {
                                    defaultMobileConsnumber = consNumber;
                                }
                                if ("X".equals(stdNo = currentTel.getString(BAPIADTEL_STD_NO).trim()) && (R3USER_MOBILE.equals(r3User) || R3USER_MOBILE_DEFAULT.equals(r3User))) {
                                    mobileWasStdNo = true;
                                }
                                ++i;
                            }
                        }
                        if (setPhone && (phone = ((String)databag.get("telephone")).trim()).length() > 0) {
                            SAPPhoneNumber sapNumber = this.getPhoneNumberInternal(phone);
                            addtel.appendRow();
                            addtel.setValue((Object)R3USER_PHONE_DEFAULT, BAPIADTEL_R_3_USER);
                            addtel.setValue((Object)sapNumber.country, BAPIADTEL_COUNTRY);
                            addtel.setValue((Object)sapNumber.number, BAPIADTEL_TELEPHONE);
                            addtel.setValue((Object)sapNumber.extension, BAPIADTEL_EXTENSION);
                            if (defaultPhoneConsnumber != -1) {
                                addtel.setValue(defaultPhoneConsnumber, BAPIADTEL_CONSNUMBER);
                            } else {
                                addtel.setValue(consnumberManager.getNextNumber(), BAPIADTEL_CONSNUMBER);
                            }
                        }
                        if (setMobile && (mobile = ((String)databag.get("mobile")).trim()).length() > 0) {
                            SAPPhoneNumber sapNumberWithExtension = this.getPhoneNumberInternal(mobile);
                            SAPPhoneNumber sapNumber = new SAPPhoneNumber(sapNumberWithExtension.country, sapNumberWithExtension.number + (sapNumberWithExtension.extension.length() == 0 ? R3USER_PHONE : "-" + sapNumberWithExtension.extension), R3USER_PHONE);
                            addtel.appendRow();
                            addtel.setValue((Object)R3USER_MOBILE_DEFAULT, BAPIADTEL_R_3_USER);
                            addtel.setValue((Object)sapNumber.country, BAPIADTEL_COUNTRY);
                            addtel.setValue((Object)sapNumber.number, BAPIADTEL_TELEPHONE);
                            addtel.setValue((Object)sapNumber.extension, BAPIADTEL_EXTENSION);
                            if (defaultMobileConsnumber != -1) {
                                addtel.setValue(defaultMobileConsnumber, BAPIADTEL_CONSNUMBER);
                            } else {
                                addtel.setValue(consnumberManager.getNextNumber(), BAPIADTEL_CONSNUMBER);
                            }
                        }
                        if (!addtel.isEmpty()) {
                            boolean phoneFound = false;
                            int firstPhonePos = 0;
                            boolean phoneStdFound = false;
                            int phoneStdPos = 0;
                            boolean mobileFound = false;
                            int firstMobilePos = 0;
                            boolean mobileStdFound = false;
                            int mobileStdPos = 0;
                            boolean stdNoFound = false;
                            int stdNoPos = 0;
                            boolean homeFlagFound = false;
                            int i = 0;
                            while (i < addtel.getNumRows()) {
                                String homeFlag;
                                String stdNo;
                                addtel.setRow(i);
                                String r3User = addtel.getString(BAPIADTEL_R_3_USER).trim();
                                if (R3USER_PHONE.equals(r3User) || R3USER_PHONE_DEFAULT.equals(r3User)) {
                                    if (!phoneFound) {
                                        firstPhonePos = i;
                                    }
                                    phoneFound = true;
                                    if (R3USER_PHONE_DEFAULT.equals(r3User)) {
                                        phoneStdFound = true;
                                        phoneStdPos = i;
                                    }
                                }
                                if (R3USER_MOBILE.equals(r3User) || R3USER_MOBILE_DEFAULT.equals(r3User)) {
                                    if (!mobileFound) {
                                        firstMobilePos = i;
                                    }
                                    mobileFound = true;
                                    if (R3USER_MOBILE_DEFAULT.equals(r3User)) {
                                        mobileStdFound = true;
                                        mobileStdPos = i;
                                    }
                                }
                                if ("X".equals(stdNo = addtel.getString(BAPIADTEL_STD_NO).trim())) {
                                    stdNoFound = true;
                                }
                                if ("X".equals(homeFlag = addtel.getString(BAPIADTEL_HOME_FLAG).trim())) {
                                    homeFlagFound = true;
                                }
                                ++i;
                            }
                            if (phoneFound && !phoneStdFound) {
                                addtel.setRow(firstPhonePos);
                                addtel.setValue((Object)R3USER_PHONE_DEFAULT, BAPIADTEL_R_3_USER);
                                phoneStdFound = true;
                                phoneStdPos = firstPhonePos;
                            }
                            if (mobileFound && !mobileStdFound) {
                                addtel.setRow(firstMobilePos);
                                addtel.setValue((Object)R3USER_MOBILE_DEFAULT, BAPIADTEL_R_3_USER);
                                mobileStdFound = true;
                                mobileStdPos = firstMobilePos;
                            }
                            if (!stdNoFound) {
                                if (mobileWasStdNo && mobileFound) {
                                    addtel.setRow(mobileStdPos);
                                    addtel.setValue((Object)"X", BAPIADTEL_STD_NO);
                                    stdNoFound = true;
                                    stdNoPos = mobileStdPos;
                                } else {
                                    addtel.setRow(phoneStdPos);
                                    addtel.setValue((Object)"X", BAPIADTEL_STD_NO);
                                    stdNoFound = true;
                                    stdNoPos = phoneStdPos;
                                }
                            }
                            if (!homeFlagFound) {
                                addtel.setRow(stdNoPos);
                                addtel.setValue((Object)"X", BAPIADTEL_HOME_FLAG);
                            }
                        }
                    }
                    if (!setFax) break block49;
                    if (addcomx != null) {
                        addcomx.setValue("X", "ADFAX");
                    }
                    ConsnumberManager consnumberManager = new ConsnumberManager(this);
                    int defaultFaxConsnumber = -1;
                    if (currentFax != null) {
                        int i = 0;
                        while (i < currentFax.getNumRows()) {
                            currentFax.setRow(i);
                            String stdNo = currentFax.getString(BAPIADTEL_STD_NO).trim();
                            int consNumber = currentFax.getInt(BAPIADTEL_CONSNUMBER);
                            if (R3USER_PHONE.equals(stdNo)) {
                                addfax.appendRow();
                                int j = 0;
                                while (j < currentFax.getNumColumns()) {
                                    addfax.setValue(currentFax.getValue(j), j);
                                    ++j;
                                }
                                consnumberManager.markNumber(consNumber);
                            }
                            if ("X".equals(stdNo)) {
                                defaultFaxConsnumber = consNumber;
                            }
                            ++i;
                        }
                    }
                    if (setFax && (fax = ((String)databag.get("fax")).trim()).length() > 0) {
                        SAPPhoneNumber sapNumber = this.getPhoneNumberInternal(fax);
                        addfax.appendRow();
                        addfax.setValue((Object)"X", BAPIADTEL_STD_NO);
                        addfax.setValue((Object)sapNumber.country, BAPIADTEL_COUNTRY);
                        addfax.setValue((Object)sapNumber.number, BAPIADFAX_FAX);
                        addfax.setValue((Object)sapNumber.extension, BAPIADTEL_EXTENSION);
                        if (defaultFaxConsnumber != -1) {
                            addfax.setValue(defaultFaxConsnumber, BAPIADTEL_CONSNUMBER);
                        } else {
                            addfax.setValue(consnumberManager.getNextNumber(), BAPIADTEL_CONSNUMBER);
                        }
                    }
                    if (addfax.isEmpty()) break block49;
                    boolean stdNoFound = false;
                    int stdNoPos = 0;
                    boolean homeFlagFound = false;
                    int i = 0;
                    while (i < addfax.getNumRows()) {
                        addfax.setRow(i);
                        String stdNo = addfax.getString(BAPIADTEL_STD_NO).trim();
                        String homeFlag = addfax.getString(BAPIADTEL_HOME_FLAG).trim();
                        if ("X".equals(stdNo)) {
                            stdNoFound = true;
                            stdNoPos = i;
                        }
                        if ("X".equals(homeFlag)) {
                            homeFlagFound = true;
                        }
                        ++i;
                    }
                    if (!stdNoFound) {
                        addfax.setRow(0);
                        addfax.setValue((Object)"X", BAPIADTEL_STD_NO);
                        stdNoPos = 0;
                    }
                    if (homeFlagFound) break block49;
                    addfax.setRow(stdNoPos);
                    addfax.setValue((Object)"X", BAPIADTEL_HOME_FLAG);
                }
                catch (Exception e) {
                    R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "setPhoneNumbers()", e);
                    throw e;
                }
            }
            Object var33_53 = null;
        }
        catch (Throwable throwable) {
            Object var33_54 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "setPhoneNumbers()", new Object[]{addtel, addfax, addcomx});
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "setPhoneNumbers()", new Object[]{addtel, addfax, addcomx});
    }

    private void doBapiUserCreateChange(R3JCoProxy.Client client, String uniqueName, boolean updateMode, Map databag) throws Exception {
        String METHOD = "doBapiUserCreateChange()";
        try {
            try {
                R3PersistenceBase.LogUtil.logEntering(LOG, "doBapiUserCreateChange()", new Object[]{client, uniqueName, new Boolean(updateMode), LOG.bePath() ? this.sensitiveMap2s(databag) : null});
                String rfcFunc = updateMode ? "BAPI_USER_CHANGE" : "BAPI_USER_CREATE1";
                R3JCoProxy.Function func = this._backendProxy.getRepository().getFunctionTemplate(rfcFunc).getFunction();
                R3JCoProxy.ParameterList imports = func.getImportParameterList();
                R3JCoProxy.ParameterList tables = func.getTableParameterList();
                imports.setValue(R3PersistenceBase.Util.charWiseUpperCase(uniqueName), "USERNAME");
                this.setBapiLogonData(imports.getStructure("LOGONDATA"), updateMode ? imports.getStructure("LOGONDATAX") : null, databag, uniqueName);
                this.setBapiAddress(imports.getStructure("ADDRESS"), updateMode ? imports.getStructure("ADDRESSX") : null, databag);
                this.setPhoneNumbers(client, uniqueName, databag, tables.getTable("ADDTEL"), tables.getTable("ADDFAX"), updateMode ? imports.getStructure("ADDCOMX") : null);
                if (databag.containsKey("referenceuser")) {
                    String referenceuser = (String)databag.get("referenceuser");
                    if (null != referenceuser) {
                        referenceuser = R3PersistenceBase.Util.charWiseUpperCase(referenceuser);
                    }
                    imports.getStructure("REF_USER").setValue(referenceuser, "REF_USER");
                    if (updateMode) {
                        imports.getStructure("REF_USERX").setValue("X", "REF_USER");
                    }
                }
                if (databag.containsKey("company")) {
                    String company = (String)databag.get("company");
                    if (updateMode) {
                        imports.getStructure("COMPANYX").setValue("X", "COMPANY");
                    }
                    imports.getStructure("COMPANY").setValue(company, "COMPANY");
                }
                if (!updateMode && imports.hasField("FORCE_SYSTEM_ASSIGNMENT")) {
                    imports.setValue("X", "FORCE_SYSTEM_ASSIGNMENT");
                }
                if (!updateMode && !databag.containsKey("j_password")) {
                    imports.getStructure("LOGONDATA").setValue("X", "CODVN");
                }
                if (databag.containsKey("j_password") && !databag.containsKey("oldpassword")) {
                    String password = (String)databag.get("j_password");
                    imports.getStructure("PASSWORD").setValue(password, "BAPIPWD");
                    if (updateMode) {
                        imports.getStructure("PASSWORDX").setValue("X", "BAPIPWD");
                    }
                }
                if (databag.containsKey("ispassworddisabled")) {
                    boolean disable = "true".equalsIgnoreCase((String)databag.get("ispassworddisabled"));
                    boolean passwordGiven = databag.containsKey("j_password");
                    if (disable) {
                        if (passwordGiven) {
                            throw new PersistenceException("Disabling of password at the same time of setting new password is not supported");
                        }
                        imports.getStructure("LOGONDATA").setValue("X", "CODVN");
                        if (updateMode) {
                            imports.getStructure("LOGONDATAX").setValue("X", "CODVN");
                        }
                    } else if (!passwordGiven) {
                        throw new PersistenceException("Disabled password can only be reactivated by setting new password");
                    }
                }
                boolean setPasswordChangeReqToFalse = false;
                if (databag.containsKey("passwordchangerequired")) {
                    boolean explicit = "true".equals(databag.get("passwordchangerequired"));
                    boolean pwdPresent = databag.containsKey("j_password");
                    boolean oldPresent = databag.containsKey("oldpassword");
                    if (!(pwdPresent && !oldPresent && explicit || pwdPresent && oldPresent && !explicit)) {
                        if (explicit) {
                            LOG.logWarningT("Attribute \"passwordchangerequired\" cannot be set explicitly to \"true\" for user {0} because the ABAP backend system does not support this operation for data consistency reasons.", new Object[]{uniqueName});
                        } else if (!updateMode && imports.hasField("SELF_REGISTER")) {
                            imports.setValue("X", "SELF_REGISTER");
                        } else {
                            setPasswordChangeReqToFalse = true;
                        }
                    }
                }
                int fieldCnt = tables.getFieldCount();
                int i = 0;
                while (i < fieldCnt) {
                    tables.setActive(false, i);
                    ++i;
                }
                tables.setActive(true, "RETURN");
                tables.setActive(true, "ADDTEL");
                tables.setActive(true, "ADDFAX");
                client.execute(func);
                this.logFunction("doBapiUserCreateChange()", func);
                R3JCoProxy.Table tabReturn = tables.getTable("RETURN");
                this.handleBapiRet2Table("doBapiUserCreateChange()", rfcFunc, tabReturn);
                if (setPasswordChangeReqToFalse) {
                    this.doSetPasswordChangeRequired(client, uniqueName);
                }
                R3PersistenceBase.WeakLRUHashMap.clearAllInstances(uniqueName);
            }
            catch (Exception e) {
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "doBapiUserCreateChange()", e);
                throw e;
            }
            Object var15_18 = null;
        }
        catch (Throwable throwable) {
            Object var15_19 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "doBapiUserCreateChange()");
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "doBapiUserCreateChange()");
    }

    private void doSetPasswordChangeRequired(R3JCoProxy.Client client, String uniqueName) throws Exception {
        String METHOD = "doSetPasswordChangeRequired()";
        try {
            try {
                R3PersistenceBase.LogUtil.logEntering(LOG, "doSetPasswordChangeRequired()", new Object[]{uniqueName});
                R3JCoProxy.Function func = this._backendProxy.getRepository().getFunctionTemplate("BAPI_USER_CHANGE").getFunction();
                R3JCoProxy.ParameterList imports = func.getImportParameterList();
                R3JCoProxy.ParameterList tables = func.getTableParameterList();
                imports.setValue(R3PersistenceBase.Util.charWiseUpperCase(uniqueName), "USERNAME");
                imports.getStructure("LOGONDATA").setValue("000001", "LTIME");
                imports.getStructure("LOGONDATAX").setValue("X", "LTIME");
                int fieldCnt = tables.getFieldCount();
                int i = 0;
                while (i < fieldCnt) {
                    tables.setActive(false, i);
                    ++i;
                }
                tables.setActive(true, "RETURN");
                client.execute(func);
                this.logFunction("doSetPasswordChangeRequired()", func);
                try {
                    R3JCoProxy.Table tabReturn = tables.getTable("RETURN");
                    this.handleBapiRet2Table("doSetPasswordChangeRequired()", R3USER_PHONE, tabReturn);
                }
                catch (Exception e) {
                    LOG.logWarningT("Attribute \"passwordchangerequired\" for user {0} cannot be set to \"false\". The ABAP backend system does not permit this operation for security reasons. Error message: {1}", new Object[]{uniqueName, e.getMessage()});
                }
                Object var11_12 = null;
            }
            catch (Exception e) {
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "doSetPasswordChangeRequired()", e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "doSetPasswordChangeRequired()");
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "doSetPasswordChangeRequired()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getPhoneNumberExternal(SAPPhoneNumber sapNumber) {
        CharSequence buf;
        String result;
        block14: {
            String string;
            block12: {
                String METHOD = "getPhoneNumberExternal()";
                result = null;
                try {
                    try {
                        block13: {
                            R3PersistenceBase.LogUtil.logEntering(LOG, "getPhoneNumberExternal()", new Object[]{sapNumber});
                            result = (String)this._phoneNumberExtBuffer.get(sapNumber);
                            if (result != null) {
                                LOG.debugT("getPhoneNumberExternal()", "Reading number from buffer");
                                string = result;
                                Object var10_7 = null;
                                break block12;
                            }
                            if (!(this._prgnJ2EETelnoConvert == null || R3USER_PHONE.equals(sapNumber.country) || sapNumber.number.startsWith("+") || this._phoneConvertClassic)) {
                                R3JCoProxy.Client client = this._backendProxy.getClient();
                                try {
                                    try {
                                        R3JCoProxy.Function func = this._prgnJ2EETelnoConvert.getFunction();
                                        R3JCoProxy.ParameterList imp = func.getImportParameterList();
                                        imp.setValue("E", "IF_DIRECTION");
                                        imp.setValue(sapNumber.country, "IF_COUNTRY");
                                        imp.setValue(sapNumber.number, "IF_TELNUMBER");
                                        imp.setValue(sapNumber.extension, "IF_EXTENSION");
                                        client.execute(func);
                                        this.logFunction("getPhoneNumberExternal()", func);
                                        this.handleBapiRet2Table("getPhoneNumberExternal()", PRGN_J2EE_TELNO_CONVERT, func.getTableParameterList().getTable("RETURN"));
                                        result = func.getExportParameterList().getString("EF_NUMBER_E123").trim();
                                    }
                                    catch (Exception e) {
                                        R3PersistenceBase.LogUtil.logThrowable(2, LOG, "getPhoneNumberExternal()", "Exception during backend access for phone number conversion for number {0}. Using default construction method. ", new Object[]{sapNumber}, e);
                                        result = null;
                                        Object var8_14 = null;
                                        this._backendProxy.releaseClient(client);
                                        break block13;
                                    }
                                    Object var8_13 = null;
                                    this._backendProxy.releaseClient(client);
                                }
                                catch (Throwable throwable) {
                                    Object var8_15 = null;
                                    this._backendProxy.releaseClient(client);
                                    throw throwable;
                                }
                            }
                        }
                        if (result == null) {
                            buf = new StringBuffer(sapNumber.number);
                            if (sapNumber.extension.length() > 0) {
                                ((StringBuffer)buf).append("-").append(sapNumber.extension);
                            }
                            result = ((StringBuffer)buf).toString();
                        }
                        this._phoneNumberExtBuffer.put(sapNumber, result);
                        buf = result;
                        break block14;
                    }
                    catch (RuntimeException e) {
                        R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "getPhoneNumberExternal()", e);
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_9 = null;
                    R3PersistenceBase.LogUtil.logExiting(LOG, "getPhoneNumberExternal()", result);
                    throw throwable;
                }
            }
            R3PersistenceBase.LogUtil.logExiting(LOG, "getPhoneNumberExternal()", result);
            return string;
        }
        Object var10_8 = null;
        R3PersistenceBase.LogUtil.logExiting(LOG, "getPhoneNumberExternal()", result);
        return buf;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SAPPhoneNumber getPhoneNumberInternal(String extNumber) {
        SAPPhoneNumber lastDash2;
        SAPPhoneNumber result;
        block15: {
            SAPPhoneNumber sAPPhoneNumber;
            block13: {
                String METHOD = "getPhoneNumberInternal()";
                result = null;
                try {
                    try {
                        block14: {
                            R3PersistenceBase.LogUtil.logEntering(LOG, "getPhoneNumberInternal()", new Object[]{extNumber});
                            extNumber = extNumber.trim();
                            result = (SAPPhoneNumber)this._phoneNumberIntBuffer.get(extNumber);
                            if (result != null) {
                                LOG.debugT("getPhoneNumberInternal()", "Reading number from buffer");
                                sAPPhoneNumber = result;
                                Object var11_9 = null;
                                break block13;
                            }
                            if (this._prgnJ2EETelnoConvert != null && extNumber.startsWith("+") && !this._phoneConvertClassic) {
                                R3JCoProxy.Client client = this._backendProxy.getClient();
                                try {
                                    try {
                                        R3JCoProxy.Function func = this._prgnJ2EETelnoConvert.getFunction();
                                        R3JCoProxy.ParameterList imp = func.getImportParameterList();
                                        imp.setValue("I", "IF_DIRECTION");
                                        imp.setValue(extNumber, "IF_NUMBER_E123");
                                        client.execute(func);
                                        this.logFunction("getPhoneNumberInternal()", func);
                                        this.handleBapiRet2Table("getPhoneNumberInternal()", PRGN_J2EE_TELNO_CONVERT, func.getTableParameterList().getTable("RETURN"));
                                        R3JCoProxy.ParameterList exp = func.getExportParameterList();
                                        result = new SAPPhoneNumber(exp.getString("EF_COUNTRY"), exp.getString("EF_TELNUMBER"), exp.getString("EF_EXTENSION"));
                                    }
                                    catch (Exception e) {
                                        R3PersistenceBase.LogUtil.logThrowable(2, LOG, "getPhoneNumberInternal()", "Exception during backend access for phone number {0} conversion. Using default construction method. ", new Object[]{extNumber}, e);
                                        result = null;
                                        Object var9_17 = null;
                                        this._backendProxy.releaseClient(client);
                                        break block14;
                                    }
                                    Object var9_16 = null;
                                    this._backendProxy.releaseClient(client);
                                }
                                catch (Throwable throwable) {
                                    Object var9_18 = null;
                                    this._backendProxy.releaseClient(client);
                                    throw throwable;
                                }
                            }
                        }
                        if (result == null) {
                            int lastDash2 = extNumber.lastIndexOf(45);
                            if (lastDash2 == -1) {
                                result = new SAPPhoneNumber(R3USER_PHONE, extNumber, R3USER_PHONE);
                            } else {
                                String number = extNumber.substring(0, lastDash2);
                                String extension = extNumber.substring(lastDash2 + 1);
                                result = extension.length() <= 10 ? new SAPPhoneNumber(R3USER_PHONE, number, extension) : new SAPPhoneNumber(R3USER_PHONE, extNumber, R3USER_PHONE);
                            }
                        }
                        this._phoneNumberExtBuffer.put(extNumber, result);
                        lastDash2 = result;
                        break block15;
                    }
                    catch (RuntimeException e) {
                        R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "getPhoneNumberInternal()", e);
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    R3PersistenceBase.LogUtil.logExiting(LOG, "getPhoneNumberInternal()", result);
                    throw throwable;
                }
            }
            R3PersistenceBase.LogUtil.logExiting(LOG, "getPhoneNumberInternal()", result);
            return sAPPhoneNumber;
        }
        Object var11_10 = null;
        R3PersistenceBase.LogUtil.logExiting(LOG, "getPhoneNumberInternal()", result);
        return lastDash2;
    }

    private String[] getPhoneNumbers(R3JCoProxy.Table table, boolean phone, boolean mobile, boolean fax) {
        ArrayList<String> numbers = new ArrayList<String>(1);
        int i = 0;
        while (i < table.getNumRows()) {
            table.setRow(i);
            String country = table.getString(BAPIADTEL_COUNTRY);
            String std_no = table.getString(BAPIADTEL_STD_NO).trim();
            String subscriber = table.getString(fax ? BAPIADFAX_FAX : BAPIADTEL_TELEPHONE);
            String extension = table.getString(BAPIADTEL_EXTENSION);
            String r3User = table.getString(BAPIADTEL_R_3_USER).trim();
            if (!(phone && (R3USER_MOBILE.equals(r3User) || R3USER_MOBILE_DEFAULT.equals(r3User)) || mobile && (R3USER_PHONE.equals(r3User) || R3USER_PHONE_DEFAULT.equals(r3User)))) {
                boolean isDefaultEntry;
                String number = this.getPhoneNumberExternal(new SAPPhoneNumber(country, subscriber, extension));
                boolean bl = isDefaultEntry = phone && R3USER_PHONE_DEFAULT.equals(r3User) || mobile && R3USER_MOBILE_DEFAULT.equals(r3User) || fax && "X".equals(std_no);
                if (isDefaultEntry) {
                    numbers.add(0, number);
                } else {
                    numbers.add(number);
                }
            }
            ++i;
        }
        return numbers.toArray(new String[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doBapiUserGetDetail(R3JCoProxy.Client client, String uniqueName, String type, IInternalPrincipalDatabag principal) throws Exception {
        String METHOD = "doBapiUserGetDetail()";
        try {
            try {
                R3PersistenceBase.LogUtil.logEntering(LOG, "doBapiUserGetDetail()", new Object[]{client, uniqueName, type, principal});
                String rfcFunc = "BAPI_USER_GET_DETAIL";
                R3JCoProxy.Function getdetail = this.doBapiUserGetDetailInternal(client, uniqueName);
                R3JCoProxy.ParameterList exports = getdetail.getExportParameterList();
                R3JCoProxy.Structure expAddress = exports.getStructure("ADDRESS");
                R3JCoProxy.Structure expCompany = exports.getStructure("COMPANY");
                R3JCoProxy.Structure expLogonData = exports.getStructure("LOGONDATA");
                R3JCoProxy.Structure expDefauls = exports.getStructure("DEFAULTS");
                R3JCoProxy.Structure expRefUser = exports.getStructure("REF_USER");
                R3JCoProxy.ParameterList tables = getdetail.getTableParameterList();
                R3JCoProxy.Table tabReturn = tables.getTable("RETURN");
                this.handleBapiRet2Table("doBapiUserGetDetail()", "BAPI_USER_GET_DETAIL", tabReturn);
                if ("USER".equals(type)) {
                    int i;
                    String[] numbers;
                    R3JCoProxy.Table addtel;
                    if (this.feelsResponsible(type, "com.sap.security.core.usermanagement", "company")) {
                        String company = expCompany.getString("COMPANY");
                        if (!R3USER_PHONE.equals(company)) {
                            principal.addAttributeValue("com.sap.security.core.usermanagement", "company", company);
                        } else {
                            R3PersistenceBase.Util.populateEmptyIfNeeded(principal, "company");
                        }
                    }
                    if (this.feelsResponsible(type, "com.sap.security.core.usermanagement", "companyid")) {
                        String companyId = expCompany.getString("COMPANY");
                        if (!R3USER_PHONE.equals(companyId)) {
                            principal.addAttributeValue("com.sap.security.core.usermanagement", "companyid", companyId);
                        } else {
                            R3PersistenceBase.Util.populateEmptyIfNeeded(principal, "companyid");
                        }
                    }
                    if (this.feelsResponsible(type, "com.sap.security.core.usermanagement", "title")) {
                        String title = expAddress.getString("TITLE_ACA1");
                        if (!R3USER_PHONE.equals(title)) {
                            principal.addAttributeValue("com.sap.security.core.usermanagement", "title", title);
                        } else {
                            R3PersistenceBase.Util.populateEmptyIfNeeded(principal, "title");
                        }
                    }
                    if (this.feelsResponsible(type, "com.sap.security.core.usermanagement", "salutation")) {
                        String salutation = expAddress.getString("TITLE_P");
                        if (!R3USER_PHONE.equals(salutation)) {
                            principal.addAttributeValue("com.sap.security.core.usermanagement", "salutation", salutation);
                        } else {
                            R3PersistenceBase.Util.populateEmptyIfNeeded(principal, "salutation");
                        }
                    }
                    if (this.feelsResponsible(type, "com.sap.security.core.usermanagement", "firstname")) {
                        String firstName = expAddress.getString("FIRSTNAME");
                        if (!R3USER_PHONE.equals(firstName)) {
                            principal.addAttributeValue("com.sap.security.core.usermanagement", "firstname", firstName);
                        } else {
                            R3PersistenceBase.Util.populateEmptyIfNeeded(principal, "firstname");
                        }
                    }
                    if (this.feelsResponsible(type, "com.sap.security.core.usermanagement", "lastname")) {
                        String lastName = expAddress.getString("LASTNAME");
                        if (!R3USER_PHONE.equals(lastName)) {
                            principal.addAttributeValue("com.sap.security.core.usermanagement", "lastname", lastName);
                        } else {
                            R3PersistenceBase.Util.populateEmptyIfNeeded(principal, "lastname");
                        }
                    }
                    if (this.feelsResponsible(type, "com.sap.security.core.usermanagement", "department")) {
                        String department = expAddress.getString("DEPARTMENT");
                        if (!R3USER_PHONE.equals(department)) {
                            principal.addAttributeValue("com.sap.security.core.usermanagement", "department", department);
                        } else {
                            R3PersistenceBase.Util.populateEmptyIfNeeded(principal, "department");
                        }
                    }
                    if (this.feelsResponsible(type, "com.sap.security.core.usermanagement", "jobtitle")) {
                        String jobTitle = expAddress.getString("FUNCTION");
                        if (!R3USER_PHONE.equals(jobTitle)) {
                            principal.addAttributeValue("com.sap.security.core.usermanagement", "jobtitle", jobTitle);
                        } else {
                            R3PersistenceBase.Util.populateEmptyIfNeeded(principal, "jobtitle");
                        }
                    }
                    if (this.feelsResponsible(type, "com.sap.security.core.usermanagement", "telephone")) {
                        addtel = tables.getTable("ADDTEL");
                        numbers = this.getPhoneNumbers(addtel, true, false, false);
                        if (numbers.length > 0) {
                            i = 0;
                            while (i < numbers.length) {
                                principal.addAttributeValue("com.sap.security.core.usermanagement", "telephone", numbers[i]);
                                ++i;
                            }
                        } else {
                            R3PersistenceBase.Util.populateEmptyIfNeeded(principal, "telephone");
                        }
                    }
                    if (this.feelsResponsible(type, "com.sap.security.core.usermanagement", "mobile")) {
                        addtel = tables.getTable("ADDTEL");
                        numbers = this.getPhoneNumbers(addtel, false, true, false);
                        if (numbers.length > 0) {
                            i = 0;
                            while (i < numbers.length) {
                                principal.addAttributeValue("com.sap.security.core.usermanagement", "mobile", numbers[i]);
                                ++i;
                            }
                        } else {
                            R3PersistenceBase.Util.populateEmptyIfNeeded(principal, "mobile");
                        }
                    }
                    if (this.feelsResponsible(type, "com.sap.security.core.usermanagement", "fax")) {
                        R3JCoProxy.Table addfax = tables.getTable("ADDFAX");
                        numbers = this.getPhoneNumbers(addfax, false, false, true);
                        if (numbers.length > 0) {
                            i = 0;
                            while (i < numbers.length) {
                                principal.addAttributeValue("com.sap.security.core.usermanagement", "fax", numbers[i]);
                                ++i;
                            }
                        } else {
                            R3PersistenceBase.Util.populateEmptyIfNeeded(principal, "fax");
                        }
                    }
                    if (this.feelsResponsible(type, "com.sap.security.core.usermanagement", "email")) {
                        String email = expAddress.getString("E_MAIL");
                        if (!R3USER_PHONE.equals(email)) {
                            principal.addAttributeValue("com.sap.security.core.usermanagement", "email", email);
                        } else {
                            R3PersistenceBase.Util.populateEmptyIfNeeded(principal, "email");
                        }
                    }
                    if (this.feelsResponsible(type, "com.sap.security.core.usermanagement", "locale")) {
                        String defaultLanguageSAP;
                        String language = expAddress.getString("LANGUP_ISO");
                        if ((language == null || R3USER_PHONE.equals(language)) && (defaultLanguageSAP = expDefauls.getString("LANGU")) != null) {
                            language = LANGUAGE_SAP_TO_ISO.getProperty(defaultLanguageSAP);
                        }
                        if (language == null || R3USER_PHONE.equals(language)) {
                            R3PersistenceBase.Util.populateEmptyIfNeeded(principal, "locale");
                        } else {
                            StringBuffer locale = new StringBuffer(5);
                            locale.append(language.toLowerCase());
                            String country = expAddress.getString("NAMCOUNTRY");
                            if (!R3USER_PHONE.equals(country)) {
                                locale.append('_').append(country.toUpperCase());
                            }
                            principal.addAttributeValue("com.sap.security.core.usermanagement", "locale", locale.toString());
                        }
                    }
                    if (this.feelsResponsible(type, "com.sap.security.core.usermanagement", "timezone")) {
                        String sapTimeZone = expLogonData.getString("TZONE");
                        if (!R3USER_PHONE.equals(sapTimeZone)) {
                            String javaTimeZone = (String)HASH_SAP_TZ.get(sapTimeZone);
                            if (null == javaTimeZone) throw new PersistenceException("No Java timezone mapped to SAP timezone \"" + sapTimeZone + "\"");
                            principal.addAttributeValue("com.sap.security.core.usermanagement", "timezone", javaTimeZone);
                        } else {
                            R3PersistenceBase.Util.populateEmptyIfNeeded(principal, "timezone");
                        }
                    }
                    if (this.feelsResponsible(type, "com.sap.security.core.usermanagement", "referenceuser")) {
                        String referenceUser = expRefUser.getString("REF_USER");
                        if (!R3USER_PHONE.equals(referenceUser)) {
                            principal.addAttributeValue("com.sap.security.core.usermanagement", "referenceuser", referenceUser);
                        } else {
                            R3PersistenceBase.Util.populateEmptyIfNeeded(principal, "referenceuser");
                        }
                    }
                } else {
                    if (!"UACC".equals(type)) throw new PersistenceException("Unsupported principal type: " + type);
                    if (this.feelsResponsible(type, "com.sap.security.core.usermanagement", "validfrom")) {
                        Date validFrom = expLogonData.getDate("GLTGV");
                        if (null != validFrom) {
                            principal.addAttributeValue("com.sap.security.core.usermanagement", "validfrom", Long.toString(validFrom.getTime()));
                        } else {
                            R3PersistenceBase.Util.populateEmptyIfNeeded(principal, "validfrom");
                        }
                    }
                    if (this.feelsResponsible(type, "com.sap.security.core.usermanagement", "validto")) {
                        Date validTo = expLogonData.getDate("GLTGB");
                        if (null != validTo) {
                            principal.addAttributeValue("com.sap.security.core.usermanagement", "validto", Long.toString(validTo.getTime()));
                        } else {
                            R3PersistenceBase.Util.populateEmptyIfNeeded(principal, "validto");
                        }
                    }
                    if (this.feelsResponsible(type, "com.sap.security.core.usermanagement", "ispassworddisabled")) {
                        String codvn = expLogonData.getString("CODVN");
                        if (null != codvn) {
                            principal.addAttributeValue("com.sap.security.core.usermanagement", "ispassworddisabled", "X".equals(codvn) ? "true" : "false");
                        } else {
                            R3PersistenceBase.Util.populateEmptyIfNeeded(principal, "ispassworddisabled");
                        }
                    }
                }
                Object var20_22 = null;
            }
            catch (Exception e) {
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "doBapiUserGetDetail()", e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var20_23 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "doBapiUserGetDetail()", new Object[]{principal});
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "doBapiUserGetDetail()", new Object[]{principal});
    }

    private void doBapiUserLock(R3JCoProxy.Client client, String uniqueName) throws Exception {
        String METHOD = "doBapiUserLock()";
        try {
            try {
                R3PersistenceBase.LogUtil.logEntering(LOG, "doBapiUserLock()", new Object[]{client, uniqueName});
                String rfcFunc = "BAPI_USER_LOCK";
                R3JCoProxy.Function lockuser = this._backendProxy.getRepository().getFunctionTemplate("BAPI_USER_LOCK").getFunction();
                lockuser.getImportParameterList().setValue(uniqueName, "USERNAME");
                client.execute(lockuser);
                this.logFunction("doBapiUserLock()", lockuser);
                R3PersistenceBase.WeakLRUHashMap.clearAllInstances(uniqueName);
                R3JCoProxy.Table tabReturn = lockuser.getTableParameterList().getTable("RETURN");
                this.handleBapiRet2Table("doBapiUserLock()", "BAPI_USER_LOCK", tabReturn);
            }
            catch (Exception e) {
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "doBapiUserLock()", e);
                throw e;
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "doBapiUserLock()");
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "doBapiUserLock()");
    }

    private void doBapiUserUnlock(R3JCoProxy.Client client, String uniqueName) throws Exception {
        String METHOD = "doBapiUserUnlock()";
        try {
            try {
                R3PersistenceBase.LogUtil.logEntering(LOG, "doBapiUserUnlock()", new Object[]{client, uniqueName});
                String rfcFunc = "BAPI_USER_UNLOCK";
                R3JCoProxy.Function unlockuser = this._backendProxy.getRepository().getFunctionTemplate("BAPI_USER_UNLOCK").getFunction();
                unlockuser.getImportParameterList().setValue(uniqueName, "USERNAME");
                client.execute(unlockuser);
                this.logFunction("doBapiUserUnlock()", unlockuser);
                R3PersistenceBase.WeakLRUHashMap.clearAllInstances(uniqueName);
                R3JCoProxy.Table tabReturn = unlockuser.getTableParameterList().getTable("RETURN");
                this.handleBapiRet2Table("doBapiUserUnlock()", "BAPI_USER_UNLOCK", tabReturn);
            }
            catch (Exception e) {
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "doBapiUserUnlock()", e);
                throw e;
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "doBapiUserUnlock()");
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "doBapiUserUnlock()");
    }

    private void doBapiUserDelete(R3JCoProxy.Client client, String uniqueName) throws Exception {
        String METHOD = "doBapiUserDelete()";
        try {
            try {
                R3PersistenceBase.LogUtil.logEntering(LOG, "doBapiUserDelete()", new Object[]{client, uniqueName});
                String rfcFunc = "BAPI_USER_DELETE";
                R3JCoProxy.Function delete = this._backendProxy.getRepository().getFunctionTemplate("BAPI_USER_DELETE").getFunction();
                delete.getImportParameterList().setValue(uniqueName, "USERNAME");
                client.execute(delete);
                this.logFunction("doBapiUserDelete()", delete);
                R3PersistenceBase.WeakLRUHashMap.clearAllInstances(uniqueName);
                R3JCoProxy.Table tabReturn = delete.getTableParameterList().getTable("RETURN");
                this.handleBapiRet2Table("doBapiUserDelete()", "BAPI_USER_DELETE", tabReturn);
            }
            catch (Exception e) {
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "doBapiUserDelete()", e);
                throw e;
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "doBapiUserDelete()");
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "doBapiUserDelete()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doBapiUserExistenceCheck(R3JCoProxy.Client client, String uniqueName) throws Exception {
        boolean bl;
        String METHOD = "doBapiUserExistenceCheck()";
        Boolean existsObject = null;
        try {
            try {
                R3PersistenceBase.LogUtil.logEntering(LOG, "doBapiUserExistenceCheck()", new Object[]{client, uniqueName});
                String rfcFunc = "BAPI_USER_EXISTENCE_CHECK";
                existsObject = (Boolean)this._bapiUserExistenceCheckCache.get(uniqueName);
                if (existsObject == null) {
                    R3JCoProxy.Function existencecheck = this._backendProxy.getRepository().getFunctionTemplate("BAPI_USER_EXISTENCE_CHECK").getFunction();
                    existencecheck.getImportParameterList().setValue(uniqueName, "USERNAME");
                    client.execute(existencecheck);
                    this.logFunction("doBapiUserExistenceCheck()", existencecheck);
                    R3JCoProxy.Structure structReturn = existencecheck.getExportParameterList().getStructure("RETURN");
                    existsObject = new Boolean("01".equals(structReturn.getString("ID")) && EXISTENCE_CONFIRMED_MSGNO.equals(structReturn.getString("NUMBER")));
                    this._bapiUserExistenceCheckCache.put(uniqueName, existsObject);
                } else {
                    LOG.debugT("doBapiUserExistenceCheck()", "Using buffered data");
                }
                bl = existsObject;
                Object var9_10 = null;
            }
            catch (Exception e) {
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "doBapiUserExistenceCheck()", e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "doBapiUserExistenceCheck()", existsObject);
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "doBapiUserExistenceCheck()", existsObject);
        return bl;
    }

    private void doBapiTransactionCommit(R3JCoProxy.Client client) throws Exception {
        String METHOD = "doBapiTransactionCommit()";
        try {
            try {
                R3PersistenceBase.LogUtil.logEntering(LOG, "doBapiTransactionCommit()", new Object[]{client});
                String rfcFunc = "BAPI_TRANSACTION_COMMIT";
                R3JCoProxy.Function commit = this._backendProxy.getRepository().getFunctionTemplate("BAPI_TRANSACTION_COMMIT").getFunction();
                commit.getImportParameterList().setValue("X", "WAIT");
                client.execute(commit);
                this.logFunction("doBapiTransactionCommit()", commit);
                R3JCoProxy.ParameterList exports = commit.getExportParameterList();
                this.handleBapiRet2Struct("doBapiTransactionCommit()", "BAPI_TRANSACTION_COMMIT", exports.getStructure("RETURN"));
            }
            catch (Exception e) {
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "doBapiTransactionCommit()", e);
                throw e;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "doBapiTransactionCommit()");
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "doBapiTransactionCommit()");
    }

    private void doBapiTransactionRollback(R3JCoProxy.Client client) throws Exception {
        String METHOD = "doBapiTransactionRollback()";
        try {
            try {
                R3PersistenceBase.LogUtil.logEntering(LOG, "doBapiTransactionRollback()", new Object[]{client});
                String rfcFunc = "BAPI_TRANSACTION_ROLLBACK";
                if (client != null) {
                    try {
                        R3JCoProxy.Function rollback = this._backendProxy.getRepository().getFunctionTemplate("BAPI_TRANSACTION_ROLLBACK").getFunction();
                        client.execute(rollback);
                        this.logFunction("doBapiTransactionRollback()", rollback);
                        R3JCoProxy.ParameterList exports = rollback.getExportParameterList();
                        this.handleBapiRet2Struct("doBapiTransactionRollback()", "BAPI_TRANSACTION_ROLLBACK", exports.getStructure("RETURN"));
                    }
                    catch (Exception e) {
                        R3PersistenceBase.LogUtil.logThrowable(1, LOG, "doBapiTransactionRollback()", "Caught exception in rollback from backend", new Object[0], e);
                    }
                }
                Object var7_8 = null;
            }
            catch (Exception e) {
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "doBapiTransactionRollback()", e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "doBapiTransactionRollback()");
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "doBapiTransactionRollback()");
    }

    private void setBapiAddress(R3JCoProxy.Structure bapiaddr3, R3JCoProxy.Structure bapiaddr3x, Map databag) throws Exception {
        String METHOD = "setBapiAddress()";
        try {
            block19: {
                try {
                    R3PersistenceBase.LogUtil.logEntering(LOG, "setBapiAddress()", new Object[]{bapiaddr3, bapiaddr3x, LOG.bePath() ? this.sensitiveMap2s(databag) : null});
                    if (databag.containsKey("salutation")) {
                        if (bapiaddr3x != null) {
                            bapiaddr3x.setValue("X", "TITLE_P");
                        }
                        bapiaddr3.setValue(databag.get("salutation"), "TITLE_P");
                    }
                    if (databag.containsKey("title")) {
                        if (bapiaddr3x != null) {
                            bapiaddr3x.setValue("X", "TITLE_ACA1");
                        }
                        bapiaddr3.setValue(databag.get("title"), "TITLE_ACA1");
                    }
                    if (databag.containsKey("jobtitle")) {
                        if (bapiaddr3x != null) {
                            bapiaddr3x.setValue("X", "FUNCTION");
                        }
                        bapiaddr3.setValue(databag.get("jobtitle"), "FUNCTION");
                    }
                    if (databag.containsKey("department")) {
                        if (bapiaddr3x != null) {
                            bapiaddr3x.setValue("X", "DEPARTMENT");
                        }
                        bapiaddr3.setValue(databag.get("department"), "DEPARTMENT");
                    }
                    if (databag.containsKey("firstname")) {
                        if (bapiaddr3x != null) {
                            bapiaddr3x.setValue("X", "FIRSTNAME");
                        }
                        bapiaddr3.setValue(databag.get("firstname"), "FIRSTNAME");
                    }
                    if (databag.containsKey("lastname")) {
                        if (bapiaddr3x != null) {
                            bapiaddr3x.setValue("X", "LASTNAME");
                        }
                        bapiaddr3.setValue(databag.get("lastname"), "LASTNAME");
                    }
                    if (databag.containsKey("email")) {
                        if (bapiaddr3x != null) {
                            bapiaddr3x.setValue("X", "E_MAIL");
                        }
                        bapiaddr3.setValue(databag.get("email"), "E_MAIL");
                    }
                    if (!databag.containsKey("locale")) break block19;
                    if (bapiaddr3x != null) {
                        bapiaddr3x.setValue("X", "LANGUP_ISO");
                        bapiaddr3x.setValue("X", "LANGU_P");
                        bapiaddr3x.setValue("X", "NAMCOUNTRY");
                    }
                    String[] localeParts = R3PersistenceBase.Util.getLocaleParts((String)databag.get("locale"));
                    bapiaddr3.setValue(localeParts[0].toUpperCase(), "LANGUP_ISO");
                    bapiaddr3.setValue(localeParts[1], "NAMCOUNTRY");
                }
                catch (Exception e) {
                    R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "setBapiAddress()", e);
                    throw e;
                }
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "setBapiAddress()");
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "setBapiAddress()");
    }

    private void setBapiLogonData(R3JCoProxy.Structure bapilogond, R3JCoProxy.Structure bapilogonx, Map databag, String uniqueName) throws Exception {
        String METHOD = "setBapiLogonData()";
        try {
            block15: {
                try {
                    String sapTimeZone;
                    R3PersistenceBase.LogUtil.logEntering(LOG, "setBapiLogonData()", new Object[]{uniqueName, bapilogond, bapilogonx, LOG.bePath() ? this.sensitiveMap2s(databag) : null});
                    if (databag.containsKey("validfrom")) {
                        Object oValidFrom;
                        String strValidFrom = (String)databag.get("validfrom");
                        if (!R3USER_PHONE.equals(strValidFrom)) {
                            long lValidFrom = Long.parseLong(strValidFrom);
                            oValidFrom = new Date(lValidFrom);
                        } else {
                            oValidFrom = strValidFrom;
                        }
                        bapilogond.setValue(oValidFrom, "GLTGV");
                        if (bapilogonx != null) {
                            bapilogonx.setValue("X", "GLTGV");
                        }
                    }
                    if (databag.containsKey("validto")) {
                        Object oValidTo;
                        String strValidTo = (String)databag.get("validto");
                        if (!R3USER_PHONE.equals(strValidTo)) {
                            long lValidTo = Long.parseLong(strValidTo);
                            oValidTo = new Date(lValidTo);
                        } else {
                            oValidTo = strValidTo;
                        }
                        bapilogond.setValue(oValidTo, "GLTGB");
                        if (bapilogonx != null) {
                            bapilogonx.setValue("X", "GLTGB");
                        }
                    }
                    if (!databag.containsKey("timezone")) break block15;
                    String javaTimeZone = (String)databag.get("timezone");
                    if (R3USER_PHONE.equals(javaTimeZone)) {
                        sapTimeZone = R3USER_PHONE;
                    } else {
                        sapTimeZone = (String)HASH_JAVA_TZ.get(javaTimeZone);
                        if (null == sapTimeZone) {
                            throw new PersistenceException("No SAP timezone mapped to Java timezone \"" + javaTimeZone + "\"");
                        }
                    }
                    bapilogond.setValue(sapTimeZone, "TZONE");
                    if (bapilogonx == null) break block15;
                    bapilogonx.setValue("X", "TZONE");
                }
                catch (Exception e) {
                    R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "setBapiLogonData()", e);
                    throw e;
                }
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "setBapiLogonData()");
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "setBapiLogonData()");
    }

    protected void assertResponsibility(DSConfigurationModel configuration) throws Exception {
        Hashtable typeHash = configuration.getResponsibleFor();
        Enumeration typeEnum = typeHash.keys();
        while (typeEnum.hasMoreElements()) {
            String typeKey = (String)typeEnum.nextElement();
            if (!"UACC".equals(typeKey) && !"USER".equals(typeKey)) {
                throw new PersistenceException("Datasource " + this.getId() + ": Unsupported principal type \"" + typeKey + "\". " + "Datasources of type " + (class$com$sap$security$core$persistence$datasource$imp$R3Persistence == null ? (class$com$sap$security$core$persistence$datasource$imp$R3Persistence = R3Persistence.class$("com.sap.security.core.persistence.datasource.imp.R3Persistence")) : class$com$sap$security$core$persistence$datasource$imp$R3Persistence).getName() + " only support principal types \"" + "UACC" + "\" and \"" + "USER" + "\"");
            }
            DSPrincipalModel principal = (DSPrincipalModel)typeHash.get(typeKey);
            Hashtable nsHash = principal.getResponsibleNameSpaceAttributes();
            Enumeration nsEnum = nsHash.keys();
            while (nsEnum.hasMoreElements()) {
                String nsKey = (String)nsEnum.nextElement();
                if (!"com.sap.security.core.usermanagement".equals(nsKey)) {
                    throw new PersistenceException("Datasource " + this.getId() + ": Unsupported namespace \"" + nsKey + ". Datasources of type " + (class$com$sap$security$core$persistence$datasource$imp$R3Persistence == null ? (class$com$sap$security$core$persistence$datasource$imp$R3Persistence = R3Persistence.class$("com.sap.security.core.persistence.datasource.imp.R3Persistence")) : class$com$sap$security$core$persistence$datasource$imp$R3Persistence).getName() + " only support attributes in the namespace \"" + "com.sap.security.core.usermanagement" + "\"");
                }
                Vector attributes = (Vector)nsHash.get(nsKey);
                int numAttributes = attributes.size();
                int i = 0;
                while (i < numAttributes) {
                    String attr = (String)attributes.get(i);
                    if ("UACC".equals(typeKey) ? !"j_user".equals(attr) && !"j_password".equals(attr) && !"userid".equals(attr) && !"islocked".equals(attr) && !"lockreason".equals(attr) && !"passwordchangerequired".equals(attr) && !"ispassworddisabled".equals(attr) && !"validfrom".equals(attr) && !"validto".equals(attr) : !"uniquename".equals(attr) && !"salutation".equals(attr) && !"title".equals(attr) && !"firstname".equals(attr) && !"lastname".equals(attr) && !"email".equals(attr) && !"telephone".equals(attr) && !"mobile".equals(attr) && !"fax".equals(attr) && !"locale".equals(attr) && !"timezone".equals(attr) && !"department".equals(attr) && !"jobtitle".equals(attr) && !"company".equals(attr) && !"companyid".equals(attr) && !"referenceuser".equals(attr)) {
                        throw new PersistenceException("Datasource " + this.getId() + ": Unsupported attribute name \"" + attr + "\". " + "Principal type: " + typeKey + ", namespace: " + nsKey);
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized void doInitTimeZone() throws Exception {
        block11: {
            block10: {
                String METHOD = "doInitTimeZone()";
                try {
                    try {
                        R3PersistenceBase.LogUtil.logEntering(LOG, "doInitTimeZone()");
                        if (_isTimeZoneMappingInitialized) {
                            LOG.debugT("doInitTimeZone()", "Time zone mappings already initialized");
                            Object var9_1 = null;
                            break block10;
                        }
                        InputStream is = UMFactory.getProperties().getInputStream(TIMEZONE_MAPPING);
                        if (null == is) throw new PersistenceException("File timezone.properties not found");
                        Properties p = new Properties();
                        p.load(is);
                        is.close();
                        Iterator iter = ((Hashtable)p).entrySet().iterator();
                        block4: while (true) {
                            String javaId;
                            if (!iter.hasNext()) {
                                LOG.debugT("doInitTimeZone()", "Created timezone mappings: " + HASH_JAVA_TZ.size() + " Java timezone IDs mapped to " + HASH_SAP_TZ.size() + " SAP timezone IDs)");
                                _isTimeZoneMappingInitialized = true;
                                break block11;
                            }
                            Map.Entry entry = iter.next();
                            String sapId = (String)entry.getKey();
                            StringTokenizer st = new StringTokenizer((String)entry.getValue(), ",");
                            if (st.hasMoreTokens()) {
                                javaId = st.nextToken().trim();
                                HASH_SAP_TZ.put(sapId, javaId);
                                HASH_JAVA_TZ.put(javaId, sapId);
                            }
                            while (true) {
                                if (!st.hasMoreTokens()) continue block4;
                                javaId = st.nextToken().trim();
                                HASH_JAVA_TZ.put(javaId, sapId);
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "doInitTimeZone()", e);
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_3 = null;
                    R3PersistenceBase.LogUtil.logExiting(LOG, "doInitTimeZone()");
                    throw throwable;
                }
            }
            R3PersistenceBase.LogUtil.logExiting(LOG, "doInitTimeZone()");
            return;
        }
        Object var9_2 = null;
        R3PersistenceBase.LogUtil.logExiting(LOG, "doInitTimeZone()");
    }

    private static synchronized void doInitLanguageMapping() {
        InputStream is;
        String METHOD = "doInitLanguageMapping()";
        if (_isLanguageMappingInitialized) {
            return;
        }
        Properties defaults = new Properties();
        defaults.setProperty("A", "AR");
        defaults.setProperty("W", "BG");
        defaults.setProperty(R3USER_PHONE_DEFAULT, "ZH");
        defaults.setProperty("M", "ZF");
        defaults.setProperty("6", "HR");
        defaults.setProperty("C", "CS");
        defaults.setProperty("K", "DA");
        defaults.setProperty("N", "NL");
        defaults.setProperty("E", "EN");
        defaults.setProperty("U", "FI");
        defaults.setProperty("F", "FR");
        defaults.setProperty("D", "DE");
        defaults.setProperty("G", "EL");
        defaults.setProperty("B", "HE");
        defaults.setProperty("H", "HU");
        defaults.setProperty("I", "IT");
        defaults.setProperty("J", "JA");
        defaults.setProperty(R3USER_MOBILE_DEFAULT, "KO");
        defaults.setProperty("O", "NO");
        defaults.setProperty("L", "PL");
        defaults.setProperty("P", "PT");
        defaults.setProperty("4", "RO");
        defaults.setProperty("R", "RU");
        defaults.setProperty("d", "SH");
        defaults.setProperty("Q", "SK");
        defaults.setProperty("5", "SL");
        defaults.setProperty("S", "ES");
        defaults.setProperty("V", "SV");
        defaults.setProperty(R3USER_MOBILE, "TH");
        defaults.setProperty("T", "TR");
        defaults.setProperty("a", "AF");
        defaults.setProperty("c", "CA");
        defaults.setProperty("9", "ET");
        defaults.setProperty("i", "ID");
        defaults.setProperty("b", "IS");
        defaults.setProperty("X", "LT");
        defaults.setProperty("Y", "LV");
        defaults.setProperty("7", "MS");
        defaults.setProperty("0", "SR");
        defaults.setProperty("8", "UK");
        LANGUAGE_SAP_TO_ISO = new Properties(defaults);
        try {
            is = UMFactory.getUMFileIO().readFile(LANGUAGE_MAPPING_FILE);
        }
        catch (IOException exc) {
            is = null;
        }
        if (is != null) {
            try {
                LANGUAGE_SAP_TO_ISO.load(is);
                is.close();
            }
            catch (IOException e) {
                R3PersistenceBase.LogUtil.logThrowable(2, LOG, "doInitLanguageMapping()", "Exception during read of language mapping file \"{0}\" from UME properties", new Object[]{LANGUAGE_MAPPING_FILE}, e);
            }
        }
        _isLanguageMappingInitialized = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isComputablePopulation(AttributeList attributeList, String principalType) throws Exception {
        int numAttributes;
        String METHOD = "isComputablePopulation()";
        int isComputablePopulation = 0;
        try {
            try {
                R3PersistenceBase.LogUtil.logEntering(LOG, "isComputablePopulation()", new Object[]{attributeList, principalType});
                if (null == attributeList || 0 == attributeList.getSize()) {
                    isComputablePopulation = 0;
                } else {
                    isComputablePopulation = 1;
                    numAttributes = attributeList.getSize();
                    if ("UACC".equals(principalType)) {
                        int i = 0;
                        while (isComputablePopulation != 0 && i < numAttributes) {
                            String ns = attributeList.getNameSpaceOfAttributeAt(i);
                            String attr = attributeList.getAttributeNameOfAttributeAt(i);
                            isComputablePopulation = "com.sap.security.core.usermanagement".equals(ns) && ("j_user".equals(attr) || "userid".equals(attr)) ? 1 : 0;
                            ++i;
                        }
                    } else if ("USER".equals(principalType)) {
                        int i = 0;
                        while (isComputablePopulation != 0 && i < numAttributes) {
                            String ns = attributeList.getNameSpaceOfAttributeAt(i);
                            String attr = attributeList.getAttributeNameOfAttributeAt(i);
                            isComputablePopulation = "com.sap.security.core.usermanagement".equals(ns) && "uniquename".equals(attr) ? 1 : 0;
                            ++i;
                        }
                    } else {
                        isComputablePopulation = 0;
                    }
                }
                numAttributes = isComputablePopulation;
                Object var9_12 = null;
            }
            catch (Exception e) {
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "isComputablePopulation()", e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            R3PersistenceBase.LogUtil.logEntering(LOG, "isComputablePopulation()", new Object[]{new Boolean(isComputablePopulation != 0)});
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logEntering(LOG, "isComputablePopulation()", new Object[]{new Boolean(isComputablePopulation != 0)});
        return numAttributes != 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isComputableSearch(ISearchAttribute searchAttribute, String principalType) throws Exception {
        boolean bl;
        String METHOD = "isComputableSearch()";
        boolean result = false;
        try {
            try {
                boolean isComputableSearch;
                R3PersistenceBase.LogUtil.logEntering(LOG, "isComputableSearch()", new Object[]{searchAttribute, principalType});
                bl = result = (isComputableSearch = 0 == searchAttribute.getOperator() && "com.sap.security.core.usermanagement".equals(searchAttribute.getAttributeNameSpace()) && "UACC".equals(principalType) && "userid".equals(searchAttribute.getAttributeName()));
                Object var7_7 = null;
            }
            catch (Exception e) {
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "isComputableSearch()", e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "isComputableSearch()", new Boolean(result));
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "isComputableSearch()", new Boolean(result));
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isExistenceCheck(ISearchAttribute searchAttribute, String principalType) throws Exception {
        boolean bl;
        String METHOD = "isExistenceCheck()";
        boolean result = false;
        try {
            try {
                boolean isExistenceCheck;
                R3PersistenceBase.LogUtil.logEntering(LOG, "isExistenceCheck()", new Object[]{searchAttribute, principalType});
                String attribute = searchAttribute.getAttributeName();
                bl = result = (isExistenceCheck = 0 == searchAttribute.getOperator() && "com.sap.security.core.usermanagement".equals(searchAttribute.getAttributeNameSpace()) && ("UACC".equals(principalType) && "j_user".equals(attribute) || "USER".equals(principalType) && "uniquename".equals(attribute)));
                Object var8_8 = null;
            }
            catch (Exception e) {
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "isExistenceCheck()", e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "isExistenceCheck()", new Boolean(result));
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "isExistenceCheck()", new Boolean(result));
        return bl;
    }

    public Object getProperty(String key) throws PersistenceException {
        if (PROPERTY_MAPPING_USREXTID.equals(key)) {
            return this._mappingUSREXTID;
        }
        throw new PersistenceException("Key \"" + key + "\" not supported from R3Persistence");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] getUserNamesForExtID(String extIDType, String extID) throws FeatureNotAvailableException, PersistenceException {
        Object[] objectArray;
        String METHOD = "getUserNamesForExtID()";
        Object[] result = null;
        try {
            try {
                R3PersistenceBase.LogUtil.logEntering(LOG, "getUserNamesForExtID()", new Object[]{extIDType, extID});
                if (this._susrGetUsrextidMappingList == null) {
                    throw new FeatureNotAvailableException();
                }
                R3JCoProxy.Function getMappingList = this._susrGetUsrextidMappingList.getFunction();
                getMappingList.getImportParameterList().setValue(extIDType, "EXTID_TYPE");
                getMappingList.getImportParameterList().setValue(extID, "EXTID_DATA");
                R3JCoProxy.Client client = null;
                try {
                    try {
                        client = this._backendProxy.getClient();
                        client.execute(getMappingList);
                        this.logFunction("getUserNamesForExtID()", getMappingList);
                        R3JCoProxy.Table userlist = getMappingList.getTableParameterList().getTable("USERLIST");
                        int numRows = userlist.getNumRows();
                        result = new String[numRows];
                        int i = 0;
                        while (true) {
                            if (i >= numRows) {
                                objectArray = result;
                                Object var12_17 = null;
                                this._backendProxy.releaseClient(client);
                                break;
                            }
                            userlist.setRow(i);
                            result[i] = userlist.getString("BAPIBNAME");
                            ++i;
                        }
                    }
                    catch (R3JCoProxy.R3ABAPException abapException) {
                        if (!"NO_MAPPING_FOUND".equals(abapException.getKey())) throw abapException;
                        Object[] numRows = result = null;
                        Object var12_18 = null;
                        this._backendProxy.releaseClient(client);
                        Object var14_21 = null;
                        R3PersistenceBase.LogUtil.logExiting(LOG, "getUserNamesForExtID()", result);
                        return numRows;
                    }
                    catch (R3JCoProxy.R3JCoException jcoException) {
                        if (jcoException.getGroup() != 104) throw jcoException;
                        this._susrGetUsrextidMappingList = null;
                        throw new FeatureNotAvailableException();
                    }
                }
                catch (Throwable throwable) {
                    Object var12_19 = null;
                    this._backendProxy.releaseClient(client);
                    throw throwable;
                }
                Object var14_20 = null;
            }
            catch (FeatureNotAvailableException fnae) {
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "getUserNamesForExtID()", fnae);
                throw fnae;
            }
            catch (Exception e) {
                PersistenceException pe = this.newPersistenceException(LOG, "getUserNamesForExtID()", e);
                R3PersistenceBase.LogUtil.exitMethodWithException(LOG, "getUserNamesForExtID()", (Throwable)((Object)pe));
                throw pe;
            }
        }
        catch (Throwable throwable) {
            Object var14_22 = null;
            R3PersistenceBase.LogUtil.logExiting(LOG, "getUserNamesForExtID()", result);
            throw throwable;
        }
        R3PersistenceBase.LogUtil.logExiting(LOG, "getUserNamesForExtID()", result);
        return objectArray;
    }

    public static ATSInterface[] getInstancesForATS() {
        return _instances.toArray(new ATSInterface[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _isLanguageMappingInitialized = false;
        LOCKED_ADMIN = Integer.toString(2);
        LOCKED_AUTO = Integer.toString(1);
        LOCKED_NO = Integer.toString(0);
        _instances = new ArrayList(1);
    }

    public class ATSInterface {
        public String getPoolID() {
            return "Feature not available any more. ATS tests do not exist for this class yet";
        }
    }

    public static interface IMappingWithUSREXTID {
        public String getLogicalSystem();

        public String[] getUserNamesForExtID(String var1, String var2) throws FeatureNotAvailableException, PersistenceException;
    }

    private class R3PersistenceTransaction
    implements IDataSourceTransaction {
        private static final int CREATE = 1;
        private static final int DELETE = 2;
        private static final int UPDATE = 3;
        private ArrayList _actions = new ArrayList(2);

        public boolean bindNewPrincipalDatabag(IInternalPrincipalDatabag principal) throws PersistenceException {
            LOG.entering("R3PersistenceTransaction.bindNewPrincipalDatabag()", new Object[]{principal});
            boolean result = R3Persistence.this.bindNewPrincipalDatabag(principal);
            LOG.exiting("R3PersistenceTransaction.bindNewPrincipalDatabag()", new Boolean(result));
            return result;
        }

        public void createPrincipalDatabag(IInternalPrincipalDatabag principal) throws PersistenceException {
            LOG.debugT("R3PersistenceTransaction.createPrincipalDatabag()", "Storing incoming principal only");
            this._actions.add(new R3PersistenceAction(1, principal));
        }

        public void updatePrincipalDatabag(IInternalPrincipalDatabagMaint principalMaint) throws PersistenceException {
            LOG.debugT("R3PersistenceTransaction.updatePrincipalDatabag()", "Storing incoming principal only");
            this._actions.add(new R3PersistenceAction(3, principalMaint));
        }

        public void deletePrincipalDatabag(IPrincipalDatabag principal) throws PersistenceException {
            LOG.debugT("R3PersistenceTransaction.deletePrincipalDatabag()", "Storing incoming principal only");
            this._actions.add(new R3PersistenceAction(2, principal));
        }

        public void commit() throws PersistenceException {
            String METHOD = "R3PersistenceTransaction.commit()";
            try {
                LOG.entering("R3PersistenceTransaction.commit()");
                int currentPos = 0;
                while (currentPos < this._actions.size()) {
                    R3PersistenceAction action = (R3PersistenceAction)this._actions.get(currentPos);
                    switch (action.action) {
                        case 1: {
                            IInternalPrincipalDatabag accountDatabag = null;
                            if ("USER".equals(action.type)) {
                                String uniqueID = action.principal.getUniqueID();
                                int scanPos = currentPos + 1;
                                while (scanPos < this._actions.size()) {
                                    R3PersistenceAction scanAction = (R3PersistenceAction)this._actions.get(scanPos);
                                    R3PersistenceBase.PrincipalDatabagWrapper scanActionPrincipalX = new R3PersistenceBase.PrincipalDatabagWrapper(scanAction.principal);
                                    if (scanAction.action == 1 && "UACC".equals(scanAction.type) && uniqueID.equals(scanActionPrincipalX.getValues("com.sap.security.core.usermanagement", "userid").getOnlyElement())) {
                                        accountDatabag = (IInternalPrincipalDatabag)scanAction.principal;
                                        this._actions.remove(scanPos);
                                        break;
                                    }
                                    ++scanPos;
                                }
                            }
                            R3Persistence.this.createPrincipalDatabag((IInternalPrincipalDatabag)action.principal, accountDatabag);
                            break;
                        }
                        case 3: {
                            R3Persistence.this.updatePrincipalDatabag((IInternalPrincipalDatabagMaint)action.principal);
                            break;
                        }
                        case 2: {
                            R3Persistence.this.deletePrincipalDatabag((IInternalPrincipalDatabag)action.principal);
                            break;
                        }
                        default: {
                            throw new PersistenceException("Unknown action type " + action.action + " stored");
                        }
                    }
                    ++currentPos;
                }
                Object var10_9 = null;
                this._actions.clear();
                LOG.exiting("R3PersistenceTransaction.commit()");
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                this._actions.clear();
                LOG.exiting("R3PersistenceTransaction.commit()");
                throw throwable;
            }
        }

        public void rollback() throws PersistenceException {
            String METHOD = "R3PersistenceTransaction.rollback()";
            R3PersistenceBase.LogUtil.logEntering(LOG, "R3PersistenceTransaction.rollback()");
            this._actions.clear();
            R3PersistenceBase.LogUtil.logExiting(LOG, "R3PersistenceTransaction.rollback()");
        }

        private class R3PersistenceAction {
            public final int action;
            public final String type;
            public final IPrincipalDatabag principal;

            public R3PersistenceAction(int action, IPrincipalDatabag principal) throws PersistenceException {
                this.action = action;
                this.principal = principal;
                this.type = principal.getIDParts()[0];
            }

            public String toString() {
                StringBuffer sb = new StringBuffer();
                sb.append("Action ");
                switch (this.action) {
                    case 1: {
                        sb.append("CREATE");
                        break;
                    }
                    case 2: {
                        sb.append("DELETE");
                        break;
                    }
                    case 3: {
                        sb.append("UPDATE");
                        break;
                    }
                    default: {
                        sb.append("Unknown(" + this.action + ")");
                    }
                }
                sb.append(": ");
                sb.append(this.principal.getUniqueID());
                return sb.toString();
            }
        }
    }

    private static class SAPPhoneNumber {
        public final String country;
        public final String number;
        public final String extension;

        public SAPPhoneNumber(String country, String number, String extension) {
            this.country = country != null ? country.trim() : R3Persistence.R3USER_PHONE;
            this.number = number != null ? number.trim() : R3Persistence.R3USER_PHONE;
            this.extension = extension != null ? extension.trim() : R3Persistence.R3USER_PHONE;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SAPPhoneNumber) {
                SAPPhoneNumber sapNumber = (SAPPhoneNumber)obj;
                return this.country.equals(sapNumber.country) && this.number.equals(sapNumber.number) && this.extension.equals(sapNumber.extension);
            }
            return false;
        }

        public int hashCode() {
            return this.country.hashCode() ^ this.number.hashCode() ^ this.extension.hashCode();
        }

        public String toString() {
            return "SAPPhoneNumber(country=\"" + this.country + "\", number=\"" + this.number + "\", extension=\"" + this.extension + "\")";
        }
    }
}

