/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp;

import com.sap.mw.jco.IFunctionTemplate;
import com.sap.mw.jco.JCO;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.datasource.imp.R3JCoProxy;
import com.sap.security.core.util.IUMTrace;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

public class R3JCo640Proxy
extends R3JCoProxy {
    private static final IUMTrace LOG = InternalUMFactory.getTrace((class$com$sap$security$core$persistence$datasource$imp$R3JCo640Proxy == null ? (class$com$sap$security$core$persistence$datasource$imp$R3JCo640Proxy = R3JCo640Proxy.class$("com.sap.security.core.persistence.datasource.imp.R3JCo640Proxy")) : class$com$sap$security$core$persistence$datasource$imp$R3JCo640Proxy).getName());
    private static final int DEFAULT_POOL_SIZE = 5;
    private static final long DEFAULT_WAIT_TIME = 10000L;
    private static int _poolCounter = 0;
    private String _poolName;
    private int _poolSize;
    private HashSet _clients;
    private Repository640 _repository;
    private long _classCreation;
    private int _numberTakenOut = 0;
    private int _numberPutBack = 0;
    static /* synthetic */ Class class$com$sap$security$core$persistence$datasource$imp$R3JCo640Proxy;

    R3JCo640Proxy(Properties umeProperties) throws R3JCoProxy.R3JCoException {
        long maxwait;
        String value = umeProperties.getProperty("poolmaxsize");
        if (value != null && !"".equals(value)) {
            try {
                this._poolSize = Integer.parseInt(value);
            }
            catch (Exception e) {
                LOG.logWarningT("UME configuration parameter \"poolmaxsize\" is no integer. Using default value.", null);
                this._poolSize = 5;
            }
        } else {
            this._poolSize = 5;
        }
        if ((value = umeProperties.getProperty("poolmaxwait")) != null && !"".equals(value)) {
            try {
                maxwait = Long.parseLong(value);
            }
            catch (Exception e) {
                LOG.logWarningT("UME configuration parameter \"poolmaxwait\" is no integer. Using default value.", null);
                maxwait = 10000L;
            }
        } else {
            maxwait = 10000L;
        }
        Properties pJCo = new Properties();
        Iterator iter = ((Hashtable)umeProperties).keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if ("RFCDestination".equals(key)) continue;
            String propVal = (String)((Hashtable)umeProperties).get(key);
            ((Hashtable)pJCo).put("jco.client." + key, propVal);
        }
        this._poolName = this.getClass().getName() + "_" + System.currentTimeMillis() + "_" + ++_poolCounter;
        this._classCreation = System.currentTimeMillis();
        try {
            JCO.addClientPool((String)this._poolName, (int)this._poolSize, (Properties)pJCo);
            JCO.getClientPoolManager().getPool(this._poolName).setMaxWaitTime(maxwait);
        }
        catch (JCO.Exception exc) {
            throw new R3JCoException640(exc);
        }
        this._clients = new HashSet(this._poolSize);
        this._repository = new Repository640(this._poolName + "Repository", this._poolName);
    }

    public R3JCoProxy.Repository getRepository() {
        return this._repository;
    }

    public R3JCoProxy.Client getClient() {
        Client640 client = new Client640();
        HashSet hashSet = this._clients;
        synchronized (hashSet) {
            this._clients.add(client);
        }
        return client;
    }

    public void releaseClient(R3JCoProxy.Client client) {
        if (client == null) {
            return;
        }
        Client640 client640 = (Client640)client;
        if (client640.__jcoclient != null) {
            client640.__released = true;
            ++this._numberPutBack;
            JCO.releaseClient((JCO.Client)client640.__jcoclient);
        }
        HashSet hashSet = this._clients;
        synchronized (hashSet) {
            this._clients.remove(client);
        }
    }

    private String getPoolStatus() {
        StringBuffer buf = new StringBuffer();
        buf.append("Current status of connection pool with ID " + this._poolName + ":\n");
        buf.append("  Created on " + new Date(this._classCreation).toString() + "\n");
        buf.append("  Clients obtained by application code: " + this._numberTakenOut + ", returned: " + this._numberPutBack + "\n");
        long currentTime = System.currentTimeMillis();
        int clientCounter = 0;
        Iterator it = this._clients.iterator();
        while (it.hasNext()) {
            Client640 client640 = (Client640)it.next();
            if (client640.__jcoclient == null) continue;
            buf.append("  Client " + clientCounter + " fetched " + (currentTime - client640.__clientFetchTime) + " ms ago from thread \"" + client640.__clientFetchThreadName + "\"\n");
            if (client640.__calls.size() == 0) {
                buf.append("    No application function call on this client yet\n");
            } else {
                Iterator callIt = client640.__calls.iterator();
                while (callIt.hasNext()) {
                    CallLine call = (CallLine)callIt.next();
                    buf.append("    Backend function " + call.function + ", started " + (currentTime - call.callStart) + " ms ago, ");
                    if (call.callEnd == 0L) {
                        buf.append("still active\n");
                        continue;
                    }
                    buf.append("duration: " + (call.callEnd - call.callStart) + " ms\n");
                }
            }
            ++clientCounter;
        }
        buf.append("Number of connections lent out by the application: " + clientCounter + "\n");
        buf.append("Configured maximum number of connections         : " + this._poolSize + "\n");
        if (clientCounter == this._poolSize - 1) {
            buf.append("The difference of one can be caused by the repository connection of the Java Connector and does not indicate a defect.\n");
        } else if (clientCounter < this._poolSize - 1) {
            buf.append("There is a significant difference between configured and available number of connections. This might indicate an implementation defect in the Java Connector (engine component \"com.sap.mw.jco\").\n");
        }
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class R3ABAPException640
    extends R3JCoProxy.R3ABAPException {
        private JCO.AbapException _abapException;

        R3ABAPException640(JCO.AbapException abapException) {
            super(abapException);
            this._abapException = abapException;
        }

        public String getKey() {
            return this._abapException.getKey();
        }

        public int getGroup() {
            int jcoErrorGroup = this._abapException.getGroup();
            switch (jcoErrorGroup) {
                case 104: {
                    return 104;
                }
            }
            return 99999;
        }

        public String toString() {
            return this._abapException.toString();
        }
    }

    private static class R3JCoException640
    extends R3JCoProxy.R3JCoException {
        private JCO.Exception _jcoException;

        R3JCoException640(JCO.Exception jcoException) {
            super((Throwable)jcoException);
            this._jcoException = jcoException;
        }

        public int getGroup() {
            int jcoErrorGroup = this._jcoException.getGroup();
            switch (jcoErrorGroup) {
                case 104: {
                    return 104;
                }
            }
            return 99999;
        }

        public String toString() {
            return this._jcoException.toString();
        }
    }

    private static class ParameterList640
    implements R3JCoProxy.ParameterList {
        private JCO.ParameterList _list;

        ParameterList640(JCO.ParameterList list) {
            this._list = list;
        }

        public int getFieldCount() {
            return this._list.getFieldCount();
        }

        public String getString(String field) {
            return this._list.getString(field);
        }

        public R3JCoProxy.Structure getStructure(String name) {
            JCO.Structure structure = this._list.getStructure(name);
            return structure != null ? new Structure640(structure) : null;
        }

        public R3JCoProxy.Table getTable(String tableName) {
            JCO.Table table = this._list.getTable(tableName);
            return table != null ? new Table640(table) : null;
        }

        public boolean hasField(String field) {
            return this._list.hasField(field);
        }

        public void setActive(boolean active, int i) {
            this._list.setActive(active, i);
        }

        public void setActive(boolean active, String field) {
            this._list.setActive(active, field);
        }

        public void setValue(byte value, String field) {
            this._list.setValue(value, field);
        }

        public void setValue(int value, String field) {
            this._list.setValue(value, field);
        }

        public void setValue(Object value, String field) {
            this._list.setValue(value, field);
        }

        public String toString() {
            return this._list.toString();
        }
    }

    private static class FunctionTemplate640
    implements R3JCoProxy.FunctionTemplate {
        private IFunctionTemplate _template;

        FunctionTemplate640(IFunctionTemplate template) {
            this._template = template;
        }

        public R3JCoProxy.Function getFunction() {
            JCO.Function function = this._template.getFunction();
            return function != null ? new Function640(function) : null;
        }

        public String toString() {
            return this._template.toString();
        }
    }

    private static class Structure640
    implements R3JCoProxy.Structure {
        private JCO.Structure _structure;

        Structure640(JCO.Structure structure) {
            this._structure = structure;
        }

        public String getString(String field) {
            return this._structure.getString(field);
        }

        public Date getDate(String field) {
            return this._structure.getDate(field);
        }

        public void setValue(Object value, String field) {
            this._structure.setValue(value, field);
        }

        public String toString() {
            return this._structure.toString();
        }
    }

    private static class Table640
    implements R3JCoProxy.Table {
        private JCO.Table _table;

        Table640(JCO.Table table) {
            this._table = table;
        }

        public int getNumRows() {
            return this._table.getNumRows();
        }

        public String getString(String field) {
            return this._table.getString(field);
        }

        public void setRow(int row) {
            this._table.setRow(row);
        }

        public void appendRow() {
            this._table.appendRow();
        }

        public void setValue(int value, String field) {
            this._table.setValue(value, field);
        }

        public void setValue(String value, String field) {
            this._table.setValue(value, field);
        }

        public int getInt(String field) {
            return this._table.getInt(field);
        }

        public int getNumColumns() {
            return this._table.getNumColumns();
        }

        public Object getValue(int i) {
            return this._table.getValue(i);
        }

        public Object getValue(String field) {
            return this._table.getValue(field);
        }

        public boolean isEmpty() {
            return this._table.isEmpty();
        }

        public void setValue(Object o, int i) {
            this._table.setValue(o, i);
        }

        public void setValue(Object value, String field) {
            this._table.setValue(value, field);
        }

        public char getChar(String field) {
            return this._table.getChar(field);
        }

        public void deleteRow() {
            this._table.deleteRow();
        }

        public String toString() {
            return this._table.toString();
        }
    }

    private static class Attributes640
    implements R3JCoProxy.Attributes {
        private JCO.Attributes _attributes;

        Attributes640(JCO.Attributes attributes) {
            this._attributes = attributes;
        }

        public String getClient() {
            return this._attributes.getClient();
        }

        public String getSystemID() {
            return this._attributes.getSystemID();
        }

        public String getUser() {
            return this._attributes.getUser();
        }

        public String toString() {
            return this._attributes.toString();
        }
    }

    private static class Function640
    implements R3JCoProxy.Function {
        private JCO.Function _function;

        Function640(JCO.Function function) {
            this._function = function;
        }

        public String getName() {
            return this._function.getName();
        }

        public void writeHTML(StringWriter writer) throws IOException {
            this._function.writeHTML((Writer)writer);
        }

        public R3JCoProxy.ParameterList getExportParameterList() {
            JCO.ParameterList list = this._function.getExportParameterList();
            return list != null ? new ParameterList640(list) : null;
        }

        public R3JCoProxy.ParameterList getImportParameterList() {
            JCO.ParameterList list = this._function.getImportParameterList();
            return list != null ? new ParameterList640(list) : null;
        }

        public R3JCoProxy.ParameterList getTableParameterList() {
            JCO.ParameterList list = this._function.getTableParameterList();
            return list != null ? new ParameterList640(list) : null;
        }

        public String toString() {
            return this._function.toString();
        }
    }

    private static class Repository640
    implements R3JCoProxy.Repository {
        private JCO.Repository __repository;

        Repository640(String name, String pool) {
            this.__repository = new JCO.Repository(name, pool);
        }

        public R3JCoProxy.FunctionTemplate getFunctionTemplate(String functionName) throws R3JCoProxy.R3JCoException {
            try {
                IFunctionTemplate functionTemplate = this.__repository.getFunctionTemplate(functionName);
                return functionTemplate != null ? new FunctionTemplate640(functionTemplate) : null;
            }
            catch (JCO.Exception exc) {
                throw new R3JCoException640(exc);
            }
        }

        public String toString() {
            return this.__repository.toString();
        }
    }

    public class Client640
    implements R3JCoProxy.Client {
        private JCO.Client __jcoclient = null;
        private long __clientFetchTime;
        private String __clientFetchThreadName;
        private boolean __released = false;
        private LinkedList __calls = new LinkedList();

        public void execute(R3JCoProxy.Function func) throws R3JCoProxy.R3ABAPException, R3JCoProxy.R3JCoException {
            this.fetchClient();
            CallLine call = new CallLine();
            call.function = func.getName();
            call.callStart = System.currentTimeMillis();
            this.__calls.add(call);
            try {
                this.__jcoclient.execute(((Function640)func)._function);
            }
            catch (JCO.AbapException abapException) {
                throw new R3ABAPException640(abapException);
            }
            catch (JCO.Exception jcoException) {
                throw new R3JCoException640(jcoException);
            }
            call.callEnd = System.currentTimeMillis();
        }

        public R3JCoProxy.Attributes getAttributes() throws R3JCoProxy.R3JCoException {
            try {
                this.fetchClient();
                JCO.Attributes attributes = this.__jcoclient.getAttributes();
                return attributes != null ? new Attributes640(attributes) : null;
            }
            catch (JCO.Exception exc) {
                throw new R3JCoException640(exc);
            }
        }

        private void fetchClient() {
            String METHOD = "fetchClient()";
            if (this.__released) {
                throw new RuntimeException("JCO Client-Proxy re-used although already released");
            }
            if (this.__jcoclient == null) {
                try {
                    this.__jcoclient = JCO.getClient((String)R3JCo640Proxy.this._poolName);
                    R3JCo640Proxy.this._numberTakenOut++;
                    this.__clientFetchTime = System.currentTimeMillis();
                    this.__clientFetchThreadName = Thread.currentThread().getName();
                }
                catch (JCO.Exception exc) {
                    if (exc.getGroup() == 106) {
                        String poolStatus;
                        LOG.warningT("fetchClient()", "Caught original JCO.Exception with message \"" + exc.getMessage() + "\"", exc);
                        HashSet hashSet = R3JCo640Proxy.this._clients;
                        synchronized (hashSet) {
                            poolStatus = R3JCo640Proxy.this.getPoolStatus();
                        }
                        throw new JCO.Exception(exc.getGroup(), exc.getKey(), exc.getMessage() + "\n" + poolStatus);
                    }
                    throw exc;
                }
            }
        }
    }

    private static class CallLine {
        private String function;
        private long callStart;
        private long callEnd;

        private CallLine() {
        }

        public String toString() {
            return "CallLine: Function " + this.function + ", Start " + (this.callStart != 0L ? new Date(this.callStart).toString() : "not set") + ", End " + (this.callEnd != 0L ? new Date(this.callEnd).toString() : "not set");
        }
    }
}

