/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp;

import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.util.IUMTrace;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;

public class OracleNativeUtil {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/OracleNativeUtil.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";
    private static IUMTrace mTrace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/OracleNativeUtil.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)");
    private Short formNchar;
    private Class oraclePreparedStmt;
    private Method oracleSetFormOfUse;
    private Method oracleGetClobOutputStream = null;
    private Method oracleGetBlobOutputStream = null;
    private Method oracleGetEmptyBlob = null;
    private Method oracleGetEmptyClob = null;
    private Object[] emptyArgument = new Object[0];

    public void oracleSetFormOfUseNchar(PreparedStatement stmt, int index) throws PersistenceException {
        try {
            if (this.oraclePreparedStmt == null) {
                this.oraclePreparedStmt = Class.forName("oracle.jdbc.OraclePreparedStatement");
            }
            if (this.oracleSetFormOfUse == null) {
                Class[] parameterTypes = new Class[]{Integer.TYPE, Short.TYPE};
                this.oracleSetFormOfUse = this.oraclePreparedStmt.getMethod("setFormOfUse", parameterTypes);
            }
            if (this.formNchar == null) {
                Field formNcharField = this.oraclePreparedStmt.getField("FORM_NCHAR");
                short formNcharFieldShort = formNcharField.getShort(stmt);
                this.formNchar = new Short(formNcharFieldShort);
            }
            Object[] args = new Object[]{new Integer(index), this.formNchar};
            this.oracleSetFormOfUse.invoke((Object)stmt, args);
        }
        catch (ClassNotFoundException e) {
            throw new PersistenceException(e);
        }
        catch (NoSuchMethodException e) {
            throw new PersistenceException(e);
        }
        catch (NoSuchFieldException e) {
            throw new PersistenceException(e);
        }
        catch (IllegalAccessException e) {
            throw new PersistenceException(e);
        }
        catch (InvocationTargetException e) {
            throw new PersistenceException(e);
        }
    }

    public Blob oracleGetEmptyBlob() throws PersistenceException {
        if (this.oracleGetEmptyBlob == null) {
            try {
                Class<?> oraBlobClass = Class.forName("oracle.sql.BLOB");
                this.oracleGetEmptyBlob = oraBlobClass.getMethod("empty_lob", new Class[0]);
            }
            catch (ClassNotFoundException cnf) {
                throw new PersistenceException(cnf);
            }
            catch (NoSuchMethodException nse) {
                throw new PersistenceException(nse);
            }
        }
        try {
            return (Blob)this.oracleGetEmptyBlob.invoke(null, this.emptyArgument);
        }
        catch (IllegalAccessException iae) {
            throw new PersistenceException(iae);
        }
        catch (InvocationTargetException ite) {
            throw new PersistenceException(ite);
        }
    }

    public Clob oracleGetEmptyClob() throws PersistenceException {
        if (this.oracleGetEmptyClob == null) {
            try {
                Class<?> oraClobClass = Class.forName("oracle.sql.CLOB");
                this.oracleGetEmptyClob = oraClobClass.getMethod("empty_lob", new Class[0]);
            }
            catch (ClassNotFoundException cnf) {
                throw new PersistenceException(cnf);
            }
            catch (NoSuchMethodException nse) {
                throw new PersistenceException(nse);
            }
        }
        try {
            return (Clob)this.oracleGetEmptyClob.invoke(null, this.emptyArgument);
        }
        catch (IllegalAccessException iae) {
            throw new PersistenceException(iae);
        }
        catch (InvocationTargetException ite) {
            throw new PersistenceException(ite);
        }
    }

    public void oracleWriteClob(Clob clob, String value) throws PersistenceException {
        if (this.oracleGetClobOutputStream == null) {
            try {
                this.oracleGetClobOutputStream = clob.getClass().getMethod("getCharacterOutputStream", new Class[0]);
            }
            catch (NoSuchMethodException nse) {
                throw new PersistenceException(nse);
            }
        }
        try {
            Writer writer = (Writer)this.oracleGetClobOutputStream.invoke((Object)clob, this.emptyArgument);
            writer.write(value);
            writer.flush();
            writer.close();
        }
        catch (IllegalAccessException iae) {
            throw new PersistenceException(iae);
        }
        catch (InvocationTargetException ite) {
            throw new PersistenceException(ite);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
    }

    public void oracleWriteBlob(Blob blob, byte[] binary) throws PersistenceException {
        if (this.oracleGetBlobOutputStream == null) {
            try {
                this.oracleGetBlobOutputStream = blob.getClass().getMethod("getBinaryOutputStream", new Class[0]);
            }
            catch (NoSuchMethodException nse) {
                throw new PersistenceException(nse);
            }
        }
        try {
            OutputStream os = (OutputStream)this.oracleGetBlobOutputStream.invoke((Object)blob, this.emptyArgument);
            os.write(binary);
            os.flush();
            os.close();
        }
        catch (IllegalAccessException iae) {
            throw new PersistenceException(iae);
        }
        catch (InvocationTargetException ite) {
            throw new PersistenceException(ite);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
    }
}

