/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.UMFactory;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.IInternalPrincipalDatabag;
import com.sap.security.core.persistence.IInternalPrincipalDatabagMaint;
import com.sap.security.core.persistence.IPrincipalDatabag;
import com.sap.security.core.persistence.datasource.DuplicateKeyException;
import com.sap.security.core.persistence.datasource.IDataSource;
import com.sap.security.core.persistence.datasource.IDataSourceTransaction;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.datasource.imp.AccessAudit;
import com.sap.security.core.persistence.datasource.imp.DSConfigurationModel;
import com.sap.security.core.persistence.datasource.imp.DSNameSpaceModel;
import com.sap.security.core.persistence.datasource.imp.DSPrincipalModel;
import com.sap.security.core.persistence.datasource.imp.DataSourceBaseImplementation;
import com.sap.security.core.persistence.datasource.imp.JNDIUtils;
import com.sap.security.core.persistence.datasource.imp.LDAPConnectionManager;
import com.sap.security.core.persistence.datasource.imp.LDAPDataSourceConnectionPool;
import com.sap.security.core.persistence.datasource.imp.LDAPDataSourceTransaction;
import com.sap.security.core.persistence.imp.PrincipalDatabag;
import com.sap.security.core.persistence.imp.SearchCriteria;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.cache.ICache;
import com.sap.tc.logging.Location;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.PartialResultException;
import javax.naming.SizeLimitExceededException;
import javax.naming.TimeLimitExceededException;
import javax.naming.directory.Attribute;
import javax.naming.directory.AttributeInUseException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class LDAPPersistence
extends DataSourceBaseImplementation
implements IDataSource {
    private static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/LDAPPersistence.java#9 $ from $DateTime: 2005/01/21 16:34:10 $ ($Change: 17855 $)";
    private static IUMTrace trace = null;
    private static final Location myLoc = Location.getLocation((Class)(class$com$sap$security$core$persistence$datasource$imp$LDAPPersistence == null ? (class$com$sap$security$core$persistence$datasource$imp$LDAPPersistence = LDAPPersistence.class$("com.sap.security.core.persistence.datasource.imp.LDAPPersistence")) : class$com$sap$security$core$persistence$datasource$imp$LDAPPersistence));
    private static IUMParameters props = null;
    private static final String NO_MAPPING = "*null*";
    private static final char WILDCARD = '*';
    private static final char ESCAPE_CHARACTER = '\\';
    private static final String PRINCIPAL_SEPARATOR = ".";
    private Hashtable mm_principalPaths = null;
    private Hashtable mm_principalObjectclasses = null;
    private Hashtable mm_principalAuxiliaryObjectclasses = null;
    private Hashtable mm_principalNamingAttributes = null;
    private Hashtable mm_principalAuxiliaryNamingAttributes = null;
    private Hashtable mm_principalCreationPaths = null;
    private Hashtable mm_principalUniqueAttributes = null;
    private int mm_flatUserGroupHierachy;
    private boolean mm_dynamicGroups = false;
    private boolean mm_userAsUseraccount = false;
    private String mm_dynamicMemberAttribute = null;
    private String mm_serverType = null;
    private String mm_socketFactory = null;
    private boolean mm_sslEnabled = false;
    private String mm_sslSocketFactory = null;
    private int mm_action_retrial;
    private boolean mm_fail_over = false;
    private int mm_size_limit;
    private int mm_time_limit;
    private final String SIEMENS_ALIAS = "SIEMENS";
    private final String MSADS_ALIAS = "MSADS";
    private final String OBJECTCLASS_ALIAS = "objectclass";
    private static final String FLAT_GROUP_HIERACHY = "ume.ldap.access.flat_group_hierachy";
    private static final String DYNAMIC_GROUPS = "ume.ldap.access.dynamic_groups";
    private static final String DYNAMIC_GROUP_ATTRIBUTE = "ume.ldap.access.dynamic_group_attribute";
    private static final String SERVER_TYPE = "ume.ldap.access.server_type";
    private static final String OBJECTCLASS = "ume.ldap.access.objectclass.";
    private static final String AUX_OBJECTCLASS = "ume.ldap.access.auxiliary_objectclass.";
    private static final String NAMINGATTRIBUTE = "ume.ldap.access.naming_attribute.";
    private static final String AUXILIARY_NAMINGATTRIBUTE = "ume.ldap.access.auxiliary_naming_attribute.";
    private static final String CREATIONPATH = "ume.ldap.access.creation_path.";
    private static final String MSADS_CONTROL_ATTRIBUTE = "ume.ldap.access.msads.control_attribute";
    private static final String MSADS_CONTROL_VALUE = "ume.ldap.access.msads.control_value";
    private static final String SIZE_LIMIT = "ume.ldap.access.size_limit";
    private static final String TIME_LIMIT = "ume.ldap.access.time_limit";
    protected static final String USER_AS_USERACCOUNT = "ume.ldap.access.user_as_account";
    protected static final String PATH = "ume.ldap.access.base_path.";
    protected static final String SERVERUSER = "ume.ldap.access.user";
    protected static final String SERVERNAME = "ume.ldap.access.server_name";
    protected static final String SERVERPORT = "ume.ldap.access.server_port";
    protected static final String SSL = "ume.ldap.access.ssl";
    protected static final String SSLSOCKETFACTORY = "ume.ldap.access.ssl_socket_factory";
    protected static final String SERVERUSERPWD = "ume.ldap.access.password";
    protected static final String SOCKETFACTORY = "ume.ldap.access.context_factory";
    protected static final String AUTHENTICATION = "ume.ldap.access.authentication";
    protected static final String CONPOOLMINSIZE = "ume.ldap.connection_pool.min_size";
    protected static final String CONPOOLMAXSIZE = "ume.ldap.connection_pool.max_size";
    protected static final String CONPOOLMAXIDLECONS = "ume.ldap.connection_pool.max_idle_connections";
    protected static final String CONPOOLMAXIDLETIME = "ume.ldap.connection_pool.idle_time";
    protected static final String CONPOOLMAXWAITTIME = "ume.ldap.connection_pool.max_wait_time";
    protected static final String CONPOOLMONLVL = "ume.ldap.connection_pool.monitor_level";
    protected static final String CONPOOLRETRIAL = "ume.ldap.connection_pool.retrial";
    protected static final String CONPOOLRETRIALINT = "ume.ldap.connection_pool.retrial_interval";
    protected static final String CONPOOLRELCHECK = "ume.ldap.connection_pool.release_check_interval";
    protected static final String ACTION_RETRIAL = "ume.ldap.access.action_retrial";
    protected static final String CONPOOLTIMEOUT = "ume.ldap.connection_pool.connection_timeout";
    protected static final String CONPOOLCONNECTTIMEOUT = "ume.ldap.connection_pool.connect_timeout";
    protected static final String NEGATIVE_USR_FILTER = "ume.ldap.negative_user_filter";
    protected static final String CASE_SENSITIVE_ACCESS = "ume.ldap.access.case_sensitive";
    protected static final String ADDITIONAL_PASSWORD_PROPERTY = "$ume.ldap.access.additional_password.";
    private static final String RECORD_LDAP_ACCESS = "ume.ldap.record_access";
    private static final String CACHE_SIZE = "ume.ldap.cache_size";
    private static final String CACHE_LIFE_TIME = "ume.ldap.cache_lifetime";
    private static final String ENABLE_DUMMY_MEMBER = "ume.ldap.default_group_member.enabled";
    private static final String DUMMY_MEMBER = "ume.ldap.default_group_member";
    private static final String default_member = "cn=DUMMY_MEMBER_FOR_UME";
    private static final String DEFAULT_CONTROL_VALUE = "512";
    private static final String DEFAULT_CONTROL_ATTRIBUTE = "userAccountControl";
    private static final String GROUPTYPE_ATTRIBUTE = "ume.ldap.access.msads.grouptype.attribute";
    private static final String GROUPTYPE_VALUE_ATTRIBUTE = "ume.ldap.access.msads.grouptype.value";
    private static final String DEFAULT_GROUP_TYPE_ATTR = "grouptype";
    private static final String DEFAULT_GROUP_TYPE_VALUE = "4";
    private static final String UNIQUE_USER_ATTRIBUTE = "ume.ldap.unique_user_attribute";
    private static final String UNIQUE_UACC_ATTRIBUTE = "ume.ldap.unique_uacc_attribute";
    private static final String UNIQUE_GRUP_ATTRIBUTE = "ume.ldap.unique_grup_attribute";
    private static final String BLOCKED_GROUPS = "ume.ldap.blocked_groups";
    private static final String BLOCKED_ACCOUNTS = "ume.ldap.blocked_accounts";
    private static final String BLOCKED_USERS = "ume.ldap.blocked_users";
    private static final String MULTIDOMAIN = "ume.ldap.access.multidomain.enabled";
    private static final String DOMAINMAPPING = "ume.ldap.access.domain_mapping";
    private static final String DOMAIN_LOGONID = "domain_j_user";
    private static final String GROUP_CHECK = "ume.ldap.access.group_existence_check";
    private static NameParser _centralNameParser = null;
    private static AccessAudit aa = null;
    private ICache search_cache = null;
    private ICache exist_cache = null;
    private LDAPConnectionManager _manager = null;
    private Vector _blockedPrincipals = null;
    private boolean lazyInitialisation = false;
    private boolean caseSensitive = false;
    private Hashtable mm_mappedDomains = null;
    private boolean mm_multiDomainEnabled = false;
    private Hashtable mm_principalNamespaces = null;
    private boolean mm_groupCheck = true;
    private int init = 0;
    private boolean mm_defaultMemberEnabled = false;
    private Hashtable mm_userFilter = null;
    private static ArrayList mm_instances = new ArrayList(1);
    static /* synthetic */ Class class$com$sap$security$core$persistence$datasource$imp$LDAPPersistence;

    public void init(DSConfigurationModel dsConf) throws PersistenceException {
        String mn = "init";
        trace = InternalUMFactory.getTrace(VERSIONSTRING);
        props = UMFactory.getProperties();
        if (trace.bePath()) {
            trace.entering("init", new Object[]{dsConf});
        }
        super.init(dsConf);
        if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
            aa = new AccessAudit();
        }
        if (trace.beInfo()) {
            trace.infoT("init", "ldap record access = " + props.getBoolean(RECORD_LDAP_ACCESS, false));
        }
        this.search_cache = this.getUMCache("search_cache");
        this.exist_cache = this.getUMCache("exist_cache");
        String _hierachyType = this.getConfigurationStringValue(dsConf, FLAT_GROUP_HIERACHY, "true");
        this.mm_flatUserGroupHierachy = _hierachyType.equalsIgnoreCase("false") ? 1 : (_hierachyType.equalsIgnoreCase("mixed") ? 2 : 0);
        if (trace.beInfo()) {
            trace.infoT("init", "use flat user group hierachy = " + this.mm_flatUserGroupHierachy);
        }
        this.mm_dynamicGroups = this.getConfigurationBooleanValue(dsConf, DYNAMIC_GROUPS, false);
        if (trace.beInfo()) {
            trace.infoT("init", "use dynamic groups = " + this.mm_dynamicGroups);
        }
        this.mm_userAsUseraccount = this.getConfigurationBooleanValue(dsConf, USER_AS_USERACCOUNT, true);
        if (trace.beInfo()) {
            trace.infoT("init", "use user object as accounts = " + this.mm_userAsUseraccount);
        }
        if (this.mm_dynamicGroups) {
            this.mm_dynamicMemberAttribute = this.getConfigurationStringValue(dsConf, DYNAMIC_GROUP_ATTRIBUTE, "memberURL");
        }
        this.caseSensitive = this.getConfigurationBooleanValue(dsConf, CASE_SENSITIVE_ACCESS, false);
        if (trace.beInfo()) {
            trace.infoT("init", "datasource is case sensitive " + this.caseSensitive);
        }
        this.mm_serverType = this.getConfigurationStringValue(dsConf, SERVER_TYPE, null);
        if (trace.beInfo()) {
            trace.infoT("init", "server type = " + this.mm_serverType);
        }
        this.mm_action_retrial = this.getConfigurationIntValue(dsConf, ACTION_RETRIAL, 2);
        if (trace.beInfo()) {
            trace.infoT("init", "action retrial = " + this.mm_action_retrial);
        }
        this.mm_principalUniqueAttributes = new Hashtable();
        String uniqueAttributes = this.getConfigurationStringValue(dsConf, UNIQUE_GRUP_ATTRIBUTE, null);
        if (uniqueAttributes != null && uniqueAttributes.length() > 0) {
            this.mm_principalUniqueAttributes.put("GRUP", JNDIUtils.getArrayListFromString(uniqueAttributes, ","));
            if (trace.beInfo()) {
                trace.infoT("init", "unique group attributes = " + uniqueAttributes);
            }
        }
        if ((uniqueAttributes = this.getConfigurationStringValue(dsConf, UNIQUE_USER_ATTRIBUTE, null)) != null && uniqueAttributes.length() > 0) {
            this.mm_principalUniqueAttributes.put("USER", JNDIUtils.getArrayListFromString(uniqueAttributes, ","));
            if (trace.beInfo()) {
                trace.infoT("init", "unique user attributes = " + uniqueAttributes);
            }
        }
        if ((uniqueAttributes = this.getConfigurationStringValue(dsConf, UNIQUE_UACC_ATTRIBUTE, null)) != null && uniqueAttributes.length() > 0) {
            this.mm_principalUniqueAttributes.put("UACC", JNDIUtils.getArrayListFromString(uniqueAttributes, ","));
            if (trace.beInfo()) {
                trace.infoT("init", "unique account attributes = " + uniqueAttributes);
            }
        }
        this.mm_size_limit = this.getConfigurationIntValue(dsConf, SIZE_LIMIT, 0);
        if (trace.beInfo()) {
            trace.infoT("init", "search size limit = " + this.mm_size_limit);
        }
        this.mm_time_limit = this.getConfigurationIntValue(dsConf, TIME_LIMIT, 0);
        if (trace.beInfo()) {
            trace.infoT("init", "time limit = " + this.mm_time_limit);
        }
        this.mm_groupCheck = this.getConfigurationBooleanValue(dsConf, GROUP_CHECK, true);
        if (!this.mm_groupCheck && trace.beInfo()) {
            trace.infoT("init", "existence check for groups is disabled");
        }
        Vector prinTypes = new Vector(dsConf.getResponsibleFor().values());
        this.mm_principalPaths = new Hashtable();
        this.mm_principalObjectclasses = new Hashtable();
        this.mm_principalAuxiliaryObjectclasses = new Hashtable();
        this.mm_principalNamingAttributes = new Hashtable();
        this.mm_principalAuxiliaryNamingAttributes = new Hashtable();
        this.mm_principalCreationPaths = new Hashtable();
        int i = 0;
        while (i < prinTypes.size()) {
            DSPrincipalModel ptype = (DSPrincipalModel)prinTypes.elementAt(i);
            String type = ptype.getType();
            if (this.mm_principalNamespaces == null) {
                this.mm_principalNamespaces = new Hashtable();
            }
            Vector namespaces = dsConf.getResponsibleNameSpaces(type);
            Vector<String> nameSpacesNames = new Vector<String>();
            int j = 0;
            while (j < namespaces.size()) {
                nameSpacesNames.add(((DSNameSpaceModel)namespaces.elementAt(j)).getName());
                this.mm_principalNamespaces.put(type, nameSpacesNames);
                ++j;
            }
            Vector _objc = null;
            String objectclass = this.getConfigurationStringValue(dsConf, OBJECTCLASS + type.toLowerCase(), null);
            if (objectclass != null) {
                _objc = JNDIUtils.getVectorFromString(objectclass.toLowerCase(), ",");
            }
            Vector _aobjc = null;
            String auxObjectclass = this.getConfigurationStringValue(dsConf, AUX_OBJECTCLASS + type.toLowerCase(), null);
            if (auxObjectclass != null) {
                _aobjc = JNDIUtils.getVectorFromString(auxObjectclass.toLowerCase(), ",");
            }
            Vector nAttr = null;
            String nAttribute = this.getConfigurationStringValue(dsConf, NAMINGATTRIBUTE + type.toLowerCase(), null);
            if (nAttribute != null) {
                nAttr = JNDIUtils.getVectorFromString(nAttribute.toLowerCase(), ",");
            }
            Vector _anAttr = null;
            String auxNAttribute = this.getConfigurationStringValue(dsConf, AUXILIARY_NAMINGATTRIBUTE + type.toLowerCase(), null);
            if (auxNAttribute != null) {
                _anAttr = JNDIUtils.getVectorFromString(auxNAttribute.toLowerCase(), ",");
            }
            String path = this.getConfigurationStringValue(dsConf, PATH + type.toLowerCase(), "");
            String creationPath = this.getConfigurationStringValue(dsConf, CREATIONPATH + type.toLowerCase(), "");
            if (type.equalsIgnoreCase("UACC") && this.mm_userAsUseraccount) {
                path = this.getConfigurationStringValue(dsConf, PATH + "USER".toLowerCase(), "");
                creationPath = this.getConfigurationStringValue(dsConf, CREATIONPATH + "USER".toLowerCase(), "");
            }
            if (type.equalsIgnoreCase("UACC") && (objectclass == null || nAttribute == null || path == null)) {
                objectclass = this.getConfigurationStringValue(dsConf, OBJECTCLASS + type.toLowerCase(), null);
                if (objectclass != null) {
                    _objc = JNDIUtils.getVectorFromString(objectclass, ",");
                }
                if ((nAttribute = this.getConfigurationStringValue(dsConf, NAMINGATTRIBUTE + "USER".toLowerCase(), null)) != null) {
                    nAttr = JNDIUtils.getVectorFromString(nAttribute, ",");
                }
                path = this.getConfigurationStringValue(dsConf, PATH + "USER".toLowerCase(), null);
            }
            if (objectclass == null || nAttribute == null || path == null) {
                trace.errorT("init", "Objectclass or path or namin gattribute can not be read from configuration or properties file for type " + type);
                trace.logFatalT("DataSource {0}:Insufficient configuration: objectclass {1} or path {2} or namingattribute {3} can not be read from configuration for type {4}", new Object[]{this.getId(), objectclass, path, nAttribute, type});
                throw new PersistenceException("objectclass or path or namingattribute can not be read");
            }
            path = JNDIUtils.trimDN(path);
            creationPath = JNDIUtils.trimDN(creationPath);
            this.mm_principalCreationPaths.put(type, creationPath);
            this.mm_principalPaths.put(type, path);
            this.mm_principalObjectclasses.put(type, _objc);
            this.mm_principalNamingAttributes.put(type, nAttr);
            if (_anAttr != null) {
                this.mm_principalAuxiliaryNamingAttributes.put(type, _anAttr);
            }
            if (_aobjc != null) {
                this.mm_principalAuxiliaryObjectclasses.put(type, _aobjc);
            }
            ++i;
        }
        String userFilterData = this.getConfigurationStringValue(dsConf, NEGATIVE_USR_FILTER, "");
        if (!userFilterData.equals("")) {
            if (trace.beInfo()) {
                trace.infoT("init", "Users belonging to following criterias are not recognized: " + userFilterData);
            }
            StringTokenizer tokenizer = new StringTokenizer(userFilterData, ";", false);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                StringTokenizer attributeTokenizer = new StringTokenizer(token, "!=", false);
                if (!attributeTokenizer.hasMoreTokens()) continue;
                String attributename = attributeTokenizer.nextToken();
                String values = attributeTokenizer.nextToken();
                Vector<String> filtervalues = new Vector<String>();
                StringTokenizer valuesTokenizer = new StringTokenizer(values.substring(1, values.length() - 1), ",", false);
                while (valuesTokenizer.hasMoreTokens()) {
                    filtervalues.add(valuesTokenizer.nextToken());
                }
                if (attributename == null || attributename.length() <= 0 || filtervalues.size() <= 0) continue;
                if (this.mm_userFilter == null) {
                    this.mm_userFilter = new Hashtable();
                }
                this.mm_userFilter.put(attributename, filtervalues);
            }
        }
        this.mm_defaultMemberEnabled = this.getConfigurationBooleanValue(dsConf, ENABLE_DUMMY_MEMBER, false);
        this.mm_sslEnabled = this.getConfigurationBooleanValue(dsConf, SSL, false);
        this.mm_socketFactory = this.getConfigurationStringValue(dsConf, SOCKETFACTORY, "com.sun.jndi.ldap.LdapCtxFactory");
        String auth = this.getConfigurationStringValue(dsConf, AUTHENTICATION, "simple");
        this.mm_sslSocketFactory = this.getConfigurationStringValue(dsConf, SSLSOCKETFACTORY, "com.sap.security.ssl.SSLSocketFactory");
        if (trace.beDebug()) {
            trace.debugT("init", "Starting the initialization of the LDAP connection manager");
        }
        try {
            this._manager = new LDAPConnectionManager();
            this._manager.initialize(dsConf);
            if (trace.beInfo()) {
                trace.infoT("init", "Connection manager sucessfully initialized");
            }
            _centralNameParser = this._manager.getParser();
            this.lazyInitialisation = false;
        }
        catch (PersistenceException e) {
            if (!this.mm_sslEnabled) {
                trace.logFatalT("DataSource {0}:Initialisation of connection manager failed because: {1}", new Object[]{this.getId(), e.getMessage()});
                this.lazyInitialisation = false;
                myLoc.traceThrowableT(500, "Initialisation of connection manager failed", (Throwable)((Object)e));
                throw new PersistenceException((Throwable)((Object)e));
            }
            trace.errorT("init", "Initialisation of connection manager failed, due to SSL configuration lazy initialisation is enabled", (Throwable)((Object)e));
            trace.logErrorT("DataSource {0}: Initialisation of connection manager failed, due to SSL configuration lazy initialisation", new Object[]{this.getId()});
            this.lazyInitialisation = true;
        }
        if (trace.beDebug()) {
            trace.debugT("init", "LDAP connection manager successfully initialized");
        }
        this.mm_multiDomainEnabled = this.getConfigurationBooleanValue(dsConf, MULTIDOMAIN, false);
        if (this.mm_multiDomainEnabled) {
            String mapped_domains = dsConf.getPrivateAttribute(DOMAINMAPPING);
            Hashtable _mappedDomains = JNDIUtils.getDomainMapping(mapped_domains);
            if (_mappedDomains != null) {
                this.mm_mappedDomains = _mappedDomains;
            }
            if (trace.beInfo()) {
                trace.infoT("init", this.getId() + ": multim domain enabled " + mapped_domains);
            }
        } else if (trace.beInfo()) {
            trace.infoT("init", this.getId() + ": no multi domain configured");
        }
        this.isInitialized = true;
        String blockedPrincipals = this.getConfigurationStringValue(dsConf, BLOCKED_USERS, null);
        Vector blocked = JNDIUtils.getVectorFromString(blockedPrincipals, ",");
        int i2 = 0;
        while (i2 < blocked.size()) {
            SearchCriteria sc = new SearchCriteria(false, "USER");
            sc.addEqualsElement("com.sap.security.core.usermanagement", "uniquename", blocked.elementAt(i2), true);
            try {
                Vector blockedIDs = this.searchPrincipalDatabags(sc);
                int j = 0;
                while (j < blockedIDs.size()) {
                    if (this._blockedPrincipals == null) {
                        this._blockedPrincipals = new Vector();
                    }
                    this._blockedPrincipals.add(blockedIDs.elementAt(j));
                    ++j;
                }
            }
            catch (Exception e) {
                trace.errorT("init", "Exception when searching for blocked users", e);
                trace.logErrorT("DataSource {0}: Exception when searching for blocked users: {1}", new Object[]{this.getId(), e.getMessage()});
            }
            ++i2;
        }
        blockedPrincipals = this.getConfigurationStringValue(dsConf, BLOCKED_GROUPS, null);
        blocked = JNDIUtils.getVectorFromString(blockedPrincipals, ",");
        int i3 = 0;
        while (i3 < blocked.size()) {
            SearchCriteria sc = new SearchCriteria(false, "GRUP");
            sc.addEqualsElement("com.sap.security.core.usermanagement", "uniquename", blocked.elementAt(i3), true);
            try {
                Vector blockedIDs = this.searchPrincipalDatabags(sc);
                if (this._blockedPrincipals == null) {
                    this._blockedPrincipals = new Vector();
                }
                int j = 0;
                while (j < blockedIDs.size()) {
                    this._blockedPrincipals.add(blockedIDs.elementAt(j));
                    ++j;
                }
            }
            catch (Exception e) {
                trace.errorT("init", "Exception when searching for blocked groups", e);
                trace.logErrorT("DataSource {0}: Exception when searching for blocked groups: {1}", new Object[]{this.getId(), e.getMessage()});
            }
            ++i3;
        }
        blockedPrincipals = this.getConfigurationStringValue(dsConf, BLOCKED_ACCOUNTS, null);
        blocked = JNDIUtils.getVectorFromString(blockedPrincipals, ",");
        int i4 = 0;
        while (i4 < blocked.size()) {
            SearchCriteria sc = new SearchCriteria(false, "UACC");
            sc.addEqualsElement("com.sap.security.core.usermanagement", "j_user", blocked.elementAt(i4), true);
            try {
                Vector blockedIDs = this.searchPrincipalDatabags(sc);
                if (this._blockedPrincipals == null) {
                    this._blockedPrincipals = new Vector();
                }
                int j = 0;
                while (j < blockedIDs.size()) {
                    this._blockedPrincipals.add(blockedIDs.elementAt(j));
                    ++j;
                }
            }
            catch (Exception e) {
                trace.errorT("init", "Exception when searching for blocked accounts", e);
                trace.logErrorT("DataSource {0}: Exception when searching for blocked accounts: {1}", new Object[]{this.getId(), e.getMessage()});
            }
            ++i4;
        }
        if (this._blockedPrincipals == null) {
            this._blockedPrincipals = new Vector();
        }
        if (trace.beInfo()) {
            StringBuffer sb = new StringBuffer();
            sb.append("|| ldap record access = ").append(props.getBoolean(RECORD_LDAP_ACCESS, false));
            sb.append("|| use flat user group hierachy = ").append(this.mm_flatUserGroupHierachy);
            sb.append("|| use user object as accounts = ").append(this.mm_userAsUseraccount);
            sb.append("|| server type = ").append(this.mm_serverType);
            sb.append("|| action retrial = ").append(this.mm_action_retrial);
            sb.append("|| search size limit = ").append(this.mm_size_limit);
            sb.append("|| search time limit = ").append(this.mm_time_limit);
            sb.append("|| ssl enabled ").append(this.mm_sslEnabled);
            sb.append("|| context factory =").append(this.mm_socketFactory);
            sb.append("|| authentication method =").append(auth);
            sb.append("|| ssl socket factory =").append(this.mm_sslSocketFactory);
            sb.append("|| dummy member enabled = ").append(this.mm_defaultMemberEnabled);
            sb.append("|| blocked principals =");
            if (this._blockedPrincipals != null) {
                int a = 0;
                while (a < this._blockedPrincipals.size()) {
                    sb.append(this._blockedPrincipals.elementAt(a)).append(",");
                    ++a;
                }
            }
            if (this.mm_multiDomainEnabled) {
                sb.append("|| mutli domain enabled = ").append(this.mm_multiDomainEnabled).append(":");
                if (this.mm_mappedDomains != null) {
                    Iterator keys = this.mm_mappedDomains.keySet().iterator();
                    while (keys.hasNext()) {
                        String domainAlias = (String)keys.next();
                        String mappedPath = (String)this.mm_mappedDomains.get(domainAlias);
                        sb.append("[").append(domainAlias).append("-->").append(mappedPath).append("]");
                    }
                }
            }
            if (trace.beInfo()) {
                trace.infoT("init", sb.toString());
            }
        }
        if (trace.bePath()) {
            trace.exiting("init");
        }
    }

    public String toString() {
        StringBuffer sb;
        block7: {
            trace.entering("toString");
            sb = new StringBuffer();
            try {
                sb.append("LDAP datasource with id = ").append(this.getId()).append("\n");
                sb.append("\t server type = ").append(this.mm_serverType).append("\n");
                sb.append("\t readonly = ").append(this.isReadonly()).append("\n");
                sb.append("\t primary = ").append(this.isPrimary()).append("\n");
                sb.append("\t flat hierachy = ").append(this.mm_flatUserGroupHierachy).append("\n");
            }
            catch (PersistenceException ex) {
                if (!trace.beInfo()) break block7;
                StringBuffer mes = new StringBuffer();
                mes.append("Persistence exception when trying to get some configuration parameters LDAP datasource ");
                mes.append(" [Exception: ").append(ex.getMessage()).append("]");
                trace.infoT("toString", mes.toString());
            }
        }
        Enumeration _principalTypes = this.mm_principalNamingAttributes.keys();
        sb.append("\t responsible for = ");
        while (_principalTypes.hasMoreElements()) {
            sb.append((String)_principalTypes.nextElement());
            if (!_principalTypes.hasMoreElements()) continue;
            sb.append(",");
        }
        sb.append("\n");
        _principalTypes = this.mm_principalPaths.keys();
        while (_principalTypes.hasMoreElements()) {
            String _type = (String)_principalTypes.nextElement();
            sb.append("\t url for ").append(_type).append(":").append(this._manager.getActiveURL(_type));
        }
        sb.append("\n");
        if (this.mm_multiDomainEnabled) {
            sb.append("\t mutli domain enabled = ").append(this.mm_multiDomainEnabled).append(":");
            if (this.mm_mappedDomains != null) {
                Iterator keys = this.mm_mappedDomains.keySet().iterator();
                while (keys.hasNext()) {
                    String domainAlias = (String)keys.next();
                    String mappedPath = (String)this.mm_mappedDomains.get(domainAlias);
                    sb.append("[").append(domainAlias).append("-->").append(mappedPath).append("]");
                }
            }
        }
        return sb.toString();
    }

    private ICache getUMCache(String owner) throws PersistenceException {
        int cachesize = props.getNumber(CACHE_SIZE, 100);
        int cachelifetime = props.getNumber(CACHE_LIFE_TIME, 300);
        if (trace.beInfo()) {
            trace.infoT("getUMCache", "asking for a new cache :" + owner + "- with size " + cachesize + " and lifetime " + cachelifetime);
        }
        ICache cache = null;
        if (cachesize <= 0 || cachelifetime <= 0) {
            if (trace.beInfo()) {
                trace.infoT("getUMCache", "asking for no caching cache");
            }
            cache = InternalUMFactory.getCache(3, cachesize, cachelifetime, this.getClass().getName() + "_" + owner + "_" + this.getId(), false);
        } else {
            cache = InternalUMFactory.getCache(4, cachesize, cachelifetime, this.getClass().getName() + "_" + owner + "_" + this.getId(), false);
        }
        return cache;
    }

    public IInternalPrincipalDatabag[] initPrincipalDatabags(IInternalPrincipalDatabag[] principals) throws PersistenceException {
        String mn = "initPrincipalDatabags";
        if (trace.bePath()) {
            trace.entering("initPrincipalDatabags", new Object[]{principals});
        }
        if (!this.isInitialized || this.lazyInitialisation) {
            trace.errorT("initPrincipalDatabags", "Data source is not initialized");
            if (this.lazyInitialisation) {
                if (!this.reinitializeConnectionManager()) {
                    trace.logErrorT("Data source {0} not initialized", new Object[]{this.getId()});
                    throw new PersistenceException("data source " + this.getId() + " not initialized");
                }
            } else {
                trace.logErrorT("Data source {0} not initialized", new Object[]{this.getId()});
                throw new PersistenceException("data source " + this.getId() + " not initialized");
            }
        }
        int count = 0;
        while (count < principals.length) {
            try {
                if (this.isHomeForPrincipalDatabag(principals[count])) {
                    this.populatePrincipalDatabag(principals[count], null);
                }
            }
            catch (PersistenceException e) {
                StringBuffer sb = new StringBuffer();
                sb.append("Exception when populating ").append(principals[count]);
                trace.errorT("initPrincipalDatabags", sb.toString(), (Throwable)((Object)e));
                principals[count] = null;
            }
            ++count;
        }
        if (trace.bePath()) {
            trace.exiting("initPrincipalDatabags");
        }
        return principals;
    }

    public void populatePrincipalDatabags(IInternalPrincipalDatabag[] principals, AttributeList populateAttributes) throws PersistenceException {
        if (trace.bePath()) {
            trace.entering("populatePrincipalDatabags", new Object[]{principals, populateAttributes});
        }
        if (!this.isInitialized || this.lazyInitialisation) {
            trace.errorT("populatePrincipalDatabags", "Data source is not initialized");
            if (this.lazyInitialisation) {
                if (!this.reinitializeConnectionManager()) {
                    trace.logErrorT("Data source {0} not initialized", new Object[]{this.getId()});
                    throw new PersistenceException("data source " + this.getId() + " not initialized");
                }
            } else {
                trace.logErrorT("Data source {0} not initialized", new Object[]{this.getId()});
                throw new PersistenceException("Data source " + this.getId() + " not initialized");
            }
        }
        int count = 0;
        while (count < principals.length) {
            this.populatePrincipalDatabag(principals[count], populateAttributes);
            ++count;
        }
        if (trace.bePath()) {
            trace.exiting("populatePrincipalDatabags");
        }
    }

    public IDataSourceTransaction beginTransaction() throws PersistenceException {
        if (trace.bePath()) {
            trace.entering("beginTransaction");
        }
        if (!this.isInitialized) {
            trace.errorT("beginTransaction", "data source is not initialized");
            trace.logErrorT("Data source {0} not initialized", new Object[]{this.getId()});
            throw new PersistenceException("Data source " + this.getId() + " not initialized");
        }
        if (trace.bePath()) {
            trace.exiting("beginTransaction");
        }
        return new LDAPDataSourceTransaction(this);
    }

    /*
     * Unable to fully structure code
     */
    public void populatePrincipalDatabag(IInternalPrincipalDatabag principal, AttributeList populateAttributes) throws PersistenceException {
        block117: {
            block114: {
                populateDistinguishedName = false;
                mn = "populatePrincipalDatabag";
                if (LDAPPersistence.trace.bePath()) {
                    LDAPPersistence.trace.entering("populatePrincipalDatabag", new Object[]{principal, populateAttributes});
                }
                if (!this.isPrimary()) {
                    message = new StringBuffer();
                    message.append("Data source ").append(this.getId());
                    message.append(" is not primary, it is used as secondary/replication datasource");
                    LDAPPersistence.trace.infoT("populatePrincipalDatabag", message.toString());
                    return;
                }
                uniqueID = principal.getUniqueID();
                if (uniqueID == null) {
                    LDAPPersistence.trace.warningT("populatePrincipalDatabag", "Principal databag not bound to a data source, unique id is null");
                    throw new PersistenceException("Unique is null");
                }
                IDParts = principal.getIDParts();
                orgID = IDParts[2];
                if (!IDParts[1].equals(this.getId())) {
                    if (LDAPPersistence.trace.beInfo()) {
                        LDAPPersistence.trace.infoT("populatePrincipalDatabag", "Principal " + principal.getUniqueID() + " not on this datasource");
                    }
                    return;
                }
                if (!this.caseSensitive && !IDParts[2].equals(IDParts[2].toLowerCase())) {
                    sb = new StringBuffer("Principal ");
                    sb.append(IDParts[2]).append(" is not completely in lower cases and is not created by this datasource");
                    LDAPPersistence.trace.warningT("populatePrincipalDatabag", sb.toString());
                    return;
                }
                if (!this.isInitialized || this.lazyInitialisation) {
                    LDAPPersistence.trace.errorT("populatePrincipalDatabag", "Data source is not initialized");
                    if (this.lazyInitialisation) {
                        if (!this.reinitializeConnectionManager()) {
                            LDAPPersistence.trace.logErrorT("Data source {0} not initialized", new Object[]{this.getId()});
                            throw new PersistenceException("Data source " + this.getId() + " not initialized");
                        }
                    } else {
                        LDAPPersistence.trace.logErrorT("Data source {0} not initialized", new Object[]{this.getId()});
                        throw new PersistenceException("Data source " + this.getId() + " not initialized");
                    }
                }
                if ((uniqueAttributes = (ArrayList)this.mm_principalUniqueAttributes.get(IDParts[0])) != null) {
                    orgID = this.getDNfromID(uniqueAttributes, IDParts[2], IDParts[0]);
                }
                objectclasses = (Vector)this.mm_principalObjectclasses.get(IDParts[0]);
                objectclass = "";
                if (objectclasses != null && objectclasses.size() > 1) {
                    objectclass = this.getObjectclass(IDParts[0], orgID) + ":";
                }
                if (populateAttributes != null && populateAttributes.getSize() == 1) {
                    attributeName = populateAttributes.getAttributeNameOfAttributeAt(0);
                    nameSpace = populateAttributes.getNameSpaceOfAttributeAt(0);
                    if (this.feelsResponsible(IDParts[0], nameSpace, attributeName) && IDParts[1].equals(this.getId()) && (attributeName.equals("uniquename") || attributeName.equals("j_user")) && nameSpace.equals("com.sap.security.core.usermanagement")) {
                        physAttribute = this.getPhysicalAttribute(IDParts[0], nameSpace, objectclass + attributeName);
                        if (this.checkAttributeAsNamingAttribute(physAttribute = this.getRealPhysicalAttribute(physAttribute), IDParts[0]) && this.mm_principalUniqueAttributes.get(IDParts[0]) != null) {
                            sindex = orgID.indexOf(61);
                            eindex = orgID.indexOf(61, sindex + 1);
                            subid = orgID.substring(sindex, eindex);
                            subid = subid.substring(1, subid.lastIndexOf(44));
                            subid = JNDIUtils.specialHandlingBackMSADS(subid);
                            subid = JNDIUtils.unescapeDistinguishedName(subid);
                            principal.addAttributeValue(nameSpace, attributeName, subid);
                            return;
                        }
                    }
                }
                if (!this.feelsResponsible(principal)) {
                    message = new StringBuffer();
                    message.append("Data source ").append(this.getId());
                    message.append(" is not responsible for this principal data bag ");
                    message.append(uniqueID);
                    if (LDAPPersistence.trace.beInfo()) {
                        LDAPPersistence.trace.infoT("populatePrincipalDatabag", message.toString());
                    }
                    return;
                }
                if (LDAPPersistence.trace.beInfo()) {
                    sb = new StringBuffer();
                    sb.append("Populate principal databag ").append(uniqueID);
                    sb.append(" of type ").append(IDParts[0]);
                    sb.append(" with internal unique id ").append(IDParts[2]);
                    LDAPPersistence.trace.infoT("populatePrincipalDatabag", sb.toString());
                }
                _logAttr = new Hashtable<String, HashSet>();
                _physAttr = new Vector<String>();
                populateParents = false;
                populateChilds = false;
                size = 0;
                if (populateAttributes != null) {
                    size = populateAttributes.getSize();
                }
                i = 0;
                while (i < size) {
                    namespace = populateAttributes.getNameSpaceOfAttributeAt(i);
                    if (this.feelsResponsible(IDParts[0], namespace, attributeName = populateAttributes.getAttributeNameOfAttributeAt(i)) && !attributeName.equals("j_password")) {
                        if (attributeName.equals("dn") && namespace.equals("com.sap.security.core.bridge")) {
                            populateDistinguishedName = true;
                        }
                        physName = this.getPhysicalAttribute(IDParts[0], namespace, objectclass + attributeName);
                        if (objectclass.length() > 0) {
                            physName = this.getRealPhysicalAttribute(physName);
                        }
                        if (!physName.equals("*null*")) {
                            if (_logAttr.get(namespace) == null) {
                                attrSet = new HashSet();
                                attrSet.add(attributeName);
                                _logAttr.put(namespace, attrSet);
                            } else {
                                attrSet = (HashSet)_logAttr.get(namespace);
                                if (!attrSet.contains(attributeName)) {
                                    attrSet.add(attributeName);
                                    _logAttr.put(namespace, attrSet);
                                }
                            }
                            if (!_physAttr.contains(physName)) {
                                _physAttr.add(physName);
                            }
                        } else {
                            if (namespace.equals("com.sap.security.core.usermanagement.relation") && attributeName.equals("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE")) {
                                populateChilds = true;
                            }
                            if (namespace.equals("com.sap.security.core.usermanagement.relation") && attributeName.equals("PRINCIPAL_RELATION_PARENT_ATTRIBUTE")) {
                                populateParents = true;
                            }
                            if (IDParts[0].equals("UACC") && namespace.equals("com.sap.security.core.usermanagement") && attributeName.equals("userid")) {
                                values = new Vector<String>();
                                sb = new StringBuffer();
                                sb.append("USER").append(".");
                                sb.append(this.getId()).append(".");
                                if (this.caseSensitive) {
                                    sb.append(IDParts[2]);
                                } else {
                                    sb.append(IDParts[2].toLowerCase());
                                }
                                values.add(sb.toString());
                                principal.setAttributeValues(namespace, attributeName, this.buildUnion(new Vector[]{values, principal.getAttributeValues(namespace, attributeName)}));
                            }
                        }
                    }
                    ++i;
                }
                popInitially = this.mConfigurationModel.getPopulateInitially(IDParts[0]);
                if (popInitially != null) {
                    initNamespaces = popInitially.keySet().iterator();
                    while (initNamespaces.hasNext()) {
                        _namespace = (String)initNamespaces.next();
                        attributeNames = (Vector)popInitially.get(_namespace);
                        i = 0;
                        while (i < attributeNames.size()) {
                            _attributeName = (String)attributeNames.elementAt(i);
                            if (this.feelsResponsible(IDParts[0], _namespace, _attributeName) && !_attributeName.equals("j_password")) {
                                if (_attributeName.equals("dn") && _namespace.equals("com.sap.security.core.bridge")) {
                                    populateDistinguishedName = true;
                                }
                                physAttribute = this.getPhysicalAttribute(IDParts[0], _namespace, objectclass + _attributeName);
                                if (objectclass.length() > 0) {
                                    physAttribute = this.getRealPhysicalAttribute(physAttribute);
                                }
                                if (!physAttribute.equals("*null*")) {
                                    if (_logAttr.get(_namespace) == null) {
                                        attrSet = new HashSet();
                                        attrSet.add(_attributeName);
                                        _logAttr.put(_namespace, attrSet);
                                    } else {
                                        attrSet = (HashSet)_logAttr.get(_namespace);
                                        if (!attrSet.contains(_attributeName)) {
                                            attrSet.add(_attributeName);
                                            _logAttr.put(_namespace, attrSet);
                                        }
                                    }
                                    if (!_physAttr.contains(physAttribute)) {
                                        _physAttr.add(physAttribute);
                                    }
                                } else {
                                    if (_namespace.equals("com.sap.security.core.usermanagement.relation") && _attributeName.equals("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE")) {
                                        populateChilds = true;
                                    }
                                    if (_namespace.equals("com.sap.security.core.usermanagement.relation") && _attributeName.equals("PRINCIPAL_RELATION_PARENT_ATTRIBUTE")) {
                                        populateParents = true;
                                    }
                                    if (IDParts[0].equals("UACC") && _namespace.equals("com.sap.security.core.usermanagement") && _attributeName.equals("userid")) {
                                        values = new Vector<String>();
                                        sb = new StringBuffer();
                                        sb.append("USER").append(".");
                                        sb.append(this.getId()).append(".");
                                        if (this.caseSensitive) {
                                            sb.append(IDParts[2]);
                                        } else {
                                            sb.append(IDParts[2].toLowerCase());
                                        }
                                        values.add(sb.toString());
                                        principal.setAttributeValues(_namespace, _attributeName, this.buildUnion(new Vector[]{values, principal.getAttributeValues(_namespace, _attributeName)}));
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                }
                if (LDAPPersistence.trace.beInfo()) {
                    sb = new StringBuffer();
                    sb.append("Trying to populate attribute for principal ").append(principal.getUniqueID()).append("->");
                    i = 0;
                    while (i < _physAttr.size()) {
                        sb.append(_physAttr.get(i)).append("-");
                        ++i;
                    }
                    LDAPPersistence.trace.infoT("populatePrincipalDatabag", sb.toString());
                }
                returningAttributes = new String[_physAttr.size()];
                i = 0;
                while (i < _physAttr.size()) {
                    returningAttributes[i] = (String)_physAttr.elementAt(i);
                    ++i;
                }
                if (returningAttributes.length <= 0 || orgID == null) break block114;
                base = null;
                if (orgID == null || orgID.length() == 0) {
                    LDAPPersistence.trace.errorT("populatePrincipalDatabag", "Invalid internal id, id should not be null for " + principal.getUniqueID());
                    throw new PersistenceException("Internal id is null");
                }
                try {
                    _path = (String)this.mm_principalPaths.get(IDParts[0]);
                    pathName = LDAPPersistence._centralNameParser.parse(_path);
                    if (LDAPPersistence.trace.beInfo()) {
                        LDAPPersistence.trace.infoT("populatePrincipalDatabag", "Trying to parse id " + orgID);
                    }
                    principalName = LDAPPersistence._centralNameParser.parse(orgID);
                    base = JNDIUtils.getRelativeBase(principalName, pathName);
                }
                catch (NamingException ne) {
                    LDAPPersistence.trace.warningT("populatePrincipalDatabag", "Naming exception when parsing the unique id of the principal " + orgID + " not on this datasource", ne);
                    return;
                }
                success = false;
                count = 0;
                while (!success && count < this.mm_action_retrial) {
                    ctx = this._manager.getConnection("populatePrincipalDatabag", IDParts[0], ++count);
                    destroyConnection = false;
                    try {
                        try {
                            if (LDAPPersistence.trace.beDebug()) {
                                LDAPPersistence.trace.debugT("populatePrincipalDatabag", "LDAP access getAttributes for principal " + uniqueID + " with " + JNDIUtils.traceOutPut(base, returningAttributes));
                            }
                            time1 = 0L;
                            if (LDAPPersistence.props.getBoolean("ume.ldap.record_access", false)) {
                                sb = new StringBuffer();
                                time1 = System.currentTimeMillis();
                                sb.append("populatePrincipalDatabag: ldap access at ").append(time1);
                                sb.append("\n\twith getAttributes(): base :").append(base);
                                sb.append("\n\treturnigAttributes: ");
                                i = 0;
                                while (i < returningAttributes.length) {
                                    sb.append(returningAttributes[i]).append('*');
                                    ++i;
                                }
                                LDAPPersistence.aa.print(sb.toString());
                            }
                            principalAttributes = ctx.getAttributes(base, returningAttributes);
                            if (LDAPPersistence.props.getBoolean("ume.ldap.record_access", false)) {
                                time1 = System.currentTimeMillis() - time1;
                                LDAPPersistence.aa.print("populatePrincipalDatabag:\nreturning from ldap with getAttributes after " + time1 + " ms");
                            }
                            if (populateDistinguishedName) {
                                dns = new Vector<String>();
                                if (this.caseSensitive) {
                                    dns.add(base + "," + (String)this.mm_principalPaths.get(IDParts[0]));
                                } else {
                                    dns.add((base + "," + (String)this.mm_principalPaths.get(IDParts[0])).toLowerCase());
                                }
                                principal.setAttributeValues("com.sap.security.core.bridge", "dn", dns);
                            }
                            if (LDAPPersistence.trace.beInfo()) {
                                LDAPPersistence.trace.infoT("populatePrincipalDatabag", "ldap access succesfully, setting existence check to true for principal " + principal.getUniqueID());
                            }
                            if (IDParts[1].equals(this.getId())) {
                                principal.setExists(true);
                            }
                            namespaces = _logAttr.keys();
                            while (namespaces.hasMoreElements()) {
                                namespace = (String)namespaces.nextElement();
                                logAttributes = ((HashSet)_logAttr.get(namespace)).iterator();
                                while (logAttributes.hasNext()) {
                                    block116: {
                                        block115: {
                                            block113: {
                                                logattrname = (String)logAttributes.next();
                                                physAttribute = this.getPhysicalAttribute(IDParts[0], namespace, objectclass + logattrname);
                                                if (objectclass.length() > 0) {
                                                    physAttribute = this.getRealPhysicalAttribute(physAttribute);
                                                }
                                                if ((oneAttribute = principalAttributes.get(physAttribute)) == null) break block115;
                                                allValues = oneAttribute.getAll();
                                                allVals = new Vector<String>();
                                                try {
                                                    if (namespace.equals("com.sap.security.core.usermanagement")) {
                                                        while (allValues.hasMore()) {
                                                            _val = allValues.nextElement();
                                                            if (_val instanceof String) {
                                                                value = (String)_val;
                                                                value = JNDIUtils.removeQuotes(value);
                                                                if (!"userid".equalsIgnoreCase(logattrname)) {
                                                                    value = JNDIUtils.unescapeAttributeValue(value);
                                                                    if (this.checkAttributeAsNamingAttribute(physAttribute, IDParts[0])) {
                                                                        value = JNDIUtils.unescapeComma(value);
                                                                    }
                                                                } else {
                                                                    value = JNDIUtils.specialHandlingMSADS(value);
                                                                    value = this.convertDNintoUMEID(value, null);
                                                                }
                                                                if (value == null) continue;
                                                                allVals.add(value);
                                                                continue;
                                                            }
                                                            allVals.add((String)_val);
                                                        }
                                                        break block113;
                                                    }
                                                    if (!namespace.equalsIgnoreCase("com.sap.security.core.usermanagement.relation")) ** GOTO lbl358
                                                    if (!logattrname.equalsIgnoreCase("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE") && !logattrname.equalsIgnoreCase("PRINCIPAL_RELATION_PARENT_ATTRIBUTE")) ** GOTO lbl344
                                                    if (!allValues.hasMore() && this.mm_serverType.equalsIgnoreCase("MSADS") && physAttribute.equalsIgnoreCase("member")) {
                                                        if (LDAPPersistence.trace.beInfo()) {
                                                            LDAPPersistence.trace.infoT("populatePrincipalDatabag", "member attribute is not available for MSADS, trying to read the ranged instance");
                                                        }
                                                        allAttr = principalAttributes.getAll();
                                                        while (allAttr.hasMore()) {
                                                            attr = allAttr.next();
                                                            attrID = attr.getID();
                                                            if (attrID.equalsIgnoreCase(physAttribute) || attrID.toLowerCase().indexOf(physAttribute.toLowerCase()) == -1) continue;
                                                            allValues = attr.getAll();
                                                            break;
                                                        }
                                                    }
                                                    while (allValues.hasMore()) {
                                                        _member = (String)allValues.nextElement();
                                                        dummy = LDAPPersistence.props.get("ume.ldap.default_group_member", "cn=DUMMY_MEMBER_FOR_UME");
                                                        if ((this.mm_serverType.equalsIgnoreCase("SIEMENS") || this.mm_defaultMemberEnabled) && _member.equals(dummy)) {
                                                            if (!LDAPPersistence.trace.beInfo()) continue;
                                                            LDAPPersistence.trace.infoT("populatePrincipalDatabag", "ignoring the default dummy member for UME");
                                                            continue;
                                                        }
                                                        try {
                                                            memberName = LDAPPersistence._centralNameParser.parse(_member);
                                                            _member = memberName.toString();
                                                            _member = JNDIUtils.specialHandlingMSADS(_member);
                                                            _member = this.convertDNintoUMEID(_member, null);
                                                            if (_member == null || this._blockedPrincipals.contains(_member)) continue;
                                                            allVals.add(_member);
                                                        }
                                                        catch (NamingException e) {
                                                            LDAPPersistence.trace.warningT("populatePrincipalDatabag", "invalid ldap member " + _member, e);
                                                        }
                                                    }
                                                    break block113;
lbl-1000:
                                                    // 1 sources

                                                    {
                                                        _val = allValues.nextElement();
                                                        if (_val instanceof String) {
                                                            value = (String)_val;
                                                            value = JNDIUtils.removeQuotes(value);
                                                            value = JNDIUtils.unescapeAttributeValue(value);
                                                            if (this.checkAttributeAsNamingAttribute(physAttribute, IDParts[0])) {
                                                                value = JNDIUtils.unescapeComma(value);
                                                            }
                                                            allVals.add(value);
                                                            continue;
                                                        }
                                                        allVals.add((String)_val);
lbl344:
                                                        // 3 sources

                                                        ** while (allValues.hasMore())
                                                    }
lbl345:
                                                    // 1 sources

                                                    break block113;
lbl-1000:
                                                    // 1 sources

                                                    {
                                                        _val = allValues.nextElement();
                                                        if (_val instanceof String) {
                                                            value = (String)_val;
                                                            value = JNDIUtils.removeQuotes(value);
                                                            value = JNDIUtils.unescapeAttributeValue(value);
                                                            if (this.checkAttributeAsNamingAttribute(physAttribute, IDParts[0])) {
                                                                value = JNDIUtils.unescapeComma(value);
                                                            }
                                                            allVals.add(value);
                                                            continue;
                                                        }
                                                        allVals.add((String)_val);
lbl358:
                                                        // 3 sources

                                                        ** while (allValues.hasMore())
                                                    }
lbl359:
                                                    // 1 sources

                                                }
                                                catch (PartialResultException e) {
                                                    if (!LDAPPersistence.trace.beInfo()) break block113;
                                                    sb = new StringBuffer();
                                                    sb.append("partial result exception when getting attributes for ");
                                                    sb.append(principal.getUniqueID()).append("; [EXCEPTION: ");
                                                    sb.append(e.getMessage()).append("]");
                                                    LDAPPersistence.trace.infoT("populatePrincipalDatabag", sb.toString());
                                                }
                                            }
                                            principal.setAttributeValues("com.sap.security.core.usermanagement", logattrname, this.buildUnion(new Vector[]{allVals, principal.getAttributeValues(namespace, logattrname)}));
                                            break block116;
                                        }
                                        principal.setAttributeValues(namespace, logattrname, this.buildUnion(new Vector[]{new Vector<E>(), principal.getAttributeValues(namespace, logattrname)}));
                                    }
                                    if (!LDAPPersistence.trace.beInfo()) continue;
                                    LDAPPersistence.trace.infoT("populatePrincipalDatabag", "populated attribute " + logattrname + " on namespace " + namespace + " for principal " + principal.getUniqueID());
                                }
                            }
                            if (LDAPPersistence.trace.beInfo()) {
                                LDAPPersistence.trace.infoT("populatePrincipalDatabag", "prinicipal " + uniqueID + " successfully populated");
                            }
                            success = true;
                        }
                        catch (PartialResultException e) {
                            if (LDAPPersistence.trace.beInfo()) {
                                LDAPPersistence.trace.infoT("populateAttributesForPrincipal", " partial result exception because of some unrecognized referrals; " + e.getMessage());
                            }
                            var40_64 = null;
                            this._manager.releaseConnection(IDParts[0], ctx, destroyConnection);
                            continue;
                        }
                        catch (NoInitialContextException nice) {
                            if (LDAPPersistence.trace.beInfo()) {
                                LDAPPersistence.trace.infoT("populatePrincipalDatabag", "no initial context when populating principal " + principal.getUniqueID(), nice);
                            }
                            destroyConnection = true;
                            if (count == this.mm_action_retrial) {
                                throw new PersistenceException(nice);
                            }
                            var40_64 = null;
                            this._manager.releaseConnection(IDParts[0], ctx, destroyConnection);
                            continue;
                        }
                        catch (CommunicationException ce) {
                            if (LDAPPersistence.trace.beInfo()) {
                                LDAPPersistence.trace.infoT("populatePrincipalDatabag", "communication exception when populating principal " + principal.getUniqueID(), ce);
                            }
                            destroyConnection = true;
                            if (count == this.mm_action_retrial) {
                                throw new PersistenceException(ce);
                            }
                            var40_64 = null;
                            this._manager.releaseConnection(IDParts[0], ctx, destroyConnection);
                            continue;
                        }
                        catch (NameNotFoundException e) {
                            LDAPPersistence.trace.warningT("populatePrincipalDatabag", "principal with id " + principal.getUniqueID() + " not found on datasource " + this.getId(), e);
                            principal.setExists(false);
                            var40_64 = null;
                            this._manager.releaseConnection(IDParts[0], ctx, destroyConnection);
                            return;
                        }
                        catch (NamingException e) {
                            LDAPPersistence.trace.errorT("populateAttributesForPrincipal", "error when populating a principal databag " + principal.getUniqueID(), e);
                            LDAPPersistence.trace.logErrorT("DataSource {0}: Problems when reading principal {1} from LDAP: {2} ", new Object[]{this.getId(), principal, e.getMessage()});
                            throw new PersistenceException(e);
                        }
                        catch (Exception e) {
                            LDAPPersistence.trace.errorT("populateAttributesForPrincipal", "some error occured when populating a principal " + principal.getUniqueID(), e);
                            LDAPPersistence.trace.logErrorT("DataSource {0}: Exception when populating principal {1}: {2} ", new Object[]{this.getId(), principal, e.getMessage()});
                            throw new PersistenceException(e);
                        }
                        var40_64 = null;
                        this._manager.releaseConnection(IDParts[0], ctx, destroyConnection);
                    }
                    catch (Throwable var39_65) {
                        var40_64 = null;
                        this._manager.releaseConnection(IDParts[0], ctx, destroyConnection);
                        throw var39_65;
                    }
                }
                if (populateParents) {
                    if (LDAPPersistence.trace.beInfo()) {
                        LDAPPersistence.trace.infoT("populatePrincipalDatabag", "Populating the direct parents of the principal " + principal.getUniqueID());
                    }
                    this.populateDirectParents(principal);
                }
                if (populateChilds) {
                    if (LDAPPersistence.trace.beInfo()) {
                        LDAPPersistence.trace.infoT("populatePrincipalDatabag", "Populating the direct childs of the principal " + principal.getUniqueID());
                    }
                    this.populateDirectChilds(principal);
                }
                if (LDAPPersistence.trace.beInfo()) {
                    LDAPPersistence.trace.infoT("populatePrincipalDatabag", "Principal populated " + principal.toString());
                }
                break block117;
            }
            if (LDAPPersistence.trace.beInfo()) {
                LDAPPersistence.trace.infoT("populatePrincipalDatabag", "No returning attributes specified, no ldap access");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean populatePrincipalDatabag(IInternalPrincipalDatabag principal, String nameSpace, String attribute) throws PersistenceException {
        String mn = "populatePrincipalDatabag";
        boolean populateDistinguishedName = false;
        if (trace.bePath()) {
            trace.entering("populatePrincipalDatabag", new Object[]{principal, nameSpace, attribute});
        }
        if (!this.isInitialized || this.lazyInitialisation) {
            StringBuffer sb = new StringBuffer();
            sb.append("Data source is not initialized:").append(this.getId());
            trace.errorT("populatePrincipalDatabag", sb.toString());
            trace.logErrorT(sb.toString(), null);
            throw new PersistenceException(sb.toString());
        }
        if (principal == null) {
            trace.errorT("populatePrincipalDatabag", "can not populate attributes, when principal is null.");
            trace.logErrorT("DatasSource {0}: Can not populate attributes, when principal is null.", new Object[]{this.getId()});
            throw new PersistenceException("principal is null");
        }
        String uniqueID = principal.getUniqueID();
        if (uniqueID == null) {
            trace.errorT("populatePrincipalDatabag", "principal databag not bound, unique id is null");
            trace.logErrorT("DataSource {0} unique id is null", new Object[]{this.getId()});
            throw new PersistenceException("unique id is null");
        }
        if (!this.isPrimary()) {
            trace.warningT("populatePrincipalDatabag", "data source is not primary when populating data dor principal " + principal.getUniqueID());
            return false;
        }
        if (!this.feelsResponsible(principal, nameSpace, attribute)) {
            if (trace.beInfo()) {
                StringBuffer sb = new StringBuffer();
                sb.append("Data source ").append(this.getId()).append(" is not responsible for principal ");
                sb.append(principal.getUniqueID()).append(" for namespace ").append(nameSpace);
                sb.append(" and attribute ").append(attribute);
                trace.infoT("populatePrincipalDatabag", sb.toString());
            }
            return false;
        }
        String[] IDParts = principal.getIDParts();
        if (!IDParts[1].equals(this.getId())) {
            if (trace.beInfo()) {
                StringBuffer sb = new StringBuffer();
                sb.append("Principal ").append(principal.getUniqueID()).append(" not on this datasource ");
                sb.append(this.getId());
                trace.infoT("populatePrincipalDatabag", sb.toString());
            }
            return false;
        }
        if (!this.caseSensitive && !IDParts[2].equals(IDParts[2].toLowerCase())) {
            StringBuffer sb = new StringBuffer();
            sb.append("Principal ").append(IDParts[2]).append(" not in lower cases and not created by data source");
            sb.append(this.getId());
            trace.warningT("populatePrincipalDatabag", sb.toString());
            return false;
        }
        String orgID = IDParts[2];
        ArrayList uniAttr = (ArrayList)this.mm_principalUniqueAttributes.get(IDParts[0]);
        if (uniAttr != null) {
            orgID = this.getDNfromID(uniAttr, IDParts[2], IDParts[0]);
        }
        Vector objectclasses = (Vector)this.mm_principalObjectclasses.get(IDParts[0]);
        String objectclass = "";
        if (objectclasses != null && objectclasses.size() > 1) {
            objectclass = this.getObjectclass(IDParts[0], orgID) + ":";
        }
        if (IDParts[0].equals("UACC") && nameSpace.equals("com.sap.security.core.usermanagement") && attribute.equals("userid") && this.getPhysicalAttribute(IDParts[0], nameSpace, objectclass + attribute).equals(NO_MAPPING) && this.mm_principalUniqueAttributes.get(IDParts[0]) == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("USER").append(PRINCIPAL_SEPARATOR).append(this.getId());
            sb.append(PRINCIPAL_SEPARATOR);
            if (this.caseSensitive) {
                sb.append(IDParts[2]);
            } else {
                sb.append(IDParts[2].toLowerCase());
            }
            principal.addAttributeValue(nameSpace, attribute, sb.toString());
            return true;
        }
        if (nameSpace.equals("com.sap.security.core.bridge") && attribute.equals("dn")) {
            populateDistinguishedName = true;
        }
        String physName = this.getPhysicalAttribute(IDParts[0], nameSpace, objectclass + attribute);
        if ((!(physName = this.getRealPhysicalAttribute(physName)).equals(NO_MAPPING) || populateDistinguishedName) && orgID != null) {
            String[] returningAttributes = new String[]{physName};
            boolean success = false;
            int count = 0;
            while (!success && count < this.mm_action_retrial) {
                Object var30_48;
                ++count;
                String name = null;
                Name _base = null;
                try {
                    Name _principalID = _centralNameParser.parse(orgID);
                    _base = _centralNameParser.parse((String)this.mm_principalPaths.get(IDParts[0]));
                    name = JNDIUtils.getRelativeBase(_principalID, _base);
                }
                catch (NamingException e) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("Naming excepton when parsing id ").append(orgID);
                    sb.append(" Exception: ").append(e.getMessage());
                    trace.warningT("populatePrincipalDatabag", sb.toString());
                    return false;
                }
                InitialDirContext ctx = this._manager.getConnection("populatePrincipalDatabag", IDParts[0], count);
                boolean destroyConnection = false;
                try {
                    StringBuffer sb;
                    StringBuffer sb2;
                    StringBuffer sb3;
                    try {
                        Attribute _attribute;
                        if (trace.beDebug()) {
                            trace.debugT("populateAttributesForPrincipal", "ldap access for prinicpal with " + JNDIUtils.traceOutPut(name, returningAttributes));
                        }
                        long time1 = 0L;
                        if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                            time1 = System.currentTimeMillis();
                            sb3 = new StringBuffer("populatePrincipalDatabag: ldap access at: " + time1);
                            sb3.append("\n\twith getAttributes(): base: " + name);
                            sb3.append("\n\treturning attributes: ");
                            int i = 0;
                            while (true) {
                                if (i >= returningAttributes.length) {
                                    aa.print(sb3.toString());
                                    break;
                                }
                                sb3.append(returningAttributes[i]).append(",");
                                ++i;
                            }
                        }
                        Attributes principalAttributes = ctx.getAttributes(name, returningAttributes);
                        if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                            time1 = System.currentTimeMillis() - time1;
                            aa.print("populatePrincipalDatabag(): returning from ldap with getAttributes() after :" + time1 + " ms");
                        }
                        if (trace.beInfo()) {
                            trace.infoT("populatePrincipalDatabag", "ldap access succesfully, setting existence check to true for principal " + principal.getUniqueID());
                        }
                        if (IDParts[1].equals(this.getId())) {
                            principal.setExists(true);
                        }
                        if (populateDistinguishedName) {
                            Vector<String> dns = new Vector<String>();
                            if (this.caseSensitive) {
                                dns.add(name + "," + _base.toString());
                            } else {
                                dns.add((name + "," + _base.toString()).toLowerCase());
                            }
                            principal.setAttributeValues("com.sap.security.core.bridge", "dn", dns);
                        }
                        if ((_attribute = principalAttributes.get(physName)) != null) {
                            NamingEnumeration<?> _attrVals = _attribute.getAll();
                            if (!_attrVals.hasMore() && this.mm_serverType.equalsIgnoreCase("MSADS") && physName.equalsIgnoreCase("member")) {
                                if (trace.beInfo()) {
                                    trace.infoT("populatePrincipalDatabag", "member attribute is not available for MSADS, trying to read the ranged instance");
                                }
                                NamingEnumeration<? extends Attribute> allAttr = principalAttributes.getAll();
                                while (allAttr.hasMore()) {
                                    Attribute attr = allAttr.next();
                                    String attrID = attr.getID();
                                    if (attrID.equalsIgnoreCase(physName) || attrID.toLowerCase().indexOf(physName.toLowerCase()) == -1) continue;
                                    _attrVals = attr.getAll();
                                    break;
                                }
                            }
                            Vector<String> _allVals = new Vector<String>();
                            try {
                                while (_attrVals.hasMore()) {
                                    if (nameSpace.equals("com.sap.security.core.usermanagement.relation") && attribute.equals("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE") || attribute.equals("PRINCIPAL_RELATION_PARENT_ATTRIBUTE")) {
                                        String member = (String)_attrVals.next();
                                        String dummy = props.get(DUMMY_MEMBER, default_member);
                                        if ((this.mm_serverType.equalsIgnoreCase("SIEMENS") || this.mm_defaultMemberEnabled) && member.equalsIgnoreCase(dummy)) {
                                            if (!trace.beInfo()) continue;
                                            trace.infoT("populatePrincipalDatabag", "ignoring the UME dummy member for UME");
                                            continue;
                                        }
                                        try {
                                            Name _member = _centralNameParser.parse(member);
                                            member = _member.toString();
                                            member = JNDIUtils.specialHandlingMSADS(member);
                                            if ((member = this.convertDNintoUMEID(member, null)) == null || this._blockedPrincipals.contains(member)) continue;
                                            _allVals.add(member);
                                        }
                                        catch (NamingException e) {
                                            trace.warningT("populatePrincipalDatabag", "not a valid ldap member (ignoring): " + member, e);
                                        }
                                        continue;
                                    }
                                    Object _val = _attrVals.nextElement();
                                    if (_val instanceof String) {
                                        String value = (String)_val;
                                        if (!"userid".equalsIgnoreCase(attribute)) {
                                            value = JNDIUtils.removeQuotes(value);
                                            value = JNDIUtils.unescapeAttributeValue(value);
                                            if (this.checkAttributeAsNamingAttribute(physName, IDParts[0])) {
                                                value = JNDIUtils.unescapeComma(value);
                                            }
                                        } else {
                                            value = this.convertDNintoUMEID(value, null);
                                        }
                                        if (value == null) continue;
                                        _allVals.add(value);
                                        continue;
                                    }
                                    _allVals.add((String)_val);
                                }
                            }
                            catch (PartialResultException e) {
                                sb2 = new StringBuffer();
                                sb2.append("Partial result exception when processing attribute values ");
                                sb2.append("Exception: ").append(e.getMessage());
                                trace.infoT("populatePrincipalDatabag", sb2.toString());
                            }
                            principal.setAttributeValues(nameSpace, attribute, this.buildUnion(new Vector[]{_allVals, principal.getAttributeValues(nameSpace, attribute)}));
                        } else {
                            principal.setAttributeValues(nameSpace, attribute, this.buildUnion(new Vector[]{new Vector(), principal.getAttributeValues(nameSpace, attribute)}));
                        }
                        if (trace.beInfo()) {
                            sb = new StringBuffer();
                            sb.append("Populated for principal ").append(principal.getUniqueID()).append(" attribute ");
                            sb.append(attribute).append(" on namespace ").append(nameSpace);
                            trace.infoT("populatePrincipalDatabag", sb.toString());
                        }
                        success = true;
                    }
                    catch (NameNotFoundException e) {
                        trace.warningT("populatePrincipalDatabag", "name not found exception when trying to populate one attribute for principal " + principal.getUniqueID(), e);
                        trace.logWarningT("Could not find principal {0} when populating attribute", new Object[]{principal.getUniqueID()});
                        principal.setExists(false);
                        var30_48 = null;
                        this._manager.releaseConnection(IDParts[0], ctx, destroyConnection);
                        continue;
                    }
                    catch (PartialResultException e) {
                        if (trace.beInfo()) {
                            sb3 = new StringBuffer();
                            sb3.append("Partial result exception because of some unrecognized referrals");
                            sb3.append("Exception: ").append(e.getMessage());
                            trace.infoT("populatePrincipalDatabag", sb3.toString());
                        }
                        var30_48 = null;
                        this._manager.releaseConnection(IDParts[0], ctx, destroyConnection);
                        continue;
                    }
                    catch (SizeLimitExceededException e) {
                        StringBuffer sb4 = new StringBuffer();
                        sb4.append("Size limit exceeded exception when populating one attribute");
                        sb4.append("Exception: ").append(e.getMessage());
                        trace.warningT("populatePrincipalDatabag", sb4.toString());
                        var30_48 = null;
                        this._manager.releaseConnection(IDParts[0], ctx, destroyConnection);
                        continue;
                    }
                    catch (TimeLimitExceededException e) {
                        sb = new StringBuffer();
                        sb.append("Time limit exceeded exception when populating one attribute");
                        sb.append("Exception: ").append(e.getMessage());
                        trace.warningT("populatePrincipalDatabag", sb.toString());
                        var30_48 = null;
                        this._manager.releaseConnection(IDParts[0], ctx, destroyConnection);
                        continue;
                    }
                    catch (CommunicationException ce) {
                        destroyConnection = true;
                        if (trace.beInfo()) {
                            trace.infoT("populatePrincipalDatabag", "Communication exception, destroying corrupt context", ce);
                        }
                        if (count == this.mm_action_retrial) {
                            throw new PersistenceException(ce);
                        }
                        var30_48 = null;
                        this._manager.releaseConnection(IDParts[0], ctx, destroyConnection);
                        continue;
                    }
                    catch (NoInitialContextException ce) {
                        destroyConnection = true;
                        if (trace.beInfo()) {
                            trace.infoT("populatePrincipalDatabag", "No initial context exception, destroying corrupt context", ce);
                        }
                        if (count == this.mm_action_retrial) {
                            throw new PersistenceException(ce);
                        }
                        var30_48 = null;
                        this._manager.releaseConnection(IDParts[0], ctx, destroyConnection);
                        continue;
                    }
                    catch (NamingException e) {
                        sb2 = new StringBuffer("Naming Excepiton when populating principal ");
                        sb2.append(principal.getUniqueID()).append(": ").append(e.getMessage());
                        trace.errorT("populateAttributesForPrincipal", sb2.toString());
                        trace.logErrorT("DataSource {0}: Naming Excepiton when populating principal {1}: Exception {2}", new Object[]{this.getId(), principal, e});
                        throw new PersistenceException(e);
                    }
                    catch (Exception e) {
                        StringBuffer sb5 = new StringBuffer("Excepiton error when populating principal ");
                        sb5.append(principal.getUniqueID()).append(": ").append(e.getMessage());
                        trace.errorT("populateAttributesForPrincipal", sb5.toString());
                        trace.logErrorT("DataSource {0}: Excepiton when populating principal {1}: Exception {2}", new Object[]{this.getId(), principal, e});
                        throw new PersistenceException(e);
                    }
                    var30_48 = null;
                    this._manager.releaseConnection(IDParts[0], ctx, destroyConnection);
                }
                catch (Throwable throwable) {
                    var30_48 = null;
                    this._manager.releaseConnection(IDParts[0], ctx, destroyConnection);
                    throw throwable;
                }
            }
        } else {
            if (nameSpace.equals("com.sap.security.core.usermanagement") && attribute.equals("userid")) {
                StringBuffer sb = new StringBuffer();
                sb.append("USER").append(PRINCIPAL_SEPARATOR).append(this.getId()).append(PRINCIPAL_SEPARATOR);
                if (this.caseSensitive) {
                    sb.append(orgID);
                } else {
                    sb.append(orgID.toLowerCase());
                }
                principal.addAttributeValue(nameSpace, attribute, sb.toString());
            }
            if (nameSpace.equals("com.sap.security.core.usermanagement.relation") && attribute.equals("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE")) {
                if (trace.beInfo()) {
                    trace.infoT("populatePrincipalDatabag", "populating direct childs for principal " + principal.getUniqueID());
                }
                this.populateDirectChilds(principal);
            }
            if (nameSpace.equals("com.sap.security.core.usermanagement.relation") && attribute.equals("PRINCIPAL_RELATION_PARENT_ATTRIBUTE")) {
                if (trace.beInfo()) {
                    trace.infoT("populatePrincipalDatabag", "populating direct parents for principal " + principal.getUniqueID());
                }
                this.populateDirectParents(principal);
            }
        }
        if (trace.beInfo()) {
            trace.infoT("populatePrincipalDatabag", "principal populated " + principal.toString());
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void createPrincipalDatabag(IInternalPrincipalDatabag principal) throws PersistenceException {
        block88: {
            block87: {
                block89: {
                    mn = "createPrincipalDatabag";
                    if (LDAPPersistence.trace.bePath()) {
                        LDAPPersistence.trace.entering("createPrincipalDatabag", new Object[]{principal});
                    }
                    if (this.isInitialized && !this.lazyInitialisation) break block89;
                    LDAPPersistence.trace.errorT("createPrincipalDatabag", "data source is not initialized");
                    if (!this.lazyInitialisation) ** GOTO lbl12
                    if (this.reinitializeConnectionManager()) {
                        LDAPPersistence.trace.warningT("createPrincipalDatabag", "connection manager initialized");
                    } else {
                        LDAPPersistence.trace.logErrorT("Data source {0} not initialized", new Object[]{this.getId()});
                        throw new PersistenceException("data source " + this.getId() + " not initialized");
lbl12:
                        // 1 sources

                        LDAPPersistence.trace.logErrorT("Data source {0} not initialized", new Object[]{this.getId()});
                        throw new PersistenceException("data source " + this.getId() + " not initialized");
                    }
                }
                if (this.isReadonly()) {
                    if (LDAPPersistence.trace.beInfo()) {
                        LDAPPersistence.trace.infoT("createPrincipalDatabag", "datasource " + this.getId() + " is readonly.");
                    }
                    return;
                }
                if (!this.feelsResponsible(principal)) {
                    if (LDAPPersistence.trace.beInfo()) {
                        sb = new StringBuffer();
                        sb.append("Data source ").append(this.getId()).append(" not responsible for ");
                        sb.append(principal.getUniqueID());
                        LDAPPersistence.trace.infoT("createPrincipalDatabag", sb.toString());
                    }
                    return;
                }
                uniqueID = principal.getUniqueID();
                if (uniqueID == null) {
                    LDAPPersistence.trace.errorT("createPrincipalDatabag", "principal is not bound to a data source.");
                    LDAPPersistence.trace.logErrorT("DataSource {0}: Unique id is null of principal {1}", new Object[]{this.getId(), principal});
                    throw new PersistenceException("unique id is null");
                }
                IDParts = principal.getIDParts();
                if (!IDParts[1].equals(this.getId())) {
                    if (LDAPPersistence.trace.beInfo()) {
                        sb = new StringBuffer();
                        sb.append(principal.getUniqueID()).append(" not on data source ").append(this.getId());
                        LDAPPersistence.trace.infoT("createPrincipalDatabag", sb.toString());
                    }
                    return;
                }
                if (IDParts[0].equals("UACC") && this.mm_userAsUseraccount) {
                    if (LDAPPersistence.trace.beInfo()) {
                        sb = new StringBuffer();
                        sb.append("Data source ").append(this.getId()).append(" doesn't support creation of useraccounts ");
                        sb.append("useraccounts are automatically created when a user is created, the user is only updated");
                        LDAPPersistence.trace.infoT("createPrincipalDatabag", sb.toString());
                    }
                    this.createUserAccount(principal);
                    return;
                }
                objectclasses = (Vector)this.mm_principalObjectclasses.get(IDParts[0]);
                mapobjectclass = "";
                if (objectclasses != null && objectclasses.size() > 1) {
                    mapobjectclass = (String)objectclasses.firstElement() + ":";
                }
                namespaces = principal.getNameSpaces();
                ldapAttributes = new BasicAttributes();
                while (namespaces.hasMoreElements()) {
                    _namespace = (String)namespaces.nextElement();
                    attributes = principal.getAttributesOnNamespace(_namespace);
                    while (attributes.hasMoreElements()) {
                        _attributeName = (String)attributes.nextElement();
                        if (!this.feelsResponsible(IDParts[0], _namespace, _attributeName)) continue;
                        physicalAN = this.getPhysicalAttribute(IDParts[0], _namespace, mapobjectclass + _attributeName);
                        if ((physicalAN = this.getRealPhysicalAttribute(physicalAN)).equals("*null*")) continue;
                        ldapAttribute = new BasicAttribute(physicalAN);
                        valueAdded = false;
                        attributeValues = principal.getAttributeValues(_namespace, _attributeName);
                        if (_attributeName.equals("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE") != false && IDParts[0].equals("GRUP") != false || _attributeName.equals("PRINCIPAL_RELATION_PARENT_ATTRIBUTE") != false && IDParts[0].equals("USER") != false || _attributeName.equals("userid") && IDParts[0].equals("UACC")) {
                            i = 0;
                            while (i < attributeValues.size()) {
                                block86: {
                                    _uniID = (String)attributeValues.elementAt(i);
                                    _IDParts = this.splitPrincipalDatabagID(_uniID);
                                    uniIDPart = _IDParts[2];
                                    uniIDPart = JNDIUtils.specialHandlingBackMSADS(uniIDPart);
                                    uniAttr = (ArrayList)this.mm_principalUniqueAttributes.get(_IDParts[0]);
                                    if (uniAttr != null) {
                                        uniIDPart = this.getDNfromID(uniAttr, uniIDPart, _IDParts[0]);
                                    }
                                    try {
                                        if (uniIDPart != null) {
                                            LDAPPersistence._centralNameParser.parse(uniIDPart);
                                            ldapAttribute.add(uniIDPart);
                                            valueAdded = true;
                                            if (_attributeName.equals("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE")) {
                                                parentAttribute = this.getPhysicalAttribute(IDParts[0], "com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_PARENT_ATTRIBUTE");
                                                if (!parentAttribute.equals("*null*")) {
                                                    this.updateContext(IDParts[0], uniIDPart, parentAttribute, IDParts[2], 1);
                                                }
                                            } else {
                                                memberAttribute = this.getPhysicalAttribute(IDParts[0], "com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE");
                                                if (!memberAttribute.equals("*null*")) {
                                                    this.updateContext(IDParts[0], uniIDPart, memberAttribute, IDParts[2], 1);
                                                }
                                            }
                                        }
                                    }
                                    catch (NamingException e) {
                                        if (!LDAPPersistence.trace.beInfo()) break block86;
                                        sb = new StringBuffer();
                                        sb.append("Can not add ").append(_uniID).append(" to ").append(principal.getUniqueID());
                                        sb.append(" [Exception: ").append(e.getMessage()).append("]");
                                        LDAPPersistence.trace.infoT("createPrincipalDatabag", sb.toString());
                                    }
                                }
                                ++i;
                            }
                        } else {
                            if (physicalAN.equals("j_password") && this.mm_serverType.equalsIgnoreCase("MSADS")) {
                                if (!this.mm_sslEnabled) {
                                    LDAPPersistence.trace.warningT("createPrincipalDatabag", "Can't create account in MSADS without ssl connection");
                                    LDAPPersistence.trace.logWarningT("DataSource {0}: Can't create account in MSADS without ssl connection", new Object[]{this.getId()});
                                    return;
                                }
                                passwords = principal.getAttributeValues(_namespace, _attributeName);
                                if (passwords != null && passwords.size() > 0) {
                                    password = (String)passwords.firstElement();
                                    sb = new StringBuffer();
                                    sb.append("\"").append(password).append("\"");
                                    password = sb.toString();
                                    try {
                                        _bytes = password.getBytes("UTF-16LE");
                                        attr = new BasicAttribute(physicalAN);
                                        attr.add(_bytes);
                                        ldapAttributes.put(attr);
                                        valueAdded = true;
                                    }
                                    catch (Exception e) {
                                        LDAPPersistence.trace.errorT("createPrincipalDatabag", "can't create unicode password for MSADS", e);
                                        LDAPPersistence.trace.logErrorT("DataSource {0}: Can't create unicode password for MSADS", new Object[]{this.getId()});
                                        throw new PersistenceException("can't create user account");
                                    }
                                }
                            }
                            i = 0;
                            while (i < attributeValues.size()) {
                                _val = attributeValues.elementAt(i);
                                if (_val instanceof String) {
                                    _value = (String)_val;
                                    if (_value.length() > 0) {
                                        _value = JNDIUtils.escapeAttributeValue(_value);
                                        if (this.checkAttributeAsNamingAttribute(physicalAN, IDParts[0])) {
                                            _value = JNDIUtils.escapeComma(_value);
                                        }
                                        ldapAttribute.add(_value);
                                        valueAdded = true;
                                    }
                                } else {
                                    ldapAttribute.add(_val);
                                    valueAdded = true;
                                }
                                ++i;
                            }
                        }
                        if (!valueAdded) continue;
                        ldapAttributes.put(ldapAttribute);
                    }
                }
                if (this.mm_serverType.equalsIgnoreCase("MSADS") && IDParts[0].equals("UACC")) {
                    controlAttribute = LDAPPersistence.props.get("ume.ldap.access.msads.control_attribute", "userAccountControl");
                    uaControl = new BasicAttribute(controlAttribute);
                    controlValue = LDAPPersistence.props.get("ume.ldap.access.msads.control_value", "512");
                    uaControl.add(controlValue);
                    ldapAttributes.put(uaControl);
                }
                vals = principal.getAttributeValues("com.sap.security.core.usermanagement", "uniquename");
                _updatedpath = null;
                namAttr = (Vector)this.mm_principalNamingAttributes.get(IDParts[0]);
                nAttr = (String)namAttr.firstElement();
                if (ldapAttributes.get(nAttr) == null) {
                    namingAttribute = new BasicAttribute(nAttr);
                    logAttribute = this.getLogicalAttribute(IDParts[0], "com.sap.security.core.usermanagement", mapobjectclass + nAttr);
                    namVals = principal.getAttributeValues("com.sap.security.core.usermanagement", logAttribute);
                    _val = (String)vals.firstElement();
                    if (namVals != null && namVals.size() > 0) {
                        _val = (String)namVals.firstElement();
                    }
                    _val = JNDIUtils.escapeComma(_val);
                    namingAttribute.add(JNDIUtils.escapeAttributeValue(_val));
                    ldapAttributes.put(namingAttribute);
                    _val = JNDIUtils.escapeBackSlash(_val);
                    _val = JNDIUtils.escapeDistinguishedName(_val);
                    _val = JNDIUtils.specialHandlingMSADS(_val);
                    _updatedpath = nAttr + "=" + _val;
                } else {
                    try {
                        value = (String)ldapAttributes.get(nAttr).getAll().next();
                        value = JNDIUtils.unescapeAttributeValue(value);
                        if (this.checkAttributeAsNamingAttribute(nAttr, IDParts[0])) {
                            value = JNDIUtils.unescapeComma(value);
                        }
                        value = JNDIUtils.escapeBackSlash(value);
                        value = JNDIUtils.escapeDistinguishedName(value);
                        value = JNDIUtils.specialHandlingMSADS(value);
                        _updatedpath = nAttr + "=" + value;
                    }
                    catch (Exception e) {
                        if (!LDAPPersistence.trace.beInfo()) break block87;
                        sb = new StringBuffer();
                        sb.append("Problems when trying to get case sensitive creation path for ");
                        sb.append(principal.getUniqueID()).append("; using the default one from the unique id");
                        sb.append(" Exception: ").append(e.getMessage());
                        LDAPPersistence.trace.infoT("createPrincipalDatabag", sb.toString());
                    }
                }
            }
            axNamAttr = (Vector)this.mm_principalAuxiliaryNamingAttributes.get(IDParts[0]);
            if (axNamAttr != null) {
                i = 0;
                while (i < axNamAttr.size()) {
                    anAttr = (String)axNamAttr.get(i);
                    if (ldapAttributes.get(anAttr) == null) {
                        anamingAttribute = new BasicAttribute(anAttr);
                        logAttribute = this.getLogicalAttribute(IDParts[0], "com.sap.security.core.usermanagement", mapobjectclass + nAttr);
                        namVals = principal.getAttributeValues("com.sap.security.core.usermanagement", logAttribute);
                        _aval = (String)vals.firstElement();
                        if (namVals != null && namVals.size() > 0) {
                            _aval = (String)namVals.firstElement();
                        }
                        _aval = JNDIUtils.escapeAttributeValue(_aval);
                        anamingAttribute.add(_aval);
                        ldapAttributes.put(anamingAttribute);
                    }
                    ++i;
                }
            }
            if (IDParts[0].equals("USER") && this.mm_userAsUseraccount) {
                allAttributes = ldapAttributes.getAll();
                physDescription = this.getPhysicalAttribute(IDParts[0], "com.sap.security.core.usermanagement", "description");
                desc /* !! */  = null;
                try {
                    while (allAttributes.hasMore()) {
                        oneAttr = allAttributes.next();
                        if (!oneAttr.getID().equals("description")) continue;
                        desc /* !! */  = oneAttr;
                    }
                    if (desc /* !! */  == null) {
                        desc /* !! */  = new BasicAttribute(physDescription);
                        desc /* !! */ .add("NO_USER_ACCOUNT");
                        ldapAttributes.put(desc /* !! */ );
                    } else {
                        ldapAttributes.remove(physDescription);
                        desc /* !! */ .add("NO_USER_ACCOUNT");
                        ldapAttributes.put(desc /* !! */ );
                    }
                }
                catch (NamingException e) {
                    if (!LDAPPersistence.trace.beInfo()) break block88;
                    sb = new StringBuffer();
                    sb.append("Problem when updating object with flag NO_USER_ACCOUNT Exception: ").append(e.getMessage());
                    LDAPPersistence.trace.infoT("createPrincipalDatabag", sb.toString());
                }
            }
        }
        objectclass = (String)((Vector)this.mm_principalObjectclasses.get(IDParts[0])).firstElement();
        objectclassAttribute = new BasicAttribute("objectclass");
        objectclassAttribute.add(objectclass);
        _auxobjectclasses = this.mm_principalAuxiliaryObjectclasses.get(IDParts[0]);
        if (_auxobjectclasses != null) {
            auxobjectclasses = (Vector)_auxobjectclasses;
            i = 0;
            while (i < auxobjectclasses.size()) {
                objectclassAttribute.add((String)auxobjectclasses.get(i));
                ++i;
            }
        }
        ldapAttributes.put(objectclassAttribute);
        if ((this.mm_serverType.equalsIgnoreCase("SIEMENS") || this.mm_defaultMemberEnabled) && IDParts[0].equals("GRUP")) {
            if (LDAPPersistence.trace.beInfo()) {
                LDAPPersistence.trace.infoT("createPrincipalDatabag", "checking for UME if one member is set, if not set the default dummy member");
            }
            if ((logMemberAttr = this.getPhysicalAttribute("GRUP", "com.sap.security.core.usermanagement.relation", mapobjectclass + "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE")) != null && !logMemberAttr.equals("*null*") && (mem = ldapAttributes.get(logMemberAttr)) == null) {
                dummy = LDAPPersistence.props.get("ume.ldap.default_group_member", "cn=DUMMY_MEMBER_FOR_UME");
                if (LDAPPersistence.trace.beInfo()) {
                    LDAPPersistence.trace.infoT("createPrincipalDatabag", "no member attribute set for UME, setting the default " + dummy);
                }
                memAttr = new BasicAttribute(logMemberAttr);
                memAttr.add(dummy);
                ldapAttributes.put(memAttr);
            }
        }
        if (this.mm_serverType.equalsIgnoreCase("MSADS") && IDParts[0].equals("GRUP") && !(groupTypeAttribute = this.getConfigurationStringValue(this.mConfigurationModel, "ume.ldap.access.msads.grouptype.attribute", "grouptype")).equals("") && !groupTypeAttribute.equals("none")) {
            groupTypeValue = this.getConfigurationStringValue(this.mConfigurationModel, "ume.ldap.access.msads.grouptype.value", "4");
            groupType = new BasicAttribute(groupTypeAttribute);
            groupType.add(groupTypeValue);
            ldapAttributes.put(groupType);
            if (LDAPPersistence.trace.beInfo()) {
                LDAPPersistence.trace.infoT("createPrincipalDatabag", "Group created with grouptype attribute " + groupTypeAttribute + " and value " + groupTypeValue);
            }
        }
        success = false;
        count = 0;
        while (!success && count < this.mm_action_retrial) {
            ++count;
            distinName = IDParts[2];
            if (this.mm_principalUniqueAttributes.get(IDParts[0]) != null) {
                distinName = this.createDistinguishedName(principal);
            }
            name = null;
            try {
                _base = LDAPPersistence._centralNameParser.parse((String)this.mm_principalPaths.get(IDParts[0]));
                _principalID = LDAPPersistence._centralNameParser.parse(distinName);
                name = JNDIUtils.getRelativeBase(_principalID, _base);
                if (_updatedpath != null) {
                    newName = LDAPPersistence._centralNameParser.parse(name);
                    newName = newName.getPrefix(newName.size() - 1);
                    newName.add(newName.size(), _updatedpath);
                    name = newName.toString();
                }
            }
            catch (NamingException e) {
                sb = new StringBuffer();
                sb.append("Naming exception when parsing id ").append(distinName);
                sb.append(";object can not be created ").append(uniqueID);
                LDAPPersistence.trace.warningT("createPrincipalDatabag", sb.toString(), e);
                throw new PersistenceException("Can not create object because :" + e.getMessage());
            }
            ctx = this._manager.getConnection("createPrincipalDatabag", IDParts[0], count);
            destroyContext = false;
            try {
                try {
                    if (LDAPPersistence.trace.beDebug()) {
                        LDAPPersistence.trace.debugT("createPrincipalDatabag", "ldap access when creating principal " + principal.getUniqueID() + " at base " + name);
                    }
                    time1 = 0L;
                    if (LDAPPersistence.props.getBoolean("ume.ldap.record_access", false)) {
                        sb = new StringBuffer();
                        time1 = System.currentTimeMillis();
                        sb.append("createPrincipalDatabag(): ldap access at " + time1);
                        sb.append("\n\twith createSubcontext: base: ").append(name).append(" - ");
                        sb.append("and some attributes");
                        LDAPPersistence.aa.print(sb.toString());
                    }
                    ctx.createSubcontext(name, (Attributes)ldapAttributes);
                    if (LDAPPersistence.props.getBoolean("ume.ldap.record_access", false)) {
                        time1 = System.currentTimeMillis() - time1;
                        LDAPPersistence.aa.print("createPrincipalDatabag: returning from ldap with createSubcontext() after " + time1 + " ms");
                    }
                    if (LDAPPersistence.trace.beInfo()) {
                        LDAPPersistence.trace.infoT("createPrincipalDatabag", "principal " + uniqueID + " successfully created.");
                    }
                    if (LDAPPersistence.trace.beInfo()) {
                        LDAPPersistence.trace.infoT("createPrincipalDatabag", "ldap access succesfully, setting existence check to true for principal " + principal.getUniqueID());
                    }
                    if (IDParts[1].equals(this.getId())) {
                        principal.setExists(true);
                    }
                    this.exist_cache.put(principal.getUniqueID().toLowerCase() + ".exists", "true");
                    this.search_cache.invalidate();
                    this.search_cache = this.getUMCache("search_cache");
                    success = true;
                }
                catch (NameAlreadyBoundException e) {
                    LDAPPersistence.trace.warningT("createPrincipalDatabag", "Principal " + uniqueID + " already exists.", e);
                    throw new DuplicateKeyException(e);
                }
                catch (PartialResultException e) {
                    if (LDAPPersistence.trace.beInfo()) {
                        sb = new StringBuffer();
                        sb.append("Partial result exception because of some unrecognized referrals ");
                        sb.append("Exception: ").append(e.getMessage());
                        LDAPPersistence.trace.infoT("createPrincipalDatabag", sb.toString());
                    }
                    var30_57 = null;
                    this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                    continue;
                }
                catch (CommunicationException ce) {
                    if (LDAPPersistence.trace.beInfo()) {
                        LDAPPersistence.trace.infoT("createPrincipalDatabag", "CommunicationException: destroying context", ce);
                    }
                    destroyContext = true;
                    if (count == this.mm_action_retrial) {
                        throw new PersistenceException(ce);
                    }
                    var30_57 = null;
                    this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                    continue;
                }
                catch (NoInitialContextException ce) {
                    if (LDAPPersistence.trace.beInfo()) {
                        LDAPPersistence.trace.infoT("createPrincipalDatabag", "NoInitialContextException: destroying context", ce);
                    }
                    destroyContext = true;
                    if (count == this.mm_action_retrial) {
                        throw new PersistenceException(ce);
                    }
                    var30_57 = null;
                    this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                    continue;
                }
                catch (NamingException e) {
                    LDAPPersistence.trace.errorT("createPrincipalDatabag", "Naming exception when trying to create principal " + uniqueID, e);
                    LDAPPersistence.trace.logErrorT("DataSource {0}: Naming exception when trying to create principal {1}", new Object[]{this.getId(), principal});
                    throw new PersistenceException(e);
                }
                catch (Exception e) {
                    LDAPPersistence.trace.errorT("createPrincipalDatabag", "Exception when trying to create principal " + uniqueID, e);
                    LDAPPersistence.trace.logErrorT("DataSource {0}: Exception when trying to create principal {1}", new Object[]{this.getId(), principal});
                    throw new PersistenceException(e);
                }
                var30_57 = null;
                this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
            }
            catch (Throwable var29_60) {
                var30_57 = null;
                this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                throw var29_60;
            }
        }
    }

    private void createUserAccount(IInternalPrincipalDatabag principal) throws PersistenceException {
        String controlAttribute;
        String[] IDParts;
        String mn = "createUserAccount";
        if (trace.bePath()) {
            trace.entering("createUserAccount", new Object[]{principal.toString()});
        }
        if (!(IDParts = principal.getIDParts())[1].equals(this.getId())) {
            if (trace.beInfo()) {
                trace.infoT("createUserAccount", "user account and user are not stored on this datasource " + this.getId());
            }
            return;
        }
        BasicAttributes updateAttributes = new BasicAttributes();
        BasicAttributes removeAttributes = new BasicAttributes();
        Vector userObjectclasses = (Vector)this.mm_principalObjectclasses.get("USER");
        String userobjectclass = "";
        if (userObjectclasses.size() > 1) {
            userobjectclass = this.getObjectclass("USER", IDParts[2]) + ":";
        }
        String userDescription = this.getPhysicalAttribute("USER", "com.sap.security.core.usermanagement", userobjectclass + "description");
        userDescription = this.getRealPhysicalAttribute(userDescription);
        if (!this.mm_serverType.equalsIgnoreCase("MSADS")) {
            BasicAttribute description = new BasicAttribute(userDescription);
            description.add("NO_USER_ACCOUNT");
            removeAttributes.put(description);
        }
        Vector accountObjectclasses = (Vector)this.mm_principalObjectclasses.get("UACC");
        String accountobjectclass = "";
        if (accountObjectclasses.size() > 1) {
            accountobjectclass = this.getObjectclass("UACC", IDParts[2]) + ":";
        }
        Enumeration namespaces = principal.getNameSpaces();
        while (namespaces.hasMoreElements()) {
            String namespace = (String)namespaces.nextElement();
            Enumeration attributes = principal.getAttributesOnNamespace(namespace);
            while (attributes.hasMoreElements()) {
                String attribute = (String)attributes.nextElement();
                if (!this.feelsResponsible(IDParts[0], namespace, attribute)) continue;
                String physAttribute = this.getPhysicalAttribute(IDParts[0], namespace, accountobjectclass + attribute);
                if ((physAttribute = this.getRealPhysicalAttribute(physAttribute)).equals(NO_MAPPING) || this.checkAttributeAsNamingAttribute(physAttribute, IDParts[0]) || this.checkAttributeAsAuxNamingAttribute(physAttribute, IDParts[0])) continue;
                if (attribute.equals("j_password") && this.mm_serverType.equalsIgnoreCase("MSADS")) {
                    if (!this.mm_sslEnabled) {
                        trace.errorT("createUserAccount", "Can't create account in MSADS without ssl connection");
                        trace.logErrorT("DataSource {0}: Can't create account in MSADS without ssl connection", new Object[]{this.getId()});
                        return;
                    }
                    Vector passwords = principal.getAttributeValues(namespace, attribute);
                    if (passwords == null || passwords.size() <= 0) continue;
                    String password = (String)passwords.firstElement();
                    StringBuffer sb = new StringBuffer();
                    sb.append("\"").append(password).append("\"");
                    password = sb.toString();
                    try {
                        byte[] _bytes = password.getBytes("UTF-16LE");
                        BasicAttribute attr = new BasicAttribute(physAttribute);
                        attr.add(_bytes);
                        updateAttributes.put(attr);
                        continue;
                    }
                    catch (Exception e) {
                        trace.errorT("createUserAccount", "can't create unicode password for MSADS", e);
                        trace.logErrorT("DataSource {0}: Can't create unicode password for MSADS", new Object[]{this.getId()});
                        throw new PersistenceException("can't create user account");
                    }
                }
                Vector attributeValues = principal.getAttributeValues(namespace, attribute);
                BasicAttribute attr = new BasicAttribute(physAttribute);
                int i = 0;
                while (i < attributeValues.size()) {
                    attr.add(attributeValues.get(i));
                    ++i;
                }
                updateAttributes.put(attr);
            }
        }
        BasicAttributes replaceAttributes = null;
        if (this.mm_serverType.equalsIgnoreCase("MSADS") && (controlAttribute = props.get(MSADS_CONTROL_ATTRIBUTE, DEFAULT_CONTROL_ATTRIBUTE)) != null && controlAttribute.length() > 0) {
            BasicAttribute uaControl = new BasicAttribute(controlAttribute);
            String controlValue = props.get(MSADS_CONTROL_VALUE, DEFAULT_CONTROL_VALUE);
            uaControl.add(controlValue);
            replaceAttributes = new BasicAttributes();
            replaceAttributes.put(uaControl);
        }
        boolean success = false;
        int count = 0;
        while (!success && count < this.mm_action_retrial) {
            Object var31_45;
            StringBuffer sb;
            ++count;
            String name = null;
            String distinName = IDParts[2];
            try {
                if (this.mm_principalUniqueAttributes.get(IDParts[0]) != null) {
                    distinName = this.createDistinguishedName(principal);
                }
                Name _id = _centralNameParser.parse(distinName);
                Name _path = _centralNameParser.parse((String)this.mm_principalPaths.get(IDParts[0]));
                name = JNDIUtils.getRelativeBase(_id, _path);
            }
            catch (PersistenceException e) {
                StringBuffer sb2 = new StringBuffer();
                sb2.append("Persistence Exception when creating distinguished name: ");
                sb2.append(e.getMessage());
                throw e;
            }
            catch (NamingException e) {
                sb = new StringBuffer();
                sb.append("Naming exception when parsing id ").append(distinName).append("; not on this datasource");
                trace.warningT("createUserAccount", sb.toString(), e);
                throw new PersistenceException("Could not create user account " + e.getMessage());
            }
            InitialDirContext ctx = this._manager.getConnection("createUserAccount", IDParts[0], count);
            boolean destroyContext = false;
            try {
                try {
                    StringBuffer sb3;
                    if (trace.beDebug()) {
                        sb = new StringBuffer();
                        sb.append("ldap access to modify some attributes for ").append(principal);
                        sb.append(" at base ").append(name);
                        trace.debugT("createUserAccount", sb.toString());
                    }
                    long time1 = System.currentTimeMillis();
                    if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                        sb3 = new StringBuffer();
                        sb3.append("createUserAccount(): ldap access at :" + time1);
                        sb3.append("\n\twith modifyAttributes(): base : ").append(name);
                        sb3.append("\n\tadding some new attributes");
                        aa.print(sb3.toString());
                    }
                    if (this.mm_serverType.equalsIgnoreCase("MSADS")) {
                        ctx.modifyAttributes(name, 2, (Attributes)updateAttributes);
                    } else {
                        ctx.modifyAttributes(name, 1, (Attributes)updateAttributes);
                    }
                    if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                        time1 = System.currentTimeMillis() - time1;
                        aa.print("createUserAccount(): returning from ldap with modifyAttributes() after " + time1 + " ms");
                    }
                    if (trace.beInfo()) {
                        trace.infoT("createUserAccount", "ldap access succesfully, setting existence check to true for principal " + principal.getUniqueID());
                    }
                    if (IDParts[1].equals(this.getId())) {
                        principal.setExists(true);
                    }
                    if (!this.mm_serverType.equalsIgnoreCase("MSADS")) {
                        time1 = System.currentTimeMillis();
                        if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                            sb3 = new StringBuffer();
                            sb3.append("createUserAccount(): ldap access at ").append(time1);
                            sb3.append("\n\tin case of an MSADS with modifyAttributes(): base :").append(name);
                            sb3.append("\n\tremove some attributes");
                            aa.print(sb3.toString());
                        }
                        ctx.modifyAttributes(name, 3, (Attributes)removeAttributes);
                        if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                            time1 = System.currentTimeMillis() - time1;
                            aa.print("createUserAccount(): returning from ldap with modifyAttributes() after " + time1 + " ms");
                        }
                    } else {
                        String[] attrs = new String[]{this.getPhysicalAttribute(IDParts[0], "com.sap.security.core.usermanagement", "description")};
                        if (trace.beDebug()) {
                            trace.debugT("createUserAccount", "ldap access reading description of user when creating the account");
                        }
                        long time = 0L;
                        if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                            time = System.currentTimeMillis();
                            StringBuffer sb4 = new StringBuffer();
                            sb4.append("createUserAccount(): ldap access at ").append(time);
                            sb4.append("\n\twith getAttributes: base: ").append(name);
                            sb4.append("\n\twith attributes description");
                            aa.print(sb4.toString());
                        }
                        Attributes attributes = ctx.getAttributes(name, attrs);
                        if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                            time = System.currentTimeMillis() - time;
                            aa.print("createUserAccout(): returning from ldap with getAttributes() after " + time + " ms");
                        }
                        Attribute attribute = attributes.get(attrs[0]);
                        NamingEnumeration<?> values = attribute.getAll();
                        BasicAttribute _upDate = new BasicAttribute(attrs[0]);
                        boolean newValue = false;
                        while (values.hasMore()) {
                            String val = (String)values.next();
                            if (val.equals("NO_USER_ACCOUNT")) continue;
                            newValue = true;
                            _upDate.add(val);
                        }
                        if (!newValue) {
                            removeAttributes = new BasicAttributes();
                            BasicAttribute descr = new BasicAttribute(attribute.getID());
                            removeAttributes.put(descr);
                        } else {
                            if (replaceAttributes == null) {
                                replaceAttributes = new BasicAttributes();
                            }
                            removeAttributes = null;
                            replaceAttributes.put(_upDate);
                        }
                    }
                    if (this.mm_serverType.equalsIgnoreCase("MSADS")) {
                        time1 = 0L;
                        if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                            time1 = System.currentTimeMillis();
                            sb3 = new StringBuffer();
                            sb3.append("createUserAccount(): ldap access at " + time1);
                            sb3.append("\n\tin case of an MSADS with modifyAttributes(): base: ").append(name);
                            sb3.append("\n\treplacing some attributes");
                            aa.print(sb3.toString());
                        }
                        if (removeAttributes != null) {
                            ctx.modifyAttributes(name, 3, (Attributes)removeAttributes);
                        }
                        if (replaceAttributes != null) {
                            ctx.modifyAttributes(name, 2, (Attributes)replaceAttributes);
                        }
                        if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                            time1 = System.currentTimeMillis() - time1;
                            aa.print("createUserAccount: returning form ldap after " + time1 + " ms");
                        }
                    }
                    if (trace.beInfo()) {
                        trace.infoT("createUserAccount", "user account " + principal.getUniqueID() + " successfully created on " + this.getId());
                    }
                    this.exist_cache.put(principal.getUniqueID().toLowerCase() + ".exists", "true");
                    this.search_cache.invalidate();
                    this.search_cache = this.getUMCache("search_cache");
                    success = true;
                }
                catch (CommunicationException ce) {
                    destroyContext = true;
                    if (trace.beInfo()) {
                        trace.infoT("createUserAccount", "Communication exception, destroying corrupt context", ce);
                    }
                    if (count == this.mm_action_retrial) {
                        throw new PersistenceException(ce);
                    }
                    var31_45 = null;
                    this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                    continue;
                }
                catch (NoInitialContextException ce) {
                    destroyContext = true;
                    if (trace.beInfo()) {
                        trace.infoT("createUserAccount", "No initial context exception, destroying corrupt context", ce);
                    }
                    if (count == this.mm_action_retrial) {
                        throw new PersistenceException(ce);
                    }
                    var31_45 = null;
                    this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                    continue;
                }
                catch (AttributeInUseException e) {
                    StringBuffer sb5 = new StringBuffer("user/account object can not be updated ");
                    sb5.append(principal.getUniqueID()).append(" Exception: ").append(e.getMessage());
                    trace.warningT("createUserAccount", sb5.toString());
                    trace.logWarningT("DataSource {0}: " + sb5.toString(), new Object[]{this.getId()});
                    throw new DuplicateKeyException(e);
                }
                catch (NameAlreadyBoundException e) {
                    trace.warningT("createUserAccount", "principal " + principal.getUniqueID() + " exists." + e.getMessage());
                    trace.logWarningT("DataSource {0}: princial already {1} exists; Exception: {2}", new Object[]{this.getId(), principal.getUniqueID(), e});
                    throw new DuplicateKeyException(e);
                }
                catch (NamingException ne) {
                    trace.warningT("createUserAccount", "Naming exception [" + ne.getMessage() + "] when creating user account");
                    trace.logWarningT("DataSource {0}: Naming exception when creating user account", new Object[]{this.getId()});
                    throw new PersistenceException(ne);
                }
                catch (Exception e) {
                    trace.warningT("createUserAccount", "Exception [" + e.getMessage() + " ] when creating user account");
                    trace.logWarningT("DataSource {0}: Exception when creating user account", new Object[]{this.getId()});
                    throw new PersistenceException(e);
                }
                var31_45 = null;
                this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
            }
            catch (Throwable throwable) {
                var31_45 = null;
                this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                throw throwable;
            }
        }
    }

    private boolean checkAttributeAsNamingAttribute(String physAttribute, String type) {
        boolean isNaming = false;
        Vector namingAttributes = (Vector)this.mm_principalNamingAttributes.get(type);
        if (namingAttributes != null && namingAttributes.size() > 0) {
            isNaming = namingAttributes.contains(physAttribute);
        }
        return isNaming;
    }

    private boolean checkAttributeAsAuxNamingAttribute(String physAttribute, String type) {
        boolean isNaming = false;
        Vector namingAttributes = (Vector)this.mm_principalAuxiliaryNamingAttributes.get(type);
        if (namingAttributes != null && namingAttributes.size() > 0) {
            isNaming = namingAttributes.contains(physAttribute);
        }
        return isNaming;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updatePrincipalDatabag(IInternalPrincipalDatabagMaint principal) throws PersistenceException {
        String mn = "updatePrincipalDatabag";
        boolean destroyContext = false;
        if (!this.isInitialized || this.lazyInitialisation) {
            trace.errorT(mn, "data source is not initialized");
            if (!this.lazyInitialisation) {
                trace.logErrorT("DataSource {0}: Data source is not initialized", new Object[]{this.getId()});
                throw new PersistenceException("data source " + this.getId() + " not initialized");
            }
            if (!this.reinitializeConnectionManager()) {
                trace.logErrorT("DataSource {0}: data source is not initialized", new Object[]{this.getId()});
                throw new PersistenceException("data source " + this.getId() + " not initialized");
            }
            trace.warningT(mn, "connection manager initialized");
        }
        if (this.isReadonly()) {
            if (trace.beInfo()) {
                StringBuffer sb = new StringBuffer();
                sb.append("Data source ").append(this.getId()).append(" is readonly");
                trace.infoT(mn, sb.toString());
            }
            return;
        }
        String uniqueID = principal.getUniqueID();
        if (uniqueID == null) {
            trace.errorT(mn, "principal is not bound to a datasource.");
            trace.logErrorT("DataSource {0}: unique id is null of principal {1}", new Object[]{this.getId(), principal});
            throw new PersistenceException("unique is is null");
        }
        String[] IDParts = principal.getIDParts();
        if (!this.feelsResponsible(principal)) {
            if (trace.beInfo()) {
                trace.infoT(mn, "datasource is not responsible for this principal " + uniqueID);
            }
            return;
        }
        if (!IDParts[1].equals(this.getId())) {
            if (trace.beInfo()) {
                trace.infoT(mn, "principal " + uniqueID + " is not on this datasource, can not be updated by datasource " + this.getId());
            }
            return;
        }
        String orgid = IDParts[2];
        ArrayList uniqueAttributes = (ArrayList)this.mm_principalUniqueAttributes.get(IDParts[0]);
        if (uniqueAttributes != null) {
            orgid = this.getDNfromID(uniqueAttributes, IDParts[2], IDParts[0]);
        }
        String objectclass = "";
        Vector objectclasses = (Vector)this.mm_principalObjectclasses.get(IDParts[0]);
        if (objectclasses != null && objectclasses.size() > 1) {
            objectclass = this.getObjectclass(IDParts[0], orgid) + ":";
        }
        boolean updateUserAccount = false;
        ModificationItem[] mods = null;
        if (IDParts[0].equals("UACC") && orgid != null) {
            String newPassword = null;
            String oldPassword = null;
            Vector newPwds = principal.getAttributeValues("com.sap.security.core.usermanagement", "j_password", 2);
            Vector oldPwds = principal.getAttributeValues("com.sap.security.core.usermanagement", "oldpassword", 2);
            if (newPwds != null) {
                newPassword = (String)newPwds.firstElement();
            }
            if (oldPwds != null) {
                oldPassword = (String)oldPwds.firstElement();
            }
            if (newPassword != null) {
                BasicAttribute mod0;
                boolean passwordchanged = false;
                String passwordAttribute = this.getPhysicalAttribute(IDParts[0], "com.sap.security.core.usermanagement", objectclass + "j_password");
                passwordAttribute = this.getRealPhysicalAttribute(passwordAttribute);
                if (this.feelsResponsible(IDParts[0], "com.sap.security.core.usermanagement", "j_password") && !passwordAttribute.equals(NO_MAPPING)) {
                    mods = new ModificationItem[1];
                    mod0 = null;
                    if (this.mm_serverType.equalsIgnoreCase("MSADS")) {
                        try {
                            if (trace.beInfo()) {
                                trace.infoT(mn, "converting password to unicode password for MSADS");
                            }
                            String quotPassword = "\"" + newPassword + "\"";
                            byte[] _bytes = quotPassword.getBytes("UTF-16LE");
                            mod0 = new BasicAttribute(passwordAttribute, _bytes);
                        }
                        catch (Exception e) {
                            trace.errorT(mn, "error when getting unicode password for MSADS", e);
                            trace.logErrorT("DataSource {0}: Error when getting unicode password for MSADS", new Object[]{this.getId()});
                            return;
                        }
                    } else {
                        mod0 = new BasicAttribute(passwordAttribute, newPassword);
                    }
                    boolean success = false;
                    int count = 0;
                    while (!success && count < this.mm_action_retrial) {
                        Object var29_63;
                        InitialDirContext ctx = this._manager.getConnection(mn, IDParts[0], ++count);
                        destroyContext = false;
                        try {
                            try {
                                ModificationItem mod = new ModificationItem(2, mod0);
                                ModificationItem[] _mods = new ModificationItem[]{mod};
                                String name = null;
                                try {
                                    String principalPath = (String)this.mm_principalPaths.get(IDParts[0]);
                                    Name _principalPath = _centralNameParser.parse(principalPath);
                                    Name _principalID = _centralNameParser.parse(orgid);
                                    name = JNDIUtils.getRelativeBase(_principalID, _principalPath);
                                }
                                catch (NamingException e) {
                                    StringBuffer sb = new StringBuffer();
                                    sb.append("Naming exception when parsing id ").append(orgid).append(" Exception: ");
                                    sb.append(e.getMessage());
                                    trace.warningT(mn, sb.toString());
                                    var29_63 = null;
                                    this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                                    return;
                                }
                                long time1 = 0L;
                                if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                                    time1 = System.currentTimeMillis();
                                    StringBuffer sb = new StringBuffer();
                                    sb.append("updatePrincipalDatabag(): ldap access at ").append(time1);
                                    sb.append("\n\twith modifyAttributes: base : ").append(name);
                                    sb.append("\n\tand some modification items");
                                    aa.print(sb.toString());
                                }
                                ctx.modifyAttributes(name, _mods);
                                if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                                    time1 = System.currentTimeMillis() - time1;
                                    aa.print("updatePrincipalDatabag() : returning from ldap after " + time1 + " ms");
                                }
                                passwordchanged = true;
                                success = true;
                            }
                            catch (CommunicationException ce) {
                                if (trace.beInfo()) {
                                    trace.infoT(mn, "CommunicationException:destroying the context", ce);
                                }
                                destroyContext = true;
                                if (count == this.mm_action_retrial) {
                                    throw new PersistenceException(ce);
                                }
                                var29_63 = null;
                                this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                                continue;
                            }
                            catch (NoInitialContextException ce) {
                                if (trace.beInfo()) {
                                    trace.infoT(mn, "NoInitialContextException:destroying the context", ce);
                                }
                                destroyContext = true;
                                if (count == this.mm_action_retrial) {
                                    throw new PersistenceException(ce);
                                }
                                var29_63 = null;
                                this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                                continue;
                            }
                            catch (Exception e) {
                                trace.errorT(mn, "can not change password without the old one, because of security reasons", e);
                                trace.logErrorT("DataSource {0}: Can not change password without the old one, because of security reasons", new Object[]{this.getId()});
                                passwordchanged = false;
                                var29_63 = null;
                                this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                                continue;
                            }
                            var29_63 = null;
                            this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                        }
                        catch (Throwable throwable) {
                            var29_63 = null;
                            this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                            throw throwable;
                        }
                    }
                }
                if (!passwordchanged) {
                    if (oldPassword != null) {
                        if (this.feelsResponsible(IDParts[0], "com.sap.security.core.usermanagement", "j_password") && !passwordAttribute.equals(NO_MAPPING)) {
                            mods = new ModificationItem[2];
                            mod0 = null;
                            BasicAttribute mod1 = null;
                            if (this.mm_serverType.equalsIgnoreCase("MSADS")) {
                                try {
                                    String quotNewPassword = "\"" + newPassword + "\"";
                                    byte[] _newBytes = quotNewPassword.getBytes("UTF-16LE");
                                    mod1 = new BasicAttribute(passwordAttribute, _newBytes);
                                    String quotOldPassword = "\"" + oldPassword + "\"";
                                    byte[] _oldBytes = quotOldPassword.getBytes("UTF-16LE");
                                    mod0 = new BasicAttribute(passwordAttribute, _oldBytes);
                                }
                                catch (Exception e) {
                                    trace.logErrorT("DataSource {0}: Error when getting unicode password for MSADS", new Object[]{this.getId()});
                                    trace.errorT(mn, "error when getting unicode password for MSADS", e);
                                    return;
                                }
                            } else {
                                mod0 = new BasicAttribute(passwordAttribute, oldPassword);
                                mod1 = new BasicAttribute(passwordAttribute, newPassword);
                            }
                            mods[0] = new ModificationItem(3, mod0);
                            mods[1] = new ModificationItem(1, mod1);
                            updateUserAccount = true;
                        }
                    } else if (trace.beWarning()) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("password not changed with new one only");
                        sb.append(", for security reasons the old one is also needed, but not provided");
                        trace.warningT(mn, sb.toString());
                    }
                }
            }
        }
        Attributes setAttributes = this.getUpDateAttributes(principal, 2, orgid, false);
        Attributes delAttributes = this.getUpDateAttributes(principal, 3, orgid, false);
        Attributes addAttributes = this.getUpDateAttributes(principal, 0, orgid, false);
        Attributes remAttributes = this.getUpDateAttributes(principal, 1, orgid, false);
        boolean success = false;
        int count = 0;
        while (true) {
            block100: {
                Object var35_78;
                if (success || count >= this.mm_action_retrial) {
                    return;
                }
                InitialDirContext ctx = this._manager.getConnection(mn, IDParts[0], ++count);
                destroyContext = false;
                Vector<ModificationItem> allModifications = new Vector<ModificationItem>();
                try {
                    block99: {
                        try {
                            block97: {
                                block98: {
                                    StringBuffer sb;
                                    BasicAttribute member;
                                    String physMember;
                                    String name;
                                    NamingEnumeration<? extends Attribute> allAttributes;
                                    boolean deleteSiemensDummyMember = false;
                                    boolean addSiemensDummyMember = false;
                                    String defaultMember = props.get(DUMMY_MEMBER, default_member);
                                    if (setAttributes != null) {
                                        allAttributes = setAttributes.getAll();
                                        while (allAttributes.hasMore()) {
                                            ModificationItem oneItem = new ModificationItem(2, allAttributes.next());
                                            allModifications.add(oneItem);
                                        }
                                    }
                                    if (delAttributes != null) {
                                        allAttributes = delAttributes.getAll();
                                        while (allAttributes.hasMore()) {
                                            Attribute one = allAttributes.next();
                                            boolean alreadyAdded = false;
                                            if ((this.mm_serverType.equalsIgnoreCase("SIEMENS") || this.mm_defaultMemberEnabled) && IDParts[0].equals("GRUP")) {
                                                String physMember2 = this.getPhysicalAttribute(IDParts[0], "com.sap.security.core.usermanagement.relation", objectclass + "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE");
                                                if (!(physMember2 = this.getRealPhysicalAttribute(physMember2)).equals(NO_MAPPING) && physMember2.equalsIgnoreCase(one.getID())) {
                                                    BasicAttribute test = new BasicAttribute(physMember2);
                                                    test.add(defaultMember);
                                                    ModificationItem oneItem = new ModificationItem(2, test);
                                                    allModifications.add(oneItem);
                                                    alreadyAdded = true;
                                                }
                                            }
                                            if (alreadyAdded) continue;
                                            ModificationItem oneItem = new ModificationItem(3, one);
                                            allModifications.add(oneItem);
                                        }
                                    }
                                    if (addAttributes != null) {
                                        allAttributes = addAttributes.getAll();
                                        while (allAttributes.hasMore()) {
                                            Attribute one = allAttributes.next();
                                            if ((this.mm_serverType.equalsIgnoreCase("SIEMENS") || this.mm_defaultMemberEnabled) && IDParts[0].equals("GRUP")) {
                                                String physMember3 = this.getPhysicalAttribute(IDParts[0], "com.sap.security.core.usermanagement.relation", objectclass + "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE");
                                                if (!(physMember3 = this.getRealPhysicalAttribute(physMember3)).equals(NO_MAPPING) && one.getID().equalsIgnoreCase(physMember3)) {
                                                    deleteSiemensDummyMember = true;
                                                }
                                            }
                                            ModificationItem oneItem = new ModificationItem(1, one);
                                            allModifications.add(oneItem);
                                        }
                                    }
                                    if (remAttributes != null) {
                                        allAttributes = remAttributes.getAll();
                                        while (allAttributes.hasMore()) {
                                            Attribute one = allAttributes.next();
                                            if ((this.mm_serverType.equalsIgnoreCase("SIEMENS") || this.mm_defaultMemberEnabled) && IDParts[0].equals("GRUP")) {
                                                String physMember4 = this.getPhysicalAttribute(IDParts[0], "com.sap.security.core.usermanagement.relation", objectclass + "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE");
                                                if (!(physMember4 = this.getRealPhysicalAttribute(physMember4)).equals(NO_MAPPING) && one.getID().equals(physMember4)) {
                                                    addSiemensDummyMember = true;
                                                    deleteSiemensDummyMember = true;
                                                }
                                            }
                                            ModificationItem oneItem = new ModificationItem(3, one);
                                            allModifications.add(oneItem);
                                        }
                                    }
                                    if (updateUserAccount) {
                                        int i = 0;
                                        while (i < mods.length) {
                                            allModifications.add(mods[i]);
                                            ++i;
                                        }
                                    }
                                    ModificationItem[] newMods = new ModificationItem[allModifications.size()];
                                    int i = 0;
                                    while (true) {
                                        if (i >= allModifications.size()) {
                                            if (orgid != null) {
                                                Name _path = _centralNameParser.parse((String)this.mm_principalPaths.get(IDParts[0]));
                                                Name _principalID = _centralNameParser.parse(orgid);
                                                name = JNDIUtils.getRelativeBase(_principalID, _path);
                                                if (!addSiemensDummyMember) break;
                                                BasicAttributes additionalAttributes = new BasicAttributes();
                                                physMember = this.getPhysicalAttribute(IDParts[0], "com.sap.security.core.usermanagement.relation", objectclass + "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE");
                                                physMember = this.getRealPhysicalAttribute(physMember);
                                                member = new BasicAttribute(physMember);
                                                member.add(defaultMember);
                                                additionalAttributes.put(member);
                                                try {
                                                    if (trace.beDebug()) {
                                                        trace.debugT(mn, "adding the default member to group " + principal.getUniqueID());
                                                    }
                                                    long time = 0L;
                                                    if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                                                        time = System.currentTimeMillis();
                                                        sb = new StringBuffer();
                                                        sb.append(mn).append(": ldap access at ").append(time);
                                                        sb.append("\n\twith modifyAttributes: base: ").append(name);
                                                        sb.append("\n\tadding the default member to a group ").append(defaultMember);
                                                        aa.print(sb.toString());
                                                    }
                                                    ctx.modifyAttributes(name, 1, (Attributes)additionalAttributes);
                                                    if (!props.getBoolean(RECORD_LDAP_ACCESS, false)) break;
                                                    time = System.currentTimeMillis() - time;
                                                    aa.print(mn + ": returning from ldap with modifyAttributes after " + time + " ms");
                                                }
                                                catch (NamingException e) {
                                                    trace.warningT(mn, "Naming exception when adding the default member; Exception: " + e.getMessage());
                                                }
                                                break;
                                            }
                                            break block97;
                                        }
                                        newMods[i] = (ModificationItem)allModifications.elementAt(i);
                                        ++i;
                                    }
                                    if (newMods.length > 0) {
                                        if (trace.beDebug()) {
                                            trace.debugT(mn, "modifying the principal " + principal.getUniqueID());
                                        }
                                        long time = 0L;
                                        if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                                            time = System.currentTimeMillis();
                                            StringBuffer sb2 = new StringBuffer();
                                            sb2.append(mn).append(": ldap access at :").append(time);
                                            sb2.append("\n\twith modifiyAttributes: base : ").append(name);
                                            sb2.append("\n\tadding specified attributes");
                                            aa.print(sb2.toString());
                                        }
                                        try {
                                            ctx.modifyAttributes(name, newMods);
                                        }
                                        catch (AttributeInUseException e) {
                                            if (trace.beInfo()) {
                                                StringBuffer sb3 = new StringBuffer();
                                                sb3.append("Attribute or value already exists when updating ").append(principal.getUniqueID());
                                                sb3.append(" Exception: ").append(e.getMessage());
                                                trace.infoT(mn, sb3.toString());
                                            }
                                            throw new DuplicateKeyException(e);
                                        }
                                        if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                                            time = System.currentTimeMillis() - time;
                                            aa.print(mn + " returning from ldap with modifyAttributes after " + time + " ms");
                                        }
                                        if (trace.beInfo()) {
                                            trace.infoT(mn, "ldap access succesfully, setting existence check to true for principal " + principal.getUniqueID());
                                        }
                                        if (IDParts[1].equals(this.getId())) {
                                            principal.setExists(true);
                                        }
                                    }
                                    if (deleteSiemensDummyMember) {
                                        BasicAttributes additionalAttributes = new BasicAttributes();
                                        physMember = this.getPhysicalAttribute(IDParts[0], "com.sap.security.core.usermanagement.relation", objectclass + "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE");
                                        physMember = this.getRealPhysicalAttribute(physMember);
                                        member = new BasicAttribute(physMember);
                                        member.add(defaultMember);
                                        additionalAttributes.put(member);
                                        try {
                                            if (trace.beDebug()) {
                                                trace.debugT(mn, "deleting the default member from the group " + principal.getUniqueID());
                                            }
                                            long time = 0L;
                                            if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                                                time = System.currentTimeMillis();
                                                sb = new StringBuffer();
                                                sb.append(mn).append(": ldap access at ").append(time);
                                                sb.append("\n\twith modifyAttributes: base: ").append(name);
                                                sb.append("\n\ttrying to delete the default member for a group on SIEMENS DirX");
                                                aa.print(sb.toString());
                                            }
                                            ctx.modifyAttributes(name, 3, (Attributes)additionalAttributes);
                                            if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                                                time = System.currentTimeMillis() - time;
                                                aa.print(mn + ": returning from ldap with modifyAttributes after " + time + " ms ");
                                            }
                                        }
                                        catch (NamingException e) {
                                            if (!trace.beInfo()) break block98;
                                            StringBuffer sb4 = new StringBuffer();
                                            sb4.append("Naming exception if deleting the default member; Exception :").append(e.getMessage());
                                            trace.infoT(mn, sb4.toString());
                                        }
                                    }
                                }
                                success = true;
                                this.search_cache.invalidate();
                                this.search_cache = this.getUMCache("search_cache");
                                break block99;
                            }
                            trace.infoT(mn, "can not parse null name for principal " + principal);
                        }
                        catch (CommunicationException ce) {
                            if (trace.beInfo()) {
                                trace.infoT(mn, "CommunicationException: destroying context", ce);
                            }
                            destroyContext = true;
                            if (count == this.mm_action_retrial) {
                                throw new PersistenceException(ce);
                            }
                            var35_78 = null;
                            this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                            break block100;
                        }
                        catch (NoInitialContextException ce) {
                            if (trace.beInfo()) {
                                trace.infoT(mn, "NoInitialContextException: destroying context", ce);
                            }
                            destroyContext = true;
                            if (count == this.mm_action_retrial) {
                                throw new PersistenceException(ce);
                            }
                            var35_78 = null;
                            this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                            break block100;
                        }
                        catch (NamingException ne) {
                            StringBuffer sb = new StringBuffer();
                            sb.append("Naming exception when updating a principal ").append(principal.getUniqueID());
                            sb.append("; Exception: ").append(ne.getMessage());
                            trace.errorT(mn, sb.toString());
                            trace.logErrorT("DataSource {0}: " + sb.toString(), new Object[]{this.getId()});
                            throw new PersistenceException(ne);
                        }
                        catch (Exception e) {
                            StringBuffer sb = new StringBuffer();
                            sb.append("Exception when updating a principal ").append(principal.getUniqueID());
                            sb.append("; Exception: ").append(e.getMessage());
                            trace.errorT(mn, sb.toString());
                            trace.logErrorT("DataSource {0}: " + sb.toString(), new Object[]{this.getId()});
                            throw new PersistenceException(e);
                        }
                    }
                    var35_78 = null;
                    this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                }
                catch (Throwable throwable) {
                    var35_78 = null;
                    this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                    throw throwable;
                }
            }
            if (!success || this.mm_serverType.equalsIgnoreCase("MSADS")) continue;
            this.getUpDateAttributes(principal, 2, orgid, true);
            this.getUpDateAttributes(principal, 3, orgid, true);
            this.getUpDateAttributes(principal, 0, orgid, true);
            this.getUpDateAttributes(principal, 1, orgid, true);
        }
    }

    private Attributes getUpDateAttributes(IInternalPrincipalDatabagMaint principal, int mode, String dn, boolean updateDoubleLink) throws PersistenceException {
        BasicAttributes updateAttributes = new BasicAttributes();
        String[] ids = principal.getIDParts();
        String objectclass = "";
        Vector objectclasses = (Vector)this.mm_principalObjectclasses.get(ids[0]);
        if (objectclasses != null && objectclasses.size() > 1) {
            objectclass = this.getObjectclass(ids[0], dn) + ":";
        }
        Enumeration upNS = principal.getNameSpaces(mode);
        while (upNS.hasMoreElements()) {
            String ns = (String)upNS.nextElement();
            Enumeration upAN = principal.getAttributesOnNamespace(ns, mode);
            while (upAN.hasMoreElements()) {
                String an = (String)upAN.nextElement();
                if (an.equals("j_password") || an.equals("oldpassword") || !this.feelsResponsible(ids[0], ns, an)) continue;
                String physName = this.getPhysicalAttribute(ids[0], ns, objectclass + an);
                if ((physName = this.getRealPhysicalAttribute(physName)).equals(NO_MAPPING)) continue;
                if (an.equals("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE") || an.equals("PRINCIPAL_RELATION_PARENT_ATTRIBUTE")) {
                    if (this.search_cache == null) {
                        this.search_cache = this.getUMCache("search_cache");
                    } else {
                        this.search_cache.invalidate();
                    }
                }
                if (mode == 3) {
                    BasicAttribute atr = new BasicAttribute(physName);
                    updateAttributes.put(atr);
                    continue;
                }
                Vector upAV = principal.getAttributeValues(ns, an, mode);
                if (upAV == null || upAV.size() <= 0) continue;
                BasicAttribute atr = new BasicAttribute(physName);
                boolean valueAdded = false;
                int i = 0;
                while (i < upAV.size()) {
                    block23: {
                        if (upAV.elementAt(i) != null) {
                            if (ns.equals("com.sap.security.core.usermanagement.relation") && (an.equals("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE") || an.equals("PRINCIPAL_RELATION_PARENT_ATTRIBUTE"))) {
                                String attrValue = (String)upAV.elementAt(i);
                                String[] IDParts = this.splitPrincipalDatabagID(attrValue);
                                String uniIDPart = IDParts[2];
                                uniIDPart = JNDIUtils.specialHandlingBackMSADS(uniIDPart);
                                ArrayList uniAttr = (ArrayList)this.mm_principalUniqueAttributes.get(IDParts[0]);
                                if (uniAttr != null) {
                                    uniIDPart = this.getDNfromID(uniAttr, uniIDPart, IDParts[0]);
                                }
                                try {
                                    if (uniIDPart == null) break block23;
                                    _centralNameParser.parse(uniIDPart);
                                    atr.add(JNDIUtils.unescapeSlash(uniIDPart));
                                    valueAdded = true;
                                    if (!updateDoubleLink) break block23;
                                    if (an.equals("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE")) {
                                        String parentAttribute = this.getPhysicalAttribute(IDParts[0], "com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_PARENT_ATTRIBUTE");
                                        if (!parentAttribute.equals(NO_MAPPING)) {
                                            this.updateContext(IDParts[0], uniIDPart, parentAttribute, dn, mode);
                                        }
                                    } else {
                                        String memberAttribute = this.getPhysicalAttribute(IDParts[0], "com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE");
                                        if (!memberAttribute.equals(NO_MAPPING)) {
                                            this.updateContext(IDParts[0], uniIDPart, memberAttribute, dn, mode);
                                        }
                                    }
                                }
                                catch (NamingException e) {
                                    StringBuffer sb = new StringBuffer();
                                    sb.append("member ").append(attrValue).append(" can not be added to ");
                                    sb.append(principal.getUniqueID()).append("; Exception: ");
                                    sb.append(e.getMessage());
                                    trace.warningT("getUpdateAttributes", sb.toString());
                                }
                            } else {
                                Object val = upAV.elementAt(i);
                                if (val instanceof String) {
                                    String _val = JNDIUtils.escapeAttributeValue((String)val);
                                    if (this.checkAttributeAsNamingAttribute(physName, ids[0])) {
                                        _val = JNDIUtils.escapeComma(_val);
                                    }
                                    if (_val.length() > 0) {
                                        atr.add(_val);
                                    }
                                    valueAdded = true;
                                } else {
                                    atr.add(val);
                                    valueAdded = true;
                                    if (ns.equals("com.sap.security.core.usermanagement") && (an.equals("javax.servlet.request.X509Certificate") || an.equals("javax.servlet.request.X509Certificate"))) {
                                        if (!trace.beInfo()) break;
                                        trace.infoT("getUpdateAttributes", "only the first certificate is recognized for saving on datasource " + this.getId());
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    ++i;
                }
                if (!valueAdded) continue;
                updateAttributes.put(atr);
            }
        }
        return updateAttributes;
    }

    private void updateContext(String type, String dntoupdate, String attributename, String attributevalue, int mode) throws PersistenceException {
        String mn = "updateContext";
        if (trace.beDebug()) {
            trace.entering(mn, new Object[]{type, dntoupdate, attributename, attributevalue, new Integer(mode)});
        }
        switch (mode) {
            case 2: {
                mode = 1;
                break;
            }
            case 0: {
                mode = 1;
                break;
            }
            case 3: {
                mode = 3;
                break;
            }
            case 1: {
                mode = 3;
                break;
            }
            default: {
                mode = 1;
            }
        }
        dntoupdate = JNDIUtils.specialHandlingMSADS(dntoupdate);
        attributevalue = JNDIUtils.specialHandlingBackMSADS(attributevalue);
        BasicAttributes attrs = new BasicAttributes();
        BasicAttribute update = new BasicAttribute(attributename);
        update.add(attributevalue);
        attrs.put(update);
        boolean success = false;
        int count = 0;
        while (!success && count < this.mm_action_retrial) {
            Object var21_21;
            ++count;
            InitialDirContext ctx = null;
            boolean destroyContext = false;
            try {
                try {
                    StringBuffer sb;
                    ctx = this._manager.getConnection("updateContext", type, 0);
                    String principalPath = (String)this.mm_principalPaths.get(type);
                    Name _principalPath = _centralNameParser.parse(principalPath);
                    Name _principalID = _centralNameParser.parse(dntoupdate);
                    String name = JNDIUtils.getRelativeBase(_principalID, _principalPath);
                    if (trace.beDebug()) {
                        trace.debugT(mn, "modifying the principal " + dntoupdate);
                    }
                    long time = 0L;
                    if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                        time = System.currentTimeMillis();
                        sb = new StringBuffer();
                        sb.append(mn).append(": ldap access at :").append(time);
                        sb.append("\n\twith modifiyAttributes: base : ").append(name);
                        sb.append("\n\tadding relation attributes attributes");
                        aa.print(sb.toString());
                    }
                    ctx.modifyAttributes(name, mode, (Attributes)attrs);
                    if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                        time = System.currentTimeMillis() - time;
                        aa.print(mn + ": returning from ldap with modifyAttributes after " + time + " ms");
                    }
                    if (trace.beInfo()) {
                        sb = new StringBuffer();
                        sb.append("Successfully modified the object ").append(dntoupdate).append(" with ");
                        sb.append(attributename).append("=").append(attributevalue);
                        trace.infoT(mn, sb.toString());
                    }
                    success = true;
                }
                catch (CommunicationException e) {
                    destroyContext = true;
                    if (trace.beInfo()) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("Communication exception when adding a new relation to ").append(dntoupdate);
                        sb.append(" with ").append(attributename).append("=").append(attributevalue);
                        sb.append("; Exception: ").append(e.getMessage());
                        trace.infoT(mn, sb.toString());
                    }
                    var21_21 = null;
                    if (ctx == null) continue;
                    this._manager.releaseConnection(type, ctx, destroyContext);
                    continue;
                }
                catch (NamingException e) {
                    if (trace.beInfo()) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("Naming exception when updating ").append(dntoupdate).append(" with ");
                        sb.append(attributename).append("=").append(attributename);
                        sb.append("; Exception: ").append(e.getMessage());
                        trace.infoT(mn, sb.toString());
                    }
                    var21_21 = null;
                    if (ctx == null) continue;
                    this._manager.releaseConnection(type, ctx, destroyContext);
                    continue;
                }
                var21_21 = null;
                if (ctx == null) continue;
                this._manager.releaseConnection(type, ctx, destroyContext);
            }
            catch (Throwable throwable) {
                var21_21 = null;
                if (ctx != null) {
                    this._manager.releaseConnection(type, ctx, destroyContext);
                }
                throw throwable;
            }
        }
        if (trace.beDebug()) {
            trace.exiting(mn);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deletePrincipalDatabag(IInternalPrincipalDatabag principal) throws PersistenceException {
        String uniqueID;
        String mn = "deletePrincipalDatabag";
        boolean destroyContext = false;
        if (trace.bePath()) {
            trace.entering("deletePrincipalDatabag", new Object[]{principal.getUniqueID()});
        }
        if (!this.isInitialized || this.lazyInitialisation) {
            trace.errorT("deletePrincipalDatabag", "data source is not initialized");
            if (!this.lazyInitialisation) {
                trace.logErrorT("DataSource {0}: Data source is not initialized", new Object[]{this.getId()});
                throw new PersistenceException("data source " + this.getId() + " not initialized");
            }
            if (!this.reinitializeConnectionManager()) {
                trace.logErrorT("DataSource {0}: Data source is not initialized", new Object[]{this.getId()});
                throw new PersistenceException("data source " + this.getId() + " not initialized");
            }
            trace.warningT("deletePrincipalDatabag", "connection manager initialized");
        }
        if ((uniqueID = principal.getUniqueID()) == null) {
            trace.errorT("deletePrincipalDatabag", "principal not bound to a datasource");
            trace.logErrorT("DataSource {0}: principal not bound to a datasource, unique id is null", new Object[]{this.getId()});
            throw new PersistenceException("unique id is null");
        }
        if (this.isReadonly()) {
            if (!trace.beInfo()) return;
            StringBuffer sb = new StringBuffer();
            sb.append("Data source ").append(this.getId()).append(" is readonly");
            sb.append("can not delete ").append(uniqueID);
            trace.infoT("deletePrincipalDatabag", sb.toString());
            return;
        }
        String[] IDParts = principal.getIDParts();
        if (IDParts[0].equals("UACC") && this.mm_userAsUseraccount) {
            if (!trace.beInfo()) return;
            trace.infoT("deletePrincipalDatabag", "can not delete user account, because user and user account are one object in the ldap server; account will be deleted when user is deleted");
            return;
        }
        String orgid = IDParts[2];
        ArrayList uniAttr = (ArrayList)this.mm_principalUniqueAttributes.get(IDParts[0]);
        if (uniAttr != null) {
            orgid = this.getDNfromID(uniAttr, IDParts[2], IDParts[0]);
        }
        if (orgid == null) {
            if (!trace.beWarning()) return;
            trace.warningT("deletePrincipalDatabag", "Can not delete user with dn = null for " + uniqueID);
            return;
        }
        if (!this.feelsResponsible(principal)) {
            if (!trace.beInfo()) return;
            trace.infoT("deletePrincipalDatabag", "ldap datasource " + this.getId() + " is not responsible for principal " + uniqueID);
            return;
        }
        String name = null;
        try {
            Name _base = _centralNameParser.parse((String)this.mm_principalPaths.get(IDParts[0]));
            Name _principalID = _centralNameParser.parse(orgid);
            name = JNDIUtils.getRelativeBase(_principalID, _base);
        }
        catch (NamingException ne) {
            trace.warningT("deletePrincipalDatabag", "Naming exeption when parsing id " + orgid + "; not on this datasource", ne);
            return;
        }
        boolean success = false;
        int count = 0;
        while (!success) {
            Object var19_22;
            if (count >= this.mm_action_retrial) {
                return;
            }
            InitialDirContext ctx = this._manager.getConnection("deletePrincipalDatabag", IDParts[0], ++count);
            destroyContext = false;
            try {
                try {
                    if (trace.beDebug()) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("Trying to delete principal ").append(uniqueID);
                        trace.debugT("deletePrincipalDatabag", sb.toString());
                    }
                    long time = 0L;
                    if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                        time = System.currentTimeMillis();
                        StringBuffer sb = new StringBuffer();
                        sb.append("deletePrincipalDatabag: ldap access at ").append(time);
                        sb.append("\n\twith destroySubcontext: base: ").append(name);
                        aa.print(sb.toString());
                    }
                    ctx.destroySubcontext(name);
                    if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                        time = System.currentTimeMillis() - time;
                        aa.print("deletePrincipalDatabag: returning from ldap with destroySubcontext after " + time + " ms");
                    }
                    this.exist_cache.invalidate(principal.getUniqueID().toLowerCase() + ".exists");
                    this.search_cache.invalidate();
                    this.search_cache = this.getUMCache("search_cache");
                    if (trace.beInfo()) {
                        trace.infoT("deletePrincipalDatabag", "principal " + uniqueID + " successfully deleted");
                    }
                }
                catch (NameNotFoundException e) {
                    trace.warningT("deletePrincipalDatabag", "could find principal " + principal.getUniqueID() + " on directory server", e);
                    var19_22 = null;
                    this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                    continue;
                }
                catch (CommunicationException ce) {
                    if (trace.beInfo()) {
                        trace.infoT("deletePrincipalDatabag", "CommunicationException: destroying context", ce);
                    }
                    destroyContext = true;
                    if (count == this.mm_action_retrial) {
                        throw new PersistenceException(ce);
                    }
                    var19_22 = null;
                    this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                    continue;
                }
                catch (NoInitialContextException ce) {
                    if (trace.beInfo()) {
                        trace.infoT("deletePrincipalDatabag", "NoInitialContextException: destroying context", ce);
                    }
                    destroyContext = true;
                    if (count == this.mm_action_retrial) {
                        throw new PersistenceException(ce);
                    }
                    var19_22 = null;
                    this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                    continue;
                }
                catch (NamingException e) {
                    StringBuffer sb = new StringBuffer("Naming exception when deleting principal ");
                    sb.append(uniqueID).append(" Excepiton :").append(e.getMessage());
                    trace.errorT("deletePrincipalDatabag", sb.toString());
                    trace.logErrorT("DataSource {0}: Naming exception when deleting principal {1} ", new Object[]{this.getId(), principal});
                    throw new PersistenceException(e);
                }
                catch (Exception e) {
                    StringBuffer sb = new StringBuffer("Exception when deleting principal ");
                    sb.append(uniqueID).append(" Excepiton :").append(e.getMessage());
                    trace.logErrorT("DataSource {0}: Exception when deleting principal {1} ", new Object[]{this.getId(), principal});
                    trace.errorT("deletePrincipalDatabag", sb.toString());
                    throw new PersistenceException(e);
                }
                var19_22 = null;
                this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
            }
            catch (Throwable throwable) {
                var19_22 = null;
                this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                throw throwable;
            }
        }
    }

    private Vector readParentsOfPrincipal(String[] IDParts, String member, String type, String gObclass) throws PersistenceException {
        String name;
        StringBuffer mappedLogicalAttribute;
        String orgid;
        Vector<String> parentsOfPrincipal;
        block37: {
            String mn = "readParentsOfPrincipal";
            parentsOfPrincipal = null;
            orgid = IDParts[2];
            if (!this.caseSensitive && !IDParts[2].equals(IDParts[2].toLowerCase())) {
                if (trace.beInfo()) {
                    trace.infoT("readParentsOfPrincipal", "id " + IDParts[2] + " is not converted to lower case, we are ignoring this search");
                }
                return null;
            }
            ArrayList uniAttr = (ArrayList)this.mm_principalUniqueAttributes.get(IDParts[0]);
            if (uniAttr != null) {
                orgid = this.getDNfromID(uniAttr, IDParts[2], IDParts[0]);
            }
            if (orgid == null) {
                if (trace.beWarning()) {
                    trace.warningT("readParentsOfPrincipal", "can not read membership from distinguished name = null");
                }
                return null;
            }
            String objectclass = "";
            Vector _objectclasses = (Vector)this.mm_principalObjectclasses.get(IDParts[0]);
            if (_objectclasses.size() > 1 && !IDParts[0].equals("GRUP")) {
                objectclass = this.getObjectclass(IDParts[0], IDParts[2]) + ":";
            }
            mappedLogicalAttribute = new StringBuffer();
            if (gObclass != null) {
                mappedLogicalAttribute.append(gObclass).append(":");
            }
            mappedLogicalAttribute.append(objectclass).append("PRINCIPAL_RELATION_PARENT_ATTRIBUTE");
            if (trace.beInfo()) {
                StringBuffer sb = new StringBuffer();
                sb.append("trying to read the membership attribute from the principal;");
                sb.append("memberShip attribute : ");
                sb.append(this.getPhysicalAttribute(IDParts[0], "com.sap.security.core.usermanagement.relation", mappedLogicalAttribute.toString()));
                sb.append(";principal is ").append(orgid);
                trace.infoT("readParentsOfPrincipal", sb.toString());
            }
            name = null;
            if (orgid != null) {
                try {
                    Name _base = _centralNameParser.parse((String)this.mm_principalPaths.get(IDParts[0]));
                    Name _principalID = _centralNameParser.parse(orgid);
                    name = JNDIUtils.getRelativeBase(_principalID, _base);
                }
                catch (NamingException e) {
                    if (!trace.beWarning()) break block37;
                    StringBuffer sb = new StringBuffer();
                    sb.append("naming exception when trying to parse id ").append(orgid);
                    sb.append(" Exception ").append(e.getMessage());
                    trace.warningT("readParentsOfPrincipal", sb.toString());
                }
            }
        }
        if (name != null) {
            String cacheKey = member + "_parents";
            parentsOfPrincipal = (Vector<String>)this.search_cache.get(cacheKey);
            if (parentsOfPrincipal == null) {
                parentsOfPrincipal = new Vector<String>();
                if (trace.beInfo()) {
                    trace.infoT("readParentsOfPrincipal", "parents not found in cache for " + member);
                }
                boolean success = false;
                int count = 0;
                while (!success && count < this.mm_action_retrial) {
                    Object var28_28;
                    ++count;
                    InitialDirContext ctx = null;
                    boolean destroyContext = false;
                    try {
                        try {
                            block38: {
                                ctx = this._manager.getConnection("readParentsOfPrincipal", IDParts[0], count);
                                String physAttr = this.getPhysicalAttribute(IDParts[0], "com.sap.security.core.usermanagement.relation", mappedLogicalAttribute.toString());
                                physAttr = this.getRealPhysicalAttribute(physAttr);
                                String[] attr = new String[]{physAttr};
                                if (trace.beDebug()) {
                                    StringBuffer sb = new StringBuffer();
                                    sb.append("looking for attribute ").append(attr[0]);
                                    sb.append(" for principal ").append(orgid);
                                    trace.debugT("readParentsOfPrincipal", sb.toString());
                                }
                                long time = 0L;
                                if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                                    time = System.currentTimeMillis();
                                    StringBuffer sb = new StringBuffer();
                                    sb.append("searchPrincipalDatabag(): ldap access at ").append(time);
                                    sb.append("\n\twith getAttributes at base ").append(name);
                                    sb.append("\n\twith attribute ").append(attr[0]);
                                    aa.print(sb.toString());
                                }
                                Attributes parentAttributes = ctx.getAttributes(name, attr);
                                if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                                    time = System.currentTimeMillis() - time;
                                    aa.print("readParentsOfPrincipal: returning from ldap after " + time + " ms");
                                }
                                NamingEnumeration<? extends Attribute> _attrs = parentAttributes.getAll();
                                try {
                                    if (_attrs.hasMore()) {
                                        Attribute oneAttribute = _attrs.next();
                                        NamingEnumeration<?> allmembers = oneAttribute.getAll();
                                        while (allmembers.hasMore()) {
                                            String mem = (String)allmembers.next();
                                            mem = JNDIUtils.specialHandlingMSADS(mem);
                                            if ((mem = this.convertDNintoUMEID(mem, type)) == null) continue;
                                            parentsOfPrincipal.add(mem);
                                            if (!trace.beDebug()) continue;
                                            trace.debugT("readParentsOfPrincipal", "adding parent " + mem + " for " + member);
                                        }
                                    }
                                }
                                catch (PartialResultException e) {
                                    if (!trace.beInfo()) break block38;
                                    StringBuffer sb = new StringBuffer();
                                    sb.append("Partial result exception while processing attribute values ");
                                    sb.append(" Exception ").append(e.getMessage());
                                    trace.infoT("readParentsOfPrincipal", sb.toString());
                                }
                            }
                            this.search_cache.put(cacheKey, parentsOfPrincipal.clone());
                            success = true;
                            Vector<String> vector = parentsOfPrincipal;
                            var28_28 = null;
                            if (ctx != null) {
                                this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                            }
                            return vector;
                        }
                        catch (CommunicationException ce) {
                            if (trace.beInfo()) {
                                trace.infoT("readParentsOfPrincipal", "CommunicationException: destroying context " + ce.getMessage());
                            }
                            destroyContext = true;
                            if (count == this.mm_action_retrial) {
                                throw new PersistenceException(ce);
                            }
                            var28_28 = null;
                            if (ctx == null) continue;
                            this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                        }
                        catch (NoInitialContextException ce) {
                            if (trace.beInfo()) {
                                trace.warningT("readParentsOfPrincipal", "NoInitialContextException: destroying context " + ce.getMessage());
                            }
                            destroyContext = true;
                            if (count == this.mm_action_retrial) {
                                throw new PersistenceException(ce);
                            }
                            var28_28 = null;
                            if (ctx == null) continue;
                            this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                        }
                        catch (NamingException ne) {
                            trace.warningT("readParentsOfPrincipal", "Naming exception when searching for parents ", ne);
                            var28_28 = null;
                            if (ctx == null) continue;
                            this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                        }
                        catch (Exception e) {
                            trace.warningT("readParentsOfPrincipal", "Exception when searching for parents ", e);
                            var28_28 = null;
                            if (ctx == null) continue;
                            this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                        }
                    }
                    catch (Throwable throwable) {
                        var28_28 = null;
                        if (ctx != null) {
                            this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                        }
                        throw throwable;
                    }
                }
            } else {
                if (trace.beInfo()) {
                    trace.infoT("readParentsOfPrincipal", "parents for " + member + " found in cache");
                }
                return parentsOfPrincipal;
            }
        }
        return parentsOfPrincipal;
    }

    private Vector searchParentsOfPrincipal(String member, String type, int operator, int criteriaLimit, SearchCriteria criteria) throws PersistenceException {
        String mn = "searchParentsOfPrincipal";
        Vector<String> foundIDs = new Vector<String>();
        StringBuffer _filter = new StringBuffer();
        String[] IDParts = this.splitPrincipalDatabagID(member);
        String orgid = IDParts[2];
        ArrayList uniAttr = (ArrayList)this.mm_principalUniqueAttributes.get(IDParts[0]);
        if (uniAttr != null) {
            orgid = this.getDNfromID(uniAttr, IDParts[2], IDParts[0]);
        }
        if (orgid == null) {
            if (trace.beInfo()) {
                trace.infoT("searchParentsOfPrincipal", "can not search parents of distinguished name = null");
            }
            return null;
        }
        String physAttribute = this.getPhysicalAttribute(type, "com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE");
        orgid = JNDIUtils.specialHandlingBackMSADS(orgid);
        orgid = JNDIUtils.escapeBothBackSlash(orgid);
        orgid = JNDIUtils.escForSearchFilter(orgid);
        orgid = JNDIUtils.unescapeSlash(orgid);
        if (operator == 0) {
            orgid = this.escapeWildCards(orgid);
        } else if (operator != 1 && trace.beInfo()) {
            trace.infoT("searchParentsOfPrincipal", "unsupported search operator " + operator);
        }
        _filter.append("(").append(physAttribute).append("=");
        _filter.append(orgid).append(")");
        Vector objectclasses = (Vector)this.mm_principalObjectclasses.get(type);
        String objectclass = (String)objectclasses.firstElement();
        String tmp = _filter.toString();
        _filter = new StringBuffer();
        _filter.append("(&(objectclass=").append(objectclass).append(")").append(tmp).append(")");
        boolean success = false;
        int count = 0;
        if (!success && count < this.mm_action_retrial) {
            ++count;
            Vector<String> _retAttribs = new Vector<String>();
            _retAttribs.add("objectclass");
            ArrayList uniqueAttributes = (ArrayList)this.mm_principalUniqueAttributes.get(type);
            if (uniqueAttributes != null) {
                _retAttribs.add((String)uniqueAttributes.get(0));
            }
            SearchControls sc = new SearchControls();
            sc.setSearchScope(2);
            sc.setDerefLinkFlag(false);
            sc.setReturningAttributes(_retAttribs.toArray(new String[0]));
            String base = "";
            if (criteriaLimit > 0 && criteriaLimit < this.mm_size_limit) {
                sc.setCountLimit(criteriaLimit);
            } else {
                sc.setCountLimit(this.mm_size_limit);
            }
            sc.setTimeLimit(this.mm_time_limit);
            String cachekey = "parents_of_" + _filter.toString();
            SearchCacheEntry entry = (SearchCacheEntry)this.search_cache.get(cachekey);
            InitialDirContext ctx = null;
            boolean destroyContext = false;
            if (entry == null) {
                block55: {
                    if (trace.beInfo()) {
                        trace.infoT("searchParentsOfPrincipal", "Nothing found in cache, search filter is " + _filter.toString() + " base is " + base);
                    }
                    try {
                        try {
                            ctx = this._manager.getConnection("doSearch", type, count);
                            long time = 0L;
                            if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                                time = System.currentTimeMillis();
                                StringBuffer sb = new StringBuffer();
                                sb.append("searchParentsOfPrincipal: ldap access at ").append(time);
                                sb.append("\n\twith search  base:").append(base);
                                sb.append("\n\tsearchfilter:").append(_filter.toString());
                                aa.print(sb.toString());
                            }
                            NamingEnumeration<SearchResult> sResults = ctx.search(base, _filter.toString(), sc);
                            if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                                time = System.currentTimeMillis() - time;
                                aa.print("searchParentsOfPrincipal: returnig from ldap after:" + time + " ms");
                            }
                            while (sResults != null && sResults.hasMore()) {
                                SearchResult sr = sResults.next();
                                sr.setRelative(true);
                                String completeName = null;
                                String srName = sr.getName();
                                srName = JNDIUtils.removeQuotes(srName);
                                srName = JNDIUtils.specialHandlingBackMSADS(srName);
                                srName = JNDIUtils.specialHandlingMSADS(srName);
                                String path = (String)this.mm_principalPaths.get(type);
                                if (path.length() > 0 && srName.length() > 0) {
                                    completeName = srName + "," + path;
                                } else if (path.length() == 0) {
                                    completeName = srName;
                                } else if (srName.length() == 0) {
                                    completeName = path;
                                }
                                if (completeName == null) continue;
                                ArrayList _uniAttr = (ArrayList)this.mm_principalUniqueAttributes.get(type);
                                if (_uniAttr != null) {
                                    String uniAttrName = (String)_uniAttr.get(0);
                                    Attribute uniAttribute = sr.getAttributes().get(uniAttrName);
                                    if (uniAttribute != null) {
                                        NamingEnumeration<?> vals = uniAttribute.getAll();
                                        if (vals.hasMore()) {
                                            completeName = (String)vals.next();
                                            if (!this.caseSensitive) {
                                                completeName = completeName.toLowerCase();
                                            }
                                        } else {
                                            completeName = null;
                                        }
                                    } else {
                                        completeName = null;
                                    }
                                }
                                if (completeName == null) continue;
                                foundIDs.add(this.getUMID(type, completeName));
                            }
                            success = true;
                        }
                        catch (SizeLimitExceededException se) {
                            criteria.errorOccurred(4);
                            if (trace.beWarning()) {
                                StringBuffer sb = new StringBuffer();
                                sb.append("Size limit reached when searching with searchfilter ");
                                sb.append(_filter.toString()).append("; Exception: ").append(se.getMessage());
                                trace.warningT("searchParentsOfPrincipal", sb.toString());
                            }
                            Object var38_47 = null;
                            if (ctx != null) {
                                this._manager.releaseConnection(type, ctx, destroyContext);
                            }
                            break block55;
                        }
                        catch (TimeLimitExceededException te) {
                            criteria.errorOccurred(8);
                            if (trace.beWarning()) {
                                StringBuffer sb = new StringBuffer();
                                sb.append("Time limit reached when searching with searchfilter ");
                                sb.append(_filter.toString()).append("; Exception: ").append(te.getMessage());
                                trace.warningT("searchParentsOfPrincipal", sb.toString());
                            }
                            Object var38_48 = null;
                            if (ctx != null) {
                                this._manager.releaseConnection(type, ctx, destroyContext);
                            }
                            break block55;
                        }
                        catch (PartialResultException pe) {
                            if (trace.beInfo()) {
                                StringBuffer sb = new StringBuffer();
                                sb.append("Partial result exception when searching with searchfilter ");
                                sb.append(_filter.toString()).append(" Exception ").append(pe.getMessage());
                                trace.infoT("searchParentsOfPrincipal", sb.toString());
                            }
                            Object var38_49 = null;
                            if (ctx != null) {
                                this._manager.releaseConnection(type, ctx, destroyContext);
                            }
                            break block55;
                        }
                        catch (CommunicationException ce) {
                            destroyContext = true;
                            if (trace.beInfo()) {
                                trace.infoT("searchParentsOfPrincipal", "Communication exception, destroying corrupt context");
                            }
                            if (count == this.mm_action_retrial) {
                                throw new PersistenceException(ce);
                            }
                            Object var38_50 = null;
                            if (ctx != null) {
                                this._manager.releaseConnection(type, ctx, destroyContext);
                            }
                            break block55;
                        }
                        catch (NoInitialContextException ce) {
                            destroyContext = true;
                            if (trace.beInfo()) {
                                trace.infoT("searchParentsOfPrincipal", "No initial context exception, destroying corrupt context");
                            }
                            if (count == this.mm_action_retrial) {
                                throw new PersistenceException(ce);
                            }
                            Object var38_51 = null;
                            if (ctx != null) {
                                this._manager.releaseConnection(type, ctx, destroyContext);
                            }
                            break block55;
                        }
                        catch (NamingException e) {
                            if (trace.beWarning()) {
                                StringBuffer sb = new StringBuffer();
                                sb.append("Naming Exception when searching for parents for a principal with searchfilter ");
                                sb.append(_filter.toString());
                                trace.warningT("searchParentsOfPrincipal", sb.toString(), e);
                            }
                            Object var38_52 = null;
                            if (ctx != null) {
                                this._manager.releaseConnection(type, ctx, destroyContext);
                            }
                            break block55;
                        }
                        catch (Exception e) {
                            if (trace.beWarning()) {
                                StringBuffer sb = new StringBuffer();
                                sb.append("Exception when searching for parents for a principal with searchfilter ");
                                sb.append(_filter.toString());
                                trace.warningT("searchParentsOfPrincipal", sb.toString(), e);
                            }
                            Object var38_53 = null;
                            if (ctx != null) {
                                this._manager.releaseConnection(type, ctx, destroyContext);
                            }
                        }
                        Object var38_46 = null;
                        if (ctx != null) {
                            this._manager.releaseConnection(type, ctx, destroyContext);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var38_54 = null;
                        if (ctx != null) {
                            this._manager.releaseConnection(type, ctx, destroyContext);
                        }
                        throw throwable;
                    }
                }
                this.search_cache.put(cachekey, new SearchCacheEntry(foundIDs, criteria.getSearchStatus()));
                return foundIDs;
            }
            if (trace.beInfo()) {
                trace.infoT("searchParentsOfPrincipal", "parents found in cache for " + member);
            }
            return (Vector)entry.getResultsIDs().clone();
        }
        return foundIDs;
    }

    /*
     * Unable to fully structure code
     */
    public Vector searchPrincipalDatabags(SearchCriteria criteria) throws PersistenceException {
        block166: {
            block162: {
                mn = "searchPrincipalDatabag";
                destroyContext = false;
                if (LDAPPersistence.trace.bePath()) {
                    LDAPPersistence.trace.entering("searchPrincipalDatabag", new Object[]{criteria});
                }
                bArrays = new Vector<byte[]>();
                bCount = -1;
                foundIDs = new Vector();
                foundParentIDs = new Vector<String>();
                parentsFound = false;
                pleaseSearch = false;
                groupMemberShip = new Vector();
                groupMemberShipSearch = false;
                accountForUserID = new Vector<String>();
                accountForUserIDSearch = false;
                dnBridgeSearchIDs = new Vector<String>();
                dnBridgeSearch = false;
                elementCount = 0;
                myDomain = null;
                if (this.isInitialized && !this.lazyInitialisation) break block162;
                LDAPPersistence.trace.errorT("searchPrincipalDatabag", "data source is not initialized");
                if (!this.lazyInitialisation) ** GOTO lbl32
                if (criteria.getPrincipalType().equals("GRUP")) ** GOTO lbl29
                if (this.reinitializeConnectionManager()) {
                    if (LDAPPersistence.trace.beWarning()) {
                        LDAPPersistence.trace.warningT("searchPrincipalDatabag", "connection manager initialized");
                    }
                } else {
                    LDAPPersistence.trace.logErrorT("DataSource {0}: Data source is not initialized", new Object[]{this.getId()});
                    throw new PersistenceException("data source " + this.getId() + " not initialized");
lbl29:
                    // 1 sources

                    if (LDAPPersistence.trace.beWarning()) {
                        LDAPPersistence.trace.warningT("searchPrincipalDatabag", "Lazy initialisation failed: returning empty search result for group search");
                    }
                    return new Vector<E>();
lbl32:
                    // 1 sources

                    LDAPPersistence.trace.logErrorT("DataSource {0}: Data source is not initialized", new Object[]{this.getId()});
                    throw new PersistenceException("data source " + this.getId() + " not initialized");
                }
            }
            if ((objectclasses = (Vector)this.mm_principalObjectclasses.get(type = criteria.getPrincipalType())) != null && objectclasses.size() > 1) {
                if (LDAPPersistence.trace.beInfo()) {
                    LDAPPersistence.trace.infoT("searchPrincipalDatabag", "multiple objectclasses defined: switch to search with different objectclasses");
                }
                mfoundIDS = null;
                i = 0;
                while (i < criteria.getElementSize()) {
                    crit = new SearchCriteria(criteria.isOrMode(), criteria.getPrincipalType());
                    sa = criteria.getAttribute(i);
                    if (!sa.getAttributeNameSpace().equals("com.sap.security.core.usermanagement") || !sa.getAttributeName().equals("PRINCIPAL_TYPE_ATTRIBUTE")) {
                        switch (sa.getOperator()) {
                            case 0: {
                                crit.addEqualsElement(sa.getAttributeNameSpace(), sa.getAttributeName(), sa.getAttributeValue(), sa.isCaseSensitive());
                                break;
                            }
                            case 2: {
                                crit.addGreaterThanElement(sa.getAttributeNameSpace(), sa.getAttributeName(), sa.getAttributeValue(), sa.isCaseSensitive());
                                break;
                            }
                            case 3: {
                                crit.addLessThanElement(sa.getAttributeNameSpace(), sa.getAttributeName(), sa.getAttributeValue(), sa.isCaseSensitive());
                                break;
                            }
                            default: {
                                crit.addLikeElement(sa.getAttributeNameSpace(), sa.getAttributeName(), sa.getAttributeValue(), sa.isCaseSensitive());
                            }
                        }
                        tempElements = this.searchWithMultipleObjectClasses(crit);
                        if (tempElements != null) {
                            mfoundIDS = mfoundIDS == null ? this.mixupResults(new Vector<E>(), tempElements, criteria.isOrMode(), false) : this.mixupResults(mfoundIDS, tempElements, criteria.isOrMode(), true);
                        }
                    }
                    ++i;
                }
                mfoundIDS = this.removeBlockedPrincipals(mfoundIDS);
                return mfoundIDS;
            }
            criteriaCount = criteria.getElementSize();
            _filter = new StringBuffer();
            i = 0;
            while (i < criteriaCount) {
                block163: {
                    block164: {
                        block157: {
                            block165: {
                                sElement = criteria.getAttribute(i);
                                namespace = sElement.getAttributeNameSpace();
                                attributeName = sElement.getAttributeName();
                                op = sElement.getOperator();
                                value = sElement.getAttributeValue();
                                membership = false;
                                if (attributeName.equals("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE") && namespace.equals("com.sap.security.core.usermanagement.relation") && type.equals("GRUP") && this.feelsResponsible(type, namespace, attributeName) && (IDParts = this.splitPrincipalDatabagID(member = (String)sElement.getAttributeValue()))[1].equals(this.getId())) {
                                    dn = IDParts[2];
                                    if (this.mm_principalUniqueAttributes.get(IDParts[0]) != null && ((ArrayList)this.mm_principalUniqueAttributes.get(IDParts[0])).size() > 0) {
                                        dn = this.getDNfromID((ArrayList)this.mm_principalUniqueAttributes.get(IDParts[0]), IDParts[2], IDParts[0]);
                                    }
                                    if (dn != null) {
                                        objectclass = "";
                                        _objectclasses = (Vector)this.mm_principalObjectclasses.get(IDParts[0]);
                                        if (_objectclasses.size() > 1 && !IDParts[0].equals("GRUP")) {
                                            objectclass = this.getObjectclass(IDParts[0], dn) + ":";
                                        }
                                        attributeToCheck = new StringBuffer();
                                        attributeToCheck.append(objectclass);
                                        attributeToCheck.append("PRINCIPAL_RELATION_PARENT_ATTRIBUTE");
                                        if (!this.getPhysicalAttribute(IDParts[0], namespace, attributeToCheck.toString()).equals("*null*")) {
                                            membership = true;
                                            parentsOfPrincipal = this.readParentsOfPrincipal(IDParts, member, type, null);
                                            if (parentsOfPrincipal != null) {
                                                groupMemberShip = this.mixupResults(groupMemberShip, parentsOfPrincipal, criteria.isOrMode(), groupMemberShipSearch);
                                                groupMemberShipSearch = true;
                                            }
                                        } else if (!this.getPhysicalAttribute(type, namespace, attributeToCheck.toString()).equals("*null*")) {
                                            membership = true;
                                            parentsOfPrincipal = this.searchParentsOfPrincipal(member, type, op, criteria.getSearchSizeLimit(), criteria);
                                            if (parentsOfPrincipal != null) {
                                                groupMemberShip = this.mixupResults(groupMemberShip, parentsOfPrincipal, criteria.isOrMode(), groupMemberShipSearch);
                                                groupMemberShipSearch = true;
                                            }
                                        }
                                    } else if (LDAPPersistence.trace.beInfo()) {
                                        LDAPPersistence.trace.infoT("searchPrincipalDatabag", "Calculated distinguished name is null for " + member + "; ignored");
                                    }
                                }
                                if (membership || !this.feelsResponsible(type, namespace, attributeName)) break block163;
                                if (!(value instanceof String)) break block164;
                                physAttribute = this.getPhysicalAttribute(type, namespace, attributeName);
                                if (physAttribute.equals("*null*")) break block165;
                                switch (op) {
                                    case 0: {
                                        if (!attributeName.equals("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE") && !attributeName.equals("userid")) ** GOTO lbl132
                                        iDParts = this.splitPrincipalDatabagID((String)value);
                                        if (iDParts[1].equals(this.getId()) && (this.caseSensitive || iDParts[2].equals(iDParts[2].toLowerCase()))) {
                                            IDParts = this.splitPrincipalDatabagID((String)value);
                                            _dnID = IDParts[2];
                                            uniAttr = (ArrayList)this.mm_principalUniqueAttributes.get(IDParts[0]);
                                            if (uniAttr != null) {
                                                _dnID = this.getDNfromID(uniAttr, IDParts[2], IDParts[0]);
                                            }
                                            if (_dnID != null) {
                                                if (attributeName.equals("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE")) {
                                                    _dnID = JNDIUtils.specialHandlingBackMSADS(_dnID);
                                                    _dnID = JNDIUtils.escapeBothBackSlash(_dnID);
                                                }
                                                _dnID = JNDIUtils.escForSearchFilter(_dnID);
                                                _dnID = JNDIUtils.unescapeSlash(_dnID);
                                                _dnID = this.escapeWildCards(_dnID);
                                                _filter.append("(").append(physAttribute).append("=");
                                                _filter.append(_dnID).append(")");
                                                ++elementCount;
                                                pleaseSearch = true;
                                                break;
                                            }
                                        }
                                        break block163;
lbl132:
                                        // 1 sources

                                        if (!this.mm_multiDomainEnabled || !attributeName.equals("j_user") || ((String)value).indexOf("\\") == -1) ** GOTO lbl150
                                        domain = ((String)value).substring(0, ((String)value).indexOf("\\"));
                                        _logonid = ((String)value).substring(((String)value).indexOf("\\") + 1, ((String)value).length());
                                        if (this.isDomainAllowed(domain)) {
                                            _logonid = JNDIUtils.escapeAttributeValue(_logonid);
                                            _logonid = JNDIUtils.escForSearchFilter(_logonid);
                                            _logonid = this.escapeWildCards(_logonid);
                                            changedPhysicalAttribute = this.getPhysicalAttribute("UACC", "com.sap.security.core.usermanagement", "domain_j_user");
                                            _filter.append("(").append(changedPhysicalAttribute).append("=");
                                            _filter.append(_logonid).append(")");
                                            if (myDomain == null) {
                                                myDomain = domain;
                                            }
                                            ++elementCount;
                                            pleaseSearch = true;
                                            break;
                                        }
                                        break block163;
lbl150:
                                        // 1 sources

                                        value = JNDIUtils.escapeAttributeValue((String)value);
                                        value = JNDIUtils.escForSearchFilter((String)value);
                                        value = this.escapeWildCards((String)value);
                                        _filter.append("(").append(physAttribute).append("=");
                                        _filter.append((String)value).append(")");
                                        ++elementCount;
                                        pleaseSearch = true;
                                        break;
                                    }
                                    case 1: {
                                        _filter.append("(").append(physAttribute).append("=");
                                        value = JNDIUtils.escapeAttributeValue((String)value);
                                        value = JNDIUtils.escForSearchFilter((String)value);
                                        _filter.append((String)value).append(")");
                                        ++elementCount;
                                        pleaseSearch = true;
                                        break;
                                    }
                                    case 3: {
                                        value = JNDIUtils.escapeAttributeValue((String)value);
                                        value = JNDIUtils.escForSearchFilter((String)value);
                                        _filter.append("(").append(physAttribute).append("<");
                                        _filter.append((String)value).append(")");
                                        ++elementCount;
                                        pleaseSearch = true;
                                        break;
                                    }
                                    case 2: {
                                        value = JNDIUtils.escapeAttributeValue((String)value);
                                        value = JNDIUtils.escForSearchFilter((String)value);
                                        _filter.append("(").append(physAttribute).append(">");
                                        _filter.append((String)value).append(")");
                                        ++elementCount;
                                        pleaseSearch = true;
                                        break;
                                    }
                                    default: {
                                        if (LDAPPersistence.trace.beWarning()) {
                                            LDAPPersistence.trace.warningT("searchPrincipalDatabag", "Ignoring unsupported search operator " + op);
                                            break;
                                        }
                                        break block163;
                                    }
                                }
                                break block163;
                            }
                            if (type.equals("UACC") && attributeName.equals("userid") && this.mm_userAsUseraccount) {
                                user = (String)sElement.getAttributeValue();
                                IDParts = this.splitPrincipalDatabagID(user);
                                uniqueName = IDParts[2];
                                if (!IDParts[1].equals(this.getId()) || !this.caseSensitive && !IDParts[2].equals(IDParts[2].toLowerCase())) {
                                    if (LDAPPersistence.trace.beInfo()) {
                                        LDAPPersistence.trace.infoT("searchPrincipalDatabag", "User account " + IDParts[2] + " is not on data souce " + this.getId());
                                    }
                                } else {
                                    accountForUserIDSearch = true;
                                    sb = new StringBuffer();
                                    sb.append("UACC").append(".");
                                    sb.append(IDParts[1]).append(".");
                                    if (this.caseSensitive) {
                                        sb.append(IDParts[2]);
                                    } else {
                                        sb.append(IDParts[2].toLowerCase());
                                    }
                                    accountForUserID.add(sb.toString());
                                }
                            }
                            if (attributeName.equals("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE") && type.equals("GRUP") && this.mm_flatUserGroupHierachy != 0 && op == 0 && (this.caseSensitive || this.splitPrincipalDatabagID((String)value)[2].equals(this.splitPrincipalDatabagID((String)value)[2].toLowerCase()))) {
                                _value = (String)value;
                                _internalDN = this.splitPrincipalDatabagID(_value)[2];
                                _datasourceID = this.splitPrincipalDatabagID(_value)[1];
                                _type = this.splitPrincipalDatabagID(_value)[0];
                                uniAttr = (ArrayList)this.mm_principalUniqueAttributes.get(_type);
                                if (uniAttr != null) {
                                    _internalDN = this.getDNfromID(uniAttr, _internalDN, _type);
                                }
                                _path = (String)this.mm_principalPaths.get(type);
                                if (_internalDN != null && !_path.equalsIgnoreCase(_internalDN) && _path.length() < _internalDN.length()) {
                                    newDN = null;
                                    DNtoCheck = null;
                                    try {
                                        newDN = LDAPPersistence._centralNameParser.parse(_internalDN);
                                        newDN = newDN.getPrefix(newDN.size() - 1);
                                        DNtoCheck = newDN.toString();
                                        if (DNtoCheck != null && this.getId().equals(_datasourceID) && _path.length() <= DNtoCheck.length()) {
                                            while (!this.checkGroupLocal(DNtoCheck) && DNtoCheck.length() > 0) {
                                                newDN = LDAPPersistence._centralNameParser.parse(DNtoCheck);
                                                newDN = newDN.getPrefix(newDN.size() - 1);
                                                DNtoCheck = newDN.toString();
                                            }
                                            if (this.checkGroupLocal(DNtoCheck) && DNtoCheck.length() > 0) {
                                                _uniAttr = (ArrayList)this.mm_principalUniqueAttributes.get("GRUP");
                                                if (_uniAttr != null) {
                                                    DNtoCheck = this.getIDFromDN(DNtoCheck, "GRUP");
                                                }
                                                if (DNtoCheck != null) {
                                                    foundParentIDs.add(this.getUMID(type, DNtoCheck));
                                                    parentsFound = true;
                                                }
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        if (!LDAPPersistence.trace.beWarning()) break block157;
                                        LDAPPersistence.trace.warningT("searchPrincipalDatabag", "Exception when trying to parse dn " + DNtoCheck, e);
                                    }
                                }
                            }
                        }
                        if (attributeName.equals("dn") && namespace.equals("com.sap.security.core.bridge") && op == 0 && type.equals("GRUP") && this.checkGroupLocal(_value = (String)value)) {
                            newid = this.convertDNintoUMEID(_value, type);
                            if (newid != null) {
                                dnBridgeSearchIDs.add(newid);
                                dnBridgeSearch = true;
                            } else {
                                LDAPPersistence.trace.logWarningT("Could not create id from dn {0}, please check trace file", new Object[]{_value});
                                LDAPPersistence.trace.warningT("searchPrincipalDatabag", "Could not create id from dn " + _value + " for type " + type);
                            }
                        }
                        break block163;
                    }
                    if (type.equals("UACC") && namespace.equals("com.sap.security.core.usermanagement") && attributeName.equals("javax.servlet.request.X509Certificate") && !(physAttribute = this.getPhysicalAttribute(type, namespace, attributeName)).equals("*null*")) {
                        cert = (X509Certificate)value;
                        try {
                            _value = cert.getEncoded();
                            bArrays.add(_value);
                            _filter.append("(").append(physAttribute).append("=");
                            _filter.append("{").append(++bCount).append("})");
                            ++elementCount;
                            pleaseSearch = true;
                        }
                        catch (CertificateEncodingException e) {
                            LDAPPersistence.trace.errorT("searchPrincipalDatabag", "Error getting byte[] from certificate, could not search for the useraccount", e);
                        }
                    }
                }
                ++i;
            }
            _completeFilter = new StringBuffer();
            if (_filter.length() > 0) {
                if (elementCount > 1) {
                    if (criteria.isOrMode()) {
                        _completeFilter.append("(|").append(_filter.toString()).append(")");
                    } else {
                        _completeFilter.append("(&").append(_filter.toString()).append(")");
                    }
                } else {
                    _completeFilter.append(_filter.toString());
                }
            }
            searchFilter = new StringBuffer();
            if (objectclasses != null && objectclasses != null) {
                searchFilter.append("(&(objectclass=").append((String)objectclasses.firstElement()).append(")");
            }
            if ((type.equals("USER") || type.equals("UACC")) && this.mm_userFilter != null) {
                userfilter = new StringBuffer("(!(|");
                filterKeys = this.mm_userFilter.keys();
                while (filterKeys.hasMoreElements()) {
                    key = (String)filterKeys.nextElement();
                    values = (Vector)this.mm_userFilter.get(key);
                    a = 0;
                    while (a < values.size()) {
                        userfilter.append("(").append(key).append("=").append(values.elementAt(a)).append(")");
                        ++a;
                    }
                }
                userfilter.append("))");
                _searchFilter = _completeFilter.toString();
                _completeFilter = new StringBuffer();
                _completeFilter.append("(&").append(_searchFilter).append((Object)userfilter).append(")");
            }
            searchFilter.append(_completeFilter.toString());
            searchFilter.append(")");
            base = "";
            ctx = null;
            sc = null;
            physDescription = this.getPhysicalAttribute(type, "com.sap.security.core.usermanagement", "description");
            if (!pleaseSearch) break block166;
            retAttr = (Vector)this.mm_principalNamingAttributes.get(type);
            _myRetAttributes = new Vector<String>();
            if (retAttr != null && retAttr.size() > 0) {
                i = 0;
                while (i < retAttr.size()) {
                    _myRetAttributes.add((String)retAttr.elementAt(i));
                    ++i;
                }
            }
            if (type.equals("UACC") && physDescription != null && !physDescription.equals("*null*")) {
                _myRetAttributes.add(physDescription);
            }
            if (this.mm_principalUniqueAttributes.get(type) != null) {
                _myRetAttributes.add((String)((ArrayList)this.mm_principalUniqueAttributes.get(type)).get(0));
            }
            returningAttributes = new String[]{};
            if (_myRetAttributes.size() > 0) {
                returningAttributes = _myRetAttributes.toArray(new String[0]);
            }
            success = false;
            count = 0;
            while (!success && count < this.mm_action_retrial) {
                ctx = this._manager.getConnection("doSearch", type, ++count);
                destroyContext = false;
                sc = new SearchControls();
                sc.setSearchScope(2);
                sc.setDerefLinkFlag(false);
                sc.setReturningAttributes(returningAttributes);
                criteriaLimit = criteria.getSearchSizeLimit();
                if (criteriaLimit > 0 && criteriaLimit < this.mm_size_limit) {
                    sc.setCountLimit(criteriaLimit);
                } else {
                    sc.setCountLimit(this.mm_size_limit);
                }
                sc.setTimeLimit(this.mm_time_limit);
                try {
                    try {
                        block168: {
                            block167: {
                                block160: {
                                    block158: {
                                        cachekeyBuffer = new StringBuffer();
                                        cachekeyBuffer.append("search*").append(type).append("*");
                                        cachekeyBuffer.append(searchFilter.toString());
                                        if (myDomain != null) {
                                            cachekeyBuffer.append("*").append(myDomain);
                                        }
                                        cachekey = cachekeyBuffer.toString();
                                        entry = null;
                                        if (bCount < 0) {
                                            entry = (SearchCacheEntry)this.search_cache.get(cachekey);
                                        }
                                        if (LDAPPersistence.trace.beInfo()) {
                                            LDAPPersistence.trace.infoT("searchPrincipalDatabag", "entry for search with searchfilter " + searchFilter.toString() + " searched in cache");
                                        }
                                        if (entry != null) break block167;
                                        if (LDAPPersistence.trace.beInfo()) {
                                            LDAPPersistence.trace.infoT("searchPrincipalDatabag", "Nothing found in cache for " + cachekey);
                                            LDAPPersistence.trace.infoT("searchPrincipalDatabag", "Search filter is " + searchFilter.toString() + " base is " + base);
                                        }
                                        time = 0L;
                                        if (LDAPPersistence.props.getBoolean("ume.ldap.record_access", false)) {
                                            time = System.currentTimeMillis();
                                            sb = new StringBuffer();
                                            sb.append("searchPrincipalDatabag: ldap access at ").append(time);
                                            sb.append("\n\twith search  base:").append(base);
                                            sb.append("\n\tsearchfilter:").append(searchFilter.toString());
                                            LDAPPersistence.aa.print(sb.toString());
                                        }
                                        sResults = null;
                                        try {
                                            if (bCount >= 0) {
                                                bObjects = new Object[bArrays.size()];
                                                i = 0;
                                                while (i < bArrays.size()) {
                                                    bObjects[i] = bArrays.elementAt(i);
                                                    ++i;
                                                }
                                                sResults = ctx.search(base, searchFilter.toString(), bObjects, sc);
                                            } else {
                                                sResults = ctx.search(base, searchFilter.toString(), sc);
                                            }
                                        }
                                        catch (SizeLimitExceededException se) {
                                            criteria.errorOccurred(4);
                                            if (LDAPPersistence.trace.beWarning()) {
                                                sb = new StringBuffer();
                                                sb.append("Size limit reached when searching in persistence ").append(this.getId());
                                                sb.append(" with search filter ").append(searchFilter.toString());
                                                sb.append(" Exception: ").append(se.getMessage());
                                                LDAPPersistence.trace.warningT("searchPrincipalDatabag", sb.toString());
                                            }
                                        }
                                        catch (TimeLimitExceededException te) {
                                            criteria.errorOccurred(8);
                                            if (LDAPPersistence.trace.beWarning()) {
                                                sb = new StringBuffer();
                                                sb.append("Time limit reached when searching in persistence ").append(this.getId());
                                                sb.append(" with search filter ").append(searchFilter.toString());
                                                sb.append(" Exception: ").append(te.getMessage());
                                                LDAPPersistence.trace.warningT("searchPrincipalDatabag", sb.toString());
                                            }
                                        }
                                        catch (PartialResultException pe) {
                                            criteria.errorOccurred(4);
                                            if (!LDAPPersistence.trace.beInfo()) break block158;
                                            sb = new StringBuffer();
                                            sb.append("Partial Result Exception when searching in persistence ").append(this.getId());
                                            sb.append(" with search filter ").append(searchFilter.toString());
                                            sb.append(" Exception: ").append(pe.getMessage());
                                            LDAPPersistence.trace.infoT("searchPrincipalDatabag", sb.toString());
                                        }
                                    }
                                    if (LDAPPersistence.props.getBoolean("ume.ldap.record_access", false)) {
                                        time = System.currentTimeMillis() - time;
                                        LDAPPersistence.aa.print("searchPrinciplaDatabag: returnig from ldap after:" + time + " ms");
                                    }
                                    try {
                                        if (true) ** GOTO lbl489
                                        do {
                                            sr = sResults.next();
                                            sr.setRelative(true);
                                            completeName = null;
                                            srName = sr.getName();
                                            srName = JNDIUtils.removeQuotes(srName);
                                            srName = JNDIUtils.specialHandlingBackMSADS(srName);
                                            srName = JNDIUtils.specialHandlingMSADS(srName);
                                            path = (String)this.mm_principalPaths.get(type);
                                            if (path.length() > 0 && srName.length() > 0) {
                                                completeName = srName + "," + path;
                                            } else if (path.length() == 0) {
                                                completeName = srName;
                                            } else if (srName.length() == 0) {
                                                completeName = path;
                                            }
                                            if (type.equals("UACC") && this.mm_userAsUseraccount && (description = sr.getAttributes().get(physDescription)) != null) {
                                                allDescriptions = description.getAll();
                                                while (allDescriptions.hasMore()) {
                                                    if (!((String)allDescriptions.next()).equals("NO_USER_ACCOUNT")) continue;
                                                    completeName = null;
                                                }
                                            }
                                            if (type.equals("UACC") && this.mm_multiDomainEnabled && this.mm_mappedDomains != null && !this.checkDomainOfDN(completeName, myDomain)) {
                                                completeName = null;
                                            }
                                            if (completeName != null) {
                                                uniAttr = (ArrayList)this.mm_principalUniqueAttributes.get(type);
                                                if (uniAttr != null) {
                                                    uniAttrName = (String)uniAttr.get(0);
                                                    uniAttribute = sr.getAttributes().get(uniAttrName);
                                                    if (uniAttribute != null) {
                                                        vals = uniAttribute.getAll();
                                                        if (vals.hasMore()) {
                                                            completeName = (String)vals.next();
                                                            if (!this.caseSensitive) {
                                                                completeName = completeName.toLowerCase();
                                                            }
                                                        } else {
                                                            completeName = null;
                                                        }
                                                    } else {
                                                        completeName = null;
                                                    }
                                                }
                                                if (completeName != null) {
                                                    foundIDs.add(this.getUMID(type, completeName));
                                                }
                                            }
lbl489:
                                            // 6 sources

                                            if (sResults == null) break;
                                        } while (sResults.hasMore());
                                        var50_88 = null;
                                        ** if (sResults == null) goto lbl-1000
                                    }
                                    catch (Throwable var49_91) {
                                        block161: {
                                            var50_88 = null;
                                            if (sResults != null) {
                                                try {
                                                    sResults.close();
                                                }
                                                catch (NamingException ne) {
                                                    if (!LDAPPersistence.trace.beInfo()) break block161;
                                                    LDAPPersistence.trace.infoT("searchPrincipalDatabag", "Problem when closing search results " + ne.getMessage());
                                                }
                                            }
                                        }
                                        throw var49_91;
                                    }
lbl-1000:
                                    // 1 sources

                                    {
                                        try {
                                            sResults.close();
                                        }
                                        catch (NamingException ne) {
                                            if (LDAPPersistence.trace.beInfo()) {
                                                LDAPPersistence.trace.infoT("searchPrincipalDatabag", "Problem when closing search results " + ne.getMessage());
                                            }
                                        }
                                    }
lbl-1000:
                                    // 4 sources

                                    {
                                        break block160;
                                        catch (SizeLimitExceededException se) {
                                            criteria.errorOccurred(4);
                                            if (LDAPPersistence.trace.beWarning()) {
                                                sb = new StringBuffer();
                                                sb.append("Size limit reached when searching in persistence ").append(this.getId());
                                                sb.append(" with search filter ").append(searchFilter.toString());
                                                sb.append(" Exception: ").append(se.getMessage());
                                                LDAPPersistence.trace.warningT("searchPrincipalDatabag", sb.toString());
                                            }
                                            var50_88 = null;
                                            if (sResults != null) {
                                                try {
                                                    sResults.close();
                                                }
                                                catch (NamingException ne) {
                                                    if (LDAPPersistence.trace.beInfo()) {
                                                        LDAPPersistence.trace.infoT("searchPrincipalDatabag", "Problem when closing search results " + ne.getMessage());
                                                    }
                                                }
                                            }
                                            break block160;
                                        }
                                        catch (TimeLimitExceededException te) {
                                            criteria.errorOccurred(8);
                                            if (LDAPPersistence.trace.beWarning()) {
                                                sb = new StringBuffer();
                                                sb.append("Time limit reached when searching in persistence ").append(this.getId());
                                                sb.append(" with search filter ").append(searchFilter.toString());
                                                sb.append(" Exception: ").append(te.getMessage());
                                                LDAPPersistence.trace.warningT("searchPrincipalDatabag", sb.toString());
                                            }
                                            var50_88 = null;
                                            if (sResults != null) {
                                                try {
                                                    sResults.close();
                                                }
                                                catch (NamingException ne) {
                                                    if (LDAPPersistence.trace.beInfo()) {
                                                        LDAPPersistence.trace.infoT("searchPrincipalDatabag", "Problem when closing search results " + ne.getMessage());
                                                    }
                                                }
                                            }
                                            break block160;
                                        }
                                        catch (PartialResultException pe) {
                                            if (LDAPPersistence.trace.beInfo()) {
                                                sb = new StringBuffer();
                                                sb.append("Partial Result Exception when searching in persistence ").append(this.getId());
                                                sb.append(" with search filter ").append(searchFilter.toString());
                                                sb.append(" Exception: ").append(pe.getMessage());
                                                LDAPPersistence.trace.infoT("searchPrincipalDatabag", sb.toString());
                                            }
                                            var50_88 = null;
                                            if (sResults != null) {
                                                try {
                                                    sResults.close();
                                                }
                                                catch (NamingException ne) {
                                                    if (LDAPPersistence.trace.beInfo()) {
                                                        LDAPPersistence.trace.infoT("searchPrincipalDatabag", "Problem when closing search results " + ne.getMessage());
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                this.search_cache.put(cachekey, new SearchCacheEntry(foundIDs, criteria.getSearchStatus()));
                                break block168;
                            }
                            if (LDAPPersistence.trace.beInfo()) {
                                LDAPPersistence.trace.infoT("searchPrincipalDatabag", "search result found in cache");
                            }
                            foundIDs = entry.getResultsIDs();
                            criteria.errorOccurred(entry.getFlag());
                        }
                        success = true;
                    }
                    catch (CommunicationException ce) {
                        destroyContext = true;
                        if (LDAPPersistence.trace.beInfo()) {
                            LDAPPersistence.trace.infoT("searchPrincipalDatabag", "Communication exception, destroying corrupt context", ce);
                        }
                        if (count == this.mm_action_retrial) {
                            throw new PersistenceException(ce);
                        }
                        var53_90 = null;
                        if (ctx == null) continue;
                        this._manager.releaseConnection(type, ctx, destroyContext);
                        continue;
                    }
                    catch (NoInitialContextException ce) {
                        destroyContext = true;
                        if (LDAPPersistence.trace.beInfo()) {
                            LDAPPersistence.trace.infoT("searchPrincipalDatabag", "No initial context exception, destroying corrupt context", ce);
                        }
                        if (count == this.mm_action_retrial) {
                            throw new PersistenceException(ce);
                        }
                        var53_90 = null;
                        if (ctx == null) continue;
                        this._manager.releaseConnection(type, ctx, destroyContext);
                        continue;
                    }
                    catch (NamingException e) {
                        sb = new StringBuffer();
                        sb.append("Naming exception when searching for a principal with filter ");
                        sb.append(searchFilter.toString());
                        LDAPPersistence.trace.errorT("searchPrincipalDatabag", sb.toString(), e);
                        LDAPPersistence.trace.logErrorT("DataSource {0}: Problem when searching for principals with searchfilter {1}", new Object[]{this.getId(), searchFilter.toString()});
                        throw new PersistenceException(e);
                    }
                    catch (Exception e) {
                        sb = new StringBuffer();
                        sb.append("Exception when searching for a principal with filter ");
                        sb.append(searchFilter.toString());
                        LDAPPersistence.trace.errorT("searchPrincipalDatabag", sb.toString(), e);
                        LDAPPersistence.trace.logErrorT("DataSource {0}: Problem when searching for principals with searchfilter {1}", new Object[]{this.getId(), searchFilter.toString()});
                        throw new PersistenceException(e);
                    }
                    var53_90 = null;
                    if (ctx == null) continue;
                    this._manager.releaseConnection(type, ctx, destroyContext);
                }
                catch (Throwable var52_93) {
                    var53_90 = null;
                    if (ctx != null) {
                        this._manager.releaseConnection(type, ctx, destroyContext);
                    }
                    throw var52_93;
                }
            }
        }
        if (groupMemberShipSearch) {
            foundIDs = this.mixupResults(foundIDs, groupMemberShip, criteria.isOrMode(), pleaseSearch);
        }
        if (parentsFound) {
            foundIDs = this.mixupResults(foundIDs, foundParentIDs, criteria.isOrMode(), pleaseSearch);
        }
        if (accountForUserIDSearch) {
            foundIDs = this.mixupResults(foundIDs, accountForUserID, criteria.isOrMode(), pleaseSearch);
        }
        if (dnBridgeSearch) {
            foundIDs = this.mixupResults(foundIDs, dnBridgeSearchIDs, criteria.isOrMode(), pleaseSearch);
        }
        if (LDAPPersistence.trace.beInfo()) {
            sb = new StringBuffer("found principals: ");
            if (foundIDs != null && foundIDs.size() > 0) {
                i = 0;
                while (i < foundIDs.size()) {
                    sb.append((String)foundIDs.elementAt(i));
                    sb.append(",");
                    ++i;
                }
            } else {
                sb.append("no results found");
            }
            LDAPPersistence.trace.infoT("searchPrincipalDatabag", sb.toString());
        }
        foundIDs = this.removeBlockedPrincipals(foundIDs);
        if (pleaseSearch || parentsFound || groupMemberShipSearch || accountForUserIDSearch || dnBridgeSearch) {
            this.putResultsIntoCache(foundIDs);
            return foundIDs;
        }
        return null;
    }

    private void putResultsIntoCache(Vector ids) {
        trace.entering("putResultsIntoVector");
        if (ids != null && ids.size() < 10) {
            int i = 0;
            while (i < ids.size()) {
                String key = (String)ids.elementAt(i) + ".exists";
                this.exist_cache.invalidate(key.toLowerCase());
                this.exist_cache.put(key.toLowerCase(), "true");
                ++i;
            }
        }
    }

    private Vector mixupResults(Vector result1, Vector result2, boolean or, boolean result1Found) {
        trace.entering("mixupResults");
        if (or) {
            int i = 0;
            while (i < result2.size()) {
                result1.add(result2.elementAt(i));
                ++i;
            }
        } else {
            Vector mixedIDs = new Vector();
            if (result1Found) {
                int i = 0;
                while (i < result1.size()) {
                    if (result2.contains(result1.elementAt(i))) {
                        mixedIDs.add(result1.elementAt(i));
                    }
                    ++i;
                }
            } else {
                mixedIDs = result2;
            }
            result1 = mixedIDs;
        }
        return result1;
    }

    /*
     * Unable to fully structure code
     */
    public boolean principalDatabagExists(IPrincipalDatabag principal) throws PersistenceException {
        block50: {
            mn = "principalDatabagExists";
            if (LDAPPersistence.trace.bePath()) {
                LDAPPersistence.trace.entering("principalDatabagExists", new Object[]{principal});
            }
            principalExists = false;
            if (this.isInitialized && !this.lazyInitialisation) break block50;
            LDAPPersistence.trace.errorT("principalDatabagExists", "data source is not initialized");
            if (!this.lazyInitialisation) ** GOTO lbl13
            if (this.reinitializeConnectionManager()) {
                LDAPPersistence.trace.warningT("principalDatabagExists", "connection manager initialized");
            } else {
                LDAPPersistence.trace.logErrorT("DataSource {0}: Data source is not initialized", new Object[]{this.getId()});
                throw new PersistenceException("data source " + this.getId() + " not initialized");
lbl13:
                // 1 sources

                LDAPPersistence.trace.logErrorT("DataSource {0}: Data source is not initialized", new Object[]{this.getId()});
                throw new PersistenceException("data source " + this.getId() + " not initialized");
            }
        }
        if (!this.isPrimary()) {
            LDAPPersistence.trace.warningT("principalDatabagExists", "data source " + this.getId() + "is not primary, can not check existence");
            return false;
        }
        uniqueID = principal.getUniqueID();
        if (uniqueID == null) {
            LDAPPersistence.trace.errorT("principalDatabagExists", "principal is not bound to a datasource, unique is is null.");
            throw new PersistenceException("unique id is null");
        }
        if (this._blockedPrincipals.contains(uniqueID)) {
            if (LDAPPersistence.trace.beWarning()) {
                LDAPPersistence.trace.warningT("principalDatabagExists", "principal is member of blocked principals and does not exist");
            }
            return false;
        }
        IDParts = principal.getIDParts();
        if (!this.caseSensitive && !IDParts[2].equals(IDParts[2].toLowerCase())) {
            if (LDAPPersistence.trace.beWarning()) {
                LDAPPersistence.trace.warningT("principalDatabagExists", "principal id " + IDParts[2] + " is not completely in lower cases and is not created by this datasource");
            }
            return false;
        }
        if (this.isHomeForPrincipalDatabag((IInternalPrincipalDatabag)principal) && IDParts[1].equals(this.getId())) {
            if (LDAPPersistence.trace.beInfo()) {
                LDAPPersistence.trace.infoT("principalDatabagExists", "data source is responsible for this type of principal and tries to find it");
            }
            key = uniqueID + ".exists";
            _checkExistence = (String)this.exist_cache.get(key.toLowerCase());
            if (LDAPPersistence.trace.beInfo()) {
                LDAPPersistence.trace.infoT("principalDatabagExists", "trying to read the entry from cache with key :" + key + " with value " + _checkExistence);
            }
            if (_checkExistence != null) {
                if (LDAPPersistence.trace.beInfo()) {
                    LDAPPersistence.trace.infoT("principalDatabagExists", "cache entry found for key " + key);
                }
                if (_checkExistence.equals("true")) {
                    return true;
                }
                if (_checkExistence.equals("false")) {
                    return false;
                }
            }
            if (LDAPPersistence.trace.beInfo()) {
                LDAPPersistence.trace.infoT("principalDatabagExists", "no cache entry found for key " + key);
            }
            orgid = IDParts[2];
            uniAttr = (ArrayList)this.mm_principalUniqueAttributes.get(IDParts[0]);
            if (uniAttr != null) {
                orgid = this.getDNfromID(uniAttr, IDParts[2], IDParts[0]);
            }
            if (orgid == null) {
                LDAPPersistence.trace.infoT("principalDatabagExists", "Can not check existence of distinguished name = null of " + principal);
                return false;
            }
            retAttr = null;
            physicalDescription = null;
            if (IDParts[0].equals("UACC") && this.mm_userAsUseraccount) {
                physicalDescription = this.getPhysicalAttribute("USER", "com.sap.security.core.usermanagement", "description");
            }
            retAttr = physicalDescription != null && physicalDescription.equals("*null*") == false ? new String[]{"objectclass", physicalDescription} : new String[]{"objectclass"};
            name = null;
            try {
                _principalID = LDAPPersistence._centralNameParser.parse(orgid);
                _base = LDAPPersistence._centralNameParser.parse((String)this.mm_principalPaths.get(IDParts[0]));
                name = JNDIUtils.getRelativeBase(_principalID, _base);
            }
            catch (NamingException e) {
                LDAPPersistence.trace.warningT("principalDatabagExists", "Naming exception when trying to parse id " + orgid, e);
                return false;
            }
            success = false;
            count = 0;
            while (!success && count < this.mm_action_retrial) {
                ctx = this._manager.getConnection("principalDatabagExists", IDParts[0], ++count);
                destroyContext = false;
                try {
                    try {
                        if (LDAPPersistence.trace.beDebug()) {
                            LDAPPersistence.trace.debugT("principalDatabagExists", "trying to read the attribute objectclass in order to check the existence");
                        }
                        time = 0L;
                        if (LDAPPersistence.props.getBoolean("ume.ldap.record_access", false)) {
                            time = System.currentTimeMillis();
                            sb = new StringBuffer();
                            sb.append("principalDatabagExists(): ldap access at ").append(time);
                            sb.append("\n\twith getAttributes() at base ").append(name);
                            sb.append("\n\treading some additional attributes");
                            LDAPPersistence.aa.print(sb.toString());
                        }
                        _allAttrs = ctx.getAttributes(name, retAttr);
                        if (LDAPPersistence.props.getBoolean("ume.ldap.record_access", false)) {
                            time = System.currentTimeMillis() - time;
                            LDAPPersistence.aa.print("principalDatabagExists(): returning from ldap after " + time + " ms");
                        }
                        if (LDAPPersistence.trace.beInfo()) {
                            LDAPPersistence.trace.infoT("principalDatabagExists", "ldap access succesfully, setting existence check to true for principal " + principal.getUniqueID());
                        }
                        if (IDParts[1].equals(this.getId())) {
                            ((IInternalPrincipalDatabag)principal).setExists(true);
                        }
                        obclass = _allAttrs.get("objectclass");
                        _results = obclass.getAll();
                        while (_results.hasMoreElements()) {
                            oneOC = (String)_results.nextElement();
                            objectclasses = (Vector)this.mm_principalObjectclasses.get(IDParts[0]);
                            i = 0;
                            while (i < objectclasses.size() && !principalExists) {
                                objectClasstoCheck = (String)objectclasses.elementAt(i);
                                if (objectClasstoCheck.equalsIgnoreCase(oneOC)) {
                                    principalExists = true;
                                }
                                ++i;
                            }
                        }
                        if (IDParts[0].equals("UACC") && this.mm_userAsUseraccount && (desc = _allAttrs.get(physDescription = this.getPhysicalAttribute("USER", "com.sap.security.core.usermanagement", "description"))) != null) {
                            _descResults = desc.getAll();
                            while (_descResults.hasMore()) {
                                oneDescription = (String)_descResults.next();
                                if (!oneDescription.equals("NO_USER_ACCOUNT")) continue;
                                principalExists = false;
                            }
                        }
                        success = true;
                    }
                    catch (PartialResultException e) {
                        if (LDAPPersistence.trace.beInfo()) {
                            LDAPPersistence.trace.infoT("principalDatabagExists", "partial result exception because of some unrecognized referrals, Exception: " + e.getMessage());
                        }
                        var27_35 = null;
                        this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                        continue;
                    }
                    catch (CommunicationException ce) {
                        destroyContext = true;
                        if (LDAPPersistence.trace.beInfo()) {
                            LDAPPersistence.trace.infoT("principalDatabagExists", "Communication exception , destroying corrupt context", ce);
                        }
                        if (count == this.mm_action_retrial) {
                            throw new PersistenceException(ce);
                        }
                        var27_35 = null;
                        this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                        continue;
                    }
                    catch (NoInitialContextException ce) {
                        destroyContext = true;
                        if (LDAPPersistence.trace.beInfo()) {
                            LDAPPersistence.trace.infoT("principalDatabagExists", "No initial context exception , destroying corrupt context", ce);
                        }
                        if (count == this.mm_action_retrial) {
                            throw new PersistenceException(ce);
                        }
                        var27_35 = null;
                        this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                        continue;
                    }
                    catch (NameNotFoundException e) {
                        if (LDAPPersistence.trace.beInfo()) {
                            LDAPPersistence.trace.infoT("principalDatabagExists", "Principal not found ", e);
                        }
                        success = true;
                        principalExists = false;
                        var27_35 = null;
                        this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                        continue;
                    }
                    catch (NamingException e) {
                        LDAPPersistence.trace.errorT("principalDatabagExists", "naming excepiton when checking existence for a principal", e);
                        LDAPPersistence.trace.logErrorT("DataSource {0}: Problem when checking existence for principal", new Object[]{this.getId()});
                        success = true;
                        principalExists = false;
                        var27_35 = null;
                        this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                        continue;
                    }
                    catch (Exception e) {
                        LDAPPersistence.trace.errorT("principalDatabagExists", "some error occured when checking existence of principal " + uniqueID, e);
                        LDAPPersistence.trace.logErrorT("DataSource {0}: Problem when checking existence for principal", new Object[]{this.getId()});
                        throw new PersistenceException(e);
                    }
                    var27_35 = null;
                    this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                }
                catch (Throwable var26_36) {
                    var27_35 = null;
                    this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                    throw var26_36;
                }
            }
        } else {
            if (LDAPPersistence.trace.beInfo()) {
                LDAPPersistence.trace.infoT("principalDatabagExists", "dataSource " + this.getId() + " is not responsible for the principal " + uniqueID);
            }
            principalExists = false;
        }
        key = principal.getUniqueID() + ".exists";
        this.exist_cache.put(key.toLowerCase(), "" + principalExists);
        return principalExists;
    }

    private String createDistinguishedName(IPrincipalDatabag principal) throws PersistenceException {
        String mn = "createDistinguishedName";
        if (trace.bePath()) {
            trace.entering("createDistinguishedName", new Object[]{principal});
        }
        String id = null;
        Vector types = principal.getAttributeValues("com.sap.security.core.usermanagement", "PRINCIPAL_TYPE_ATTRIBUTE");
        String _type = (String)types.firstElement();
        if (_type.equals("UACC")) {
            if (this.mm_userAsUseraccount) {
                Vector vals = principal.getAttributeValues("com.sap.security.core.usermanagement", "userid");
                String userID = (String)vals.firstElement();
                try {
                    id = this.getDNfromID((ArrayList)this.mm_principalUniqueAttributes.get("USER"), this.splitPrincipalDatabagID(userID)[2], "USER");
                }
                catch (PersistenceException ex) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("Exception when splitting the id ").append(userID);
                    sb.append(" Exception ").append(ex.getMessage());
                    trace.warningT("createDistinguishedName", sb.toString());
                }
                if (this.caseSensitive) {
                    if (trace.bePath()) {
                        trace.exiting("createDistinguishedName", id);
                    }
                    return id;
                }
                if (trace.bePath()) {
                    trace.exiting("createDistinguishedName", id.toLowerCase());
                }
                return id.toLowerCase();
            }
            Vector namAttr = (Vector)this.mm_principalNamingAttributes.get(_type);
            Vector objectclasses = (Vector)this.mm_principalObjectclasses.get(_type);
            String naming = (String)namAttr.firstElement();
            String logAttr = null;
            if (objectclasses.size() > 1) {
                String obj = (String)objectclasses.firstElement();
                logAttr = this.getLogicalAttribute(_type, "com.sap.security.core.usermanagement", obj + ":" + naming);
                logAttr = this.getRealPhysicalAttribute(logAttr);
            } else {
                logAttr = this.getLogicalAttribute(_type, "com.sap.security.core.usermanagement", naming);
            }
            String namValue = (String)principal.getAttributeValues("com.sap.security.core.usermanagement", logAttr).firstElement();
            StringBuffer sb = new StringBuffer();
            namValue = JNDIUtils.escapeBackSlash(namValue);
            namValue = JNDIUtils.escapeDistinguishedName(namValue);
            sb.append(naming).append("=").append(JNDIUtils.specialHandlingMSADS(namValue));
            if (this.mm_principalCreationPaths.get(_type) != null && ((String)this.mm_principalCreationPaths.get(_type)).length() > 0) {
                sb.append(",").append((String)this.mm_principalCreationPaths.get(_type));
            }
            if (this.mm_principalPaths.get(_type) != null && ((String)this.mm_principalPaths.get(_type)).length() > 0) {
                sb.append(",").append((String)this.mm_principalPaths.get(_type));
            }
            if (this.caseSensitive) {
                if (trace.bePath()) {
                    trace.exiting("createDistinguishedName", sb.toString());
                }
                return sb.toString();
            }
            if (trace.bePath()) {
                trace.exiting("createDistinguishedName", sb.toString().toLowerCase());
            }
            return sb.toString().toLowerCase();
        }
        StringBuffer sb = new StringBuffer();
        Vector namAttr = (Vector)this.mm_principalNamingAttributes.get(_type);
        String fna = (String)namAttr.firstElement();
        Vector objectclasses = (Vector)this.mm_principalObjectclasses.get(_type);
        String logAttr = null;
        if (objectclasses.size() > 1) {
            String obj = (String)objectclasses.firstElement();
            logAttr = this.getLogicalAttribute(_type, "com.sap.security.core.usermanagement", obj + ":" + fna);
            logAttr = this.getRealPhysicalAttribute(logAttr);
        } else {
            logAttr = this.getLogicalAttribute(_type, "com.sap.security.core.usermanagement", fna);
        }
        Vector umids = principal.getAttributeValues("com.sap.security.core.usermanagement", logAttr);
        if (umids == null || umids.size() == 0) {
            umids = principal.getAttributeValues("com.sap.security.core.usermanagement", "uniquename");
        }
        sb.append(fna).append("=");
        String escapedIDPart = JNDIUtils.escapeBackSlash((String)umids.firstElement());
        escapedIDPart = JNDIUtils.escapeDistinguishedName(escapedIDPart);
        escapedIDPart = JNDIUtils.specialHandlingMSADS(escapedIDPart);
        sb.append(escapedIDPart);
        if (this.mm_principalCreationPaths.get(_type) != null && ((String)this.mm_principalCreationPaths.get(_type)).length() > 0) {
            sb.append(",").append((String)this.mm_principalCreationPaths.get(_type));
        }
        if (this.mm_principalPaths.get(_type) != null && ((String)this.mm_principalPaths.get(_type)).length() > 0) {
            sb.append(",").append((String)this.mm_principalPaths.get(_type));
        }
        if (this.caseSensitive) {
            if (trace.bePath()) {
                trace.exiting("createDistinguishedName", sb.toString());
            }
            return sb.toString();
        }
        if (trace.bePath()) {
            trace.exiting("createDistinguishedName", sb.toString().toLowerCase());
        }
        return sb.toString().toLowerCase();
    }

    public String getPrivateIDPart(IPrincipalDatabag principal) throws PersistenceException {
        String id = null;
        Vector types = principal.getAttributeValues("com.sap.security.core.usermanagement", "PRINCIPAL_TYPE_ATTRIBUTE");
        String _type = (String)types.firstElement();
        ArrayList physUniqueAttrList = (ArrayList)this.mm_principalUniqueAttributes.get(_type);
        if (physUniqueAttrList == null) {
            if (_type.equals("UACC")) {
                if (this.mm_userAsUseraccount) {
                    Vector vals = principal.getAttributeValues("com.sap.security.core.usermanagement", "userid");
                    String userID = (String)vals.firstElement();
                    try {
                        id = this.splitPrincipalDatabagID(userID)[2];
                    }
                    catch (PersistenceException ex) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("Exception when splitting the id ").append(userID);
                        sb.append(" Exception ").append(ex.getMessage());
                        trace.warningT("getPrivateID", sb.toString());
                    }
                    if (this.caseSensitive) {
                        return id;
                    }
                    return id.toLowerCase();
                }
                Vector namAttr = (Vector)this.mm_principalNamingAttributes.get(_type);
                Vector objectclasses = (Vector)this.mm_principalObjectclasses.get(_type);
                String naming = (String)namAttr.firstElement();
                String logAttr = null;
                try {
                    if (objectclasses.size() > 1) {
                        String obj = (String)objectclasses.firstElement();
                        logAttr = this.getLogicalAttribute(_type, "com.sap.security.core.usermanagement", obj + ":" + naming);
                        logAttr = this.getRealPhysicalAttribute(logAttr);
                    } else {
                        logAttr = this.getLogicalAttribute(_type, "com.sap.security.core.usermanagement", naming);
                    }
                }
                catch (PersistenceException pe) {
                    trace.warningT("getPrivateIDPart", "error getting logical attribute for " + naming, (Throwable)((Object)pe));
                }
                String namValue = (String)principal.getAttributeValues("com.sap.security.core.usermanagement", logAttr).firstElement();
                StringBuffer sb = new StringBuffer();
                namValue = JNDIUtils.escapeBackSlash(namValue);
                namValue = JNDIUtils.escapeDistinguishedName(namValue);
                sb.append(naming).append("=").append(JNDIUtils.specialHandlingMSADS(namValue));
                if (this.mm_principalCreationPaths.get(_type) != null && ((String)this.mm_principalCreationPaths.get(_type)).length() > 0) {
                    sb.append(",").append((String)this.mm_principalCreationPaths.get(_type));
                }
                if (this.mm_principalPaths.get(_type) != null && ((String)this.mm_principalPaths.get(_type)).length() > 0) {
                    sb.append(",").append((String)this.mm_principalPaths.get(_type));
                }
                if (this.caseSensitive) {
                    return sb.toString();
                }
                return sb.toString().toLowerCase();
            }
            StringBuffer sb = new StringBuffer();
            Vector namAttr = (Vector)this.mm_principalNamingAttributes.get(_type);
            String fna = (String)namAttr.firstElement();
            Vector objectclasses = (Vector)this.mm_principalObjectclasses.get(_type);
            String logAttr = null;
            if (objectclasses.size() > 1) {
                String obj = (String)objectclasses.firstElement();
                logAttr = this.getLogicalAttribute(_type, "com.sap.security.core.usermanagement", obj + ":" + fna);
                logAttr = this.getRealPhysicalAttribute(logAttr);
            } else {
                logAttr = this.getLogicalAttribute(_type, "com.sap.security.core.usermanagement", fna);
            }
            Vector umids = principal.getAttributeValues("com.sap.security.core.usermanagement", logAttr);
            if (umids == null || umids.size() == 0) {
                umids = principal.getAttributeValues("com.sap.security.core.usermanagement", "uniquename");
            }
            sb.append(fna).append("=");
            String escapedIDPart = JNDIUtils.escapeBackSlash((String)umids.firstElement());
            escapedIDPart = JNDIUtils.escapeDistinguishedName(escapedIDPart);
            escapedIDPart = JNDIUtils.specialHandlingMSADS(escapedIDPart);
            sb.append(escapedIDPart);
            if (this.mm_principalCreationPaths.get(_type) != null && ((String)this.mm_principalCreationPaths.get(_type)).length() > 0) {
                sb.append(",").append((String)this.mm_principalCreationPaths.get(_type));
            }
            if (this.mm_principalPaths.get(_type) != null && ((String)this.mm_principalPaths.get(_type)).length() > 0) {
                sb.append(",").append((String)this.mm_principalPaths.get(_type));
            }
            if (this.caseSensitive) {
                return sb.toString();
            }
            return sb.toString().toLowerCase();
        }
        if (_type.equals("UACC") && this.mm_userAsUseraccount) {
            Vector vals = principal.getAttributeValues("com.sap.security.core.usermanagement", "userid");
            String userID = (String)vals.firstElement();
            try {
                id = this.splitPrincipalDatabagID(userID)[2];
            }
            catch (PersistenceException ex) {
                StringBuffer sb = new StringBuffer();
                sb.append("Exception when splitting the id ").append(userID);
                sb.append(" Exception ").append(ex.getMessage());
                trace.warningT("getPrivateID", sb.toString());
            }
            if (this.caseSensitive) {
                return id;
            }
            return id.toLowerCase();
        }
        String physUniqueAttr = (String)physUniqueAttrList.get(0);
        Vector objectclasses = (Vector)this.mm_principalObjectclasses.get(_type);
        String logAttr = null;
        if (objectclasses.size() > 1) {
            String obj = (String)objectclasses.firstElement();
            logAttr = this.getLogicalAttribute(_type, "com.sap.security.core.usermanagement", obj + ":" + physUniqueAttr);
            logAttr = this.getRealPhysicalAttribute(logAttr);
        } else {
            logAttr = this.getLogicalAttribute(_type, "com.sap.security.core.usermanagement", physUniqueAttr);
        }
        if (logAttr == null) {
            throw new PersistenceException("Unique attribute is configured but during creation no unique attribute is mapped");
        }
        Vector vec = principal.getAttributeValues("com.sap.security.core.usermanagement", logAttr);
        if (vec == null || vec.size() == 0) {
            throw new PersistenceException("Unique attribute is configured but during creation no unique attribute is provided");
        }
        if (this.caseSensitive) {
            return (String)vec.firstElement();
        }
        return ((String)vec.firstElement()).toLowerCase();
    }

    /*
     * Unable to fully structure code
     */
    public boolean checkCredentials(Hashtable credentials) throws PersistenceException {
        block116: {
            block126: {
                mn = "checkCredentials";
                destroyContext = false;
                if (LDAPPersistence.trace.bePath()) {
                    LDAPPersistence.trace.entering("checkCredentials");
                }
                if (this.isInitialized && !this.lazyInitialisation) break block126;
                LDAPPersistence.trace.errorT("checkCredentials", "data source is not initialized");
                if (!this.lazyInitialisation) ** GOTO lbl14
                if (this.reinitializeConnectionManager()) {
                    LDAPPersistence.trace.warningT("checkCredentials", "connection manager initialized");
                } else {
                    LDAPPersistence.trace.errorT("checkCredentials", "data source is not initialized");
                    LDAPPersistence.trace.logErrorT("DataSource {0}: Data source not initialized ", new Object[]{this.getId()});
                    throw new PersistenceException("data source " + this.getId() + " not initialized");
lbl14:
                    // 1 sources

                    LDAPPersistence.trace.errorT("checkCredentials", "data source is not initialized");
                    LDAPPersistence.trace.logErrorT("DataSource {0}: Data source not initialized ", new Object[]{this.getId()});
                    throw new PersistenceException("data source " + this.getId() + " not initialized");
                }
            }
            if ((dsToSearch = (String[])credentials.get("dataSourceIDs")) != null) {
                found = false;
                k = 0;
                s = dsToSearch.length;
                while (k < s && !found) {
                    if (this.getId().equals(dsToSearch[k])) {
                        found = true;
                    }
                    ++k;
                }
                if (!found) {
                    return false;
                }
            }
            userLogin = (String)credentials.get("j_user");
            userPassword = (String)credentials.get("j_password");
            dn = (String)credentials.get("uniqueIDOfPrincipal");
            cert = credentials.get("javax.servlet.request.X509Certificate");
            accountUniAttr = (ArrayList)this.mm_principalUniqueAttributes.get("UACC");
            if (dn != null && accountUniAttr != null) {
                dn = this.getDNfromID(accountUniAttr, this.splitPrincipalDatabagID(dn)[2], "UACC");
            }
            u_pwdLogon = userLogin != null;
            v0 = certLogon = cert != null;
            if (!(this.feelsResponsible("com.sap.security.core.usermanagement", "j_user") && this.feelsResponsible("com.sap.security.core.usermanagement", "j_password") && u_pwdLogon || this.feelsResponsible("com.sap.security.core.usermanagement", "javax.servlet.request.X509Certificate") && certLogon)) {
                try {
                    if (!this.mConfigurationModel.getPrivateAttributeBooleanValue("check_credentials")) {
                        if (LDAPPersistence.trace.bePath()) {
                            LDAPPersistence.trace.exiting("checkCredentials", new Boolean(false));
                        }
                        return false;
                    }
                }
                catch (PersistenceException pex) {
                    LDAPPersistence.trace.warningT("checkCredentials", "Excepiton when checking check credentials with certificate attribute " + pex.getMessage());
                    if (LDAPPersistence.trace.bePath()) {
                        LDAPPersistence.trace.exiting("checkCredentials", new Boolean(false));
                    }
                    return false;
                }
            }
            if (cert != null) {
                if (LDAPPersistence.trace.beInfo()) {
                    LDAPPersistence.trace.infoT("checkCredentials", "user authentication with certification on datasource " + this.getId());
                }
                return this.checkCertificateCredentials(credentials);
            }
            if (userLogin.equalsIgnoreCase("SAP*")) {
                if (LDAPPersistence.trace.beInfo()) {
                    LDAPPersistence.trace.infoT("checkCredentials", "can check credentials of super user");
                }
                return false;
            }
            if (userLogin == null || userLogin.length() == 0) {
                if (LDAPPersistence.trace.beWarning()) {
                    LDAPPersistence.trace.warningT("checkCredentials", "insufficient credential: login id is null");
                }
                return false;
            }
            if (userPassword == null || userPassword.length() == 0) {
                if (LDAPPersistence.trace.beWarning()) {
                    LDAPPersistence.trace.warningT("checkCredentials", "insufficient credentials: password is null");
                }
                return false;
            }
            filter = new StringBuffer();
            userLogin = JNDIUtils.escapeDistinguishedName(userLogin);
            userLogin = JNDIUtils.escForSearchFilter(userLogin);
            objectClassesAndAttributeNames = this.mConfigurationModel.getPrivateAttribute("check_credentials.login_attributes");
            classesAndAttributes = new Vector<String>();
            if (objectClassesAndAttributeNames == null) {
                objectClasses = (Vector)this.mm_principalObjectclasses.get("UACC");
                i = 0;
                while (i < objectClasses.size()) {
                    objectclass = (String)objectClasses.elementAt(i);
                    logonid = this.getPhysicalAttribute("UACC", "com.sap.security.core.usermanagement", objectclass + ":" + "j_user");
                    logonid = this.getRealPhysicalAttribute(logonid);
                    classesAndAttributes.add(objectclass + ":" + logonid);
                    ++i;
                }
            } else {
                strt = new StringTokenizer(objectClassesAndAttributeNames, ",", false);
                while (strt.hasMoreTokens()) {
                    classesAndAttributes.add(strt.nextToken().trim());
                }
            }
            oClasses = new Vector<String>();
            aNames = new Vector<String>();
            clAndAttr = null;
            indexOfColon = -1;
            i = 0;
            while (i < classesAndAttributes.size()) {
                clAndAttr = (String)classesAndAttributes.elementAt(i);
                indexOfColon = clAndAttr.indexOf(":");
                if (indexOfColon != -1) {
                    oClasses.add(clAndAttr.substring(0, indexOfColon));
                    aNames.add(clAndAttr.substring(indexOfColon + 1));
                }
                ++i;
            }
            myDomain = null;
            myLogonID = null;
            if (oClasses.size() > 1) {
                filter.append("(|");
                i = 0;
                while (i < oClasses.size()) {
                    myLogonID = userLogin;
                    logName = (String)aNames.elementAt(i);
                    if (this.mm_multiDomainEnabled && userLogin.indexOf("\\") != -1) {
                        myDomain = userLogin.substring(0, userLogin.indexOf("\\"));
                        myLogonID = userLogin.substring(userLogin.indexOf("\\") + 1, userLogin.length());
                        logName = "domain_j_user";
                    }
                    logName = (String)oClasses.elementAt(i) + ":" + logName;
                    physAttr = this.getPhysicalAttribute("UACC", "com.sap.security.core.usermanagement", logName);
                    physAttr = this.getRealPhysicalAttribute(physAttr);
                    objectclass = (String)oClasses.elementAt(i);
                    filter.append("(&(objectclass=").append(objectclass).append(")");
                    filter.append("(").append(physAttr).append("=").append(myLogonID).append("))");
                    ++i;
                }
            } else {
                myLogonID = userLogin;
                logName = "j_user";
                if (this.mm_multiDomainEnabled && userLogin.indexOf("\\") != -1) {
                    logName = "domain_j_user";
                    myDomain = userLogin.substring(0, userLogin.indexOf("\\"));
                    myLogonID = userLogin.substring(userLogin.indexOf("\\") + 1, userLogin.length());
                }
                physAttr = this.getPhysicalAttribute("UACC", "com.sap.security.core.usermanagement", logName);
                filter.append("(&(objectclass=").append(oClasses.firstElement()).append(")");
                filter.append("(");
                filter.append(physAttr);
                filter.append("=").append(myLogonID).append(")");
            }
            filter.append(")");
            name = null;
            if (dn != null) {
                try {
                    dnParts = this.splitPrincipalDatabagID(dn);
                    if (dnParts[0].equalsIgnoreCase("UACC") && dnParts[1].equalsIgnoreCase(this.getId())) {
                        _tmpID = LDAPPersistence._centralNameParser.parse(dnParts[2]);
                        name = _tmpID.toString();
                    }
                }
                catch (Exception e) {
                    if (!LDAPPersistence.trace.beWarning()) break block116;
                    sb = new StringBuffer();
                    sb.append("Exception when parsing dn ").append(dn).append("; Excepiton: ");
                    sb.append(e.getMessage());
                    LDAPPersistence.trace.warningT("checkCredentials", sb.toString());
                }
            }
        }
        if (name == null) {
            namAttr = (Vector)this.mm_principalNamingAttributes.get("UACC");
            offset = 0;
            if (this.mm_userAsUseraccount) {
                physDescription = this.getPhysicalAttribute("USER", "com.sap.security.core.usermanagement", "description");
                returningAttributes = new String[namAttr.size() + 1];
                returningAttributes[0] = physDescription;
                ++offset;
            } else {
                returningAttributes = new String[namAttr.size()];
            }
            i = 0;
            while (i < namAttr.size()) {
                returningAttributes[i + offset] = (String)namAttr.elementAt(i);
                ++i;
            }
            success = false;
            count = 0;
            while (!success && count < this.mm_action_retrial) {
                block118: {
                    accountCtx = this._manager.getConnection("checkCredentials", "UACC", count);
                    destroyContext = false;
                    sc = new SearchControls();
                    sc.setSearchScope(2);
                    sc.setDerefLinkFlag(false);
                    sc.setReturningAttributes(returningAttributes);
                    sc.setTimeLimit(this.mm_time_limit);
                    searchResults = null;
                    _tmpEntry = (SearchCacheEntry)this.search_cache.get("search." + filter.toString());
                    sr = null;
                    if (_tmpEntry == null) {
                        if (LDAPPersistence.trace.beDebug()) {
                            sb = new StringBuffer();
                            sb.append("ldap access: search with base: and searchfilter: " + filter.toString());
                            LDAPPersistence.trace.debugT("checkCredentials", sb.toString());
                        }
                        time = 0L;
                        if (LDAPPersistence.props.getBoolean("ume.ldap.record_access", false)) {
                            time = System.currentTimeMillis();
                            sb = new StringBuffer();
                            sb.append("checkCredentials(): ldap access at ").append(time);
                            sb.append("\n\twith search(): base: ");
                            sb.append("\n\tsearch filter ").append(filter.toString());
                            LDAPPersistence.aa.print(sb.toString());
                        }
                        searchResults = accountCtx.search("", filter.toString(), sc);
                        if (LDAPPersistence.props.getBoolean("ume.ldap.record_access", false)) {
                            time = System.currentTimeMillis() - time;
                            LDAPPersistence.aa.print("checkCredentials: returning from ldap with search after " + time + " ms");
                        }
                        _sResults = null;
                        if (searchResults.hasMore()) {
                            block117: {
                                _sResults = new Vector<SearchResult>();
                                sr = searchResults.next();
                                _sResults.add(sr);
                                try {
                                    while (searchResults.hasMore()) {
                                        _sResults.add(searchResults.next());
                                    }
                                }
                                catch (PartialResultException ex) {
                                    if (!LDAPPersistence.trace.beInfo()) break block117;
                                    sb = new StringBuffer();
                                    sb.append("Partial result exception when searching with searchfilter ");
                                    sb.append(filter.toString()).append("; Exception: ").append(ex.getMessage());
                                    LDAPPersistence.trace.infoT("checkCredentials", sb.toString());
                                }
                            }
                            this.search_cache.put("search." + filter.toString(), new SearchCacheEntry(_sResults, 0));
                        }
                    } else {
                        _tmpResults = _tmpEntry.getResultsIDs();
                        if (_tmpResults.size() > 0) {
                            sr = (SearchResult)_tmpResults.firstElement();
                        }
                    }
                    if (sr != null) {
                        srName = sr.getName();
                        srName = JNDIUtils.removeQuotes(srName);
                        srName = JNDIUtils.specialHandlingBackMSADS(srName);
                        srName = JNDIUtils.specialHandlingMSADS(srName);
                        path = (String)this.mm_principalPaths.get("UACC");
                        name = path.length() > 0 && srName.length() > 0 ? srName + "," + path : srName;
                        if (!this.checkDomainOfDN(name, myDomain)) {
                            name = null;
                        }
                    }
                    success = true;
                    var40_62 = null;
                    if (searchResults == null) break block118;
                    try {
                        searchResults.close();
                    }
                    catch (NamingException ne) {
                        if (!LDAPPersistence.trace.beInfo()) break block118;
                        LDAPPersistence.trace.infoT("checkCredentials", "exception when closing search result ", ne);
                    }
                }
                this._manager.releaseConnection("UACC", accountCtx, destroyContext);
                {
                    continue;
                    catch (CommunicationException ce) {
                        block119: {
                            if (LDAPPersistence.trace.beInfo()) {
                                LDAPPersistence.trace.infoT("checkCredentials", "CommunicationException: destroying context", ce);
                            }
                            destroyContext = true;
                            if (count == this.mm_action_retrial) {
                                throw new PersistenceException(ce);
                            }
                            var40_62 = null;
                            if (searchResults != null) {
                                try {
                                    searchResults.close();
                                }
                                catch (NamingException ne) {
                                    if (!LDAPPersistence.trace.beInfo()) break block119;
                                    LDAPPersistence.trace.infoT("checkCredentials", "exception when closing search result ", ne);
                                }
                            }
                        }
                        this._manager.releaseConnection("UACC", accountCtx, destroyContext);
                        continue;
                    }
                    catch (NoInitialContextException ce) {
                        block120: {
                            if (LDAPPersistence.trace.beInfo()) {
                                LDAPPersistence.trace.infoT("checkCredentials", "NoInitialContextException: destroying context", ce);
                            }
                            destroyContext = true;
                            if (count == this.mm_action_retrial) {
                                throw new PersistenceException(ce);
                            }
                            var40_62 = null;
                            if (searchResults != null) {
                                try {
                                    searchResults.close();
                                }
                                catch (NamingException ne) {
                                    if (!LDAPPersistence.trace.beInfo()) break block120;
                                    LDAPPersistence.trace.infoT("checkCredentials", "exception when closing search result ", ne);
                                }
                            }
                        }
                        this._manager.releaseConnection("UACC", accountCtx, destroyContext);
                        continue;
                    }
                    catch (PartialResultException ne) {
                        block121: {
                            if (LDAPPersistence.trace.beInfo()) {
                                sb = new StringBuffer();
                                sb.append("Partial result exception when searching with searchfilter ");
                                sb.append(filter.toString()).append("; Exception: ").append(ne.getMessage());
                                LDAPPersistence.trace.infoT("checkCredentials", sb.toString());
                            }
                            var40_62 = null;
                            if (searchResults != null) {
                                try {
                                    searchResults.close();
                                }
                                catch (NamingException ne) {
                                    if (!LDAPPersistence.trace.beInfo()) break block121;
                                    LDAPPersistence.trace.infoT("checkCredentials", "exception when closing search result ", ne);
                                }
                            }
                        }
                        this._manager.releaseConnection("UACC", accountCtx, destroyContext);
                        continue;
                    }
                    catch (NamingException ne) {
                        if (LDAPPersistence.trace.beWarning()) {
                            LDAPPersistence.trace.warningT("checkCredentials", "NamingException: no user account found", ne);
                        }
                        throw new PersistenceException(ne);
                    }
                    catch (Exception e) {
                        if (LDAPPersistence.trace.beWarning()) {
                            LDAPPersistence.trace.warningT("checkCredentials", "some error occurred when checking some credentials", e);
                        }
                        throw new PersistenceException(e);
                    }
                }
                catch (Throwable var39_64) {
                    block122: {
                        var40_62 = null;
                        if (searchResults != null) {
                            try {
                                searchResults.close();
                            }
                            catch (NamingException ne) {
                                if (!LDAPPersistence.trace.beInfo()) break block122;
                                LDAPPersistence.trace.infoT("checkCredentials", "exception when closing search result ", ne);
                            }
                        }
                    }
                    this._manager.releaseConnection("UACC", accountCtx, destroyContext);
                    throw var39_64;
                }
            }
        }
        if (name != null) {
            providerURL = this._manager.getActiveURL("UACC");
            env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", this.mm_socketFactory);
            env.put("java.naming.security.authentication", "simple");
            if (this.mm_serverType.equalsIgnoreCase("MSADS")) {
                env.put("java.naming.security.principal", JNDIUtils.unescapeSlash(name));
            } else {
                env.put("java.naming.security.principal", name);
            }
            env.put("java.naming.security.credentials", userPassword);
            providerURL = JNDIUtils.escapeBlankCharacter(providerURL);
            env.put("java.naming.provider.url", providerURL);
            if (this.mm_sslEnabled) {
                env.put("java.naming.security.protocol", "ssl");
                env.put("java.naming.ldap.factory.socket", this.mm_sslSocketFactory);
                if (LDAPPersistence.trace.beInfo()) {
                    LDAPPersistence.trace.infoT("checkCredentials", "using a ssl connection");
                }
            }
            cl = Thread.currentThread().getContextClassLoader();
            authenticationDone = false;
            authenticated = false;
            i = 0;
            while (i < 2 && !authenticationDone) {
                block124: {
                    ctx = null;
                    try {
                        block123: {
                            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                            if (LDAPPersistence.props.getBoolean("ume.ldap.record_access", false)) {
                                buffer = new StringBuffer();
                                buffer.append("-> trying to bind to ldap in order to check the password of " + env.get("java.naming.security.principal"));
                                LDAPPersistence.aa.print(buffer.toString());
                            }
                            try {
                                ctx = (InitialDirContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                    public Object run() throws NamingException {
                                        return new InitialDirContext(env);
                                    }
                                });
                            }
                            catch (PrivilegedActionException e) {
                                ex = e.getException();
                                if (ex instanceof CommunicationException) {
                                    throw (CommunicationException)ex;
                                }
                                if (ex instanceof AuthenticationException) {
                                    throw (AuthenticationException)ex;
                                }
                                LDAPPersistence.trace.errorT("checkCredentials", "exception when checking credentials ", e);
                                LDAPPersistence.trace.logErrorT("DataSource {0}: Problem when checking credentials for logonid {1}", new Object[]{this.getId(), userLogin});
                                throw (NamingException)ex;
                            }
                            ctx.close();
                            authenticationDone = true;
                            authenticated = true;
                            if (!LDAPPersistence.props.getBoolean("ume.ldap.record_access", false)) break block123;
                            buffer = new StringBuffer();
                            buffer.append("-> bind to ldap successfull for " + env.get("java.naming.security.principal"));
                            LDAPPersistence.aa.print(buffer.toString());
                        }
                        var43_65 = null;
                        Thread.currentThread().setContextClassLoader(cl);
                        ** if (ctx == null) goto lbl-1000
                    }
                    catch (Throwable var42_68) {
                        block125: {
                            var43_65 = null;
                            Thread.currentThread().setContextClassLoader(cl);
                            if (ctx != null) {
                                try {
                                    ctx.close();
                                }
                                catch (NamingException ne) {
                                    if (!LDAPPersistence.trace.beInfo()) break block125;
                                    sb = new StringBuffer();
                                    sb.append("Naming Exception when closing used context to check credentials ");
                                    sb.append("Exception ").append(ne.getMessage());
                                    LDAPPersistence.trace.infoT("checkCredentials", sb.toString());
                                }
                            }
                        }
                        throw var42_68;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            ctx.close();
                        }
                        catch (NamingException ne) {
                            if (LDAPPersistence.trace.beInfo()) {
                                sb = new StringBuffer();
                                sb.append("Naming Exception when closing used context to check credentials ");
                                sb.append("Exception ").append(ne.getMessage());
                                LDAPPersistence.trace.infoT("checkCredentials", sb.toString());
                            }
                        }
                    }
lbl-1000:
                    // 4 sources

                    {
                        break block124;
                        catch (CommunicationException ce) {
                            if (LDAPPersistence.trace.beInfo()) {
                                LDAPPersistence.trace.infoT("checkCredentials", "CommunicationException: can not open context to check credentials: " + ce.getMessage());
                            }
                            var43_65 = null;
                            Thread.currentThread().setContextClassLoader(cl);
                            if (ctx != null) {
                                try {
                                    ctx.close();
                                }
                                catch (NamingException ne) {
                                    if (LDAPPersistence.trace.beInfo()) {
                                        sb = new StringBuffer();
                                        sb.append("Naming Exception when closing used context to check credentials ");
                                        sb.append("Exception ").append(ne.getMessage());
                                        LDAPPersistence.trace.infoT("checkCredentials", sb.toString());
                                    }
                                }
                            }
                            break block124;
                        }
                        catch (AuthenticationException ae) {
                            LDAPPersistence.trace.warningT("checkCredentials", "AuthenticationException using wrong logonid or user passsword", ae);
                            authenticationDone = true;
                            authenticated = false;
                            if (LDAPPersistence.props.getBoolean("ume.ldap.record_access", false)) {
                                buffer = new StringBuffer();
                                buffer.append("-> bind to ldap NOT successfull for " + env.get("java.naming.security.principal"));
                                LDAPPersistence.aa.print(buffer.toString());
                            }
                            var43_65 = null;
                            Thread.currentThread().setContextClassLoader(cl);
                            if (ctx != null) {
                                try {
                                    ctx.close();
                                }
                                catch (NamingException ne) {
                                    if (LDAPPersistence.trace.beInfo()) {
                                        sb = new StringBuffer();
                                        sb.append("Naming Exception when closing used context to check credentials ");
                                        sb.append("Exception ").append(ne.getMessage());
                                        LDAPPersistence.trace.infoT("checkCredentials", sb.toString());
                                    }
                                }
                            }
                            break block124;
                        }
                        catch (NamingException e) {
                            LDAPPersistence.trace.warningT("checkCredentials", "NamingException when checking credentials [" + e.getMessage() + "]", e);
                            authenticationDone = true;
                            authenticated = false;
                            if (LDAPPersistence.props.getBoolean("ume.ldap.record_access", false)) {
                                buffer = new StringBuffer();
                                buffer.append("-> bind to ldap NOT successfull for " + env.get("java.naming.security.principal"));
                                LDAPPersistence.aa.print(buffer.toString());
                            }
                            var43_65 = null;
                            Thread.currentThread().setContextClassLoader(cl);
                            if (ctx != null) {
                                try {
                                    ctx.close();
                                }
                                catch (NamingException ne) {
                                    if (LDAPPersistence.trace.beInfo()) {
                                        sb = new StringBuffer();
                                        sb.append("Naming Exception when closing used context to check credentials ");
                                        sb.append("Exception ").append(ne.getMessage());
                                        LDAPPersistence.trace.infoT("checkCredentials", sb.toString());
                                    }
                                }
                            }
                        }
                    }
                }
                ++i;
            }
            if (LDAPPersistence.trace.beDebug()) {
                LDAPPersistence.trace.debugT("checkCredentials", "check credentials of " + userLogin + " successful = " + authenticated);
            }
            return authenticated;
        }
        if (LDAPPersistence.trace.beDebug()) {
            LDAPPersistence.trace.debugT("checkCredentials", "ckeck credentials of " + userLogin + " not successful");
        }
        return false;
    }

    /*
     * Loose catch block
     */
    protected boolean checkCertificateCredentials(Hashtable credentials) throws PersistenceException {
        boolean check = false;
        String mn = "checkCertificateCredentials";
        Object certificate = credentials.get("javax.servlet.request.X509Certificate");
        X509Certificate cert = (X509Certificate)certificate;
        byte[] certKey = null;
        try {
            certKey = cert.getEncoded();
        }
        catch (Exception e) {
            trace.errorT("checkCertificateCredentials", "Encoding exception while trying to verify the certificate", e);
            trace.logErrorT("DataSource {0}:Encoding exception while trying to verify the certificate", new Object[]{this.getId()});
            return false;
        }
        String base = "";
        SearchControls sc = new SearchControls();
        sc.setReturningAttributes(new String[]{"objectclass"});
        sc.setSearchScope(2);
        sc.setDerefLinkFlag(false);
        sc.setTimeLimit(this.mm_time_limit);
        StringBuffer _ocfilter = new StringBuffer();
        StringBuffer _certFilter = new StringBuffer();
        _ocfilter.append("(|");
        String objectClassesAndAttributeNames = this.mConfigurationModel.getPrivateAttribute("check_credentials.certificate_attribute");
        Vector<String> classesAndAttributes = new Vector<String>();
        if (objectClassesAndAttributeNames == null) {
            Vector objectClasses = (Vector)this.mm_principalObjectclasses.get("UACC");
            if (objectClasses.size() > 1) {
                int i = 0;
                while (i < objectClasses.size()) {
                    String objectclass = (String)objectClasses.elementAt(i);
                    String certalias = this.getPhysicalAttribute("UACC", "com.sap.security.core.usermanagement", objectclass + ":" + "javax.servlet.request.X509Certificate");
                    certalias = this.getRealPhysicalAttribute(certalias);
                    classesAndAttributes.add(objectclass + ":" + certalias);
                    ++i;
                }
            } else {
                String certalias = this.getPhysicalAttribute("UACC", "com.sap.security.core.usermanagement", "javax.servlet.request.X509Certificate");
                classesAndAttributes.add(objectClasses.firstElement() + ":" + certalias);
            }
        } else {
            StringTokenizer strt = new StringTokenizer(objectClassesAndAttributeNames, ",", false);
            while (strt.hasMoreTokens()) {
                classesAndAttributes.add(strt.nextToken().trim());
            }
        }
        Vector<String> oClasses = new Vector<String>();
        Vector<String> aNames = new Vector<String>();
        String clAndAttr = null;
        int indexOfColon = -1;
        int i = 0;
        while (i < classesAndAttributes.size()) {
            clAndAttr = (String)classesAndAttributes.elementAt(i);
            indexOfColon = clAndAttr.indexOf(":");
            if (indexOfColon != -1) {
                oClasses.add(clAndAttr.substring(0, indexOfColon));
                aNames.add(clAndAttr.substring(indexOfColon + 1));
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < oClasses.size()) {
            String objc = (String)oClasses.elementAt(i2);
            _ocfilter.append("(&(objectclass=").append(objc).append(")");
            String mapobjc = "";
            _ocfilter.append("(").append(aNames.elementAt(i2)).append("={0}))");
            ++i2;
        }
        _ocfilter.append(")");
        boolean success = false;
        int count = 0;
        while (!success && count < this.mm_action_retrial) {
            NamingException ne2222;
            Object var30_37;
            NamingEnumeration<SearchResult> results;
            boolean destroyContext;
            InitialDirContext ctx;
            block45: {
                StringBuffer sb;
                ctx = this._manager.getConnection("checkCertificateCredentials", "UACC", ++count);
                destroyContext = false;
                results = null;
                long time = 0L;
                if (trace.beDebug()) {
                    sb = new StringBuffer();
                    sb.append("ldap access: search with base:  and searchfilter: " + _ocfilter.toString());
                    trace.debugT("checkCertificateCredentials", sb.toString());
                }
                if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                    time = System.currentTimeMillis();
                    sb = new StringBuffer();
                    sb.append("checkCertificateCredentials(): ldap access at ").append(time);
                    sb.append("\n\twith search(): base: ").append(base);
                    sb.append("\n\tsearch filter ").append(_ocfilter.toString());
                    aa.print(sb.toString());
                }
                results = ctx.search(base, _ocfilter.toString(), new Object[]{certKey}, sc);
                if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                    time = System.currentTimeMillis() - time;
                    aa.print("checkCertificateCredentials: returning from ldap with search after " + time + " ms");
                }
                if (results.hasMore()) {
                    results.next();
                    check = true;
                    if (results.hasMore()) {
                        check = false;
                    }
                }
                success = true;
                var30_37 = null;
                if (results == null) break block45;
                try {
                    results.close();
                }
                catch (NamingException ne2222) {
                    if (!trace.beInfo()) break block45;
                    trace.infoT("checkCertificateCredentials", "Exception when closing search results " + ne2222.getMessage());
                }
            }
            this._manager.releaseConnection("UACC", ctx, destroyContext);
            {
                continue;
                catch (CommunicationException ce) {
                    block47: {
                        if (trace.beInfo()) {
                            trace.infoT("checkCertificateCredentials", "communication exception when trying to check the certificate : " + ce.getMessage() + " destroying the context");
                        }
                        destroyContext = true;
                        if (count == this.mm_action_retrial) {
                            boolean bl;
                            block46: {
                                bl = false;
                                var30_37 = null;
                                if (results != null) {
                                    try {
                                        results.close();
                                    }
                                    catch (NamingException ne2222) {
                                        if (!trace.beInfo()) break block46;
                                        trace.infoT("checkCertificateCredentials", "Exception when closing search results " + ne2222.getMessage());
                                    }
                                }
                            }
                            this._manager.releaseConnection("UACC", ctx, destroyContext);
                            return bl;
                        }
                        var30_37 = null;
                        if (results != null) {
                            try {
                                results.close();
                            }
                            catch (NamingException ne2222) {
                                if (!trace.beInfo()) break block47;
                                trace.infoT("checkCertificateCredentials", "Exception when closing search results " + ne2222.getMessage());
                            }
                        }
                    }
                    this._manager.releaseConnection("UACC", ctx, destroyContext);
                    continue;
                }
                catch (NoInitialContextException e) {
                    block49: {
                        if (trace.beInfo()) {
                            trace.infoT("checkCertificateCredentials", "no initial context exception when trying to check the certificate : " + e.getMessage() + " destroying the context");
                        }
                        destroyContext = true;
                        if (count == this.mm_action_retrial) {
                            boolean sb;
                            block48: {
                                sb = false;
                                var30_37 = null;
                                if (results != null) {
                                    try {
                                        results.close();
                                    }
                                    catch (NamingException ne2222) {
                                        if (!trace.beInfo()) break block48;
                                        trace.infoT("checkCertificateCredentials", "Exception when closing search results " + ne2222.getMessage());
                                    }
                                }
                            }
                            this._manager.releaseConnection("UACC", ctx, destroyContext);
                            return sb;
                        }
                        var30_37 = null;
                        if (results != null) {
                            try {
                                results.close();
                            }
                            catch (NamingException ne2222) {
                                if (!trace.beInfo()) break block49;
                                trace.infoT("checkCertificateCredentials", "Exception when closing search results " + ne2222.getMessage());
                            }
                        }
                    }
                    this._manager.releaseConnection("UACC", ctx, destroyContext);
                    continue;
                }
                catch (NamingException ne3) {
                    boolean bl;
                    block50: {
                        if (trace.beWarning()) {
                            trace.warningT("checkCertificateCredentials", "Naming exception when trying to check the certificate : ", ne3);
                        }
                        bl = false;
                        var30_37 = null;
                        if (results != null) {
                            try {
                                results.close();
                            }
                            catch (NamingException ne2222) {
                                if (!trace.beInfo()) break block50;
                                trace.infoT("checkCertificateCredentials", "Exception when closing search results " + ne2222.getMessage());
                            }
                        }
                    }
                    this._manager.releaseConnection("UACC", ctx, destroyContext);
                    return bl;
                }
                catch (Exception e) {
                    boolean bl;
                    block51: {
                        trace.errorT("checkCertificateCredentials", "Exception when trying to check the certificate : ", e);
                        trace.logErrorT("DataSource {0}: Problems when checking certificate, no successfull authentication", new Object[]{this.getId()});
                        bl = false;
                        var30_37 = null;
                        if (results != null) {
                            try {
                                results.close();
                            }
                            catch (NamingException ne2222) {
                                if (!trace.beInfo()) break block51;
                                trace.infoT("checkCertificateCredentials", "Exception when closing search results " + ne2222.getMessage());
                            }
                        }
                    }
                    this._manager.releaseConnection("UACC", ctx, destroyContext);
                    return bl;
                }
            }
            catch (Throwable throwable) {
                block52: {
                    var30_37 = null;
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (NamingException ne2222) {
                            if (!trace.beInfo()) break block52;
                            trace.infoT("checkCertificateCredentials", "Exception when closing search results " + ne2222.getMessage());
                        }
                    }
                }
                this._manager.releaseConnection("UACC", ctx, destroyContext);
                throw throwable;
            }
        }
        return check;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getAttributeNamespaces(IPrincipalDatabag principal) throws PersistenceException {
        String uniqueID;
        String mn = "getAttributeNamespaces";
        if (trace.bePath()) {
            trace.entering("getAttributeNamespaces", new Object[]{principal});
        }
        Vector<String> namespaces = null;
        if (!this.isInitialized || this.lazyInitialisation) {
            trace.errorT("getAttributeNamespaces", "data source is not initialized");
            if (!this.lazyInitialisation) {
                trace.logErrorT("DataSource {0}:data source not initialized", new Object[]{this.getId()});
                throw new PersistenceException("data source " + this.getId() + " not initialized");
            }
            if (!this.reinitializeConnectionManager()) {
                trace.logErrorT("DataSource {0}: data source not initialized", new Object[]{this.getId()});
                throw new PersistenceException("data source " + this.getId() + " not initialized");
            }
            trace.warningT("getAttributeNamespaces", "connection manager initialized");
        }
        if ((uniqueID = principal.getUniqueID()) == null) {
            trace.errorT("getAttributeNamespaces", "principal databag is not yet bound to a data source");
            trace.logErrorT("DataSource {0}: unique id is null for {1}", new Object[]{this.getId(), principal});
            throw new PersistenceException("principal databag is not yet bound");
        }
        if (!this.feelsResponsible(principal)) {
            if (trace.beInfo()) {
                trace.infoT("getAttributeNamespaces", "this datasource is not responsible for this principal");
            }
            return null;
        }
        if (!this.principalDatabagExists(principal)) {
            if (trace.beWarning()) {
                trace.warningT("getAttributeNamespaces", "principal " + principal.getUniqueID() + "does not exist on this datasource");
            }
            return null;
        }
        if (this.feelsResponsible((IInternalPrincipalDatabag)principal)) {
            namespaces = new Vector<String>();
            namespaces.add("com.sap.security.core.usermanagement");
            String[] IDParts = principal.getIDParts();
            String orgid = IDParts[2];
            ArrayList uniAttr = (ArrayList)this.mm_principalUniqueAttributes.get(IDParts[0]);
            if (uniAttr != null) {
                orgid = this.getDNfromID(uniAttr, IDParts[2], IDParts[0]);
            }
            if (orgid == null) {
                trace.infoT("getAttributeNamespaces", "can not read attribute namespaces if distinguished name = null of principal " + principal);
                return null;
            }
            String name = null;
            try {
                Name _principalID = _centralNameParser.parse(orgid);
                Name _base = _centralNameParser.parse((String)this.mm_principalPaths.get(IDParts[0]));
                name = JNDIUtils.getRelativeBase(_principalID, _base);
            }
            catch (NamingException e) {
                if (trace.beWarning()) {
                    trace.warningT("getAttributeNamespaces", "naming exception when trying to parse id " + orgid, e);
                }
                return null;
            }
            boolean success = false;
            int count = 0;
            while (!success && count < this.mm_action_retrial) {
                Object var25_31;
                InitialDirContext ctx = this._manager.getConnection("getAttributeNamespaces", IDParts[0], ++count);
                boolean destroyContext = false;
                try {
                    try {
                        Attribute objc;
                        if (trace.beDebug()) {
                            trace.debugT("getAttributeNamespaces", "ldap access for " + principal.getUniqueID());
                        }
                        long time = 0L;
                        if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                            time = System.currentTimeMillis();
                            StringBuffer sb = new StringBuffer();
                            sb.append("getAttributeNames: ldap access at ").append(time);
                            sb.append("\n\twithgetAttributes : base ").append(name);
                            sb.append("\n\treturning all attributes");
                            aa.print(sb.toString());
                        }
                        Attributes _attrs = ctx.getAttributes(name);
                        if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                            time = System.currentTimeMillis() - time;
                            aa.print("getAttributeNames: returning from ldap with getAttributes() after " + time + " ms");
                        }
                        String objectclass = "";
                        if (((Vector)this.mm_principalObjectclasses.get(IDParts[0])).size() > 1 && (objc = _attrs.get("objectclass")) != null) {
                            Vector _objclasses = (Vector)this.mm_principalObjectclasses.get(IDParts[0]);
                            NamingEnumeration<?> values = objc.getAll();
                            while (values.hasMore()) {
                                String value = ((String)values.next()).toLowerCase();
                                if (!_objclasses.contains(value)) continue;
                                if (trace.beInfo()) {
                                    trace.infoT("getAttributeNamespaces", "objectclass " + value + " found for principal " + principal.getUniqueID());
                                }
                                objectclass = value.toLowerCase() + ":";
                                break;
                            }
                        }
                        Vector definedNamespaces = (Vector)this.mm_principalNamespaces.get(IDParts[0]);
                        NamingEnumeration<? extends Attribute> _allAttrs = _attrs.getAll();
                        block12: while (true) {
                            if (!_allAttrs.hasMore()) {
                                success = true;
                                break;
                            }
                            Attribute attr = _allAttrs.next();
                            String physName = attr.getID().toLowerCase();
                            int i = 0;
                            while (true) {
                                if (i >= definedNamespaces.size()) continue block12;
                                String _namespace = (String)definedNamespaces.elementAt(i);
                                String logname = this.getLogicalAttribute(IDParts[0], _namespace, objectclass + physName);
                                if ((logname = this.getRealPhysicalAttribute(logname)) != null && !namespaces.contains(_namespace) && this.feelsResponsible(IDParts[0], _namespace, logname)) {
                                    namespaces.add(_namespace);
                                }
                                ++i;
                            }
                            break;
                        }
                    }
                    catch (PartialResultException e) {
                        if (trace.beInfo()) {
                            trace.infoT("getAttributeNamespaces", "Partial result excepiton because of some unrecognized referrals, Exception: " + e.getMessage());
                        }
                        var25_31 = null;
                        this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                        continue;
                    }
                    catch (CommunicationException ce) {
                        destroyContext = true;
                        if (trace.beInfo()) {
                            trace.infoT("getAttributeNamespaces", "communication exception, destroying corrupt context", ce);
                        }
                        if (count == this.mm_action_retrial) {
                            throw new PersistenceException(ce);
                        }
                        var25_31 = null;
                        this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                        continue;
                    }
                    catch (NoInitialContextException ce) {
                        destroyContext = true;
                        if (trace.beInfo()) {
                            trace.infoT("getAttributeNamespaces", "no initial context exception, destroying corrupt context", ce);
                        }
                        if (count == this.mm_action_retrial) {
                            throw new PersistenceException(ce);
                        }
                        var25_31 = null;
                        this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                        continue;
                    }
                    catch (NamingException e) {
                        trace.errorT("getAttributeNamespaces", "Naming exception when searching for namespaces", e);
                        trace.logErrorT("DataSource {0}: Naming exception when searching for namespaces for principal {1}", new Object[]{this.getId(), principal.getUniqueID()});
                        var25_31 = null;
                        this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                        continue;
                    }
                    catch (Exception e) {
                        trace.errorT("getAttributeNamespaces", "An error has occured when reading namespaces", e);
                        trace.logErrorT("DataSource {0}: Exception when searching for namespaces for principal {1}", new Object[]{this.getId(), principal.getUniqueID()});
                        var25_31 = null;
                        this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                        continue;
                    }
                    var25_31 = null;
                    this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                }
                catch (Throwable throwable) {
                    var25_31 = null;
                    this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                    throw throwable;
                }
            }
        }
        return namespaces;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getAttributeNames(IPrincipalDatabag principal, String nameSpace) throws PersistenceException {
        String mn = "getAttributeNames";
        if (trace.bePath()) {
            trace.entering("getAttributeNames", new Object[]{principal, nameSpace});
        }
        if (!this.feelsResponsible(principal)) {
            if (trace.beInfo()) {
                trace.infoT("getAttributeNames", "this datasource is not responsible for this principal");
            }
            return null;
        }
        if (!this.principalDatabagExists(principal)) {
            trace.warningT("getAttributeNames", "principal " + principal.getUniqueID() + "does not exist on this datasource");
            return null;
        }
        Vector<String> attributeNames = new Vector<String>();
        if (!this.isInitialized || this.lazyInitialisation) {
            trace.errorT("getAttributeNames", "data source is not initialized");
            if (!this.lazyInitialisation) {
                trace.logErrorT("DataSource {0}: Data source not initialized", new Object[]{this.getId()});
                throw new PersistenceException("data source " + this.getId() + " not initialized");
            }
            if (!this.reinitializeConnectionManager()) {
                trace.logErrorT("DataSource {0}: Data source not initialized", new Object[]{this.getId()});
                throw new PersistenceException("data source " + this.getId() + " not initialized");
            }
            trace.warningT("getAttributeNames", "connection manager initialized");
        }
        String uniqueID = principal.getUniqueID();
        String[] IDParts = principal.getIDParts();
        String orgid = IDParts[2];
        ArrayList uniAttr = (ArrayList)this.mm_principalUniqueAttributes.get(IDParts[0]);
        if (uniAttr != null) {
            orgid = this.getDNfromID(uniAttr, IDParts[2], IDParts[0]);
        }
        if (orgid == null) {
            if (trace.beInfo()) {
                trace.infoT("getAttributeNames", "can not read attribute names if distinguished name = null of " + principal);
            }
            return null;
        }
        if (uniqueID == null) {
            trace.errorT("getAttributeNames", "principal databag is not bound to a data source, unique id is null");
            trace.logErrorT("DataSource {0}: unique id is null for principal {1}", new Object[]{this.getId(), principal.getUniqueID()});
            throw new PersistenceException("unique id is null");
        }
        Vector definedNamespaces = (Vector)this.mm_principalNamespaces.get(IDParts[0]);
        if (definedNamespaces == null || !definedNamespaces.contains(nameSpace)) {
            if (trace.beInfo()) {
                trace.infoT("getAttributeNames", "Namespace " + nameSpace + " not defined for this principal type " + IDParts[0]);
            }
            return null;
        }
        if (this.feelsResponsible((IInternalPrincipalDatabag)principal)) {
            String name = null;
            try {
                Name _name = _centralNameParser.parse(orgid);
                Name _path = _centralNameParser.parse((String)this.mm_principalPaths.get(IDParts[0]));
                name = JNDIUtils.getRelativeBase(_name, _path);
            }
            catch (NamingException e) {
                if (trace.beWarning()) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("Naming exception when trying to parse id ").append(orgid).append("; Exception: ");
                    sb.append(e.getMessage());
                    trace.warningT("getAttributeNames", sb.toString());
                }
                return null;
            }
            boolean success = false;
            int count = 0;
            while (!success && count < this.mm_action_retrial) {
                Object var26_33;
                InitialDirContext ctx = this._manager.getConnection("getAttributeNames", IDParts[0], ++count);
                boolean destroyContext = false;
                try {
                    try {
                        if (trace.beDebug()) {
                            trace.debugT("getAttributeNames", "reading all attributes of " + principal.getUniqueID());
                        }
                        long time = 0L;
                        if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                            time = System.currentTimeMillis();
                            StringBuffer sb = new StringBuffer();
                            sb.append("getAttributeNames: ldap access at ").append(time);
                            sb.append("\n\twith getAttributes: base ").append(name);
                            sb.append("\n\treturning all attributes");
                            aa.print(sb.toString());
                        }
                        Attributes _allAttrs = ctx.getAttributes(name);
                        if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                            time = System.currentTimeMillis() - time;
                            aa.print("getAttributeNames: returning from ldap with getAttributes() after " + time + " ms");
                        }
                        NamingEnumeration<? extends Attribute> _attrs = _allAttrs.getAll();
                        while (true) {
                            Attribute objc;
                            if (!_attrs.hasMore()) {
                                success = true;
                                break;
                            }
                            String physName = _attrs.next().getID().toLowerCase();
                            String objectclass = "";
                            if (((Vector)this.mm_principalObjectclasses.get(IDParts[0])).size() > 1 && (objc = _allAttrs.get("objectclass")) != null) {
                                Vector _objclasses = (Vector)this.mm_principalObjectclasses.get(IDParts[0]);
                                NamingEnumeration<?> values = objc.getAll();
                                while (values.hasMore()) {
                                    String value = ((String)values.next()).toLowerCase();
                                    if (!_objclasses.contains(value)) continue;
                                    if (trace.beInfo()) {
                                        trace.infoT("getAttributeNames", "objectclass " + value + " found for principal " + principal.getUniqueID());
                                    }
                                    objectclass = value.toLowerCase() + ":";
                                    break;
                                }
                            }
                            String logname = this.getLogicalAttribute(IDParts[0], nameSpace, objectclass + physName);
                            if (!this.feelsResponsible(principal, nameSpace, logname = this.getRealPhysicalAttribute(logname))) continue;
                            attributeNames.add(logname);
                        }
                    }
                    catch (PartialResultException e) {
                        if (trace.beInfo()) {
                            trace.infoT("getAttributeNames", "partial result exception when reading attribute names,Exception: " + e.getMessage());
                        }
                        var26_33 = null;
                        this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                        continue;
                    }
                    catch (CommunicationException ce) {
                        destroyContext = true;
                        if (trace.beInfo()) {
                            trace.infoT("getAttributeNames", "communication exception, destroying corrupt context", ce);
                        }
                        if (count == this.mm_action_retrial) {
                            throw new PersistenceException(ce);
                        }
                        var26_33 = null;
                        this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                        continue;
                    }
                    catch (NoInitialContextException ce) {
                        destroyContext = true;
                        if (trace.beInfo()) {
                            trace.infoT("getAttributeNames", "no initial context exception, destroying corrupt context", ce);
                        }
                        if (count == this.mm_action_retrial) {
                            throw new PersistenceException(ce);
                        }
                        var26_33 = null;
                        this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                        continue;
                    }
                    catch (NamingException e) {
                        trace.errorT("getAttributeNames", "Naming excepiton when searching for attribute names for a specific namespace", e);
                        trace.logErrorT("DataSource {0}: Naming excepiton when searching for attribute names for a specific namespace", new Object[]{this.getId()});
                        throw new PersistenceException("naming exception when search for some attribute names for a namespace");
                    }
                    catch (Exception e) {
                        trace.errorT("getAttributeNames", "Error occured when searching for attribute names for a specific namespace", e);
                        trace.logErrorT("DataSource {0}: Error occured when searching for attribute names for a specific namespace", new Object[]{this.getId()});
                        throw new PersistenceException("naming exception when search for some attribute names dor a namespace");
                    }
                    var26_33 = null;
                    this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                }
                catch (Throwable throwable) {
                    var26_33 = null;
                    this._manager.releaseConnection(IDParts[0], ctx, destroyContext);
                    throw throwable;
                }
            }
        }
        return attributeNames;
    }

    private String convertDNintoUMEID(String dn, String type) throws PersistenceException {
        StringBuffer sb;
        if (!this.caseSensitive) {
            dn = dn.toLowerCase();
            if (trace.beInfo()) {
                trace.infoT("convertDNintoUMEID", "converting " + dn + " tolowerCase and into ume id");
            }
        } else if (trace.beInfo()) {
            trace.infoT("convertDNintoUMEID", "converting " + dn + " into ume id");
        }
        String userAccountPath = (String)this.mm_principalPaths.get("UACC");
        Vector accountNamingAttributes = (Vector)this.mm_principalNamingAttributes.get("UACC");
        String groupPath = (String)this.mm_principalPaths.get("GRUP");
        Vector groupNamingAttributes = (Vector)this.mm_principalNamingAttributes.get("GRUP");
        String userPath = (String)this.mm_principalPaths.get("USER");
        Vector userNamingAttributes = (Vector)this.mm_principalNamingAttributes.get("USER");
        if ((type == null || "GRUP".equals(type)) && groupNamingAttributes != null && groupPath != null && dn.toLowerCase().endsWith(groupPath.toLowerCase())) {
            sb = new StringBuffer();
            sb.append("GRUP").append(PRINCIPAL_SEPARATOR);
            sb.append(this.getId());
            if ("GRUP".equals(type) && !this.mm_groupCheck || this.checkGroupLocal(dn)) {
                ArrayList uniAttr = (ArrayList)this.mm_principalUniqueAttributes.get("GRUP");
                if (uniAttr == null) {
                    sb.append(PRINCIPAL_SEPARATOR).append(dn);
                } else {
                    String _id = this.getIDFromDN(dn, "GRUP");
                    if (_id == null) {
                        return null;
                    }
                    sb.append(PRINCIPAL_SEPARATOR).append(_id);
                }
                return sb.toString();
            }
        }
        if ((type == null || type.equals("USER")) && userNamingAttributes != null && userPath != null && dn.toLowerCase().endsWith(userPath.toLowerCase())) {
            sb = new StringBuffer();
            sb.append("USER").append(PRINCIPAL_SEPARATOR);
            sb.append(this.getId());
            if (this.checkUserLocal(dn)) {
                ArrayList uniAttr = (ArrayList)this.mm_principalUniqueAttributes.get("USER");
                if (uniAttr == null) {
                    sb.append(PRINCIPAL_SEPARATOR).append(dn);
                } else {
                    String _id = this.getIDFromDN(dn, "USER");
                    if (_id == null) {
                        return null;
                    }
                    sb.append(PRINCIPAL_SEPARATOR).append(_id);
                }
                return sb.toString();
            }
        }
        if ((type == null || type.equals("UACC")) && !this.mm_userAsUseraccount && userAccountPath != null && accountNamingAttributes != null) {
            try {
                if (dn.toLowerCase().endsWith(userAccountPath.toLowerCase())) {
                    sb = new StringBuffer();
                    sb.append("UACC").append(PRINCIPAL_SEPARATOR);
                    sb.append(this.getId());
                    if (this.checkAccountLocal(dn)) {
                        ArrayList uniAttr = (ArrayList)this.mm_principalUniqueAttributes.get("UACC");
                        if (uniAttr == null) {
                            sb.append(PRINCIPAL_SEPARATOR).append(dn);
                        } else {
                            String _id = this.getIDFromDN(dn, "UACC");
                            if (_id == null) {
                                return null;
                            }
                            sb.append(PRINCIPAL_SEPARATOR).append(_id);
                        }
                        return sb.toString();
                    }
                }
            }
            catch (Exception e) {
                trace.errorT("convertDNintoUMEID", "can not convert " + dn + " into a UME id (ignoring); " + e.getMessage());
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void populateDirectParents(IInternalPrincipalDatabag principal) throws PersistenceException {
        block51: {
            block52: {
                mn = "populateDirectParents";
                IDParts = principal.getIDParts();
                orgid = IDParts[2];
                uniAttributes = (ArrayList)this.mm_principalUniqueAttributes.get(IDParts[0]);
                if (uniAttributes != null) {
                    orgid = this.getDNfromID(uniAttributes, IDParts[2], IDParts[0]);
                }
                if (orgid == null) {
                    if (LDAPPersistence.trace.beInfo() == false) return;
                    LDAPPersistence.trace.infoT("populateDirectParents", "can not populate direct parents if distinguished name = null for " + principal.getUniqueID());
                    return;
                }
                foundParents = new Vector();
                if (this.mm_flatUserGroupHierachy != 0) break block52;
                principalID = null;
                try {
                    _principalID = LDAPPersistence._centralNameParser.parse(orgid);
                    principalID = _principalID.toString();
                }
                catch (NamingException e) {
                    if (LDAPPersistence.trace.beWarning() == false) return;
                    sb = new StringBuffer();
                    sb.append("Naming exception when parsing id ").append(orgid);
                    sb.append("; Exception: ").append(e.getMessage());
                    LDAPPersistence.trace.warningT("populateDirectParents", sb.toString());
                    return;
                }
                attributeName = this.getPhysicalAttribute("GRUP", "com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE");
                filterBuffer = new StringBuffer();
                filterBuffer.append("(&(objectclass=");
                objectclasses = (Vector)this.mm_principalObjectclasses.get("GRUP");
                filterBuffer.append((String)objectclasses.firstElement());
                filterBuffer.append(")(");
                filterBuffer.append(attributeName).append("=");
                principalID = JNDIUtils.specialHandlingBackMSADS(principalID);
                filterBuffer.append(principalID).append("))");
                if (LDAPPersistence.trace.beInfo()) {
                    LDAPPersistence.trace.infoT("populateDirectParents", "seachfilter is " + filterBuffer.toString());
                }
                base = "";
                sc = new SearchControls();
                namingAttributes = (Vector)this.mm_principalNamingAttributes.get("GRUP");
                sc.setReturningAttributes(new String[]{(String)namingAttributes.firstElement()});
                sc.setSearchScope(2);
                sc.setDerefLinkFlag(false);
                sc.setCountLimit(this.mm_size_limit);
                sc.setTimeLimit(this.mm_time_limit);
                success = false;
                count = 0;
                while (success == false) {
                    block49: {
                        if (count >= this.mm_action_retrial) {
                            return;
                        }
                        ctx = this._manager.getConnection("populateDirectParents", "GRUP", ++count);
                        destroyContext = false;
                        results = null;
                        try {
                            try {
                                block46: {
                                    time = 0L;
                                    if (LDAPPersistence.props.getBoolean("ume.ldap.record_access", false)) {
                                        time = System.currentTimeMillis();
                                        sb = new StringBuffer();
                                        sb.append("populateDirectParents: ldap access at ").append(time);
                                        sb.append("\n\twith search(): base: ").append(base);
                                        sb.append("\n\tsearchfilter :").append(filterBuffer.toString());
                                        LDAPPersistence.aa.print(sb.toString());
                                    }
                                    results = ctx.search(base, filterBuffer.toString(), sc);
                                    if (LDAPPersistence.props.getBoolean("ume.ldap.record_access", false)) {
                                        time = System.currentTimeMillis() - time;
                                        LDAPPersistence.aa.print("populateDirectParents: returning from ldap with search after " + time + " ms");
                                    }
                                    if (LDAPPersistence.trace.beInfo()) {
                                        LDAPPersistence.trace.infoT("populateDirectParents", "ldap access succesfully, setting existence check to true for principal " + principal.getUniqueID());
                                    }
                                    if (IDParts[1].equals(this.getId())) {
                                        principal.setExists(true);
                                    }
                                    try {
                                        while (results.hasMore()) {
                                            sr = results.next();
                                            resultName = sr.getName();
                                            sb = new StringBuffer(resultName);
                                            sb.append(",").append(this.mm_principalPaths.get("GRUP"));
                                            resultName = sb.toString();
                                            try {
                                                resultName = LDAPPersistence._centralNameParser.parse(resultName).toString();
                                                if (uniAttributes != null) {
                                                    resultName = this.getIDFromDN(resultName, "GRUP");
                                                }
                                                if (resultName == null) continue;
                                                foundParents.add(this.getUMID("GRUP", resultName));
                                            }
                                            catch (NamingException ne) {
                                                if (!LDAPPersistence.trace.beWarning()) continue;
                                                _sb = new StringBuffer();
                                                _sb.append("Naming exception when parsing id ").append(orgid);
                                                _sb.append("; Exception: ").append(ne.getMessage());
                                                LDAPPersistence.trace.warningT("populateDirectParents", _sb.toString());
                                            }
                                        }
                                    }
                                    catch (PartialResultException e) {
                                        if (!LDAPPersistence.trace.beInfo()) break block46;
                                        sb = new StringBuffer();
                                        sb.append("Partial result exception when searching with searchfilter ").append(filterBuffer.toString());
                                        sb.append(", Excepiton: ").append(e.getMessage());
                                        LDAPPersistence.trace.warningT("populateDirectParents", sb.toString());
                                    }
                                }
                                foundParents = this.removeBlockedPrincipals(foundParents);
                                principal.setAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_PARENT_ATTRIBUTE", this.buildUnion(new Vector[]{foundParents, principal.getAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_PARENT_ATTRIBUTE")}));
                                if (LDAPPersistence.trace.beInfo()) {
                                    LDAPPersistence.trace.infoT("populateDirectParents", "direct parents populated for " + principalID + " : " + principal.toString());
                                }
                                success = true;
                            }
                            catch (CommunicationException ce) {
                                block47: {
                                    destroyContext = true;
                                    if (LDAPPersistence.trace.beInfo()) {
                                        LDAPPersistence.trace.infoT("populateDirectParents", "communication exception, destroying corrupt context", ce);
                                    }
                                    if (count == this.mm_action_retrial) {
                                        throw new PersistenceException(ce);
                                    }
                                    var27_42 = null;
                                    if (results != null) {
                                        try {
                                            results.close();
                                        }
                                        catch (NamingException ne) {
                                            if (!LDAPPersistence.trace.beInfo()) break block47;
                                            LDAPPersistence.trace.infoT("populateDirectParents", "Exception when trying to close search result " + ne.getMessage());
                                        }
                                    }
                                }
                                this._manager.releaseConnection("GRUP", ctx, destroyContext);
                                continue;
                            }
                            catch (NoInitialContextException ce) {
                                block48: {
                                    destroyContext = true;
                                    if (LDAPPersistence.trace.beInfo()) {
                                        LDAPPersistence.trace.infoT("populateDirectParents", "no initial context exception, destroying corrupt context", ce);
                                    }
                                    if (count < this.mm_action_retrial) {
                                        throw new PersistenceException(ce);
                                    }
                                    var27_42 = null;
                                    if (results != null) {
                                        ** try [egrp 5[TRYBLOCK] [8 : 1361->1371)] { 
lbl147:
                                        // 1 sources

                                        results.close();
                                        break block48;
lbl149:
                                        // 1 sources

                                        catch (NamingException ne) {
                                            if (!LDAPPersistence.trace.beInfo()) break block48;
                                            LDAPPersistence.trace.infoT("populateDirectParents", "Exception when trying to close search result " + ne.getMessage());
                                        }
                                    }
                                }
                                this._manager.releaseConnection("GRUP", ctx, destroyContext);
                                continue;
                            }
                            catch (NamingException ne) {
                                LDAPPersistence.trace.errorT("populateDirectParents", "Naming exception when searching for direct parents for principal " + principal.getUniqueID(), ne);
                                LDAPPersistence.trace.logErrorT("DataSource {0}: Naming Exception when trying to get the direct parents of {1}", new Object[]{this.getId(), principal});
                                throw new PersistenceException(ne);
                            }
                            catch (Exception e) {
                                LDAPPersistence.trace.errorT("populateDirectParents", "Exception when searching for direct parents for principal " + principal.getUniqueID(), e);
                                LDAPPersistence.trace.logErrorT("DataSource {0}: Exception when trying to get the direct parents of {1}", new Object[]{this.getId(), principal});
                                throw new PersistenceException(e);
                            }
                            var27_42 = null;
                            if (results == null) break block49;
                        }
                        catch (Throwable var26_44) {
                            block50: {
                                var27_42 = null;
                                if (results != null) {
                                    ** try [egrp 5[TRYBLOCK] [8 : 1361->1371)] { 
lbl171:
                                    // 1 sources

                                    results.close();
                                    break block50;
lbl173:
                                    // 1 sources

                                    catch (NamingException ne) {
                                        if (!LDAPPersistence.trace.beInfo()) break block50;
                                        LDAPPersistence.trace.infoT("populateDirectParents", "Exception when trying to close search result " + ne.getMessage());
                                    }
                                }
                            }
                            this._manager.releaseConnection("GRUP", ctx, destroyContext);
                            throw var26_44;
                        }
                        ** try [egrp 5[TRYBLOCK] [8 : 1361->1371)] { 
lbl180:
                        // 1 sources

                        results.close();
                        break block49;
lbl182:
                        // 1 sources

                        catch (NamingException ne) {
                            if (!LDAPPersistence.trace.beInfo()) break block49;
                            LDAPPersistence.trace.infoT("populateDirectParents", "Exception when trying to close search result " + ne.getMessage());
                        }
                    }
                    this._manager.releaseConnection("GRUP", ctx, destroyContext);
                }
                return;
            }
            _principalID = null;
            id = null;
            if (uniAttributes != null) {
                id = this.getDNfromID(uniAttributes, IDParts[2], IDParts[0]);
            }
            if (id == null) {
                if (LDAPPersistence.trace.beWarning() == false) return;
                LDAPPersistence.trace.warningT("populateDirectParents", "can not process dn = null for " + IDParts[2]);
                return;
            }
            try {
                _principalID = LDAPPersistence._centralNameParser.parse(id);
            }
            catch (NamingException ne) {
                if (LDAPPersistence.trace.beWarning() == false) return;
                sb = new StringBuffer();
                sb.append("Naming Exception when parsing dn ").append(id).append(", Exception; ").append(ne.getMessage());
                LDAPPersistence.trace.warningT("populateDirectParents", sb.toString());
                return;
            }
            groupNamingAttributes = (Vector)this.mm_principalNamingAttributes.get("GRUP");
            size = _principalID.size();
            parentfound = false;
            foundParent = null;
            i = 1;
            while (true) {
                if (i > size || parentfound) {
                    if (this._blockedPrincipals.contains(foundParent)) {
                        foundParent = null;
                    }
                    if (foundParent == null) break;
                    foundParent = this.getUMID("GRUP", foundParent);
                    principal.addAttributeValue("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_PARENT_ATTRIBUTE", foundParent);
                    break block51;
                }
                checkName = _principalID.getPrefix(size - i).toString();
                if (this.checkGroupLocal(checkName)) {
                    parentfound = true;
                    if (uniAttributes != null && (checkName = this.getIDFromDN(checkName, "GRUP")) == null) {
                        parentfound = false;
                    }
                    foundParent = checkName;
                }
                ++i;
            }
            principal.setAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_PARENT_ATTRIBUTE", this.buildUnion(new Vector[]{new Vector<E>(), principal.getAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_PARENT_ATTRIBUTE")}));
        }
        if (LDAPPersistence.trace.beInfo() == false) return;
        LDAPPersistence.trace.infoT("populateDirectParents", "direct parents populated for principal " + principal.getUniqueID() + " ; " + principal.toString());
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkAccountLocal(String userID) {
        mn = "checkAccountLocal";
        if (LDAPPersistence.trace.bePath()) {
            LDAPPersistence.trace.entering("checkAccountLocal");
        }
        if ((cacheEntry = this.exist_cache.get(key = "ACCOUNT" + userID + "*localExists")) != null) {
            if (LDAPPersistence.trace.beInfo()) {
                LDAPPersistence.trace.infoT("checkAccountLocal", "user existence entry for " + userID + " found in cache");
            }
            if (((String)cacheEntry).equalsIgnoreCase("true")) {
                return true;
            }
            if (((String)cacheEntry).equalsIgnoreCase("false")) {
                return false;
            }
        }
        userExists = false;
        base = null;
        try {
            _name = LDAPPersistence._centralNameParser.parse(userID);
            _id = LDAPPersistence._centralNameParser.parse((String)this.mm_principalPaths.get("UACC"));
            base = JNDIUtils.getRelativeBase(_name, _id);
        }
        catch (NamingException e) {
            if (LDAPPersistence.trace.beWarning() == false) return false;
            sb = new StringBuffer();
            sb.append("Naming exception when parsing id ").append(userID).append("; Exception: ").append(e.getMessage());
            LDAPPersistence.trace.warningT("checkAccountLocal", sb.toString());
            return false;
        }
        success = false;
        count = 0;
        while (true) {
            if (success || count >= this.mm_action_retrial) {
                this.exist_cache.put(key, "" + userExists);
                if (LDAPPersistence.trace.beInfo() == false) return userExists;
                LDAPPersistence.trace.infoT("checkAccountLocal", "account " + userID + " exists : " + userExists);
                return userExists;
            }
            ++count;
            ctx = null;
            destroyContext = false;
            try {
                ctx = this._manager.getConnection("checkAccountLocal", "UACC", count);
            }
            catch (PersistenceException e) {
                LDAPPersistence.trace.warningT("checkAccountLocal", "time out exception when requesting a new connection ", (Throwable)e);
                return false;
            }
            try {
                returningAttributes = new String[]{"objectclass"};
                time = 0L;
                if (LDAPPersistence.props.getBoolean("ume.ldap.record_access", false)) {
                    time = System.currentTimeMillis();
                    sb = new StringBuffer();
                    sb.append("checkAccountLocal: ldap access at ").append(time);
                    sb.append("\n\twith getAttributes(): base: ").append(base);
                    sb.append("\n\tra : objectclass");
                    LDAPPersistence.aa.print(sb.toString());
                }
                attr = ctx.getAttributes(base, returningAttributes);
                if (LDAPPersistence.props.getBoolean("ume.ldap.record_access", false)) {
                    time = System.currentTimeMillis() - time;
                    LDAPPersistence.aa.print("checkAccountLocal: returning from ldap with getAttributes() after " + time + " ms");
                }
                objClass = attr.get("objectclass");
                allValues = objClass.getAll();
                objectclasses = (Vector)this.mm_principalObjectclasses.get("UACC");
                do {
                    if (allValues.hasMore()) continue;
                    success = true;
                    ** GOTO lbl148
                } while (!objectclasses.contains((oneObjectClass = (String)allValues.next()).toLowerCase()));
                this.exist_cache.put(key, "true");
                if (LDAPPersistence.trace.beInfo()) {
                    LDAPPersistence.trace.infoT("checkAccountLocal", "account " + userID + " exists");
                }
                var19_30 = true;
                var21_28 = null;
                ** GOTO lbl142
            }
            catch (CommunicationException ce) {
                destroyContext = true;
                if (LDAPPersistence.trace.beWarning()) {
                    LDAPPersistence.trace.warningT("checkAccountLocal", "communication exception when checking account " + userID + "; destroying used context", ce);
                }
                var21_28 = null;
                try {
                    this._manager.releaseConnection("UACC", ctx, destroyContext);
                }
                catch (PersistenceException e) {
                    LDAPPersistence.trace.warningT("checkAccountLocal", "persistence exception when trying to release connection Exception " + e.getMessage());
                }
                continue;
            }
            catch (NoInitialContextException ce) {
                destroyContext = true;
                if (LDAPPersistence.trace.beWarning()) {
                    LDAPPersistence.trace.warningT("checkAccountLocal", "no initial context exception when checking account " + userID + "; destroying used context", ce);
                }
                var21_28 = null;
                ** try [egrp 4[TRYBLOCK] [8 : 955->971)] { 
lbl94:
                // 1 sources

                this._manager.releaseConnection("UACC", ctx, destroyContext);
lbl96:
                // 1 sources

                catch (PersistenceException e) {
                    LDAPPersistence.trace.warningT("checkAccountLocal", "persistence exception when trying to release connection Exception " + e.getMessage());
                }
                continue;
            }
            catch (NameNotFoundException ne) {
                if (LDAPPersistence.trace.beWarning()) {
                    LDAPPersistence.trace.warningT("checkAccountLocal", "name not found exception when checking for a account " + userID + ":" + ne.getMessage());
                }
                success = true;
                var21_28 = null;
                ** try [egrp 4[TRYBLOCK] [8 : 955->971)] { 
lbl106:
                // 1 sources

                this._manager.releaseConnection("UACC", ctx, destroyContext);
lbl108:
                // 1 sources

                catch (PersistenceException e) {
                    LDAPPersistence.trace.warningT("checkAccountLocal", "persistence exception when trying to release connection Exception " + e.getMessage());
                }
                continue;
            }
            catch (NamingException ne) {
                if (LDAPPersistence.trace.beWarning()) {
                    LDAPPersistence.trace.warningT("checkAccountLocal", "naming exception when checking for a account " + userID + ":" + ne.getMessage());
                }
                var21_28 = null;
                ** try [egrp 4[TRYBLOCK] [8 : 955->971)] { 
lbl117:
                // 1 sources

                this._manager.releaseConnection("UACC", ctx, destroyContext);
lbl119:
                // 1 sources

                catch (PersistenceException e) {
                    LDAPPersistence.trace.warningT("checkAccountLocal", "persistence exception when trying to release connection Exception " + e.getMessage());
                }
                continue;
            }
            catch (Exception e) {
                if (LDAPPersistence.trace.beWarning()) {
                    LDAPPersistence.trace.warningT("checkAccountLocal", "some exception occured when checking for a account " + userID + ":" + e.getMessage());
                }
                var21_28 = null;
                ** try [egrp 4[TRYBLOCK] [8 : 955->971)] { 
lbl128:
                // 1 sources

                this._manager.releaseConnection("UACC", ctx, destroyContext);
lbl130:
                // 1 sources

                catch (PersistenceException e) {
                    LDAPPersistence.trace.warningT("checkAccountLocal", "persistence exception when trying to release connection Exception " + e.getMessage());
                }
                continue;
            }
            {
                catch (Throwable var20_31) {
                    var21_28 = null;
                    ** try [egrp 4[TRYBLOCK] [8 : 955->971)] { 
lbl137:
                    // 1 sources

                    this._manager.releaseConnection("UACC", ctx, destroyContext);
                    throw var20_31;
lbl139:
                    // 1 sources

                    catch (PersistenceException e) {
                        LDAPPersistence.trace.warningT("checkAccountLocal", "persistence exception when trying to release connection Exception " + e.getMessage());
                    }
                    throw var20_31;
                }
lbl142:
                // 1 sources

                ** try [egrp 4[TRYBLOCK] [8 : 955->971)] { 
lbl143:
                // 1 sources

                this._manager.releaseConnection("UACC", ctx, destroyContext);
                return var19_30;
lbl145:
                // 1 sources

                catch (PersistenceException e) {
                    LDAPPersistence.trace.warningT("checkAccountLocal", "persistence exception when trying to release connection Exception " + e.getMessage());
                }
                return var19_30;
lbl148:
                // 1 sources

                var21_28 = null;
                try {}
                catch (PersistenceException e) {}
                LDAPPersistence.trace.warningT("checkAccountLocal", "persistence exception when trying to release connection Exception " + e.getMessage());
                continue;
                this._manager.releaseConnection("UACC", ctx, destroyContext);
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkUserLocal(String userID) {
        mn = "checkUserLocal";
        LDAPPersistence.trace.entering("checkUserLocal");
        key = "USER" + userID + "*localExists";
        cacheEntry = this.exist_cache.get(key);
        if (cacheEntry != null) {
            if (LDAPPersistence.trace.beInfo()) {
                LDAPPersistence.trace.infoT("checkUserLocal", "user existence entry for " + userID + " found in cache");
            }
            if (((String)cacheEntry).equalsIgnoreCase("true")) {
                return true;
            }
            if (((String)cacheEntry).equalsIgnoreCase("false")) {
                return false;
            }
        }
        userExists = false;
        base = null;
        try {
            _name = LDAPPersistence._centralNameParser.parse(userID);
            _id = LDAPPersistence._centralNameParser.parse((String)this.mm_principalPaths.get("USER"));
            base = JNDIUtils.getRelativeBase(_name, _id);
        }
        catch (NamingException e) {
            if (LDAPPersistence.trace.beWarning() == false) return false;
            sb = new StringBuffer();
            sb.append("Naming exception when parsing id ").append(userID).append("; Exception: ").append(e.getMessage());
            LDAPPersistence.trace.warningT("checkUserLocal", sb.toString());
            return false;
        }
        success = false;
        count = 0;
        while (true) {
            if (success || count >= this.mm_action_retrial) {
                this.exist_cache.put(key, "" + userExists);
                if (LDAPPersistence.trace.beInfo() == false) return userExists;
                LDAPPersistence.trace.infoT("checkUserLocal", "user " + userID + " exists : " + userExists);
                return userExists;
            }
            ++count;
            ctx = null;
            destroyContext = false;
            try {
                ctx = this._manager.getConnection("checkUserLocal", "USER", count);
            }
            catch (PersistenceException e) {
                LDAPPersistence.trace.warningT("checkUserLocal", "time out exception when requesting a new connection ", (Throwable)e);
                return false;
            }
            try {
                returningAttributes = new String[]{"objectclass"};
                filterAttributes = null;
                if (this.mm_userFilter != null) {
                    filterKeys = this.mm_userFilter.keys();
                    filterAttributes = new Vector<Object>();
                    while (true) {
                        if (!filterKeys.hasMoreElements()) {
                            filterAttributes.add("objectclass");
                            returningAttributes = filterAttributes.toArray(new String[0]);
                            filterAttributes.remove("objectclass");
                            break;
                        }
                        filterAttributes.add(filterKeys.nextElement());
                    }
                }
                time = 0L;
                if (LDAPPersistence.props.getBoolean("ume.ldap.record_access", false)) {
                    time = System.currentTimeMillis();
                    sb = new StringBuffer();
                    sb.append("checkUserLocal: ldap access at ").append(time);
                    sb.append("\n\twith getAttributes(): base: ").append(base);
                    sb.append("\n\tra : objectclass");
                    LDAPPersistence.aa.print(sb.toString());
                }
                attr = ctx.getAttributes(base, returningAttributes);
                if (LDAPPersistence.props.getBoolean("ume.ldap.record_access", false)) {
                    time = System.currentTimeMillis() - time;
                    LDAPPersistence.aa.print("checkGroupLocal: returning from ldap with getAttributes() after " + time + " ms");
                }
                objClass = attr.get("objectclass");
                allValues = objClass.getAll();
                objectclasses = (Vector)this.mm_principalObjectclasses.get("USER");
                do {
                    if (allValues.hasMore()) continue;
                    success = true;
                    ** GOTO lbl194
                } while (!objectclasses.contains((oneObjectClass = (String)allValues.next()).toLowerCase()));
                if (this.mm_userFilter != null) {
                    a = 0;
                    while (a < filterAttributes.size()) {
                        attribute = (String)filterAttributes.elementAt(a);
                        chkAttribute = attr.get(attribute);
                        if (chkAttribute != null) {
                            checkValues = chkAttribute.getAll();
                            chkValues = (Vector)this.mm_userFilter.get(attribute);
                            while (checkValues.hasMore()) {
                                valueToCheck = (String)checkValues.next();
                                if (!chkValues.contains(valueToCheck)) continue;
                                if (LDAPPersistence.trace.beDebug()) {
                                    sb = new StringBuffer();
                                    sb.append("Object is filter because of defined user filter ");
                                    sb.append(userID);
                                    LDAPPersistence.trace.debugT("checkUserLocal", sb.toString());
                                }
                                this.exist_cache.put(key, "false");
                                var26_39 = false;
                                var28_30 = null;
                                try {
                                    this._manager.releaseConnection("USER", ctx, destroyContext);
                                    return var26_39;
                                }
                                catch (PersistenceException e) {
                                    LDAPPersistence.trace.warningT("checkUserLocal", "persistence exception when trying to release connection Exception " + e.getMessage());
                                }
                                return var26_39;
                            }
                        }
                        ++a;
                    }
                }
                this.exist_cache.put(key, "true");
                if (LDAPPersistence.trace.beInfo()) {
                    LDAPPersistence.trace.infoT("checkUserLocal", "user " + userID + " exists");
                }
                var20_32 = true;
                ** GOTO lbl187
            }
            catch (CommunicationException ce) {
                destroyContext = true;
                if (LDAPPersistence.trace.beWarning()) {
                    LDAPPersistence.trace.warningT("checkUserLocal", "communication exception when checking user " + userID + "; destroying used context", ce);
                }
                var28_30 = null;
                ** try [egrp 4[TRYBLOCK] [8 : 1214->1230)] { 
lbl127:
                // 1 sources

                this._manager.releaseConnection("USER", ctx, destroyContext);
lbl129:
                // 1 sources

                catch (PersistenceException e) {
                    LDAPPersistence.trace.warningT("checkUserLocal", "persistence exception when trying to release connection Exception " + e.getMessage());
                }
                continue;
            }
            catch (NoInitialContextException ce) {
                destroyContext = true;
                if (LDAPPersistence.trace.beWarning()) {
                    LDAPPersistence.trace.warningT("checkUserLocal", "no initial context exception when checking user " + userID + "; destroying used context", ce);
                }
                var28_30 = null;
                ** try [egrp 4[TRYBLOCK] [8 : 1214->1230)] { 
lbl139:
                // 1 sources

                this._manager.releaseConnection("USER", ctx, destroyContext);
lbl141:
                // 1 sources

                catch (PersistenceException e) {
                    LDAPPersistence.trace.warningT("checkUserLocal", "persistence exception when trying to release connection Exception " + e.getMessage());
                }
                continue;
            }
            catch (NameNotFoundException ne) {
                if (LDAPPersistence.trace.beWarning()) {
                    LDAPPersistence.trace.warningT("checkUserLocal", "name not found exception when checking for a user " + userID + ":" + ne.getMessage());
                }
                success = true;
                var28_30 = null;
                ** try [egrp 4[TRYBLOCK] [8 : 1214->1230)] { 
lbl151:
                // 1 sources

                this._manager.releaseConnection("USER", ctx, destroyContext);
lbl153:
                // 1 sources

                catch (PersistenceException e) {
                    LDAPPersistence.trace.warningT("checkUserLocal", "persistence exception when trying to release connection Exception " + e.getMessage());
                }
                continue;
            }
            catch (NamingException ne) {
                if (LDAPPersistence.trace.beWarning()) {
                    LDAPPersistence.trace.warningT("checkUserLocal", "naming exception when checking for a user " + userID + ":" + ne.getMessage());
                }
                var28_30 = null;
                ** try [egrp 4[TRYBLOCK] [8 : 1214->1230)] { 
lbl162:
                // 1 sources

                this._manager.releaseConnection("USER", ctx, destroyContext);
lbl164:
                // 1 sources

                catch (PersistenceException e) {
                    LDAPPersistence.trace.warningT("checkUserLocal", "persistence exception when trying to release connection Exception " + e.getMessage());
                }
                continue;
            }
            catch (Exception e) {
                if (LDAPPersistence.trace.beWarning()) {
                    LDAPPersistence.trace.warningT("checkUserLocal", "some exception occured when checking for a user " + userID + ":" + e.getMessage());
                }
                var28_30 = null;
                ** try [egrp 4[TRYBLOCK] [8 : 1214->1230)] { 
lbl173:
                // 1 sources

                this._manager.releaseConnection("USER", ctx, destroyContext);
lbl175:
                // 1 sources

                catch (PersistenceException e) {
                    LDAPPersistence.trace.warningT("checkUserLocal", "persistence exception when trying to release connection Exception " + e.getMessage());
                }
                continue;
            }
            {
                catch (Throwable var27_40) {
                    var28_30 = null;
                    ** try [egrp 4[TRYBLOCK] [8 : 1214->1230)] { 
lbl182:
                    // 1 sources

                    this._manager.releaseConnection("USER", ctx, destroyContext);
                    throw var27_40;
lbl184:
                    // 1 sources

                    catch (PersistenceException e) {
                        LDAPPersistence.trace.warningT("checkUserLocal", "persistence exception when trying to release connection Exception " + e.getMessage());
                    }
                    throw var27_40;
                }
lbl187:
                // 1 sources

                var28_30 = null;
                ** try [egrp 4[TRYBLOCK] [8 : 1214->1230)] { 
lbl189:
                // 1 sources

                this._manager.releaseConnection("USER", ctx, destroyContext);
                return var20_32;
lbl191:
                // 1 sources

                catch (PersistenceException e) {
                    LDAPPersistence.trace.warningT("checkUserLocal", "persistence exception when trying to release connection Exception " + e.getMessage());
                }
                return var20_32;
lbl194:
                // 1 sources

                var28_30 = null;
                try {}
                catch (PersistenceException e) {}
                LDAPPersistence.trace.warningT("checkUserLocal", "persistence exception when trying to release connection Exception " + e.getMessage());
                continue;
                this._manager.releaseConnection("USER", ctx, destroyContext);
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkGroupLocal(String groupid) {
        mn = "checkGroupLocal";
        LDAPPersistence.trace.entering("checkGroupLocal");
        key = "GROUP" + groupid + "*localExists";
        cacheEntry = this.exist_cache.get(key);
        if (cacheEntry != null) {
            if (LDAPPersistence.trace.beInfo()) {
                LDAPPersistence.trace.infoT("checkGroupLocal", "group existence entry for " + groupid + " found in cache");
            }
            if (((String)cacheEntry).equalsIgnoreCase("true")) {
                return true;
            }
            if (((String)cacheEntry).equalsIgnoreCase("false")) {
                return false;
            }
        }
        groupExists = false;
        base = null;
        try {
            _name = LDAPPersistence._centralNameParser.parse(groupid);
            _id = LDAPPersistence._centralNameParser.parse((String)this.mm_principalPaths.get("GRUP"));
            base = JNDIUtils.getRelativeBase(_name, _id);
        }
        catch (NamingException e) {
            if (LDAPPersistence.trace.beWarning() == false) return false;
            sb = new StringBuffer();
            sb.append("Naming exception when parsing id ").append(groupid).append("; Exception: ").append(e.getMessage());
            LDAPPersistence.trace.warningT("checkGroupLocal", sb.toString());
            return false;
        }
        success = false;
        count = 0;
        while (true) {
            if (success || count >= this.mm_action_retrial) {
                this.exist_cache.put(key, "" + groupExists);
                if (LDAPPersistence.trace.beInfo() == false) return groupExists;
                LDAPPersistence.trace.infoT("checkGroupLocal", "group " + groupid + " exists " + groupExists);
                return groupExists;
            }
            ++count;
            ctx = null;
            destroyContext = false;
            try {
                ctx = this._manager.getConnection("checkGroupLocal", "GRUP", count);
            }
            catch (PersistenceException e) {
                LDAPPersistence.trace.warningT("checkGroupLocal", "connection time out exception when requesting a new connection " + e.getMessage());
            }
            try {
                returningAttributes = new String[]{"objectclass"};
                time = 0L;
                if (LDAPPersistence.props.getBoolean("ume.ldap.record_access", false)) {
                    time = System.currentTimeMillis();
                    sb = new StringBuffer();
                    sb.append("checkGroupLocal: ldap access at ").append(time);
                    sb.append("\n\twith getAttributes(): base: ").append(base);
                    sb.append("\n\tra : objectclass");
                    LDAPPersistence.aa.print(sb.toString());
                }
                attr = ctx.getAttributes(base, returningAttributes);
                if (LDAPPersistence.props.getBoolean("ume.ldap.record_access", false)) {
                    time = System.currentTimeMillis() - time;
                    LDAPPersistence.aa.print("checkGroupLocal: returning from ldap with getAttributes() after " + time + " ms");
                }
                objClass = attr.get("objectclass");
                allValues = objClass.getAll();
                objectclasses = (Vector)this.mm_principalObjectclasses.get("GRUP");
                do {
                    if (allValues.hasMore()) continue;
                    success = true;
                    ** GOTO lbl156
                } while (!objectclasses.contains((oneObjectClass = (String)allValues.next()).toLowerCase()));
                this.exist_cache.put(key, "true");
                if (LDAPPersistence.trace.beInfo()) {
                    LDAPPersistence.trace.infoT("checkGroupLocal", "group with id " + groupid + " exists");
                }
                var19_30 = true;
                var21_28 = null;
                ** GOTO lbl149
            }
            catch (CommunicationException ce) {
                destroyContext = true;
                if (LDAPPersistence.trace.beWarning()) {
                    LDAPPersistence.trace.warningT("checkGroupLocal", "Communication exception when checking group " + groupid, ce);
                }
                var21_28 = null;
                try {
                    this._manager.releaseConnection("GRUP", ctx, destroyContext);
                }
                catch (PersistenceException e) {
                    if (!LDAPPersistence.trace.beWarning()) continue;
                    LDAPPersistence.trace.warningT("checkGroupLocal", "persistence exception when trying to release connection; Exception " + e.getMessage());
                }
                continue;
            }
            catch (NoInitialContextException ce) {
                destroyContext = true;
                if (LDAPPersistence.trace.beWarning()) {
                    LDAPPersistence.trace.warningT("checkGroupLocal", "no initial context exception when checking group " + groupid, ce);
                }
                var21_28 = null;
                ** try [egrp 4[TRYBLOCK] [8 : 919->935)] { 
lbl95:
                // 1 sources

                this._manager.releaseConnection("GRUP", ctx, destroyContext);
lbl97:
                // 1 sources

                catch (PersistenceException e) {
                    if (!LDAPPersistence.trace.beWarning()) continue;
                    LDAPPersistence.trace.warningT("checkGroupLocal", "persistence exception when trying to release connection; Exception " + e.getMessage());
                }
                continue;
            }
            catch (NameNotFoundException ne) {
                if (LDAPPersistence.trace.beWarning()) {
                    LDAPPersistence.trace.warningT("checkGroupLocal", "name not found exception when checking for a group " + groupid, ne);
                }
                groupExists = false;
                success = true;
                var21_28 = null;
                ** try [egrp 4[TRYBLOCK] [8 : 919->935)] { 
lbl109:
                // 1 sources

                this._manager.releaseConnection("GRUP", ctx, destroyContext);
lbl111:
                // 1 sources

                catch (PersistenceException e) {
                    if (!LDAPPersistence.trace.beWarning()) continue;
                    LDAPPersistence.trace.warningT("checkGroupLocal", "persistence exception when trying to release connection; Exception " + e.getMessage());
                }
                continue;
            }
            catch (NamingException ne) {
                if (LDAPPersistence.trace.beWarning()) {
                    LDAPPersistence.trace.warningT("checkGroupLocal", "naming exception when checking for a group " + groupid, ne);
                }
                var21_28 = null;
                ** try [egrp 4[TRYBLOCK] [8 : 919->935)] { 
lbl121:
                // 1 sources

                this._manager.releaseConnection("GRUP", ctx, destroyContext);
lbl123:
                // 1 sources

                catch (PersistenceException e) {
                    if (!LDAPPersistence.trace.beWarning()) continue;
                    LDAPPersistence.trace.warningT("checkGroupLocal", "persistence exception when trying to release connection; Exception " + e.getMessage());
                }
                continue;
            }
            catch (Exception e) {
                if (LDAPPersistence.trace.beWarning()) {
                    LDAPPersistence.trace.warningT("checkGroupLocal", "some exception occured when checking for a group " + groupid, e);
                }
                var21_28 = null;
                ** try [egrp 4[TRYBLOCK] [8 : 919->935)] { 
lbl133:
                // 1 sources

                this._manager.releaseConnection("GRUP", ctx, destroyContext);
lbl135:
                // 1 sources

                catch (PersistenceException e) {
                    if (!LDAPPersistence.trace.beWarning()) continue;
                    LDAPPersistence.trace.warningT("checkGroupLocal", "persistence exception when trying to release connection; Exception " + e.getMessage());
                }
                continue;
            }
            {
                catch (Throwable var20_31) {
                    var21_28 = null;
                    ** try [egrp 4[TRYBLOCK] [8 : 919->935)] { 
lbl143:
                    // 1 sources

                    this._manager.releaseConnection("GRUP", ctx, destroyContext);
                    throw var20_31;
lbl145:
                    // 1 sources

                    catch (PersistenceException e) {
                        if (LDAPPersistence.trace.beWarning() == false) throw var20_31;
                        LDAPPersistence.trace.warningT("checkGroupLocal", "persistence exception when trying to release connection; Exception " + e.getMessage());
                    }
                    throw var20_31;
                }
lbl149:
                // 1 sources

                ** try [egrp 4[TRYBLOCK] [8 : 919->935)] { 
lbl150:
                // 1 sources

                this._manager.releaseConnection("GRUP", ctx, destroyContext);
                return var19_30;
lbl152:
                // 1 sources

                catch (PersistenceException e) {
                    if (LDAPPersistence.trace.beWarning() == false) return var19_30;
                    LDAPPersistence.trace.warningT("checkGroupLocal", "persistence exception when trying to release connection; Exception " + e.getMessage());
                }
                return var19_30;
lbl156:
                // 1 sources

                var21_28 = null;
                try {}
                catch (PersistenceException e) {}
                if (!LDAPPersistence.trace.beWarning()) continue;
                LDAPPersistence.trace.warningT("checkGroupLocal", "persistence exception when trying to release connection; Exception " + e.getMessage());
                continue;
                this._manager.releaseConnection("GRUP", ctx, destroyContext);
            }
            break;
        }
    }

    private String getUMID(String type, String id) throws PersistenceException {
        StringBuffer sb = new StringBuffer();
        sb.append(type.toUpperCase()).append(PRINCIPAL_SEPARATOR);
        sb.append(this.getId()).append(PRINCIPAL_SEPARATOR);
        if (this.caseSensitive) {
            sb.append(id);
        } else {
            sb.append(id.toLowerCase());
        }
        return sb.toString();
    }

    /*
     * Loose catch block
     */
    private void populateDirectChilds(IInternalPrincipalDatabag principal) throws PersistenceException {
        String mn = "populateDirectChilds";
        if (this.mm_flatUserGroupHierachy != 0) {
            String[] IDParts = principal.getIDParts();
            String orgid = IDParts[2];
            ArrayList uniAttrs = (ArrayList)this.mm_principalUniqueAttributes.get(IDParts[0]);
            if (uniAttrs != null) {
                orgid = this.getDNfromID(uniAttrs, IDParts[2], IDParts[0]);
            }
            if (orgid == null) {
                if (trace.beWarning()) {
                    trace.warningT("populateDirectChilds", "can not populate direct children for dn = null;" + principal.getUniqueID());
                }
                return;
            }
            String base = "";
            Vector foundChilds = new Vector();
            if (IDParts[0].equals("GRUP")) {
                try {
                    String path = (String)this.mm_principalPaths.get("GRUP");
                    Name _principalID = _centralNameParser.parse(orgid);
                    Name _path = _centralNameParser.parse(path);
                    base = JNDIUtils.getRelativeBase(_principalID, _path);
                }
                catch (Exception e) {
                    if (trace.beWarning()) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("Exception when parsing ").append(orgid).append("; Exception: ").append(e.getMessage());
                        trace.warningT("populateDirectChilds", sb.toString());
                    }
                    return;
                }
                SearchControls sc = new SearchControls();
                sc.setSearchScope(1);
                sc.setDerefLinkFlag(false);
                sc.setCountLimit(this.mm_time_limit);
                sc.setTimeLimit(this.mm_time_limit);
                Vector namingAttributes = (Vector)this.mm_principalNamingAttributes.get("USER");
                sc.setReturningAttributes(new String[]{"objectclass"});
                StringBuffer filterBuffer = new StringBuffer();
                filterBuffer.append("(|");
                Vector userObjectclasses = (Vector)this.mm_principalObjectclasses.get("USER");
                int i = 0;
                while (i < userObjectclasses.size()) {
                    filterBuffer.append("(objectclass=");
                    filterBuffer.append((String)userObjectclasses.elementAt(i));
                    filterBuffer.append(")");
                    ++i;
                }
                Vector groupObjectClasses = (Vector)this.mm_principalObjectclasses.get("GRUP");
                i = 0;
                while (i < groupObjectClasses.size()) {
                    filterBuffer.append("(objectclass=");
                    filterBuffer.append((String)groupObjectClasses.elementAt(i));
                    filterBuffer.append(")");
                    ++i;
                }
                filterBuffer.append(")");
                if (trace.beInfo()) {
                    trace.infoT("populateDirectChilds", "calculated searchfilter is :" + filterBuffer.toString());
                }
                boolean success = false;
                int count = 0;
                while (!success && count < this.mm_action_retrial) {
                    NamingException ne2222;
                    Object var31_36;
                    NamingEnumeration<SearchResult> results;
                    boolean destroyContext;
                    InitialDirContext ctx;
                    block59: {
                        StringBuffer sb;
                        ctx = this._manager.getConnection("populateDirectChilds", "GRUP", ++count);
                        destroyContext = false;
                        results = null;
                        long time = 0L;
                        if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                            time = System.currentTimeMillis();
                            sb = new StringBuffer();
                            sb.append("populateDirectChilds: ldap access at ").append(time);
                            sb.append("\n\twith search(): base : ").append(base);
                            sb.append("\n\tsearch filter :").append(filterBuffer.toString());
                            aa.print(sb.toString());
                        }
                        results = ctx.search(base, filterBuffer.toString(), sc);
                        if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                            time = System.currentTimeMillis();
                            aa.print("populateDirectChilds(): returning from ldap with search after " + time + " ms");
                        }
                        if (trace.beInfo()) {
                            trace.infoT("populateDirectChilds", "ldap access succesfully, setting existence check to true for principal " + principal.getUniqueID());
                        }
                        if (IDParts[1].equals(this.getId())) {
                            principal.setExists(true);
                        }
                        while (results.hasMore()) {
                            String _myID;
                            StringBuffer _id;
                            StringBuffer sb2;
                            String _srName;
                            SearchResult sResult = results.next();
                            NamingEnumeration<?> objClValues = sResult.getAttributes().get("objectclass").getAll();
                            boolean userFound = false;
                            boolean groupFound = false;
                            while (objClValues.hasMoreElements() && !userFound && !groupFound) {
                                String objectclassValue = (String)objClValues.nextElement();
                                Vector _userObjectclasses = (Vector)this.mm_principalObjectclasses.get("USER");
                                Vector _groupObjectclasses = (Vector)this.mm_principalObjectclasses.get("GRUP");
                                if (_userObjectclasses.contains(objectclassValue.toLowerCase())) {
                                    userFound = true;
                                    continue;
                                }
                                if (!_groupObjectclasses.contains(objectclassValue.toLowerCase())) continue;
                                groupFound = true;
                            }
                            if (groupFound) {
                                _srName = sResult.getName();
                                _srName = JNDIUtils.removeQuotes(_srName);
                                _srName = JNDIUtils.specialHandlingBackMSADS(_srName);
                                _srName = JNDIUtils.specialHandlingMSADS(_srName);
                                sb2 = new StringBuffer(_srName);
                                if (base.length() > 0) {
                                    sb2.append(",").append(base);
                                }
                                if (((String)this.mm_principalPaths.get("GRUP")).length() > 0) {
                                    sb2.append(",").append((String)this.mm_principalPaths.get("GRUP"));
                                }
                                _id = new StringBuffer();
                                _id.append("GRUP").append(PRINCIPAL_SEPARATOR).append(this.getId());
                                _id.append(PRINCIPAL_SEPARATOR);
                                ArrayList uniAttr = (ArrayList)this.mm_principalUniqueAttributes.get("GRUP");
                                if (uniAttr == null) {
                                    if (this.caseSensitive) {
                                        _id.append(sb2.toString());
                                    } else {
                                        _id.append(sb2.toString().toLowerCase());
                                    }
                                } else {
                                    _myID = this.getIDFromDN(sb2.toString(), "GRUP");
                                    if (_myID == null) {
                                        _id = null;
                                    } else {
                                        _id.append(_myID);
                                    }
                                }
                                if (_id == null) continue;
                                foundChilds.add(_id.toString());
                                continue;
                            }
                            if (!userFound) continue;
                            _srName = sResult.getName();
                            _srName = JNDIUtils.removeQuotes(_srName);
                            _srName = JNDIUtils.specialHandlingBackMSADS(_srName);
                            _srName = JNDIUtils.specialHandlingMSADS(_srName);
                            sb2 = new StringBuffer(_srName);
                            if (base.length() > 0) {
                                sb2.append(",").append(base);
                            }
                            if (((String)this.mm_principalPaths.get("USER")).length() > 0) {
                                sb2.append(",").append((String)this.mm_principalPaths.get("USER"));
                            }
                            _id = new StringBuffer();
                            _id.append("USER").append(PRINCIPAL_SEPARATOR).append(this.getId());
                            _id.append(PRINCIPAL_SEPARATOR);
                            ArrayList _uniAttrs = (ArrayList)this.mm_principalUniqueAttributes.get("USER");
                            if (_uniAttrs == null) {
                                if (this.caseSensitive) {
                                    _id.append(sb2.toString());
                                } else {
                                    _id.append(sb2.toString().toLowerCase());
                                }
                            } else {
                                _myID = this.getIDFromDN(sb2.toString(), "USER");
                                if (_myID == null) {
                                    _id = null;
                                } else {
                                    _id.append(_myID);
                                }
                            }
                            if (_id == null) continue;
                            foundChilds.add(_id.toString());
                        }
                        foundChilds = this.removeBlockedPrincipals(foundChilds);
                        if (trace.beInfo()) {
                            sb = new StringBuffer();
                            if (foundChilds != null) {
                                int j = 0;
                                while (j < foundChilds.size()) {
                                    sb.append(foundChilds.elementAt(j)).append("--");
                                    ++j;
                                }
                                if (trace.beInfo()) {
                                    trace.infoT("populateDirectChilds", "found childs for principal " + principal.getUniqueID() + " : " + sb.toString());
                                }
                            }
                        }
                        principal.setAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", this.buildUnion(new Vector[]{foundChilds, principal.getAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE")}));
                        success = true;
                        var31_36 = null;
                        if (results == null) break block59;
                        try {
                            results.close();
                        }
                        catch (NamingException ne2222) {
                            if (!trace.beInfo()) break block59;
                            trace.infoT("populateDirectChilds", "exception when closing search result " + ne2222.getMessage());
                        }
                    }
                    this._manager.releaseConnection("GRUP", ctx, destroyContext);
                    {
                        continue;
                        catch (CommunicationException ce) {
                            block60: {
                                destroyContext = true;
                                if (trace.beInfo()) {
                                    trace.infoT("populateDirectChilds", "communication exception, destroying corrupt context", ce);
                                }
                                if (count == this.mm_action_retrial) {
                                    throw new PersistenceException(ce);
                                }
                                var31_36 = null;
                                if (results != null) {
                                    try {
                                        results.close();
                                    }
                                    catch (NamingException ne2222) {
                                        if (!trace.beInfo()) break block60;
                                        trace.infoT("populateDirectChilds", "exception when closing search result " + ne2222.getMessage());
                                    }
                                }
                            }
                            this._manager.releaseConnection("GRUP", ctx, destroyContext);
                            continue;
                        }
                        catch (NoInitialContextException ce) {
                            block61: {
                                destroyContext = true;
                                if (trace.beInfo()) {
                                    trace.infoT("populateDirectChilds", "no initial context exception, destroying corrupt context", ce);
                                }
                                if (count == this.mm_action_retrial) {
                                    throw new PersistenceException(ce);
                                }
                                var31_36 = null;
                                if (results != null) {
                                    try {
                                        results.close();
                                    }
                                    catch (NamingException ne2222) {
                                        if (!trace.beInfo()) break block61;
                                        trace.infoT("populateDirectChilds", "exception when closing search result " + ne2222.getMessage());
                                    }
                                }
                            }
                            this._manager.releaseConnection("GRUP", ctx, destroyContext);
                            continue;
                        }
                        catch (NamingException ne3) {
                            trace.errorT("populateDirectChilds", "Naming exception when search for direct childs of principal " + principal.getUniqueID(), ne3);
                            trace.logErrorT("DataSource {0}: Naming exception when search for direct childs of principal {1}", new Object[]{this.getId(), principal.getUniqueID()});
                            throw new PersistenceException(ne3);
                        }
                        catch (Exception e) {
                            trace.errorT("populateDirectChilds", "Exception when search for direct childs of principal " + principal.getUniqueID(), e);
                            trace.logErrorT("DataSource {0}: Naming exception when search for direct childs of principal {1}", new Object[]{this.getId(), principal.getUniqueID()});
                            throw new PersistenceException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        block62: {
                            var31_36 = null;
                            if (results != null) {
                                try {
                                    results.close();
                                }
                                catch (NamingException ne2222) {
                                    if (!trace.beInfo()) break block62;
                                    trace.infoT("populateDirectChilds", "exception when closing search result " + ne2222.getMessage());
                                }
                            }
                        }
                        this._manager.releaseConnection("GRUP", ctx, destroyContext);
                        throw throwable;
                    }
                }
            }
        }
    }

    private String escapeWildCards(String value) {
        StringBuffer sb = new StringBuffer(value);
        int i = 0;
        while (i < sb.length()) {
            if (sb.charAt(i) == '*') {
                sb.insert(i, '\\');
                ++i;
            }
            ++i;
        }
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getObjectclass(String type, String principalID) {
        mn = "getObjectclass";
        if (LDAPPersistence.trace.bePath()) {
            LDAPPersistence.trace.entering("getObjectclass", new Object[]{type, principalID});
        }
        success = false;
        count = 0;
        while (success == false) {
            if (count >= this.mm_action_retrial) {
                return null;
            }
            ++count;
            ctx = null;
            destroyContext = false;
            try {
                block21: {
                    ctx = this._manager.getConnection("getObjectclass", type, count);
                    _name = LDAPPersistence._centralNameParser.parse(principalID);
                    path = (String)this.mm_principalPaths.get(type);
                    _path = LDAPPersistence._centralNameParser.parse(path);
                    base = JNDIUtils.getRelativeBase(_name, _path);
                    returningAttributes = new String[]{"objectclass"};
                    attributes = ctx.getAttributes(base, returningAttributes);
                    objc = attributes.get("objectclass");
                    if (objc == null) break block21;
                    _objclasses = (Vector)this.mm_principalObjectclasses.get(type);
                    values = objc.getAll();
                    while (values.hasMore()) {
                        value = ((String)values.next()).toLowerCase();
                        if (!_objclasses.contains(value)) continue;
                        if (LDAPPersistence.trace.beInfo()) {
                            LDAPPersistence.trace.infoT("getObjectclass", "objectclass " + value + " found for principal " + principalID);
                        }
                        var18_23 = value;
                        var20_21 = null;
                        ** GOTO lbl85
                    }
                }
                success = true;
                ** GOTO lbl92
            }
            catch (CommunicationException e) {
                if (LDAPPersistence.trace.beInfo()) {
                    LDAPPersistence.trace.infoT("getObjectclass", "exception getting objectclass of principalID " + principalID, e);
                }
                destroyContext = true;
                var20_21 = null;
                try {
                    this._manager.releaseConnection(type, ctx, destroyContext);
                }
                catch (PersistenceException e) {
                    if (!LDAPPersistence.trace.beWarning()) continue;
                    LDAPPersistence.trace.warningT("getObjectclass", "persistence exception when trying to release connection: " + e.getMessage());
                }
                continue;
            }
            catch (NoInitialContextException e) {
                if (LDAPPersistence.trace.beInfo()) {
                    LDAPPersistence.trace.infoT("getObjectclass", "exception getting objectclass of principalID " + principalID, e);
                }
                destroyContext = true;
                var20_21 = null;
                ** try [egrp 2[TRYBLOCK] [4 : 460->475)] { 
lbl57:
                // 1 sources

                this._manager.releaseConnection(type, ctx, destroyContext);
lbl59:
                // 1 sources

                catch (PersistenceException e) {
                    if (!LDAPPersistence.trace.beWarning()) continue;
                    LDAPPersistence.trace.warningT("getObjectclass", "persistence exception when trying to release connection: " + e.getMessage());
                }
                continue;
            }
            catch (Exception e) {
                if (LDAPPersistence.trace.beWarning()) {
                    LDAPPersistence.trace.warningT("getObjectclass", "exception getting objectclass of principalID " + principalID, e);
                }
                var20_21 = null;
                ** try [egrp 2[TRYBLOCK] [4 : 460->475)] { 
lbl69:
                // 1 sources

                this._manager.releaseConnection(type, ctx, destroyContext);
lbl71:
                // 1 sources

                catch (PersistenceException e) {
                    if (!LDAPPersistence.trace.beWarning()) continue;
                    LDAPPersistence.trace.warningT("getObjectclass", "persistence exception when trying to release connection: " + e.getMessage());
                }
                continue;
            }
            {
                catch (Throwable var19_24) {
                    var20_21 = null;
                    ** try [egrp 2[TRYBLOCK] [4 : 460->475)] { 
lbl79:
                    // 1 sources

                    this._manager.releaseConnection(type, ctx, destroyContext);
                    throw var19_24;
lbl81:
                    // 1 sources

                    catch (PersistenceException e) {
                        if (LDAPPersistence.trace.beWarning() == false) throw var19_24;
                        LDAPPersistence.trace.warningT("getObjectclass", "persistence exception when trying to release connection: " + e.getMessage());
                    }
                    throw var19_24;
                }
lbl85:
                // 1 sources

                ** try [egrp 2[TRYBLOCK] [4 : 460->475)] { 
lbl86:
                // 1 sources

                this._manager.releaseConnection(type, ctx, destroyContext);
                return var18_23;
lbl88:
                // 1 sources

                catch (PersistenceException e) {
                    if (LDAPPersistence.trace.beWarning() == false) return var18_23;
                    LDAPPersistence.trace.warningT("getObjectclass", "persistence exception when trying to release connection: " + e.getMessage());
                }
                return var18_23;
lbl92:
                // 1 sources

                var20_21 = null;
                try {}
                catch (PersistenceException e) {}
                if (!LDAPPersistence.trace.beWarning()) continue;
                LDAPPersistence.trace.warningT("getObjectclass", "persistence exception when trying to release connection: " + e.getMessage());
                continue;
                this._manager.releaseConnection(type, ctx, destroyContext);
            }
        }
        return null;
    }

    private String getRealPhysicalAttribute(String name) {
        trace.entering("getRealPhysicalAttribute", new Object[]{name});
        if (name.equals(NO_MAPPING)) {
            return name;
        }
        StringTokenizer tokenizer = new StringTokenizer(name, ":");
        if (tokenizer.countTokens() == 2) {
            tokenizer.nextToken();
            return tokenizer.nextToken();
        }
        return name;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Vector searchWithMultipleObjectClasses(SearchCriteria criteria) throws PersistenceException {
        block169: {
            block166: {
                block161: {
                    mn = "searchWithMultipleObjectClasses";
                    if (LDAPPersistence.trace.bePath()) {
                        LDAPPersistence.trace.entering("searchWithMultipleObjectClasses", new Object[]{criteria});
                    }
                    if (this.isInitialized && !this.lazyInitialisation) break block161;
                    LDAPPersistence.trace.errorT("searchWithMultipleObjectClasses", "data source is not initialized");
                    if (!this.lazyInitialisation) ** GOTO lbl12
                    if (this.reinitializeConnectionManager()) {
                        LDAPPersistence.trace.warningT("searchWithMultipleObjectClasses", "connection manager initialized");
                    } else {
                        LDAPPersistence.trace.logErrorT("DataSource {0}: Data source not initialized", new Object[]{this.getId()});
                        throw new PersistenceException("data source " + this.getId() + " not initialized");
lbl12:
                        // 1 sources

                        LDAPPersistence.trace.logErrorT("DataSource {0}: Data source not initialized", new Object[]{this.getId()});
                        throw new PersistenceException("data source " + this.getId() + " not initialized");
                    }
                }
                bArrays = null;
                bCount = -1;
                pleaseSearch = false;
                foundIDs = new Vector();
                foundParentIDs = null;
                accountUserIDs = null;
                groupMemberIDs = null;
                dnBridgeSearchIDs = null;
                myDomain = null;
                type = criteria.getPrincipalType();
                objectclasses = (Vector)this.mm_principalObjectclasses.get(type);
                ccount = criteria.getElementSize();
                _filter = new StringBuffer();
                i = 0;
                while (i < ccount) {
                    block162: {
                        sElement = criteria.getAttribute(i);
                        namespace = sElement.getAttributeNameSpace();
                        aName = sElement.getAttributeName();
                        aValue = sElement.getAttributeValue();
                        op = sElement.getOperator();
                        if (!this.feelsResponsible(type, namespace, aName)) break block162;
                        _filterToAdd = new StringBuffer();
                        j = 0;
                        while (j < objectclasses.size()) {
                            block164: {
                                block163: {
                                    block156: {
                                        block165: {
                                            oc = (String)objectclasses.elementAt(j);
                                            if (LDAPPersistence.trace.beInfo()) {
                                                sb = new StringBuffer();
                                                sb.append("now processing ").append(namespace).append("/").append(aName).append(" for objectclass ");
                                                sb.append(oc);
                                                LDAPPersistence.trace.infoT("searchWithMultipleObjectClasses", sb.toString());
                                            }
                                            physAttribute = this.getPhysicalAttribute(type, namespace, oc + ":" + aName);
                                            physAttribute = this.getRealPhysicalAttribute(physAttribute);
                                            alreadyProcessed = false;
                                            if (aName.equals("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE") && namespace.equals("com.sap.security.core.usermanagement.relation") && type.equals("GRUP")) {
                                                if (LDAPPersistence.trace.beInfo()) {
                                                    LDAPPersistence.trace.infoT("searchWithMultipleObjectClasses", "search for a group with a specific member :" + aValue);
                                                }
                                                if ((member = this.splitPrincipalDatabagID((String)aValue))[1].equals(this.getId())) {
                                                    if (groupMemberIDs == null) {
                                                        groupMemberIDs = new Vector();
                                                    }
                                                    if ((_testobjectclasses = (Vector)this.mm_principalObjectclasses.get(member[0])) != null) {
                                                        testobjc = "";
                                                        if (_testobjectclasses.size() > 1 && !member[0].equalsIgnoreCase("GRUP")) {
                                                            testobjc = this.getObjectclass(member[0], member[2]) + ":";
                                                        }
                                                        parentmemberattribute = new StringBuffer();
                                                        parentmemberattribute.append(oc).append(":").append(testobjc).append("PRINCIPAL_RELATION_PARENT_ATTRIBUTE");
                                                        if (!this.getPhysicalAttribute(member[0], "com.sap.security.core.usermanagement.relation", parentmemberattribute.toString()).equals("*null*") && member[1].equals(this.getId())) {
                                                            alreadyProcessed = true;
                                                            _found = this.readParentsOfPrincipal(member, (String)aValue, type, oc);
                                                            if (_found != null) {
                                                                if (groupMemberIDs == null) {
                                                                    groupMemberIDs = (Vector)_found.clone();
                                                                } else {
                                                                    groupMemberIDs.addAll(_found);
                                                                }
                                                            }
                                                        }
                                                    } else {
                                                        alreadyProcessed = true;
                                                    }
                                                } else {
                                                    alreadyProcessed = true;
                                                    if (LDAPPersistence.trace.beInfo()) {
                                                        LDAPPersistence.trace.infoT("searchWithMultipleObjectClasses", "id " + member[2] + " is not on this datasource " + this.getId());
                                                    }
                                                }
                                            }
                                            if (alreadyProcessed) break block163;
                                            if (!(aValue instanceof String)) break block164;
                                            value = (String)aValue;
                                            if (physAttribute.equals("*null*")) break block165;
                                            switch (op) {
                                                case 0: {
                                                    if (!aName.equals("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE")) ** GOTO lbl102
                                                    iDParts = this.splitPrincipalDatabagID(value);
                                                    if (iDParts[1].equals(this.getId()) && (this.caseSensitive || iDParts[2].equals(iDParts[2].toLowerCase()))) {
                                                        IDParts = this.splitPrincipalDatabagID(value);
                                                        testValue = IDParts[2];
                                                        uniAttr = (ArrayList)this.mm_principalUniqueAttributes.get(IDParts[0]);
                                                        if (uniAttr != null) {
                                                            testValue = this.getDNfromID(uniAttr, testValue, IDParts[0]);
                                                        }
                                                        if (testValue != null) {
                                                            testValue = JNDIUtils.escForSearchFilter(testValue);
                                                            testValue = JNDIUtils.unescapeSlash(testValue);
                                                            testValue = this.escapeWildCards(testValue);
                                                            _filterToAdd.append("(").append(physAttribute).append("=");
                                                            _filterToAdd.append(testValue).append(")");
                                                            break;
                                                        }
                                                    }
                                                    break block164;
lbl102:
                                                    // 1 sources

                                                    if (!this.mm_multiDomainEnabled || !aName.equals("j_user") || value.indexOf("\\") == -1) ** GOTO lbl120
                                                    domain = value.substring(0, value.indexOf("\\"));
                                                    _logonid = value.substring(value.indexOf("\\") + 1, value.length());
                                                    if (this.isDomainAllowed(domain)) {
                                                        _logonid = JNDIUtils.escapeAttributeValue(_logonid);
                                                        _logonid = JNDIUtils.escForSearchFilter(_logonid);
                                                        _logonid = this.escapeWildCards(_logonid);
                                                        changedPhysicalAttribute = this.getPhysicalAttribute("UACC", "com.sap.security.core.usermanagement", "domain_j_user");
                                                        changedPhysicalAttribute = this.getRealPhysicalAttribute(changedPhysicalAttribute);
                                                        _filter.append("(").append(changedPhysicalAttribute).append("=");
                                                        _filter.append(_logonid).append(")");
                                                        if (myDomain == null) {
                                                            myDomain = domain;
                                                        }
                                                        pleaseSearch = true;
                                                        break;
                                                    }
                                                    break block164;
lbl120:
                                                    // 1 sources

                                                    value = JNDIUtils.escapeAttributeValue(value);
                                                    value = JNDIUtils.escForSearchFilter(value);
                                                    value = this.escapeWildCards(value);
                                                    _filterToAdd.append("(").append(physAttribute).append("=");
                                                    _filterToAdd.append(value).append(")");
                                                    break;
                                                }
                                                case 1: {
                                                    _filterToAdd.append("(").append(physAttribute).append("=");
                                                    value = JNDIUtils.escapeAttributeValue(value);
                                                    value = JNDIUtils.escForSearchFilter(value);
                                                    _filterToAdd.append(value).append(")");
                                                    break;
                                                }
                                                case 3: {
                                                    value = JNDIUtils.escapeAttributeValue(value);
                                                    value = JNDIUtils.escForSearchFilter(value);
                                                    _filterToAdd.append("(").append(physAttribute).append("<");
                                                    _filterToAdd.append(value).append(")");
                                                    break;
                                                }
                                                case 2: {
                                                    value = JNDIUtils.escapeAttributeValue(value);
                                                    value = JNDIUtils.escForSearchFilter(value);
                                                    _filterToAdd.append("(").append(physAttribute).append(">");
                                                    _filterToAdd.append(value).append(")");
                                                    break;
                                                }
                                                default: {
                                                    if (LDAPPersistence.trace.beWarning()) {
                                                        LDAPPersistence.trace.warningT("searchWithMultipleObjectClasses", "unsupported search operator (ignoring) " + op);
                                                        break;
                                                    }
                                                    break block164;
                                                }
                                            }
                                            break block164;
                                        }
                                        if (type.equals("UACC") && aName.equals("userid") && this.mm_userAsUseraccount) {
                                            if (accountUserIDs == null) {
                                                accountUserIDs = new Vector<String>();
                                            }
                                            user = (String)sElement.getAttributeValue();
                                            IDParts = this.splitPrincipalDatabagID(user);
                                            uniqueName = IDParts[2];
                                            if (!IDParts[1].equals(this.getId()) || !this.caseSensitive && !uniqueName.equals(uniqueName.toLowerCase())) {
                                                if (LDAPPersistence.trace.beInfo()) {
                                                    LDAPPersistence.trace.infoT("searchWithMultipleObjectClasses", "this user account is not on datasouce " + this.getId() + " or the id is not lower case " + uniqueName);
                                                }
                                            } else {
                                                sb = new StringBuffer();
                                                sb.append("UACC").append(".");
                                                sb.append(IDParts[1]).append(".");
                                                if (this.caseSensitive) {
                                                    sb.append(IDParts[2]);
                                                } else {
                                                    sb.append(IDParts[2].toLowerCase());
                                                }
                                                if (accountUserIDs == null) {
                                                    accountUserIDs = new Vector<E>();
                                                }
                                                if (!accountUserIDs.contains(sb.toString())) {
                                                    accountUserIDs.add(sb.toString());
                                                } else if (LDAPPersistence.trace.beInfo()) {
                                                    LDAPPersistence.trace.infoT("searchWithMultipleObjectClasses", "account already found");
                                                }
                                            }
                                        }
                                        if (aName.equals("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE") && type.equals("GRUP") && this.mm_flatUserGroupHierachy != 0 && op == 0 && (this.caseSensitive || this.splitPrincipalDatabagID(value)[2].equals(this.splitPrincipalDatabagID(value)[2].toLowerCase()))) {
                                            if (foundParentIDs == null) {
                                                foundParentIDs = new Vector<String>();
                                            }
                                            _value /* !! */  = (byte[])value;
                                            _internalDN = this.splitPrincipalDatabagID((String)_value /* !! */ )[2];
                                            _datasourceID = this.splitPrincipalDatabagID((String)_value /* !! */ )[1];
                                            _type = this.splitPrincipalDatabagID((String)_value /* !! */ )[0];
                                            _path = (String)this.mm_principalPaths.get(type);
                                            uniAttr = (ArrayList)this.mm_principalUniqueAttributes.get(_type);
                                            if (uniAttr != null) {
                                                _internalDN = this.getDNfromID(uniAttr, _internalDN, _type);
                                            }
                                            if (_internalDN != null && !_path.equalsIgnoreCase(_internalDN) && _path.length() < _internalDN.length()) {
                                                newDN = null;
                                                DNtoCheck = null;
                                                try {
                                                    newDN = LDAPPersistence._centralNameParser.parse(_internalDN);
                                                    newDN = newDN.getPrefix(newDN.size() - 1);
                                                    DNtoCheck = newDN.toString();
                                                    if (DNtoCheck != null && this.getId().equals(_datasourceID)) {
                                                        while (!this.checkGroupLocal(DNtoCheck) && DNtoCheck.length() > 0) {
                                                            newDN = LDAPPersistence._centralNameParser.parse(DNtoCheck);
                                                            newDN = newDN.getPrefix(newDN.size() - 1);
                                                            DNtoCheck = newDN.toString();
                                                        }
                                                        if (this.checkGroupLocal(DNtoCheck) && DNtoCheck.length() > 0) {
                                                            _groupUniAttr = (ArrayList)this.mm_principalUniqueAttributes.get("GRUP");
                                                            if (_groupUniAttr != null) {
                                                                DNtoCheck = this.getIDFromDN(DNtoCheck, "GRUP");
                                                            }
                                                            if (DNtoCheck != null) {
                                                                foundParentIDs.add(this.getUMID(type, DNtoCheck));
                                                            }
                                                        }
                                                    }
                                                }
                                                catch (Exception e) {
                                                    if (!LDAPPersistence.trace.beWarning()) break block156;
                                                    LDAPPersistence.trace.warningT("searchWithMultipleObjectClasses", "Exception when trying to parse dn " + DNtoCheck + ": " + e.getMessage());
                                                }
                                            }
                                        }
                                    }
                                    if (aName.equals("dn") && namespace.equals("com.sap.security.core.bridge") && type.equals("GRUP")) {
                                        if (dnBridgeSearchIDs == null) {
                                            dnBridgeSearchIDs = new Vector<String>();
                                        }
                                        if (this.checkGroupLocal((String)(_value /* !! */  = (byte[])value))) {
                                            dnBridgeSearchIDs.add(this.getUMID(type, (String)_value /* !! */ ));
                                            ** GOTO lbl255
                                        }
                                    }
                                    break block164;
                                }
                                if (type.equals("UACC") && namespace.equals("com.sap.security.core.usermanagement") && aName.equals("javax.servlet.request.X509Certificate") && !physAttribute.equals("*null*")) {
                                    cert = (X509Certificate)aValue;
                                    try {
                                        _value /* !! */  = cert.getEncoded();
                                        bArrays.add(_value /* !! */ );
                                        _filter.append("(").append(physAttribute).append("=");
                                        _filter.append("{").append(++bCount).append("})");
                                        pleaseSearch = true;
                                    }
                                    catch (CertificateEncodingException e) {
                                        sb = new StringBuffer();
                                        sb.append("error getting byte[] from certificate");
                                        sb.append(", could not search for the useraccount. Exception: ");
                                        sb.append(e.getMessage());
                                        LDAPPersistence.trace.errorT("searchWithMultipleObjectClasses", sb.toString());
                                        LDAPPersistence.trace.logErrorT("DataSource {0}: error getting byte[] from certificate, could not search for the useraccount", new Object[]{this.getId()});
                                    }
                                }
                            }
                            ++j;
                        }
                        if (_filterToAdd.length() > 0) {
                            _filter.append("(|").append(_filterToAdd.toString()).append(")");
                        }
                    }
                    ++i;
                }
                sFilter = new StringBuffer();
                if (_filter.length() > 0) {
                    if ((type.equals("USER") || type.equals("UACC")) && this.mm_userFilter != null) {
                        userfilter = new StringBuffer("(!(|");
                        filterKeys = this.mm_userFilter.keys();
                        while (filterKeys.hasMoreElements()) {
                            key = (String)filterKeys.nextElement();
                            values = (Vector)this.mm_userFilter.get(key);
                            a = 0;
                            while (a < values.size()) {
                                userfilter.append("(").append(key).append("=").append(values.elementAt(a)).append(")");
                                ++a;
                            }
                        }
                        userfilter.append("))");
                        cFilter = _filter.toString();
                        _filter = new StringBuffer();
                        _filter.append("(&").append(cFilter).append(userfilter.toString()).append(")");
                    }
                    ocFilter = new StringBuffer();
                    ocFilter.append("(|");
                    i = 0;
                    while (i < objectclasses.size()) {
                        ocFilter.append("(objectclass=").append(objectclasses.elementAt(i)).append(")");
                        ++i;
                    }
                    ocFilter.append(")");
                    sFilter.append("(&").append((Object)ocFilter);
                    if (criteria.isOrMode()) {
                        sFilter.append("(|").append((Object)_filter).append(")");
                    } else {
                        sFilter.append("(&").append((Object)_filter).append(")");
                    }
                    sFilter.append(")");
                }
                if (sFilter.length() <= 0) break block166;
                pleaseSearch = true;
                if (LDAPPersistence.trace.beInfo()) {
                    sb = new StringBuffer();
                    sb.append("Searching on ").append(this.getId()).append(" with ").append(sFilter.toString());
                    sb.append(" for type ").append(type);
                    LDAPPersistence.trace.infoT("searchWithMultipleObjectClasses", sb.toString());
                }
                retAttr = new Vector<String>();
                if (type.equals("UACC") && this.mm_userAsUseraccount) {
                    i = 0;
                    while (i < objectclasses.size()) {
                        physAttr = this.getPhysicalAttribute("USER", "com.sap.security.core.usermanagement", objectclasses.elementAt(i) + ":" + "description");
                        if (!(physAttr = this.getRealPhysicalAttribute(physAttr)).equals("*null*")) {
                            retAttr.add(physAttr);
                        }
                        ++i;
                    }
                }
                if ((uniAttr = (ArrayList)this.mm_principalUniqueAttributes.get(type)) != null) {
                    size = uniAttr.size();
                    i = 0;
                    while (i < size) {
                        retAttr.add((String)uniAttr.get(i));
                        ++i;
                    }
                }
                retAttr.add("objectclass");
                returningAttributes = new String[retAttr.size()];
                i = 0;
                while (i < retAttr.size()) {
                    returningAttributes[i] = (String)retAttr.elementAt(i);
                    ++i;
                }
                sc = new SearchControls();
                sc.setReturningAttributes(returningAttributes);
                sc.setSearchScope(2);
                sc.setDerefLinkFlag(false);
                criteriaSize = criteria.getSearchSizeLimit();
                if (criteriaSize > 0 && criteriaSize < this.mm_size_limit) {
                    sc.setCountLimit(criteriaSize);
                } else {
                    sc.setCountLimit(this.mm_size_limit);
                }
                sc.setTimeLimit(this.mm_time_limit);
                base = "";
                success = false;
                count = 0;
                while (!success && count < this.mm_action_retrial) {
                    ctx = this._manager.getConnection("doSearch()", type, ++count);
                    destroyContext = false;
                    try {
                        try {
                            block168: {
                                block167: {
                                    block159: {
                                        block157: {
                                            cacheKeyBuffer = new StringBuffer();
                                            cacheKeyBuffer.append("search*").append(type).append("*");
                                            cacheKeyBuffer.append(sFilter.toString());
                                            if (myDomain != null) {
                                                cacheKeyBuffer.append("*").append(myDomain);
                                            }
                                            cachekey = cacheKeyBuffer.toString();
                                            if (LDAPPersistence.trace.beInfo()) {
                                                LDAPPersistence.trace.infoT("searchWithMultipleObjectClasses", "entry for search with key " + cachekey + " searched in cache");
                                            }
                                            entry = null;
                                            if (bCount < 0) {
                                                entry = (SearchCacheEntry)this.search_cache.get(cachekey);
                                            }
                                            if (entry != null) break block167;
                                            if (LDAPPersistence.trace.beInfo()) {
                                                LDAPPersistence.trace.infoT("searchWithMultipleObjectClasses", "search filter is " + sFilter.toString() + " base is " + base);
                                            }
                                            time = 0L;
                                            if (LDAPPersistence.props.getBoolean("ume.ldap.record_access", false)) {
                                                time = System.currentTimeMillis();
                                                sb = new StringBuffer();
                                                sb.append("searchPrincipalDatabag: ldap access at ").append(time);
                                                sb.append("\n\twith search: base:").append(base);
                                                sb.append("\n\tsearchfilter;").append(sFilter.toString());
                                                LDAPPersistence.aa.print(sb.toString());
                                            }
                                            sResults = null;
                                            try {
                                                if (bCount >= 0) {
                                                    bObjects = new Object[bArrays.size()];
                                                    i = 0;
                                                    while (i < bArrays.size()) {
                                                        bObjects[i] = bArrays.elementAt(i);
                                                        ++i;
                                                    }
                                                    sResults = ctx.search(base, sFilter.toString(), bObjects, sc);
                                                } else {
                                                    sResults = ctx.search(base, sFilter.toString(), sc);
                                                }
                                                if (LDAPPersistence.props.getBoolean("ume.ldap.record_access", false)) {
                                                    time = System.currentTimeMillis();
                                                    LDAPPersistence.aa.print("returning from ldap after search " + time + " ms");
                                                }
                                            }
                                            catch (SizeLimitExceededException se) {
                                                criteria.errorOccurred(4);
                                                if (LDAPPersistence.trace.beWarning()) {
                                                    LDAPPersistence.trace.warningT("searchPrinciplaDatabag", "size limit reached when searching with filter " + _filter.toString(), se);
                                                }
                                            }
                                            catch (TimeLimitExceededException te) {
                                                criteria.errorOccurred(8);
                                                if (LDAPPersistence.trace.beWarning()) {
                                                    LDAPPersistence.trace.warningT("searchPrinciplaDatabag", "time limit reached when searching with searchfilter " + _filter.toString(), te);
                                                }
                                            }
                                            catch (PartialResultException pe) {
                                                criteria.errorOccurred(4);
                                                if (!LDAPPersistence.trace.beInfo()) break block157;
                                                sb = new StringBuffer();
                                                sb.append("Partial result exception when searching with filter ");
                                                sb.append(_filter.toString());
                                                sb.append(" Exception: ").append(pe.getMessage());
                                                LDAPPersistence.trace.infoT("searchWithMultipleObjectClasses", sb.toString());
                                            }
                                        }
                                        try {
                                            if (true) ** GOTO lbl484
                                            do {
                                                sr = sResults.next();
                                                sr.setRelative(true);
                                                completeName = null;
                                                srName = sr.getName();
                                                srName = JNDIUtils.removeQuotes(srName);
                                                srName = JNDIUtils.specialHandlingBackMSADS(srName);
                                                srName = JNDIUtils.specialHandlingMSADS(srName);
                                                path = (String)this.mm_principalPaths.get(type);
                                                if (path.length() > 0 && srName.length() > 0) {
                                                    completeName = srName + "," + path;
                                                } else if (path.length() == 0) {
                                                    completeName = srName;
                                                } else if (srName.length() == 0) {
                                                    completeName = path;
                                                }
                                                _objectclass = null;
                                                objectclass = sr.getAttributes().get("objectclass");
                                                if (objectclass != null) {
                                                    allObjectclasses = objectclass.getAll();
                                                    while (allObjectclasses.hasMore()) {
                                                        oneObjectclass = (String)allObjectclasses.next();
                                                        if (!objectclasses.contains(oneObjectclass.toLowerCase())) continue;
                                                        _objectclass = oneObjectclass;
                                                        break;
                                                    }
                                                }
                                                if (type.equals("UACC") && this.mm_userAsUseraccount) {
                                                    physDescription = this.getPhysicalAttribute("USER", "com.sap.security.core.usermanagement", _objectclass + ":" + "description");
                                                    physDescription = this.getRealPhysicalAttribute(physDescription);
                                                    description = sr.getAttributes().get(physDescription);
                                                    if (description != null) {
                                                        allDescriptions = description.getAll();
                                                        while (allDescriptions.hasMore()) {
                                                            if (!((String)allDescriptions.next()).equals("NO_USER_ACCOUNT")) continue;
                                                            completeName = null;
                                                        }
                                                    }
                                                }
                                                if (type.equals("UACC") && this.mm_multiDomainEnabled && this.mm_mappedDomains != null && !this.checkDomainOfDN(completeName, myDomain)) {
                                                    completeName = null;
                                                }
                                                if (_objectclass == null) {
                                                    completeName = null;
                                                }
                                                if (completeName != null && uniAttr != null) {
                                                    uniAttrName = (String)uniAttr.get(objectclasses.indexOf(_objectclass.toLowerCase()));
                                                    uniAttribute = sr.getAttributes().get(uniAttrName);
                                                    if (uniAttribute != null) {
                                                        vals = uniAttribute.getAll();
                                                        if (vals.hasMore()) {
                                                            completeName = (String)vals.next();
                                                            if (!this.caseSensitive) {
                                                                completeName = completeName.toLowerCase();
                                                            }
                                                        } else {
                                                            completeName = null;
                                                        }
                                                    } else {
                                                        completeName = null;
                                                    }
                                                }
                                                if (completeName != null) {
                                                    foundIDs.add(this.getUMID(type, completeName));
                                                }
lbl484:
                                                // 4 sources

                                                if (sResults == null) break;
                                            } while (sResults.hasMore());
                                            var45_70 = null;
                                            ** if (sResults == null) goto lbl-1000
                                        }
                                        catch (Throwable var44_73) {
                                            block160: {
                                                var45_70 = null;
                                                if (sResults != null) {
                                                    try {
                                                        sResults.close();
                                                    }
                                                    catch (NamingException ne) {
                                                        if (!LDAPPersistence.trace.beInfo()) break block160;
                                                        LDAPPersistence.trace.infoT("searchWithMultipleObjectClasses", "Exception when closing search result: " + ne.getMessage());
                                                    }
                                                }
                                            }
                                            throw var44_73;
                                        }
lbl-1000:
                                        // 1 sources

                                        {
                                            try {
                                                sResults.close();
                                            }
                                            catch (NamingException ne) {
                                                if (LDAPPersistence.trace.beInfo()) {
                                                    LDAPPersistence.trace.infoT("searchWithMultipleObjectClasses", "Exception when closing search result: " + ne.getMessage());
                                                }
                                            }
                                        }
lbl-1000:
                                        // 4 sources

                                        {
                                            break block159;
                                            catch (SizeLimitExceededException se) {
                                                criteria.errorOccurred(4);
                                                if (LDAPPersistence.trace.beWarning()) {
                                                    LDAPPersistence.trace.warningT("searchWithMultipleObjectClasses", "size limit reached when searching with filter " + _filter.toString(), se);
                                                }
                                                var45_70 = null;
                                                if (sResults != null) {
                                                    try {
                                                        sResults.close();
                                                    }
                                                    catch (NamingException ne) {
                                                        if (LDAPPersistence.trace.beInfo()) {
                                                            LDAPPersistence.trace.infoT("searchWithMultipleObjectClasses", "Exception when closing search result: " + ne.getMessage());
                                                        }
                                                    }
                                                }
                                                break block159;
                                            }
                                            catch (TimeLimitExceededException te) {
                                                criteria.errorOccurred(8);
                                                if (LDAPPersistence.trace.beWarning()) {
                                                    LDAPPersistence.trace.warningT("searchWithMultipleObjectClasses", "time limit reached when searching with searchfilter " + _filter.toString(), te);
                                                }
                                                var45_70 = null;
                                                if (sResults != null) {
                                                    try {
                                                        sResults.close();
                                                    }
                                                    catch (NamingException ne) {
                                                        if (LDAPPersistence.trace.beInfo()) {
                                                            LDAPPersistence.trace.infoT("searchWithMultipleObjectClasses", "Exception when closing search result: " + ne.getMessage());
                                                        }
                                                    }
                                                }
                                                break block159;
                                            }
                                            catch (PartialResultException pe) {
                                                if (LDAPPersistence.trace.beInfo()) {
                                                    sb = new StringBuffer();
                                                    sb.append("Partial result excepiton when searching with filter ");
                                                    sb.append(_filter.toString());
                                                    sb.append(" Exception: ").append(pe.getMessage());
                                                    LDAPPersistence.trace.infoT("searchWithMultipleObjectClasses", sb.toString());
                                                }
                                                var45_70 = null;
                                                if (sResults != null) {
                                                    try {
                                                        sResults.close();
                                                    }
                                                    catch (NamingException ne) {
                                                        if (LDAPPersistence.trace.beInfo()) {
                                                            LDAPPersistence.trace.infoT("searchWithMultipleObjectClasses", "Exception when closing search result: " + ne.getMessage());
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    this.search_cache.put(cachekey, new SearchCacheEntry(foundIDs, criteria.getSearchStatus()));
                                    break block168;
                                }
                                foundIDs = entry.getResultsIDs();
                                criteria.errorOccurred(entry.getFlag());
                            }
                            success = true;
                        }
                        catch (CommunicationException ce) {
                            destroyContext = true;
                            if (LDAPPersistence.trace.beInfo()) {
                                LDAPPersistence.trace.infoT("searchWithMultipleObjectClasses", "communication exception, destroying corrupt context", ce);
                            }
                            if (count == this.mm_action_retrial) {
                                throw new PersistenceException(ce);
                            }
                            var48_72 = null;
                            this._manager.releaseConnection(type, ctx, destroyContext);
                            continue;
                        }
                        catch (NoInitialContextException ce) {
                            destroyContext = true;
                            if (LDAPPersistence.trace.beInfo()) {
                                LDAPPersistence.trace.infoT("searchWithMultipleObjectClasses", "no initial context exception, destroying corrupt context", ce);
                            }
                            if (count == this.mm_action_retrial) {
                                throw new PersistenceException(ce);
                            }
                            var48_72 = null;
                            this._manager.releaseConnection(type, ctx, destroyContext);
                            continue;
                        }
                        catch (NamingException e) {
                            LDAPPersistence.trace.errorT("searchWithMultipleObjectClasses", "Naming exception when searching for a principal ", e);
                            LDAPPersistence.trace.logErrorT("DataSource {0}: Naming exception when searching with filter {1}", new Object[]{this.getId(), _filter.toString()});
                            throw new PersistenceException(e);
                        }
                        catch (Exception e) {
                            LDAPPersistence.trace.errorT("searchWithMultipleObjectClasses", "Exception occured when searching for a principal ", e);
                            LDAPPersistence.trace.logErrorT("DataSource {0}: Exception when searching with filter {1}", new Object[]{this.getId(), _filter.toString()});
                            throw new PersistenceException(e);
                        }
                        var48_72 = null;
                        this._manager.releaseConnection(type, ctx, destroyContext);
                    }
                    catch (Throwable var47_74) {
                        var48_72 = null;
                        this._manager.releaseConnection(type, ctx, destroyContext);
                        throw var47_74;
                    }
                }
                break block169;
            }
            if (LDAPPersistence.trace.beInfo()) {
                LDAPPersistence.trace.infoT("searchWithMultipleObjectClasses", "no search done on ldap server, as no criteria is matching");
            }
        }
        if (groupMemberIDs != null) {
            foundIDs = this.mixupResults(foundIDs, groupMemberIDs, true, pleaseSearch);
        }
        if (foundParentIDs != null) {
            foundIDs = this.mixupResults(foundIDs, foundParentIDs, true, pleaseSearch);
        }
        if (accountUserIDs != null) {
            foundIDs = this.mixupResults(foundIDs, accountUserIDs, true, pleaseSearch);
        }
        if (dnBridgeSearchIDs != null) {
            foundIDs = this.mixupResults(foundIDs, dnBridgeSearchIDs, true, pleaseSearch);
        }
        if (!pleaseSearch && groupMemberIDs == null && foundParentIDs == null && accountUserIDs == null && dnBridgeSearchIDs == null) {
            foundIDs = null;
        }
        if (foundIDs != null && LDAPPersistence.trace.beInfo()) {
            sb = new StringBuffer();
            i = 0;
            while (i < foundIDs.size()) {
                sb.append(foundIDs.elementAt(i) + " -- ");
                ++i;
            }
            LDAPPersistence.trace.infoT("searchWithMultipleObjectClasses", "search results for " + criteria.toString() + " results : " + sb.toString());
        }
        if (foundIDs != null) {
            this.putResultsIntoCache(foundIDs);
        }
        return foundIDs;
    }

    private String getIDFromDN(String distinguishedName, String type) throws PersistenceException {
        String mn = "getIDFromDN";
        if (trace.beInfo()) {
            trace.infoT("getIDFromDN", "trying to convert dn " + distinguishedName + " into the id");
        }
        String id = null;
        int count = 0;
        boolean success = false;
        ArrayList uniqueAttribute = (ArrayList)this.mm_principalUniqueAttributes.get(type);
        String[] returningAttributes = new String[uniqueAttribute.size()];
        int i = 0;
        while (i < uniqueAttribute.size()) {
            returningAttributes[i] = (String)uniqueAttribute.get(i);
            ++i;
        }
        if (uniqueAttribute != null && uniqueAttribute.size() > 0) {
            StringBuffer cacheKey = new StringBuffer();
            if (type.equals("USER") && this.mm_userAsUseraccount) {
                cacheKey.append("getIDFromDN").append("_").append("UACC").append("_").append(distinguishedName);
            } else {
                cacheKey.append("getIDFromDN").append("_").append(type).append("_").append(distinguishedName);
            }
            String dn = (String)this.search_cache.get(cacheKey.toString().toLowerCase());
            if (dn == null) {
                String _name;
                block30: {
                    _name = null;
                    try {
                        Name name = _centralNameParser.parse(distinguishedName);
                        Name base = _centralNameParser.parse((String)this.mm_principalPaths.get(type));
                        _name = JNDIUtils.getRelativeBase(name, base);
                    }
                    catch (NamingException e) {
                        if (!trace.beWarning()) break block30;
                        StringBuffer sb = new StringBuffer();
                        sb.append("Exception while parsing ").append(distinguishedName);
                        sb.append(" Exception: ").append(e.getMessage());
                        trace.warningT("getIDFromDN", sb.toString());
                    }
                }
                while (!success && count < this.mm_action_retrial) {
                    Object var22_28;
                    InitialDirContext ctx = this._manager.getConnection("getIDFromDN", type, ++count);
                    boolean destroyContext = false;
                    try {
                        try {
                            Attribute ua;
                            NamingEnumeration<?> allValues;
                            NamingEnumeration<? extends Attribute> allAttr;
                            if (trace.beInfo()) {
                                StringBuffer sb = new StringBuffer();
                                sb.append("returning attributes : ");
                                int j = 0;
                                while (j < returningAttributes.length) {
                                    sb.append(returningAttributes[j]).append(" -- ");
                                    ++j;
                                }
                                trace.infoT("getIDFromDN", "accessing directory server with getAttributes :" + sb.toString());
                            }
                            long time = 0L;
                            if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                                time = System.currentTimeMillis();
                                StringBuffer sb = new StringBuffer();
                                sb.append("getIDFromDN: ldap access with getAttributes at ").append(time);
                                sb.append("\n\twith search at base ").append(_name);
                                sb.append("\n\twith returningAttributes ").append(returningAttributes.toString());
                                aa.print(sb.toString());
                            }
                            Attributes uniqueAttrs = ctx.getAttributes(_name, returningAttributes);
                            if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                                time = System.currentTimeMillis() - time;
                                aa.print("getIDFromDN: returning from ldap after " + time + " ms");
                            }
                            if (uniqueAttrs != null && (allAttr = uniqueAttrs.getAll()).hasMore() && (allValues = (ua = allAttr.next()).getAll()).hasMore()) {
                                id = (String)allValues.next();
                            }
                            this.search_cache.put(cacheKey.toString().toLowerCase(), id);
                            success = true;
                        }
                        catch (CommunicationException e) {
                            if (trace.beInfo()) {
                                trace.infoT("getIDFromDN", "communiaction exception: destroying used context ", e);
                            }
                            destroyContext = true;
                            if (count == this.mm_action_retrial) {
                                throw new PersistenceException(e);
                            }
                            var22_28 = null;
                            this._manager.releaseConnection(type, ctx, destroyContext);
                            continue;
                        }
                        catch (NoInitialContextException e) {
                            if (trace.beInfo()) {
                                trace.infoT("getIDFromDN", "no initial context exception: destroying used context ", e);
                            }
                            destroyContext = true;
                            if (count == this.mm_action_retrial) {
                                throw new PersistenceException(e);
                            }
                            var22_28 = null;
                            this._manager.releaseConnection(type, ctx, destroyContext);
                            continue;
                        }
                        catch (NamingException e) {
                            trace.errorT("getIDFromDN", "Naming exception when trying to get uinqueid for dn " + distinguishedName, e);
                            trace.logErrorT("DataSource {0}: Naming exception when trying to get uinqueid for dn " + distinguishedName, new Object[]{this.getId()});
                            throw new PersistenceException(e);
                        }
                        catch (Exception e) {
                            trace.errorT("getIDFromDN", "Exception when trying to get unique id for dn " + distinguishedName, e);
                            trace.logErrorT("DataSource {0}: Exception when trying to get unique id for dn " + distinguishedName, new Object[]{this.getId()});
                            throw new PersistenceException(e);
                        }
                        var22_28 = null;
                        this._manager.releaseConnection(type, ctx, destroyContext);
                    }
                    catch (Throwable throwable) {
                        var22_28 = null;
                        this._manager.releaseConnection(type, ctx, destroyContext);
                        throw throwable;
                    }
                }
            } else {
                if (trace.beInfo()) {
                    trace.infoT("getIDFromDN", "found id for distinguished name " + distinguishedName + " in cache");
                }
                id = dn;
            }
        }
        if (trace.beInfo()) {
            trace.infoT("getIDFromDN", "converting dn " + distinguishedName + " into id " + id);
        }
        if (id == null) {
            trace.warningT("getIDFromDN", "No id available, will ignore distinguished name " + distinguishedName);
            return null;
        }
        if (this.caseSensitive) {
            return id;
        }
        return id.toLowerCase();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getDNfromID(ArrayList attributeNames, String attributeValue, String type) throws PersistenceException {
        String dn = null;
        String mn = "getDNfromID";
        if (trace.bePath()) {
            trace.entering("getDNfromID", new Object[]{attributeValue, type});
        }
        StringBuffer cacheKey = new StringBuffer();
        if (type.equals("USER") && this.mm_userAsUseraccount) {
            cacheKey.append("getDNfromID").append("_").append("UACC").append("_").append(attributeValue);
        } else {
            cacheKey.append("getDNfromID").append("_").append(type).append("_").append(attributeValue);
        }
        String _dn = (String)this.search_cache.get(cacheKey.toString().toLowerCase());
        if (_dn == null) {
            try {
                SearchControls sc = new SearchControls();
                sc.setReturningAttributes(new String[]{"objectclass"});
                sc.setSearchScope(2);
                sc.setDerefLinkFlag(false);
                sc.setTimeLimit(this.mm_time_limit);
                Vector objectclasses = (Vector)this.mm_principalObjectclasses.get(type);
                int size = attributeNames.size();
                if (size > objectclasses.size()) {
                    size = objectclasses.size();
                }
                StringBuffer filter = new StringBuffer();
                filter.append("(|");
                int i = 0;
                while (true) {
                    if (i >= size) break;
                    filter.append("(&(objectclass=").append(objectclasses.elementAt(i)).append(")");
                    filter.append("(").append(attributeNames.get(i)).append("=");
                    filter.append(JNDIUtils.escapeAttributeValue(attributeValue)).append(")");
                    filter.append(")");
                    ++i;
                }
                filter.append(")");
                boolean success = false;
                int count = 0;
                while (!success) {
                    Object var25_29;
                    if (count >= this.mm_action_retrial) {
                        return dn;
                    }
                    InitialDirContext ctx = this._manager.getConnection("getDNFromID", type, ++count);
                    boolean destroyContext = false;
                    try {
                        try {
                            if (trace.beInfo()) {
                                trace.infoT("getDNfromID", "searching for dn with searchfilter " + filter.toString());
                            }
                            long time = 0L;
                            if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                                time = System.currentTimeMillis();
                                StringBuffer sb = new StringBuffer();
                                sb.append("getDNFromID: ldap access at ").append(time);
                                sb.append("\n\twith search at base ");
                                sb.append("\n\twith filter ").append(filter.toString());
                                aa.print(sb.toString());
                            }
                            NamingEnumeration<SearchResult> results = ctx.search("", filter.toString(), sc);
                            if (props.getBoolean(RECORD_LDAP_ACCESS, false)) {
                                aa.print("getDNFromID: returning from ldap with search after " + (System.currentTimeMillis() - time) + " ms");
                            }
                            if (results.hasMore()) {
                                SearchResult sr = results.next();
                                String path = (String)this.mm_principalPaths.get(type);
                                String creationPath = (String)this.mm_principalCreationPaths.get(type);
                                StringBuffer name = new StringBuffer(JNDIUtils.removeQuotes(sr.getName()));
                                if (path != null && path.length() > 0) {
                                    if (name.length() > 0) {
                                        name.append(",").append(path);
                                    } else {
                                        name.append(path);
                                    }
                                }
                                dn = this.caseSensitive ? name.toString() : name.toString().toLowerCase();
                            }
                            success = true;
                            this.search_cache.put(cacheKey.toString().toLowerCase(), dn);
                        }
                        catch (CommunicationException e) {
                            if (trace.beInfo()) {
                                trace.infoT("getDNfromID", "communication exception: destroying used context", e);
                            }
                            destroyContext = true;
                            if (count == this.mm_action_retrial) {
                                throw new PersistenceException(e);
                            }
                            var25_29 = null;
                            this._manager.releaseConnection(type, ctx, destroyContext);
                            continue;
                        }
                        catch (NoInitialContextException e) {
                            if (trace.beInfo()) {
                                trace.infoT("getDNfromID", "no initial context exception: destroying used context", e);
                            }
                            destroyContext = true;
                            if (count == this.mm_action_retrial) {
                                throw new PersistenceException(e);
                            }
                            var25_29 = null;
                            this._manager.releaseConnection(type, ctx, destroyContext);
                            continue;
                        }
                        catch (NameNotFoundException e) {
                            trace.errorT("getDNfromID", "Name not found exception when trying to get the distinguished name for a " + type + " with value " + attributeValue, e);
                            trace.logErrorT("DataSource {0}: Object not found when trying to get the distinguished name for a {1} with value {2}", new Object[]{this.getId(), type, attributeValue});
                            success = true;
                            var25_29 = null;
                            this._manager.releaseConnection(type, ctx, destroyContext);
                            continue;
                        }
                        catch (NamingException e) {
                            trace.errorT("getDNfromID", "naming exception when trying to get the distinguished name for a " + type + " with value " + attributeValue, e);
                            trace.logErrorT("DataSource {0}: Object not found when trying to get the distinguished name for a {1} with value {2}", new Object[]{this.getId(), type, attributeValue});
                            success = true;
                            var25_29 = null;
                            this._manager.releaseConnection(type, ctx, destroyContext);
                            continue;
                        }
                        catch (Exception e) {
                            trace.errorT("getDNfromID", "some exception occured while searching for a distinguished name", e);
                            trace.logErrorT("DataSource {0}: Object not found when trying to get the distinguished name for a {1} with value {2}", new Object[]{this.getId(), type, attributeValue});
                            throw new PersistenceException(e);
                        }
                        var25_29 = null;
                        this._manager.releaseConnection(type, ctx, destroyContext);
                    }
                    catch (Throwable throwable) {
                        var25_29 = null;
                        this._manager.releaseConnection(type, ctx, destroyContext);
                        throw throwable;
                    }
                }
                return dn;
            }
            catch (LDAPDataSourceConnectionPool.ConnectionTimeoutException e) {
                if (!trace.beWarning()) return dn;
                trace.warningT("getDNfromID", "time out exception while trying to get a new connection", (Throwable)((Object)e));
                return dn;
            }
        }
        if (!trace.beInfo()) return _dn;
        trace.infoT("getDNfromID", "Distinguished name found in cache or key " + cacheKey.toString());
        return _dn;
    }

    private String getConfigurationStringValue(DSConfigurationModel model, String name, String defaultvalue) {
        String value = model.getPrivateAttribute(name);
        if (value == null) {
            value = defaultvalue == null ? props.get(name) : props.get(name, defaultvalue);
        }
        return value;
    }

    private boolean getConfigurationBooleanValue(DSConfigurationModel model, String name, boolean defaultvalue) {
        boolean value = defaultvalue;
        try {
            value = model.getPrivateAttributeBooleanValue(name);
        }
        catch (PersistenceException e) {
            if (trace.beInfo()) {
                StringBuffer sb = new StringBuffer();
                sb.append("Persistence exception when tyring to get private boolean attribute ");
                sb.append(name).append(" Exception: ").append(e.getMessage());
                trace.infoT("getConfigurationBooleanValue", sb.toString());
            }
            value = props.getBoolean(name, defaultvalue);
        }
        return value;
    }

    private int getConfigurationIntValue(DSConfigurationModel model, String name, int defaultvalue) {
        int value = defaultvalue;
        try {
            value = model.getPrivateAttributeIntValue(name);
            if (value == -1) {
                value = props.getNumber(name, defaultvalue);
            }
        }
        catch (PersistenceException e) {
            if (trace.beInfo()) {
                StringBuffer sb = new StringBuffer();
                sb.append("Persistence exception when tyring to get private int attribute ");
                sb.append(name).append(" Exception: ").append(e.getMessage());
                trace.infoT("getConfigurationIntValue", sb.toString());
            }
            value = props.getNumber(name, defaultvalue);
        }
        return value;
    }

    private Vector removeBlockedPrincipals(Vector result) {
        if (this._blockedPrincipals == null || this._blockedPrincipals.size() == 0) {
            return result;
        }
        if (result == null) {
            return result;
        }
        int i = 0;
        while (i < this._blockedPrincipals.size()) {
            if (result.contains(this._blockedPrincipals.elementAt(i))) {
                if (trace.beInfo()) {
                    trace.infoT("removeBlockedPrincipals", "removing principal " + this._blockedPrincipals.elementAt(i) + " from search result");
                }
                result.remove(this._blockedPrincipals.elementAt(i));
            }
            ++i;
        }
        return result;
    }

    private synchronized boolean reinitializeConnectionManager() {
        if (!this.lazyInitialisation) {
            return true;
        }
        String mn = "reinitializeConnectionManager";
        ++this.init;
        boolean initialzed = false;
        try {
            this._manager = new LDAPConnectionManager();
            this._manager.initialize(this.mConfigurationModel);
            if (trace.beInfo()) {
                trace.infoT("reinitializeConnectionManager", "Connection manager sucessfully initialized");
            }
            _centralNameParser = this._manager.getParser();
            this.lazyInitialisation = false;
            initialzed = true;
            if (trace.beWarning()) {
                trace.warningT("reinitializeConnectionManager", "Reinitialisation successfull (keystore available)");
            }
        }
        catch (PersistenceException e) {
            if (!this.mm_sslEnabled) {
                trace.errorT("reinitializeConnectionManager", "Initialisation of connection manager failed", (Throwable)((Object)e));
                initialzed = false;
                this.lazyInitialisation = false;
            }
            trace.errorT("reinitializeConnectionManager", "Initialisation of connection manager failed", (Throwable)((Object)e));
            trace.logErrorT("Initialisation of LDAP connection manager failed", null);
            this.lazyInitialisation = true;
        }
        if (initialzed) {
            if (trace.beDebug()) {
                trace.debugT("reinitializeConnectionManager", "LDAP connection manager successfully initialized");
            }
            String blockedPrincipals = this.getConfigurationStringValue(this.mConfigurationModel, BLOCKED_USERS, null);
            Vector blocked = JNDIUtils.getVectorFromString(blockedPrincipals, ",");
            int i = 0;
            while (i < blocked.size()) {
                SearchCriteria sc = new SearchCriteria(false, "USER");
                sc.addEqualsElement("com.sap.security.core.usermanagement", "uniquename", blocked.elementAt(i), true);
                try {
                    Vector blockedIDs = this.searchPrincipalDatabags(sc);
                    int j = 0;
                    while (j < blockedIDs.size()) {
                        if (this._blockedPrincipals == null) {
                            this._blockedPrincipals = new Vector();
                        }
                        this._blockedPrincipals.add(blockedIDs.elementAt(j));
                        ++j;
                    }
                }
                catch (Exception e) {
                    trace.errorT("reinitializeConnectionManager", "Exception when searching for blocked users", e);
                    trace.logErrorT("Exception when searching for blocked users", null);
                }
                ++i;
            }
            blockedPrincipals = this.getConfigurationStringValue(this.mConfigurationModel, BLOCKED_GROUPS, null);
            blocked = JNDIUtils.getVectorFromString(blockedPrincipals, ",");
            int i2 = 0;
            while (i2 < blocked.size()) {
                SearchCriteria sc = new SearchCriteria(false, "GRUP");
                sc.addEqualsElement("com.sap.security.core.usermanagement", "uniquename", blocked.elementAt(i2), true);
                try {
                    Vector blockedIDs = this.searchPrincipalDatabags(sc);
                    if (this._blockedPrincipals == null) {
                        this._blockedPrincipals = new Vector();
                    }
                    int j = 0;
                    while (j < blockedIDs.size()) {
                        this._blockedPrincipals.add(blockedIDs.elementAt(j));
                        ++j;
                    }
                }
                catch (Exception e) {
                    trace.errorT("reinitializeConnectionManager", "Exception when searching for blocked groups", e);
                    trace.logErrorT("Exception when searching for blocked groups", null);
                }
                ++i2;
            }
            blockedPrincipals = this.getConfigurationStringValue(this.mConfigurationModel, BLOCKED_ACCOUNTS, null);
            blocked = JNDIUtils.getVectorFromString(blockedPrincipals, ",");
            int i3 = 0;
            while (i3 < blocked.size()) {
                SearchCriteria sc = new SearchCriteria(false, "UACC");
                sc.addEqualsElement("com.sap.security.core.usermanagement", "j_user", blocked.elementAt(i3), true);
                try {
                    Vector blockedIDs = this.searchPrincipalDatabags(sc);
                    if (this._blockedPrincipals == null) {
                        this._blockedPrincipals = new Vector();
                    }
                    int j = 0;
                    while (j < blockedIDs.size()) {
                        this._blockedPrincipals.add(blockedIDs.elementAt(j));
                        ++j;
                    }
                }
                catch (Exception e) {
                    trace.errorT("reinitializeConnectionManager", "Exception when searching for blocked accounts", e);
                    trace.logErrorT("Exception when searching for blocked accounts", null);
                }
                ++i3;
            }
        }
        return initialzed;
    }

    private boolean isDomainAllowed(String domain) {
        try {
            if (this.mm_mappedDomains == null) {
                return this.getId().equalsIgnoreCase(domain);
            }
            return this.mm_mappedDomains.containsKey(domain.toLowerCase());
        }
        catch (PersistenceException e) {
            trace.warningT("isDomainAllowed", "Exception when checking for allowed domains " + e.getMessage());
            trace.logWarningT("Domains can not be checked as getting datasource id causes an exception, please check log file", null);
            return false;
        }
    }

    private boolean checkDomainOfDN(String dn, String domainAlias) {
        String domainPath = null;
        if (domainAlias == null) {
            return true;
        }
        if (dn == null) {
            return false;
        }
        Iterator keys = this.mm_mappedDomains.keySet().iterator();
        while (keys.hasNext()) {
            String dAlias = (String)keys.next();
            String path = ((String)this.mm_mappedDomains.get(dAlias)).toLowerCase();
            if (!dn.toLowerCase().endsWith(path)) continue;
            if (domainPath == null) {
                domainPath = path;
                continue;
            }
            if (path.length() <= domainPath.length()) continue;
            domainPath = path;
        }
        return ((String)this.mm_mappedDomains.get(domainAlias.toLowerCase())).equalsIgnoreCase(domainPath);
    }

    public LDAPPersistence() {
        LDAPATSInterface in = new LDAPATSInterface();
        mm_instances.add(in);
    }

    public static LDAPATSInterface[] getATSInstances() {
        return mm_instances.toArray(new LDAPATSInterface[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class LDAPATSInterface {
        public boolean isLDAPReadonly() throws PersistenceException {
            return LDAPPersistence.this.isReadonly();
        }

        public boolean isHomeForUser() throws PersistenceException {
            String uniqueID = "USER." + LDAPPersistence.this.getId() + ".cn=dummy,o=sap.corp";
            PrincipalDatabag p = new PrincipalDatabag(uniqueID);
            return LDAPPersistence.this.isHomeForPrincipalDatabag(p);
        }

        public boolean isHomeForGroup() throws PersistenceException {
            String uniqueID = "GRUP." + LDAPPersistence.this.getId() + ".cn=dummy,o=sap.corp";
            PrincipalDatabag p = new PrincipalDatabag(uniqueID);
            return LDAPPersistence.this.isHomeForPrincipalDatabag(p);
        }

        public Vector getAvailableAttributeNames(String id, String namespace) throws PersistenceException {
            return LDAPPersistence.this.getAttributeNames(new PrincipalDatabag(id), namespace);
        }

        public Vector getAvailableNameSpaces(String id) throws PersistenceException {
            return LDAPPersistence.this.getAttributeNamespaces(new PrincipalDatabag(id));
        }
    }

    protected class SearchCacheEntry {
        private Vector _ids = null;
        private int _flag;

        protected SearchCacheEntry(Vector results, int flag) {
            this._ids = results;
            this._flag = flag;
        }

        protected int getFlag() {
            return this._flag;
        }

        protected Vector getResultsIDs() {
            return this._ids;
        }
    }
}

