/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp;

import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.util.IUMTrace;
import java.util.Hashtable;
import javax.naming.directory.InitialDirContext;

public class LDAPMasterCheck {
    private static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/LDAPMasterCheck.java#3 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)";
    private static IUMTrace _trace = null;
    private boolean _available = false;
    private Hashtable _env = null;
    private long _checktime = 0L;
    private long _lastCheck = 0L;
    private boolean _useThread = false;
    private Thread check = null;

    public LDAPMasterCheck(Hashtable env, long time, boolean useThread) {
        this._env = (Hashtable)env.clone();
        this._checktime = time;
        this._useThread = useThread;
        _trace = InternalUMFactory.getTrace(VERSIONSTRING);
    }

    public void startCheck() {
        this._lastCheck = System.currentTimeMillis();
        this._available = false;
        if (this._useThread) {
            if (this.check == null) {
                this.check = new Thread((Runnable)new CheckServerThread(), "master_server_check");
            }
            if (this.check.isAlive()) {
                this.check.resume();
            } else {
                this.check.start();
            }
        }
    }

    public void stopCheck() {
        if (this._useThread) {
            this.check.suspend();
        }
    }

    public boolean isMasterAvailable() {
        if (this._useThread) {
            return this._available;
        }
        if (!this._available && this._lastCheck + this._checktime < System.currentTimeMillis()) {
            try {
                this._lastCheck = System.currentTimeMillis();
                InitialDirContext ctx = new InitialDirContext(this._env);
                if (ctx != null) {
                    ctx.lookup("");
                    ctx.close();
                    this._available = true;
                    _trace.infoT("checkAvailability", "main server available");
                }
            }
            catch (Exception e) {
                _trace.warningT("checkAvailability", "exception " + e.getMessage() + " when checking availability of main server, not available");
                this._available = false;
            }
        }
        return this._available;
    }

    private class CheckServerThread
    implements Runnable {
        public void run() {
            block5: {
                try {
                    while (!Thread.interrupted()) {
                        if (_trace.beDebug()) {
                            _trace.debugT("run", "checking availability of main server");
                        }
                        LDAPMasterCheck.this._available = this.checkAvailability();
                        if (_trace.beDebug()) {
                            _trace.debugT("run", "main ldap server available :" + LDAPMasterCheck.this._available);
                        }
                        Thread.sleep(LDAPMasterCheck.this._checktime);
                    }
                }
                catch (InterruptedException e) {
                    if (!_trace.beInfo()) break block5;
                    StringBuffer sb = new StringBuffer();
                    sb.append("Interrupted exception while ClientServerThread checks availability of master server");
                    sb.append(" [Exeption: ").append(e.getMessage()).append("]");
                    _trace.infoT("ClientServerThread.run", sb.toString());
                }
            }
        }

        private boolean checkAvailability() {
            boolean avail = false;
            try {
                InitialDirContext ctx = new InitialDirContext(LDAPMasterCheck.this._env);
                if (ctx != null) {
                    ctx.lookup("");
                    ctx.close();
                    avail = true;
                    if (_trace.beInfo()) {
                        _trace.infoT("checkAvailabilty", "main server available");
                    }
                }
            }
            catch (Exception e) {
                _trace.infoT("checkAvailability", "exception " + e.getMessage() + " when checking availability of main server, main server not available");
                avail = false;
            }
            return avail;
        }
    }
}

