/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp;

import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.IInternalPrincipalDatabag;
import com.sap.security.core.persistence.IInternalPrincipalDatabagMaint;
import com.sap.security.core.persistence.IPrincipalDatabag;
import com.sap.security.core.persistence.datasource.IDataSourceTransaction;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.datasource.imp.LDAPPersistence;
import com.sap.security.core.util.IUMTrace;
import java.util.Vector;

public class LDAPDataSourceTransaction
implements IDataSourceTransaction {
    private static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/LDAPDataSourceTransaction.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";
    private static IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/LDAPDataSourceTransaction.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)");
    private static final int BIND_PRINCIPAL = 0;
    private static final int CREATE_PRINCIPAL = 1;
    private static final int DELETE_PRINCIPAL = 2;
    private static final int MODIFY_PRINCIPAL = 3;
    private Vector actions = null;
    private LDAPPersistence ds = null;

    public LDAPDataSourceTransaction(LDAPPersistence dataSource) {
        this.ds = dataSource;
        this.actions = new Vector();
    }

    public void createPrincipalDatabag(IInternalPrincipalDatabag principal) throws PersistenceException {
        if (trace.beDebug()) {
            trace.entering("createPrincipalDatabag", new Object[]{principal});
        }
        if (principal == null) {
            trace.errorT("createPrincipalDatabag", "can not create principal null");
            throw new PersistenceException("can not create a null principal");
        }
        LDAPAction ldapAction = new LDAPAction(1, principal);
        this.actions.add(ldapAction);
    }

    public void deletePrincipalDatabag(IPrincipalDatabag principal) throws PersistenceException {
        if (trace.beDebug()) {
            trace.entering("deletePrincipalDatabag", new Object[]{principal});
        }
        if (principal == null) {
            trace.errorT("deletePrincipalDatabag", "can not delete a principal null");
            throw new PersistenceException("can not delete a null principal");
        }
        LDAPAction ldapAction = new LDAPAction(2, principal);
        this.actions.add(ldapAction);
    }

    public void updatePrincipalDatabag(IInternalPrincipalDatabagMaint principal) throws PersistenceException {
        if (trace.beDebug()) {
            trace.entering("updatePrincipalDatabag", new Object[]{principal});
        }
        if (principal == null) {
            trace.errorT("updatePrincipalDatabag", "can not update a principal null");
            throw new PersistenceException("can not modify a null principal");
        }
        LDAPAction ldapAction = new LDAPAction(3, principal);
        this.actions.add(ldapAction);
    }

    public void commit() throws PersistenceException {
        if (trace.beDebug()) {
            trace.entering("commit");
        }
        int count = 0;
        count = 0;
        while (count < this.actions.size()) {
            LDAPAction action = (LDAPAction)this.actions.get(count);
            switch (action.getAction()) {
                case 1: {
                    this.ds.createPrincipalDatabag((IInternalPrincipalDatabag)action.getPrincipal());
                    trace.infoT("commit", "create a principal");
                    break;
                }
                case 2: {
                    this.ds.deletePrincipalDatabag((IInternalPrincipalDatabag)action.getPrincipal());
                    trace.infoT("commit", "delete a principal");
                    break;
                }
                case 3: {
                    this.ds.updatePrincipalDatabag((IInternalPrincipalDatabagMaint)action.getPrincipal());
                    trace.infoT("commit", "update a principal");
                    break;
                }
            }
            ++count;
        }
        this.actions = new Vector();
    }

    public void rollback() {
        if (trace.beDebug()) {
            trace.entering("rollback");
        }
        this.actions = new Vector();
    }

    public boolean bindNewPrincipalDatabag(IInternalPrincipalDatabag principal) throws PersistenceException {
        if (trace.beDebug()) {
            trace.entering("bindNewPrincipal", new Object[]{principal});
        }
        return this.ds.bindNewPrincipalDatabag(principal);
    }

    private class LDAPAction {
        private int mAction;
        private IPrincipalDatabag mPrincipal;

        public LDAPAction(int action, IPrincipalDatabag principal) {
            this.mAction = action;
            this.mPrincipal = principal;
        }

        public int getAction() {
            return this.mAction;
        }

        public IPrincipalDatabag getPrincipal() {
            return this.mPrincipal;
        }
    }
}

