/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp;

import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.util.IUMTrace;
import com.sap.tc.logging.Location;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.InitialDirContext;

public class LDAPDataSourceConnectionPool {
    private static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/LDAPDataSourceConnectionPool.java#5 $ from $DateTime: 2004/07/30 14:01:42 $ ($Change: 16956 $)";
    private static IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/LDAPDataSourceConnectionPool.java#5 $ from $DateTime: 2004/07/30 14:01:42 $ ($Change: 16956 $)");
    private static final Location myLoc = Location.getLocation((Class)(class$com$sap$security$core$persistence$datasource$imp$LDAPDataSourceConnectionPool == null ? (class$com$sap$security$core$persistence$datasource$imp$LDAPDataSourceConnectionPool = LDAPDataSourceConnectionPool.class$("com.sap.security.core.persistence.datasource.imp.LDAPDataSourceConnectionPool")) : class$com$sap$security$core$persistence$datasource$imp$LDAPDataSourceConnectionPool));
    private String mName = null;
    private int mMinSize;
    private int mMaxSize;
    private int mMaxIdleConnections;
    private int mMaxIdleTimeMillis;
    private int mMaxWaitTimeMillis;
    public static final int DEF_MINSIZE = 1;
    public static final int DEF_MAXSIZE = 10;
    public static final int DEF_MAXIDLECONNECTIONS = 5;
    public static final int DEF_MAXIDLETIME = 600000;
    public static final int DEF_MAXWAITTIME = 30000;
    public static final int MIN_MONITORINTERVAL = 1000;
    private Hashtable mConnectionParameters;
    private Hashtable distributedConnections = null;
    private int mUsedCount;
    private int mOpenCount;
    private int mWaitingThreadsCount;
    private int mAutomaticConnectionReleaseIntervalMillis;
    private int mConnectionReleaseCheckIntervalMillis;
    private int mConnectionRetrial;
    private int mConnectionTimeout;
    private Stack mIdleConnections;
    private StringBuffer mStatusInfoBuffer;
    private static final String NEWLINE = System.getProperty("line.separator", "\n");
    private Thread mMonitorThread;
    private Thread mListMonitorThread;
    static /* synthetic */ Class class$com$sap$security$core$persistence$datasource$imp$LDAPDataSourceConnectionPool;

    public LDAPDataSourceConnectionPool(String name, int minSize, int maxSize, int maxIdleConnections, int maxIdleTimeMillis, int maxWaitTimeMillis, int connectionTimeout, Hashtable connectionParameters, int monitorInterval, int connectionRetrial, int automaticConnectionReleaseIntervallMillis, int connectionReleaseCheckIntervalMillis) throws InitializationException, ServerNotAvailableException {
        StringBuffer sb;
        if (trace.beDebug()) {
            StringBuffer sb2 = new StringBuffer();
            sb2.append("Connectionparameters\n");
            sb2.append("name:").append(name).append("\n");
            sb2.append("minSize:").append(minSize).append("\n");
            sb2.append("maxSize:").append(maxSize).append("\n");
            sb2.append("maxIdleConnections:").append(maxIdleConnections).append("\n");
            sb2.append("maxIdleTimeMillis:").append(maxIdleTimeMillis).append("\n");
            sb2.append("maxWaitTimeMillis:").append(maxWaitTimeMillis).append("\n");
            sb2.append("monitorInterval:").append(monitorInterval).append("\n");
            sb2.append("connectionRetrial:").append(connectionRetrial).append("\n");
            sb2.append("automaticConnectionReleaseIntervallMillis:").append(automaticConnectionReleaseIntervallMillis).append("\n");
            sb2.append("connectionReleaseCheckIntervalMillis:").append(connectionReleaseCheckIntervalMillis).append("\n");
            Enumeration keys = connectionParameters.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                Object value = connectionParameters.get(key);
                if (key.equals("java.naming.security.credentials")) {
                    sb2.append(key).append(":").append("*****").append("\n");
                    continue;
                }
                sb2.append(key).append(":").append(value).append("\n");
            }
            trace.debugT("LDAPDataSourceConnectionPool", sb2.toString());
        }
        this.mConnectionRetrial = connectionRetrial;
        this.mAutomaticConnectionReleaseIntervalMillis = automaticConnectionReleaseIntervallMillis;
        this.mConnectionReleaseCheckIntervalMillis = connectionReleaseCheckIntervalMillis;
        this.mConnectionTimeout = connectionTimeout;
        if (name == null) {
            trace.errorT("LDAPDataSourceConnectionPool", "connection pool name is null");
            throw new InitializationException("Connection pool name must not be null");
        }
        if (this.distributedConnections == null) {
            this.distributedConnections = new Hashtable();
        }
        this.mName = name.replace(' ', '_');
        this.mMinSize = minSize > 0 ? minSize : 1;
        this.mMaxSize = maxSize > 0 ? maxSize : 10;
        this.mMaxIdleConnections = maxIdleConnections > 0 ? maxIdleConnections : 5;
        this.mMaxIdleTimeMillis = maxIdleTimeMillis > 0 ? maxIdleTimeMillis : 600000;
        this.mMaxWaitTimeMillis = maxWaitTimeMillis > 0 ? maxWaitTimeMillis : 30000;
        this.mConnectionParameters = connectionParameters;
        this.mUsedCount = 0;
        this.mOpenCount = 0;
        this.mWaitingThreadsCount = 0;
        this.mStatusInfoBuffer = new StringBuffer(20);
        this.mIdleConnections = new Stack();
        int i = 0;
        while (i < this.mMinSize) {
            InitialDirContext context = this.newConnection();
            if (context == null) {
                trace.errorT("LDAPDataSourceConnectionPool", "Initialization of connection pool failed, context is null");
                throw new InitializationException(this.mName + ": Initialization of connection pool failed.");
            }
            this.mIdleConnections.push(new ConnectionWrapper(context));
            ++i;
        }
        if (monitorInterval > 0) {
            if (monitorInterval < 1000) {
                sb = new StringBuffer(200);
                sb.append(this.mName).append(": using minimum connection pool monitor interval ");
                sb.append(1000).append("ms");
                trace.warningT("LDAPDataSourceConnectionPool", sb.toString());
                monitorInterval = 1000;
            }
            sb = new StringBuffer(100);
            String poolname = this.mName.replace(':', '_');
            sb.append("sapum_cpmon_").append(poolname).append(".log");
            Monitor monitor = null;
            try {
                monitor = new Monitor(this, monitorInterval, sb.toString());
            }
            catch (IllegalArgumentException ex) {
                sb.setLength(0);
                sb.append(this.mName).append(" : connection pool monitoring failed: ");
                sb.append(ex);
                trace.errorT("LDAPDataSourceConnectionPool", sb.toString(), ex);
            }
            this.mMonitorThread = new Thread((Runnable)monitor, "CP Monitor " + this.mName);
            this.mMonitorThread.setPriority(1);
            this.mMonitorThread.start();
            ConnectionListMonitor listMon = null;
            try {
                listMon = new ConnectionListMonitor(this.distributedConnections, connectionReleaseCheckIntervalMillis);
            }
            catch (IllegalArgumentException ex) {
                sb.setLength(0);
                sb.append(this.mName).append(" : connection list monitoring failed: ");
                sb.append(ex);
                trace.errorT("LDAPDataSourceConnectionPool", sb.toString(), ex);
            }
            this.mListMonitorThread = new Thread((Runnable)listMon, "CL Monitor " + this.mName);
            this.mListMonitorThread.setPriority(1);
            this.mListMonitorThread.start();
        }
        if (trace.beInfo()) {
            sb = new StringBuffer(200);
            sb.append("Connection pool ").append(this.mName).append(" successfuly initialized.").append(NEWLINE);
            sb.append("    Connection: ").append(this.getConnectionString()).append(NEWLINE);
            sb.append("    min pool size=").append(this.mMinSize).append(NEWLINE);
            sb.append("    max pool size=").append(this.mMaxSize).append(NEWLINE);
            sb.append("    max idle connections=").append(this.mMaxIdleConnections).append(NEWLINE);
            sb.append("    max idle time=").append(this.mMaxIdleTimeMillis).append("ms").append(NEWLINE);
            sb.append("    waiting timeout=").append(this.mMaxWaitTimeMillis).append("ms").append(NEWLINE);
            sb.append("    connection retrial=").append(connectionRetrial).append("ms").append(NEWLINE);
            sb.append("    release given connections after=").append(automaticConnectionReleaseIntervallMillis).append("ms").append(NEWLINE);
            sb.append("    check given connections interval=").append(connectionReleaseCheckIntervalMillis).append("ms").append(NEWLINE);
            sb.append("    connection time out=").append(connectionTimeout).append(NEWLINE);
            sb.append("    monitoring=");
            sb.append(monitorInterval <= 0 ? "off" : monitorInterval + "ms").append(NEWLINE);
            trace.infoT("LDAPDataSourceConnectionPool", sb.toString());
        }
    }

    public LDAPDataSourceConnectionPool(String name, int minSize, int maxSize, int maxIdleConnections, int maxIdleTimeMillis, int maxWaitTimeMillis, int connectionTimeout, Hashtable connectionParameters, int connectionRetrial, int automaticConnectionReleaseIntervallMillis, int connectionReleaseCheckIntervalMillis) throws InitializationException, ServerNotAvailableException {
        this(name, minSize, maxSize, maxIdleConnections, maxIdleTimeMillis, maxWaitTimeMillis, connectionTimeout, connectionParameters, -1, connectionRetrial, automaticConnectionReleaseIntervallMillis, connectionReleaseCheckIntervalMillis);
    }

    public LDAPDataSourceConnectionPool(String name, int connectionTimeout, Hashtable connectionParameters, int connectionRetrial, int automaticConnectionReleaseIntervalMillis, int connectionReleaseCheckIntervalMillis) throws InitializationException, ServerNotAvailableException {
        this(name, 1, 10, 5, 600000, 30000, connectionTimeout, connectionParameters, connectionRetrial, automaticConnectionReleaseIntervalMillis, connectionReleaseCheckIntervalMillis);
    }

    public synchronized InitialDirContext getConnection(String description) throws ConnectionTimeoutException, ServerNotAvailableException {
        InitialDirContext context = null;
        while (context == null) {
            long startWaitingTs;
            block7: {
                context = this.getIdleConnection();
                if (context != null) {
                    ++this.mUsedCount;
                    this.distributedConnections.put(context, new ConnectionPostIt(description, this.mAutomaticConnectionReleaseIntervalMillis));
                    return context;
                }
                if (this.mOpenCount < this.mMaxSize) {
                    context = this.newConnection();
                    ++this.mUsedCount;
                    this.distributedConnections.put(context, new ConnectionPostIt(description, this.mAutomaticConnectionReleaseIntervalMillis));
                    return context;
                }
                ++this.mWaitingThreadsCount;
                if (trace.beDebug()) {
                    trace.debugT("getConnection", this.mName + ": Waiting for connection ...");
                }
                startWaitingTs = System.currentTimeMillis();
                try {
                    this.wait(this.mMaxWaitTimeMillis);
                }
                catch (InterruptedException ex) {
                    if (!trace.beDebug()) break block7;
                    trace.debugT("getConnection", this.mName + ": ... interrupted; Exception: " + ex.getMessage());
                }
            }
            --this.mWaitingThreadsCount;
            if (System.currentTimeMillis() - startWaitingTs > (long)this.mMaxWaitTimeMillis) {
                trace.errorT("getConnection", this.mName + ": Maximum wait time of " + this.mMaxWaitTimeMillis + "ms elapsed.");
                break;
            }
            if (!trace.beDebug()) continue;
            trace.debugT("getConnection", this.mName + ": ... notified");
        }
        trace.errorT("getConnection", "Maximum wait time exceeded for connectionpool " + this.mMaxWaitTimeMillis);
        throw new ConnectionTimeoutException("Maximum wait time exceeded: " + this.mMaxWaitTimeMillis);
    }

    public synchronized void releaseConnection(InitialDirContext context, boolean destroy) throws ServerNotAvailableException {
        if (!this.distributedConnections.containsKey(context)) {
            try {
                context.close();
                this.notify();
            }
            catch (NamingException nex) {
                trace.infoT("releaseConnection", this.mName + ": Cannot destroy timed out connection; Exception: " + nex.getMessage());
            }
            return;
        }
        --this.mUsedCount;
        this.distributedConnections.remove(context);
        if (this.mWaitingThreadsCount > 0 || this.mIdleConnections.size() < this.mMaxIdleConnections || this.mUsedCount < this.mMinSize) {
            StringBuffer sb;
            if (destroy) {
                try {
                    context.close();
                    if (trace.beDebug()) {
                        sb = new StringBuffer(100);
                        sb.append(this.mName + ": Released connection ");
                        sb.append(context).append(" destroyed (recommended by caller)");
                        trace.debugT("releaseConnection", sb.toString());
                    }
                }
                catch (NamingException ex) {
                    trace.warningT("releaseConnection", this.mName + ": Catched exception while closing connection " + context, ex);
                }
                --this.mOpenCount;
                context = this.newConnection();
            }
            this.mIdleConnections.push(new ConnectionWrapper(context));
            if (trace.beDebug()) {
                sb = new StringBuffer(100);
                sb.append(this.mName + ": Released connection ");
                sb.append(context).append(" pushed back on stack");
                trace.debugT("releaseConnection", sb.toString());
            }
            this.notify();
        } else {
            try {
                context.close();
                if (trace.beDebug()) {
                    StringBuffer sb = new StringBuffer(100);
                    sb.append(this.mName + ": Released connection ");
                    sb.append(context).append(" closed");
                    trace.debugT("releaseConnection", sb.toString());
                }
            }
            catch (NamingException ex) {
                trace.warningT("releaseConnection", this.mName + ": Catched exception while closing connection " + context, ex);
            }
            --this.mOpenCount;
        }
    }

    public synchronized void releaseConnection(InitialDirContext context) throws ServerNotAvailableException {
        this.releaseConnection(context, false);
    }

    public synchronized void closeAllConnections() {
        Enumeration allIdleConnections = this.mIdleConnections.elements();
        while (allIdleConnections.hasMoreElements()) {
            ConnectionWrapper cw = (ConnectionWrapper)allIdleConnections.nextElement();
            try {
                cw.getConnection().close();
            }
            catch (Exception e) {
                trace.warningT("closeAllConnections", "exception while closing one idle connection", e);
            }
        }
    }

    public synchronized String getStatus() {
        this.mStatusInfoBuffer.setLength(0);
        this.mStatusInfoBuffer.append(this.mOpenCount).append('\t');
        this.mStatusInfoBuffer.append(this.mUsedCount).append('\t');
        this.mStatusInfoBuffer.append(this.mIdleConnections.size()).append('\t');
        this.mStatusInfoBuffer.append(this.mWaitingThreadsCount);
        return this.mStatusInfoBuffer.toString();
    }

    public String getName() {
        return this.mName;
    }

    private InitialDirContext newConnection() throws ServerNotAvailableException {
        InitialDirContext context = null;
        try {
            int z = 0;
            while (z < this.mConnectionRetrial + 1) {
                try {
                    if (trace.beDebug()) {
                        StringBuffer sb = new StringBuffer("connection parameter:\n");
                        Enumeration keys = this.mConnectionParameters.keys();
                        while (keys.hasMoreElements()) {
                            String key = (String)keys.nextElement();
                            String value = null;
                            value = key.equalsIgnoreCase("java.naming.security.credentials") ? "******" : this.mConnectionParameters.get(key);
                            sb.append(key).append(":").append((Object)value).append("\n");
                        }
                        trace.debugT("newConnection", sb.toString());
                    }
                    context = (InitialDirContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws NamingException {
                            return new InitialDirContext(LDAPDataSourceConnectionPool.this.mConnectionParameters);
                        }
                    });
                    try {
                        context.lookup("");
                    }
                    catch (PartialResultException e) {
                        if (!trace.beInfo()) break;
                        trace.infoT("newConnection", "partial result exception when opening a new connection: " + e.getMessage());
                    }
                    break;
                }
                catch (NullPointerException e) {
                    trace.warningT("newConnection", "KeystoreService not available during start up, Reinitialisation started");
                    throw new ServerNotAvailableException("no connection to the ldap server:" + ((Throwable)e).getMessage());
                }
                catch (Exception e) {
                    trace.warningT("newConnection", "an error occured when opening a connection, trying again [cause:" + e.getMessage() + "]");
                    if (z == this.mConnectionRetrial) {
                        myLoc.traceThrowableT(500, "newConnection", "no connection to the ldap server", (Throwable)e);
                        trace.logFatalT("No connection to the ldap server, recheck configuration or availability of directory server", null);
                        throw new ServerNotAvailableException("no connection to the ldap server:" + e.getMessage());
                    }
                    ++z;
                }
            }
            LDAPDataSourceConnectionPool e = this;
            synchronized (e) {
                ++this.mOpenCount;
            }
            if (trace.beDebug()) {
                StringBuffer sb = new StringBuffer(100);
                sb.append(this.mName).append(": New connection to LDAP server successful (");
                sb.append(this.getConnectionString()).append(")");
                trace.debugT("newConnection", sb.toString());
            }
        }
        catch (ServerNotAvailableException e) {
            myLoc.traceThrowableT(500, "new Connection", "server not available, trying to switch to fail over if possible", (Throwable)((Object)e));
            trace.logFatalT("Server not available,recheck configuration or availability of directory server", null);
            throw e;
        }
        catch (Exception ex) {
            StringBuffer sb = new StringBuffer(100);
            sb.append(this.mName).append(": Connection to LDAP server failed (");
            sb.append(this.getConnectionString()).append("): ");
            trace.errorT("newConnection", sb.toString(), ex);
            throw new ServerNotAvailableException(ex.toString());
        }
        return context;
    }

    private InitialDirContext getIdleConnection() throws ServerNotAvailableException {
        ConnectionWrapper connectionWrapper = null;
        Stack stack = this.mIdleConnections;
        synchronized (stack) {
            if (!this.mIdleConnections.isEmpty()) {
                connectionWrapper = (ConnectionWrapper)this.mIdleConnections.pop();
            }
        }
        if (connectionWrapper == null) {
            return null;
        }
        long time = System.currentTimeMillis();
        if (time - connectionWrapper.getLastAccess() > (long)this.mMaxIdleTimeMillis || this.mConnectionTimeout > 0 && time - connectionWrapper.getCreated() > (long)this.mConnectionTimeout) {
            if (this.mConnectionTimeout > 0 && time - connectionWrapper.getCreated() > (long)this.mConnectionTimeout) {
                trace.warningT("getIdleConnection", "time out reached " + this.mConnectionTimeout + " closing connection");
            }
            try {
                connectionWrapper.getConnection().close();
                LDAPDataSourceConnectionPool lDAPDataSourceConnectionPool = this;
                synchronized (lDAPDataSourceConnectionPool) {
                    --this.mOpenCount;
                }
            }
            catch (NamingException ex) {
                trace.warningT("getIdleConnection", this.mName + ": Catched exception while closing connection: ", ex);
            }
            InitialDirContext context = this.newConnection();
            if (trace.beDebug()) {
                StringBuffer sb = new StringBuffer(100);
                sb.append(this.mName + ": Maxmimum idle time ");
                sb.append(this.mMaxIdleTimeMillis).append(" exceeded, returning new connection");
                trace.debugT("getIdleConnection", sb.toString());
            }
            return context;
        }
        if (trace.beDebug()) {
            StringBuffer sb = new StringBuffer(100);
            sb.append(this.mName + ": Got idle connection ");
            sb.append(connectionWrapper.getConnection()).append(" from stack");
            trace.debugT("getIdleConnection", sb.toString());
        }
        return connectionWrapper.getConnection();
    }

    private String getConnectionString() {
        if (this.mConnectionParameters != null) {
            StringBuffer sb = new StringBuffer(200);
            sb.append("Url=").append(this.mConnectionParameters.get("java.naming.provider.url"));
            sb.append(", user=");
            sb.append((Object)("none".equals(this.mConnectionParameters.get("java.naming.security.authentication")) ? "anonymous" : this.mConnectionParameters.get("java.naming.security.principal")));
            return sb.toString();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Monitor
    implements Runnable {
        private LDAPDataSourceConnectionPool mPool = null;
        private int mStatusInterval = 1000;
        private PrintWriter mOut = null;
        private DateFormat mDateFormat = null;
        private static final String DEF_DATEFORMATSTRING = "dd.MM.yyyy HH:mm:ss.SSS";

        public Monitor(LDAPDataSourceConnectionPool pool, int statusInterval, String fileName) {
            if (pool == null) {
                throw new IllegalArgumentException("Pool is null.");
            }
            this.mPool = pool;
            if (statusInterval > 0) {
                this.mStatusInterval = statusInterval;
            }
            try {
                this.mOut = new PrintWriter(new FileOutputStream(fileName));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Failed to open monitor logfile " + fileName + ": " + ex);
            }
            this.mDateFormat = new SimpleDateFormat(DEF_DATEFORMATSTRING);
        }

        public void run() {
            this.mOut.println("Jndi connection pool status for pool ");
            this.mOut.println("time / open connections / used connections / idle connections / waiting threads");
            this.mOut.println();
            this.mOut.flush();
            try {
                try {
                    while (!Thread.interrupted()) {
                        this.mOut.println(this.mDateFormat.format(new Date()) + ":\t" + this.mPool.getStatus());
                        this.mOut.flush();
                        Thread.sleep(this.mStatusInterval);
                    }
                }
                catch (InterruptedException ex) {
                    if (trace.beInfo()) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("interrupted exception while connection pool monitor is running");
                        sb.append(" [Exception: ").append(ex.getMessage()).append("]");
                        trace.infoT("ConnectionPoolMonitor.run", sb.toString());
                    }
                    Object var4_2 = null;
                    this.mOut.flush();
                }
                Object var4_1 = null;
                this.mOut.flush();
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                this.mOut.flush();
                throw throwable;
            }
        }
    }

    private class ConnectionListMonitor
    implements Runnable {
        private Hashtable mList = null;
        private int mInterval = 10000;

        public ConnectionListMonitor(Hashtable list, int interval) {
            if (list == null) {
                throw new IllegalArgumentException("List is null.");
            }
            this.mList = list;
            if (interval > 0) {
                this.mInterval = interval;
            }
        }

        public void run() {
            block5: {
                try {
                    while (!Thread.interrupted()) {
                        Iterator iterator;
                        Set keys = this.mList.keySet();
                        if (keys != null && (iterator = keys.iterator()) != null) {
                            while (iterator.hasNext()) {
                                InitialDirContext tempContext = (InitialDirContext)iterator.next();
                                if (!((ConnectionPostIt)this.mList.get(tempContext)).hasExpired()) continue;
                                this.mList.remove(tempContext);
                                LDAPDataSourceConnectionPool.this.mOpenCount--;
                                LDAPDataSourceConnectionPool.this.mUsedCount--;
                            }
                        }
                        Thread.sleep(this.mInterval);
                    }
                }
                catch (InterruptedException ex) {
                    if (!trace.beInfo()) break block5;
                    StringBuffer sb = new StringBuffer();
                    sb.append("Interrrupted exception while connection list monitor is running");
                    sb.append(" [Exeption: ").append(ex.getMessage()).append("]");
                    trace.infoT("ConnectionListMonitor.run", sb.toString());
                }
            }
        }
    }

    public static class ServerNotAvailableException
    extends PersistenceException {
        public ServerNotAvailableException() {
            super("no reason defined");
        }

        public ServerNotAvailableException(String message) {
            super(message);
        }
    }

    public static class ConnectionTimeoutException
    extends PersistenceException {
        public ConnectionTimeoutException() {
            super("no reason available");
        }

        public ConnectionTimeoutException(String message) {
            super(message);
        }
    }

    public class ConnectionPostIt {
        private String mDescription;
        private long mExpirationTimeMillis;

        public ConnectionPostIt(String description, long timeToExpirationMillis) {
            this.mDescription = description == null ? "No description available" : description;
            this.mExpirationTimeMillis = System.currentTimeMillis() + timeToExpirationMillis;
        }

        public String getDescription() {
            return this.mDescription;
        }

        public long getExpirationTimeMillis() {
            return this.mExpirationTimeMillis;
        }

        public boolean hasExpired() {
            return System.currentTimeMillis() >= this.mExpirationTimeMillis;
        }
    }

    public static class InitializationException
    extends Exception {
        public InitializationException() {
        }

        public InitializationException(String message) {
            super(message);
        }
    }

    private static class ConnectionWrapper {
        private InitialDirContext mContext = null;
        private long mLastAccess = 0L;
        private long mCreated = 0L;

        public ConnectionWrapper(InitialDirContext context) {
            this.mContext = context;
            this.mCreated = this.mLastAccess = System.currentTimeMillis();
        }

        public long getCreated() {
            return this.mCreated;
        }

        public long getLastAccess() {
            return this.mLastAccess;
        }

        public InitialDirContext getConnection() {
            return this.mContext;
        }
    }
}

