/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp;

import com.sap.security.api.UMFactory;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.datasource.imp.DSConfigurationModel;
import com.sap.security.core.persistence.datasource.imp.DSPrincipalModel;
import com.sap.security.core.persistence.datasource.imp.JNDIUtils;
import com.sap.security.core.persistence.datasource.imp.LDAPDataSourceConnectionPool;
import com.sap.security.core.persistence.datasource.imp.LDAPMasterCheck;
import com.sap.security.core.util.IUMTrace;
import com.sap.tc.logging.Location;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;

public class LDAPConnectionManager {
    private static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/LDAPConnectionManager.java#7 $ from $DateTime: 2004/07/30 14:01:42 $ ($Change: 16956 $)";
    private static final Location myLoc = Location.getLocation((Class)(class$com$sap$security$core$persistence$datasource$imp$LDAPConnectionManager == null ? (class$com$sap$security$core$persistence$datasource$imp$LDAPConnectionManager = LDAPConnectionManager.class$("com.sap.security.core.persistence.datasource.imp.LDAPConnectionManager")) : class$com$sap$security$core$persistence$datasource$imp$LDAPConnectionManager));
    private static final String CON_POOL_NAME = "connection_pool_name";
    private static final String ACTIVE_SERVER = "active_server";
    private static final String CONTEXT_ENVIRONMENT = "context_environment";
    private static final String CON_POOL_DEFAULT_SWITCH = "ume.ldap.access.default_switch";
    private static final String THREAD_CHECKER = "ume.ldap.access.maint_check_thread";
    private boolean _initialized = false;
    private static IUMTrace _trace = null;
    private IUMParameters _props = null;
    private NameParser _parser = null;
    private Hashtable _active_pools = null;
    private ArrayList _activePoolNames = null;
    private ArrayList _inactivePoolNames = null;
    private Hashtable _activeURLs = null;
    private ArrayList _serverNames = null;
    private ArrayList _ports = null;
    private boolean _fail_over = false;
    private long _checkFailOver = 0L;
    private int _maxRetrialCount = 0;
    private boolean _refreshing = false;
    private Hashtable _switched_server = null;
    private int _connectionPoolServer = 0;
    private Hashtable _connectionPoolProps = null;
    private static LDAPConnectionManager _instance = null;
    private LDAPMasterCheck checkMaster = null;
    static /* synthetic */ Class class$com$sap$security$core$persistence$datasource$imp$LDAPConnectionManager;

    protected NameParser getParser() {
        return this._parser;
    }

    protected void initialize(DSConfigurationModel dsConf) throws PersistenceException {
        this._props = UMFactory.getProperties();
        _trace = InternalUMFactory.getTrace(VERSIONSTRING);
        if (_trace.bePath()) {
            _trace.entering("initialize", new Object[]{dsConf});
        }
        this._switched_server = new Hashtable();
        this.initConnectionPools(dsConf);
        this._initialized = true;
        if (_trace.bePath()) {
            _trace.exiting("initialize", new Boolean(true));
        }
    }

    protected InitialDirContext getConnection(String name, String type, int count) throws PersistenceException {
        LDAPConnectionManager e2;
        block45: {
            String mn = "getConnection";
            if (_trace.bePath()) {
                _trace.entering("getConnection", new Object[]{name, type, new Integer(count)});
            }
            if (!this._initialized) {
                _trace.errorT("getConnection", "LDAP connection manager not initialized, can not return a connection");
                _trace.logErrorT("LDAP connection manager not initialized, can not return a connection, recheck the configuration or the availability of the ldap server", null);
                throw new PersistenceException("LDAPConnectionManager not initialized");
            }
            try {
                LDAPConnectionManager lDAPConnectionManager = this;
                synchronized (lDAPConnectionManager) {
                    while (this._refreshing) {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException e2) {
                if (!_trace.beInfo()) break block45;
                _trace.infoT("getConnection", "interrupted exception while changing the connection pool " + e2.getMessage());
            }
        }
        if (this.checkMaster.isMasterAvailable() && this._fail_over && (Integer)this._switched_server.get(type) > 0) {
            LDAPConnectionManager lDAPConnectionManager;
            if (_trace.beInfo()) {
                _trace.infoT("getConnection", "switch to fail over before, trying to switch back to main pool");
            }
            try {
                e2 = this;
                synchronized (e2) {
                    this._refreshing = true;
                }
                this.openNewConnectionPool(type, true);
                Object var9_11 = null;
                lDAPConnectionManager = this;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                LDAPConnectionManager lDAPConnectionManager2 = this;
                synchronized (lDAPConnectionManager2) {
                    this._refreshing = false;
                    this.notifyAll();
                }
                throw throwable;
            }
            synchronized (lDAPConnectionManager) {
                this._refreshing = false;
                this.notifyAll();
            }
            return ((LDAPDataSourceConnectionPool)this._active_pools.get(type)).getConnection(name);
        }
        if (this._fail_over && this._maxRetrialCount > 0 && count >= this._maxRetrialCount) {
            LDAPConnectionManager lDAPConnectionManager;
            if (_trace.beWarning()) {
                _trace.warningT("getConnection", "trying to switch to fail over pool, because of " + count + " unsuccessful actions");
            }
            try {
                e2 = this;
                synchronized (e2) {
                    this._refreshing = true;
                }
                this.openNewConnectionPool(type, false);
                Object var14_19 = null;
                lDAPConnectionManager = this;
            }
            catch (Throwable throwable) {
                Object var14_20 = null;
                LDAPConnectionManager lDAPConnectionManager3 = this;
                synchronized (lDAPConnectionManager3) {
                    this._refreshing = false;
                    this.notifyAll();
                }
                throw throwable;
            }
            synchronized (lDAPConnectionManager) {
                this._refreshing = false;
                this.notifyAll();
            }
            return ((LDAPDataSourceConnectionPool)this._active_pools.get(type)).getConnection(name);
        }
        try {
            return ((LDAPDataSourceConnectionPool)this._active_pools.get(type)).getConnection(name);
        }
        catch (PersistenceException e3) {
            LDAPConnectionManager lDAPConnectionManager;
            if (_trace.beWarning()) {
                _trace.warningT("getConnection", "Exception while getting connection from active pool, switch to fail over server", (Throwable)((Object)e3));
                StringBuffer sb = new StringBuffer();
                sb.append("Can not get new connection from connection pool");
                sb.append(", please check your directory server");
                sb.append(", try to a failover connection pool if available");
                _trace.logWarningT(sb.toString(), null);
            }
            try {
                LDAPConnectionManager lDAPConnectionManager4 = this;
                synchronized (lDAPConnectionManager4) {
                    this._refreshing = true;
                }
                _trace.infoT("getConnection", "trying to open fail over pool");
                this.openNewConnectionPool(type, false);
                Object var19_27 = null;
                lDAPConnectionManager = this;
            }
            catch (Throwable throwable) {
                Object var19_28 = null;
                LDAPConnectionManager lDAPConnectionManager5 = this;
                synchronized (lDAPConnectionManager5) {
                    this._refreshing = false;
                    this.notifyAll();
                }
                throw throwable;
            }
            synchronized (lDAPConnectionManager) {
                this._refreshing = false;
                this.notifyAll();
            }
            return ((LDAPDataSourceConnectionPool)this._active_pools.get(type)).getConnection(name);
        }
    }

    protected void releaseConnection(String type, InitialDirContext connection, boolean destroy) throws PersistenceException {
        block29: {
            String name;
            block28: {
                block27: {
                    if (_trace.bePath()) {
                        _trace.entering("releaseConnection", new Object[]{type, connection, new Boolean(destroy)});
                    }
                    try {
                        LDAPConnectionManager lDAPConnectionManager = this;
                        synchronized (lDAPConnectionManager) {
                            while (this._refreshing) {
                                this.wait();
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        if (!_trace.beWarning()) break block27;
                        _trace.warningT("releaseConnection", "interrupted connection while waiting for connection pool refresh", e);
                    }
                }
                if (!this._initialized) {
                    throw new PersistenceException("LDAPConnectionManager not initialized");
                }
                name = null;
                try {
                    name = (String)connection.getEnvironment().get(CON_POOL_NAME);
                }
                catch (NamingException e) {
                    if (!_trace.beWarning()) break block28;
                    _trace.warningT("releaseConnection", "error while getting name of connection pool", e);
                }
            }
            if (name != null && this._activePoolNames.contains(name)) {
                try {
                    ((LDAPDataSourceConnectionPool)this._active_pools.get(type)).releaseConnection(connection, destroy);
                }
                catch (LDAPDataSourceConnectionPool.ServerNotAvailableException e) {
                    LDAPConnectionManager lDAPConnectionManager;
                    Object sb;
                    if (_trace.beWarning()) {
                        _trace.warningT("releaseConnection", "exception while releasing connection, switching to fail over server", (Throwable)((Object)e));
                        sb = new StringBuffer();
                        ((StringBuffer)sb).append("Can not release connection,");
                        ((StringBuffer)sb).append(" please check the availability of your directory server");
                        ((StringBuffer)sb).append(", switching to failover connection pool if available");
                        _trace.logWarningT(((StringBuffer)sb).toString(), null);
                    }
                    try {
                        sb = this;
                        synchronized (sb) {
                            this._refreshing = true;
                        }
                        this.openNewConnectionPool(type, false);
                        Object var9_13 = null;
                        lDAPConnectionManager = this;
                    }
                    catch (Throwable throwable) {
                        Object var9_14 = null;
                        LDAPConnectionManager lDAPConnectionManager2 = this;
                        synchronized (lDAPConnectionManager2) {
                            this._refreshing = false;
                            this.notifyAll();
                        }
                        throw throwable;
                    }
                    synchronized (lDAPConnectionManager) {
                        this._refreshing = false;
                        this.notifyAll();
                    }
                }
            } else {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    if (!_trace.beWarning()) break block29;
                    StringBuffer sb = new StringBuffer();
                    sb.append("Error while closing unusable connection");
                    sb.append(" Exception: ").append(e.getMessage());
                    _trace.warningT("releaseConnection", sb.toString());
                }
            }
        }
    }

    protected synchronized void releaseConnection(String type, InitialDirContext connection) throws PersistenceException {
        if (!this._initialized) {
            _trace.errorT("releaseConnection", "LDAP Connection manager is not initialized, can not release connection");
            StringBuffer sb = new StringBuffer();
            sb.append("LDAP Connection manager not initilialized,");
            sb.append(" check configuration or availability of the directory server");
            _trace.logErrorT(sb.toString(), null);
            throw new PersistenceException("LDAPConnectionManager not initialized");
        }
        this.releaseConnection(type, connection, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initConnectionPools(DSConfigurationModel dsConf) throws PersistenceException {
        String mm_socketFactory;
        int checkFailOver;
        if (_trace.bePath()) {
            _trace.entering("initConnectionPools", new Object[]{dsConf});
        }
        this._connectionPoolProps = new Hashtable();
        this._active_pools = new Hashtable();
        this._activePoolNames = new ArrayList();
        this._activeURLs = new Hashtable();
        try {
            checkFailOver = dsConf.getPrivateAttributeIntValue(CON_POOL_DEFAULT_SWITCH);
            this._checkFailOver = checkFailOver * 60 * 1000;
        }
        catch (PersistenceException e) {
            if (_trace.beInfo()) {
                StringBuffer sb = new StringBuffer();
                sb.append("Error getting int value from configuration file for ");
                sb.append(CON_POOL_DEFAULT_SWITCH);
                sb.append(" Exception: ").append(e.getMessage());
                _trace.infoT("initConnectionPools", sb.toString());
            }
            int checkFailOver2 = this._props.getNumber(CON_POOL_DEFAULT_SWITCH, 10);
            this._checkFailOver = checkFailOver2 * 60 * 1000;
        }
        if (this._checkFailOver < 0L) {
            checkFailOver = this._props.getNumber(CON_POOL_DEFAULT_SWITCH, 10);
            this._checkFailOver = checkFailOver * 60 * 1000;
        }
        Hashtable<String, Object> _configParams = new Hashtable<String, Object>();
        int conPoolMinSize = dsConf.getPrivateAttributeIntValue("ume.ldap.connection_pool.min_size");
        if (conPoolMinSize == -1) {
            conPoolMinSize = this._props.getNumber("ume.ldap.connection_pool.min_size", 1);
        }
        _configParams.put("ume.ldap.connection_pool.min_size", new Integer(conPoolMinSize));
        int conPoolMaxSize = dsConf.getPrivateAttributeIntValue("ume.ldap.connection_pool.max_size");
        if (conPoolMaxSize == -1) {
            conPoolMaxSize = this._props.getNumber("ume.ldap.connection_pool.max_size", 10);
        }
        _configParams.put("ume.ldap.connection_pool.max_size", new Integer(conPoolMaxSize));
        int conPoolMaxIdleConnections = dsConf.getPrivateAttributeIntValue("ume.ldap.connection_pool.max_idle_connections");
        if (conPoolMaxIdleConnections == -1) {
            conPoolMaxIdleConnections = this._props.getNumber("ume.ldap.connection_pool.max_idle_connections", 5);
        }
        _configParams.put("ume.ldap.connection_pool.max_idle_connections", new Integer(conPoolMaxIdleConnections));
        int conPoolMaxIdleTime = dsConf.getPrivateAttributeIntValue("ume.ldap.connection_pool.idle_time");
        if (conPoolMaxIdleTime == -1) {
            conPoolMaxIdleTime = this._props.getNumber("ume.ldap.connection_pool.idle_time", 300000);
        }
        _configParams.put("ume.ldap.connection_pool.idle_time", new Integer(conPoolMaxIdleTime));
        int conPoolMaxWaitTime = dsConf.getPrivateAttributeIntValue("ume.ldap.connection_pool.max_wait_time");
        if (conPoolMaxWaitTime == -1) {
            conPoolMaxWaitTime = this._props.getNumber("ume.ldap.connection_pool.max_wait_time", 60000);
        }
        _configParams.put("ume.ldap.connection_pool.max_wait_time", new Integer(conPoolMaxWaitTime));
        int conPoolMonitorInterval = dsConf.getPrivateAttributeIntValue("ume.ldap.connection_pool.monitor_level");
        if (conPoolMonitorInterval == -1) {
            conPoolMonitorInterval = this._props.getNumber("ume.ldap.connection_pool.monitor_level", 0);
        }
        _configParams.put("ume.ldap.connection_pool.monitor_level", new Integer(conPoolMonitorInterval));
        int conPoolRetrial = dsConf.getPrivateAttributeIntValue("ume.ldap.connection_pool.retrial");
        if (conPoolRetrial == -1) {
            conPoolRetrial = this._props.getNumber("ume.ldap.connection_pool.retrial", 5);
        }
        _configParams.put("ume.ldap.connection_pool.retrial", new Integer(conPoolRetrial));
        int conPoolRetrialInterval = dsConf.getPrivateAttributeIntValue("ume.ldap.connection_pool.retrial_interval");
        if (conPoolRetrialInterval == -1) {
            conPoolRetrialInterval = this._props.getNumber("ume.ldap.connection_pool.retrial_interval", 10000);
        }
        _configParams.put("ume.ldap.connection_pool.retrial_interval", new Integer(conPoolRetrialInterval));
        int conPoolReleaseCheckInterval = dsConf.getPrivateAttributeIntValue("ume.ldap.connection_pool.release_check_interval");
        if (conPoolReleaseCheckInterval == -1) {
            conPoolReleaseCheckInterval = this._props.getNumber("ume.ldap.connection_pool.release_check_interval", 120000);
        }
        _configParams.put("ume.ldap.connection_pool.release_check_interval", new Integer(conPoolReleaseCheckInterval));
        int conPoolTimeoutConnection = dsConf.getPrivateAttributeIntValue("ume.ldap.connection_pool.connection_timeout");
        if (conPoolTimeoutConnection == -1) {
            conPoolTimeoutConnection = this._props.getNumber("ume.ldap.connection_pool.connection_timeout", 0);
        }
        _configParams.put("ume.ldap.connection_pool.connection_timeout", new Integer(conPoolTimeoutConnection));
        int conPoolConnectTimout = dsConf.getPrivateAttributeIntValue("ume.ldap.connection_pool.connect_timeout");
        if (conPoolConnectTimout == -1) {
            conPoolConnectTimout = this._props.getNumber("ume.ldap.connection_pool.connect_timeout", 0);
        }
        _configParams.put("ume.ldap.connection_pool.connect_timeout", new Integer(conPoolConnectTimout));
        String _serverName = dsConf.getPrivateAttribute("ume.ldap.access.server_name");
        if (_serverName == null) {
            _serverName = this._props.get("ume.ldap.access.server_name");
        }
        this._serverNames = JNDIUtils.getArrayListFromString(_serverName, ",");
        String _port = dsConf.getPrivateAttribute("ume.ldap.access.server_port");
        if (_port == null) {
            _port = this._props.get("ume.ldap.access.server_port");
        }
        this._ports = JNDIUtils.getArrayListFromString(_port, ",");
        if (this._serverNames.size() != this._ports.size()) {
            StringBuffer sb = new StringBuffer();
            sb.append("Amount of server ").append(this._serverNames.size());
            sb.append(" differs from amout of ports ").append(this._ports.size());
            _trace.errorT("initialize", sb.toString());
            sb.append(" please check the LDAP configuration");
            _trace.logErrorT(sb.toString(), null);
            throw new PersistenceException("Amount of servers differ from amount of ports in the configuration");
        }
        _configParams.put("ume.ldap.access.server_name", this._serverNames);
        _configParams.put("ume.ldap.access.server_port", this._ports);
        if (this._serverNames.size() > 1) {
            this._fail_over = true;
            try {
                this._maxRetrialCount = dsConf.getPrivateAttributeIntValue("ume.ldap.access.action_retrial");
            }
            catch (PersistenceException e) {
                if (_trace.beInfo()) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("Exception when getting private int attribute from configuration file ");
                    sb.append("ume.ldap.access.action_retrial").append(" Exception: ");
                    sb.append(e.getMessage());
                    _trace.infoT("initConnectionPools", sb.toString());
                }
                this._maxRetrialCount = this._props.getNumber("ume.ldap.access.action_retrial", 0);
            }
        }
        boolean mm_sslEnabled = false;
        try {
            mm_sslEnabled = dsConf.getPrivateAttributeBooleanValue("ume.ldap.access.ssl");
        }
        catch (PersistenceException e) {
            if (_trace.beInfo()) {
                StringBuffer sb = new StringBuffer();
                sb.append("Exception when getting private boolean attribute from configuration file ");
                sb.append("ume.ldap.access.ssl").append(" Exception: ");
                sb.append(e.getMessage());
                _trace.infoT("initConnectionPools", sb.toString());
            }
            mm_sslEnabled = this._props.getBoolean("ume.ldap.access.ssl", false);
        }
        _configParams.put("ume.ldap.access.ssl", new Boolean(mm_sslEnabled));
        String serverUser = null;
        String serverUserPwd = null;
        serverUser = dsConf.getPrivateAttribute("ume.ldap.access.user");
        if (serverUser == null) {
            serverUser = this._props.get("ume.ldap.access.user");
        }
        if ((serverUserPwd = dsConf.getPrivateAttribute("ume.ldap.access.password")) == null) {
            serverUserPwd = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return LDAPConnectionManager.this._props.getPassword("ume.ldap.access.password");
                }
            });
        } else if (serverUserPwd.startsWith("$ume.ldap.access.additional_password.")) {
            final String propName = new String(serverUserPwd.substring(1, serverUserPwd.length()));
            if (_trace.beInfo()) {
                _trace.infoT("initConnectionPools", "trying to get password for ldap bind with property " + propName);
            }
            serverUserPwd = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return LDAPConnectionManager.this._props.getPassword(propName);
                }
            });
        } else {
            _trace.infoT("initConnectionPools", "incorrect property for ldap password " + serverUserPwd);
        }
        _configParams.put("ume.ldap.access.user", serverUser);
        _configParams.put("ume.ldap.access.password", serverUserPwd);
        if (serverUser.length() == 0 && serverUserPwd.length() == 0 && _trace.beWarning()) {
            _trace.warningT("initConnectionPools", "can not read the user and password for the connection to the ldap server; using an anonymous connection");
        }
        if ((mm_socketFactory = dsConf.getPrivateAttribute("ume.ldap.access.context_factory")) == null) {
            mm_socketFactory = this._props.get("ume.ldap.access.context_factory", "com.sun.jndi.ldap.LdapCtxFactory");
        }
        _configParams.put("ume.ldap.access.context_factory", mm_socketFactory);
        String auth = dsConf.getPrivateAttribute("ume.ldap.access.authentication");
        if (auth == null) {
            auth = this._props.get("ume.ldap.access.authentication", "simple");
        }
        _configParams.put("ume.ldap.access.authentication", auth);
        boolean mm_userAsUseraccount = false;
        try {
            mm_userAsUseraccount = dsConf.getPrivateAttributeBooleanValue("ume.ldap.access.user_as_account");
        }
        catch (PersistenceException pe) {
            if (_trace.beInfo()) {
                StringBuffer sb = new StringBuffer();
                sb.append("Exception when getting private boolean attribute from configuration file ");
                sb.append("ume.ldap.access.user_as_account").append(" Exception: ");
                sb.append(pe.getMessage());
                _trace.infoT("initConnectionPools", sb.toString());
            }
            mm_userAsUseraccount = this._props.getBoolean("ume.ldap.access.user_as_account", true);
        }
        Vector allPrincipalTypes = new Vector(dsConf.getResponsibleFor().values());
        int i = 0;
        while (true) {
            block81: {
                Object var44_52;
                ClassLoader cl;
                block79: {
                    int cTimeOut;
                    if (i >= allPrincipalTypes.size()) {
                        return;
                    }
                    Hashtable newConfigParams = (Hashtable)_configParams.clone();
                    DSPrincipalModel prinMod = (DSPrincipalModel)allPrincipalTypes.get(i);
                    String prinType = prinMod.getType();
                    String path = dsConf.getPrivateAttribute("ume.ldap.access.base_path." + prinType.toLowerCase());
                    if (path == null) {
                        path = this._props.get("ume.ldap.access.base_path." + prinType.toLowerCase(), "");
                    }
                    if (mm_userAsUseraccount && prinType.equals("UACC") && (path = dsConf.getPrivateAttribute("ume.ldap.access.base_path." + "USER".toLowerCase())) == null) {
                        path = this._props.get("ume.ldap.access.base_path." + "USER".toLowerCase(), "");
                    }
                    path = JNDIUtils.trimDN(path);
                    path = JNDIUtils.escapeBlankCharacter(path);
                    newConfigParams.put("ume.ldap.access.base_path.", path);
                    newConfigParams.put(ACTIVE_SERVER, new Integer(0));
                    StringBuffer sb = new StringBuffer();
                    sb.append("ldap://").append(this._serverNames.get(0)).append(":").append(this._ports.get(0));
                    if (path != null || path.length() > 0) {
                        sb.append("/").append(path);
                    }
                    if (_trace.beInfo()) {
                        _trace.infoT("initConnectionPools", "open connection for " + prinType + " with url " + sb.toString());
                    }
                    StringBuffer conPoolName = new StringBuffer();
                    conPoolName.append(this._serverNames.get(0)).append(":").append(this._ports.get(0)).append("_").append(prinType);
                    Hashtable<String, Object> env = new Hashtable<String, Object>();
                    env.put("java.naming.ldap.version", "3");
                    env.put("java.naming.factory.initial", mm_socketFactory);
                    env.put("java.naming.security.authentication", auth);
                    if (!serverUser.equals("") && !serverUserPwd.equals("")) {
                        env.put("java.naming.security.principal", serverUser);
                        env.put("java.naming.security.credentials", serverUserPwd);
                        if (_trace.beInfo()) {
                            _trace.infoT("initConnectionPool", "no anonymous bind to the ldap server");
                        }
                    } else if (_trace.beWarning()) {
                        _trace.warningT("initConnectionPool", "Please recheck ldap credentials, provided user and password can lead to an anonymous bind with restricted access");
                    }
                    if (mm_sslEnabled) {
                        String sslSocketFactory = dsConf.getPrivateAttribute("ume.ldap.access.ssl_socket_factory");
                        if (sslSocketFactory == null) {
                            sslSocketFactory = this._props.get("ume.ldap.access.ssl_socket_factory", "com.sap.security.ssl.SSLSocketFactory");
                        }
                        newConfigParams.put("ume.ldap.access.ssl_socket_factory", sslSocketFactory);
                        env.put("java.naming.security.protocol", "ssl");
                        env.put("java.naming.ldap.factory.socket", sslSocketFactory);
                        _trace.infoT("initConnectionPools", "using ssl connections");
                        if (System.getProperty("LDAP_DEBUG") != null) {
                            env.put("com.sun.jndi.ldap.trace.ber", System.err);
                            if (_trace.beInfo()) {
                                _trace.infoT("initConnectionPools", "ssl tracing is activated");
                            }
                        }
                    }
                    if ((cTimeOut = ((Integer)_configParams.get("ume.ldap.connection_pool.connect_timeout")).intValue()) > 0) {
                        if (_trace.beDebug()) {
                            _trace.debugT("initConnectionPools", "connect time out set of " + cTimeOut + " ms");
                        }
                        env.put("com.sun.jndi.ldap.connect.timeout", "" + cTimeOut);
                    }
                    newConfigParams.put(CONTEXT_ENVIRONMENT, env);
                    newConfigParams.put(ACTIVE_SERVER, new Integer(0));
                    env.put("java.naming.provider.url", sb.toString());
                    env.put(CON_POOL_NAME, conPoolName.toString());
                    this._connectionPoolProps.put(prinType, newConfigParams);
                    boolean threadCheck = false;
                    try {
                        threadCheck = dsConf.getPrivateAttributeBooleanValue(THREAD_CHECKER);
                    }
                    catch (Exception e) {
                        if (_trace.beInfo()) {
                            StringBuffer _sb = new StringBuffer();
                            _sb.append("Exception when getting private boolean attribute from configuration file ");
                            _sb.append(THREAD_CHECKER).append(" Exception: ");
                            _sb.append(e.getMessage());
                            _trace.infoT("initConnectionPools", _sb.toString());
                        }
                        threadCheck = this._props.getBoolean(THREAD_CHECKER, false);
                    }
                    if (_trace.beInfo()) {
                        _trace.infoT("initConnectionPools", "check main server with thread (if defined) :" + threadCheck);
                    }
                    if (this.checkMaster == null) {
                        this.checkMaster = new LDAPMasterCheck(env, this._checkFailOver, threadCheck);
                    }
                    cl = Thread.currentThread().getContextClassLoader();
                    try {
                        Enumeration allKeys;
                        StringBuffer messageText;
                        Exception e2;
                        block80: {
                            try {
                                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                                LDAPDataSourceConnectionPool connectionPool = null;
                                connectionPool = conPoolMinSize == -1 || conPoolMaxSize == -1 || conPoolMaxIdleTime == -1 || conPoolMaxIdleConnections == -1 || conPoolMaxWaitTime == -1 ? new LDAPDataSourceConnectionPool(conPoolName.toString(), conPoolTimeoutConnection, env, conPoolRetrial, conPoolRetrialInterval, conPoolReleaseCheckInterval) : (conPoolMonitorInterval == -1 ? new LDAPDataSourceConnectionPool(conPoolName.toString(), conPoolMinSize, conPoolMaxSize, conPoolMaxIdleConnections, conPoolMaxIdleTime, conPoolMaxWaitTime, conPoolTimeoutConnection, env, conPoolRetrial, conPoolRetrialInterval, conPoolReleaseCheckInterval) : new LDAPDataSourceConnectionPool(conPoolName.toString(), conPoolMinSize, conPoolMaxSize, conPoolMaxIdleConnections, conPoolMaxIdleTime, conPoolMaxWaitTime, conPoolTimeoutConnection, env, conPoolMonitorInterval, conPoolRetrial, conPoolRetrialInterval, conPoolReleaseCheckInterval));
                                if (_trace.beInfo()) {
                                    _trace.infoT("initConnectionPool", "instantiate central name parser");
                                }
                                if (this._parser == null) {
                                    Object var37_49;
                                    InitialDirContext ctx = connectionPool.getConnection("init central name parser");
                                    try {
                                        this._parser = ctx.getNameParser("");
                                        var37_49 = null;
                                        connectionPool.releaseConnection(ctx);
                                    }
                                    catch (Throwable throwable) {
                                        var37_49 = null;
                                        connectionPool.releaseConnection(ctx);
                                        throw throwable;
                                    }
                                }
                                this._active_pools.put(prinType, connectionPool);
                                this._activePoolNames.add(conPoolName.toString());
                                this._activeURLs.put(prinType, sb.toString());
                                if (_trace.beInfo()) {
                                    _trace.infoT("initConnectionPool", "connection pool instantiated for " + prinType);
                                }
                                this._switched_server.put(prinType, new Integer(0));
                            }
                            catch (Exception e2) {
                                myLoc.traceThrowableT(500, "initConnectionPool", "connection pool for principal type {0} fails", new Object[]{prinType}, (Throwable)e2);
                                StringBuffer _sb = new StringBuffer();
                                _sb.append("Initialisation of a connection pool failed for ").append(prinType);
                                _sb.append(" please check the configuration or availability of the directory server");
                                _trace.logFatalT(_sb.toString(), null);
                                if (this._fail_over) {
                                    LDAPConnectionManager lDAPConnectionManager;
                                    Object var40_50;
                                    try {
                                        LDAPConnectionManager lDAPConnectionManager2 = this;
                                        synchronized (lDAPConnectionManager2) {
                                            this._refreshing = true;
                                        }
                                        this.openNewConnectionPool(prinType, false);
                                        var40_50 = null;
                                        lDAPConnectionManager = this;
                                    }
                                    catch (Throwable throwable) {
                                        var40_50 = null;
                                        lDAPConnectionManager = this;
                                        synchronized (lDAPConnectionManager) {
                                            this._refreshing = false;
                                            this.notifyAll();
                                            throw throwable;
                                        }
                                    }
                                    synchronized (lDAPConnectionManager) {
                                        this._refreshing = false;
                                        this.notifyAll();
                                        break block79;
                                    }
                                }
                                messageText = new StringBuffer();
                                messageText.append("Initialisation of connection pool failed for ").append(prinType);
                                messageText.append("\n\tpoolname ").append(conPoolName.toString());
                                allKeys = env.keys();
                                break block80;
                            }
                            var44_52 = null;
                            Thread.currentThread().setContextClassLoader(cl);
                            break block81;
                        }
                        while (true) {
                            if (!allKeys.hasMoreElements()) {
                                messageText.append("\n\t[EXCEPTION: ").append(e2.getMessage()).append("]");
                                _trace.logFatalT("Please recheck the LDAP configuration " + messageText.toString(), null);
                                myLoc.errorT("initConnectionPool", "LDAP configuration details, please check it \n" + messageText.toString());
                                throw new PersistenceException(messageText.toString());
                            }
                            String key = (String)allKeys.nextElement();
                            Object entry = env.get(key);
                            if (key.equalsIgnoreCase("java.naming.security.credentials")) {
                                messageText.append("\n\t").append(key).append("= ").append("******");
                                continue;
                            }
                            messageText.append("\n\t").append(key).append("= ").append(entry);
                        }
                    }
                    catch (Throwable throwable) {
                        var44_52 = null;
                        Thread.currentThread().setContextClassLoader(cl);
                        throw throwable;
                    }
                }
                var44_52 = null;
                Thread.currentThread().setContextClassLoader(cl);
            }
            ++i;
        }
    }

    protected String getActiveURL(String type) {
        _trace.entering("getActiveURL");
        try {
            LDAPConnectionManager lDAPConnectionManager = this;
            synchronized (lDAPConnectionManager) {
                while (this._refreshing) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException e) {
            _trace.warningT("getActiveURL", "interrupted exception while waiting for pool refresh ", e);
        }
        return (String)this._activeURLs.get(type);
    }

    /*
     * Unable to fully structure code
     */
    private void openNewConnectionPool(String type, boolean mainPool) throws PersistenceException {
        if (mainPool && !this.checkMaster.isMasterAvailable()) {
            return;
        }
        if (LDAPConnectionManager._trace.bePath()) {
            LDAPConnectionManager._trace.entering("openNewConnectionPool", new Object[]{type, new Boolean(mainPool)});
        }
        _oldCP = (LDAPDataSourceConnectionPool)this._active_pools.get(type);
        _newCP = null;
        _newURL = null;
        _newConPoolName = null;
        configParams = (Hashtable)this._connectionPoolProps.get(type);
        conPoolMinSize = (Integer)configParams.get("ume.ldap.connection_pool.min_size");
        conPoolMaxSize = (Integer)configParams.get("ume.ldap.connection_pool.max_size");
        conPoolMaxIdleTime = (Integer)configParams.get("ume.ldap.connection_pool.idle_time");
        conPoolMaxIdleConnections = (Integer)configParams.get("ume.ldap.connection_pool.max_idle_connections");
        conPoolMaxWaitTime = (Integer)configParams.get("ume.ldap.connection_pool.max_wait_time");
        conPoolRetrial = (Integer)configParams.get("ume.ldap.connection_pool.retrial");
        conPoolRetrialInterval = (Integer)configParams.get("ume.ldap.connection_pool.retrial_interval");
        conPoolReleaseCheckInterval = (Integer)configParams.get("ume.ldap.connection_pool.release_check_interval");
        conPoolMonitorInterval = (Integer)configParams.get("ume.ldap.connection_pool.monitor_level");
        conPoolTimeoutConnection = (Integer)configParams.get("ume.ldap.connection_pool.connection_timeout");
        serverNames = (ArrayList)configParams.get("ume.ldap.access.server_name");
        serverPorts = (ArrayList)configParams.get("ume.ldap.access.server_port");
        activeServer = (Integer)configParams.get("active_server");
        i = 0;
        while (i < serverNames.size()) {
            block31: {
                block32: {
                    ++activeServer;
                    if (mainPool) {
                        activeServer = 0;
                    }
                    if (activeServer == serverNames.size()) {
                        LDAPConnectionManager._trace.warningT("openNewConnectionPool", "last fail over server reached, trying to get connection to the main server");
                        activeServer = 0;
                    }
                    configParams.put("active_server", new Integer(activeServer));
                    _newConPoolName = new StringBuffer();
                    _newConPoolName.append(serverNames.get(activeServer)).append(":");
                    _newConPoolName.append(serverPorts.get(activeServer)).append("_").append(type);
                    configParams.put("active_server", new Integer(activeServer));
                    path = (String)configParams.get("ume.ldap.access.base_path.");
                    _newURL = new StringBuffer();
                    _newURL.append("ldap://").append(this._serverNames.get(activeServer)).append(":").append(this._ports.get(activeServer));
                    if (path != null || path.length() > 0) {
                        _newURL.append("/").append(path);
                    }
                    if (LDAPConnectionManager._trace.beWarning()) {
                        LDAPConnectionManager._trace.warningT("openNewConnectionPool", "tyring to open a new pool for " + type + " with url " + _newURL);
                    }
                    env = (Hashtable)configParams.get("context_environment");
                    cTimeOut = (Integer)configParams.get("ume.ldap.connection_pool.connect_timeout");
                    if (cTimeOut > 0) {
                        if (LDAPConnectionManager._trace.beDebug()) {
                            LDAPConnectionManager._trace.debugT("openNewConnectionPool", "connect time out set " + cTimeOut + " ms");
                        }
                        env.put("com.sun.jndi.ldap.connect.timeout", "" + cTimeOut);
                    }
                    env.put("java.naming.provider.url", _newURL.toString());
                    env.put("connection_pool_name", _newConPoolName.toString());
                    cl = Thread.currentThread().getContextClassLoader();
                    try {
                        try {
                            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                            _newCP = conPoolMinSize == -1 || conPoolMaxSize == -1 || conPoolMaxIdleTime == -1 || conPoolMaxIdleConnections == -1 || conPoolMaxWaitTime == -1 ? new LDAPDataSourceConnectionPool(_newConPoolName.toString(), conPoolTimeoutConnection, env, conPoolRetrial, conPoolRetrialInterval, conPoolReleaseCheckInterval) : (conPoolMonitorInterval == -1 ? new LDAPDataSourceConnectionPool(_newConPoolName.toString(), conPoolMinSize, conPoolMaxSize, conPoolMaxIdleConnections, conPoolMaxIdleTime, conPoolMaxWaitTime, conPoolTimeoutConnection, env, conPoolRetrial, conPoolRetrialInterval, conPoolReleaseCheckInterval) : new LDAPDataSourceConnectionPool(_newConPoolName.toString(), conPoolMinSize, conPoolMaxSize, conPoolMaxIdleConnections, conPoolMaxIdleTime, conPoolMaxWaitTime, conPoolTimeoutConnection, env, conPoolMonitorInterval, conPoolRetrial, conPoolRetrialInterval, conPoolReleaseCheckInterval));
                            if (LDAPConnectionManager._trace.beInfo()) {
                                LDAPConnectionManager._trace.infoT("initConnectionPool", "instantiate central name parser");
                            }
                            if (this._parser == null) {
                                ctx = _newCP.getConnection("init central name parser");
                                try {
                                    this._parser = ctx.getNameParser("");
                                    var28_31 = null;
                                    _newCP.releaseConnection(ctx);
                                }
                                catch (Throwable var27_29) {
                                    var28_31 = null;
                                    _newCP.releaseConnection(ctx);
                                    throw var27_29;
                                }
                            }
                            if (LDAPConnectionManager._trace.beInfo()) {
                                LDAPConnectionManager._trace.infoT("initConnectionPool", "connection pool instantiated for " + type);
                            }
                            if (mainPool || activeServer == 0) {
                                this._switched_server.put(type, new Integer(0));
                            } else {
                                this._switched_server.put(type, new Integer(activeServer));
                            }
                            if (activeServer != 0) {
                                this.checkMaster.startCheck();
                            } else {
                                this.checkMaster.stopCheck();
                            }
                            if (_newCP != null) {
                                var34_34 = null;
                                Thread.currentThread().setContextClassLoader(cl);
                                break;
                            }
                            var34_34 = null;
                            Thread.currentThread().setContextClassLoader(cl);
                            break block31;
                        }
                        catch (LDAPDataSourceConnectionPool.ServerNotAvailableException e) {
                            messageText = new StringBuffer();
                            messageText.append("Initialisation of connection pool failed for ").append(type);
                            messageText.append("\nServer not available, please check configuration and ");
                            messageText.append("availability of directory server, ");
                            messageText.append("switching to a default directory server.");
                            messageText.append("\n\tpoolname ").append(_newConPoolName.toString());
                            allKeys = env.keys();
                            ** while (allKeys.hasMoreElements())
                        }
lbl-1000:
                        // 1 sources

                        {
                            key = (String)allKeys.nextElement();
                            entry = env.get(key);
                            if (key.equalsIgnoreCase("java.naming.security.credentials")) {
                                messageText.append("\n\t").append(key).append("= ").append("******");
                                continue;
                            }
                            messageText.append("\n\t").append(key).append("= ").append(entry);
                            continue;
                        }
lbl123:
                        // 1 sources

                        messageText.append("\n\t[EXCEPTION: ").append(e.getMessage()).append("]");
                        LDAPConnectionManager._trace.errorT("openNewConnectionPool", messageText.toString());
                        if (!mainPool) break block32;
                    }
                    catch (Throwable var33_37) {
                        var34_34 = null;
                        Thread.currentThread().setContextClassLoader(cl);
                        throw var33_37;
                    }
                    var34_34 = null;
                    Thread.currentThread().setContextClassLoader(cl);
                    {
                        break;
                    }
                }
                var34_34 = null;
                Thread.currentThread().setContextClassLoader(cl);
                {
                    break block31;
                    catch (Exception e) {
                        LDAPConnectionManager.myLoc.errorT("openNewConnectionPool", "connection pool for principal type " + type + " fails [cause:" + e.getMessage() + "]");
                        sb = new StringBuffer();
                        sb.append("Can not open new connection pool for ").append(type);
                        sb.append(", please check configuration or availability of directory server");
                        LDAPConnectionManager._trace.logFatalT(sb.toString(), null);
                        messageText = new StringBuffer();
                        messageText.append("Initialisation of connection pool failed for ").append(type);
                        messageText.append("\n\tpoolname ").append(_newConPoolName.toString());
                        allKeys = env.keys();
                        ** while (allKeys.hasMoreElements())
                    }
lbl-1000:
                    // 1 sources

                    {
                        key = (String)allKeys.nextElement();
                        entry = env.get(key);
                        if (key.equalsIgnoreCase("java.naming.security.credentials")) {
                            messageText.append("\n\t").append(key).append("= ").append("******");
                            continue;
                        }
                        messageText.append("\n\t").append(key).append("= ").append(entry);
                        continue;
                    }
lbl160:
                    // 1 sources

                    messageText.append("\n\t[EXCEPTION: ").append(e.getMessage()).append("]");
                    LDAPConnectionManager.myLoc.errorT("openNewConnectionPool", messageText.toString());
                    LDAPConnectionManager._trace.logFatalT(messageText.toString(), null);
                    throw new PersistenceException(messageText.toString());
                }
            }
            ++i;
        }
        if (_newCP == null) {
            if (!mainPool) {
                messageText = new StringBuffer();
                messageText.append("Initialisation of connection pool failed for ").append(type);
                messageText.append("\n\tpoolname ").append(_newConPoolName.toString());
                messageText.append("\n\t[EXCEPTION: ").append("no connection to any server possible");
                messageText.append("]");
                LDAPConnectionManager.myLoc.errorT("openNewConnectionPool", messageText.toString());
                LDAPConnectionManager._trace.logFatalT(messageText.toString(), null);
                throw new PersistenceException(messageText.toString());
            }
        } else {
            this._active_pools.remove(type);
            this._activePoolNames.remove(_oldCP);
            this._activeURLs.remove(type);
            configParams.put("active_server", new Integer(activeServer));
            this._active_pools.put(type, _newCP);
            this._activePoolNames.add(_newConPoolName.toString());
            this._activeURLs.put(type, _newURL.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

