/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp;

import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.util.IUMTrace;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.Name;

public class JNDIUtils {
    private static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/JNDIUtils.java#5 $ from $DateTime: 2004/07/30 14:01:42 $ ($Change: 16956 $)";
    private static IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/JNDIUtils.java#5 $ from $DateTime: 2004/07/30 14:01:42 $ ($Change: 16956 $)");
    private static final char[] specialCharactersDN = new char[]{'/', '+', '>', '<', '#', ';'};
    private static final char[] specialCharactersValue = new char[]{'\\'};
    private static final int FOR_DN = 0;
    private static final int FOR_VAL = 1;
    private static final char escapeCharacter = '\\';
    private static final String MSADS = "MSADS";

    protected JNDIUtils() {
    }

    protected static String unescapeDistinguishedName(String name) {
        String sep = ",";
        if (name == null) {
            return null;
        }
        if (name.length() == 0) {
            return "";
        }
        StringTokenizer tokenizer = new StringTokenizer(name, "=", false);
        StringBuffer newDN = new StringBuffer();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int idx = token.lastIndexOf(",");
            if (idx != -1) {
                String firstPart = token.substring(0, idx);
                String lastPart = token.substring(idx, token.length());
                newDN.append(JNDIUtils.unescapeSpecialCharacter(firstPart, 0));
                newDN.append(lastPart);
                newDN.append("=");
                continue;
            }
            newDN.append(JNDIUtils.unescapeSpecialCharacter(token, 0));
            newDN.append("=");
        }
        if (newDN.charAt(newDN.length() - 1) == '=') {
            newDN.deleteCharAt(newDN.length() - 1);
        }
        return newDN.toString();
    }

    protected static String removeQuotes(String entry) {
        if (entry == null) {
            return entry;
        }
        if (entry.length() == 0) {
            return entry;
        }
        StringBuffer sb = new StringBuffer(entry);
        if (sb.charAt(0) == '\"' && sb.charAt(sb.length() - 1) == '\"') {
            sb.deleteCharAt(0);
            sb.deleteCharAt(sb.length() - 1);
            int i = 0;
            while (i < sb.length()) {
                int j = 0;
                while (j < specialCharactersDN.length) {
                    if (sb.charAt(i) == specialCharactersDN[j]) {
                        if (i > 1) {
                            if (sb.charAt(i - 1) != '\\') {
                                sb.insert(i, '\\');
                                ++i;
                            }
                        } else {
                            sb.insert(i, '\\');
                            ++i;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return sb.toString();
    }

    protected static String escapeDistinguishedName(String name) {
        String sep = ",";
        if (name == null) {
            return null;
        }
        if (name.length() == 0) {
            return name;
        }
        StringTokenizer tokenizer = new StringTokenizer(name, "=", false);
        StringBuffer newDistinguishedName = new StringBuffer();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int idx = token.lastIndexOf(",");
            if (idx != -1) {
                String firstPart = token.substring(0, idx);
                String lastPart = token.substring(idx, token.length());
                newDistinguishedName.append(JNDIUtils.escapeSpecialCharacters(firstPart, 0));
                newDistinguishedName.append(lastPart);
                newDistinguishedName.append("=");
                continue;
            }
            newDistinguishedName.append(JNDIUtils.escapeSpecialCharacters(token, 0));
            newDistinguishedName.append("=");
        }
        if (newDistinguishedName.charAt(newDistinguishedName.length() - 1) == '=') {
            newDistinguishedName.deleteCharAt(newDistinguishedName.length() - 1);
        }
        return newDistinguishedName.toString();
    }

    protected static String escForSearchFilter(String value) {
        char[] escapedCharacters = new char[]{'(', ')'};
        if (value == null) {
            return value;
        }
        if (value.length() == 0) {
            return value;
        }
        StringBuffer sb = new StringBuffer(value);
        int i = 0;
        while (i < sb.length()) {
            int j = 0;
            j = 0;
            while (j < escapedCharacters.length) {
                if (sb.charAt(i) == escapedCharacters[j]) {
                    sb.insert(i, '\\');
                    ++i;
                }
                ++j;
            }
            j = 0;
            while (j < specialCharactersDN.length) {
                if (i > 0 && sb.charAt(i) == specialCharactersDN[j] && (sb.charAt(i - 1) == '\\' || sb.charAt(i) == '\\')) {
                    sb.insert(i, '\\');
                    ++i;
                }
                ++j;
            }
            ++i;
        }
        return sb.toString();
    }

    protected static String getRelativeBase(Name entry, Name base) {
        String entryPart = null;
        String basePart = null;
        Name relName = null;
        if (entry.size() >= base.size()) {
            int i = 0;
            while (i < base.size() && relName == null) {
                entryPart = entry.get(i);
                basePart = base.get(i);
                if (!entryPart.trim().equalsIgnoreCase(basePart.trim())) {
                    relName = entry.getSuffix(i);
                }
                ++i;
            }
            if (relName == null) {
                relName = entry.getSuffix(base.size());
            }
        } else {
            relName = (Name)entry.clone();
        }
        return relName.toString();
    }

    protected static String trimDN(Name dn) {
        if (dn == null) {
            return null;
        }
        return dn.getSuffix(0).toString();
    }

    public static String trimDN(String name) {
        String sep = ",";
        if (name == null) {
            return null;
        }
        if (name.length() == 0) {
            return name;
        }
        StringTokenizer tokenizer = new StringTokenizer(name, "=", false);
        StringBuffer newDistinguishedName = new StringBuffer();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int idx = token.lastIndexOf(",");
            if (idx != -1) {
                String firstPart = token.substring(0, idx).trim();
                String lastPart = token.substring(idx + 1, token.length());
                if (tokenizer.hasMoreTokens()) {
                    lastPart = token.substring(idx + 1, token.length()).trim();
                }
                newDistinguishedName.append(firstPart).append(",");
                newDistinguishedName.append(lastPart);
                newDistinguishedName.append("=");
                continue;
            }
            newDistinguishedName.append(token.trim());
            newDistinguishedName.append("=");
        }
        if (newDistinguishedName.charAt(newDistinguishedName.length() - 1) == '=') {
            newDistinguishedName.deleteCharAt(newDistinguishedName.length() - 1);
        }
        return newDistinguishedName.toString();
    }

    protected static String traceOutPut(String base, String[] returningAttributes) {
        StringBuffer sb = new StringBuffer();
        sb.append("base :").append(base);
        sb.append("||returning attributes: ");
        int i = 0;
        while (i < returningAttributes.length) {
            sb.append(returningAttributes[i]).append("-");
            ++i;
        }
        return sb.toString();
    }

    private static String escapeSpecialCharacters(String aLiteral, int type) {
        if (aLiteral == null || aLiteral.length() == 0) {
            return aLiteral;
        }
        char[] specialCharacters = new char[]{};
        switch (type) {
            case 1: {
                specialCharacters = specialCharactersValue;
                break;
            }
            case 0: {
                specialCharacters = specialCharactersDN;
                break;
            }
            default: {
                specialCharacters = specialCharactersValue;
            }
        }
        StringBuffer sb = new StringBuffer(aLiteral);
        int i = 0;
        while (i < sb.length()) {
            char c = sb.charAt(i);
            int j = 0;
            while (j < specialCharacters.length) {
                if (c == specialCharacters[j]) {
                    sb.insert(i, '\\');
                    ++i;
                }
                ++j;
            }
            ++i;
        }
        return sb.toString();
    }

    private static String unescapeSpecialCharacter(String aLiteral, int type) {
        if (aLiteral == null || aLiteral.length() == 0) {
            return aLiteral;
        }
        char[] specialCharacters = new char[]{};
        switch (type) {
            case 0: {
                specialCharacters = specialCharactersDN;
                break;
            }
            case 1: {
                specialCharacters = specialCharactersValue;
                break;
            }
            default: {
                specialCharacters = specialCharactersDN;
            }
        }
        StringBuffer sb = new StringBuffer(aLiteral);
        int i = 0;
        while (i < sb.length()) {
            char c = sb.charAt(i);
            int j = 0;
            while (j < specialCharacters.length) {
                if (c == specialCharacters[j] && i > 0 && sb.charAt(i - 1) == '\\') {
                    sb.deleteCharAt(i - 1);
                    --i;
                }
                ++j;
            }
            ++i;
        }
        return sb.toString();
    }

    protected static String specialHandlingMSADS(String aLiteral) {
        if (aLiteral == null) {
            return aLiteral;
        }
        if (aLiteral.length() == 0) {
            return aLiteral;
        }
        StringBuffer sb = new StringBuffer(aLiteral);
        int i = 0;
        while (i < sb.length() - 1) {
            if (sb.charAt(i) == '\\') {
                if (i < sb.length() - 1 && sb.charAt(i + 1) == '\\') {
                    sb.insert(i, '\\');
                    ++i;
                    ++i;
                }
            } else if (sb.charAt(i) == '/' && i > 1 && sb.charAt(i - 1) != '\\') {
                sb.insert(i, '\\');
                ++i;
            }
            ++i;
        }
        return sb.toString();
    }

    protected static String specialHandlingBackMSADS(String aLiteral) {
        if (aLiteral == null || aLiteral.length() == 0) {
            return aLiteral;
        }
        StringBuffer sb = new StringBuffer(aLiteral);
        int i = 0;
        while (i < sb.length()) {
            if (sb.charAt(i) == '\\' && i < sb.length() - 2 && sb.charAt(i + 1) == '\\' && sb.charAt(i + 2) == '\\') {
                sb.deleteCharAt(i);
                ++i;
            }
            ++i;
        }
        return sb.toString();
    }

    protected static String escapeAttributeValue(String aLiteral) {
        if (aLiteral == null || aLiteral.length() == 0) {
            return aLiteral;
        }
        return JNDIUtils.escapeSpecialCharacters(aLiteral, 1);
    }

    protected static String unescapeAttributeValue(String aLiteral) {
        if (aLiteral == null || aLiteral.length() == 0) {
            return aLiteral;
        }
        return JNDIUtils.unescapeSpecialCharacter(aLiteral, 1);
    }

    protected static Vector getVectorFromString(String tokens, String del) {
        Vector<String> result = new Vector<String>();
        if (tokens == null || tokens.equals("") || del == null || del.equals("")) {
            return result;
        }
        StringTokenizer tokenizer = new StringTokenizer(tokens, del);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            result.add(token.toLowerCase().trim());
        }
        return result;
    }

    protected static ArrayList getArrayListFromString(String tokens, String del) {
        ArrayList<String> result = new ArrayList<String>();
        if (tokens == null || tokens.equals("") || del == null || del.equals("")) {
            return result;
        }
        StringTokenizer tokenizer = new StringTokenizer(tokens, del);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            result.add(token.toLowerCase());
        }
        return result;
    }

    protected static String escapeBackSlash(String aLiteral) {
        if (aLiteral == null || aLiteral.length() == 0) {
            return aLiteral;
        }
        StringBuffer sb = new StringBuffer(aLiteral);
        int i = 0;
        while (i < sb.length()) {
            if (sb.charAt(i) == '\\') {
                sb.insert(i, '\\');
                ++i;
            }
            ++i;
        }
        return sb.toString();
    }

    protected static String escapeBothBackSlash(String aLiteral) {
        if (aLiteral == null || aLiteral.length() == 0) {
            return aLiteral;
        }
        StringBuffer sb = new StringBuffer(aLiteral);
        int i = 0;
        i = 0;
        while (i < sb.length()) {
            if (i < sb.length() - 1 && sb.charAt(i) == '\\' && sb.charAt(i + 1) == '\\') {
                sb.insert(i, '\\');
                sb.insert(i, '\\');
                ++i;
                ++i;
            }
            ++i;
        }
        return sb.toString();
    }

    protected static String unescapeSlash(String aLiteral) {
        if (aLiteral == null || aLiteral.length() == 0) {
            return aLiteral;
        }
        StringBuffer sb = new StringBuffer(aLiteral);
        int i = 0;
        while (i < sb.length()) {
            if (sb.charAt(i) == '/' && i > 0 && sb.charAt(i - 1) == '\\') {
                sb.deleteCharAt(i - 1);
                --i;
            }
            ++i;
        }
        return sb.toString();
    }

    protected static String getServerFromURL(String url) {
        int end;
        if (url == null || url.length() == 0) {
            return url;
        }
        int start = url.indexOf("//") + 2;
        if (start > -1 && (end = url.indexOf(":", start)) > -1 && end >= start) {
            return url.substring(start, end);
        }
        return null;
    }

    protected static String getPortFromURL(String url) {
        int end;
        if (url == null || url.length() == 0) {
            return url;
        }
        int start = url.indexOf(":", url.indexOf("//")) + 1;
        if (start > -1 && (end = url.indexOf("/", start)) > -1 && end >= start) {
            return url.substring(start, end);
        }
        return null;
    }

    protected static Hashtable getDomainMapping(String mappingString) {
        if (mappingString == null || mappingString.length() == 0) {
            return null;
        }
        Hashtable<String, String> mappedDomains = new Hashtable<String, String>();
        boolean added = false;
        int sindex = mappingString.indexOf("[");
        int eindex = mappingString.indexOf("]");
        while (sindex != -1 && eindex != -1) {
            String sub = mappingString.substring(sindex + 1, eindex);
            System.out.println(sub);
            if (sub != null && sub.length() > 0) {
                StringTokenizer tokenizer = new StringTokenizer(sub, ";", false);
                while (tokenizer.hasMoreTokens()) {
                    String domainName = tokenizer.nextToken();
                    String mappedPath = tokenizer.nextToken();
                    if (tokenizer.hasMoreTokens()) {
                        if (!trace.beWarning()) continue;
                        trace.logWarningT("Invalid domain mapping: please recheck the domain mapping in the configuration xml file", null);
                        trace.warningT("getDomainMapping", "following entry when getting mapped domains will be ignored " + sub);
                        continue;
                    }
                    mappedDomains.put(domainName.toLowerCase(), mappedPath.toLowerCase());
                    added = true;
                }
            }
            mappingString = mappingString.substring(eindex + 1);
            sindex = mappingString.indexOf("[");
            eindex = mappingString.indexOf("]");
        }
        if (added) {
            return mappedDomains;
        }
        return null;
    }

    protected static String escapeBlankCharacter(String url) {
        if (url == null || url.length() == 1) {
            return "";
        }
        StringBuffer pathSB = new StringBuffer(url);
        int index = 0;
        while (index < pathSB.length()) {
            if (pathSB.charAt(index) == ' ') {
                pathSB.replace(index, index + 1, "%20");
            }
            ++index;
        }
        if (trace.beInfo()) {
            trace.infoT("escapeBlankCharacter", "converted " + url + " to " + pathSB.toString());
        }
        return pathSB.toString();
    }

    protected static String escapeComma(String aLiteral) {
        if (aLiteral == null || aLiteral.length() == 0) {
            return aLiteral;
        }
        StringBuffer sb = new StringBuffer(aLiteral);
        int i = 0;
        i = 0;
        while (i < sb.length()) {
            if (i < sb.length() - 1 && sb.charAt(i) == ',') {
                sb.insert(i, '\\');
                ++i;
            }
            ++i;
        }
        return sb.toString();
    }

    protected static String unescapeComma(String aLiteral) {
        if (aLiteral == null || aLiteral.length() == 0) {
            return aLiteral;
        }
        StringBuffer sb = new StringBuffer(aLiteral);
        int i = 0;
        while (i < sb.length()) {
            if (sb.charAt(i) == ',' && i > 0 && sb.charAt(i - 1) == '\\') {
                sb.deleteCharAt(i - 1);
                --i;
            }
            ++i;
        }
        return sb.toString();
    }

    public static void main(String[] args) {
    }
}

