/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp;

import com.sap.engine.services.connector.ResourceObjectFactory;
import com.sap.security.api.UMRuntimeException;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.datasource.ConnectionTimeoutException;
import com.sap.security.core.persistence.datasource.IConnectionPool;
import com.sap.security.core.persistence.datasource.InitializationException;
import com.sap.security.core.util.IUMTrace;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class J2EEConnectionPool
implements IConnectionPool {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/J2EEConnectionPool.java#2 $ from $DateTime: 2004/09/10 10:01:00 $ ($Change: 17287 $)";
    public static final String XA_TRANSACTIONS_USED = "ume.db.connection_pool.j2ee.xatransactions_used";
    public static final String IS_UNICODE = "ume.db.connection_pool.j2ee.is_unicode";
    public static final String IS_ORACLE_NATIVE_DRIVER_USED = "ume.db.connection_pool.j2ee.oracle_native_driver_used";
    public static final String JTA_SUPPORT_ENABLED = "ume.db.connection_pool.j2ee.jta_transaction_support_enabled";
    private static IUMTrace mTrace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/J2EEConnectionPool.java#2 $ from $DateTime: 2004/09/10 10:01:00 $ ($Change: 17287 $)");
    private boolean mXATransactionsUsed;
    private boolean mUnicode;
    private boolean mMerantChecked;
    private boolean mIsMerantDriver;
    private String mDatabaseVendor;
    private boolean mOracleNativeDriverUsed;
    private boolean mJTATransactionsSupported;
    private int mOriginalTransactionIsolation;
    private static Hashtable mDBDatasources = new Hashtable();
    private String mDatasourceName;
    static /* synthetic */ Class class$com$sap$security$core$persistence$datasource$imp$J2EEConnectionPool;

    public J2EEConnectionPool(String datasource, boolean XATransactionsUsed, boolean JTATransactionsSupported, boolean isUnicode, boolean isOracleNativeDriverUsed) throws InitializationException {
        if (mTrace.bePath()) {
            mTrace.entering("constructor", new Object[]{datasource, new Boolean(this.mXATransactionsUsed)});
        }
        this.mMerantChecked = false;
        this.mIsMerantDriver = false;
        this.mXATransactionsUsed = XATransactionsUsed;
        this.mJTATransactionsSupported = JTATransactionsSupported;
        this.mOracleNativeDriverUsed = isOracleNativeDriverUsed;
        this.mUnicode = isUnicode;
        if (datasource == null) {
            throw new InitializationException("Creation of J2EEConnectionPool failed... no datasource given!");
        }
        this.mDatasourceName = datasource;
        this.lookupDBPool(datasource);
        this.mOriginalTransactionIsolation = -1;
    }

    private void lookupDBPool(String datasource) throws InitializationException {
        Class clazz = class$com$sap$security$core$persistence$datasource$imp$J2EEConnectionPool == null ? (class$com$sap$security$core$persistence$datasource$imp$J2EEConnectionPool = J2EEConnectionPool.class$("com.sap.security.core.persistence.datasource.imp.J2EEConnectionPool")) : class$com$sap$security$core$persistence$datasource$imp$J2EEConnectionPool;
        synchronized (clazz) {
            if (mDBDatasources.get(datasource) == null) {
                try {
                    Hashtable parms = new Hashtable();
                    String jndiPrefix = "jdbc/notx/";
                    if (datasource.startsWith(jndiPrefix)) {
                        datasource = datasource.substring(jndiPrefix.length());
                    }
                    ResourceObjectFactory rFactory = new ResourceObjectFactory();
                    Reference notxref = new Reference("com.sap.engine.services.dbpool.cci.ConnectionFactory", "com.sap.engine.services.connector.ResourceObjectFactory", "service:connector");
                    notxref.add(new StringRefAddr("res-type", "javax.sql.DataSource"));
                    notxref.add(new StringRefAddr("res-auth", "Application"));
                    notxref.add(new StringRefAddr("sharing-scope", "Shareable"));
                    notxref.add(new StringRefAddr("res-name", datasource));
                    if (this.mJTATransactionsSupported) {
                        notxref.add(new StringRefAddr("tx-support", "true"));
                    } else {
                        notxref.add(new StringRefAddr("tx-support", "false"));
                    }
                    DataSource dbDatasource = (DataSource)rFactory.getObjectInstance((Object)notxref, null, null, parms);
                    if (dbDatasource == null) {
                        String errorMessage = "Cannot get dbpool \"" + datasource + "\"";
                        if (mTrace.beWarning()) {
                            mTrace.warningT("constructor", errorMessage);
                        }
                        throw new InitializationException(errorMessage);
                    }
                    mDBDatasources.put(this.mDatasourceName, dbDatasource);
                    if (mTrace.beInfo()) {
                        mTrace.infoT("constructor", "Datasource : " + datasource + " found");
                    }
                }
                catch (Exception ex) {
                    if (mTrace.beWarning()) {
                        mTrace.warningT("constructor", "Error while trying to get dbpool  \"" + datasource + "\"", ex);
                    }
                    throw new InitializationException(ex, ex.getMessage());
                }
            }
        }
    }

    public String getDatabaseVendor() {
        block11: {
            if (this.mDatabaseVendor == null) {
                try {
                    Connection dbCon = this.getConnection("getDatabaseVendor");
                    try {
                        block10: {
                            try {
                                DatabaseMetaData dbMetaData = dbCon.getMetaData();
                                String dbVendor = dbMetaData.getDatabaseProductName();
                                if (dbVendor == null) {
                                    this.mDatabaseVendor = "Not available";
                                    break block10;
                                }
                                this.mDatabaseVendor = dbVendor;
                            }
                            catch (SQLException sqlex) {
                                if (mTrace.beError()) {
                                    String errorMessage = "SQLException: " + sqlex.getMessage();
                                    mTrace.errorT("getDatabaseVendor", errorMessage, sqlex);
                                }
                                this.mDatabaseVendor = "Not accessible";
                                Object var5_9 = null;
                                this.releaseConnection(dbCon);
                                break block11;
                            }
                        }
                        Object var5_8 = null;
                        this.releaseConnection(dbCon);
                    }
                    catch (Throwable throwable) {
                        Object var5_10 = null;
                        this.releaseConnection(dbCon);
                        throw throwable;
                    }
                }
                catch (ConnectionTimeoutException ctoutex) {
                    if (mTrace.beError()) {
                        String errorMessage = "ConnectionTimeoutException: " + ctoutex.getMessage();
                        mTrace.errorT("getDatabaseVendor", errorMessage, (Throwable)((Object)ctoutex));
                    }
                    this.mDatabaseVendor = "Not accessible";
                }
            }
        }
        return this.mDatabaseVendor;
    }

    public boolean isUnicode() {
        return this.mUnicode;
    }

    public boolean isOracleNativeDriverUsed() {
        return this.mOracleNativeDriverUsed;
    }

    public boolean isXATransactionsUsed() {
        return this.mXATransactionsUsed;
    }

    public boolean isJTASupportEnabled() {
        return this.mJTATransactionsSupported;
    }

    public Connection getConnection(String description, int transactionIsolation) throws ConnectionTimeoutException {
        Connection con;
        block4: {
            con = this.getConnection(description);
            if (transactionIsolation == -1) {
                return con;
            }
            try {
                int transIsolation = con.getTransactionIsolation();
                if (transactionIsolation != transIsolation) {
                    this.mOriginalTransactionIsolation = transIsolation;
                    con.setTransactionIsolation(transactionIsolation);
                }
            }
            catch (SQLException sqlex) {
                if (!mTrace.beInfo()) break block4;
                mTrace.infoT("getConnection", "Cannot change transaction isolation level.", sqlex);
            }
        }
        return con;
    }

    public Connection getConnection(String description) throws ConnectionTimeoutException {
        Connection con = null;
        try {
            DataSource ds = (DataSource)mDBDatasources.get(this.mDatasourceName);
            if (ds == null) {
                try {
                    this.lookupDBPool(this.mDatasourceName);
                    ds = (DataSource)mDBDatasources.get(this.mDatasourceName);
                    if (ds == null) {
                        throw new UMRuntimeException("Tried to lookup db pool \"" + this.mDatasourceName + "\" but still got null.");
                    }
                }
                catch (InitializationException e) {
                    throw new UMRuntimeException((Throwable)((Object)e));
                }
            }
            if ((con = ds.getConnection()).getAutoCommit()) {
                con.setAutoCommit(false);
            }
        }
        catch (Exception e) {
            throw new UMRuntimeException((Throwable)e);
        }
        return con;
    }

    public void releaseConnection(Connection context, boolean destroy) {
        this.releaseConnection(context);
    }

    public void releaseConnection(Connection context) {
        try {
            context.commit();
            context.close();
        }
        catch (SQLException sqlex) {
            throw new UMRuntimeException((Throwable)sqlex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

