/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.IInternalPrincipalDatabag;
import com.sap.security.core.persistence.IPrincipalDatabag;
import com.sap.security.core.persistence.datasource.IDataSource;
import com.sap.security.core.persistence.datasource.IDataSourceTransaction;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.datasource.imp.DSConfigurationModel;
import com.sap.security.core.persistence.imp.SearchCriteria;
import com.sap.security.core.persistence.notification.IPersistenceNotification;
import com.sap.security.core.persistence.notification.IPersistenceNotificationListener;
import com.sap.security.core.persistence.notification.NotificationException;
import com.sap.security.core.util.IUMTrace;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public abstract class DataSourceBaseImplementation
implements IDataSource {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/DataSourceBaseImplementation.java#3 $ from $DateTime: 2004/11/04 13:54:08 $ ($Change: 17563 $)";
    public static final String PRINCIPAL_ID_SEPARATOR = ".";
    public static final String CHECK_CREDENTIALS = "check_credentials";
    public static final String CHECK_CREDENTIALS_UID_ATTRIBUTES = "check_credentials.login_attributes";
    public static final String CHECK_CREDENTIALS_CERT_ATTRIBUTE = "check_credentials.certificate_attribute";
    protected boolean isInitialized;
    public DSConfigurationModel mConfigurationModel;
    protected IPersistenceNotificationListener mPersistenceNotificationListener;
    private static IUMTrace mTrace;

    public DataSourceBaseImplementation() {
        if (mTrace == null) {
            mTrace = InternalUMFactory.getTrace(VERSIONSTRING);
        }
        if (mTrace.bePath()) {
            mTrace.entering("constructor");
        }
        this.isInitialized = false;
        if (mTrace.bePath()) {
            mTrace.exiting("constructor");
        }
    }

    public void init(DSConfigurationModel dsConf) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("init", new Object[]{dsConf});
        }
        this.mConfigurationModel = dsConf;
        this.mPersistenceNotificationListener = this.mConfigurationModel.getNotificationListener();
        if (mTrace.bePath()) {
            mTrace.exiting("init");
        }
    }

    protected void notifyPrincipalDatabagFactory(IPersistenceNotification persistenceNotification) throws NotificationException {
        if (mTrace.bePath()) {
            mTrace.entering("notify", new Object[]{persistenceNotification});
        }
        if (this.mPersistenceNotificationListener != null) {
            persistenceNotification.setCaller(this.mConfigurationModel.getDataSourceID());
            this.mPersistenceNotificationListener.notify(persistenceNotification);
        }
        if (mTrace.bePath()) {
            mTrace.exiting("notify");
        }
    }

    public String getPhysicalAttribute(String principalType, String nameSpace, String logicalAttributeName) throws PersistenceException {
        if (this.mConfigurationModel == null) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        return this.mConfigurationModel.getPhysicalAttribute(principalType, nameSpace, logicalAttributeName);
    }

    public String getLogicalAttribute(String principalType, String nameSpace, String physicalAttributeName) throws PersistenceException {
        if (this.mConfigurationModel == null) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        return this.mConfigurationModel.getLogicalAttribute(principalType, nameSpace, physicalAttributeName);
    }

    public String getId() throws PersistenceException {
        if (this.mConfigurationModel == null) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        return this.mConfigurationModel.getDataSourceID();
    }

    public boolean isHomeForPrincipalDatabag(IInternalPrincipalDatabag principal) throws PersistenceException {
        Vector values;
        String attribute;
        String nameSpace;
        if (this.mConfigurationModel == null) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        if (principal == null) {
            return false;
        }
        String id = principal.getUniqueID();
        String type = null;
        String dsID = null;
        if (id != null) {
            String[] idParts = principal.getIDParts();
            type = idParts[0];
            dsID = idParts[1];
        } else {
            Vector types = principal.getAttributeValues("com.sap.security.core.usermanagement", "PRINCIPAL_TYPE_ATTRIBUTE");
            if (types == null) {
                String errorMessage = "Missing attribute PRINCIPAL_TYPE_ATTRIBUTE on namespace com.sap.security.core.usermanagement in order to check home";
                throw new PersistenceException(errorMessage);
            }
            type = (String)types.firstElement();
            if (type == null) {
                String errorMessage = "Missing attribute PRINCIPAL_TYPE_ATTRIBUTE on namespace com.sap.security.core.usermanagement in order to check home";
                throw new PersistenceException(errorMessage);
            }
        }
        boolean homeFor = false;
        if (dsID != null) {
            homeFor = dsID.equals(this.mConfigurationModel.getDataSourceID());
            return homeFor;
        }
        Enumeration en = principal.getNameSpaces();
        while (en.hasMoreElements() && !homeFor) {
            nameSpace = (String)en.nextElement();
            Enumeration en2 = principal.getAttributesOnNamespace(nameSpace);
            while (en2.hasMoreElements() && !homeFor) {
                attribute = (String)en2.nextElement();
                values = principal.getAttributeValues(nameSpace, attribute);
                int i = 0;
                while (i < values.size() && !homeFor) {
                    homeFor = homeFor || this.mConfigurationModel.isHomeFor(type, nameSpace, attribute, values.elementAt(i));
                    ++i;
                }
            }
        }
        Enumeration en2 = principal.getNameSpaces();
        while (en2.hasMoreElements() && homeFor) {
            nameSpace = (String)en2.nextElement();
            Enumeration en22 = principal.getAttributesOnNamespace(nameSpace);
            while (en22.hasMoreElements() && homeFor) {
                attribute = (String)en22.nextElement();
                values = principal.getAttributeValues(nameSpace, attribute);
                int i = 0;
                while (i < values.size() && homeFor) {
                    homeFor = homeFor && !this.mConfigurationModel.isNotHomeFor(type, nameSpace, attribute, values.elementAt(i));
                    ++i;
                }
            }
        }
        return homeFor;
    }

    public boolean bindNewPrincipalDatabag(IInternalPrincipalDatabag principal) throws PersistenceException {
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        if (this.mConfigurationModel.getIsReadonly()) {
            return false;
        }
        if (principal == null) {
            String errorMessage = "Given principal is null!";
            throw new PersistenceException(errorMessage);
        }
        String[] dsToCreate = principal.getDataSourcesToCreate();
        boolean found = false;
        if (dsToCreate != null) {
            int k = 0;
            int s = dsToCreate.length;
            while (k < s && !found) {
                if (this.getId().equals(dsToCreate[k])) {
                    found = true;
                }
                ++k;
            }
        } else {
            found = true;
        }
        if (!found) {
            return false;
        }
        Vector types = principal.getAttributeValues("com.sap.security.core.usermanagement", "PRINCIPAL_TYPE_ATTRIBUTE");
        if (types == null) {
            String errorMessage = "Missing attribute PRINCIPAL_TYPE_ATTRIBUTE on namespace com.sap.security.core.usermanagement in principal bind";
            throw new PersistenceException(errorMessage);
        }
        String type = (String)types.firstElement();
        if (type == null) {
            String errorMessage = "Missing attribute PRINCIPAL_TYPE_ATTRIBUTE on namespace com.sap.security.core.usermanagement in principal bind";
            throw new PersistenceException(errorMessage);
        }
        boolean responsible = this.isHomeForPrincipalDatabag(principal);
        if (responsible) {
            String id = principal.getUniqueID();
            if (id != null) {
                String errorMessage = "Principal databag " + id + " already bound!";
                throw new PersistenceException(errorMessage);
            }
            int prio = this.mConfigurationModel.getPriority(type);
            if (prio == principal.getPriority()) {
                id = type + PRINCIPAL_ID_SEPARATOR + this.mConfigurationModel.getDataSourceID() + PRINCIPAL_ID_SEPARATOR + this.getPrivateIDPart(principal);
                principal.setUniqueID(id);
            } else {
                return false;
            }
        }
        return responsible;
    }

    protected abstract String getPrivateIDPart(IPrincipalDatabag var1) throws PersistenceException;

    protected boolean feelsResponsible(IPrincipalDatabag principal, String nameSpace, String attribute) throws PersistenceException {
        if (this.mConfigurationModel == null) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        if (principal != null && nameSpace != null && attribute != null) {
            return this.feelsResponsible(principal.getIDParts()[0], nameSpace, attribute);
        }
        return false;
    }

    protected boolean feelsResponsible(String type, String nameSpace, String attribute) throws PersistenceException {
        if (this.mConfigurationModel == null) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        if (!(type == null || nameSpace == null || attribute == null || nameSpace.equals("com.sap.security.core.usermanagement") && (attribute.equals("PRINCIPAL_TYPE_ATTRIBUTE") || attribute.equals("oldpassword")))) {
            return this.mConfigurationModel.feelsResponsible(type, nameSpace, attribute);
        }
        return false;
    }

    protected boolean feelsResponsible(String nameSpace, String attribute) throws PersistenceException {
        if (this.mConfigurationModel == null) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        if (!(nameSpace == null || attribute == null || nameSpace.equals("com.sap.security.core.usermanagement") && (attribute.equals("PRINCIPAL_TYPE_ATTRIBUTE") || attribute.equals("oldpassword")))) {
            return this.mConfigurationModel.feelsResponsible(nameSpace, attribute);
        }
        return false;
    }

    protected boolean feelsResponsible(IPrincipalDatabag principal) throws PersistenceException {
        if (this.mConfigurationModel == null) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        if (principal != null) {
            return this.mConfigurationModel.feelsResponsible(principal.getIDParts()[0]);
        }
        return false;
    }

    public boolean isPrimary() throws PersistenceException {
        if (this.mConfigurationModel == null) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        return this.mConfigurationModel.getIsPrimary();
    }

    public boolean isReadonly() throws PersistenceException {
        if (this.mConfigurationModel == null) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        return this.mConfigurationModel.getIsReadonly();
    }

    public String[] splitPrincipalDatabagID(String principalID) throws PersistenceException {
        if (principalID == null) {
            String errorMessage = "The given ID is null!";
            throw new PersistenceException(errorMessage);
        }
        int firstOccurrence = principalID.indexOf(PRINCIPAL_ID_SEPARATOR);
        String[] idParts = new String[3];
        boolean valid = false;
        if (firstOccurrence != -1) {
            idParts[0] = principalID.substring(0, firstOccurrence);
            if ((firstOccurrence = (principalID = principalID.substring(firstOccurrence + 1, principalID.length())).indexOf(PRINCIPAL_ID_SEPARATOR)) != -1) {
                idParts[1] = principalID.substring(0, firstOccurrence);
                idParts[2] = principalID.substring(firstOccurrence + 1, principalID.length());
                boolean bl = valid = idParts[0].length() == 4;
            }
        }
        if (!valid) {
            String errorMessage = "The given ID \"" + principalID + "\" is not valid!";
            throw new PersistenceException(errorMessage);
        }
        return idParts;
    }

    public abstract IInternalPrincipalDatabag[] initPrincipalDatabags(IInternalPrincipalDatabag[] var1) throws PersistenceException;

    public abstract boolean checkCredentials(Hashtable var1) throws PersistenceException;

    public abstract void populatePrincipalDatabags(IInternalPrincipalDatabag[] var1, AttributeList var2) throws PersistenceException;

    public abstract boolean populatePrincipalDatabag(IInternalPrincipalDatabag var1, String var2, String var3) throws PersistenceException;

    public abstract IDataSourceTransaction beginTransaction() throws PersistenceException;

    public abstract boolean principalDatabagExists(IPrincipalDatabag var1) throws PersistenceException;

    public abstract Vector searchPrincipalDatabags(SearchCriteria var1) throws PersistenceException;

    public abstract void populatePrincipalDatabag(IInternalPrincipalDatabag var1, AttributeList var2) throws PersistenceException;

    public abstract Vector getAttributeNamespaces(IPrincipalDatabag var1) throws PersistenceException;

    public abstract Vector getAttributeNames(IPrincipalDatabag var1, String var2) throws PersistenceException;

    public Collection[] getDirectParents(String[] principalids, String[] principalTypes) throws PersistenceException {
        String currentType = null;
        int size = principalTypes.length;
        SearchCriteria sc = null;
        int size2 = principalids.length;
        Collection[] result = new Collection[size2];
        int j = 0;
        while (j < size2) {
            if (principalids[j] != null) {
                int i = 0;
                while (i < size) {
                    currentType = principalTypes[i];
                    if (this.feelsResponsible(currentType, "com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE")) {
                        Vector tempResult;
                        sc = new SearchCriteria(false, currentType);
                        sc.addEqualsElement("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", principalids[j], true);
                        if (result[j] == null) {
                            result[j] = new HashSet();
                        }
                        if ((tempResult = this.searchPrincipalDatabags(sc)) != null) {
                            result[j].addAll(tempResult);
                        }
                    }
                    ++i;
                }
            }
            if (result[j] == null) {
                result[j] = new Vector();
            }
            ++j;
        }
        return result;
    }

    public Collection getDirectParents(String principalid, String[] principalTypes) throws PersistenceException {
        Collection[] result = this.getDirectParents(new String[]{principalid}, principalTypes);
        if (result != null && result.length > 0) {
            return result[0];
        }
        return null;
    }

    protected Vector buildIntersection(Vector[] sets) {
        Vector objectsInAllResults = null;
        int length = sets.length;
        int i = 0;
        while (i < length && (objectsInAllResults == null || objectsInAllResults.size() != 0)) {
            Vector currentRes = sets[i] != null ? sets[i] : null;
            if (currentRes != null) {
                if (objectsInAllResults == null) {
                    objectsInAllResults = currentRes;
                } else {
                    Vector intersection = new Vector();
                    int j = 0;
                    while (j < objectsInAllResults.size()) {
                        Object id = objectsInAllResults.elementAt(j);
                        if (currentRes.contains(id)) {
                            intersection.add(id);
                        }
                        ++j;
                    }
                    objectsInAllResults = intersection;
                }
            }
            ++i;
        }
        return objectsInAllResults;
    }

    protected Vector buildUnion(Vector[] sets) {
        Vector objectsInAllResults = new Vector();
        int length = sets.length;
        int i = 0;
        while (i < length) {
            Vector currentRes;
            if (sets[i] != null && (currentRes = sets[i]) != null) {
                int j = 0;
                while (j < currentRes.size()) {
                    Object id = currentRes.elementAt(j);
                    if (!objectsInAllResults.contains(id)) {
                        objectsInAllResults.add(id);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return objectsInAllResults;
    }
}

