/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp;

import java.util.Hashtable;

public class DataBaseStringsPool {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/DataBaseStringsPool.java#2 $ from $DateTime: 2004/09/10 10:01:00 $ ($Change: 17287 $)";
    public static final String INSERT_STATEMENT_STRINGS = "ISS";
    public static final String INSERT_STATEMENT_BLOBS = "ISB";
    public static final String DELETE_STATEMENT_WITH_VALUE = "DSV";
    public static final String DELETE_STATEMENT_WITHOUT_VALUE = "DS";
    public static final String SEARCH_STATEMENT_ONE_ATTRIBUTE = "SS";
    public static final String SEARCH_STATEMENT_DIRECT_PARENTS = "DP";
    public static final String QUERY_STATEMENT_LOGON_UID = "UID";
    public static final String QUERY_STATEMENT_LOGON_PWD = "PWD";
    public static final String QUERY_STATEMENT_LOGON_CERT = "X509";
    public static final String POPULATE_STATEMENT_SINGLE_ATTRIBUTE_STRINGS = "SAS";
    public static final String POPULATE_STATEMENT_SINGLE_ATTRIBUTE_BLOBS = "SAB";
    private static DataBaseStringsPool mInstance;
    private static Hashtable mStatements;

    private DataBaseStringsPool() {
        mStatements = new Hashtable();
    }

    public static synchronized DataBaseStringsPool getInstance() {
        if (mInstance == null) {
            mInstance = new DataBaseStringsPool();
        }
        return mInstance;
    }

    public String getDataBaseString(String key, String type) {
        Hashtable stmts = (Hashtable)mStatements.get(type);
        if (stmts != null) {
            return (String)stmts.get(key);
        }
        return null;
    }

    public void storeDataBaseString(String key, String type, String dataBaseString) {
        Hashtable<String, String> stmts = (Hashtable<String, String>)mStatements.get(type);
        if (stmts == null) {
            stmts = new Hashtable<String, String>();
        }
        stmts.put(key, dataBaseString);
        mStatements.put(type, stmts);
    }
}

