/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.ISearchAttribute;
import com.sap.security.api.UMFactory;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.locking.imp.LockManager;
import com.sap.security.core.persistence.IInternalPrincipalDatabag;
import com.sap.security.core.persistence.IInternalPrincipalDatabagMaint;
import com.sap.security.core.persistence.IPrincipalDatabag;
import com.sap.security.core.persistence.datasource.ConnectionTimeoutException;
import com.sap.security.core.persistence.datasource.DuplicateKeyException;
import com.sap.security.core.persistence.datasource.IConnectionPool;
import com.sap.security.core.persistence.datasource.IDataSource;
import com.sap.security.core.persistence.datasource.IDataSourceTransaction;
import com.sap.security.core.persistence.datasource.InitializationException;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.datasource.imp.DSConfigurationModel;
import com.sap.security.core.persistence.datasource.imp.DataBaseConnectionPool;
import com.sap.security.core.persistence.datasource.imp.DataBaseDataSourceTransaction;
import com.sap.security.core.persistence.datasource.imp.DataBaseStringsPool;
import com.sap.security.core.persistence.datasource.imp.DataSourceBaseImplementation;
import com.sap.security.core.persistence.datasource.imp.J2EEConnectionPool;
import com.sap.security.core.persistence.datasource.imp.J2EEUserTransactionPool;
import com.sap.security.core.persistence.datasource.imp.OracleNativeUtil;
import com.sap.security.core.persistence.datasource.imp.SP0_TO_SP1;
import com.sap.security.core.persistence.imp.PrincipalDatabag;
import com.sap.security.core.persistence.imp.SearchCriteria;
import com.sap.security.core.util.Base64;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.imp.PasswordHash;
import com.sap.security.core.util.imp.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

public class DataBasePersistence
extends DataSourceBaseImplementation
implements IDataSource {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/DataBasePersistence.java#7 $ from $DateTime: 2005/01/21 16:34:10 $ ($Change: 17855 $)";
    public static final String CONNECTION_POOL_PROPERTY = "ume.db.connection_pool_type";
    public static final String CONNECTION_POOL_INTERNAL = "internal";
    public static final String PRINCIPALS_DISTRIBUTED_BY_TYPE_IDENTIFIER = "ume.db.table.principals_distributed_by_typeidentifier";
    public static final String OR_SEARCH_MAX_ATTRIBUTES = "ume.db.or_search.max_arguments";
    public static final String OR_PARENT_SEARCH_MAX_ATTRIBUTES = "ume.db.parent_search.max_arguments";
    public static final String USE_DEFAULT_TRANSACTION_ISOLATION = "ume.db.use_default_transaction_isolation";
    public static final String STRING_TABLE = "ume.db.table.strings";
    public static final String BLOB_TABLE = "ume.db.table.blobs";
    public static final String CHECK_UNIQUENESS_OF_ATTRIBUTE_VALUES = "ume.db.check_uniqueness_of_attribute_values";
    public static final String PID_COLUMN = "ume.db.column.principalid";
    public static final String NAMESPACE_COLUMN = "ume.db.column.namespace";
    public static final String ATTRIBUTE_COLUMN = "ume.db.column.attribute";
    public static final String ATTRIBUTE_GUID_COLUMN = "ume.db.column.attribute_guid";
    public static final String VALUE_COLUMN = "ume.db.column.value";
    public static final String UPPER_VALUE_COLUMN = "ume.db.column.uppercase_value";
    public static final String PID_HASH_COLUMN = "ume.db.column.principalid_hash";
    public static final String NAMESPACE_HASH_COLUMN = "ume.db.column.namespace_hash";
    public static final String ATTRIBUTE_HASH_COLUMN = "ume.db.column.attribute_hash";
    public static final String VALUE_HASH_COLUMN = "ume.db.column.value_hash";
    public static final String UPPER_VALUE_HASH_COLUMN = "ume.db.column.uppercase_value_hash";
    public static final String UPDATE_DB_SCHEMA = "ume.db.update_schema";
    public static final String UPDATE_DB_DATA = "ume.db.update_data";
    private static final String THIS_REPLACES_THE_EMPTY_STRING_FOR_ORACLE = " ";
    private static final String XOPEN_SQL_STATE_CONSTRAINT_VIOLATED = "23000";
    private int mDefaultTransactionIsolation;
    private static final String DATABASE_ESCAPE_CHARACTER = "#";
    private OracleNativeUtil mOracleUtil;
    private String dataBaseDriver;
    private String dataBaseUser;
    private String dataBaseContextFactory;
    private String dataBaseProviderUrl;
    private String dataBasePassword;
    private String dataBaseUrl;
    private boolean principalsSeparatedInTablesByType;
    private String stringValueTable;
    private String blobValueTable;
    private String principalIdColumn;
    private String nameSpaceColumn;
    private String attributeColumn;
    private String attributeGUIDColumn;
    private String valueColumn;
    private String upperValueColumn;
    private String principalIdHashColumn;
    private String nameSpaceHashColumn;
    private String attributeHashColumn;
    private String valueHashColumn;
    private String upperValueHashColumn;
    private int mOrSearchMaxArguments;
    private int mOrParentSearchMaxArguments;
    private IConnectionPool mConnectionPool;
    private boolean mCheckUniquenessOfAttributeValues;
    private J2EEUserTransactionPool mUserTransactionPool;
    private static IUMTrace mTrace;
    private boolean dbWasEmptyOnStartup;

    public DataBasePersistence() {
        String methodName = "constructor";
        mTrace = InternalUMFactory.getTrace(VERSIONSTRING);
        if (mTrace.bePath()) {
            mTrace.entering(methodName);
        }
        if (mTrace.bePath()) {
            mTrace.exiting(methodName);
        }
    }

    protected int getDBSchemaVersion() throws PersistenceException {
        String methodName = "getDBSchemaVersion";
        int version = -1;
        ResultSet res = null;
        PreparedStatement stmt = null;
        Connection myCon = this.mConnectionPool.getConnection(methodName, this.mDefaultTransactionIsolation);
        try {
            block14: {
                try {
                    String query = "SELECT DBVER FROM UME_VERSION";
                    if (mTrace.beInfo()) {
                        mTrace.infoT(methodName, "perform query: " + query);
                    }
                    stmt = myCon.prepareStatement(query);
                    try {
                        res = stmt.executeQuery();
                        if (res.next()) {
                            version = res.getInt("DBVER");
                        }
                    }
                    catch (SQLException sqlex) {
                        if (mTrace.beDebug()) {
                            mTrace.debugT("getDBSchemaVersion", sqlex);
                        }
                        version = -1;
                    }
                    if (version != -1) break block14;
                    String update = "CREATE TABLE UME_VERSION (DBVER INTEGER NOT NULL, CONSTRAINT UME_PK_VERSION PRIMARY KEY (DBVER))";
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (1 != (stmt = myCon.prepareStatement(update)).executeUpdate()) {
                        mTrace.warningT(methodName, "Version table UME_VERSION not created!");
                    }
                    update = "INSERT INTO UME_VERSION (DBVER) VALUES (0)";
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (1 != (stmt = myCon.prepareStatement(update)).executeUpdate()) {
                        mTrace.warningT(methodName, "Version not written to version table UME_VERSION!");
                    } else {
                        version = 0;
                    }
                    if (this.mConnectionPool.isXATransactionsUsed()) break block14;
                    myCon.commit();
                }
                catch (SQLException sqlex) {
                    throw new PersistenceException(sqlex);
                }
            }
            Object var9_10 = null;
            this.closeResultSet(res, methodName);
            this.closePreparedStatement(stmt, methodName);
            this.mConnectionPool.releaseConnection(myCon);
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.closeResultSet(res, methodName);
            this.closePreparedStatement(stmt, methodName);
            this.mConnectionPool.releaseConnection(myCon);
            throw throwable;
        }
        return version;
    }

    private void closePreparedStatement(PreparedStatement stmt, String methodName) {
        block3: {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {
                    if (!mTrace.beWarning()) break block3;
                    mTrace.warningT(methodName, "Error while closing prepared statement: " + ex.getMessage(), ex);
                }
            }
        }
    }

    private void closeResultSet(ResultSet res, String methodName) {
        block3: {
            if (res != null) {
                try {
                    res.close();
                }
                catch (Exception ex) {
                    if (!mTrace.beWarning()) break block3;
                    mTrace.warningT(methodName, "Error while closing result set: " + ex.getMessage(), ex);
                }
            }
        }
    }

    public void closeInputStream(InputStream is, String methodName) {
        block3: {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ex) {
                    if (!mTrace.beWarning()) break block3;
                    mTrace.warningT(methodName, "Error while closing input stream: " + ex.getMessage(), ex);
                }
            }
        }
    }

    public void init(DSConfigurationModel dsConf) throws PersistenceException {
        IUMParameters props;
        String connectionPool;
        String methodName;
        block62: {
            block61: {
                methodName = "init";
                super.init(dsConf);
                mTrace = InternalUMFactory.getTrace(VERSIONSTRING);
                connectionPool = dsConf.getPrivateAttribute(CONNECTION_POOL_PROPERTY);
                props = UMFactory.getProperties();
                if (connectionPool == null) {
                    connectionPool = props.get(CONNECTION_POOL_PROPERTY);
                }
                this.mOrSearchMaxArguments = -1;
                try {
                    this.mOrSearchMaxArguments = dsConf.getPrivateAttributeIntValue(OR_SEARCH_MAX_ATTRIBUTES);
                }
                catch (PersistenceException pex) {
                    if (!mTrace.beInfo()) break block61;
                    mTrace.infoT(methodName, "Error while reading property \"ume.db.or_search.max_arguments\":" + pex.getMessage(), (Throwable)((Object)pex));
                }
            }
            if (this.mOrSearchMaxArguments < 1) {
                this.mOrSearchMaxArguments = UMFactory.getProperties().getNumber(OR_SEARCH_MAX_ATTRIBUTES, 50);
            }
            this.mOrParentSearchMaxArguments = -1;
            try {
                this.mOrParentSearchMaxArguments = dsConf.getPrivateAttributeIntValue(OR_PARENT_SEARCH_MAX_ATTRIBUTES);
            }
            catch (PersistenceException pex) {
                if (!mTrace.beInfo()) break block62;
                mTrace.infoT(methodName, "Error while reading property \"ume.db.parent_search.max_arguments\":" + pex.getMessage(), (Throwable)((Object)pex));
            }
        }
        if (this.mOrParentSearchMaxArguments < 1) {
            this.mOrParentSearchMaxArguments = UMFactory.getProperties().getNumber(OR_PARENT_SEARCH_MAX_ATTRIBUTES, 500);
        }
        if (connectionPool == null) {
            connectionPool = CONNECTION_POOL_INTERNAL;
        }
        if (connectionPool.equalsIgnoreCase(CONNECTION_POOL_INTERNAL)) {
            String isOracleNativeDriverUsed;
            String isUnicode;
            String xaTransactionsUsed;
            String cpLogPath;
            int cpReleaseCheckInterval;
            int cpReleaseInterval;
            int cpConnectRetrials;
            int cpMonitorInterval;
            int cpMaxWaitTime;
            int cpMaxIdleTime;
            int cpMaxIdleConnections;
            int cpMaxSize;
            int cpMinSize;
            this.dataBaseDriver = dsConf.getPrivateAttribute("ume.db.jdbc_driver");
            if (this.dataBaseDriver == null) {
                this.dataBaseDriver = props.get("ume.db.jdbc_driver");
            }
            this.dataBaseUser = dsConf.getPrivateAttribute("ume.db.jdbc_user");
            if (this.dataBaseUser == null) {
                this.dataBaseUser = props.get("ume.db.jdbc_user");
            }
            this.dataBasePassword = dsConf.getPrivateAttribute("ume.db.jdbc_password");
            if (this.dataBasePassword == null) {
                this.dataBasePassword = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return props.getPassword("ume.db.jdbc_password");
                    }
                });
            }
            this.dataBaseUrl = dsConf.getPrivateAttribute("ume.db.jdbc_url");
            if (this.dataBaseUrl == null) {
                this.dataBaseUrl = props.get("ume.db.jdbc_url");
            }
            if ((cpMinSize = dsConf.getPrivateAttributeIntValue("ume.db.connection_pool.internal.minsize")) == -1) {
                cpMinSize = props.getNumber("ume.db.connection_pool.internal.minsize", 1);
            }
            if ((cpMaxSize = dsConf.getPrivateAttributeIntValue("ume.db.connection_pool.internal.maxsize")) == -1) {
                cpMaxSize = props.getNumber("ume.db.connection_pool.internal.maxsize", 30);
            }
            if ((cpMaxIdleConnections = dsConf.getPrivateAttributeIntValue("ume.db.connection_pool.internal.max_idle_connections")) == -1) {
                cpMaxIdleConnections = props.getNumber("ume.db.connection_pool.internal.max_idle_connections", 5);
            }
            if ((cpMaxIdleTime = dsConf.getPrivateAttributeIntValue("ume.db.connection_pool.internal.max_connection_idle_time")) == -1) {
                cpMaxIdleTime = props.getNumber("ume.db.connection_pool.internal.max_connection_idle_time", 600000);
            }
            if ((cpMaxWaitTime = dsConf.getPrivateAttributeIntValue("ume.db.connection_pool.internal.max_wait_process_time")) == -1) {
                cpMaxWaitTime = props.getNumber("ume.db.connection_pool.internal.max_wait_process_time", 600000);
            }
            if ((cpMonitorInterval = dsConf.getPrivateAttributeIntValue("ume.db.connection_pool.internal.monitor_interval")) == -1) {
                cpMonitorInterval = props.getNumber("ume.db.connection_pool.internal.monitor_interval", -1);
            }
            if ((cpConnectRetrials = dsConf.getPrivateAttributeIntValue("ume.db.connection_pool.internal.connect_retrials")) == -1) {
                cpConnectRetrials = props.getNumber("ume.db.connection_pool.internal.connect_retrials", 0);
            }
            if ((cpReleaseInterval = dsConf.getPrivateAttributeIntValue("ume.db.connection_pool.internal.max_connection_usage_time")) == -1) {
                cpReleaseInterval = props.getNumber("ume.db.connection_pool.internal.max_connection_usage_time", 600000);
            }
            if ((cpReleaseCheckInterval = dsConf.getPrivateAttributeIntValue("ume.db.connection_pool.internal.max_connection_usage_time_check_interval")) == -1) {
                cpReleaseCheckInterval = props.getNumber("ume.db.connection_pool.internal.max_connection_usage_time_check_interval", 60000);
            }
            if ((cpLogPath = dsConf.getPrivateAttributeFileValue("ume.db.connection_pool.internal.monitor_path")) == null) {
                cpLogPath = props.getFile("ume.db.connection_pool.internal.monitor_path", dsConf.getConfigurationRootDir().getAbsolutePath());
            }
            if ((xaTransactionsUsed = dsConf.getPrivateAttribute("ume.db.connection_pool.internal.xatransactions_used")) == null) {
                xaTransactionsUsed = props.get("ume.db.connection_pool.internal.xatransactions_used", "false");
            }
            if ((isUnicode = dsConf.getPrivateAttribute("ume.db.connection_pool.internal.is_unicode")) == null) {
                isUnicode = props.get("ume.db.connection_pool.internal.is_unicode", "false");
            }
            if ((isOracleNativeDriverUsed = dsConf.getPrivateAttribute("ume.db.connection_pool.internal.oracle_native_driver_used")) == null) {
                isOracleNativeDriverUsed = props.get("ume.db.connection_pool.internal.oracle_native_driver_used", "false");
            }
            if (mTrace.beInfo()) {
                mTrace.infoT(methodName, "Using database driver: " + this.dataBaseDriver);
                mTrace.infoT(methodName, "Using database url: " + this.dataBaseUrl);
                mTrace.infoT(methodName, "Using XATransactions: " + xaTransactionsUsed);
                mTrace.infoT(methodName, "Using Unicode: " + isUnicode);
                mTrace.infoT(methodName, "Using Oracle native driver: " + isOracleNativeDriverUsed);
                mTrace.infoT(methodName, "Using database user: " + this.dataBaseUser);
                mTrace.infoT(methodName, "Using max. number of arguments for or searches: " + this.mOrSearchMaxArguments);
                mTrace.infoT(methodName, "Connection pool Minsize: " + cpMinSize);
                mTrace.infoT(methodName, "Connection pool Maxsize: " + cpMaxSize);
                mTrace.infoT(methodName, "Connection pool MaxIdleConnections: " + cpMaxIdleConnections);
                mTrace.infoT(methodName, "Connection pool MaxIdleTime: " + cpMaxIdleTime);
                mTrace.infoT(methodName, "Connection pool MaxWaitTime: " + cpMaxWaitTime);
                mTrace.infoT(methodName, "Connection pool MonitorInterval: " + cpMonitorInterval);
                mTrace.infoT(methodName, "Connection pool ConnectionRetrials: " + cpConnectRetrials);
                mTrace.infoT(methodName, "Connection pool ConnectionReleaseInterval: " + cpReleaseInterval);
                mTrace.infoT(methodName, "Connection pool ConnectionReleaseCheckInterval: " + cpReleaseCheckInterval);
                mTrace.infoT(methodName, "Connection pool MonitorPath: " + cpLogPath);
            }
            Hashtable<String, String> mConnectionParameters = new Hashtable<String, String>();
            mConnectionParameters.put("ume.db.jdbc_driver", this.dataBaseDriver);
            mConnectionParameters.put("ume.db.jdbc_url", this.dataBaseUrl);
            mConnectionParameters.put("ume.db.jdbc_user", this.dataBaseUser);
            mConnectionParameters.put("ume.db.jdbc_password", this.dataBasePassword);
            try {
                boolean xaTransactionsUsedValue = xaTransactionsUsed.equalsIgnoreCase("true");
                this.mUserTransactionPool = xaTransactionsUsedValue ? new J2EEUserTransactionPool() : null;
                this.mConnectionPool = new DataBaseConnectionPool(this.mConfigurationModel.getDataSourceID() + "_cp", cpMinSize, cpMaxSize, cpMaxIdleConnections, cpMaxIdleTime, cpMaxWaitTime, mConnectionParameters, cpConnectRetrials, cpReleaseInterval, cpReleaseCheckInterval, xaTransactionsUsedValue, isUnicode.equalsIgnoreCase("true"), isOracleNativeDriverUsed.equalsIgnoreCase("true"));
            }
            catch (InitializationException iex) {
                throw new PersistenceException((Throwable)((Object)iex), iex.getMessage() + "\n\t" + CONNECTION_POOL_PROPERTY + "=" + connectionPool + "\n\t" + "ume.db.jdbc_driver" + "=" + this.dataBaseDriver + "\n\t" + "ume.db.jdbc_url" + "=" + this.dataBaseUrl + "\n\t" + "ume.db.jdbc_user" + "=" + this.dataBaseUser + "\n\t" + "ume.db.jdbc_password" + "=********" + "\n\t" + "ume.db.connection_pool.internal.minsize" + "=" + cpMinSize + "\n\t" + "ume.db.connection_pool.internal.maxsize" + "=" + cpMaxSize + "\n\t" + "ume.db.connection_pool.internal.max_idle_connections" + "=" + cpMaxIdleConnections + "\n\t" + "ume.db.connection_pool.internal.max_connection_idle_time" + "=" + cpMaxIdleTime + "\n\t" + "ume.db.connection_pool.internal.max_wait_process_time" + "=" + cpMaxWaitTime + "\n\t" + "ume.db.connection_pool.internal.connect_retrials" + "=" + cpConnectRetrials + "\n\t" + "ume.db.connection_pool.internal.max_connection_usage_time" + "=" + cpReleaseInterval + "\n\t" + "ume.db.connection_pool.internal.max_connection_usage_time_check_interval" + "=" + cpReleaseCheckInterval + "\n\t" + "ume.db.connection_pool.internal.xatransactions_used" + "=" + xaTransactionsUsed + "\n\t" + "ume.db.connection_pool.internal.is_unicode" + "=" + isUnicode + "\n\t" + "ume.db.connection_pool.internal.oracle_native_driver_used" + "=" + isOracleNativeDriverUsed);
            }
        }
        String xaTransactionsUsed = null;
        String jtaTransactionsSupported = null;
        String isUnicode = null;
        String isOracleNativeDriverUsed = null;
        try {
            xaTransactionsUsed = dsConf.getPrivateAttribute("ume.db.connection_pool.j2ee.xatransactions_used");
            if (xaTransactionsUsed == null) {
                xaTransactionsUsed = props.get("ume.db.connection_pool.j2ee.xatransactions_used", "false");
            }
            if ((jtaTransactionsSupported = dsConf.getPrivateAttribute("ume.db.connection_pool.j2ee.jta_transaction_support_enabled")) == null) {
                jtaTransactionsSupported = props.get("ume.db.connection_pool.j2ee.jta_transaction_support_enabled", "false");
            }
            if ((isUnicode = dsConf.getPrivateAttribute("ume.db.connection_pool.j2ee.is_unicode")) == null) {
                isUnicode = props.get("ume.db.connection_pool.j2ee.is_unicode", "true");
            }
            if ((isOracleNativeDriverUsed = dsConf.getPrivateAttribute("ume.db.connection_pool.j2ee.oracle_native_driver_used")) == null) {
                isOracleNativeDriverUsed = props.get("ume.db.connection_pool.j2ee.oracle_native_driver_used", "false");
            }
            if (mTrace.beInfo()) {
                mTrace.infoT(methodName, "Using initial context factory: " + this.dataBaseContextFactory);
                mTrace.infoT(methodName, "Using provider url: " + this.dataBaseProviderUrl);
                mTrace.infoT(methodName, "Using XATransactions: " + xaTransactionsUsed);
                mTrace.infoT(methodName, "Supporting JTATransactions: " + jtaTransactionsSupported);
                mTrace.infoT(methodName, "Using max. number of arguments for or searches: " + this.mOrSearchMaxArguments);
                mTrace.infoT(methodName, "Using Unicode: " + isUnicode);
                mTrace.infoT(methodName, "Using Oracle native driver: " + isOracleNativeDriverUsed);
                mTrace.infoT(methodName, "Try to lookup: " + connectionPool);
            }
            boolean xaTransactionsUsedValue = xaTransactionsUsed.equalsIgnoreCase("true");
            boolean jtaTransactionsSupportedValue = jtaTransactionsSupported.equalsIgnoreCase("true");
            this.mUserTransactionPool = xaTransactionsUsedValue ? new J2EEUserTransactionPool() : null;
            this.mConnectionPool = new J2EEConnectionPool(connectionPool, xaTransactionsUsedValue, jtaTransactionsSupportedValue, isUnicode.equalsIgnoreCase("true"), isOracleNativeDriverUsed.equalsIgnoreCase("true"));
        }
        catch (InitializationException iex) {
            throw new PersistenceException((Throwable)((Object)iex), iex.getMessage() + "\n\t" + CONNECTION_POOL_PROPERTY + "=" + connectionPool + "\n\t" + "ume.db.connection_pool.j2ee.xatransactions_used" + "=" + xaTransactionsUsed + "\n\t" + "ume.db.connection_pool.j2ee.is_unicode" + "=" + isUnicode + "\n\t" + "ume.db.connection_pool.j2ee.oracle_native_driver_used" + "=" + isOracleNativeDriverUsed);
        }
        String useDBLocking = dsConf.getPrivateAttribute(USE_DEFAULT_TRANSACTION_ISOLATION);
        if (useDBLocking == null) {
            useDBLocking = props.get(USE_DEFAULT_TRANSACTION_ISOLATION);
        }
        this.mDefaultTransactionIsolation = -1;
        if ((useDBLocking == null || !"true".equalsIgnoreCase(useDBLocking)) && LockManager.getInstance().isLockingEnabled()) {
            this.mDefaultTransactionIsolation = 1;
            if (mTrace.beInfo()) {
                mTrace.infoT(methodName, "Using transaction isolation \"TRANSACTION_READ_UNCOMMITTED\"");
            }
        }
        try {
            this.principalsSeparatedInTablesByType = dsConf.getPrivateAttributeBooleanValue(PRINCIPALS_DISTRIBUTED_BY_TYPE_IDENTIFIER);
        }
        catch (PersistenceException pex) {
            if (mTrace.beInfo()) {
                mTrace.infoT(methodName, "Error while reading private property \"ume.db.table.principals_distributed_by_typeidentifier\"", (Throwable)((Object)pex));
            }
            this.principalsSeparatedInTablesByType = false;
        }
        this.stringValueTable = dsConf.getPrivateAttribute(STRING_TABLE);
        if (this.stringValueTable == null) {
            this.stringValueTable = "UME_STRINGS";
        }
        this.blobValueTable = dsConf.getPrivateAttribute(BLOB_TABLE);
        if (this.blobValueTable == null) {
            this.blobValueTable = "UME_BLOBS";
        }
        this.principalIdColumn = dsConf.getPrivateAttribute(PID_COLUMN);
        if (this.principalIdColumn == null) {
            this.principalIdColumn = "PID";
        }
        this.nameSpaceColumn = dsConf.getPrivateAttribute(NAMESPACE_COLUMN);
        if (this.nameSpaceColumn == null) {
            this.nameSpaceColumn = "NAMESP";
        }
        this.attributeColumn = dsConf.getPrivateAttribute(ATTRIBUTE_COLUMN);
        if (this.attributeColumn == null) {
            this.attributeColumn = "ATTR";
        }
        this.attributeGUIDColumn = dsConf.getPrivateAttribute(ATTRIBUTE_GUID_COLUMN);
        if (this.attributeGUIDColumn == null) {
            this.attributeGUIDColumn = "ATTRGUID";
        }
        this.valueColumn = dsConf.getPrivateAttribute(VALUE_COLUMN);
        if (this.valueColumn == null) {
            this.valueColumn = "VAL";
        }
        this.upperValueColumn = dsConf.getPrivateAttribute(UPPER_VALUE_COLUMN);
        if (this.upperValueColumn == null) {
            this.upperValueColumn = "UPPERVAL";
        }
        this.principalIdHashColumn = dsConf.getPrivateAttribute(PID_HASH_COLUMN);
        if (this.principalIdHashColumn == null) {
            this.principalIdHashColumn = "PIDH";
        }
        this.nameSpaceHashColumn = dsConf.getPrivateAttribute(NAMESPACE_HASH_COLUMN);
        if (this.nameSpaceHashColumn == null) {
            this.nameSpaceHashColumn = "NAMESPH";
        }
        this.attributeHashColumn = dsConf.getPrivateAttribute(ATTRIBUTE_HASH_COLUMN);
        if (this.attributeHashColumn == null) {
            this.attributeHashColumn = "ATTRH";
        }
        this.valueHashColumn = dsConf.getPrivateAttribute(VALUE_HASH_COLUMN);
        if (this.valueHashColumn == null) {
            this.valueHashColumn = "VALH";
        }
        this.upperValueHashColumn = dsConf.getPrivateAttribute(UPPER_VALUE_HASH_COLUMN);
        if (this.upperValueHashColumn == null) {
            this.upperValueHashColumn = "UPPERVALH";
        }
        if (mTrace.beInfo()) {
            mTrace.infoT(methodName, "Using database table for strings: " + this.getRealTableName(this.stringValueTable, null));
            mTrace.infoT(methodName, "Using database table for blobs: " + this.getRealTableName(this.blobValueTable, null));
            StringBuffer sb = new StringBuffer();
            sb.append("|");
            sb.append(this.principalIdColumn);
            sb.append("|");
            sb.append(this.nameSpaceColumn);
            sb.append("|");
            sb.append(this.attributeColumn);
            sb.append("|");
            sb.append(this.attributeGUIDColumn);
            sb.append("|");
            sb.append(this.valueColumn);
            sb.append("|");
            sb.append(this.upperValueColumn);
            sb.append("|");
            sb.append(this.principalIdHashColumn);
            sb.append("|");
            sb.append(this.nameSpaceHashColumn);
            sb.append("|");
            sb.append(this.attributeHashColumn);
            sb.append("|");
            sb.append(this.valueHashColumn);
            sb.append("|");
            sb.append(this.upperValueHashColumn);
            sb.append("|");
            mTrace.infoT(methodName, "Using database table layout: " + sb.toString());
        }
        this.isInitialized = true;
        if (this.mConnectionPool.isOracleNativeDriverUsed()) {
            this.mOracleUtil = new OracleNativeUtil();
        }
        StringBuffer query = new StringBuffer();
        query.append("SELECT DISTINCT ");
        query.append(this.nameSpaceHashColumn);
        query.append(" FROM ");
        query.append(this.getRealTableName(this.stringValueTable, "USER"));
        Connection myCon = this.mConnectionPool.getConnection(methodName, this.mDefaultTransactionIsolation);
        PreparedStatement ps = null;
        ResultSet res = null;
        this.dbWasEmptyOnStartup = false;
        try {
            try {
                ps = myCon.prepareStatement(query.toString());
                res = ps.executeQuery();
                this.dbWasEmptyOnStartup = !res.next();
            }
            catch (SQLException sqlex) {
                throw new PersistenceException(sqlex);
            }
            Object var21_36 = null;
            this.closePreparedStatement(ps, methodName);
            this.closeResultSet(res, methodName);
            this.mConnectionPool.releaseConnection(myCon);
        }
        catch (Throwable throwable) {
            Object var21_37 = null;
            this.closePreparedStatement(ps, methodName);
            this.closeResultSet(res, methodName);
            this.mConnectionPool.releaseConnection(myCon);
            throw throwable;
        }
        this.mCheckUniquenessOfAttributeValues = props.getBoolean(CHECK_UNIQUENESS_OF_ATTRIBUTE_VALUES, true);
    }

    private String getRealTableName(String tableName, String principalTypeIdentifier) {
        if (this.principalsSeparatedInTablesByType) {
            StringBuffer result = new StringBuffer(tableName.length() + 5);
            result.append(tableName);
            result.append("_");
            if (principalTypeIdentifier != null) {
                result.append(principalTypeIdentifier);
            } else {
                result.append("<principalTypeIdentifier>");
            }
            return result.toString();
        }
        return tableName;
    }

    protected void convertSchema() {
        String methodName = "convertSchema";
        Connection myCon = null;
        String updateSchema = System.getProperty(UPDATE_DB_SCHEMA);
        boolean updateDBSchema = true;
        updateDBSchema = updateSchema == null ? UMFactory.getProperties().getBoolean(UPDATE_DB_SCHEMA, true) : updateSchema.equalsIgnoreCase("true");
        String updateData = System.getProperty(UPDATE_DB_DATA);
        boolean updateDBData = true;
        updateDBData = updateData == null ? UMFactory.getProperties().getBoolean(UPDATE_DB_DATA, true) : updateData.equalsIgnoreCase("true");
        if (!updateDBData && !updateDBSchema) {
            return;
        }
        try {
            block23: {
                try {
                    int i;
                    Vector result;
                    myCon = this.mConnectionPool.getConnection(methodName, this.mDefaultTransactionIsolation);
                    if (this.mConnectionPool.isXATransactionsUsed()) {
                        UserTransaction userTrans = this.mUserTransactionPool.getUserTransaction();
                        try {
                            int i2;
                            Vector result2;
                            if (userTrans.getStatus() == 6) {
                                userTrans.begin();
                            }
                            if (updateDBSchema) {
                                result2 = SP0_TO_SP1.changeSchema(myCon, userTrans, this.mConnectionPool.getDatabaseVendor());
                                if (mTrace.beInfo()) {
                                    i2 = 0;
                                    while (i2 < result2.size()) {
                                        mTrace.infoT(methodName, (String)result2.elementAt(i2));
                                        ++i2;
                                    }
                                }
                            }
                            if (!updateDBData) break block23;
                            result2 = SP0_TO_SP1.convertData(myCon, userTrans);
                            if (!mTrace.beInfo()) break block23;
                            i2 = 0;
                            while (i2 < result2.size()) {
                                mTrace.infoT(methodName, (String)result2.elementAt(i2));
                                ++i2;
                            }
                            break block23;
                        }
                        catch (NotSupportedException e) {
                            String errorMessage = e.getMessage();
                            if (mTrace.beInfo()) {
                                mTrace.infoT(methodName, errorMessage, e);
                            }
                            break block23;
                        }
                        catch (SystemException e) {
                            String errorMessage = e.getMessage();
                            if (!mTrace.beInfo()) break block23;
                            mTrace.infoT(methodName, errorMessage, e);
                        }
                        break block23;
                    }
                    if (updateDBSchema) {
                        result = SP0_TO_SP1.changeSchema(myCon, null, this.mConnectionPool.getDatabaseVendor());
                        if (mTrace.beInfo()) {
                            i = 0;
                            while (i < result.size()) {
                                mTrace.infoT(methodName, (String)result.elementAt(i));
                                ++i;
                            }
                        }
                    }
                    if (!updateDBData) break block23;
                    result = SP0_TO_SP1.convertData(myCon, null);
                    if (!mTrace.beInfo()) break block23;
                    i = 0;
                    while (i < result.size()) {
                        mTrace.infoT(methodName, (String)result.elementAt(i));
                        ++i;
                    }
                }
                catch (ConnectionTimeoutException ctoex) {
                    String errorMessage = ctoex.getMessage();
                    if (mTrace.beInfo()) {
                        mTrace.infoT(methodName, errorMessage, (Throwable)((Object)ctoex));
                    }
                    Object var12_19 = null;
                    if (myCon != null) {
                        this.mConnectionPool.releaseConnection(myCon);
                    }
                }
            }
            Object var12_18 = null;
            if (myCon != null) {
                this.mConnectionPool.releaseConnection(myCon);
            }
        }
        catch (Throwable throwable) {
            Object var12_20 = null;
            if (myCon != null) {
                this.mConnectionPool.releaseConnection(myCon);
            }
            throw throwable;
        }
    }

    public boolean wasEmptyOnStartup() {
        return this.dbWasEmptyOnStartup;
    }

    public IInternalPrincipalDatabag[] initPrincipalDatabags(IInternalPrincipalDatabag[] principals) throws PersistenceException {
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        int size = principals.length;
        int i = 0;
        while (i < size) {
            if (principals[i] != null && this.isHomeForPrincipalDatabag(principals[i])) {
                this.populatePrincipalDatabag(principals[i], null);
            }
            ++i;
        }
        return principals;
    }

    /*
     * Unable to fully structure code
     */
    public Collection[] getDirectParents(String[] principalids, String[] principalTypes) throws PersistenceException {
        block12: {
            size = principalTypes.length;
            responsibleTypes = null;
            i = 0;
            while (i < size) {
                if (this.feelsResponsible(principalTypes[i], "com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE")) {
                    if (responsibleTypes == null) {
                        responsibleTypes = new HashSet<String>(size);
                    }
                    responsibleTypes.add(principalTypes[i]);
                }
                ++i;
            }
            if (responsibleTypes == null || responsibleTypes.isEmpty()) {
                return null;
            }
            size = responsibleTypes.size();
            tables = new HashSet<String>();
            cacheKeyType = null;
            tempBuffer = new StringBuffer(size * 5);
            iter = responsibleTypes.iterator();
            while (iter.hasNext()) {
                currentType = (String)iter.next();
                tempBuffer.append(currentType);
                tempBuffer.append("_");
                tables.add(this.getRealTableName(this.stringValueTable, currentType));
            }
            cacheKeyType = tempBuffer.toString();
            size = principalids.length;
            result = new Collection[size];
            it = tables.iterator();
            if (principalids.length <= this.mOrParentSearchMaxArguments) ** GOTO lbl60
            while (it.hasNext()) {
                tableName = (String)it.next();
                currentPage = 0;
                while (currentPage * this.mOrParentSearchMaxArguments < size) {
                    alreadyProcessed = currentPage * this.mOrParentSearchMaxArguments;
                    if (size < (currentPage + 1) * this.mOrParentSearchMaxArguments) {
                        pageResult = new Collection[size - alreadyProcessed];
                        pageIds = new String[size - alreadyProcessed];
                    } else {
                        pageResult = new Collection[this.mOrParentSearchMaxArguments];
                        pageIds = new String[this.mOrParentSearchMaxArguments];
                    }
                    i = 0;
                    while (i < pageResult.length) {
                        pageIds[i] = principalids[alreadyProcessed + i];
                        ++i;
                    }
                    this.getDirectParentsInternal(pageIds, tableName, responsibleTypes, cacheKeyType, pageResult);
                    i = 0;
                    while (i < pageResult.length) {
                        result[alreadyProcessed + i] = pageResult[i];
                        ++i;
                    }
                    ++currentPage;
                }
            }
            break block12;
lbl-1000:
            // 1 sources

            {
                this.getDirectParentsInternal(principalids, (String)it.next(), responsibleTypes, cacheKeyType, result);
lbl60:
                // 2 sources

                ** while (it.hasNext())
            }
        }
        return result;
    }

    private void getDirectParentsInternal(String[] principalids, String tableName, Collection principalTypes, String cacheKey, Collection[] result) throws PersistenceException {
        if (principalids == null || principalids.length == 0 || principalTypes == null || principalTypes.isEmpty()) {
            return;
        }
        String methodName = "getDirectParentsInternal";
        String cachedSearchString = DataBaseStringsPool.getInstance().getDataBaseString("DP", cacheKey);
        StringBuffer sqlString = null;
        if (cachedSearchString == null) {
            sqlString = new StringBuffer();
            sqlString.append("SELECT DISTINCT ");
            sqlString.append(this.principalIdColumn);
            sqlString.append(",");
            sqlString.append(this.valueColumn);
            sqlString.append(" FROM ");
            sqlString.append(tableName);
            sqlString.append(" WHERE (");
            boolean firstSet = false;
            Iterator iter = principalTypes.iterator();
            while (iter.hasNext()) {
                if (firstSet) {
                    sqlString.append(" OR ");
                }
                sqlString.append("(");
                sqlString.append(this.principalIdColumn);
                sqlString.append(" LIKE '");
                sqlString.append(this.encodeLikeStringForDB((String)iter.next()));
                sqlString.append("%')");
                firstSet = true;
            }
            sqlString.append(")");
            sqlString.append(" AND (");
            sqlString.append(this.nameSpaceColumn);
            sqlString.append(" = ?) AND (");
            sqlString.append(this.nameSpaceHashColumn);
            sqlString.append(" = ?) AND (");
            sqlString.append(this.attributeColumn);
            sqlString.append(" = ?) AND (");
            sqlString.append(this.attributeHashColumn);
            sqlString.append(" = ?) AND (");
            cachedSearchString = sqlString.toString();
            DataBaseStringsPool.getInstance().storeDataBaseString("DP", cacheKey, cachedSearchString);
        }
        StringBuffer realQueryString = new StringBuffer(cachedSearchString.length() * 2);
        realQueryString.append(cachedSearchString);
        int size = principalids.length;
        boolean firstSet = false;
        int i = 0;
        while (i < size) {
            if (principalids[i] != null) {
                if (firstSet) {
                    realQueryString.append(" OR ");
                }
                realQueryString.append("((");
                realQueryString.append(this.valueColumn);
                realQueryString.append(" = ?) AND (");
                realQueryString.append(this.valueHashColumn);
                realQueryString.append(" = ?))");
                firstSet = true;
            }
            ++i;
        }
        realQueryString.append(")");
        Connection myCon = this.mConnectionPool.getConnection("getDirectParentsInternal", this.mDefaultTransactionIsolation);
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            try {
                HashSet<String> dummy;
                int counter = 1;
                if (mTrace.beInfo()) {
                    mTrace.infoT("getDirectParentsInternal", "Perform parent search query: " + realQueryString.toString());
                }
                ps = myCon.prepareStatement(realQueryString.toString());
                ps.setObject(counter, "com.sap.security.core.usermanagement.relation");
                ps.setLong(++counter, Util.getHash("com.sap.security.core.usermanagement.relation"));
                ps.setObject(++counter, "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE");
                ps.setLong(++counter, Util.getHash("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE"));
                ++counter;
                int valuesSize = principalids.length;
                int i2 = 0;
                while (i2 < valuesSize) {
                    if (principalids[i2] != null) {
                        ps.setObject(counter, principalids[i2]);
                        ps.setLong(++counter, Util.getHash(principalids[i2]));
                        ++counter;
                    }
                    ++i2;
                }
                rs = ps.executeQuery();
                HashMap<String, HashSet<String>> map = new HashMap<String, HashSet<String>>();
                while (rs.next()) {
                    String pid = rs.getString(this.principalIdColumn).trim();
                    String val = rs.getString(this.valueColumn);
                    dummy = (HashSet<String>)map.get(val);
                    if (dummy == null) {
                        dummy = new HashSet<String>();
                        map.put(val, dummy);
                    }
                    dummy.add(pid);
                }
                int i3 = 0;
                while (i3 < valuesSize) {
                    if (principalids[i3] != null && (dummy = (Collection)map.get(principalids[i3])) != null) {
                        if (result[i3] == null) {
                            result[i3] = new HashSet(dummy.size());
                        }
                        result[i3].addAll(dummy);
                    }
                    ++i3;
                }
            }
            catch (SQLException sqlex) {
                throw new PersistenceException(sqlex);
            }
            Object var25_27 = null;
            this.closeResultSet(rs, "getDirectParentsInternal");
            this.closePreparedStatement(ps, "getDirectParentsInternal");
            this.mConnectionPool.releaseConnection(myCon);
        }
        catch (Throwable throwable) {
            Object var25_28 = null;
            this.closeResultSet(rs, "getDirectParentsInternal");
            this.closePreparedStatement(ps, "getDirectParentsInternal");
            this.mConnectionPool.releaseConnection(myCon);
            throw throwable;
        }
    }

    public void populatePrincipalDatabags(IInternalPrincipalDatabag[] principals, AttributeList populateAttributes) throws PersistenceException {
        String methodName = "populatePrincipalDatabags";
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        if (!this.feelsResponsible(principals[0])) {
            return;
        }
        String[] idParts = principals[0].getIDParts();
        String type = idParts[0];
        boolean stringFound = false;
        boolean blobFound = false;
        Hashtable nameSpaces = (Hashtable)this.mConfigurationModel.getPopulateInitially(type).clone();
        if (populateAttributes != null) {
            int i = 0;
            while (i < populateAttributes.getSize()) {
                String myAttributeName;
                String myNameSpace = populateAttributes.getNameSpaceOfAttributeAt(i);
                if (this.feelsResponsible(type, myNameSpace, myAttributeName = populateAttributes.getAttributeNameOfAttributeAt(i))) {
                    Vector<String> dummy = (Vector<String>)nameSpaces.get(myNameSpace);
                    if (dummy == null) {
                        dummy = new Vector<String>();
                    }
                    dummy.add(myAttributeName);
                    nameSpaces.put(myNameSpace, dummy);
                }
                ++i;
            }
        }
        boolean stringAttributeToPopulateFound = false;
        boolean blobAttributeToPopulateFound = false;
        if (!nameSpaces.isEmpty()) {
            String attribute;
            String nameSpace;
            StringBuffer queryPart1 = new StringBuffer();
            StringBuffer queryPart2 = new StringBuffer();
            StringBuffer queryPart3 = new StringBuffer();
            queryPart1.append("SELECT ");
            queryPart1.append(this.principalIdColumn);
            queryPart1.append(",");
            queryPart1.append(this.nameSpaceColumn);
            queryPart1.append(",");
            queryPart1.append(this.attributeColumn);
            queryPart1.append(",");
            queryPart1.append(this.valueColumn);
            queryPart1.append(" FROM ");
            queryPart2.append(" WHERE (");
            queryPart3.append(" WHERE (");
            queryPart2.append("(");
            queryPart3.append("(");
            boolean firstPrincipalIdSet = false;
            int i = 0;
            while (i < principals.length) {
                if (firstPrincipalIdSet) {
                    queryPart2.append(" OR ");
                    queryPart3.append(" OR ");
                } else {
                    firstPrincipalIdSet = true;
                }
                queryPart2.append("((");
                queryPart3.append("((");
                queryPart2.append(this.principalIdColumn);
                queryPart3.append(this.principalIdColumn);
                queryPart2.append(" = ?) AND (");
                queryPart3.append(" = ?) AND (");
                queryPart2.append(this.principalIdHashColumn);
                queryPart3.append(this.principalIdHashColumn);
                queryPart2.append(" = ?))");
                queryPart3.append(" = ?))");
                ++i;
            }
            queryPart2.append(")");
            queryPart3.append(")");
            Vector<String> queryValues = new Vector<String>();
            Vector<String> queryValues2 = new Vector<String>();
            Hashtable<String, IInternalPrincipalDatabag> principalTable = new Hashtable<String, IInternalPrincipalDatabag>();
            int i2 = 0;
            while (i2 < principals.length) {
                queryValues.add(principals[i2].getUniqueID());
                queryValues2.add(principals[i2].getUniqueID());
                principalTable.put(principals[i2].getUniqueID(), principals[i2]);
                ++i2;
            }
            int attrType = 0;
            boolean firstSet = false;
            boolean firstSet2 = false;
            Enumeration en = nameSpaces.keys();
            while (en.hasMoreElements()) {
                nameSpace = (String)en.nextElement();
                Vector attributes = (Vector)nameSpaces.get(nameSpace);
                if (attributes == null) continue;
                int size = attributes.size();
                int i3 = 0;
                while (i3 < size) {
                    String physicalAttribute;
                    attribute = (String)attributes.elementAt(i3);
                    attrType = this.mConfigurationModel.getAttributeType(type, nameSpace, attribute);
                    if (attrType == 0) {
                        attrType = populateAttributes.getAttributeType(nameSpace, attribute);
                    }
                    if (attrType == 1 || attrType == 0) {
                        stringAttributeToPopulateFound = true;
                        if (firstSet) {
                            queryPart2.append(" OR ");
                        } else {
                            queryPart2.append("AND (");
                        }
                        queryPart2.append("((");
                        queryPart2.append(this.nameSpaceColumn);
                        queryPart2.append("=?) AND (");
                        queryPart2.append(this.nameSpaceHashColumn);
                        queryPart2.append("=?) AND (");
                        queryPart2.append(this.attributeColumn);
                        queryPart2.append("=?) AND (");
                        queryPart2.append(this.attributeHashColumn);
                        queryPart2.append("=?))");
                        firstSet = true;
                        queryValues.add(nameSpace);
                        physicalAttribute = this.getPhysicalAttribute(type, nameSpace, attribute);
                        queryValues.add(physicalAttribute);
                    }
                    if (attrType == 2 || attrType == 0) {
                        blobAttributeToPopulateFound = true;
                        if (firstSet2) {
                            queryPart3.append(" OR ");
                        } else {
                            queryPart3.append("AND (");
                        }
                        queryPart3.append("((");
                        queryPart3.append(this.nameSpaceColumn);
                        queryPart3.append("=?) AND (");
                        queryPart3.append(this.nameSpaceHashColumn);
                        queryPart3.append("=?) AND (");
                        queryPart3.append(this.attributeColumn);
                        queryPart3.append("=?) AND (");
                        queryPart3.append(this.attributeHashColumn);
                        queryPart3.append("=?))");
                        firstSet2 = true;
                        queryValues2.add(nameSpace);
                        physicalAttribute = this.getPhysicalAttribute(type, nameSpace, attribute);
                        queryValues2.add(physicalAttribute);
                    }
                    ++i3;
                }
            }
            if (firstSet) {
                queryPart2.append(")");
            }
            if (firstSet2) {
                queryPart3.append(")");
            }
            queryPart2.append(")");
            queryPart3.append(")");
            Connection myCon = this.mConnectionPool.getConnection(methodName, this.mDefaultTransactionIsolation);
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    String readPrincipalID;
                    int i4;
                    int size;
                    StringBuffer query;
                    if (stringAttributeToPopulateFound) {
                        query = new StringBuffer();
                        query.append(queryPart1.toString());
                        query.append(this.getRealTableName(this.stringValueTable, type));
                        query.append(queryPart2.toString());
                        if (mTrace.beInfo()) {
                            mTrace.infoT(methodName, "Perform query: " + query.toString());
                        }
                        ps = myCon.prepareStatement(query.toString());
                        size = queryValues.size();
                        i4 = 0;
                        while (i4 < size) {
                            ps.setObject(i4 * 2 + 1, (String)queryValues.elementAt(i4));
                            ps.setLong(i4 * 2 + 2, Util.getHash((String)queryValues.elementAt(i4)));
                            ++i4;
                        }
                        rs = ps.executeQuery();
                        Vector attribs = null;
                        while (rs.next()) {
                            Object value;
                            readPrincipalID = rs.getString(this.principalIdColumn);
                            nameSpace = rs.getString(this.nameSpaceColumn);
                            attribute = rs.getString(this.attributeColumn);
                            attribs = (Vector)nameSpaces.get(nameSpace);
                            if (attribs != null && !attribs.isEmpty() && attribs.contains(attribute)) {
                                attribs.remove(attribute);
                                if (!attribs.isEmpty()) {
                                    nameSpaces.put(nameSpace, attribs);
                                } else {
                                    nameSpaces.remove(nameSpace);
                                }
                            }
                            if ((value = rs.getObject(this.valueColumn)).equals(THIS_REPLACES_THE_EMPTY_STRING_FOR_ORACLE)) {
                                value = "";
                            }
                            IInternalPrincipalDatabag principalDatabag = (IInternalPrincipalDatabag)principalTable.get(readPrincipalID);
                            principalDatabag.addAttributeValue(nameSpace, this.getLogicalAttribute(type, nameSpace, attribute), value);
                            if (principalDatabag.getIDParts()[1].equals(this.getId())) {
                                principalDatabag.setExists(true);
                            }
                            stringFound = true;
                        }
                        ps.close();
                        ps = null;
                        rs.close();
                        rs = null;
                    } else if (mTrace.beInfo()) {
                        mTrace.infoT(methodName, "No string attributes requested.");
                    }
                    if (!nameSpaces.isEmpty() && firstSet2) {
                        if (blobAttributeToPopulateFound) {
                            query = new StringBuffer();
                            query.append(queryPart1.toString());
                            query.append(this.getRealTableName(this.blobValueTable, type));
                            query.append(queryPart3.toString());
                            if (mTrace.beInfo()) {
                                mTrace.infoT(methodName, "Perform query: " + query.toString());
                            }
                            ps = myCon.prepareStatement(query.toString());
                            size = queryValues2.size();
                            i4 = 0;
                            while (i4 < size) {
                                ps.setObject(i4 * 2 + 1, (String)queryValues2.elementAt(i4));
                                ps.setLong(i4 * 2 + 2, Util.getHash((String)queryValues2.elementAt(i4)));
                                ++i4;
                            }
                            rs = ps.executeQuery();
                            while (rs.next()) {
                                Object var41_54;
                                readPrincipalID = rs.getString(this.principalIdColumn);
                                nameSpace = rs.getString(this.nameSpaceColumn);
                                attribute = rs.getString(this.attributeColumn);
                                InputStream is = null;
                                try {
                                    block55: {
                                        try {
                                            is = rs.getBinaryStream(this.valueColumn);
                                            byte[] aReadBuffer = new byte[1024];
                                            int iBytesRead = 0;
                                            ByteArrayOutputStream bBuffer = new ByteArrayOutputStream();
                                            while ((iBytesRead = is.read(aReadBuffer)) >= 0) {
                                                bBuffer.write(aReadBuffer, 0, iBytesRead);
                                            }
                                            IInternalPrincipalDatabag principalDatabag = (IInternalPrincipalDatabag)principalTable.get(readPrincipalID);
                                            principalDatabag.addAttributeValue(nameSpace, this.getLogicalAttribute(type, nameSpace, attribute), bBuffer.toByteArray());
                                            if (!principalDatabag.getIDParts()[1].equals(this.getId())) break block55;
                                            principalDatabag.setExists(true);
                                        }
                                        catch (IOException ioex) {
                                            throw new PersistenceException(ioex);
                                        }
                                    }
                                    var41_54 = null;
                                    this.closeInputStream(is, methodName);
                                }
                                catch (Throwable throwable) {
                                    var41_54 = null;
                                    this.closeInputStream(is, methodName);
                                    throw throwable;
                                }
                                blobFound = true;
                            }
                        } else if (mTrace.beInfo()) {
                            mTrace.infoT(methodName, "No binary attributes requested.");
                        }
                    }
                    int i5 = 0;
                    while (i5 < principals.length) {
                        principals[i5] = (IInternalPrincipalDatabag)principalTable.get(principals[i5].getUniqueID());
                        ++i5;
                    }
                }
                catch (SQLException sqlex) {
                    throw new PersistenceException(sqlex);
                }
                Object var43_56 = null;
                this.closeResultSet(rs, methodName);
                this.closePreparedStatement(ps, methodName);
                this.mConnectionPool.releaseConnection(myCon);
            }
            catch (Throwable throwable) {
                Object var43_57 = null;
                this.closeResultSet(rs, methodName);
                this.closePreparedStatement(ps, methodName);
                this.mConnectionPool.releaseConnection(myCon);
                throw throwable;
            }
            if (!stringFound && !blobFound) {
                return;
            }
            Enumeration en2 = nameSpaces.keys();
            while (en2.hasMoreElements()) {
                nameSpace = (String)en2.nextElement();
                Vector attributes = (Vector)nameSpaces.get(nameSpace);
                if (attributes == null) continue;
                int i6 = 0;
                while (i6 < attributes.size()) {
                    int j = 0;
                    while (j < principals.length) {
                        attribute = (String)attributes.elementAt(i6);
                        Vector values = principals[j].getAttributeValues(nameSpace, attribute);
                        if (values == null) {
                            principals[j].setAttributeValues(nameSpace, attribute, new Vector());
                        }
                        ++j;
                    }
                    ++i6;
                }
            }
        }
    }

    public void populatePrincipalDatabag(IInternalPrincipalDatabag principal, AttributeList populateAttributes) throws PersistenceException {
        String methodName = "populatePrincipalDatabag";
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        if (!this.feelsResponsible(principal)) {
            return;
        }
        String id = principal.getUniqueID();
        String[] idParts = principal.getIDParts();
        String type = idParts[0];
        Hashtable nameSpaces = (Hashtable)this.mConfigurationModel.getPopulateInitially(type).clone();
        if (populateAttributes != null) {
            int i = 0;
            while (i < populateAttributes.getSize()) {
                String myAttributeName;
                String myNameSpace = populateAttributes.getNameSpaceOfAttributeAt(i);
                if (this.feelsResponsible(type, myNameSpace, myAttributeName = populateAttributes.getAttributeNameOfAttributeAt(i))) {
                    Vector<String> dummy = (Vector<String>)nameSpaces.get(myNameSpace);
                    if (dummy == null) {
                        dummy = new Vector<String>();
                    }
                    dummy.add(myAttributeName);
                    nameSpaces.put(myNameSpace, dummy);
                }
                ++i;
            }
        }
        boolean stringAttributeToPopulateFound = false;
        boolean blobAttributeToPopulateFound = false;
        if (!nameSpaces.isEmpty()) {
            String attribute;
            String nameSpace;
            StringBuffer queryPart1 = new StringBuffer();
            StringBuffer queryPart2 = new StringBuffer();
            StringBuffer queryPart3 = new StringBuffer();
            queryPart1.append("SELECT ");
            queryPart1.append(this.nameSpaceColumn);
            queryPart1.append(",");
            queryPart1.append(this.attributeColumn);
            queryPart1.append(",");
            queryPart1.append(this.valueColumn);
            queryPart1.append(" FROM ");
            queryPart2.append(" WHERE ");
            queryPart3.append(" WHERE ");
            queryPart2.append("((");
            queryPart3.append("((");
            queryPart2.append(this.principalIdColumn);
            queryPart3.append(this.principalIdColumn);
            queryPart2.append(" = ?) AND (");
            queryPart3.append(" = ?) AND (");
            queryPart2.append(this.principalIdHashColumn);
            queryPart3.append(this.principalIdHashColumn);
            queryPart2.append(" = ?))");
            queryPart3.append(" = ?))");
            Vector<String> queryValues = new Vector<String>();
            Vector<String> queryValues2 = new Vector<String>();
            queryValues.add(id);
            queryValues2.add(id);
            boolean firstSet = false;
            boolean firstSet2 = false;
            boolean nameSpaceSetString = false;
            boolean nameSpaceSetBlob = false;
            boolean attributeSetString = false;
            boolean attributeSetBlob = false;
            int attrType = 0;
            Enumeration en = nameSpaces.keys();
            while (en.hasMoreElements()) {
                nameSpace = (String)en.nextElement();
                nameSpaceSetString = false;
                nameSpaceSetBlob = false;
                Vector attributes = (Vector)nameSpaces.get(nameSpace);
                attributeSetString = false;
                attributeSetBlob = false;
                if (attributes == null) continue;
                int size = attributes.size();
                int i = 0;
                while (i < size) {
                    String physicalAttribute;
                    attribute = (String)attributes.elementAt(i);
                    attrType = this.mConfigurationModel.getAttributeType(type, nameSpace, attribute);
                    if (attrType == 0) {
                        attrType = populateAttributes.getAttributeType(nameSpace, attribute);
                    }
                    if (attrType == 1 || attrType == 0) {
                        stringAttributeToPopulateFound = true;
                        if (!firstSet) {
                            queryPart2.append(" AND ((");
                        }
                        if (!nameSpaceSetString) {
                            if (firstSet) {
                                queryPart2.append(" OR (");
                            }
                            queryPart2.append(this.createOrSubQueryNameSpacePart());
                            queryPart2.append(" AND (");
                            nameSpaceSetString = true;
                            queryValues.add(nameSpace);
                        }
                        if (attributeSetString) {
                            queryPart2.append(" OR ");
                        }
                        queryPart2.append(this.createOrSubQueryAttributePart());
                        physicalAttribute = this.getPhysicalAttribute(type, nameSpace, attribute);
                        queryValues.add(physicalAttribute);
                        firstSet = true;
                        attributeSetString = true;
                    }
                    if (attrType == 2 || attrType == 0) {
                        blobAttributeToPopulateFound = true;
                        if (!firstSet2) {
                            queryPart3.append(" AND ((");
                        }
                        if (!nameSpaceSetBlob) {
                            if (firstSet2) {
                                queryPart3.append(" OR (");
                            }
                            queryPart3.append(this.createOrSubQueryNameSpacePart());
                            queryPart3.append(" AND (");
                            nameSpaceSetBlob = true;
                            queryValues2.add(nameSpace);
                        }
                        if (attributeSetBlob) {
                            queryPart3.append(" OR ");
                        }
                        queryPart3.append(this.createOrSubQueryAttributePart());
                        physicalAttribute = this.getPhysicalAttribute(type, nameSpace, attribute);
                        queryValues2.add(physicalAttribute);
                        firstSet2 = true;
                        attributeSetBlob = true;
                    }
                    ++i;
                }
                if (attributeSetString) {
                    queryPart2.append("))");
                }
                if (!attributeSetBlob) continue;
                queryPart3.append("))");
            }
            if (firstSet) {
                queryPart2.append(")");
            }
            if (firstSet2) {
                queryPart3.append(")");
            }
            Connection myCon = this.mConnectionPool.getConnection("populatePrincipalDatabag", this.mDefaultTransactionIsolation);
            PreparedStatement ps = null;
            ResultSet rs = null;
            boolean homeDS = idParts[1].equals(this.getId());
            boolean sthingFound = false;
            try {
                block52: {
                    try {
                        int i;
                        int size;
                        StringBuffer query;
                        if (stringAttributeToPopulateFound) {
                            query = new StringBuffer(queryPart1.length() + 20 + queryPart2.length());
                            query.append(queryPart1.toString());
                            query.append(this.getRealTableName(this.stringValueTable, type));
                            query.append(queryPart2.toString());
                            if (mTrace.beInfo()) {
                                mTrace.infoT("populatePrincipalDatabag", "Perform query: " + query.toString());
                            }
                            ps = myCon.prepareStatement(query.toString());
                            size = queryValues.size();
                            i = 0;
                            while (i < size) {
                                ps.setObject(i * 2 + 1, (String)queryValues.elementAt(i));
                                ps.setLong(i * 2 + 2, Util.getHash((String)queryValues.elementAt(i)));
                                ++i;
                            }
                            rs = ps.executeQuery();
                            Vector attribs = null;
                            while (rs.next()) {
                                Object value;
                                sthingFound = true;
                                nameSpace = rs.getString(this.nameSpaceColumn);
                                attribute = rs.getString(this.attributeColumn);
                                attribs = (Vector)nameSpaces.get(nameSpace);
                                if (attribs != null && !attribs.isEmpty() && attribs.contains(attribute)) {
                                    attribs.remove(attribute);
                                    if (!attribs.isEmpty()) {
                                        nameSpaces.put(nameSpace, attribs);
                                    } else {
                                        nameSpaces.remove(nameSpace);
                                    }
                                }
                                if ((value = rs.getObject(this.valueColumn)).equals(THIS_REPLACES_THE_EMPTY_STRING_FOR_ORACLE)) {
                                    value = "";
                                }
                                principal.addAttributeValue(nameSpace, this.getLogicalAttribute(type, nameSpace, attribute), value);
                            }
                            ps.close();
                            ps = null;
                            rs.close();
                            rs = null;
                        } else if (mTrace.beInfo()) {
                            mTrace.infoT("populatePrincipalDatabag", "No string attributes requested.");
                        }
                        if (!nameSpaces.isEmpty() && firstSet2) {
                            if (blobAttributeToPopulateFound) {
                                query = new StringBuffer(queryPart1.length() + 20 + queryPart3.length());
                                query.append(queryPart1.toString());
                                query.append(this.getRealTableName(this.blobValueTable, type));
                                query.append(queryPart3.toString());
                                if (mTrace.beInfo()) {
                                    mTrace.infoT("populatePrincipalDatabag", "Perform query: " + query.toString());
                                }
                                ps = myCon.prepareStatement(query.toString());
                                size = queryValues2.size();
                                i = 0;
                                while (i < size) {
                                    ps.setObject(i * 2 + 1, (String)queryValues2.elementAt(i));
                                    ps.setLong(i * 2 + 2, Util.getHash((String)queryValues2.elementAt(i)));
                                    ++i;
                                }
                                rs = ps.executeQuery();
                                while (rs.next()) {
                                    Object var40_50;
                                    sthingFound = true;
                                    nameSpace = rs.getString(this.nameSpaceColumn);
                                    attribute = rs.getString(this.attributeColumn);
                                    InputStream is = null;
                                    try {
                                        try {
                                            is = rs.getBinaryStream(this.valueColumn);
                                            byte[] aReadBuffer = new byte[1024];
                                            int iBytesRead = 0;
                                            ByteArrayOutputStream bBuffer = new ByteArrayOutputStream();
                                            while ((iBytesRead = is.read(aReadBuffer)) >= 0) {
                                                bBuffer.write(aReadBuffer, 0, iBytesRead);
                                            }
                                            principal.addAttributeValue(nameSpace, this.getLogicalAttribute(type, nameSpace, attribute), bBuffer.toByteArray());
                                        }
                                        catch (IOException ioex) {
                                            throw new PersistenceException(ioex);
                                        }
                                        var40_50 = null;
                                        this.closeInputStream(is, "populatePrincipalDatabag");
                                    }
                                    catch (Throwable throwable) {
                                        var40_50 = null;
                                        this.closeInputStream(is, "populatePrincipalDatabag");
                                        throw throwable;
                                    }
                                }
                            } else if (mTrace.beInfo()) {
                                mTrace.infoT("populatePrincipalDatabag", "No binary attributes requested.");
                            }
                        }
                        if (!homeDS || !sthingFound) break block52;
                        principal.setExists(true);
                    }
                    catch (SQLException sqlex) {
                        throw new PersistenceException(sqlex);
                    }
                }
                Object var42_52 = null;
                this.closeResultSet(rs, "populatePrincipalDatabag");
                this.closePreparedStatement(ps, "populatePrincipalDatabag");
                this.mConnectionPool.releaseConnection(myCon);
            }
            catch (Throwable throwable) {
                Object var42_53 = null;
                this.closeResultSet(rs, "populatePrincipalDatabag");
                this.closePreparedStatement(ps, "populatePrincipalDatabag");
                this.mConnectionPool.releaseConnection(myCon);
                throw throwable;
            }
            Enumeration en2 = nameSpaces.keys();
            while (en2.hasMoreElements()) {
                nameSpace = (String)en2.nextElement();
                Vector attributes = (Vector)nameSpaces.get(nameSpace);
                if (attributes == null) continue;
                int i = 0;
                while (i < attributes.size()) {
                    attribute = (String)attributes.elementAt(i);
                    Vector values = principal.getAttributeValues(nameSpace, attribute);
                    if (values == null) {
                        principal.setAttributeValues(nameSpace, attribute, new Vector());
                    }
                    ++i;
                }
            }
        }
    }

    public boolean populatePrincipalDatabag(IInternalPrincipalDatabag principal, String nameSpace, String attribute) throws PersistenceException {
        String methodName = "populatePrincipalDatabag";
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        if (!this.feelsResponsible(principal, nameSpace, attribute)) {
            return false;
        }
        String principalDatabagID = principal.getUniqueID();
        String[] idParts = principal.getIDParts();
        String type = idParts[0];
        boolean homeDS = idParts[1].equals(this.getId());
        String cachedQuery = null;
        StringBuffer query = null;
        cachedQuery = DataBaseStringsPool.getInstance().getDataBaseString("SAS", type);
        if (cachedQuery == null) {
            query = new StringBuffer();
            query.append("SELECT DISTINCT ");
            query.append(this.valueColumn);
            query.append(" FROM ");
            query.append(this.getRealTableName(this.stringValueTable, type));
            query.append(" WHERE ((");
            query.append(this.principalIdColumn);
            query.append("=?)");
            query.append(" AND (");
            query.append(this.principalIdHashColumn);
            query.append("=?)");
            query.append(" AND (");
            query.append(this.nameSpaceColumn);
            query.append("=?)");
            query.append(" AND (");
            query.append(this.nameSpaceHashColumn);
            query.append("=?)");
            query.append(" AND (");
            query.append(this.attributeColumn);
            query.append("=?)");
            query.append(" AND (");
            query.append(this.attributeHashColumn);
            query.append("=?))");
        }
        Connection myCon = this.mConnectionPool.getConnection(methodName, this.mDefaultTransactionIsolation);
        PreparedStatement ps = null;
        ResultSet rs = null;
        Vector<Object> result = null;
        boolean sthingFound = false;
        try {
            block27: {
                try {
                    if (mTrace.beInfo()) {
                        if (cachedQuery == null) {
                            mTrace.infoT(methodName, "Perform query: " + query.toString());
                        } else {
                            mTrace.infoT(methodName, "Perform query: " + cachedQuery);
                        }
                    }
                    if (cachedQuery == null) {
                        ps = myCon.prepareStatement(query.toString());
                        DataBaseStringsPool.getInstance().storeDataBaseString("SAS", type, query.toString());
                    } else {
                        ps = myCon.prepareStatement(cachedQuery);
                    }
                    ps.setObject(1, principalDatabagID);
                    ps.setLong(2, Util.getHash(principalDatabagID));
                    ps.setObject(3, nameSpace);
                    ps.setLong(4, Util.getHash(nameSpace));
                    ps.setObject(5, this.getPhysicalAttribute(type, nameSpace, attribute));
                    ps.setLong(6, Util.getHash(this.getPhysicalAttribute(type, nameSpace, attribute)));
                    rs = ps.executeQuery();
                    result = new Vector<Object>();
                    while (rs.next()) {
                        sthingFound = true;
                        String value = rs.getString(this.valueColumn);
                        if (value.equals(THIS_REPLACES_THE_EMPTY_STRING_FOR_ORACLE)) {
                            value = "";
                        }
                        result.add(value);
                    }
                    rs.close();
                    rs = null;
                    ps.close();
                    ps = null;
                    if (result.size() == 0) {
                        cachedQuery = DataBaseStringsPool.getInstance().getDataBaseString("SAB", type);
                        if (cachedQuery == null) {
                            query = new StringBuffer();
                            query.append("SELECT ");
                            query.append(this.valueColumn);
                            query.append(" FROM ");
                            query.append(this.getRealTableName(this.blobValueTable, type));
                            query.append(" WHERE ((");
                            query.append(this.principalIdColumn);
                            query.append("=?)");
                            query.append(" AND (");
                            query.append(this.principalIdHashColumn);
                            query.append("=?)");
                            query.append(" AND (");
                            query.append(this.nameSpaceColumn);
                            query.append("=?)");
                            query.append(" AND (");
                            query.append(this.nameSpaceHashColumn);
                            query.append("=?)");
                            query.append(" AND (");
                            query.append(this.attributeColumn);
                            query.append("=?)");
                            query.append(" AND (");
                            query.append(this.attributeHashColumn);
                            query.append("=?))");
                        }
                        if (mTrace.beInfo()) {
                            if (cachedQuery == null) {
                                mTrace.infoT(methodName, "Perform query: " + query.toString());
                            } else {
                                mTrace.infoT(methodName, "Perform query: " + cachedQuery);
                            }
                        }
                        if (cachedQuery == null) {
                            ps = myCon.prepareStatement(query.toString());
                            DataBaseStringsPool.getInstance().storeDataBaseString("SAB", type, query.toString());
                        } else {
                            ps = myCon.prepareStatement(cachedQuery);
                        }
                        ps.setObject(1, principalDatabagID);
                        ps.setLong(2, Util.getHash(principalDatabagID));
                        ps.setObject(3, nameSpace);
                        ps.setLong(4, Util.getHash(nameSpace));
                        ps.setObject(5, this.getPhysicalAttribute(type, nameSpace, attribute));
                        ps.setLong(6, Util.getHash(this.getPhysicalAttribute(type, nameSpace, attribute)));
                        rs = ps.executeQuery();
                        result = new Vector();
                        while (rs.next()) {
                            Object var22_24;
                            sthingFound = true;
                            InputStream is = null;
                            try {
                                try {
                                    is = rs.getBinaryStream(this.valueColumn);
                                    byte[] aReadBuffer = new byte[1024];
                                    int iBytesRead = 0;
                                    ByteArrayOutputStream bBuffer = new ByteArrayOutputStream();
                                    while ((iBytesRead = is.read(aReadBuffer)) >= 0) {
                                        bBuffer.write(aReadBuffer, 0, iBytesRead);
                                    }
                                    result.add(bBuffer.toByteArray());
                                }
                                catch (IOException ioex) {
                                    throw new PersistenceException(ioex);
                                }
                                var22_24 = null;
                                this.closeInputStream(is, methodName);
                            }
                            catch (Throwable throwable) {
                                var22_24 = null;
                                this.closeInputStream(is, methodName);
                                throw throwable;
                            }
                        }
                    }
                    if (!homeDS || !sthingFound) break block27;
                    principal.setExists(true);
                }
                catch (SQLException sqlex) {
                    throw new PersistenceException(sqlex);
                }
            }
            Object var24_26 = null;
            this.closeResultSet(rs, methodName);
            this.closePreparedStatement(ps, methodName);
            this.mConnectionPool.releaseConnection(myCon);
        }
        catch (Throwable throwable) {
            Object var24_27 = null;
            this.closeResultSet(rs, methodName);
            this.closePreparedStatement(ps, methodName);
            this.mConnectionPool.releaseConnection(myCon);
            throw throwable;
        }
        attribute = this.getLogicalAttribute(type, nameSpace, attribute);
        Vector alreadySetValues = principal.getAttributeValues(nameSpace, attribute);
        principal.setAttributeValues(nameSpace, attribute, this.buildUnion(new Vector[]{result, alreadySetValues}));
        return true;
    }

    public IDataSourceTransaction beginTransaction() throws PersistenceException {
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        DataBaseDataSourceTransaction newDBDStrans = new DataBaseDataSourceTransaction(this);
        newDBDStrans.putDBConnection(this.mConnectionPool.getConnection(newDBDStrans.toString(), this.mDefaultTransactionIsolation));
        return newDBDStrans;
    }

    public boolean isXATransactionsUsed() {
        return this.mConnectionPool.isXATransactionsUsed();
    }

    public boolean isJTASupportEnabled() {
        return this.mConnectionPool.isJTASupportEnabled();
    }

    public UserTransaction getUserTransaction() {
        return this.mUserTransactionPool.getUserTransaction();
    }

    public boolean principalDatabagExists(IPrincipalDatabag principal) throws PersistenceException {
        String methodName = "principalDatabagExists";
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        String principalDatabagID = principal.getUniqueID();
        boolean exists = false;
        if (this.isHomeForPrincipalDatabag((IInternalPrincipalDatabag)principal)) {
            String[] idParts = principal.getIDParts();
            String type = idParts[0];
            StringBuffer query = new StringBuffer();
            query.append("SELECT DISTINCT ");
            query.append(this.principalIdColumn);
            query.append(" FROM ");
            query.append(this.getRealTableName(this.stringValueTable, type));
            query.append(" WHERE ((");
            query.append(this.principalIdColumn);
            query.append(" = ?) AND (");
            query.append(this.principalIdHashColumn);
            query.append(" = ?))");
            Connection myCon = this.mConnectionPool.getConnection(methodName, this.mDefaultTransactionIsolation);
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                block7: {
                    try {
                        if (mTrace.beInfo()) {
                            mTrace.infoT(methodName, "Perform query: " + query.toString());
                        }
                        ps = myCon.prepareStatement(query.toString());
                        ps.setString(1, principalDatabagID);
                        ps.setLong(2, Util.getHash(principalDatabagID));
                        rs = ps.executeQuery();
                        if (!rs.next()) break block7;
                        String id = rs.getString(this.principalIdColumn).trim();
                        exists = id.equals(principalDatabagID);
                    }
                    catch (SQLException sqlex) {
                        throw new PersistenceException(sqlex);
                    }
                }
                Object var13_14 = null;
                this.closeResultSet(rs, methodName);
                this.closePreparedStatement(ps, methodName);
                this.mConnectionPool.releaseConnection(myCon);
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                this.closeResultSet(rs, methodName);
                this.closePreparedStatement(ps, methodName);
                this.mConnectionPool.releaseConnection(myCon);
                throw throwable;
            }
        }
        return exists;
    }

    protected String getPrivateIDPart(IPrincipalDatabag principal) throws PersistenceException {
        String methodName = "getPrivateIDPart";
        String guid = null;
        Vector type = principal.getAttributeValues("com.sap.security.core.usermanagement", "PRINCIPAL_TYPE_ATTRIBUTE");
        if (type != null && !type.isEmpty()) {
            Object onlyElement = type.firstElement();
            Vector uniqueNames = principal.getAttributeValues("com.sap.security.core.usermanagement", "uniquename");
            if ("USER".equals(onlyElement)) {
                if (uniqueNames == null || uniqueNames.isEmpty()) {
                    throw new PersistenceException("Cannot create user if unique name is not specified.");
                }
            } else if ("UACC".equals(onlyElement) && ((uniqueNames = principal.getAttributeValues("com.sap.security.core.usermanagement", "j_user")) == null || uniqueNames.isEmpty())) {
                throw new PersistenceException("Cannot create user account if logon id is not specified.");
            }
            if (uniqueNames != null && !uniqueNames.isEmpty()) {
                Object uniqueName = uniqueNames.firstElement();
                if (uniqueName instanceof String) {
                    if (((String)uniqueName).length() > 200) {
                        throw new PersistenceException("Unique name or logon id exceeds max. length which is 200 characters.");
                    }
                    guid = "un:" + (String)uniqueName;
                }
            } else {
                guid = Util.createGUID();
            }
        } else {
            throw new PersistenceException("Cannot create principal if no type is specified.");
        }
        if (guid == null) {
            throw new PersistenceException("No private part available.");
        }
        return guid;
    }

    private String encodeLikeStringForDB(String stringWithSpecialCharacters) {
        StringBuffer result = new StringBuffer();
        int length = stringWithSpecialCharacters.length();
        int counter = 0;
        counter = 0;
        while (counter < length) {
            switch (stringWithSpecialCharacters.charAt(counter)) {
                case '%': {
                    result.append(DATABASE_ESCAPE_CHARACTER);
                    result.append("%");
                    break;
                }
                case '_': {
                    result.append(DATABASE_ESCAPE_CHARACTER);
                    result.append("_");
                    break;
                }
                case '*': {
                    result.append("%");
                    break;
                }
                case '?': {
                    result.append("_");
                    break;
                }
                case '#': {
                    result.append(DATABASE_ESCAPE_CHARACTER);
                    result.append(DATABASE_ESCAPE_CHARACTER);
                    break;
                }
                default: {
                    result.append(stringWithSpecialCharacters.charAt(counter));
                }
            }
            ++counter;
        }
        return result.toString();
    }

    public Vector searchPrincipalDatabags(SearchCriteria criteria) throws PersistenceException {
        String methodName = "searchPrincipalDatabags";
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        int size = criteria.getElementSize();
        String type = criteria.getPrincipalType();
        SearchCriteria dsCriteria = new SearchCriteria(criteria.isOrMode(), criteria.getPrincipalType());
        int i = 0;
        while (i < size) {
            boolean checkResult;
            ISearchAttribute se = criteria.getAttribute(i);
            String nameSpace = se.getAttributeNameSpace();
            String attribute = se.getAttributeName();
            if ((!nameSpace.equals("com.sap.security.core.usermanagement") || !attribute.equals("PRINCIPAL_TYPE_ATTRIBUTE") && !attribute.equals("oldpassword")) && (checkResult = this.feelsResponsible(type, nameSpace, attribute))) {
                int op = se.getOperator();
                Object value = se.getAttributeValue();
                if (value != null) {
                    if (value instanceof String && ((String)value).equals("")) {
                        value = THIS_REPLACES_THE_EMPTY_STRING_FOR_ORACLE;
                    }
                    if (!(value instanceof X509Certificate)) {
                        boolean cs = se.isCaseSensitive();
                        switch (op) {
                            case 1: {
                                dsCriteria.addLikeElement(nameSpace, attribute, value, cs);
                                break;
                            }
                            case 0: {
                                dsCriteria.addEqualsElement(nameSpace, attribute, value, cs);
                                break;
                            }
                            case 2: {
                                dsCriteria.addGreaterThanElement(nameSpace, attribute, value, cs);
                                break;
                            }
                            case 3: {
                                dsCriteria.addLessThanElement(nameSpace, attribute, value, cs);
                            }
                        }
                    }
                }
            }
            ++i;
        }
        if (dsCriteria.getElementSize() == 1) {
            if (mTrace.beInfo()) {
                mTrace.infoT(methodName, "Not responsible for any search element.");
            }
            return null;
        }
        Vector searchResults = new Vector();
        if (!dsCriteria.isOrMode() || dsCriteria.getElementSize() < this.mOrSearchMaxArguments) {
            dsCriteria.setSearchSizeLimit(criteria.getSearchSizeLimit());
            this.doSearch(dsCriteria, searchResults, type);
        } else {
            int realElementSize = dsCriteria.getElementSize() - 1;
            int remainder = realElementSize % this.mOrSearchMaxArguments;
            int numberOfSingleSearches = (realElementSize - remainder) / this.mOrSearchMaxArguments;
            if (remainder != 0) {
                ++numberOfSingleSearches;
            }
            SearchCriteria[] singleSearchCriteria = new SearchCriteria[numberOfSingleSearches];
            Vector[] singleSearchResults = new Vector[numberOfSingleSearches];
            size = dsCriteria.getElementSize();
            ISearchAttribute sa = null;
            int counter = 0;
            int i2 = 0;
            while (i2 < size) {
                sa = dsCriteria.getAttribute(i2);
                String attributeName = sa.getAttributeName();
                String nameSpaceName = sa.getAttributeNameSpace();
                if (singleSearchCriteria[counter] == null) {
                    singleSearchCriteria[counter] = new SearchCriteria(dsCriteria.isOrMode(), dsCriteria.getPrincipalType());
                }
                if (!attributeName.equals("PRINCIPAL_TYPE_ATTRIBUTE") || !nameSpaceName.equals("com.sap.security.core.usermanagement")) {
                    Object val = sa.getAttributeValue();
                    int operatore = sa.getOperator();
                    boolean caseSensitive = sa.isCaseSensitive();
                    switch (operatore) {
                        case 1: {
                            singleSearchCriteria[counter].addLikeElement(nameSpaceName, attributeName, val, caseSensitive);
                            break;
                        }
                        case 0: {
                            singleSearchCriteria[counter].addEqualsElement(nameSpaceName, attributeName, val, caseSensitive);
                            break;
                        }
                        case 2: {
                            singleSearchCriteria[counter].addGreaterThanElement(nameSpaceName, attributeName, val, caseSensitive);
                            break;
                        }
                        case 3: {
                            singleSearchCriteria[counter].addLessThanElement(nameSpaceName, attributeName, val, caseSensitive);
                        }
                    }
                }
                if (singleSearchCriteria[counter].getElementSize() - 1 == this.mOrSearchMaxArguments) {
                    ++counter;
                }
                ++i2;
            }
            size = singleSearchCriteria.length;
            int i3 = 0;
            while (i3 < size) {
                singleSearchResults[i3] = new Vector();
                singleSearchCriteria[i3].setSearchSizeLimit(criteria.getSearchSizeLimit());
                this.doSearch(singleSearchCriteria[i3], singleSearchResults[i3], type);
                ++i3;
            }
            searchResults = this.buildUnion(singleSearchResults);
        }
        return searchResults;
    }

    private String createSimpleOrSubQuery(boolean caseSensitive, int operatore) {
        String op = " LIKE ";
        switch (operatore) {
            case 0: {
                op = " = ";
                break;
            }
            case 2: {
                op = " > ";
                break;
            }
            case 3: {
                op = " < ";
            }
        }
        StringBuffer result = new StringBuffer();
        result.append("((");
        result.append(this.nameSpaceColumn);
        result.append("=");
        result.append("?)");
        result.append(" AND ");
        result.append("(");
        result.append(this.nameSpaceHashColumn);
        result.append("=");
        result.append("?)");
        result.append(" AND ");
        result.append("(");
        result.append(this.attributeColumn);
        result.append("=");
        result.append("?)");
        result.append(" AND ");
        result.append("(");
        result.append(this.attributeHashColumn);
        result.append("=");
        result.append("?)");
        result.append(" AND ");
        result.append("(");
        if (!caseSensitive) {
            result.append(this.upperValueColumn);
        } else {
            result.append(this.valueColumn);
        }
        result.append(op);
        result.append(" ?");
        if (operatore == 1) {
            result.append(" ESCAPE ");
            if (this.mConnectionPool.isUnicode()) {
                result.append("N");
            }
            result.append("'");
            result.append(DATABASE_ESCAPE_CHARACTER);
            result.append("'");
        }
        result.append(")");
        if (operatore == 0) {
            result.append(" AND (");
            if (!caseSensitive) {
                result.append(this.upperValueHashColumn);
            } else {
                result.append(this.valueHashColumn);
            }
            result.append(" = ?)");
        }
        result.append(")");
        return result.toString();
    }

    private String createOrSubQueryValuePart(boolean caseSensitive, int operatore) {
        String op = " LIKE ";
        switch (operatore) {
            case 0: {
                op = " = ";
                break;
            }
            case 2: {
                op = " > ";
                break;
            }
            case 3: {
                op = " < ";
            }
        }
        StringBuffer result = new StringBuffer();
        result.append("(");
        if (operatore == 0) {
            result.append("(");
        }
        if (!caseSensitive) {
            result.append(this.upperValueColumn);
        } else {
            result.append(this.valueColumn);
        }
        result.append(op);
        result.append("?");
        if (operatore == 1) {
            result.append(" ESCAPE ");
            if (this.mConnectionPool.isUnicode()) {
                result.append("N");
            }
            result.append("'");
            result.append(DATABASE_ESCAPE_CHARACTER);
            result.append("'");
        }
        result.append(")");
        if (operatore == 0) {
            result.append(" AND (");
            if (!caseSensitive) {
                result.append(this.upperValueHashColumn);
            } else {
                result.append(this.valueHashColumn);
            }
            result.append(" = ?))");
        }
        return result.toString();
    }

    private String createOrSubQueryNameSpacePart() {
        StringBuffer result = new StringBuffer();
        result.append("((");
        result.append(this.nameSpaceColumn);
        result.append("=");
        result.append("?)");
        result.append(" AND ");
        result.append("(");
        result.append(this.nameSpaceHashColumn);
        result.append("=");
        result.append("?))");
        return result.toString();
    }

    private String createOrSubQueryAttributePart() {
        StringBuffer result = new StringBuffer();
        result.append("((");
        result.append(this.attributeColumn);
        result.append("=");
        result.append("?)");
        result.append(" AND ");
        result.append("(");
        result.append(this.attributeHashColumn);
        result.append("=");
        result.append("?))");
        return result.toString();
    }

    private String createAndSubQuery(boolean caseSensitive, int operatore, String type) {
        String op = " LIKE ";
        switch (operatore) {
            case 0: {
                op = " = ";
                break;
            }
            case 2: {
                op = " > ";
                break;
            }
            case 3: {
                op = " < ";
            }
        }
        StringBuffer result = new StringBuffer();
        result.append("(");
        result.append(this.principalIdColumn);
        result.append(" IN (");
        result.append("SELECT DISTINCT ");
        result.append(this.principalIdColumn);
        result.append(" FROM ");
        result.append(this.getRealTableName(this.stringValueTable, type));
        result.append(" WHERE ");
        result.append("((");
        result.append(this.nameSpaceColumn);
        result.append("=");
        result.append("?)");
        result.append(" AND ");
        result.append("(");
        result.append(this.nameSpaceHashColumn);
        result.append("=");
        result.append("?)");
        result.append(" AND ");
        result.append("(");
        result.append(this.attributeColumn);
        result.append("=");
        result.append("?)");
        result.append(" AND ");
        result.append("(");
        result.append(this.attributeHashColumn);
        result.append("=");
        result.append("?)");
        result.append(" AND ");
        result.append("(");
        if (!caseSensitive) {
            result.append(this.upperValueColumn);
        } else {
            result.append(this.valueColumn);
        }
        result.append(op);
        result.append("?");
        if (operatore == 1) {
            result.append(" ESCAPE ");
            if (this.mConnectionPool.isUnicode()) {
                result.append("N");
            }
            result.append("'");
            result.append(DATABASE_ESCAPE_CHARACTER);
            result.append("'");
        }
        result.append(")");
        if (operatore == 0) {
            result.append(" AND (");
            if (!caseSensitive) {
                result.append(this.upperValueHashColumn);
            } else {
                result.append(this.valueHashColumn);
            }
            result.append(" = ?)");
        }
        result.append(")");
        result.append("))");
        return result.toString();
    }

    public void releaseConnection(Connection connection) throws PersistenceException {
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        this.mConnectionPool.releaseConnection(connection);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkCredentials(Hashtable credentials) throws PersistenceException {
        boolean cee222;
        ResultSet rs2;
        PreparedStatement ps2;
        ResultSet rs;
        PreparedStatement ps;
        Connection myCon;
        String methodName;
        block44: {
            boolean cee222;
            block43: {
                boolean cee222;
                block42: {
                    boolean accountId2;
                    block41: {
                        boolean bl;
                        block40: {
                            boolean u_pwdLogon;
                            X509Certificate cert;
                            methodName = "checkCredentials";
                            if (!this.isInitialized) {
                                String errorMessage = "Data source is not initialized!";
                                throw new PersistenceException(errorMessage);
                            }
                            String[] dsToSearch = (String[])credentials.get("dataSourceIDs");
                            if (dsToSearch != null) {
                                boolean found = false;
                                int k = 0;
                                int s = dsToSearch.length;
                                while (true) {
                                    if (k >= s || found) {
                                        if (found) break;
                                        return false;
                                    }
                                    if (this.getId().equals(dsToSearch[k])) {
                                        found = true;
                                    }
                                    ++k;
                                }
                            }
                            boolean certLogon = (cert = (X509Certificate)credentials.get("javax.servlet.request.X509Certificate")) != null;
                            String login = (String)credentials.get("j_user");
                            String password = (String)credentials.get("j_password");
                            boolean bl2 = u_pwdLogon = login != null;
                            if (!(this.feelsResponsible("com.sap.security.core.usermanagement", "j_user") && this.feelsResponsible("com.sap.security.core.usermanagement", "j_password") && u_pwdLogon || this.feelsResponsible("com.sap.security.core.usermanagement", "javax.servlet.request.X509Certificate") && this.feelsResponsible("com.sap.security.core.usermanagement", "certificatehash") && certLogon)) {
                                try {
                                    if (!this.mConfigurationModel.getPrivateAttributeBooleanValue("check_credentials")) {
                                        return false;
                                    }
                                }
                                catch (PersistenceException pex) {
                                    if (!mTrace.beDebug()) return false;
                                    mTrace.debugT(methodName, (Throwable)((Object)pex));
                                    return false;
                                }
                            }
                            if (u_pwdLogon && password == null) {
                                return false;
                            }
                            if (!u_pwdLogon && !certLogon) {
                                return false;
                            }
                            String cachedQuery1 = null;
                            String cachedQuery2 = null;
                            StringBuffer query = null;
                            StringBuffer query2 = null;
                            if (u_pwdLogon) {
                                cachedQuery1 = DataBaseStringsPool.getInstance().getDataBaseString("UID", "UACC");
                                if (cachedQuery1 == null) {
                                    query = new StringBuffer();
                                    query.append("SELECT DISTINCT ");
                                    query.append(this.principalIdColumn);
                                    query.append(" FROM ");
                                    query.append(this.getRealTableName(this.stringValueTable, "UACC"));
                                    query.append(" WHERE (");
                                    query.append(this.nameSpaceColumn);
                                    query.append(" = ?) AND (");
                                    query.append(this.nameSpaceHashColumn);
                                    query.append(" = ?) AND (");
                                    query.append(this.attributeColumn);
                                    query.append(" = ?) AND (");
                                    query.append(this.attributeHashColumn);
                                    query.append(" = ?) AND (");
                                    query.append(this.upperValueColumn);
                                    query.append("=?) AND (");
                                    query.append(this.upperValueHashColumn);
                                    query.append("=?)");
                                }
                                if ((cachedQuery2 = DataBaseStringsPool.getInstance().getDataBaseString("PWD", "UACC")) == null) {
                                    query2 = new StringBuffer();
                                    query2.append("SELECT DISTINCT ");
                                    query2.append(this.valueColumn);
                                    query2.append(" FROM ");
                                    query2.append(this.getRealTableName(this.stringValueTable, "UACC"));
                                    query2.append(" WHERE (");
                                    query2.append(this.nameSpaceColumn);
                                    query2.append(" = ?) AND (");
                                    query2.append(this.nameSpaceHashColumn);
                                    query2.append(" = ?) AND (");
                                    query2.append(this.attributeColumn);
                                    query2.append(" = ?) AND (");
                                    query2.append(this.attributeHashColumn);
                                    query2.append(" = ?) AND (");
                                    query2.append(this.principalIdColumn);
                                    query2.append("=?) AND (");
                                    query2.append(this.principalIdHashColumn);
                                    query2.append("=?)");
                                }
                            }
                            if (certLogon && (cachedQuery1 = DataBaseStringsPool.getInstance().getDataBaseString("X509", "UACC")) == null) {
                                query = new StringBuffer();
                                query.append("SELECT DISTINCT ");
                                query.append(this.principalIdColumn);
                                query.append(" FROM ");
                                query.append(this.getRealTableName(this.stringValueTable, "UACC"));
                                query.append(" WHERE ");
                                query.append("((");
                                query.append(this.principalIdColumn);
                                query.append(" LIKE ? ESCAPE ");
                                if (this.mConnectionPool.isUnicode()) {
                                    query.append("N");
                                }
                                query.append("'");
                                query.append(DATABASE_ESCAPE_CHARACTER);
                                query.append("') AND (");
                                query.append(this.nameSpaceColumn);
                                query.append("= ?) AND (");
                                query.append(this.nameSpaceHashColumn);
                                query.append("= ?) AND (");
                                query.append(this.attributeColumn);
                                query.append("= ?) AND (");
                                query.append(this.attributeHashColumn);
                                query.append("= ?) AND (");
                                query.append(this.valueColumn);
                                query.append("= ?) AND (");
                                query.append(this.valueHashColumn);
                                query.append(" = ?))");
                            }
                            myCon = this.mConnectionPool.getConnection(methodName, this.mDefaultTransactionIsolation);
                            ps = null;
                            rs = null;
                            ps2 = null;
                            rs2 = null;
                            try {
                                try {
                                    if (mTrace.beInfo()) {
                                        if (cachedQuery1 == null) {
                                            mTrace.infoT(methodName, "Perform query: " + query.toString());
                                        } else {
                                            mTrace.infoT(methodName, "Perform query: " + cachedQuery1);
                                        }
                                    }
                                    if (cachedQuery1 == null) {
                                        ps = myCon.prepareStatement(query.toString());
                                        if (u_pwdLogon) {
                                            DataBaseStringsPool.getInstance().storeDataBaseString("UID", "UACC", query.toString());
                                        } else {
                                            DataBaseStringsPool.getInstance().storeDataBaseString("X509", "UACC", query.toString());
                                        }
                                    } else {
                                        ps = myCon.prepareStatement(cachedQuery1);
                                    }
                                    if (u_pwdLogon) {
                                        if (mTrace.beInfo()) {
                                            if (cachedQuery2 == null) {
                                                mTrace.infoT(methodName, "Perform query: " + query2.toString());
                                            } else {
                                                mTrace.infoT(methodName, "Perform query: " + cachedQuery2);
                                            }
                                        }
                                        if (cachedQuery2 == null) {
                                            ps2 = myCon.prepareStatement(query2.toString());
                                            DataBaseStringsPool.getInstance().storeDataBaseString("PWD", "UACC", query2.toString());
                                        } else {
                                            ps2 = myCon.prepareStatement(cachedQuery2);
                                        }
                                        ps.setString(1, "com.sap.security.core.usermanagement");
                                        ps.setLong(2, Util.getHash("com.sap.security.core.usermanagement"));
                                        ps.setString(3, this.getPhysicalAttribute("UACC", "com.sap.security.core.usermanagement", "j_user"));
                                        ps.setLong(4, Util.getHash(this.getPhysicalAttribute("UACC", "com.sap.security.core.usermanagement", "j_user")));
                                        ps.setString(5, login.toUpperCase());
                                        ps.setLong(6, Util.getHash(login.toUpperCase()));
                                        rs = ps.executeQuery();
                                        if (rs.next()) {
                                            String accountId2 = rs.getString(this.principalIdColumn);
                                            ps2.setString(1, "com.sap.security.core.usermanagement");
                                            ps2.setLong(2, Util.getHash("com.sap.security.core.usermanagement"));
                                            ps2.setString(3, this.getPhysicalAttribute("UACC", "com.sap.security.core.usermanagement", "j_password"));
                                            ps2.setLong(4, Util.getHash(this.getPhysicalAttribute("UACC", "com.sap.security.core.usermanagement", "j_password")));
                                            ps2.setString(5, accountId2);
                                            ps2.setLong(6, Util.getHash(accountId2));
                                            rs2 = ps2.executeQuery();
                                            if (rs2.next()) {
                                                boolean result;
                                                String passwordHash = rs2.getString(this.valueColumn);
                                                boolean bl3 = result = new PasswordHash(login, password).checkHash(passwordHash);
                                                Object var23_33 = null;
                                                this.closeResultSet(rs, methodName);
                                                this.closeResultSet(rs2, methodName);
                                                this.closePreparedStatement(ps, methodName);
                                                this.closePreparedStatement(ps2, methodName);
                                                this.mConnectionPool.releaseConnection(myCon);
                                                return bl3;
                                            }
                                            bl = false;
                                            break block40;
                                        }
                                        accountId2 = false;
                                        break block41;
                                    }
                                    if (certLogon) {
                                        ps.setString(1, this.encodeLikeStringForDB("UACC") + "%");
                                        ps.setString(2, "com.sap.security.core.usermanagement");
                                        ps.setLong(3, Util.getHash("com.sap.security.core.usermanagement"));
                                        ps.setString(4, this.getPhysicalAttribute("UACC", "com.sap.security.core.usermanagement", "certificatehash"));
                                        ps.setLong(5, Util.getHash(this.getPhysicalAttribute("UACC", "com.sap.security.core.usermanagement", "certificatehash")));
                                        try {
                                            ps.setString(6, Base64.encode(Util.createMD5HashValue(cert.getEncoded())));
                                            ps.setLong(7, Util.getHash(Base64.encode(Util.createMD5HashValue(cert.getEncoded()))));
                                        }
                                        catch (CertificateEncodingException cee222) {
                                            throw new PersistenceException(cee222);
                                        }
                                        rs = ps.executeQuery();
                                        if (rs.next()) {
                                            cee222 = true;
                                            break block42;
                                        }
                                        cee222 = false;
                                        break block43;
                                    }
                                    cee222 = false;
                                    break block44;
                                }
                                catch (SQLException sqlex) {
                                    throw new PersistenceException(sqlex);
                                }
                            }
                            catch (Throwable throwable) {
                                Object var23_39 = null;
                                this.closeResultSet(rs, methodName);
                                this.closeResultSet(rs2, methodName);
                                this.closePreparedStatement(ps, methodName);
                                this.closePreparedStatement(ps2, methodName);
                                this.mConnectionPool.releaseConnection(myCon);
                                throw throwable;
                            }
                        }
                        Object var23_34 = null;
                        this.closeResultSet(rs, methodName);
                        this.closeResultSet(rs2, methodName);
                        this.closePreparedStatement(ps, methodName);
                        this.closePreparedStatement(ps2, methodName);
                        this.mConnectionPool.releaseConnection(myCon);
                        return bl;
                    }
                    Object var23_35 = null;
                    this.closeResultSet(rs, methodName);
                    this.closeResultSet(rs2, methodName);
                    this.closePreparedStatement(ps, methodName);
                    this.closePreparedStatement(ps2, methodName);
                    this.mConnectionPool.releaseConnection(myCon);
                    return accountId2;
                }
                Object var23_36 = null;
                this.closeResultSet(rs, methodName);
                this.closeResultSet(rs2, methodName);
                this.closePreparedStatement(ps, methodName);
                this.closePreparedStatement(ps2, methodName);
                this.mConnectionPool.releaseConnection(myCon);
                return cee222;
            }
            Object var23_37 = null;
            this.closeResultSet(rs, methodName);
            this.closeResultSet(rs2, methodName);
            this.closePreparedStatement(ps, methodName);
            this.closePreparedStatement(ps2, methodName);
            this.mConnectionPool.releaseConnection(myCon);
            return cee222;
        }
        Object var23_38 = null;
        this.closeResultSet(rs, methodName);
        this.closeResultSet(rs2, methodName);
        this.closePreparedStatement(ps, methodName);
        this.closePreparedStatement(ps2, methodName);
        this.mConnectionPool.releaseConnection(myCon);
        return cee222;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doSearch(SearchCriteria criteria, Vector searchResults, String principalType) throws PersistenceException {
        ISearchAttribute se3;
        String methodName = "doSearch";
        String cachedQueryString = null;
        StringBuffer cacheKey = null;
        int criteriaSize = criteria.getElementSize();
        if (criteriaSize == 2) {
            boolean caseSensitive = false;
            boolean like = false;
            int i = 0;
            while (true) {
                if (i >= criteriaSize) {
                    if (cacheKey == null) break;
                    cachedQueryString = DataBaseStringsPool.getInstance().getDataBaseString(cacheKey.toString(), principalType);
                    break;
                }
                ISearchAttribute se2 = criteria.getAttribute(i);
                if (!se2.getAttributeNameSpace().equals("com.sap.security.core.usermanagement") || !se2.getAttributeName().equals("PRINCIPAL_TYPE_ATTRIBUTE") && !se2.getAttributeName().equals("oldpassword")) {
                    caseSensitive = se2.isCaseSensitive();
                    cacheKey = new StringBuffer(4);
                    cacheKey.append("SS");
                    if (caseSensitive) {
                        cacheKey.append('X');
                    } else {
                        cacheKey.append('_');
                    }
                    cacheKey.append(se2.getOperator());
                }
                ++i;
            }
        }
        StringBuffer principalPartBuffer = null;
        StringBuffer queryString = null;
        if (cachedQueryString == null) {
            principalPartBuffer = new StringBuffer();
            principalPartBuffer.append("(");
            principalPartBuffer.append(this.principalIdColumn);
            principalPartBuffer.append(" LIKE ? ESCAPE ");
            if (this.mConnectionPool.isUnicode()) {
                principalPartBuffer.append("N");
            }
            principalPartBuffer.append("'");
            principalPartBuffer.append(DATABASE_ESCAPE_CHARACTER);
            principalPartBuffer.append("') AND (");
            queryString = new StringBuffer();
            queryString.append("SELECT DISTINCT ");
            queryString.append(this.principalIdColumn);
            queryString.append(" FROM ");
            queryString.append(this.getRealTableName(this.stringValueTable, principalType));
            queryString.append(" WHERE ");
            queryString.append("(");
            queryString.append(principalPartBuffer.toString());
        }
        String type = criteria.getPrincipalType();
        Vector<Object> valuesForPS = new Vector<Object>();
        int size = criteria.getElementSize();
        if (criteria.isOrMode() && size != 2) {
            Enumeration en1;
            boolean firstSet3;
            boolean firstSet2;
            boolean firstSet;
            PrincipalDatabag struct = new PrincipalDatabag(null);
            int i = 0;
            while (true) {
                if (i >= size) {
                    firstSet = false;
                    firstSet2 = false;
                    firstSet3 = false;
                    en1 = struct.getNameSpaces();
                    break;
                }
                se3 = criteria.getAttribute(i);
                if (!se3.getAttributeNameSpace().equals("com.sap.security.core.usermanagement") || !se3.getAttributeName().equals("PRINCIPAL_TYPE_ATTRIBUTE") && !se3.getAttributeName().equals("oldpassword")) {
                    struct.addAttributeValue(se3.getAttributeNameSpace(), se3.getAttributeName(), se3);
                }
                ++i;
            }
            block12: while (en1.hasMoreElements()) {
                String nameSpace = (String)en1.nextElement();
                if (queryString != null) {
                    if (firstSet) {
                        queryString.append(" OR ");
                    }
                    queryString.append("(");
                    queryString.append(this.createOrSubQueryNameSpacePart());
                    queryString.append(" AND (");
                }
                valuesForPS.add(nameSpace);
                valuesForPS.add(new Long(Util.getHash(nameSpace)));
                firstSet2 = false;
                Enumeration en2 = struct.getAttributesOnNamespace(nameSpace);
                while (true) {
                    if (!en2.hasMoreElements()) {
                        if (queryString != null) {
                            queryString.append("))");
                        }
                        firstSet = true;
                        continue block12;
                    }
                    String attribute = (String)en2.nextElement();
                    if (queryString != null) {
                        if (firstSet2) {
                            queryString.append(" OR ");
                        }
                        queryString.append("(");
                        queryString.append(this.createOrSubQueryAttributePart());
                        queryString.append(" AND (");
                    }
                    valuesForPS.add(this.getPhysicalAttribute(type, nameSpace, attribute));
                    valuesForPS.add(new Long(Util.getHash(this.getPhysicalAttribute(type, nameSpace, attribute))));
                    Vector searchAttributes = struct.getAttributeValues(nameSpace, attribute);
                    if (searchAttributes != null) {
                        size = searchAttributes.size();
                        firstSet3 = false;
                        int i2 = 0;
                        while (i2 < size) {
                            Object o;
                            se3 = (ISearchAttribute)searchAttributes.elementAt(i2);
                            if (queryString != null) {
                                if (firstSet3) {
                                    queryString.append(" OR ");
                                }
                                queryString.append(this.createOrSubQueryValuePart(se3.isCaseSensitive(), se3.getOperator()));
                            }
                            if (!((o = se3.getAttributeValue()) instanceof String)) {
                                String errorMessage = "The search can only be done for string values!";
                                throw new PersistenceException(errorMessage);
                            }
                            if (!se3.isCaseSensitive()) {
                                o = ((String)o).toUpperCase();
                            }
                            if (se3.getOperator() == 1) {
                                String escO = this.encodeLikeStringForDB((String)o);
                                valuesForPS.add(escO);
                            } else {
                                valuesForPS.add((String)o);
                                if (se3.getOperator() == 0) {
                                    valuesForPS.add(new Long(Util.getHash((String)o)));
                                }
                            }
                            firstSet3 = true;
                            ++i2;
                        }
                    }
                    if (queryString != null) {
                        queryString.append("))");
                    }
                    firstSet2 = true;
                }
            }
        } else if (size == 2) {
            int k = 0;
            while (k < size) {
                se3 = criteria.getAttribute(k);
                if (!se3.getAttributeNameSpace().equals("com.sap.security.core.usermanagement") || !se3.getAttributeName().equals("PRINCIPAL_TYPE_ATTRIBUTE") && !se3.getAttributeName().equals("oldpassword")) {
                    if (queryString != null) {
                        queryString.append(this.createSimpleOrSubQuery(se3.isCaseSensitive(), se3.getOperator()));
                    }
                    valuesForPS.add(se3.getAttributeNameSpace());
                    valuesForPS.add(new Long(Util.getHash(se3.getAttributeNameSpace())));
                    valuesForPS.add(this.getPhysicalAttribute(type, se3.getAttributeNameSpace(), se3.getAttributeName()));
                    valuesForPS.add(new Long(Util.getHash(this.getPhysicalAttribute(type, se3.getAttributeNameSpace(), se3.getAttributeName()))));
                    Object o = se3.getAttributeValue();
                    if (!(o instanceof String)) {
                        String errorMessage = "The search can only be done for string values!";
                        throw new PersistenceException(errorMessage);
                    }
                    if (!se3.isCaseSensitive()) {
                        o = ((String)o).toUpperCase();
                    }
                    if (se3.getOperator() == 1) {
                        String escO = this.encodeLikeStringForDB((String)o);
                        valuesForPS.add(escO);
                    } else {
                        valuesForPS.add((String)o);
                        if (se3.getOperator() == 0) {
                            valuesForPS.add(new Long(Util.getHash((String)o)));
                        }
                    }
                }
                ++k;
            }
        } else {
            boolean isNew = true;
            Vector tempRes = new Vector();
            int i = 0;
            while (true) {
                if (i >= size) {
                    return;
                }
                ISearchAttribute se3 = criteria.getAttribute(i);
                if (!se3.getAttributeNameSpace().equals("com.sap.security.core.usermanagement") || !se3.getAttributeName().equals("PRINCIPAL_TYPE_ATTRIBUTE") && !se3.getAttributeName().equals("oldpassword")) {
                    SearchCriteria tempSearch = new SearchCriteria(principalType);
                    int operatore = se3.getOperator();
                    switch (operatore) {
                        case 0: {
                            tempSearch.addEqualsElement(se3.getAttributeNameSpace(), se3.getAttributeName(), se3.getAttributeValue(), se3.isCaseSensitive());
                            break;
                        }
                        case 1: {
                            tempSearch.addLikeElement(se3.getAttributeNameSpace(), se3.getAttributeName(), se3.getAttributeValue(), se3.isCaseSensitive());
                            break;
                        }
                        case 3: {
                            tempSearch.addLessThanElement(se3.getAttributeNameSpace(), se3.getAttributeName(), se3.getAttributeValue(), se3.isCaseSensitive());
                            break;
                        }
                        case 2: {
                            tempSearch.addGreaterThanElement(se3.getAttributeNameSpace(), se3.getAttributeName(), se3.getAttributeValue(), se3.isCaseSensitive());
                            break;
                        }
                    }
                    this.doSearch(tempSearch, tempRes, principalType);
                    if (tempRes.isEmpty()) {
                        searchResults.clear();
                        return;
                    }
                    if (isNew) {
                        searchResults.addAll(tempRes);
                        isNew = false;
                    } else {
                        searchResults.retainAll(tempRes);
                        if (searchResults.isEmpty()) {
                            return;
                        }
                    }
                    tempRes.clear();
                }
                ++i;
            }
        }
        if (queryString != null) {
            if (principalPartBuffer != null) {
                queryString.append(")");
            }
            queryString.append(")");
        }
        Connection myCon = this.mConnectionPool.getConnection("doSearch", this.mDefaultTransactionIsolation);
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            try {
                int counter = 1;
                if (mTrace.beInfo()) {
                    if (queryString != null) {
                        mTrace.infoT("doSearch", "Perform query: " + queryString.toString());
                    } else {
                        mTrace.infoT("doSearch", "Perform query: " + cachedQueryString);
                    }
                }
                if (queryString != null) {
                    ps = myCon.prepareStatement(queryString.toString());
                    if (cacheKey != null) {
                        DataBaseStringsPool.getInstance().storeDataBaseString(cacheKey.toString(), principalType, queryString.toString());
                    }
                } else {
                    ps = myCon.prepareStatement(cachedQueryString);
                }
                ps.setString(counter, this.encodeLikeStringForDB(principalType) + "%");
                ++counter;
                int valuesSize = valuesForPS.size();
                int k = 0;
                while (true) {
                    if (k >= valuesSize) {
                        rs = ps.executeQuery();
                    }
                    ps.setObject(counter, valuesForPS.elementAt(k));
                    ++counter;
                    ++k;
                }
                int searchSizeLimit = criteria.getSearchSizeLimit();
                boolean checkSearchSizeLimit = searchSizeLimit > 0;
                boolean searchSizeLimitReached = false;
                int resultCounter = 0;
                while (!searchSizeLimitReached && rs.next()) {
                    searchResults.add(rs.getString(this.principalIdColumn).trim());
                    if (!checkSearchSizeLimit || !(searchSizeLimitReached = searchSizeLimit == ++resultCounter) || !rs.next()) continue;
                    criteria.errorOccurred(4);
                }
            }
            catch (SQLException sqlex) {
                throw new PersistenceException(sqlex);
            }
            Object var28_47 = null;
            this.closeResultSet(rs, "doSearch");
            this.closePreparedStatement(ps, "doSearch");
            this.mConnectionPool.releaseConnection(myCon);
            return;
        }
        catch (Throwable throwable) {
            Object var28_48 = null;
            this.closeResultSet(rs, "doSearch");
            this.closePreparedStatement(ps, "doSearch");
            this.mConnectionPool.releaseConnection(myCon);
            throw throwable;
        }
    }

    public void deletePrincipalDatabag(IPrincipalDatabag principal, IDataSourceTransaction transaction) throws PersistenceException {
        String methodName = "deletePrincipalDatabag";
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        if (this.isReadonly()) {
            if (mTrace.beInfo()) {
                mTrace.infoT(methodName, "This datasource is readonly... do not try to delete principal databag.");
            }
            return;
        }
        String principalID = principal.getUniqueID();
        if (this.feelsResponsible(principal)) {
            String[] idParts = principal.getIDParts();
            String type = idParts[0];
            Connection myCon = ((DataBaseDataSourceTransaction)transaction).getDBConnection();
            PreparedStatement ps1 = null;
            PreparedStatement ps2 = null;
            PreparedStatement ps3 = null;
            PreparedStatement ps4 = null;
            ResultSet rs = null;
            StringBuffer queryString1 = new StringBuffer();
            queryString1.append("SELECT DISTINCT ");
            queryString1.append(this.attributeColumn);
            queryString1.append(",");
            queryString1.append(this.nameSpaceColumn);
            queryString1.append(" FROM ");
            queryString1.append(this.getRealTableName(this.stringValueTable, type));
            queryString1.append(" WHERE (");
            queryString1.append(this.principalIdColumn);
            queryString1.append(" = ?)");
            queryString1.append(" AND (");
            queryString1.append(this.principalIdHashColumn);
            queryString1.append(" = ?)");
            StringBuffer queryString2 = new StringBuffer();
            queryString2.append("SELECT DISTINCT ");
            queryString2.append(this.attributeColumn);
            queryString2.append(",");
            queryString2.append(this.nameSpaceColumn);
            queryString2.append(" FROM ");
            queryString2.append(this.getRealTableName(this.blobValueTable, type));
            queryString2.append(" WHERE (");
            queryString2.append(this.principalIdColumn);
            queryString2.append(" = ?)");
            queryString2.append(" AND (");
            queryString2.append(this.principalIdHashColumn);
            queryString2.append(" = ?)");
            StringBuffer updateString1 = new StringBuffer();
            updateString1.append("DELETE FROM ");
            updateString1.append(this.getRealTableName(this.stringValueTable, type));
            updateString1.append(" WHERE (");
            updateString1.append(this.principalIdColumn);
            updateString1.append(" = ?)");
            updateString1.append(" AND (");
            updateString1.append(this.principalIdHashColumn);
            updateString1.append(" = ?)");
            try {
                block33: {
                    try {
                        Vector dummy;
                        String attribute;
                        String namespace;
                        if (mTrace.beInfo()) {
                            mTrace.infoT(methodName, "Perform query: " + queryString1.toString());
                        }
                        ps3 = myCon.prepareStatement(queryString1.toString());
                        ps3.setObject(1, principalID);
                        ps3.setLong(2, Util.getHash(principalID));
                        rs = ps3.executeQuery();
                        Hashtable<String, Vector> stringHt = new Hashtable<String, Vector>();
                        while (rs.next()) {
                            namespace = rs.getString(this.nameSpaceColumn);
                            if (!this.feelsResponsible(type, namespace, attribute = rs.getString(this.attributeColumn))) continue;
                            dummy = (Vector)stringHt.get(namespace);
                            if (dummy == null) {
                                dummy = new Vector();
                            }
                            if (!dummy.contains(attribute)) {
                                dummy.add(attribute);
                            }
                            stringHt.put(namespace, dummy);
                        }
                        rs.close();
                        boolean firstSet = false;
                        Enumeration en = stringHt.keys();
                        while (en.hasMoreElements()) {
                            namespace = (String)en.nextElement();
                            dummy = (Vector)stringHt.get(namespace);
                            boolean firstSet2 = false;
                            int size = dummy.size();
                            if (!firstSet) {
                                updateString1.append(" AND ((");
                            } else {
                                updateString1.append(" OR (");
                            }
                            updateString1.append(this.nameSpaceColumn);
                            updateString1.append("=? AND ");
                            updateString1.append(this.nameSpaceHashColumn);
                            updateString1.append("=? AND (");
                            int i = 0;
                            while (i < size) {
                                if (firstSet2) {
                                    updateString1.append(" OR ");
                                }
                                updateString1.append("(");
                                updateString1.append(this.attributeColumn);
                                updateString1.append("=? AND ");
                                updateString1.append(this.attributeHashColumn);
                                updateString1.append("=?)");
                                firstSet2 = true;
                                ++i;
                            }
                            updateString1.append("))");
                            firstSet = true;
                            if (en.hasMoreElements()) continue;
                            updateString1.append(")");
                        }
                        if (mTrace.beInfo()) {
                            mTrace.infoT(methodName, "Perform query: " + queryString2.toString());
                        }
                        ps4 = myCon.prepareStatement(queryString2.toString());
                        ps4.setObject(1, principalID);
                        ps4.setLong(2, Util.getHash(principalID));
                        rs = ps4.executeQuery();
                        Hashtable<String, Vector> blobHt = new Hashtable<String, Vector>();
                        while (rs.next()) {
                            namespace = rs.getString(this.nameSpaceColumn);
                            if (!this.feelsResponsible(type, namespace, attribute = rs.getString(this.attributeColumn))) continue;
                            dummy = (Vector)blobHt.get(namespace);
                            if (dummy == null) {
                                dummy = new Vector();
                            }
                            if (!dummy.contains(attribute)) {
                                dummy.add(attribute);
                            }
                            blobHt.put(namespace, dummy);
                        }
                        if (!stringHt.isEmpty()) {
                            if (mTrace.beInfo()) {
                                mTrace.infoT(methodName, "Perform query: " + updateString1.toString());
                            }
                            ps1 = myCon.prepareStatement(updateString1.toString());
                            ps1.setObject(1, principalID);
                            ps1.setLong(2, Util.getHash(principalID));
                            int counter = 3;
                            Enumeration en2 = stringHt.keys();
                            while (en2.hasMoreElements()) {
                                namespace = (String)en2.nextElement();
                                ps1.setString(counter, namespace);
                                ps1.setLong(++counter, Util.getHash(namespace));
                                ++counter;
                                dummy = (Vector)stringHt.get(namespace);
                                int size = dummy.size();
                                int i = 0;
                                while (i < size) {
                                    attribute = (String)dummy.elementAt(i);
                                    ps1.setString(counter, attribute);
                                    ps1.setLong(++counter, Util.getHash(attribute));
                                    ++counter;
                                    ++i;
                                }
                            }
                            ps1.executeUpdate();
                        }
                        if (blobHt.isEmpty()) break block33;
                        StringBuffer updateString2 = new StringBuffer();
                        updateString2.append("DELETE FROM ");
                        updateString2.append(this.getRealTableName(this.blobValueTable, type));
                        updateString2.append(" WHERE (");
                        updateString2.append(this.principalIdColumn);
                        updateString2.append(" = ?)");
                        updateString2.append(" AND (");
                        updateString2.append(this.principalIdHashColumn);
                        updateString2.append(" = ?)");
                        firstSet = false;
                        Enumeration en3 = blobHt.keys();
                        while (en3.hasMoreElements()) {
                            namespace = (String)en3.nextElement();
                            dummy = (Vector)blobHt.get(namespace);
                            boolean firstSet2 = false;
                            int size = dummy.size();
                            if (!firstSet) {
                                updateString2.append(" AND ((");
                            } else {
                                updateString2.append(" OR (");
                            }
                            updateString2.append(this.nameSpaceColumn);
                            updateString2.append("=? AND ");
                            updateString2.append(this.nameSpaceHashColumn);
                            updateString2.append("=? AND (");
                            int i = 0;
                            while (i < size) {
                                if (firstSet2) {
                                    updateString2.append(" OR ");
                                }
                                updateString2.append("(");
                                updateString2.append(this.attributeColumn);
                                updateString2.append("=? AND ");
                                updateString2.append(this.attributeHashColumn);
                                updateString2.append("=?)");
                                firstSet2 = true;
                                ++i;
                            }
                            updateString2.append("))");
                            firstSet = true;
                            if (en3.hasMoreElements()) continue;
                            updateString2.append(")");
                        }
                        if (mTrace.beInfo()) {
                            mTrace.infoT(methodName, "Perform query: " + updateString2.toString());
                        }
                        ps2 = myCon.prepareStatement(updateString2.toString());
                        ps2.setObject(1, principalID);
                        ps2.setLong(2, Util.getHash(principalID));
                        int counter = 3;
                        Enumeration en4 = blobHt.keys();
                        while (en4.hasMoreElements()) {
                            namespace = (String)en4.nextElement();
                            ps2.setString(counter, namespace);
                            ps2.setLong(++counter, Util.getHash(namespace));
                            ++counter;
                            dummy = (Vector)blobHt.get(namespace);
                            int size = dummy.size();
                            int i = 0;
                            while (i < size) {
                                attribute = (String)dummy.elementAt(i);
                                ps2.setString(counter, attribute);
                                ps2.setLong(++counter, Util.getHash(attribute));
                                ++counter;
                                ++i;
                            }
                        }
                        ps2.executeUpdate();
                    }
                    catch (SQLException sqlex) {
                        throw new PersistenceException(sqlex);
                    }
                }
                Object var30_37 = null;
                this.closeResultSet(rs, methodName);
                this.closePreparedStatement(ps1, methodName);
                this.closePreparedStatement(ps2, methodName);
            }
            catch (Throwable throwable) {
                Object var30_38 = null;
                this.closeResultSet(rs, methodName);
                this.closePreparedStatement(ps1, methodName);
                this.closePreparedStatement(ps2, methodName);
                throw throwable;
            }
        }
    }

    public void createPrincipalDatabag(IInternalPrincipalDatabag principal, IDataSourceTransaction transaction) throws PersistenceException {
        String methodName = "createPrincipalDatabag";
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        if (this.isReadonly()) {
            if (mTrace.beInfo()) {
                mTrace.infoT(methodName, "This datasource is readonly... do not try to create principal databag.");
            }
            return;
        }
        String principalID = principal.getUniqueID();
        if (principalID == null) {
            String errorMessage = "A principal databag has to be bound before it can be created!";
            throw new PersistenceException(errorMessage);
        }
        if (this.feelsResponsible(principal)) {
            String[] idParts = principal.getIDParts();
            String type = idParts[0];
            Connection myCon = ((DataBaseDataSourceTransaction)transaction).getDBConnection();
            Statement currentStringsPreparedStatement = null;
            Statement currentBlobsPreparedStatement = null;
            try {
                block24: {
                    try {
                        Vector respNameSpaces = new Vector();
                        Enumeration en = principal.getNameSpaces();
                        while (en.hasMoreElements()) {
                            respNameSpaces.add(en.nextElement());
                        }
                        int j = 0;
                        while (j < respNameSpaces.size()) {
                            String nameSpace = (String)respNameSpaces.elementAt(j);
                            Enumeration attrsEn = principal.getAttributesOnNamespace(nameSpace);
                            while (attrsEn.hasMoreElements()) {
                                Object o;
                                Vector v;
                                String attribute = (String)attrsEn.nextElement();
                                if (nameSpace.equals("com.sap.security.core.usermanagement") && (attribute.equals("PRINCIPAL_TYPE_ATTRIBUTE") || attribute.equals("oldpassword")) || !this.feelsResponsible(type, nameSpace, attribute) || (v = principal.getAttributeValues(nameSpace, attribute)) == null) continue;
                                int vectorSize = v.size();
                                if (v.isEmpty() || (o = v.firstElement()) == null) continue;
                                if (!(o instanceof String) && !(o instanceof byte[])) {
                                    String errorMessage = "Unsupported value type: " + o.getClass();
                                    throw new PersistenceException(errorMessage);
                                }
                                int i = 0;
                                while (i < vectorSize) {
                                    if (v.elementAt(i) != null) {
                                        if (o instanceof String) {
                                            if (attribute.equals("j_password") && nameSpace.equals("com.sap.security.core.usermanagement")) {
                                                Vector logonIDs = principal.getAttributeValues("com.sap.security.core.usermanagement", "j_user");
                                                if (logonIDs != null && logonIDs.size() > 0) {
                                                    String logonID = (String)logonIDs.firstElement();
                                                    String hashedPassword = new PasswordHash(logonID, (String)v.elementAt(i)).getHash();
                                                    v.setElementAt(hashedPassword, i);
                                                } else {
                                                    String errorMessage = "Cannot set password for principal " + principal.getUniqueID() + " without logon id!";
                                                    throw new PersistenceException(errorMessage);
                                                }
                                            }
                                            if (currentStringsPreparedStatement == null) {
                                                currentStringsPreparedStatement = this.createInsertStatement(myCon, o, type);
                                            }
                                            this.addBatchToInsertStatement((PreparedStatement)currentStringsPreparedStatement, myCon, type, principalID, nameSpace, attribute, v.elementAt(i));
                                        } else {
                                            if (currentBlobsPreparedStatement == null) {
                                                currentBlobsPreparedStatement = this.createInsertStatement(myCon, o, type);
                                            }
                                            this.addBatchToInsertStatement((PreparedStatement)currentBlobsPreparedStatement, myCon, type, principalID, nameSpace, attribute, v.elementAt(i));
                                        }
                                    }
                                    ++i;
                                }
                            }
                            ++j;
                        }
                        if (currentStringsPreparedStatement != null) {
                            currentStringsPreparedStatement.executeBatch();
                        }
                        if (currentBlobsPreparedStatement == null) break block24;
                        currentBlobsPreparedStatement.executeBatch();
                    }
                    catch (SQLException sqlex) {
                        if (sqlex instanceof com.sap.sql.DuplicateKeyException || sqlex.getSQLState().equals(XOPEN_SQL_STATE_CONSTRAINT_VIOLATED)) {
                            throw new DuplicateKeyException(sqlex);
                        }
                        throw new PersistenceException(sqlex);
                    }
                }
                Object var24_27 = null;
                this.closePreparedStatement((PreparedStatement)currentStringsPreparedStatement, methodName);
                this.closePreparedStatement((PreparedStatement)currentBlobsPreparedStatement, methodName);
            }
            catch (Throwable throwable) {
                Object var24_28 = null;
                this.closePreparedStatement((PreparedStatement)currentStringsPreparedStatement, methodName);
                this.closePreparedStatement((PreparedStatement)currentBlobsPreparedStatement, methodName);
                throw throwable;
            }
        }
    }

    private PreparedStatement createInsertStatement(Connection con, Object o, String type) throws SQLException, PersistenceException {
        String methodName = "createInsertStatement";
        String cachedInsertString = null;
        if (o instanceof String) {
            cachedInsertString = DataBaseStringsPool.getInstance().getDataBaseString("ISS", type);
        } else if (o instanceof byte[]) {
            cachedInsertString = DataBaseStringsPool.getInstance().getDataBaseString("ISB", type);
        } else {
            String errorMessage = "Unsupported value type: " + o.getClass();
            throw new PersistenceException(errorMessage);
        }
        StringBuffer sqlString = null;
        if (cachedInsertString == null) {
            String dbTableName = null;
            if (o instanceof String) {
                dbTableName = this.stringValueTable;
            } else if (o instanceof byte[]) {
                dbTableName = this.blobValueTable;
            } else {
                String errorMessage = "Unsupported value type: " + o.getClass();
                throw new PersistenceException(errorMessage);
            }
            sqlString = new StringBuffer();
            sqlString.append("INSERT INTO ");
            sqlString.append(this.getRealTableName(dbTableName, type));
            sqlString.append("(");
            sqlString.append(this.principalIdColumn);
            sqlString.append(",");
            sqlString.append(this.principalIdHashColumn);
            sqlString.append(",");
            sqlString.append(this.nameSpaceColumn);
            sqlString.append(",");
            sqlString.append(this.nameSpaceHashColumn);
            sqlString.append(",");
            sqlString.append(this.attributeColumn);
            sqlString.append(",");
            sqlString.append(this.attributeHashColumn);
            sqlString.append(",");
            sqlString.append(this.attributeGUIDColumn);
            sqlString.append(",");
            sqlString.append(this.valueColumn);
            if (dbTableName.equals(this.stringValueTable)) {
                sqlString.append(",");
                sqlString.append(this.upperValueColumn);
                sqlString.append(",");
                sqlString.append(this.valueHashColumn);
                sqlString.append(",");
                sqlString.append(this.upperValueHashColumn);
            }
            sqlString.append(")");
            sqlString.append(" VALUES ");
            sqlString.append("(?,?,?,?,?,?,?,?");
            if (dbTableName.equals(this.stringValueTable)) {
                sqlString.append(",?,?,?");
            }
            sqlString.append(")");
        }
        if (mTrace.beInfo()) {
            if (sqlString != null) {
                mTrace.infoT("createInsertStatement", "Create prepared insert statement: " + sqlString);
            } else {
                mTrace.infoT("createInsertStatement", "Create prepared insert statement: " + cachedInsertString);
            }
        }
        PreparedStatement newStatement = null;
        if (sqlString != null) {
            newStatement = con.prepareStatement(sqlString.toString());
            if (o instanceof String) {
                DataBaseStringsPool.getInstance().storeDataBaseString("ISS", type, sqlString.toString());
            } else if (o instanceof byte[]) {
                DataBaseStringsPool.getInstance().storeDataBaseString("ISB", type, sqlString.toString());
            }
        } else {
            newStatement = con.prepareStatement(cachedInsertString);
        }
        return newStatement;
    }

    private PreparedStatement createDeleteStatement(Connection con, Object o, String dbTable) throws SQLException {
        String methodName = "createDeleteStatement";
        String cachedDeleteString = null;
        cachedDeleteString = o == null ? DataBaseStringsPool.getInstance().getDataBaseString("DS", dbTable) : DataBaseStringsPool.getInstance().getDataBaseString("DSV", dbTable);
        StringBuffer sqlString = null;
        if (cachedDeleteString == null) {
            sqlString = new StringBuffer();
            sqlString.append("DELETE FROM ");
            sqlString.append(dbTable);
            sqlString.append(" WHERE (");
            sqlString.append(this.principalIdColumn);
            sqlString.append(" = ?) AND (");
            sqlString.append(this.principalIdHashColumn);
            sqlString.append(" = ?) AND (");
            sqlString.append(this.nameSpaceColumn);
            sqlString.append(" = ?) AND (");
            sqlString.append(this.nameSpaceHashColumn);
            sqlString.append(" = ?) AND (");
            sqlString.append(this.attributeColumn);
            sqlString.append(" = ?) AND (");
            sqlString.append(this.attributeHashColumn);
            sqlString.append(" = ?)");
            if (o != null) {
                sqlString.append(" AND (");
                sqlString.append(this.valueColumn);
                sqlString.append(" = ?) AND (");
                sqlString.append(this.valueHashColumn);
                sqlString.append(" = ?)");
            }
        }
        if (mTrace.beInfo()) {
            if (sqlString != null) {
                mTrace.infoT("createDeleteStatement", "Create prepared delete statement: " + sqlString);
            } else {
                mTrace.infoT("createDeleteStatement", "Create prepared delete statement: " + cachedDeleteString);
            }
        }
        PreparedStatement newStatement = null;
        if (sqlString != null) {
            newStatement = con.prepareStatement(sqlString.toString());
            if (o != null) {
                DataBaseStringsPool.getInstance().storeDataBaseString("DSV", dbTable, sqlString.toString());
            } else {
                DataBaseStringsPool.getInstance().storeDataBaseString("DS", dbTable, sqlString.toString());
            }
        } else {
            newStatement = con.prepareStatement(cachedDeleteString);
        }
        return newStatement;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addBatchToDeleteStatement(PreparedStatement stmt, String type, String principalID, String nameSpace, String attribute, Object val) throws SQLException, PersistenceException {
        Object value = val instanceof String && val.equals("") ? THIS_REPLACES_THE_EMPTY_STRING_FOR_ORACLE : val;
        if (mTrace.beInfo()) {
            StringBuffer sqlString = new StringBuffer();
            sqlString.append("DELETE FROM ");
            sqlString.append("<table>");
            sqlString.append(" WHERE (");
            sqlString.append(this.principalIdColumn);
            sqlString.append(" = '" + principalID + "') AND (");
            sqlString.append(this.principalIdHashColumn);
            sqlString.append(" = " + Util.getHash(principalID) + ") AND (");
            sqlString.append(this.nameSpaceColumn);
            sqlString.append(" = '" + nameSpace + "') AND (");
            sqlString.append(this.nameSpaceHashColumn);
            sqlString.append(" = " + Util.getHash(nameSpace) + ") AND (");
            sqlString.append(this.attributeColumn);
            sqlString.append(" = '" + this.getPhysicalAttribute(type, nameSpace, attribute) + "') AND (");
            sqlString.append(this.attributeHashColumn);
            sqlString.append(" = " + Util.getHash(this.getPhysicalAttribute(type, nameSpace, attribute)) + ")");
            if (value != null) {
                sqlString.append(" AND (");
                sqlString.append(this.valueColumn);
                sqlString.append(" = '" + (String)value + "') AND (");
                sqlString.append(this.valueHashColumn);
                sqlString.append(" = " + Util.getHash((String)value) + ")");
            }
            mTrace.infoT("addBatchToDeleteStatement", "Adding batch to delete statement: " + sqlString.toString());
        }
        stmt.setObject(1, principalID);
        stmt.setLong(2, Util.getHash(principalID));
        stmt.setObject(3, nameSpace);
        stmt.setLong(4, Util.getHash(nameSpace));
        stmt.setObject(5, this.getPhysicalAttribute(type, nameSpace, attribute));
        stmt.setLong(6, Util.getHash(this.getPhysicalAttribute(type, nameSpace, attribute)));
        if (value == null) {
            stmt.addBatch();
            return;
        }
        if (value instanceof String) {
            stmt.setObject(7, (String)value);
            stmt.setLong(8, Util.getHash((String)value));
            stmt.addBatch();
            return;
        }
        stmt.clearParameters();
        String errorMessage = "Removing single value is only supported for strings found: " + value.getClass();
        throw new PersistenceException(errorMessage);
    }

    private String createAttributeGuid(String type, String principalID, String nameSpace, String attribute, Object value) {
        String guid;
        if (attribute.equals("uniquename") && nameSpace.equals("com.sap.security.core.usermanagement") && (type.equals("USER") || type.equals("GRUP") || type.equals("ROLE") || type.equals("TEAM") || type.equals("COMP")) || attribute.equals("j_user") && nameSpace.equals("com.sap.security.core.usermanagement") && type.equals("UACC")) {
            String obj = Base64.encode(Util.createMD5HashValue(value.toString().getBytes()));
            StringBuffer g = new StringBuffer(type.length() + ".".length() + obj.length());
            g.append(type);
            g.append(".");
            g.append(obj);
            guid = g.toString();
        } else if (this.mCheckUniquenessOfAttributeValues) {
            String obj = value instanceof String ? (String)value : value.toString();
            StringBuffer strBuff = new StringBuffer(principalID.length() + nameSpace.length() + attribute.length() + obj.length());
            strBuff.append(principalID);
            strBuff.append(nameSpace);
            strBuff.append(attribute);
            strBuff.append(obj);
            obj = Base64.encode(Util.createMD5HashValue(strBuff.toString().getBytes()));
            StringBuffer g = new StringBuffer(type.length() + ".".length() + obj.length());
            g.append(type);
            g.append(".");
            g.append(obj);
            guid = g.toString();
        } else {
            guid = Util.createGUID();
        }
        return guid;
    }

    private void addBatchToInsertStatement(PreparedStatement stmt, Connection con, String type, String principalID, String nameSpace, String attribute, Object val) throws SQLException, PersistenceException {
        String methodName = "addBatchToInsertStatement";
        Object value = val instanceof String && val.equals("") ? THIS_REPLACES_THE_EMPTY_STRING_FOR_ORACLE : val;
        String guid = this.createAttributeGuid(type, principalID, nameSpace, attribute, value);
        if (mTrace.beInfo()) {
            StringBuffer sqlString = new StringBuffer();
            sqlString.append("INSERT INTO ");
            sqlString.append("<table>");
            sqlString.append("(");
            sqlString.append(this.principalIdColumn);
            sqlString.append(",");
            sqlString.append(this.principalIdHashColumn);
            sqlString.append(",");
            sqlString.append(this.nameSpaceColumn);
            sqlString.append(",");
            sqlString.append(this.nameSpaceHashColumn);
            sqlString.append(",");
            sqlString.append(this.attributeColumn);
            sqlString.append(",");
            sqlString.append(this.attributeHashColumn);
            sqlString.append(",");
            sqlString.append(this.attributeGUIDColumn);
            sqlString.append(",");
            sqlString.append(this.valueColumn);
            if (value instanceof String) {
                sqlString.append(",");
                sqlString.append(this.upperValueColumn);
                sqlString.append(",");
                sqlString.append(this.valueHashColumn);
                sqlString.append(",");
                sqlString.append(this.upperValueHashColumn);
            }
            sqlString.append(")");
            sqlString.append(" VALUES ");
            sqlString.append("('" + principalID + "'," + Util.getHash(principalID) + ",'" + nameSpace + "'," + Util.getHash(nameSpace) + ",'" + this.getPhysicalAttribute(type, nameSpace, attribute) + "'," + Util.getHash(this.getPhysicalAttribute(type, nameSpace, attribute)) + ",'" + guid + "',");
            if (value instanceof String) {
                if (!nameSpace.equals("com.sap.security.core.usermanagement") || !attribute.equals("j_password")) {
                    sqlString.append("'" + (String)value + "','" + ((String)value).toUpperCase() + "'," + Util.getHash((String)value) + "," + Util.getHash(((String)value).toUpperCase()));
                } else {
                    sqlString.append("'********','********'," + Util.getHash((String)value) + "," + Util.getHash(((String)value).toUpperCase()));
                }
            } else if (value instanceof byte[]) {
                sqlString.append("byte[" + ((byte[])value).length + "]");
            }
            sqlString.append(")");
            mTrace.infoT(methodName, "Adding batch to insert statement: " + sqlString.toString());
        }
        stmt.setObject(1, principalID);
        stmt.setLong(2, Util.getHash(principalID));
        stmt.setObject(3, nameSpace);
        stmt.setLong(4, Util.getHash(nameSpace));
        stmt.setObject(5, this.getPhysicalAttribute(type, nameSpace, attribute));
        stmt.setLong(6, Util.getHash(this.getPhysicalAttribute(type, nameSpace, attribute)));
        stmt.setObject(7, guid);
        if (value instanceof String) {
            stmt.setObject(8, (String)value);
            stmt.setObject(9, ((String)value).toUpperCase());
            stmt.setLong(10, Util.getHash((String)value));
            stmt.setLong(11, Util.getHash(((String)value).toUpperCase()));
            stmt.addBatch();
        } else if (value instanceof byte[]) {
            if (!this.mConnectionPool.isOracleNativeDriverUsed()) {
                byte[] blob = (byte[])value;
                stmt.setBinaryStream(8, (InputStream)new ByteArrayInputStream(blob), blob.length);
                stmt.addBatch();
            } else {
                stmt.setBlob(8, this.mOracleUtil.oracleGetEmptyBlob());
                stmt.executeUpdate();
                StringBuffer selectEmptyBlobQuery = new StringBuffer();
                selectEmptyBlobQuery.append("SELECT ");
                selectEmptyBlobQuery.append(this.valueColumn);
                selectEmptyBlobQuery.append(" FROM ");
                selectEmptyBlobQuery.append(this.getRealTableName(this.blobValueTable, type));
                selectEmptyBlobQuery.append(" WHERE ");
                selectEmptyBlobQuery.append(this.attributeGUIDColumn);
                selectEmptyBlobQuery.append(" = ?");
                PreparedStatement selectEmptyBlobStatement = null;
                ResultSet blobResult = null;
                try {
                    selectEmptyBlobStatement = con.prepareStatement(selectEmptyBlobQuery.toString());
                    selectEmptyBlobStatement.setObject(1, guid);
                    blobResult = selectEmptyBlobStatement.executeQuery();
                    if (blobResult.next()) {
                        Blob b = blobResult.getBlob(this.valueColumn);
                        this.mOracleUtil.oracleWriteBlob(b, (byte[])value);
                    }
                    Object var16_15 = null;
                    this.closeResultSet(blobResult, methodName);
                    this.closePreparedStatement(selectEmptyBlobStatement, methodName);
                }
                catch (Throwable throwable) {
                    Object var16_16 = null;
                    this.closeResultSet(blobResult, methodName);
                    this.closePreparedStatement(selectEmptyBlobStatement, methodName);
                    throw throwable;
                }
            }
        } else {
            stmt.clearParameters();
            String errorMessage = "Unsupported value type: " + value.getClass();
            throw new PersistenceException(errorMessage);
        }
    }

    public void updatePrincipalDatabag(IInternalPrincipalDatabagMaint principalMaint, IDataSourceTransaction transaction) throws PersistenceException {
        String methodName = "updatePrincipalDatabag";
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        if (this.isReadonly()) {
            if (mTrace.beInfo()) {
                mTrace.infoT(methodName, "This datasource is readonly... do not try to update principal databag.");
            }
            return;
        }
        Vector addValues = null;
        Vector removeValues = null;
        Connection myCon = ((DataBaseDataSourceTransaction)transaction).getDBConnection();
        String principalID = principalMaint.getUniqueID();
        String[] idParts = principalMaint.getIDParts();
        String type = idParts[0];
        Statement deleteSingleValueString = null;
        Statement deleteAllValuesString = null;
        Statement deleteAllValuesBlob = null;
        Statement insertValueString = null;
        Statement insertValueBlob = null;
        try {
            int vectorSize;
            int attrType;
            String attributeName;
            Enumeration innerEn;
            String nameSpace;
            Enumeration en;
            try {
                en = principalMaint.getNameSpaces(2);
                while (en.hasMoreElements()) {
                    nameSpace = (String)en.nextElement();
                    innerEn = principalMaint.getAttributesOnNamespace(nameSpace, 2);
                    while (innerEn.hasMoreElements()) {
                        Object o;
                        attributeName = (String)innerEn.nextElement();
                        if (nameSpace.equals("com.sap.security.core.usermanagement") && (attributeName.equals("PRINCIPAL_TYPE_ATTRIBUTE") || attributeName.equals("oldpassword")) || !this.feelsResponsible(type, nameSpace, attributeName)) continue;
                        Vector v = principalMaint.getAttributeValues(nameSpace, attributeName, 2);
                        if (v == null) {
                            principalMaint.deleteAttributeMaintValues(nameSpace, attributeName);
                            continue;
                        }
                        attrType = -1;
                        if (!v.isEmpty() && (o = v.firstElement()) != null) {
                            if (o instanceof String) {
                                attrType = 1;
                            }
                            if (o instanceof byte[]) {
                                attrType = 2;
                            }
                        }
                        if (attrType == -1) {
                            attrType = this.mConfigurationModel.getAttributeType(type, nameSpace, attributeName);
                        }
                        if (attrType == 1 || attrType == 0) {
                            if (deleteAllValuesString == null) {
                                deleteAllValuesString = this.createDeleteStatement(myCon, null, this.getRealTableName(this.stringValueTable, type));
                            }
                            this.addBatchToDeleteStatement((PreparedStatement)deleteAllValuesString, type, principalID, nameSpace, attributeName, null);
                        }
                        if (attrType == 2 || attrType == 0) {
                            if (deleteAllValuesBlob == null) {
                                deleteAllValuesBlob = this.createDeleteStatement(myCon, null, this.getRealTableName(this.blobValueTable, type));
                            }
                            this.addBatchToDeleteStatement((PreparedStatement)deleteAllValuesBlob, type, principalID, nameSpace, attributeName, null);
                        }
                        vectorSize = v.size();
                        if (v.isEmpty() || (o = v.firstElement()) == null) continue;
                        attrType = this.mConfigurationModel.getAttributeType(type, nameSpace, attributeName);
                        if (o instanceof String) {
                            if (attrType != 1 && attrType != 0) {
                                String errorMessage = "Only values of type string are allowed for attribute \"" + attributeName + "\" on namespace \"" + nameSpace + "\" for principal type \"" + type + "\"";
                                throw new PersistenceException(errorMessage);
                            }
                        } else if (o instanceof byte[]) {
                            if (attrType != 2 && attrType != 0) {
                                String errorMessage = "Only values of type blob are allowed for attribute \"" + attributeName + "\" on namespace \"" + nameSpace + "\" for principal type \"" + type + "\"";
                                throw new PersistenceException(errorMessage);
                            }
                        } else {
                            String errorMessage = "Unsupported value type: " + o.getClass();
                            throw new PersistenceException(errorMessage);
                        }
                        int i = 0;
                        while (i < vectorSize) {
                            if (v.elementAt(i) != null) {
                                if (v.elementAt(i) instanceof String) {
                                    if (attributeName.equals("j_password") && nameSpace.equals("com.sap.security.core.usermanagement")) {
                                        Vector logonIDs = principalMaint.getAttributeValues("com.sap.security.core.usermanagement", "j_user");
                                        if (logonIDs != null && logonIDs.size() > 0) {
                                            String logonID = (String)logonIDs.firstElement();
                                            String hashedPassword = new PasswordHash(logonID, (String)v.elementAt(i)).getHash();
                                            v.setElementAt(hashedPassword, i);
                                        } else {
                                            String errorMessage = "Cannot set password for principal " + principalMaint.getUniqueID() + " without logon id!";
                                            throw new PersistenceException(errorMessage);
                                        }
                                    }
                                    if (insertValueString == null) {
                                        insertValueString = this.createInsertStatement(myCon, v.elementAt(i), type);
                                    }
                                    this.addBatchToInsertStatement((PreparedStatement)insertValueString, myCon, type, principalID, nameSpace, attributeName, v.elementAt(i));
                                }
                                if (v.elementAt(i) instanceof byte[] && insertValueBlob == null) {
                                    insertValueBlob = this.createInsertStatement(myCon, v.elementAt(i), type);
                                    this.addBatchToInsertStatement((PreparedStatement)insertValueBlob, myCon, type, principalID, nameSpace, attributeName, v.elementAt(i));
                                }
                            }
                            ++i;
                        }
                    }
                }
                if (deleteAllValuesString != null) {
                    deleteAllValuesString.executeBatch();
                }
                if (deleteAllValuesBlob != null) {
                    deleteAllValuesBlob.executeBatch();
                }
                if (insertValueString != null) {
                    insertValueString.executeBatch();
                }
                if (insertValueBlob != null) {
                    insertValueBlob.executeBatch();
                }
            }
            catch (SQLException sqlex) {
                if (sqlex instanceof com.sap.sql.DuplicateKeyException || sqlex.getSQLState().equals(XOPEN_SQL_STATE_CONSTRAINT_VIOLATED)) {
                    throw new DuplicateKeyException(sqlex);
                }
                throw new PersistenceException(sqlex);
            }
            try {
                en = principalMaint.getNameSpaces(3);
                while (en.hasMoreElements()) {
                    nameSpace = (String)en.nextElement();
                    innerEn = principalMaint.getAttributesOnNamespace(nameSpace, 3);
                    while (innerEn.hasMoreElements()) {
                        attributeName = (String)innerEn.nextElement();
                        if (nameSpace.equals("com.sap.security.core.usermanagement") && (attributeName.equals("PRINCIPAL_TYPE_ATTRIBUTE") || attributeName.equals("oldpassword")) || !this.feelsResponsible(type, nameSpace, attributeName)) continue;
                        int attrType2 = this.mConfigurationModel.getAttributeType(type, nameSpace, attributeName);
                        if (attrType2 == 1 || attrType2 == 0) {
                            if (deleteAllValuesString == null) {
                                deleteAllValuesString = this.createDeleteStatement(myCon, null, this.getRealTableName(this.stringValueTable, type));
                            }
                            this.addBatchToDeleteStatement((PreparedStatement)deleteAllValuesString, type, principalID, nameSpace, attributeName, null);
                        }
                        if (attrType2 != 2 && attrType2 != 0) continue;
                        if (deleteAllValuesBlob == null) {
                            deleteAllValuesBlob = this.createDeleteStatement(myCon, null, this.getRealTableName(this.blobValueTable, type));
                        }
                        this.addBatchToDeleteStatement((PreparedStatement)deleteAllValuesBlob, type, principalID, nameSpace, attributeName, null);
                    }
                }
                if (deleteAllValuesString != null) {
                    deleteAllValuesString.executeBatch();
                }
                if (deleteAllValuesBlob != null) {
                    deleteAllValuesBlob.executeBatch();
                }
            }
            catch (SQLException sqlex) {
                throw new PersistenceException(sqlex);
            }
            try {
                en = principalMaint.getNameSpaces(0);
                while (en.hasMoreElements()) {
                    nameSpace = (String)en.nextElement();
                    innerEn = principalMaint.getAttributesOnNamespace(nameSpace, 0);
                    while (innerEn.hasMoreElements()) {
                        Object o;
                        attributeName = (String)innerEn.nextElement();
                        if (nameSpace.equals("com.sap.security.core.usermanagement") && (attributeName.equals("PRINCIPAL_TYPE_ATTRIBUTE") || attributeName.equals("oldpassword")) || !this.feelsResponsible(type, nameSpace, attributeName) || (addValues = principalMaint.getAttributeValues(nameSpace, attributeName, 0)) == null) continue;
                        vectorSize = addValues.size();
                        if (addValues.isEmpty() || (o = addValues.firstElement()) == null) continue;
                        attrType = this.mConfigurationModel.getAttributeType(type, nameSpace, attributeName);
                        if (o instanceof String) {
                            if (attrType != 1 && attrType != 0) {
                                String errorMessage = "Only values of type string are allowed for attribute \"" + attributeName + "\" on namespace \"" + nameSpace + "\" for principal type \"" + type + "\"";
                                throw new PersistenceException(errorMessage);
                            }
                        } else if (o instanceof byte[]) {
                            if (attrType != 2 && attrType != 0) {
                                String errorMessage = "Only values of type blob are allowed for attribute \"" + attributeName + "\" on namespace \"" + nameSpace + "\" for principal type \"" + type + "\"";
                                throw new PersistenceException(errorMessage);
                            }
                        } else {
                            String errorMessage = "Unsupported value type: " + o.getClass();
                            throw new PersistenceException(errorMessage);
                        }
                        int i = 0;
                        while (i < vectorSize) {
                            if (addValues.elementAt(i) != null) {
                                if (addValues.elementAt(i) instanceof String) {
                                    if (attributeName.equals("j_password") && nameSpace.equals("com.sap.security.core.usermanagement")) {
                                        Vector logonIDs = principalMaint.getAttributeValues("com.sap.security.core.usermanagement", "j_user");
                                        if (logonIDs != null && logonIDs.size() > 0) {
                                            String logonID = (String)logonIDs.firstElement();
                                            String hashedPassword = new PasswordHash(logonID, (String)addValues.elementAt(i)).getHash();
                                            addValues.setElementAt(hashedPassword, i);
                                        } else {
                                            String errorMessage = "Cannot set password for principal " + principalMaint.getUniqueID() + " without logon id!";
                                            throw new PersistenceException(errorMessage);
                                        }
                                    }
                                    if (insertValueString == null) {
                                        insertValueString = this.createInsertStatement(myCon, addValues.elementAt(i), type);
                                    }
                                    this.addBatchToInsertStatement((PreparedStatement)insertValueString, myCon, type, principalID, nameSpace, attributeName, addValues.elementAt(i));
                                }
                                if (addValues.elementAt(i) instanceof byte[] && insertValueBlob == null) {
                                    insertValueBlob = this.createInsertStatement(myCon, addValues.elementAt(i), type);
                                    this.addBatchToInsertStatement((PreparedStatement)insertValueBlob, myCon, type, principalID, nameSpace, attributeName, addValues.elementAt(i));
                                }
                            }
                            ++i;
                        }
                    }
                }
                if (insertValueString != null) {
                    insertValueString.executeBatch();
                }
                if (insertValueBlob != null) {
                    insertValueBlob.executeBatch();
                }
            }
            catch (SQLException sqlex) {
                if (sqlex instanceof com.sap.sql.DuplicateKeyException || sqlex.getSQLState().equals(XOPEN_SQL_STATE_CONSTRAINT_VIOLATED)) {
                    throw new DuplicateKeyException(sqlex);
                }
                throw new PersistenceException(sqlex);
            }
            try {
                en = principalMaint.getNameSpaces(1);
                while (en.hasMoreElements()) {
                    nameSpace = (String)en.nextElement();
                    innerEn = principalMaint.getAttributesOnNamespace(nameSpace, 1);
                    while (innerEn.hasMoreElements()) {
                        attributeName = (String)innerEn.nextElement();
                        if (nameSpace.equals("com.sap.security.core.usermanagement") && (attributeName.equals("PRINCIPAL_TYPE_ATTRIBUTE") || attributeName.equals("oldpassword")) || !this.feelsResponsible(type, nameSpace, attributeName) || (removeValues = principalMaint.getAttributeValues(nameSpace, attributeName, 1)) == null) continue;
                        int i = 0;
                        while (i < removeValues.size()) {
                            Object o = removeValues.elementAt(i);
                            if (o instanceof String) {
                                if (deleteSingleValueString == null) {
                                    deleteSingleValueString = this.createDeleteStatement(myCon, o, this.getRealTableName(this.stringValueTable, type));
                                }
                                this.addBatchToDeleteStatement((PreparedStatement)deleteSingleValueString, type, principalID, nameSpace, attributeName, o);
                            } else if (o instanceof byte[]) {
                                throw new PersistenceException("Cannot remove single blob!");
                            }
                            ++i;
                        }
                    }
                }
                if (deleteSingleValueString != null) {
                    deleteSingleValueString.executeBatch();
                }
            }
            catch (SQLException sqlex) {
                throw new PersistenceException(sqlex);
            }
            Object var28_46 = null;
            this.closePreparedStatement((PreparedStatement)deleteSingleValueString, methodName);
            this.closePreparedStatement((PreparedStatement)deleteAllValuesString, methodName);
            this.closePreparedStatement((PreparedStatement)deleteAllValuesBlob, methodName);
            this.closePreparedStatement((PreparedStatement)insertValueString, methodName);
            this.closePreparedStatement((PreparedStatement)insertValueBlob, methodName);
        }
        catch (Throwable throwable) {
            Object var28_47 = null;
            this.closePreparedStatement((PreparedStatement)deleteSingleValueString, methodName);
            this.closePreparedStatement((PreparedStatement)deleteAllValuesString, methodName);
            this.closePreparedStatement((PreparedStatement)deleteAllValuesBlob, methodName);
            this.closePreparedStatement((PreparedStatement)insertValueString, methodName);
            this.closePreparedStatement((PreparedStatement)insertValueBlob, methodName);
            throw throwable;
        }
    }

    public Vector getAttributeNamespaces(IPrincipalDatabag principal) throws PersistenceException {
        String methodName = "getAttributeNamespaces";
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        String id = principal.getUniqueID();
        String[] idParts = principal.getIDParts();
        String type = idParts[0];
        StringBuffer queryPart1 = new StringBuffer();
        StringBuffer queryPart2 = new StringBuffer();
        queryPart1.append("SELECT DISTINCT ");
        queryPart1.append(this.nameSpaceColumn);
        queryPart1.append(" FROM ");
        queryPart2.append(" WHERE (");
        queryPart2.append(this.principalIdColumn);
        queryPart2.append("= ?) AND (");
        queryPart2.append(this.principalIdHashColumn);
        queryPart2.append("= ?)");
        StringBuffer query = new StringBuffer();
        Connection myCon = this.mConnectionPool.getConnection(methodName, this.mDefaultTransactionIsolation);
        PreparedStatement ps = null;
        ResultSet rs = null;
        Vector<String> results = new Vector<String>();
        try {
            try {
                query.append(queryPart1.toString());
                query.append(this.getRealTableName(this.stringValueTable, type));
                query.append(queryPart2.toString());
                if (mTrace.beInfo()) {
                    mTrace.infoT(methodName, "Perform query: " + query.toString());
                }
                ps = myCon.prepareStatement(query.toString());
                ps.setObject(1, id);
                ps.setLong(2, Util.getHash(id));
                rs = ps.executeQuery();
                while (rs.next()) {
                    results.add(rs.getString(this.nameSpaceColumn));
                }
                rs.close();
                rs = null;
                ps.close();
                ps = null;
                query = new StringBuffer();
                query.append(queryPart1.toString());
                query.append(this.getRealTableName(this.blobValueTable, type));
                query.append(queryPart2.toString());
                if (mTrace.beInfo()) {
                    mTrace.infoT(methodName, "Perform query: " + query.toString());
                }
                ps = myCon.prepareStatement(query.toString());
                ps.setObject(1, id);
                ps.setLong(2, Util.getHash(id));
                rs = ps.executeQuery();
                while (rs.next()) {
                    results.add(rs.getString(this.nameSpaceColumn));
                }
            }
            catch (SQLException sqlex) {
                throw new PersistenceException(sqlex);
            }
            Object var15_14 = null;
            this.closeResultSet(rs, methodName);
            this.closePreparedStatement(ps, methodName);
            this.mConnectionPool.releaseConnection(myCon);
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            this.closeResultSet(rs, methodName);
            this.closePreparedStatement(ps, methodName);
            this.mConnectionPool.releaseConnection(myCon);
            throw throwable;
        }
        return results;
    }

    public Vector getAttributeNames(IPrincipalDatabag principal, String nameSpace) throws PersistenceException {
        String methodName = "getAttributeNames";
        if (!this.isInitialized) {
            String errorMessage = "Data source is not initialized!";
            throw new PersistenceException(errorMessage);
        }
        String id = principal.getUniqueID();
        String[] idParts = principal.getIDParts();
        String type = idParts[0];
        StringBuffer queryPart1 = new StringBuffer();
        StringBuffer queryPart2 = new StringBuffer();
        queryPart1.append("SELECT DISTINCT ");
        queryPart1.append(this.attributeColumn);
        queryPart1.append(" FROM ");
        queryPart2.append(" WHERE (");
        if (nameSpace != null) {
            queryPart2.append("(");
        }
        queryPart2.append(this.principalIdColumn);
        queryPart2.append("=?) AND (");
        queryPart2.append(this.principalIdHashColumn);
        queryPart2.append("=?)");
        if (nameSpace != null) {
            queryPart2.append(" AND (");
            queryPart2.append(this.nameSpaceColumn);
            queryPart2.append(" = ?) AND (");
            queryPart2.append(this.nameSpaceHashColumn);
            queryPart2.append(" = ?) )");
        }
        StringBuffer query = new StringBuffer();
        Connection myCon = this.mConnectionPool.getConnection(methodName, this.mDefaultTransactionIsolation);
        PreparedStatement ps = null;
        ResultSet rs = null;
        Vector<String> results = new Vector<String>();
        try {
            try {
                query.append(queryPart1.toString());
                query.append(this.getRealTableName(this.stringValueTable, type));
                query.append(queryPart2.toString());
                if (mTrace.beInfo()) {
                    mTrace.infoT(methodName, "Perform query: " + query.toString());
                }
                ps = myCon.prepareStatement(query.toString());
                ps.setObject(1, id);
                ps.setLong(2, Util.getHash(id));
                if (nameSpace != null) {
                    ps.setObject(3, nameSpace);
                    ps.setLong(4, Util.getHash(nameSpace));
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    results.add(rs.getString(this.attributeColumn));
                }
                rs.close();
                rs = null;
                ps.close();
                ps = null;
                query = new StringBuffer();
                query.append(queryPart1.toString());
                query.append(this.getRealTableName(this.blobValueTable, type));
                query.append(queryPart2.toString());
                if (mTrace.beInfo()) {
                    mTrace.infoT(methodName, "Perform query: " + query.toString());
                }
                ps = myCon.prepareStatement(query.toString());
                ps.setObject(1, id);
                ps.setLong(2, Util.getHash(id));
                if (nameSpace != null) {
                    ps.setObject(3, nameSpace);
                    ps.setLong(4, Util.getHash(nameSpace));
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    results.add(rs.getString(this.attributeColumn));
                }
            }
            catch (SQLException sqlex) {
                throw new PersistenceException(sqlex);
            }
            Object var16_15 = null;
            this.closeResultSet(rs, methodName);
            this.closePreparedStatement(ps, methodName);
            this.mConnectionPool.releaseConnection(myCon);
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            this.closeResultSet(rs, methodName);
            this.closePreparedStatement(ps, methodName);
            this.mConnectionPool.releaseConnection(myCon);
            throw throwable;
        }
        return results;
    }
}

