/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp;

import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.IInternalPrincipalDatabag;
import com.sap.security.core.persistence.IInternalPrincipalDatabagMaint;
import com.sap.security.core.persistence.IPrincipalDatabag;
import com.sap.security.core.persistence.datasource.IDataSourceTransaction;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.datasource.imp.DataBasePersistence;
import com.sap.security.core.util.IUMTrace;
import java.sql.Connection;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;

public class DataBaseDataSourceTransaction
implements IDataSourceTransaction {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/DataBaseDataSourceTransaction.java#2 $ from $DateTime: 2004/09/10 10:01:00 $ ($Change: 17287 $)";
    private DataBasePersistence mDataBasePersistence;
    private Connection mConnection;
    private boolean mConnectionReleased;
    private UserTransaction mUserTransaction;
    private boolean mUserTransactionUsed;
    private static IUMTrace mTrace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/DataBaseDataSourceTransaction.java#2 $ from $DateTime: 2004/09/10 10:01:00 $ ($Change: 17287 $)");

    public DataBaseDataSourceTransaction(DataBasePersistence dataBasePersistence) throws PersistenceException {
        block10: {
            try {
                this.mDataBasePersistence = dataBasePersistence;
                this.mConnectionReleased = true;
                this.mUserTransactionUsed = false;
                if (this.mDataBasePersistence.isJTASupportEnabled()) {
                    try {
                        InitialContext ctx = new InitialContext();
                        this.mUserTransaction = (UserTransaction)ctx.lookup("java:comp/UserTransaction");
                        if (this.mUserTransaction != null && this.mUserTransaction.getStatus() != 6) {
                            if (mTrace.beInfo()) {
                                mTrace.infoT("DataBaseDataSourceTransaction", "Open JTA transaction found.");
                            }
                            this.mUserTransactionUsed = true;
                        }
                    }
                    catch (Exception e) {
                        if (mTrace.beInfo()) {
                            mTrace.infoT("DataBaseDataSourceTransaction", e);
                        }
                        this.mUserTransactionUsed = false;
                    }
                    if (mTrace.beInfo()) {
                        mTrace.infoT("DataBaseDataSourceTransaction", "No JTA transaction found.");
                    }
                    break block10;
                }
                if (mTrace.beInfo()) {
                    mTrace.infoT("DataBaseDataSourceTransaction", "JTA support not enabled.");
                }
            }
            catch (Exception e) {
                throw new PersistenceException(e);
            }
        }
    }

    public void createPrincipalDatabag(IInternalPrincipalDatabag principal) throws PersistenceException {
        this.mDataBasePersistence.createPrincipalDatabag(principal, this);
    }

    public void deletePrincipalDatabag(IPrincipalDatabag principal) throws PersistenceException {
        this.mDataBasePersistence.deletePrincipalDatabag(principal, this);
    }

    public void updatePrincipalDatabag(IInternalPrincipalDatabagMaint principalMaint) throws PersistenceException {
        this.mDataBasePersistence.updatePrincipalDatabag(principalMaint, this);
    }

    public void putDBConnection(Connection connection) {
        this.mConnection = connection;
        this.mConnectionReleased = false;
    }

    public Connection getDBConnection() {
        return this.mConnection;
    }

    public void commit() throws PersistenceException {
        try {
            block8: {
                try {
                    if (!this.mUserTransactionUsed) {
                        if (!this.mConnection.getAutoCommit()) {
                            this.mConnection.commit();
                        }
                        break block8;
                    }
                    this.mDataBasePersistence.releaseConnection(this.mConnection);
                    this.mConnectionReleased = true;
                }
                catch (Exception e) {
                    throw new PersistenceException(e);
                }
            }
            Object var3_1 = null;
            if (!this.mConnectionReleased) {
                this.mDataBasePersistence.releaseConnection(this.mConnection);
                this.mConnectionReleased = true;
            }
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            if (!this.mConnectionReleased) {
                this.mDataBasePersistence.releaseConnection(this.mConnection);
                this.mConnectionReleased = true;
            }
            throw throwable;
        }
    }

    public void rollback() throws PersistenceException {
        try {
            block10: {
                try {
                    if (!this.mUserTransactionUsed) {
                        if (this.mConnection.getAutoCommit()) break block10;
                        try {
                            this.mConnection.rollback();
                        }
                        catch (Exception ex) {
                            if (mTrace.beInfo()) {
                                mTrace.infoT("rollback", "Error while rollback of connection.", ex);
                            }
                            break block10;
                        }
                    }
                    this.mDataBasePersistence.releaseConnection(this.mConnection);
                    this.mConnectionReleased = true;
                }
                catch (Exception e) {
                    throw new PersistenceException(e);
                }
            }
            Object var3_3 = null;
            if (!this.mConnectionReleased) {
                this.mDataBasePersistence.releaseConnection(this.mConnection);
                this.mConnectionReleased = true;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (!this.mConnectionReleased) {
                this.mDataBasePersistence.releaseConnection(this.mConnection);
                this.mConnectionReleased = true;
            }
            throw throwable;
        }
    }

    public boolean bindNewPrincipalDatabag(IInternalPrincipalDatabag principal) throws PersistenceException {
        boolean result = this.mDataBasePersistence.bindNewPrincipalDatabag(principal);
        return result;
    }

    protected void finalize() throws Throwable {
        if (!this.mConnectionReleased) {
            if (mTrace.beWarning()) {
                mTrace.warningT("finalize", "Database connection wasn't released. Release it due to collection of the DataBaseDataSourceTransaction object.");
            }
            this.mDataBasePersistence.releaseConnection(this.mConnection);
            this.mConnectionReleased = true;
        }
    }
}

