/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp;

import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.datasource.ConnectionTimeoutException;
import com.sap.security.core.persistence.datasource.IConnectionPool;
import com.sap.security.core.persistence.datasource.InitializationException;
import com.sap.security.core.util.IUMTrace;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;

public class DataBaseConnectionPool
implements IConnectionPool {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/DataBaseConnectionPool.java#4 $ from $DateTime: 2004/09/10 10:01:00 $ ($Change: 17287 $)";
    private String mName = null;
    private int mMinSize;
    private int mMaxSize;
    private int mMaxIdleConnections;
    private int mMaxIdleTimeMillis;
    private int mMaxWaitTimeMillis;
    public static final int DEF_MINSIZE = 1;
    public static final int DEF_MAXSIZE = 10;
    public static final int DEF_MAXIDLECONNECTIONS = 5;
    public static final int DEF_MAXIDLETIME = 600000;
    public static final int DEF_MAXWAITTIME = 30000;
    public static final int MIN_MONITORINTERVAL = 1000;
    public static final String DB_DRIVER = "ume.db.jdbc_driver";
    public static final String DB_URL = "ume.db.jdbc_url";
    public static final String DB_USER = "ume.db.jdbc_user";
    public static final String DB_PASSWORD = "ume.db.jdbc_password";
    public static final String DB_CONNECTION_POOL_NAME = "ume.db.connection_pool.internal.name";
    public static final String DB_CONNECTION_POOL_MINSIZE = "ume.db.connection_pool.internal.minsize";
    public static final String DB_CONNECTION_POOL_MAXSIZE = "ume.db.connection_pool.internal.maxsize";
    public static final String DB_CONNECTION_POOL_MAXIDLECONNECTIONS = "ume.db.connection_pool.internal.max_idle_connections";
    public static final String DB_CONNECTION_POOL_MAXIDLETIME = "ume.db.connection_pool.internal.max_connection_idle_time";
    public static final String DB_CONNECTION_POOL_MAXWAITTIME = "ume.db.connection_pool.internal.max_wait_process_time";
    public static final String DB_CONNECTION_POOL_MONITORINTERVAL = "ume.db.connection_pool.internal.monitor_interval";
    public static final String DB_CONNECTION_POOL_CONNECTION_RETRIALS = "ume.db.connection_pool.internal.connect_retrials";
    public static final String DB_CONNECTION_POOL_AUTOMATIC_CONNECTION_RELEASE_INTERVAL = "ume.db.connection_pool.internal.max_connection_usage_time";
    public static final String DB_CONNECTION_POOL_AUTOMATIC_CONNECTION_RELEASE_CHECK_INTERVAL = "ume.db.connection_pool.internal.max_connection_usage_time_check_interval";
    public static final String DB_CONNECTION_POOL_MONITORPATH = "ume.db.connection_pool.internal.monitor_path";
    public static final String XA_TRANSACTIONS_USED = "ume.db.connection_pool.internal.xatransactions_used";
    public static final String IS_UNICODE = "ume.db.connection_pool.internal.is_unicode";
    public static final String IS_ORACLE_NATIVE_DRIVER_USED = "ume.db.connection_pool.internal.oracle_native_driver_used";
    private boolean mMerantChecked;
    private boolean mIsMerantDriver;
    private boolean mOracleNativeDriverUsed;
    private int mOriginalTransactionIsolation;
    private Hashtable mConnectionParameters;
    private Hashtable distributedConnections = null;
    private boolean mXATransactionsUsed;
    private boolean mUnicode;
    private int mUsedCount;
    private int mOpenCount;
    private int mWaitingThreadsCount;
    private int mAutomaticConnectionReleaseIntervalMillis;
    private int mConnectionReleaseCheckIntervalMillis;
    private int mConnectionRetrial;
    private String mDatabaseVendor;
    private String mMonitorPath;
    private Stack mIdleConnections;
    private StringBuffer mStatusInfoBuffer;
    private static final String NEWLINE = System.getProperty("line.separator", "\n");
    private Thread mMonitorThread;
    private Thread mListMonitorThread;
    private static IUMTrace mTrace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/DataBaseConnectionPool.java#4 $ from $DateTime: 2004/09/10 10:01:00 $ ($Change: 17287 $)");

    public DataBaseConnectionPool(String name, int minSize, int maxSize, int maxIdleConnections, int maxIdleTimeMillis, int maxWaitTimeMillis, Hashtable connectionParameters, int monitorInterval, int connectionRetrial, int automaticConnectionReleaseIntervallMillis, int connectionReleaseCheckIntervalMillis, String monitorPath, boolean XATransactionsUsed, boolean isUnicode, boolean isOracleNativeDriverUsed) throws InitializationException {
        StringBuffer sb;
        if (mTrace.bePath()) {
            mTrace.entering("constructor", new Object[]{name, new Integer(minSize), new Integer(maxSize), new Integer(maxIdleConnections), new Integer(maxIdleTimeMillis), new Integer(maxWaitTimeMillis), connectionParameters, new Integer(monitorInterval), new Integer(connectionRetrial), new Integer(automaticConnectionReleaseIntervallMillis), new Integer(connectionReleaseCheckIntervalMillis), monitorPath, new Boolean(XATransactionsUsed), new Boolean(isUnicode), new Boolean(isOracleNativeDriverUsed)});
        }
        this.mOriginalTransactionIsolation = -1;
        this.mMerantChecked = false;
        this.mIsMerantDriver = false;
        this.mOracleNativeDriverUsed = isOracleNativeDriverUsed;
        this.mXATransactionsUsed = XATransactionsUsed;
        this.mUnicode = isUnicode;
        this.mConnectionRetrial = connectionRetrial;
        this.mAutomaticConnectionReleaseIntervalMillis = automaticConnectionReleaseIntervallMillis;
        this.mConnectionReleaseCheckIntervalMillis = connectionReleaseCheckIntervalMillis;
        if (name == null) {
            String errorMessage = "Connection pool name must not be null!";
            mTrace.errorT("constructor", errorMessage);
            throw new InitializationException(errorMessage);
        }
        if (this.distributedConnections == null) {
            this.distributedConnections = new Hashtable();
        }
        this.mMonitorPath = monitorPath;
        this.mName = name.replace(' ', '_');
        this.mMinSize = minSize > 0 ? minSize : 1;
        this.mMaxSize = maxSize > 0 ? maxSize : 10;
        this.mMaxIdleConnections = maxIdleConnections > 0 ? maxIdleConnections : 5;
        this.mMaxIdleTimeMillis = maxIdleTimeMillis > 0 ? maxIdleTimeMillis : 600000;
        this.mMaxWaitTimeMillis = maxWaitTimeMillis > 0 ? maxWaitTimeMillis : 30000;
        this.mConnectionParameters = connectionParameters;
        try {
            Driver driver = (Driver)Class.forName((String)this.mConnectionParameters.get(DB_DRIVER)).newInstance();
            DriverManager.registerDriver(driver);
        }
        catch (Exception e) {
            throw new InitializationException(e);
        }
        this.mUsedCount = 0;
        this.mOpenCount = 0;
        this.mWaitingThreadsCount = 0;
        this.mStatusInfoBuffer = new StringBuffer(20);
        this.mIdleConnections = new Stack();
        int i = 0;
        while (i < this.mMinSize) {
            Connection context = this.newConnection();
            if (context == null) {
                String errorMessage = this.mName + ": Initialization of connection pool failed.";
                mTrace.errorT("constructor", errorMessage);
                throw new InitializationException(errorMessage);
            }
            this.mIdleConnections.push(new ConnectionWrapper(context));
            ++i;
        }
        if (monitorInterval > 0) {
            ConnectionListMonitor listMon;
            block17: {
                Monitor monitor;
                block16: {
                    if (monitorInterval < 1000) {
                        sb = new StringBuffer(200);
                        sb.append(this.mName).append(": using minimum connection pool monitor interval ");
                        sb.append(1000).append("ms");
                        if (mTrace.beInfo()) {
                            mTrace.infoT("constructor", sb.toString() + " *** init ***");
                        }
                        monitorInterval = 1000;
                    }
                    sb = new StringBuffer(100);
                    sb.append(this.mMonitorPath);
                    sb.append("cpmon_").append(this.mName).append(".log");
                    monitor = null;
                    try {
                        monitor = new Monitor(this, monitorInterval, sb.toString());
                    }
                    catch (IllegalArgumentException ex) {
                        sb.setLength(0);
                        sb.append(this.mName).append(" : connection pool monitoring failed: ");
                        sb.append(ex);
                        if (!mTrace.beError()) break block16;
                        mTrace.errorT("constructor", sb.toString(), ex);
                    }
                }
                this.mMonitorThread = new Thread((Runnable)monitor, "CP Monitor " + this.mName);
                this.mMonitorThread.setPriority(1);
                this.mMonitorThread.start();
                listMon = null;
                try {
                    listMon = new ConnectionListMonitor(this.distributedConnections, connectionReleaseCheckIntervalMillis);
                }
                catch (IllegalArgumentException ex) {
                    sb.setLength(0);
                    sb.append(this.mName).append(" : connection list monitoring failed: ");
                    sb.append(ex);
                    if (!mTrace.beInfo()) break block17;
                    mTrace.infoT("constructor", sb.toString() + " *** init ***");
                }
            }
            this.mListMonitorThread = new Thread((Runnable)listMon, "CL Monitor " + this.mName);
            this.mListMonitorThread.setPriority(1);
            this.mListMonitorThread.start();
        }
        sb = new StringBuffer(200);
        sb.append("Connection pool ").append(this.mName).append(" successfuly initialized.").append(NEWLINE);
        sb.append("    Connection: ").append(this.getConnectionString()).append(NEWLINE);
        sb.append("    min pool size=").append(this.mMinSize).append(NEWLINE);
        sb.append("    max pool size=").append(this.mMaxSize).append(NEWLINE);
        sb.append("    max idle connections=").append(this.mMaxIdleConnections).append(NEWLINE);
        sb.append("    max idle time=").append(this.mMaxIdleTimeMillis).append("ms").append(NEWLINE);
        sb.append("    waiting timeout=").append(this.mMaxWaitTimeMillis).append("ms").append(NEWLINE);
        sb.append("    connection retrial=").append(connectionRetrial).append("ms").append(NEWLINE);
        sb.append("    release given connections after=").append(automaticConnectionReleaseIntervallMillis).append("ms").append(NEWLINE);
        sb.append("    check given connections interval=").append(connectionReleaseCheckIntervalMillis).append("ms").append(NEWLINE);
        sb.append("    monitoring=");
        sb.append(monitorInterval <= 0 ? "off" : monitorInterval + "ms").append(NEWLINE);
        if (mTrace.beInfo()) {
            mTrace.infoT("constructor", sb.toString() + " *** init ***");
        }
        if (mTrace.bePath()) {
            mTrace.exiting("constructor");
        }
    }

    public DataBaseConnectionPool(String name, int minSize, int maxSize, int maxIdleConnections, int maxIdleTimeMillis, int maxWaitTimeMillis, Hashtable connectionParameters, int connectionRetrial, int automaticConnectionReleaseIntervallMillis, int connectionReleaseCheckIntervalMillis, boolean XATransactionsUsed, boolean isUnicode, boolean isOracleNativeDriverUsed) throws InitializationException {
        this(name, minSize, maxSize, maxIdleConnections, maxIdleTimeMillis, maxWaitTimeMillis, connectionParameters, -1, connectionRetrial, automaticConnectionReleaseIntervallMillis, connectionReleaseCheckIntervalMillis, "", XATransactionsUsed, isUnicode, isOracleNativeDriverUsed);
    }

    public DataBaseConnectionPool(String name, Hashtable connectionParameters, int connectionRetrial, int automaticConnectionReleaseIntervalMillis, int connectionReleaseCheckIntervalMillis, boolean XATransactionsUsed, boolean isUnicode, boolean isOracleNativeDriverUsed) throws InitializationException {
        this(name, 1, 10, 5, 600000, 30000, connectionParameters, connectionRetrial, automaticConnectionReleaseIntervalMillis, connectionReleaseCheckIntervalMillis, XATransactionsUsed, isUnicode, isOracleNativeDriverUsed);
    }

    public Connection getConnection(String description, int transactionIsolation) throws ConnectionTimeoutException {
        Connection con;
        block4: {
            con = this.getConnection(description);
            if (transactionIsolation == -1) {
                return con;
            }
            try {
                int transIsolation = con.getTransactionIsolation();
                if (transactionIsolation != transIsolation) {
                    this.mOriginalTransactionIsolation = transIsolation;
                    con.setTransactionIsolation(transactionIsolation);
                }
            }
            catch (SQLException sqlex) {
                if (!mTrace.beInfo()) break block4;
                mTrace.infoT("getConnection", "Cannot change transaction isolation level.", sqlex);
            }
        }
        return con;
    }

    public synchronized Connection getConnection(String description) throws ConnectionTimeoutException {
        if (mTrace.bePath()) {
            mTrace.exiting("getConnection", new Object[]{description});
        }
        Connection context = null;
        while (context == null) {
            long startWaitingTs;
            block11: {
                context = this.getIdleConnection();
                if (context != null) {
                    ++this.mUsedCount;
                    this.distributedConnections.put(context, new ConnectionPostIt(description, this.mAutomaticConnectionReleaseIntervalMillis));
                    if (mTrace.bePath()) {
                        mTrace.exiting("getConnection", context);
                    }
                    return context;
                }
                if (this.mOpenCount < this.mMaxSize) {
                    context = this.newConnection();
                    ++this.mUsedCount;
                    this.distributedConnections.put(context, new ConnectionPostIt(description, this.mAutomaticConnectionReleaseIntervalMillis));
                    if (mTrace.bePath()) {
                        mTrace.exiting("getConnection", context);
                    }
                    return context;
                }
                ++this.mWaitingThreadsCount;
                if (mTrace.beInfo()) {
                    mTrace.infoT("getConnection", this.mName + ": Waiting for connection ...");
                }
                startWaitingTs = System.currentTimeMillis();
                try {
                    this.wait(this.mMaxWaitTimeMillis);
                }
                catch (InterruptedException ex) {
                    if (!mTrace.beInfo()) break block11;
                    mTrace.infoT("getConnection", this.mName + ": ... interrupted", ex);
                }
            }
            --this.mWaitingThreadsCount;
            if (System.currentTimeMillis() - startWaitingTs > (long)this.mMaxWaitTimeMillis) {
                if (!mTrace.beError()) break;
                mTrace.errorT("getConnection", this.mName + ": Maximum wait time of " + this.mMaxWaitTimeMillis + "ms elapsed.");
                break;
            }
            if (!mTrace.beInfo()) continue;
            mTrace.infoT("getConnection", this.mName + ": ... notified");
        }
        String errorMessage = "Maximum wait time exceeded: " + this.mMaxWaitTimeMillis;
        if (mTrace.beError()) {
            mTrace.errorT("getConnection", errorMessage);
        }
        throw new ConnectionTimeoutException(errorMessage);
    }

    public synchronized void releaseConnection(Connection context, boolean destroy) {
        StringBuffer sb;
        block26: {
            if (mTrace.bePath()) {
                mTrace.entering("releaseConnection", new Object[]{context, new Boolean(destroy)});
            }
            if (!this.isXATransactionsUsed()) {
                try {
                    block25: {
                        if (this.mOriginalTransactionIsolation != -1) {
                            try {
                                if (context.getTransactionIsolation() != this.mOriginalTransactionIsolation) {
                                    context.setTransactionIsolation(this.mOriginalTransactionIsolation);
                                }
                            }
                            catch (SQLException e) {
                                if (!mTrace.beInfo()) break block25;
                                mTrace.infoT("releaseConnection", "Cannot change transaction isolation level.", e);
                            }
                        }
                    }
                    if (!context.getAutoCommit()) {
                        context.rollback();
                    }
                }
                catch (SQLException sqlex) {
                    if (!mTrace.beWarning()) break block26;
                    mTrace.warningT("releaseConnection", this.mName + ": Cannot rollback connection", sqlex);
                }
            }
        }
        if (!this.distributedConnections.containsKey(context)) {
            block27: {
                try {
                    context.close();
                    this.notify();
                }
                catch (SQLException sqlex) {
                    if (!mTrace.beError()) break block27;
                    mTrace.errorT("releaseConnection", this.mName + ": Cannot destroy timed out connection", sqlex);
                }
            }
            if (mTrace.bePath()) {
                mTrace.exiting("releaseConnection");
            }
            return;
        }
        --this.mUsedCount;
        if (mTrace.beInfo()) {
            mTrace.infoT("releaseConnection", ((ConnectionPostIt)this.distributedConnections.get(context)).getDescription());
        }
        this.distributedConnections.remove(context);
        if (this.mWaitingThreadsCount > 0 || this.mIdleConnections.size() < this.mMaxIdleConnections || this.mUsedCount < this.mMinSize) {
            if (destroy) {
                block28: {
                    try {
                        context.close();
                        if (mTrace.beInfo()) {
                            sb = new StringBuffer(100);
                            sb.append(this.mName);
                            sb.append(context).append(" destroyed (recommended by caller)");
                            mTrace.infoT("releaseConnection", sb.toString());
                        }
                    }
                    catch (SQLException sqlex) {
                        if (!mTrace.beError()) break block28;
                        mTrace.errorT("releaseConnection", this.mName + ": Catched exception while closing connection", sqlex);
                    }
                }
                --this.mOpenCount;
                context = this.newConnection();
            }
            this.mIdleConnections.push(new ConnectionWrapper(context));
            if (mTrace.beInfo()) {
                sb = new StringBuffer(100);
                sb.append(this.mName);
                sb.append(context).append(" pushed back on stack");
                mTrace.infoT("releaseConnection", sb.toString());
            }
            this.notify();
        } else {
            block29: {
                try {
                    context.close();
                    if (mTrace.beInfo()) {
                        sb = new StringBuffer(100);
                        sb.append(this.mName);
                        sb.append(context).append(" closed");
                        mTrace.infoT("releaseConnection", sb.toString());
                    }
                }
                catch (SQLException sqlex) {
                    if (!mTrace.beError()) break block29;
                    mTrace.errorT("releaseConnection", this.mName + ": Catched exception while closing connection", sqlex);
                }
            }
            --this.mOpenCount;
        }
        if (mTrace.bePath()) {
            mTrace.exiting("releaseConnection");
        }
    }

    public boolean isUnicode() {
        return this.mUnicode;
    }

    public boolean isXATransactionsUsed() {
        return this.mXATransactionsUsed;
    }

    public boolean isJTASupportEnabled() {
        return false;
    }

    public boolean isOracleNativeDriverUsed() {
        return this.mOracleNativeDriverUsed;
    }

    public synchronized void releaseConnection(Connection context) {
        this.releaseConnection(context, false);
    }

    public synchronized String getStatus() {
        if (mTrace.bePath()) {
            mTrace.entering("getStatus");
        }
        this.mStatusInfoBuffer.setLength(0);
        this.mStatusInfoBuffer.append(this.mOpenCount).append('\t');
        this.mStatusInfoBuffer.append(this.mUsedCount).append('\t');
        this.mStatusInfoBuffer.append(this.mIdleConnections.size()).append('\t');
        this.mStatusInfoBuffer.append(this.mWaitingThreadsCount);
        if (mTrace.bePath()) {
            mTrace.exiting("getStatus", this.mStatusInfoBuffer.toString());
        }
        return this.mStatusInfoBuffer.toString();
    }

    public String getDatabaseVendor() {
        block11: {
            if (this.mDatabaseVendor == null) {
                try {
                    Connection dbCon = this.getConnection("getDatabaseVendor");
                    try {
                        block10: {
                            try {
                                DatabaseMetaData dbMetaData = dbCon.getMetaData();
                                String dbVendor = dbMetaData.getDatabaseProductName();
                                if (dbVendor == null) {
                                    this.mDatabaseVendor = "Not available";
                                    break block10;
                                }
                                this.mDatabaseVendor = dbVendor;
                            }
                            catch (SQLException sqlex) {
                                if (mTrace.beError()) {
                                    String errorMessage = "SQLException: " + sqlex.getMessage();
                                    mTrace.errorT("getDatabaseVendor", errorMessage, sqlex);
                                }
                                this.mDatabaseVendor = "Not accessible";
                                Object var5_9 = null;
                                this.releaseConnection(dbCon);
                                break block11;
                            }
                        }
                        Object var5_8 = null;
                        this.releaseConnection(dbCon);
                    }
                    catch (Throwable throwable) {
                        Object var5_10 = null;
                        this.releaseConnection(dbCon);
                        throw throwable;
                    }
                }
                catch (ConnectionTimeoutException ctoutex) {
                    if (mTrace.beError()) {
                        String errorMessage = "ConnectionTimeoutException: " + ctoutex.getMessage();
                        mTrace.errorT("getDatabaseVendor", errorMessage, (Throwable)((Object)ctoutex));
                    }
                    this.mDatabaseVendor = "Not accessible";
                }
            }
        }
        return this.mDatabaseVendor;
    }

    private Connection newConnection() {
        Connection context;
        block13: {
            if (mTrace.bePath()) {
                mTrace.entering("newConnection");
            }
            context = null;
            try {
                int z = 0;
                while (z < this.mConnectionRetrial + 1) {
                    try {
                        context = this.mConnectionParameters.get(DB_USER) == null ? DriverManager.getConnection((String)this.mConnectionParameters.get(DB_URL)) : DriverManager.getConnection((String)this.mConnectionParameters.get(DB_URL), (String)this.mConnectionParameters.get(DB_USER), (String)this.mConnectionParameters.get(DB_PASSWORD));
                        if (!this.mMerantChecked || this.mIsMerantDriver) {
                            this.mMerantChecked = true;
                        }
                        if (!context.getAutoCommit()) break;
                        context.setAutoCommit(false);
                        break;
                    }
                    catch (Exception e) {
                        mTrace.errorT("newConnection", this.mName + ",could not connect to database server, try again", e);
                        if (z == this.mConnectionRetrial) {
                            throw e;
                        }
                        ++z;
                    }
                }
                DataBaseConnectionPool e = this;
                synchronized (e) {
                    ++this.mOpenCount;
                }
                if (mTrace.beInfo()) {
                    StringBuffer sb = new StringBuffer(100);
                    sb.append(this.mName).append(": New connection to database server successful (");
                    sb.append(this.getConnectionString()).append(")");
                    mTrace.infoT("newConnection", sb.toString());
                }
            }
            catch (Exception ex) {
                if (!mTrace.beError()) break block13;
                StringBuffer sb = new StringBuffer(100);
                sb.append(this.mName).append(": Connection to DataBase server failed (");
                sb.append(this.getConnectionString()).append("): ");
                sb.append(ex.toString());
                mTrace.errorT("newConnection", sb.toString(), ex);
            }
        }
        if (mTrace.bePath()) {
            mTrace.exiting("newConnection", context);
        }
        return context;
    }

    private Connection getIdleConnection() {
        if (mTrace.bePath()) {
            mTrace.entering("getIdleConnection");
        }
        ConnectionWrapper connectionWrapper = null;
        Stack stack = this.mIdleConnections;
        synchronized (stack) {
            if (!this.mIdleConnections.isEmpty()) {
                connectionWrapper = (ConnectionWrapper)this.mIdleConnections.pop();
            }
        }
        if (connectionWrapper == null) {
            return null;
        }
        if (System.currentTimeMillis() - connectionWrapper.getLastAccess() > (long)this.mMaxIdleTimeMillis) {
            block17: {
                try {
                    if (!this.mXATransactionsUsed) {
                        connectionWrapper.getConnection().close();
                    }
                    DataBaseConnectionPool dataBaseConnectionPool = this;
                    synchronized (dataBaseConnectionPool) {
                        --this.mOpenCount;
                    }
                }
                catch (SQLException sqlex) {
                    if (!mTrace.beError()) break block17;
                    mTrace.errorT("getIdleConnection", this.mName + ": Catched exception while closing connection: " + sqlex, sqlex);
                }
            }
            Connection context = this.newConnection();
            if (mTrace.beInfo()) {
                StringBuffer sb = new StringBuffer(100);
                sb.append(this.mName + ": Maxmimum idle time ");
                sb.append(this.mMaxIdleTimeMillis).append(" exceeded, returning new connection");
                mTrace.infoT("getIdleConnection", sb.toString());
            }
            if (mTrace.bePath()) {
                mTrace.exiting("getIdleConnection", context);
            }
            return context;
        }
        if (mTrace.beInfo()) {
            StringBuffer sb = new StringBuffer(100);
            sb.append(this.mName + ": Got idle connection ");
            sb.append(connectionWrapper.getConnection()).append(" from stack");
            mTrace.infoT("getIdleConnection", sb.toString());
        }
        if (mTrace.bePath()) {
            mTrace.exiting("getIdleConnection", connectionWrapper.getConnection());
        }
        return connectionWrapper.getConnection();
    }

    private String getConnectionString() {
        if (mTrace.bePath()) {
            mTrace.entering("getConnectionString");
        }
        if (this.mConnectionParameters != null) {
            StringBuffer sb = new StringBuffer(200);
            sb.append("Url=").append(this.mConnectionParameters.get(DB_URL));
            sb.append(", user=");
            sb.append(this.mConnectionParameters.get(DB_USER));
            if (mTrace.bePath()) {
                mTrace.exiting("getConnectionString", sb.toString());
            }
            return sb.toString();
        }
        if (mTrace.bePath()) {
            mTrace.exiting("getConnectionString", null);
        }
        return null;
    }

    private static class Monitor
    implements Runnable {
        private DataBaseConnectionPool mPool = null;
        private int mStatusInterval = 1000;
        private PrintWriter mOut = null;
        private DateFormat mDateFormat = null;
        private static final String DEF_DATEFORMATSTRING = "dd.MM.yyyy HH:mm:ss.SSS";

        public Monitor(DataBaseConnectionPool pool, int statusInterval, String fileName) {
            if (pool == null) {
                if (mTrace.beError()) {
                    mTrace.errorT("Monitor", "Pool is null!");
                }
                throw new IllegalArgumentException("Pool is null!");
            }
            this.mPool = pool;
            if (statusInterval > 0) {
                this.mStatusInterval = statusInterval;
            }
            try {
                this.mOut = new PrintWriter(new FileOutputStream(fileName));
            }
            catch (Exception ex) {
                String errorMessage = "Failed to open monitor logfile " + fileName + ": ";
                if (mTrace.beError()) {
                    mTrace.errorT("Monitor", errorMessage, ex);
                }
                throw new IllegalArgumentException(errorMessage + ex);
            }
            this.mDateFormat = new SimpleDateFormat(DEF_DATEFORMATSTRING);
        }

        public void run() {
            this.mOut.println("Jndi connection pool status for pool ");
            this.mOut.println("time / open connections / used connections / idle connections / waiting threads");
            this.mOut.println();
            this.mOut.flush();
            try {
                try {
                    while (!Thread.interrupted()) {
                        this.mOut.println(this.mDateFormat.format(new Date()) + ":\t" + this.mPool.getStatus());
                        this.mOut.flush();
                        Thread.sleep(this.mStatusInterval);
                    }
                }
                catch (InterruptedException ex) {
                    if (mTrace.beDebug()) {
                        mTrace.debugT("run", ex);
                    }
                    Object var3_2 = null;
                    this.mOut.flush();
                }
                Object var3_1 = null;
                this.mOut.flush();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.mOut.flush();
                throw throwable;
            }
        }
    }

    private class ConnectionListMonitor
    implements Runnable {
        private Hashtable mList = null;
        private int mInterval = 10000;

        public ConnectionListMonitor(Hashtable list, int interval) {
            if (list == null) {
                throw new IllegalArgumentException("List is null.");
            }
            this.mList = list;
            if (interval > 0) {
                this.mInterval = interval;
            }
        }

        public void run() {
            block6: {
                try {
                    while (!Thread.interrupted()) {
                        Iterator iterator;
                        Set keys = this.mList.keySet();
                        if (keys != null && (iterator = keys.iterator()) != null) {
                            while (iterator.hasNext()) {
                                Connection tempContext = (Connection)iterator.next();
                                if (!((ConnectionPostIt)this.mList.get(tempContext)).hasExpired()) continue;
                                if (mTrace.beInfo()) {
                                    mTrace.infoT("ConnectionListMonitor", "Connection timed out: " + ((ConnectionPostIt)this.mList.get(tempContext)).getDescription());
                                }
                                this.mList.remove(tempContext);
                                DataBaseConnectionPool.this.mOpenCount--;
                                DataBaseConnectionPool.this.mUsedCount--;
                            }
                        }
                        Thread.sleep(this.mInterval);
                    }
                }
                catch (InterruptedException ex) {
                    if (!mTrace.beDebug()) break block6;
                    mTrace.debugT("run", ex);
                }
            }
        }
    }

    public class ConnectionPostIt {
        private String mDescription;
        private long mExpirationTimeMillis;

        public ConnectionPostIt(String description, long timeToExpirationMillis) {
            this.mDescription = description == null ? "No description available" : description;
            this.mExpirationTimeMillis = System.currentTimeMillis() + timeToExpirationMillis;
        }

        public String getDescription() {
            return this.mDescription;
        }

        public long getExpirationTimeMillis() {
            return this.mExpirationTimeMillis;
        }

        public boolean hasExpired() {
            return System.currentTimeMillis() >= this.mExpirationTimeMillis;
        }
    }

    private static class ConnectionWrapper {
        private Connection mContext = null;
        private long mLastAccess = 0L;

        public ConnectionWrapper(Connection context) {
            this.mContext = context;
            this.mLastAccess = System.currentTimeMillis();
        }

        public long getLastAccess() {
            return this.mLastAccess;
        }

        public Connection getConnection() {
            return this.mContext;
        }
    }
}

