/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp;

import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.imp.XHTMLEncoder;
import java.io.Serializable;
import javax.swing.tree.DefaultMutableTreeNode;

public class DSPrivatePropertyModel
implements Serializable {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/DSPrivatePropertyModel.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";
    private String mName;
    private String mValue;
    private static transient IUMTrace mTrace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/DSPrivatePropertyModel.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)");

    public DSPrivatePropertyModel(String name, String value) throws PersistenceException {
        if (name == null || value == null) {
            String errorMessage = "Name and value of private property must not be null!";
            throw new PersistenceException(errorMessage);
        }
        this.mName = name;
        this.mValue = value;
    }

    public String toString() {
        return this.getName();
    }

    public DefaultMutableTreeNode toTreeNode() {
        DefaultMutableTreeNode thisNode = new DefaultMutableTreeNode(this);
        thisNode.add(new DefaultMutableTreeNode(this.mValue));
        return thisNode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DSPrivatePropertyModel)) {
            return false;
        }
        DSPrivatePropertyModel model = (DSPrivatePropertyModel)o;
        return this.mName.equals(model.getName());
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public void setName(String name) throws PersistenceException {
        if (name == null) {
            String errorMessage = "Name of private property must not be null!";
            throw new PersistenceException(errorMessage);
        }
        this.mName = name;
    }

    public void setValue(String value) throws PersistenceException {
        if (value == null) {
            String errorMessage = "Value of private property must not be null!";
            throw new PersistenceException(errorMessage);
        }
        this.mValue = value;
    }

    public String getName() {
        return this.mName;
    }

    public String getValue() {
        return this.mValue;
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < level) {
            result.append("\t");
            ++i;
        }
        result.append("<");
        result.append(this.mName);
        result.append(">");
        result.append(XHTMLEncoder.encode(this.mValue));
        result.append("</");
        result.append(this.mName);
        result.append(">\n");
        return result.toString();
    }
}

