/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp;

import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.datasource.imp.DSAttributeModel;
import com.sap.security.core.persistence.datasource.imp.DSNameSpaceModel;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.imp.XHTMLEncoder;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class DSPrincipalModel {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/DSPrincipalModel.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";
    private String mType;
    private Hashtable mNameSpaces;
    private int mPriority;
    private static transient IUMTrace mTrace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/DSPrincipalModel.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)");

    public DSPrincipalModel() {
    }

    public DSPrincipalModel(String type) throws PersistenceException {
        if (type == null) {
            String errorMessage = "Type of principal must not be null!";
            throw new PersistenceException(errorMessage);
        }
        this.mType = type;
        this.mPriority = 0;
        this.mNameSpaces = new Hashtable();
    }

    public void setPriority(int priority) {
        if (priority > -1 && priority < 10) {
            this.mPriority = priority;
        }
    }

    public int getPriority() {
        return this.mPriority;
    }

    public String toString() {
        return this.getType();
    }

    public DefaultMutableTreeNode toTreeNode() {
        DefaultMutableTreeNode thisNode = new DefaultMutableTreeNode(this);
        if (!this.mNameSpaces.isEmpty()) {
            Collection c = this.mNameSpaces.values();
            Iterator it = c.iterator();
            while (it.hasNext()) {
                thisNode.add(((DSNameSpaceModel)it.next()).toTreeNode());
            }
        }
        return thisNode;
    }

    public boolean isHomeFor(String nameSpace, String attribute, Object value) {
        if (this.mNameSpaces.isEmpty()) {
            return true;
        }
        DSNameSpaceModel dummy = (DSNameSpaceModel)this.mNameSpaces.get(nameSpace);
        if (dummy != null) {
            return dummy.isHomeFor(attribute, value);
        }
        return false;
    }

    public boolean timeLimitedAttributesPresent() {
        if (this.mNameSpaces.isEmpty()) {
            return false;
        }
        boolean timeLimitedAttributesPresent = false;
        Enumeration en = this.mNameSpaces.keys();
        while (en.hasMoreElements() && !timeLimitedAttributesPresent) {
            DSNameSpaceModel nModel = (DSNameSpaceModel)this.mNameSpaces.get(en.nextElement());
            boolean bl = timeLimitedAttributesPresent = nModel.timeLimitedAttributesPresent() || timeLimitedAttributesPresent;
        }
        return timeLimitedAttributesPresent;
    }

    public int getAttributeCacheTime(String nameSpace, String attribute) {
        int cacheTime = -1;
        DSNameSpaceModel dummy = (DSNameSpaceModel)this.mNameSpaces.get(nameSpace);
        if (dummy != null) {
            return dummy.getAttributeCacheTime(attribute);
        }
        return cacheTime;
    }

    public boolean isAttributeModifiable(String nameSpace, String attribute) {
        if (this.mNameSpaces.isEmpty()) {
            return true;
        }
        DSNameSpaceModel dummy = (DSNameSpaceModel)this.mNameSpaces.get(nameSpace);
        if (dummy != null) {
            return dummy.isAttributeModifiable(attribute);
        }
        return false;
    }

    public boolean feelsResponsible(String nameSpace, String attribute) {
        if (this.mNameSpaces.isEmpty()) {
            return true;
        }
        DSNameSpaceModel dummy = (DSNameSpaceModel)this.mNameSpaces.get(nameSpace);
        if (dummy != null) {
            return dummy.feelsResponsible(attribute);
        }
        return false;
    }

    public String getPhysicalAttribute(String nameSpace, String logicalAttributeName) {
        if (this.mNameSpaces.isEmpty()) {
            return logicalAttributeName;
        }
        DSNameSpaceModel dummy = (DSNameSpaceModel)this.mNameSpaces.get(nameSpace);
        if (dummy != null) {
            return dummy.getPhysicalAttribute(logicalAttributeName);
        }
        return logicalAttributeName;
    }

    public Vector getResponsibleNameSpaces() {
        if (this.mNameSpaces.isEmpty()) {
            return null;
        }
        Collection c = this.mNameSpaces.values();
        return new Vector(c);
    }

    public Hashtable getPopulateInitially() {
        Hashtable result = new Hashtable();
        if (this.mNameSpaces.isEmpty()) {
            return result;
        }
        Collection c = this.mNameSpaces.values();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            DSNameSpaceModel dummy = (DSNameSpaceModel)it.next();
            Hashtable attribs = dummy.getAttributes();
            Collection c2 = attribs.values();
            Vector<String> smallResult = new Vector<String>();
            Iterator it2 = c2.iterator();
            while (it2.hasNext()) {
                DSAttributeModel dummy2 = null;
                dummy2 = (DSAttributeModel)it2.next();
                if (!dummy2.getPopulateInitially()) continue;
                smallResult.add(dummy2.getName());
            }
            result.put(dummy.getName(), smallResult);
        }
        return result;
    }

    public Hashtable getResponsibleNameSpaceAttributes() {
        Hashtable result = new Hashtable();
        if (this.mNameSpaces.isEmpty()) {
            return result;
        }
        Collection c = this.mNameSpaces.values();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            DSNameSpaceModel dummy = (DSNameSpaceModel)it.next();
            Hashtable attribs = dummy.getAttributes();
            result.put(dummy.getName(), new Vector(attribs.keySet()));
        }
        return result;
    }

    public String getLogicalAttribute(String nameSpace, String physicalAttributeName) {
        if (this.mNameSpaces.isEmpty()) {
            return physicalAttributeName;
        }
        DSNameSpaceModel dummy = (DSNameSpaceModel)this.mNameSpaces.get(nameSpace);
        if (dummy != null) {
            return dummy.getLogicalAttribute(physicalAttributeName);
        }
        return physicalAttributeName;
    }

    public String getType() {
        return this.mType;
    }

    public String getTypeForXML() {
        if (this.mType.equals("USER")) {
            return "user";
        }
        if (this.mType.equals("GRUP")) {
            return "group";
        }
        if (this.mType.equals("ROLE")) {
            return "role";
        }
        if (this.mType.equals("TEAM")) {
            return "team";
        }
        if (this.mType.equals("UACC")) {
            return "team";
        }
        if (this.mType.equals("COMP")) {
            return "team";
        }
        return this.mType;
    }

    public void setNameSpace(DSNameSpaceModel nameSpace) {
        this.mNameSpaces.put(nameSpace.getName(), nameSpace);
    }

    public DSNameSpaceModel getNameSpace(String nameSpace) {
        return (DSNameSpaceModel)this.mNameSpaces.get(nameSpace);
    }

    public Hashtable getNameSpaces() {
        return this.mNameSpaces;
    }

    public void deleteNameSpace(DSNameSpaceModel nameSpace) {
        this.mNameSpaces.remove(nameSpace.getName());
    }

    public void setType(String type) throws PersistenceException {
        if (type == null) {
            String errorMessage = "Type of principal must not be null!";
            throw new PersistenceException(errorMessage);
        }
        this.mType = type;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DSPrincipalModel)) {
            return false;
        }
        DSPrincipalModel model = (DSPrincipalModel)o;
        return this.mType.equals(model.getType());
    }

    public int hashCode() {
        return this.mType.hashCode();
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < level) {
            result.append("\t");
            ++i;
        }
        result.append("<");
        result.append("principal");
        result.append(" ");
        result.append("type");
        result.append("=\"");
        if (this.mType.equals("USER")) {
            result.append("user");
        } else if (this.mType.equals("GRUP")) {
            result.append("group");
        } else if (this.mType.equals("ROLE")) {
            result.append("role");
        } else if (this.mType.equals("TEAM")) {
            result.append("team");
        } else if (this.mType.equals("UACC")) {
            result.append("account");
        } else if (this.mType.equals("COMP")) {
            result.append("company");
        } else {
            result.append(XHTMLEncoder.encode(this.mType));
        }
        result.append("\"");
        if (!this.mNameSpaces.isEmpty()) {
            result.append(">\n");
            int i2 = 0;
            while (i2 < level + 1) {
                result.append("\t");
                ++i2;
            }
            result.append("<");
            result.append("nameSpaces");
            result.append(">\n");
            Collection c = this.mNameSpaces.values();
            Iterator it = c.iterator();
            while (it.hasNext()) {
                result.append(((DSNameSpaceModel)it.next()).toXML(level + 2));
            }
            int i3 = 0;
            while (i3 < level + 1) {
                result.append("\t");
                ++i3;
            }
            result.append("</");
            result.append("nameSpaces");
            result.append(">\n");
            int i4 = 0;
            while (i4 < level) {
                result.append("\t");
                ++i4;
            }
            result.append("</");
            result.append("principal");
            result.append(">\n");
        } else {
            result.append(" />\n");
        }
        return result.toString();
    }
}

