/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp;

import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.datasource.imp.DSAttributeModel;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.imp.XHTMLEncoder;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.tree.DefaultMutableTreeNode;

public class DSNameSpaceModel
implements Serializable {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/DSNameSpaceModel.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";
    private String mName;
    private Hashtable mAttributes;
    private static transient IUMTrace mTrace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/DSNameSpaceModel.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)");

    public DSNameSpaceModel() {
    }

    public DSNameSpaceModel(String name) throws PersistenceException {
        if (name == null) {
            String errorMessage = "Name of namespace must not be null!";
            throw new PersistenceException(errorMessage);
        }
        this.mName = name;
        this.mAttributes = new Hashtable();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("\"");
        result.append(this.getName());
        result.append("\"");
        return result.toString();
    }

    public DefaultMutableTreeNode toTreeNode() {
        DefaultMutableTreeNode thisNode = new DefaultMutableTreeNode(this);
        if (!this.mAttributes.isEmpty()) {
            Collection c = this.mAttributes.values();
            Iterator it = c.iterator();
            while (it.hasNext()) {
                thisNode.add(((DSAttributeModel)it.next()).toTreeNode());
            }
        }
        return thisNode;
    }

    public boolean isHomeFor(String attribute, Object value) {
        if (this.mAttributes.isEmpty()) {
            return true;
        }
        DSAttributeModel dummy = (DSAttributeModel)this.mAttributes.get(attribute);
        if (dummy != null) {
            return dummy.getValues().contains(value);
        }
        return false;
    }

    public boolean feelsResponsible(String attribute) {
        if (this.mAttributes.isEmpty()) {
            return true;
        }
        DSAttributeModel dummy = (DSAttributeModel)this.mAttributes.get(attribute);
        return dummy != null;
    }

    public int getAttributeCacheTime(String attribute) {
        if (this.mAttributes.isEmpty()) {
            return -1;
        }
        DSAttributeModel dummy = (DSAttributeModel)this.mAttributes.get(attribute);
        int cacheTime = -1;
        if (dummy != null) {
            return dummy.getTimeLimit();
        }
        return cacheTime;
    }

    public boolean isAttributeModifiable(String attribute) {
        if (this.mAttributes.isEmpty()) {
            return true;
        }
        DSAttributeModel dummy = (DSAttributeModel)this.mAttributes.get(attribute);
        boolean modifiable = false;
        if (dummy != null) {
            modifiable = !dummy.getReadonly();
            return modifiable;
        }
        return false;
    }

    public boolean timeLimitedAttributesPresent() {
        if (this.mAttributes.isEmpty()) {
            return false;
        }
        boolean timeLimitedAttributesPresent = false;
        Enumeration en = this.mAttributes.keys();
        while (en.hasMoreElements() && !timeLimitedAttributesPresent) {
            DSAttributeModel aModel = (DSAttributeModel)this.mAttributes.get(en.nextElement());
            boolean bl = timeLimitedAttributesPresent = aModel.isTimeLimited() || timeLimitedAttributesPresent;
        }
        return timeLimitedAttributesPresent;
    }

    public String getPhysicalAttribute(String logicalAttributeName) {
        if (this.mAttributes.isEmpty()) {
            return logicalAttributeName;
        }
        DSAttributeModel dummy = (DSAttributeModel)this.mAttributes.get(logicalAttributeName);
        if (dummy != null) {
            String physicalName = dummy.getPhysicalName();
            if (physicalName != null) {
                return physicalName;
            }
            return logicalAttributeName;
        }
        return logicalAttributeName;
    }

    public String getLogicalAttribute(String physicalAttributeName) {
        if (this.mAttributes.isEmpty()) {
            return physicalAttributeName;
        }
        Collection c = this.mAttributes.values();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            DSAttributeModel dummy = (DSAttributeModel)it.next();
            String physicalName = dummy.getPhysicalName();
            if (physicalName == null || !physicalName.equals(physicalAttributeName)) continue;
            return dummy.getName();
        }
        return physicalAttributeName;
    }

    public void setName(String name) throws PersistenceException {
        if (name == null) {
            String errorMessage = "Name of namespace must not be null!";
            throw new PersistenceException(errorMessage);
        }
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public void setAttribute(DSAttributeModel attribute) {
        this.mAttributes.put(attribute.getName(), attribute);
    }

    public DSAttributeModel getAttribute(String attributeName) {
        return (DSAttributeModel)this.mAttributes.get(attributeName);
    }

    public Hashtable getAttributes() {
        return this.mAttributes;
    }

    public void deleteAttribute(DSAttributeModel attribute) {
        this.mAttributes.remove(attribute.getName());
    }

    public boolean equals(Object o) {
        if (!(o instanceof DSNameSpaceModel)) {
            return false;
        }
        DSNameSpaceModel model = (DSNameSpaceModel)o;
        return this.mName.equals(model.getName());
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < level) {
            result.append("\t");
            ++i;
        }
        result.append("<");
        result.append("nameSpace");
        result.append(" ");
        result.append("name");
        result.append("=\"");
        result.append(XHTMLEncoder.encode(this.mName));
        result.append("\"");
        if (!this.mAttributes.isEmpty()) {
            result.append(">\n");
            int i2 = 0;
            while (i2 < level + 1) {
                result.append("\t");
                ++i2;
            }
            result.append("<");
            result.append("attributes");
            result.append(">\n");
            Collection c = this.mAttributes.values();
            Iterator it = c.iterator();
            while (it.hasNext()) {
                result.append(((DSAttributeModel)it.next()).toXML(level + 2));
            }
            int i3 = 0;
            while (i3 < level + 1) {
                result.append("\t");
                ++i3;
            }
            result.append("</");
            result.append("attributes");
            result.append(">\n");
            int i4 = 0;
            while (i4 < level) {
                result.append("\t");
                ++i4;
            }
            result.append("</");
            result.append("nameSpace");
            result.append(">\n");
        } else {
            result.append(" />\n");
        }
        return result.toString();
    }
}

