/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp;

import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.datasource.imp.DSAttributeModel;
import com.sap.security.core.persistence.datasource.imp.DSNameSpaceModel;
import com.sap.security.core.persistence.datasource.imp.DSPrincipalModel;
import com.sap.security.core.persistence.datasource.imp.DSPrivatePropertyModel;
import com.sap.security.core.persistence.notification.IPersistenceNotificationListener;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.imp.XHTMLEncoder;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class DSConfigurationModel
implements Serializable {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/DSConfigurationModel.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";
    private String mDataSourceID;
    private String mClassName;
    private boolean mIsReadonly;
    private boolean mIsPrimary;
    private String mDisplayName;
    private transient IPersistenceNotificationListener mNotificationListener;
    private Hashtable mHomeFor;
    private Hashtable mResponsibleFor;
    private Hashtable mNotHomeFor;
    private Hashtable mNotResponsibleFor;
    private Hashtable mAttributeMapping;
    private Hashtable mPrivateSection;
    private static transient IUMTrace mTrace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/DSConfigurationModel.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)");

    public DSConfigurationModel() {
    }

    public DSConfigurationModel(String dataSourceID, String className, boolean isReadonly, boolean isPrimary, String displayName) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("constructor", new Object[]{dataSourceID, className, new Boolean(isReadonly), new Boolean(isPrimary)});
        }
        if (dataSourceID == null || className == null) {
            String errorMessage = "ID and className of datasource must not be null!";
            throw new PersistenceException(errorMessage);
        }
        if (!isPrimary && isReadonly) {
            String errorMessage = "Secondary datasource " + dataSourceID + " must not be readonly (only primary can be readonly)!";
            throw new PersistenceException(errorMessage);
        }
        this.mDataSourceID = dataSourceID;
        this.mClassName = className;
        this.mIsReadonly = isReadonly;
        this.mIsPrimary = isPrimary;
        this.mDisplayName = displayName;
        this.mHomeFor = new Hashtable();
        this.mResponsibleFor = new Hashtable();
        this.mNotHomeFor = new Hashtable();
        this.mNotResponsibleFor = new Hashtable();
        this.mAttributeMapping = new Hashtable();
        this.mPrivateSection = new Hashtable();
        if (mTrace.bePath()) {
            mTrace.exiting("constructor");
        }
    }

    public Vector getHomePrincipalTypes() {
        Vector<String> result = new Vector<String>();
        Enumeration en = this.mHomeFor.keys();
        while (en.hasMoreElements()) {
            String type = (String)en.nextElement();
            if (result.contains(type)) continue;
            result.add(type);
        }
        return result;
    }

    public Vector getResponsiblePrincipalTypes() {
        Vector<String> result = new Vector<String>();
        Enumeration en = this.mResponsibleFor.keys();
        while (en.hasMoreElements()) {
            String type = (String)en.nextElement();
            if (result.contains(type)) continue;
            result.add(type);
        }
        return result;
    }

    public boolean timeLimitedAttributesPresent() {
        if (this.mResponsibleFor.isEmpty()) {
            return false;
        }
        boolean timeLimitedAttributesPresent = false;
        Enumeration en = this.mResponsibleFor.keys();
        while (en.hasMoreElements() && !timeLimitedAttributesPresent) {
            DSPrincipalModel pModel = (DSPrincipalModel)this.mResponsibleFor.get(en.nextElement());
            boolean bl = timeLimitedAttributesPresent = pModel.timeLimitedAttributesPresent() || timeLimitedAttributesPresent;
        }
        return timeLimitedAttributesPresent;
    }

    public boolean hasExplicitHomeForConfiguration(String type) {
        return this.mHomeFor.get(type) != null;
    }

    public boolean hasExplicitAttributeMappingConfiguration(String type) {
        return this.mAttributeMapping.get(type) != null;
    }

    public boolean hasExplicitNotHomeForConfiguration(String type) {
        return this.mNotHomeFor.get(type) != null;
    }

    public boolean hasExplicitResponsibleForConfiguration(String type) {
        return this.mResponsibleFor.get(type) != null;
    }

    public boolean hasExplicitNotResponsibleForConfiguration(String type) {
        return this.mNotResponsibleFor.get(type) != null;
    }

    public int getPriority(String type) {
        DSPrincipalModel dummy = (DSPrincipalModel)this.mHomeFor.get(type);
        if (dummy == null) {
            dummy = (DSPrincipalModel)this.mHomeFor.get("*");
        }
        if (dummy != null) {
            return dummy.getPriority();
        }
        return -1;
    }

    public boolean isHomeFor(String type, String nameSpace, String attribute, Object value) {
        boolean homeFor = false;
        DSPrincipalModel dummy = (DSPrincipalModel)this.mHomeFor.get(type);
        if (dummy == null) {
            dummy = (DSPrincipalModel)this.mHomeFor.get("*");
        }
        if (dummy != null) {
            homeFor = dummy.isHomeFor(nameSpace, attribute, value);
        }
        return homeFor;
    }

    public boolean isNotHomeFor(String type, String nameSpace, String attribute, Object value) {
        DSPrincipalModel dummy = (DSPrincipalModel)this.mNotHomeFor.get(type);
        boolean notHomeFor = false;
        if (dummy == null) {
            dummy = (DSPrincipalModel)this.mNotHomeFor.get("*");
        }
        if (dummy != null) {
            notHomeFor = dummy.isHomeFor(nameSpace, attribute, value);
        }
        return notHomeFor;
    }

    public boolean feelsResponsible(String nameSpace, String attribute) {
        Enumeration en = this.mResponsibleFor.keys();
        while (en.hasMoreElements()) {
            if (!this.feelsResponsible((String)en.nextElement(), nameSpace, attribute)) continue;
            return true;
        }
        return false;
    }

    public boolean feelsResponsible(String type) {
        Vector dummy = this.getResponsibleNameSpaces(type);
        if (dummy == null || !dummy.isEmpty()) {
            return true;
        }
        Hashtable dummy2 = this.getResponsibleNameSpaceAttributes(type);
        return dummy2 == null || !dummy2.isEmpty();
    }

    public int getAttributeCacheTime(String type, String nameSpace, String attribute) {
        int cacheTime = -1;
        DSPrincipalModel dummy = (DSPrincipalModel)this.mResponsibleFor.get(type);
        if (dummy == null) {
            dummy = (DSPrincipalModel)this.mResponsibleFor.get("*");
        }
        if (dummy != null) {
            cacheTime = dummy.getAttributeCacheTime(nameSpace, attribute);
        }
        return cacheTime;
    }

    public boolean isAttributeModifiable(String type, String nameSpace, String attribute) {
        if (this.getIsReadonly()) {
            return false;
        }
        DSPrincipalModel dummy = (DSPrincipalModel)this.mResponsibleFor.get(type);
        boolean isModifyable = false;
        if (dummy == null) {
            dummy = (DSPrincipalModel)this.mResponsibleFor.get("*");
        }
        if (dummy != null) {
            isModifyable = dummy.isAttributeModifiable(nameSpace, attribute);
        }
        return isModifyable;
    }

    public boolean feelsResponsible(String type, String nameSpace, String attribute) {
        DSPrincipalModel dummy = (DSPrincipalModel)this.mResponsibleFor.get(type);
        boolean responsible = false;
        if (dummy == null) {
            dummy = (DSPrincipalModel)this.mResponsibleFor.get("*");
        }
        if (dummy != null) {
            responsible = dummy.feelsResponsible(nameSpace, attribute);
        }
        if (this.mNotResponsibleFor.isEmpty() || !responsible) {
            return responsible;
        }
        dummy = (DSPrincipalModel)this.mNotResponsibleFor.get(type);
        if (dummy == null) {
            dummy = (DSPrincipalModel)this.mNotResponsibleFor.get("*");
        }
        if (dummy != null) {
            responsible = !dummy.feelsResponsible(nameSpace, attribute);
        }
        return responsible;
    }

    public String getPhysicalAttribute(String principalType, String nameSpace, String logicalAttributeName) {
        DSPrincipalModel dummy = (DSPrincipalModel)this.mAttributeMapping.get(principalType);
        if (dummy == null) {
            dummy = (DSPrincipalModel)this.mAttributeMapping.get("*");
        }
        if (dummy != null) {
            return dummy.getPhysicalAttribute(nameSpace, logicalAttributeName);
        }
        return logicalAttributeName;
    }

    public Vector getResponsibleNameSpaces(String type) {
        Vector respNamespaces = new Vector();
        DSPrincipalModel dummy = (DSPrincipalModel)this.mResponsibleFor.get(type);
        if (dummy == null) {
            dummy = (DSPrincipalModel)this.mResponsibleFor.get("*");
        }
        if (dummy != null) {
            respNamespaces = dummy.getResponsibleNameSpaces();
        }
        if (respNamespaces != null && respNamespaces.isEmpty()) {
            return respNamespaces;
        }
        dummy = (DSPrincipalModel)this.mNotResponsibleFor.get(type);
        if (dummy == null) {
            dummy = (DSPrincipalModel)this.mNotResponsibleFor.get("*");
        }
        if (dummy != null) {
            Vector remove = dummy.getResponsibleNameSpaces();
            if (respNamespaces != null && remove != null) {
                Enumeration en = remove.elements();
                while (en.hasMoreElements()) {
                    respNamespaces.remove(en.nextElement());
                }
            }
        }
        return respNamespaces;
    }

    public Hashtable getResponsibleNameSpaceAttributes(String type) {
        Hashtable respNamespaceAttributes = new Hashtable();
        DSPrincipalModel dummy = (DSPrincipalModel)this.mResponsibleFor.get(type);
        if (dummy == null) {
            dummy = (DSPrincipalModel)this.mResponsibleFor.get("*");
        }
        if (dummy != null) {
            respNamespaceAttributes = dummy.getResponsibleNameSpaceAttributes();
        }
        if ((dummy = (DSPrincipalModel)this.mNotResponsibleFor.get(type)) == null) {
            dummy = (DSPrincipalModel)this.mNotResponsibleFor.get("*");
        }
        if (dummy != null) {
            Hashtable remove = dummy.getResponsibleNameSpaceAttributes();
            Enumeration en = remove.keys();
            while (en.hasMoreElements()) {
                String namespace = (String)en.nextElement();
                Vector newValues = (Vector)respNamespaceAttributes.get(namespace);
                Vector attribs = (Vector)remove.get(namespace);
                if (attribs == null || newValues == null) continue;
                int size = attribs.size();
                int j = 0;
                while (j < size) {
                    newValues.remove(attribs.elementAt(j));
                    ++j;
                }
                respNamespaceAttributes.put(namespace, newValues);
            }
        }
        return respNamespaceAttributes;
    }

    public int getAttributeType(String type, String nameSpace, String attribute) {
        DSAttributeModel dummy3;
        DSNameSpaceModel dummy2;
        int attrType = 0;
        DSPrincipalModel dummy = (DSPrincipalModel)this.mResponsibleFor.get(type);
        if (dummy != null && (dummy2 = dummy.getNameSpace(nameSpace)) != null && (dummy3 = dummy2.getAttribute(attribute)) != null) {
            attrType = dummy3.getType();
        }
        return attrType;
    }

    public Hashtable getPopulateInitially(String type) {
        Hashtable respNamespaceAttributes = new Hashtable();
        DSPrincipalModel dummy = (DSPrincipalModel)this.mResponsibleFor.get(type);
        if (dummy == null) {
            dummy = (DSPrincipalModel)this.mResponsibleFor.get("*");
        }
        if (dummy != null) {
            respNamespaceAttributes = dummy.getPopulateInitially();
        }
        if ((dummy = (DSPrincipalModel)this.mNotResponsibleFor.get(type)) == null) {
            dummy = (DSPrincipalModel)this.mNotResponsibleFor.get("*");
        }
        if (dummy != null) {
            Hashtable remove = dummy.getResponsibleNameSpaceAttributes();
            Enumeration en = remove.keys();
            while (en.hasMoreElements()) {
                String namespace = (String)en.nextElement();
                Vector newValues = (Vector)respNamespaceAttributes.get(namespace);
                Vector attribs = (Vector)remove.get(namespace);
                if (attribs == null || newValues == null) continue;
                int size = attribs.size();
                int j = 0;
                while (j < size) {
                    newValues.remove(attribs.elementAt(j));
                    ++j;
                }
                respNamespaceAttributes.put(namespace, newValues);
            }
        }
        return respNamespaceAttributes;
    }

    public String getPrivateAttributeFileValue(String attributeName) throws PersistenceException {
        DSPrivatePropertyModel dummy = (DSPrivatePropertyModel)this.mPrivateSection.get(attributeName);
        String value = null;
        if (dummy != null) {
            value = dummy.getValue();
        }
        if (value != null) {
            File f = new File(value);
            if (f.isAbsolute()) {
                return value;
            }
            if (value.startsWith("/") || value.startsWith("\\")) {
                value = f.getAbsolutePath();
            } else {
                File mRootDir = new File("");
                if (mRootDir != null) {
                    value = mRootDir + File.separator + value;
                } else {
                    String errorMessage = "Can't determine directory for \"" + value + "\"!";
                    throw new PersistenceException(errorMessage);
                }
            }
            return value;
        }
        return null;
    }

    public String getPrivateAttribute(String attributeName) {
        DSPrivatePropertyModel dummy = (DSPrivatePropertyModel)this.mPrivateSection.get(attributeName);
        if (dummy != null) {
            return dummy.getValue();
        }
        return null;
    }

    public boolean getPrivateAttributeBooleanValue(String attributeName) throws PersistenceException {
        DSPrivatePropertyModel dummy = (DSPrivatePropertyModel)this.mPrivateSection.get(attributeName);
        if (dummy != null) {
            String value = dummy.getValue();
            if (value == null) {
                String errorMessage = "Cannot convert null to boolean!";
                throw new PersistenceException(errorMessage);
            }
            return value.equalsIgnoreCase("true");
        }
        String errorMessage = "No value found for " + attributeName + " in private section!";
        throw new PersistenceException(errorMessage);
    }

    public int getPrivateAttributeIntValue(String attributeName) throws PersistenceException {
        DSPrivatePropertyModel dummy = (DSPrivatePropertyModel)this.mPrivateSection.get(attributeName);
        if (dummy != null) {
            try {
                return Integer.parseInt(dummy.getValue());
            }
            catch (NumberFormatException nfex) {
                throw new PersistenceException(nfex);
            }
        }
        return -1;
    }

    public long getPrivateAttributeLongValue(String attributeName) throws PersistenceException {
        DSPrivatePropertyModel dummy = (DSPrivatePropertyModel)this.mPrivateSection.get(attributeName);
        if (dummy != null) {
            try {
                return Long.parseLong(dummy.getValue());
            }
            catch (NumberFormatException nfex) {
                throw new PersistenceException(nfex);
            }
        }
        return -1L;
    }

    public String getLogicalAttribute(String principalType, String nameSpace, String physicalAttributeName) {
        DSPrincipalModel dummy = (DSPrincipalModel)this.mAttributeMapping.get(principalType);
        if (dummy == null) {
            dummy = (DSPrincipalModel)this.mAttributeMapping.get("*");
        }
        if (dummy != null) {
            return dummy.getLogicalAttribute(nameSpace, physicalAttributeName);
        }
        return physicalAttributeName;
    }

    public void setPrivateSectionElement(DSPrivatePropertyModel property) {
        this.mPrivateSection.put(property.getName(), property);
    }

    public void deletePrivateSectionElement(DSPrivatePropertyModel property) {
        this.mPrivateSection.remove(property.getName());
    }

    public void setHomeFor(DSPrincipalModel principal) {
        this.mHomeFor.put(principal.getType(), principal);
    }

    public void setNotHomeFor(DSPrincipalModel principal) {
        this.mNotHomeFor.put(principal.getType(), principal);
    }

    public Hashtable getResponsibleFor() {
        return this.mResponsibleFor;
    }

    public Hashtable getAttributeMapping() {
        return this.mAttributeMapping;
    }

    public Hashtable getPrivateSection() {
        return this.mPrivateSection;
    }

    public Hashtable getHomeFor() {
        return this.mHomeFor;
    }

    public void deleteHomeFor(DSPrincipalModel principal) {
        this.mHomeFor.remove(principal.getType());
    }

    public void setResponsibleFor(DSPrincipalModel principal) {
        this.mResponsibleFor.put(principal.getType(), principal);
    }

    public void setNotResponsibleFor(DSPrincipalModel principal) {
        this.mNotResponsibleFor.put(principal.getType(), principal);
    }

    public void deleteResponsibleFor(DSPrincipalModel principal) {
        this.mResponsibleFor.remove(principal.getType());
    }

    public void setAttributeMapping(DSPrincipalModel principal) {
        this.mAttributeMapping.put(principal.getType(), principal);
    }

    public void deleteAttributeMapping(DSPrincipalModel principal) {
        this.mAttributeMapping.remove(principal.getType());
    }

    public void setDataSourceID(String dataSourceID) throws PersistenceException {
        if (dataSourceID == null) {
            String errorMessage = "ID of datasource must not be null!";
            throw new PersistenceException(errorMessage);
        }
        this.mDataSourceID = dataSourceID;
    }

    public File getConfigurationRootDir() {
        return new File("");
    }

    public void setClassName(String className) throws PersistenceException {
        if (className == null) {
            String errorMessage = "ClassName of datasource must not be null!";
            throw new PersistenceException(errorMessage);
        }
        this.mClassName = className;
    }

    public void setIsReadonly(boolean isReadonly) throws PersistenceException {
        if (isReadonly && !this.mIsPrimary) {
            String errorMessage = "Secondary datasource " + this.mDataSourceID + " must not be readonly (only primary data souces can be readonly)!";
            throw new PersistenceException(errorMessage);
        }
        this.mIsReadonly = isReadonly;
    }

    public void setIsPrimary(boolean isPrimary) throws PersistenceException {
        if (this.mIsReadonly && !isPrimary) {
            String errorMessage = "Readonly datasource " + this.mDataSourceID + " must not be secondary datasource (only primary data souces can be readonly)!";
            throw new PersistenceException(errorMessage);
        }
        this.mIsPrimary = isPrimary;
    }

    public String getDataSourceID() {
        return this.mDataSourceID;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    public void setDisplayName(String displayName) {
        this.mDisplayName = displayName;
    }

    public String getClassName() {
        return this.mClassName;
    }

    public boolean getIsReadonly() {
        return this.mIsReadonly;
    }

    public boolean getIsPrimary() {
        return this.mIsPrimary;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DSConfigurationModel)) {
            return false;
        }
        DSConfigurationModel model = (DSConfigurationModel)o;
        return this.mDataSourceID.equals(model.getDataSourceID());
    }

    public int hashCode() {
        return this.mDataSourceID.hashCode();
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toString() {
        return this.getDataSourceID();
    }

    public DefaultMutableTreeNode toTreeNode() {
        Iterator it;
        Collection c;
        DefaultMutableTreeNode newNode;
        DefaultMutableTreeNode thisNode = new DefaultMutableTreeNode(this);
        if (!this.mHomeFor.isEmpty()) {
            newNode = new DefaultMutableTreeNode("homeFor");
            c = this.mHomeFor.values();
            it = c.iterator();
            while (it.hasNext()) {
                newNode.add(((DSPrincipalModel)it.next()).toTreeNode());
            }
            thisNode.add(newNode);
        }
        if (!this.mNotHomeFor.isEmpty()) {
            newNode = new DefaultMutableTreeNode("notHomeFor");
            c = this.mNotHomeFor.values();
            it = c.iterator();
            while (it.hasNext()) {
                newNode.add(((DSPrincipalModel)it.next()).toTreeNode());
            }
            thisNode.add(newNode);
        }
        if (!this.mResponsibleFor.isEmpty()) {
            newNode = new DefaultMutableTreeNode("responsibleFor");
            c = this.mResponsibleFor.values();
            it = c.iterator();
            while (it.hasNext()) {
                newNode.add(((DSPrincipalModel)it.next()).toTreeNode());
            }
            thisNode.add(newNode);
        }
        if (!this.mNotResponsibleFor.isEmpty()) {
            newNode = new DefaultMutableTreeNode("notResponsibleFor");
            c = this.mNotResponsibleFor.values();
            it = c.iterator();
            while (it.hasNext()) {
                newNode.add(((DSPrincipalModel)it.next()).toTreeNode());
            }
            thisNode.add(newNode);
        }
        if (!this.mAttributeMapping.isEmpty()) {
            newNode = new DefaultMutableTreeNode("attributeMapping");
            c = this.mAttributeMapping.values();
            it = c.iterator();
            while (it.hasNext()) {
                newNode.add(((DSPrincipalModel)it.next()).toTreeNode());
            }
            thisNode.add(newNode);
        }
        if (!this.mPrivateSection.isEmpty()) {
            newNode = new DefaultMutableTreeNode("privateSection");
            c = this.mPrivateSection.values();
            it = c.iterator();
            while (it.hasNext()) {
                newNode.add(((DSPrivatePropertyModel)it.next()).toTreeNode());
            }
            thisNode.add(newNode);
        }
        return thisNode;
    }

    public void setNotificationListener(IPersistenceNotificationListener notificationListener) {
        this.mNotificationListener = notificationListener;
    }

    public IPersistenceNotificationListener getNotificationListener() {
        return this.mNotificationListener;
    }

    public String toXML(int level) {
        int i;
        Iterator it;
        Collection c;
        int i2;
        StringBuffer result = new StringBuffer();
        int i3 = 0;
        while (i3 < level) {
            result.append("\t");
            ++i3;
        }
        result.append("<");
        result.append("dataSource");
        result.append(" ");
        result.append("id");
        result.append("=\"");
        result.append(XHTMLEncoder.encode(this.mDataSourceID));
        result.append("\"");
        result.append(" ");
        result.append("className");
        result.append("=\"");
        result.append(XHTMLEncoder.encode(this.mClassName));
        result.append("\"");
        result.append(" ");
        result.append("isReadonly");
        result.append("=\"");
        if (this.mIsReadonly) {
            result.append("true");
        } else {
            result.append("false");
        }
        result.append("\"");
        result.append(" ");
        result.append("isPrimary");
        result.append("=\"");
        if (this.mIsPrimary) {
            result.append("true");
        } else {
            result.append("false");
        }
        result.append("\"");
        if (this.mDisplayName != null) {
            result.append(" ");
            result.append("displayName");
            result.append("=\"");
            result.append(this.mDisplayName);
            result.append("\"");
        }
        result.append(">\n");
        if (!this.mHomeFor.isEmpty()) {
            i2 = 0;
            while (i2 < level + 1) {
                result.append("\t");
                ++i2;
            }
            result.append("<");
            result.append("homeFor");
            result.append(">\n");
            c = this.mHomeFor.values();
            it = c.iterator();
            while (it.hasNext()) {
                result.append(((DSPrincipalModel)it.next()).toXML(level + 2));
            }
            i = 0;
            while (i < level + 1) {
                result.append("\t");
                ++i;
            }
            result.append("</");
            result.append("homeFor");
            result.append(">\n");
        }
        if (!this.mNotHomeFor.isEmpty()) {
            i2 = 0;
            while (i2 < level + 1) {
                result.append("\t");
                ++i2;
            }
            result.append("<");
            result.append("notHomeFor");
            result.append(">\n");
            c = this.mNotHomeFor.values();
            it = c.iterator();
            while (it.hasNext()) {
                result.append(((DSPrincipalModel)it.next()).toXML(level + 2));
            }
            i = 0;
            while (i < level + 1) {
                result.append("\t");
                ++i;
            }
            result.append("</");
            result.append("notHomeFor");
            result.append(">\n");
        }
        if (!this.mResponsibleFor.isEmpty()) {
            i2 = 0;
            while (i2 < level + 1) {
                result.append("\t");
                ++i2;
            }
            result.append("<");
            result.append("responsibleFor");
            result.append(">\n");
            c = this.mResponsibleFor.values();
            it = c.iterator();
            while (it.hasNext()) {
                result.append(((DSPrincipalModel)it.next()).toXML(level + 2));
            }
            i = 0;
            while (i < level + 1) {
                result.append("\t");
                ++i;
            }
            result.append("</");
            result.append("responsibleFor");
            result.append(">\n");
        }
        if (!this.mNotResponsibleFor.isEmpty()) {
            i2 = 0;
            while (i2 < level + 1) {
                result.append("\t");
                ++i2;
            }
            result.append("<");
            result.append("notResponsibleFor");
            result.append(">\n");
            c = this.mNotResponsibleFor.values();
            it = c.iterator();
            while (it.hasNext()) {
                result.append(((DSPrincipalModel)it.next()).toXML(level + 2));
            }
            i = 0;
            while (i < level + 1) {
                result.append("\t");
                ++i;
            }
            result.append("</");
            result.append("notResponsibleFor");
            result.append(">\n");
        }
        if (!this.mAttributeMapping.isEmpty()) {
            i2 = 0;
            while (i2 < level + 1) {
                result.append("\t");
                ++i2;
            }
            result.append("<");
            result.append("attributeMapping");
            result.append(">\n");
            c = this.mAttributeMapping.values();
            it = c.iterator();
            while (it.hasNext()) {
                result.append(((DSPrincipalModel)it.next()).toXML(level + 2));
            }
            i = 0;
            while (i < level + 1) {
                result.append("\t");
                ++i;
            }
            result.append("</");
            result.append("attributeMapping");
            result.append(">\n");
        }
        if (!this.mPrivateSection.isEmpty()) {
            i2 = 0;
            while (i2 < level + 1) {
                result.append("\t");
                ++i2;
            }
            result.append("<");
            result.append("privateSection");
            result.append(">\n");
            c = this.mPrivateSection.values();
            it = c.iterator();
            while (it.hasNext()) {
                result.append(((DSPrivatePropertyModel)it.next()).toXML(level + 2));
            }
            i = 0;
            while (i < level + 1) {
                result.append("\t");
                ++i;
            }
            result.append("</");
            result.append("privateSection");
            result.append(">\n");
        }
        i2 = 0;
        while (i2 < level) {
            result.append("\t");
            ++i2;
        }
        result.append("</");
        result.append("dataSource");
        result.append(">\n");
        return result.toString();
    }
}

