/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp;

import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.imp.XHTMLEncoder;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class DSAttributeModel
implements Serializable {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/DSAttributeModel.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_STRING = 1;
    public static final int TYPE_BLOB = 2;
    private String mName;
    private int mType;
    private boolean mPopulateInitially;
    private String mPhysicalName;
    private boolean mReadonly;
    private int mTimeLimit;
    private Vector mValues;
    private static transient IUMTrace mTrace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/DSAttributeModel.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)");

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("\"");
        result.append(this.getName());
        result.append("\" (");
        if (this.mTimeLimit != -1) {
            result.append(this.mTimeLimit);
            result.append("s");
        } else {
            result.append("no time limit set");
        }
        result.append(")");
        return result.toString();
    }

    public DefaultMutableTreeNode toTreeNode() {
        DefaultMutableTreeNode thisNode = new DefaultMutableTreeNode(this);
        if (!this.mValues.isEmpty()) {
            int j = 0;
            while (j < this.mValues.size()) {
                thisNode.add(new DefaultMutableTreeNode((String)this.mValues.elementAt(j)));
                ++j;
            }
        }
        return thisNode;
    }

    public DSAttributeModel() {
    }

    public DSAttributeModel(String name, int type, boolean readonly) throws PersistenceException {
        this(name, type, readonly, -1);
    }

    public DSAttributeModel(String name, int type, boolean readonly, int timeLimit) throws PersistenceException {
        if (name == null) {
            String errorMessage = "Name of attribute must not be null!";
            throw new PersistenceException(errorMessage);
        }
        this.mName = name;
        this.mType = type;
        this.mPopulateInitially = false;
        this.mReadonly = readonly;
        this.mValues = new Vector();
        this.mTimeLimit = timeLimit;
    }

    public boolean isTimeLimited() {
        return this.mTimeLimit != -1;
    }

    public int getTimeLimit() {
        return this.mTimeLimit;
    }

    public void setTimeLimit(int timeLimit) {
        this.mTimeLimit = timeLimit;
    }

    public void setName(String name) throws PersistenceException {
        if (name == null) {
            String errorMessage = "Name of attribute must not be null!";
            throw new PersistenceException(errorMessage);
        }
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public int getType() {
        return this.mType;
    }

    public void setReadonly(boolean readonly) {
        this.mReadonly = readonly;
    }

    public void setPopulateInitially(boolean poplateInitially) {
        this.mPopulateInitially = poplateInitially;
    }

    public boolean getReadonly() {
        return this.mReadonly;
    }

    public boolean getPopulateInitially() {
        return this.mPopulateInitially;
    }

    public void setPhysicalName(String physicalName) {
        this.mPhysicalName = physicalName;
    }

    public String getPhysicalName() {
        return this.mPhysicalName;
    }

    public void setValue(String value) {
        this.mValues.add(value);
    }

    public Vector getValues() {
        return this.mValues;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DSAttributeModel)) {
            return false;
        }
        DSAttributeModel model = (DSAttributeModel)o;
        return this.mName.equals(model.getName());
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        int i;
        StringBuffer result = new StringBuffer();
        int i2 = 0;
        while (i2 < level) {
            result.append("\t");
            ++i2;
        }
        result.append("<");
        result.append("attribute");
        result.append(" ");
        result.append("name");
        result.append("=\"");
        result.append(XHTMLEncoder.encode(this.mName));
        result.append("\"");
        if (this.mPopulateInitially) {
            result.append(" ");
            result.append("populateInitially");
            result.append("=\"true\"");
        }
        if (this.mReadonly) {
            result.append(" ");
            result.append("readonly");
            result.append("=\"true\"");
        }
        if (this.mType != 0) {
            result.append(" ");
            result.append("type");
            result.append("=\"");
            switch (this.mType) {
                case 1: {
                    result.append("string");
                    break;
                }
                case 2: {
                    result.append("blob");
                }
            }
            result.append("\"");
        }
        if (this.mTimeLimit != -1) {
            result.append(" ");
            result.append("cacheTime");
            result.append("=\"");
            result.append(this.mTimeLimit);
            result.append("\"");
        }
        result.append(">\n");
        if (!this.mValues.isEmpty()) {
            int i3;
            i = 0;
            while (i < level + 1) {
                result.append("\t");
                ++i;
            }
            result.append("<");
            result.append("values");
            result.append(">\n");
            int j = 0;
            while (j < this.mValues.size()) {
                i3 = 0;
                while (i3 < level + 2) {
                    result.append("\t");
                    ++i3;
                }
                result.append("<");
                result.append("value");
                result.append(">");
                result.append(XHTMLEncoder.encode((String)this.mValues.elementAt(j)));
                result.append("</");
                result.append("value");
                result.append(">\n");
                ++j;
            }
            i3 = 0;
            while (i3 < level + 1) {
                result.append("\t");
                ++i3;
            }
            result.append("</");
            result.append("values");
            result.append(">\n");
        }
        if (this.mPhysicalName != null) {
            i = 0;
            while (i < level + 1) {
                result.append("\t");
                ++i;
            }
            result.append("<");
            result.append("physicalAttribute");
            result.append(" ");
            result.append("name");
            result.append("=\"");
            result.append(XHTMLEncoder.encode(this.mPhysicalName));
            result.append("\"");
            result.append("/>\n");
        }
        i = 0;
        while (i < level) {
            result.append("\t");
            ++i;
        }
        result.append("</");
        result.append("attribute");
        result.append(">\n");
        return result.toString();
    }
}

