/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp;

import com.sap.security.api.UMFactory;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.datasource.imp.DSAttributeModel;
import com.sap.security.core.persistence.datasource.imp.DSConfigurationModel;
import com.sap.security.core.persistence.datasource.imp.DSNameSpaceModel;
import com.sap.security.core.persistence.datasource.imp.DSPrincipalModel;
import com.sap.security.core.persistence.datasource.imp.DSPrivatePropertyModel;
import com.sap.security.core.util.IUMTrace;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Configuration
implements Serializable {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/Configuration.java#3 $ from $DateTime: 2004/11/04 13:54:08 $ ($Change: 17563 $)";
    public static final String DATASOURCES = "dataSources";
    public static final String DATASOURCE = "dataSource";
    public static final String DATASOURCE_ID = "id";
    public static final String DATASOURCE_CLASSNAME = "className";
    public static final String DATASOURCE_ISREADONLY = "isReadonly";
    public static final String DATASOURCE_ISPRIMARY = "isPrimary";
    public static final String DATASOURCE_DISPLAYNAME = "displayName";
    public static final String ATTRIBUTEMAPPING = "attributeMapping";
    public static final String RESPONSIBLEFOR = "responsibleFor";
    public static final String NOT_RESPONSIBLEFOR = "notResponsibleFor";
    public static final String PRIVATESECTION = "privateSection";
    public static final String PRINCIPALS = "principals";
    public static final String PRINCIPAL = "principal";
    public static final String PRINCIPAL_TYPE = "type";
    public static final String PRINCIPAL_PRIORITY = "priority";
    public static final String NAMESPACES = "nameSpaces";
    public static final String NAMESPACE = "nameSpace";
    public static final String NAMESPACE_NAME = "name";
    public static final String ATTRIBUTES = "attributes";
    public static final String ATTRIBUTE = "attribute";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String POPULATE_INITIALLY = "populateInitially";
    public static final String ATTRIBUTE_TYPE = "type";
    public static final String ATTRIBUTE_READONLY = "readonly";
    public static final String ATTRIBUTE_CACHING_TIME = "cacheTime";
    public static final String ATTRIBUTE_STRING_TYPE = "string";
    public static final String ATTRIBUTE_BLOB_TYPE = "blob";
    public static final String PHYSICAL_ATTRIBUTE = "physicalAttribute";
    public static final String PHYSICAL_ATTRIBUTE_NAME = "name";
    public static final String VALUE = "value";
    public static final String VALUES = "values";
    public static final String HOME_FOR = "homeFor";
    public static final String NOT_HOME_FOR = "notHomeFor";
    public static final String USER_TYPE = "user";
    public static final String GROUP_TYPE = "group";
    public static final String ROLE_TYPE = "role";
    public static final String TEAM_TYPE = "team";
    public static final String ACCOUNT_TYPE = "account";
    public static final String COMPANY_TYPE = "company";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String PRINCIPAL_TYPE_WILDCARD = "*";
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    Vector mDataSourceConfigurationModels;
    InputStream mConfigFile;
    private static transient IUMTrace mTrace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/Configuration.java#3 $ from $DateTime: 2004/11/04 13:54:08 $ ($Change: 17563 $)");

    public String toString() {
        return this.toXML();
    }

    public Configuration() {
    }

    public Configuration(InputStream configurationFile) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("constructor", new Object[]{configurationFile});
        }
        this.mConfigFile = configurationFile;
        if (configurationFile == null) {
            String errorMessage = "Config file is null!";
            throw new PersistenceException(errorMessage);
        }
        this.mDataSourceConfigurationModels = new Vector();
        this.refresh();
        if (mTrace.bePath()) {
            mTrace.exiting("constructor");
        }
    }

    public Vector getDataSourceConfigurations() {
        if (mTrace.bePath()) {
            mTrace.entering("getDataSourceConfigurations");
        }
        if (mTrace.bePath()) {
            mTrace.exiting("getDataSourceConfigurations", new Object[]{this.mDataSourceConfigurationModels});
        }
        return this.mDataSourceConfigurationModels;
    }

    public String toXML() {
        if (mTrace.bePath()) {
            mTrace.entering("toXML");
        }
        StringBuffer result = new StringBuffer();
        result.append("<");
        result.append(DATASOURCES);
        if (!this.mDataSourceConfigurationModels.isEmpty()) {
            result.append(">\n");
            int i = 0;
            while (i < this.mDataSourceConfigurationModels.size()) {
                result.append(((DSConfigurationModel)this.mDataSourceConfigurationModels.elementAt(i)).toXML(1));
                ++i;
            }
            result.append("</");
            result.append(DATASOURCES);
            result.append(">\n");
        } else {
            result.append(" />\n");
        }
        if (mTrace.bePath()) {
            mTrace.exiting("toXML", new Object[]{result.toString()});
        }
        return result.toString();
    }

    public DefaultMutableTreeNode toTreeNode() {
        if (mTrace.bePath()) {
            mTrace.entering("toTreeNode");
        }
        DefaultMutableTreeNode thisNode = new DefaultMutableTreeNode(DATASOURCES);
        if (!this.mDataSourceConfigurationModels.isEmpty()) {
            int j = 0;
            while (j < this.mDataSourceConfigurationModels.size()) {
                thisNode.add(((DSConfigurationModel)this.mDataSourceConfigurationModels.elementAt(j)).toTreeNode());
                ++j;
            }
        }
        if (mTrace.bePath()) {
            mTrace.exiting("toTreeNode", new Object[]{thisNode});
        }
        return thisNode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void refresh() throws PersistenceException {
        DocumentBuilderFactory factory;
        if (mTrace.bePath()) {
            mTrace.entering("refresh");
        }
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        ClassLoader mine = this.getClass().getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(mine);
            factory = DocumentBuilderFactory.newInstance();
            Object var5_4 = null;
            Thread.currentThread().setContextClassLoader(current);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Thread.currentThread().setContextClassLoader(current);
            throw throwable;
        }
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder parser = null;
        try {
            parser = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pcex) {
            throw new PersistenceException(pcex);
        }
        SecutityDTDResolver ser = new SecutityDTDResolver();
        parser.setEntityResolver(ser);
        Document document = null;
        try {
            document = parser.parse(this.mConfigFile);
            ser.closeStream();
        }
        catch (FileNotFoundException fnfex) {
            throw new PersistenceException(fnfex);
        }
        catch (IOException ioex) {
            throw new PersistenceException(ioex);
        }
        catch (SAXException saxex) {
            throw new PersistenceException(saxex);
        }
        Element datasources = this.getElementChildByName(document, DATASOURCES);
        Element datasource = null;
        if (datasources == null) {
            datasource = this.getElementChildByName(document, DATASOURCE);
            if (datasource == null) {
                String errorMessage = "Config file " + this.mConfigFile + " doesn't contain datasource definitions!";
                throw new PersistenceException(errorMessage);
            }
            this.handleDataSource(datasource);
        } else {
            this.handleDataSources(datasources);
        }
        if (mTrace.bePath()) {
            mTrace.exiting("refresh");
        }
    }

    private void handleDataSources(Element datasources) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("handleDataSources", new Object[]{datasources});
        }
        Element datasource = this.getFirstChildElement(datasources);
        while (datasource != null) {
            if (!datasource.getNodeName().equalsIgnoreCase(DATASOURCE)) {
                String errorMessage = "Children of <dataSources> have to be <dataSource>";
                throw new PersistenceException(errorMessage);
            }
            this.handleDataSource(datasource);
            datasource = this.getNextSiblingElement(datasource);
        }
        if (mTrace.bePath()) {
            mTrace.exiting("handleDataSources");
        }
    }

    private void handleDataSource(Element datasource) throws PersistenceException {
        Element privateSection;
        Element attributeMapping;
        Element notIsResponsibleFor;
        Element isResponsibleFor;
        Element notIsHomeFor;
        String container;
        if (mTrace.bePath()) {
            mTrace.entering("handleDataSource", new Object[]{datasource});
        }
        String id = datasource.getAttribute(DATASOURCE_ID);
        String className = datasource.getAttribute(DATASOURCE_CLASSNAME);
        if (id != null && id.equalsIgnoreCase("")) {
            id = null;
        }
        if (className != null && className.equalsIgnoreCase("")) {
            className = null;
        }
        if (id == null || className == null) {
            String errorMessage = "Attributes id and className of <dataSource> must not be undefined!";
            throw new PersistenceException(errorMessage);
        }
        if (id.indexOf(".") != -1) {
            String errorMessage = "Attributes id of <dataSource> must not contain \".\"!";
            throw new PersistenceException(errorMessage);
        }
        String displayName = datasource.getAttribute(DATASOURCE_DISPLAYNAME);
        if (displayName != null && displayName.equals("")) {
            displayName = null;
        }
        boolean isReadonly = (container = datasource.getAttribute(DATASOURCE_ISREADONLY)) != null ? container.equalsIgnoreCase(TRUE) : false;
        container = datasource.getAttribute(DATASOURCE_ISPRIMARY);
        boolean isPrimary = container != null ? container.equalsIgnoreCase(TRUE) : true;
        if (!isPrimary && isReadonly) {
            String errorMessage = "Secondary datasource " + id + " cannot be readonly (only primary datasources can be readonly)!";
            throw new PersistenceException(errorMessage);
        }
        DSConfigurationModel dsConf = new DSConfigurationModel(id, className, isReadonly, isPrimary, displayName);
        Element isHomeFor = this.getElementChildByName(datasource, HOME_FOR);
        if (isHomeFor != null) {
            this.handleHomeFor(isHomeFor, dsConf, false);
        }
        if ((notIsHomeFor = this.getElementChildByName(datasource, NOT_HOME_FOR)) != null) {
            this.handleHomeFor(notIsHomeFor, dsConf, true);
        }
        if ((isResponsibleFor = this.getElementChildByName(datasource, RESPONSIBLEFOR)) != null) {
            this.handleResponsibleFor(isResponsibleFor, dsConf, false);
        }
        if ((notIsResponsibleFor = this.getElementChildByName(datasource, NOT_RESPONSIBLEFOR)) != null) {
            this.handleResponsibleFor(notIsResponsibleFor, dsConf, true);
        }
        if ((attributeMapping = this.getElementChildByName(datasource, ATTRIBUTEMAPPING)) != null) {
            this.handleAttributeMapping(attributeMapping, dsConf);
        }
        if ((privateSection = this.getElementChildByName(datasource, PRIVATESECTION)) != null) {
            this.handlePrivateSection(privateSection, dsConf);
        }
        this.mDataSourceConfigurationModels.add(dsConf);
        if (mTrace.bePath()) {
            mTrace.exiting("handleDataSource", dsConf);
        }
    }

    private void handlePrivateSection(Element privateSection, DSConfigurationModel dsConf) throws PersistenceException {
        if (mTrace.bePath()) {
            mTrace.entering("handlePrivateSection", new Object[]{privateSection, dsConf});
        }
        Element privateAttribute = this.getFirstChildElement(privateSection);
        while (privateAttribute != null) {
            String name = privateAttribute.getNodeName();
            String value = this.trimWhiteSpace(this.getElementContent(privateAttribute));
            if (name != null) {
                if (value == null) {
                    value = "";
                }
                DSPrivatePropertyModel prop = new DSPrivatePropertyModel(name, value);
                dsConf.setPrivateSectionElement(prop);
            }
            privateAttribute = this.getNextSiblingElement(privateAttribute);
        }
        if (mTrace.bePath()) {
            mTrace.exiting("handlePrivateSection", dsConf);
        }
    }

    private void handleAttributeMapping(Element attributeMapping, DSConfigurationModel dsConf) throws PersistenceException {
        Element principals;
        if (mTrace.bePath()) {
            mTrace.entering("handleAttributeMapping", new Object[]{attributeMapping, dsConf});
        }
        Element principal = (principals = this.getElementChildByName(attributeMapping, PRINCIPALS)) != null ? this.getFirstChildElement(principals) : this.getFirstChildElement(attributeMapping);
        while (principal != null) {
            if (!principal.getNodeName().equalsIgnoreCase(PRINCIPAL)) {
                String errorMessage = "Children of <principals> and <attributeMapping> have to be <principal>";
                throw new PersistenceException(errorMessage);
            }
            this.handleAttributeMappingForPrincipalDatabag(principal, dsConf);
            principal = this.getNextSiblingElement(principal);
        }
        if (mTrace.bePath()) {
            mTrace.exiting("handleAttributeMapping", dsConf);
        }
    }

    private void handleAttributeMappingForPrincipalDatabag(Element principal, DSConfigurationModel dsConf) throws PersistenceException {
        String type;
        if (mTrace.bePath()) {
            mTrace.entering("handleAttributeMappingForPrincipalDatabag", new Object[]{principal, dsConf});
        }
        if ((type = principal.getAttribute("type")) != null && type.equalsIgnoreCase("")) {
            type = null;
        }
        if (type == null) {
            String errorMessage = "<principal> must have a type attribute!";
            throw new PersistenceException(errorMessage);
        }
        if (type.indexOf(".") != -1) {
            String errorMessage = "Attribute type of <principal> must not contain \".\"!";
            throw new PersistenceException(errorMessage);
        }
        if (type.equalsIgnoreCase(USER_TYPE)) {
            type = "USER";
        } else if (type.equalsIgnoreCase(GROUP_TYPE)) {
            type = "GRUP";
        } else if (type.equalsIgnoreCase(ROLE_TYPE)) {
            type = "ROLE";
        } else if (type.equalsIgnoreCase(TEAM_TYPE)) {
            type = "TEAM";
        } else if (type.equalsIgnoreCase(ACCOUNT_TYPE)) {
            type = "UACC";
        } else if (type.equalsIgnoreCase(COMPANY_TYPE)) {
            type = "COMP";
        } else if (type.equalsIgnoreCase(PRINCIPAL_TYPE_WILDCARD)) {
            type = PRINCIPAL_TYPE_WILDCARD;
        } else if (type.length() != 4) {
            String errorMessage = "<principal> contains unsupported value (not 4 characters) in type attribute: " + type;
            throw new PersistenceException(errorMessage);
        }
        Element namespaces = this.getElementChildByName(principal, NAMESPACES);
        Element namespace = namespaces != null ? this.getFirstChildElement(namespaces) : this.getFirstChildElement(principal);
        DSPrincipalModel princ = new DSPrincipalModel(type);
        while (namespace != null) {
            if (!namespace.getNodeName().equalsIgnoreCase(NAMESPACE)) {
                String errorMessage = "Children of <principal> and <nameSpaces> have to be <nameSpace>";
                throw new PersistenceException(errorMessage);
            }
            this.handleAttributeMappingForNameSpace(type, namespace, princ);
            namespace = this.getNextSiblingElement(namespace);
        }
        dsConf.setAttributeMapping(princ);
        if (mTrace.bePath()) {
            mTrace.exiting("handleAttributeMappingForPrincipalDatabag", dsConf);
        }
    }

    private void handleAttributeMappingForNameSpace(String principalType, Element nameSpace, DSPrincipalModel princ) throws PersistenceException {
        String name;
        if (mTrace.bePath()) {
            mTrace.entering("handleAttributeMappingForNameSpace", new Object[]{principalType, nameSpace, princ});
        }
        if ((name = nameSpace.getAttribute("name")) != null && name.equalsIgnoreCase("")) {
            name = null;
        }
        if (name == null) {
            String errorMessage = "<nameSpace> must have a name attribute!";
            throw new PersistenceException(errorMessage);
        }
        Element attributes = this.getElementChildByName(nameSpace, ATTRIBUTES);
        Element attribute = attributes != null ? this.getFirstChildElement(attributes) : this.getFirstChildElement(nameSpace);
        DSNameSpaceModel namesp = new DSNameSpaceModel(name);
        while (attribute != null) {
            if (!attribute.getNodeName().equalsIgnoreCase(ATTRIBUTE)) {
                String errorMessage = "Children of <nameSpace> and <attributes> have to be <attribute>";
                throw new PersistenceException(errorMessage);
            }
            this.handleAttributeMappingForAttribute(principalType, name, attribute, namesp);
            attribute = this.getNextSiblingElement(attribute);
        }
        princ.setNameSpace(namesp);
        if (mTrace.bePath()) {
            mTrace.exiting("handleAttributeMappingForNameSpace", princ);
        }
    }

    private void handleAttributeMappingForAttribute(String principalType, String nameSpace, Element attribute, DSNameSpaceModel dsConf) throws PersistenceException {
        String logicalAttributeName;
        if (mTrace.bePath()) {
            mTrace.entering("handleAttributeMappingForAttribute", new Object[]{principalType, nameSpace, attribute, dsConf});
        }
        if ((logicalAttributeName = attribute.getAttribute("name")) != null && logicalAttributeName.equalsIgnoreCase("")) {
            logicalAttributeName = null;
        }
        if (logicalAttributeName == null) {
            String errorMessage = "<attribute> must have a name attribute!";
            throw new PersistenceException(errorMessage);
        }
        Element physicalAttribute = this.getElementChildByName(attribute, PHYSICAL_ATTRIBUTE);
        if (physicalAttribute != null) {
            String name = physicalAttribute.getAttribute("name");
            if (name != null && name.equalsIgnoreCase("")) {
                String errorMessage = "<physicalAttribute> must have a name attribute!";
                throw new PersistenceException(errorMessage);
            }
            DSAttributeModel attrib = new DSAttributeModel(logicalAttributeName, 0, false);
            attrib.setPhysicalName(name);
            dsConf.setAttribute(attrib);
        }
        if (mTrace.bePath()) {
            mTrace.exiting("handleAttributeMappingForAttribute", dsConf);
        }
    }

    private void handleResponsibleFor(Element responsibleFor, DSConfigurationModel dsConf, boolean invers) throws PersistenceException {
        Element principals;
        if (mTrace.bePath()) {
            mTrace.entering("handleResponsibleFor", new Object[]{responsibleFor, dsConf, new Boolean(invers)});
        }
        Element principal = (principals = this.getElementChildByName(responsibleFor, PRINCIPALS)) != null ? this.getFirstChildElement(principals) : this.getFirstChildElement(responsibleFor);
        if (invers || principal != null) {
            while (principal != null) {
                if (!principal.getNodeName().equalsIgnoreCase(PRINCIPAL)) {
                    String errorMessage = "Children of <responsibleFor> and <principals> have to be <principal>";
                    throw new PersistenceException(errorMessage);
                }
                this.handleResponsibleForPrincipalDatabag(principal, dsConf, invers);
                principal = this.getNextSiblingElement(principal);
            }
        }
        if (mTrace.bePath()) {
            mTrace.exiting("handleResponsibleFor", dsConf);
        }
    }

    private void handleResponsibleForPrincipalDatabag(Element principal, DSConfigurationModel dsConf, boolean invers) throws PersistenceException {
        String type;
        if (mTrace.bePath()) {
            mTrace.entering("handleResponsibleForPrincipalDatabag", new Object[]{principal, dsConf, new Boolean(invers)});
        }
        if ((type = principal.getAttribute("type")) != null && type.equalsIgnoreCase("")) {
            type = null;
        }
        if (type == null) {
            String errorMessage = "<principal> must have a type attribute!";
            throw new PersistenceException(errorMessage);
        }
        if (type.equalsIgnoreCase(USER_TYPE)) {
            type = "USER";
        } else if (type.equalsIgnoreCase(GROUP_TYPE)) {
            type = "GRUP";
        } else if (type.equalsIgnoreCase(ROLE_TYPE)) {
            type = "ROLE";
        } else if (type.equalsIgnoreCase(TEAM_TYPE)) {
            type = "TEAM";
        } else if (type.equalsIgnoreCase(ACCOUNT_TYPE)) {
            type = "UACC";
        } else if (type.equalsIgnoreCase(COMPANY_TYPE)) {
            type = "COMP";
        } else if (type.equalsIgnoreCase(PRINCIPAL_TYPE_WILDCARD)) {
            type = PRINCIPAL_TYPE_WILDCARD;
        } else if (type.length() != 4) {
            String errorMessage = "<principal> contains unsupported value (not 4 characters) in type attribute: " + type;
            throw new PersistenceException(errorMessage);
        }
        Element namespaces = this.getElementChildByName(principal, NAMESPACES);
        Element namespace = namespaces != null ? this.getFirstChildElement(namespaces) : this.getFirstChildElement(principal);
        DSPrincipalModel princ = new DSPrincipalModel(type);
        while (namespace != null) {
            if (!namespace.getNodeName().equalsIgnoreCase(NAMESPACE)) {
                String errorMessage = "Children of <principal> and <nameSpaces> have to be <nameSpace>";
                throw new PersistenceException(errorMessage);
            }
            this.handleResponsibleForNameSpace(type, namespace, princ);
            namespace = this.getNextSiblingElement(namespace);
        }
        if (!invers) {
            dsConf.setResponsibleFor(princ);
        } else {
            dsConf.setNotResponsibleFor(princ);
        }
        if (mTrace.bePath()) {
            mTrace.exiting("handleResponsibleForPrincipalDatabag", dsConf);
        }
    }

    private void handleResponsibleForNameSpace(String principalType, Element nameSpace, DSPrincipalModel princ) throws PersistenceException {
        String name;
        if (mTrace.bePath()) {
            mTrace.entering("handleResponsibleForNameSpace", new Object[]{principalType, nameSpace, princ});
        }
        if ((name = nameSpace.getAttribute("name")) != null && name.equalsIgnoreCase("")) {
            name = null;
        }
        if (name == null) {
            String errorMessage = "<nameSpace> must have a name attribute!";
            throw new PersistenceException(errorMessage);
        }
        Element attributes = this.getElementChildByName(nameSpace, ATTRIBUTES);
        Element attribute = attributes != null ? this.getFirstChildElement(attributes) : this.getFirstChildElement(nameSpace);
        DSNameSpaceModel namesp = new DSNameSpaceModel(name);
        while (attribute != null) {
            if (!attribute.getNodeName().equalsIgnoreCase(ATTRIBUTE)) {
                String errorMessage = "Children of <nameSpace> and <attributes> have to be <attribute>";
                throw new PersistenceException(errorMessage);
            }
            this.handleResponsibleForAttribute(principalType, name, attribute, namesp);
            attribute = this.getNextSiblingElement(attribute);
        }
        princ.setNameSpace(namesp);
        if (mTrace.bePath()) {
            mTrace.exiting("handleResponsibleForNameSpace", princ);
        }
    }

    private void handleResponsibleForAttribute(String principalType, String nameSpace, Element attribute, DSNameSpaceModel namesp) throws PersistenceException {
        String name;
        if (mTrace.bePath()) {
            mTrace.entering("handleResponsibleForAttribute", new Object[]{principalType, nameSpace, attribute, namesp});
        }
        if ((name = attribute.getAttribute("name")) != null && name.equalsIgnoreCase("")) {
            name = null;
        }
        if (name == null) {
            String errorMessage = "<attribute> must have a name attribute!";
            throw new PersistenceException(errorMessage);
        }
        int attrType = 0;
        String type = attribute.getAttribute("type");
        if (type != null) {
            if (type.equalsIgnoreCase(ATTRIBUTE_STRING_TYPE)) {
                attrType = 1;
            } else if (type.equalsIgnoreCase(ATTRIBUTE_BLOB_TYPE)) {
                attrType = 2;
            }
        }
        String readonly = attribute.getAttribute(ATTRIBUTE_READONLY);
        boolean readonlyFlag = false;
        if (readonly != null) {
            readonlyFlag = readonly.equalsIgnoreCase(TRUE);
        }
        String cachingTime = attribute.getAttribute(ATTRIBUTE_CACHING_TIME);
        int cacheTimeInSeconds = -1;
        if (cachingTime != null) {
            try {
                cacheTimeInSeconds = Integer.parseInt(cachingTime);
            }
            catch (NumberFormatException nfex) {
                if (mTrace.beDebug()) {
                    mTrace.debugT("handleResponsibleForAttribute", nfex);
                }
                cacheTimeInSeconds = -1;
            }
        }
        DSAttributeModel attrib = new DSAttributeModel(name, attrType, readonlyFlag, cacheTimeInSeconds);
        String populateInitially = attribute.getAttribute(POPULATE_INITIALLY);
        if (populateInitially != null && populateInitially.equalsIgnoreCase(TRUE)) {
            attrib.setPopulateInitially(true);
        } else {
            attrib.setPopulateInitially(false);
        }
        namesp.setAttribute(attrib);
        if (mTrace.bePath()) {
            mTrace.exiting("handleResponsibleForAttribute", namesp);
        }
    }

    private void handleHomeFor(Element homeFor, DSConfigurationModel dsConf, boolean invers) throws PersistenceException {
        Element principals;
        Element principal;
        if (mTrace.bePath()) {
            mTrace.entering("handleHomeFor", new Object[]{homeFor, dsConf, new Boolean(invers)});
        }
        if ((principal = (principals = this.getElementChildByName(homeFor, PRINCIPALS)) != null ? this.getFirstChildElement(principals) : this.getFirstChildElement(homeFor)) != null) {
            while (principal != null) {
                if (!principal.getNodeName().equalsIgnoreCase(PRINCIPAL)) {
                    String errorMessage = "Children of <homeFor> and <principals> have to be <principal>";
                    throw new PersistenceException(errorMessage);
                }
                this.handleHomeForPrincipalDatabag(principal, dsConf, invers);
                principal = this.getNextSiblingElement(principal);
            }
        }
        if (mTrace.bePath()) {
            mTrace.exiting("handleHomeFor", dsConf);
        }
    }

    private void handleHomeForPrincipalDatabag(Element principal, DSConfigurationModel dsConf, boolean invers) throws PersistenceException {
        Element namespaces;
        String type;
        if (mTrace.bePath()) {
            mTrace.entering("handleHomeForPrincipalDatabag", new Object[]{principal, dsConf, new Boolean(invers)});
        }
        if ((type = principal.getAttribute("type")) != null && type.equalsIgnoreCase("")) {
            type = null;
        }
        if (type == null) {
            String errorMessage = "<principal> must have a type attribute!";
            throw new PersistenceException(errorMessage);
        }
        if (type.equalsIgnoreCase(USER_TYPE)) {
            type = "USER";
        } else if (type.equalsIgnoreCase(GROUP_TYPE)) {
            type = "GRUP";
        } else if (type.equalsIgnoreCase(ROLE_TYPE)) {
            type = "ROLE";
        } else if (type.equalsIgnoreCase(TEAM_TYPE)) {
            type = "TEAM";
        } else if (type.equalsIgnoreCase(ACCOUNT_TYPE)) {
            type = "UACC";
        } else if (type.equalsIgnoreCase(COMPANY_TYPE)) {
            type = "COMP";
        } else if (type.equalsIgnoreCase(PRINCIPAL_TYPE_WILDCARD)) {
            type = PRINCIPAL_TYPE_WILDCARD;
        } else if (type.length() != 4) {
            String errorMessage = "<principal> contains unsupported value (not 4 characters) in type attribute: " + type;
            throw new PersistenceException(errorMessage);
        }
        String priority = principal.getAttribute(PRINCIPAL_PRIORITY);
        int prio = 0;
        if (priority != null && !priority.equals("")) {
            try {
                prio = Integer.parseInt(priority);
                if (prio < 0 || prio > 9) {
                    String errorMessage = "<principal> contains unsupported value ([0-9]) in priority attribute: " + prio;
                    throw new PersistenceException(errorMessage);
                }
            }
            catch (NumberFormatException nfex) {
                String errorMessage = "<principal> contains unsupported value ([0-9]) in priority attribute: " + prio;
                throw new PersistenceException(errorMessage);
            }
        }
        Element namespace = (namespaces = this.getElementChildByName(principal, NAMESPACES)) != null ? this.getFirstChildElement(namespaces) : this.getFirstChildElement(principal);
        DSPrincipalModel princ = new DSPrincipalModel(type);
        princ.setPriority(prio);
        while (namespace != null) {
            if (!namespace.getNodeName().equalsIgnoreCase(NAMESPACE)) {
                String errorMessage = "Children of <principal> and <nameSpaces> have to be <nameSpace>";
                throw new PersistenceException(errorMessage);
            }
            this.handleHomeForNameSpace(type, namespace, princ);
            namespace = this.getNextSiblingElement(namespace);
        }
        if (!invers) {
            dsConf.setHomeFor(princ);
        } else {
            dsConf.setNotHomeFor(princ);
        }
        if (mTrace.bePath()) {
            mTrace.exiting("handleHomeForPrincipalDatabag", dsConf);
        }
    }

    private void handleHomeForNameSpace(String principalType, Element nameSpace, DSPrincipalModel princ) throws PersistenceException {
        String name;
        if (mTrace.bePath()) {
            mTrace.entering("handleHomeForNameSpace", new Object[]{principalType, nameSpace, princ});
        }
        if ((name = nameSpace.getAttribute("name")) != null && name.equalsIgnoreCase("")) {
            name = null;
        }
        if (name == null) {
            String errorMessage = "<nameSpace> must have a name attribute!";
            throw new PersistenceException(errorMessage);
        }
        Element attributes = this.getElementChildByName(nameSpace, ATTRIBUTES);
        Element attribute = attributes != null ? this.getFirstChildElement(attributes) : this.getFirstChildElement(nameSpace);
        DSNameSpaceModel namesp = new DSNameSpaceModel(name);
        while (attribute != null) {
            if (!attribute.getNodeName().equalsIgnoreCase(ATTRIBUTE)) {
                String errorMessage = "Children of <nameSpace> and <attributes> have to be <attribute>";
                throw new PersistenceException(errorMessage);
            }
            this.handleHomeForAttribute(principalType, name, attribute, namesp);
            attribute = this.getNextSiblingElement(attribute);
        }
        princ.setNameSpace(namesp);
        if (mTrace.bePath()) {
            mTrace.exiting("handleHomeForNameSpace", princ);
        }
    }

    private void handleHomeForAttribute(String principalType, String nameSpace, Element attribute, DSNameSpaceModel namesp) throws PersistenceException {
        String name;
        if (mTrace.bePath()) {
            mTrace.entering("handleHomeForAttribute", new Object[]{principalType, nameSpace, attribute, namesp});
        }
        if ((name = attribute.getAttribute("name")) != null && name.equalsIgnoreCase("")) {
            name = null;
        }
        if (name == null) {
            String errorMessage = "<attribute> must have a name attribute!";
            throw new PersistenceException(errorMessage);
        }
        Element values = this.getElementChildByName(attribute, VALUES);
        Element value = values != null ? this.getFirstChildElement(values) : this.getFirstChildElement(attribute);
        DSAttributeModel attrib = new DSAttributeModel(name, 0, false);
        while (value != null) {
            if (!value.getNodeName().equalsIgnoreCase(VALUE)) {
                String errorMessage = "Children of <attribute> and <values> have to be <value>";
                throw new PersistenceException(errorMessage);
            }
            this.handleHomeForValue(principalType, nameSpace, name, value, attrib);
            value = this.getNextSiblingElement(value);
        }
        namesp.setAttribute(attrib);
        if (mTrace.bePath()) {
            mTrace.exiting("handleHomeForAttribute", namesp);
        }
    }

    private void handleHomeForValue(String principalType, String nameSpace, String attributeName, Element value, DSAttributeModel attrib) throws PersistenceException {
        String val;
        if (mTrace.bePath()) {
            mTrace.entering("handleHomeForValue", new Object[]{principalType, nameSpace, attributeName, value, attrib});
        }
        if ((val = this.getElementContent(value)) == null) {
            String errorMessage = "Empty <value> found in configuration";
            throw new PersistenceException(errorMessage);
        }
        attrib.setValue(val);
        if (mTrace.bePath()) {
            mTrace.exiting("handleHomeForValue", attrib);
        }
    }

    protected String convertXMLToString(Element startNode) {
        StringBuffer strBuff = new StringBuffer();
        strBuff.append("<?xml version=\"1.0\" encoding=\"");
        strBuff.append(DEFAULT_ENCODING);
        strBuff.append("\"?>\n");
        this.serializeNodes(startNode, strBuff, 0);
        return strBuff.toString();
    }

    private String xmlEncode(String value) {
        StringBuffer nstr = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            switch (value.charAt(i)) {
                case '<': {
                    nstr.append("&lt;");
                    break;
                }
                case '>': {
                    nstr.append("&gt;");
                    break;
                }
                case '\"': {
                    nstr.append("&quot;");
                    break;
                }
                case '\'': {
                    nstr.append("&apos;");
                    break;
                }
                case '&': {
                    nstr.append("&amp;");
                    break;
                }
                default: {
                    nstr.append(value.charAt(i));
                }
            }
            ++i;
        }
        return nstr.toString();
    }

    private void serializeNodes(Node domNode, StringBuffer strBuff, int depth) {
        if (domNode instanceof Element) {
            NodeList nodeList;
            String content = domNode.getNodeValue();
            String tagName = domNode.getNodeName();
            int i = 0;
            while (i < depth) {
                strBuff.append("\t");
                ++i;
            }
            strBuff.append("<");
            strBuff.append(tagName);
            NamedNodeMap nodeAttributes = domNode.getAttributes();
            if (nodeAttributes != null) {
                int n = 0;
                while (n < nodeAttributes.getLength()) {
                    Node currentAttribute = nodeAttributes.item(n);
                    String attributeName = currentAttribute.getNodeName();
                    String attributeValue = currentAttribute.getNodeValue();
                    strBuff.append(" ");
                    strBuff.append(attributeName);
                    strBuff.append("=\"");
                    strBuff.append(this.xmlEncode(attributeValue));
                    strBuff.append("\"");
                    ++n;
                }
            }
            strBuff.append(">\n");
            if (content != null) {
                int i2 = 0;
                while (i2 < depth + 1) {
                    strBuff.append("\t");
                    ++i2;
                }
                strBuff.append("<![CDATA[");
                strBuff.append(content);
                strBuff.append("]]>");
            }
            if ((nodeList = domNode.getChildNodes()) != null) {
                int i3 = 0;
                while (i3 < nodeList.getLength()) {
                    Node currentNode = nodeList.item(i3);
                    this.serializeNodes(currentNode, strBuff, depth + 1);
                    ++i3;
                }
            }
            int i4 = 0;
            while (i4 < depth) {
                strBuff.append("\t");
                ++i4;
            }
            strBuff.append("</" + tagName + ">\n");
        } else if (domNode instanceof Text) {
            int i = 0;
            while (i < depth) {
                strBuff.append("\t");
                ++i;
            }
            String content = domNode.getNodeValue();
            strBuff.append("<![CDATA[");
            strBuff.append(content);
            strBuff.append("]]>\n");
        }
    }

    private Element getFirstChildElement(Node node) {
        if (node != null) {
            if ((node = node.getFirstChild()) == null) {
                return null;
            }
            if (node.getNodeType() == 1) {
                return (Element)node;
            }
            return this.getNextSiblingElement(node);
        }
        return null;
    }

    private Element getNextSiblingElement(Node node) {
        if (node != null) {
            while ((node = node.getNextSibling()) != null && node.getNodeType() != 1) {
            }
            return (Element)node;
        }
        return null;
    }

    private Element getElementChildByName(Node node, String name) {
        Element element = this.getFirstChildElement(node);
        String nodeName = null;
        while (!(element == null || (nodeName = element.getNodeName()) != null && nodeName.equals(name))) {
            element = this.getNextSiblingElement(element);
        }
        return element;
    }

    protected String getElementChildContentByName(Node node, String name) {
        Node child;
        Element element = this.getElementChildByName(node, name);
        if (element != null && (child = element.getFirstChild()) != null && (child.getNodeType() == 3 || child.getNodeType() == 4)) {
            return ((Text)child).getData();
        }
        return null;
    }

    private String getElementContent(Element element) {
        Node child;
        if (element != null && (child = element.getFirstChild()) != null && (child.getNodeType() == 3 || child.getNodeType() == 4)) {
            return ((Text)child).getData();
        }
        return null;
    }

    protected String createOpenXMLTag(int level, String tagName, String[] attributes, String[] values) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < level) {
            result.append("\t");
            ++i;
        }
        result.append("<");
        result.append(tagName);
        if (attributes != null) {
            int size = attributes.length;
            int i2 = 0;
            while (i2 < size) {
                result.append(" ");
                result.append(attributes[i2]);
                result.append("=\"");
                if (values != null) {
                    result.append(values[i2]);
                }
                result.append("\"");
                ++i2;
            }
        }
        result.append(">\n");
        return result.toString();
    }

    protected String createXMLTagContent(int level, String value, boolean cdata) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < level) {
            result.append("\t");
            ++i;
        }
        if (cdata) {
            result.append("<![CDATA[");
        }
        result.append(value);
        if (cdata) {
            result.append("]]>");
        }
        result.append("\n");
        return result.toString();
    }

    protected String createCloseXMLTag(int level, String tagName) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < level) {
            result.append("\t");
            ++i;
        }
        result.append("</");
        result.append(tagName);
        result.append(">\n");
        return result.toString();
    }

    protected boolean isWhiteSpaceChar(char ch) {
        return ch == ' ' || ch == '\r' || ch == '\n' || ch == '\t';
    }

    protected String trimWhiteSpace(String data) {
        if (data == null) {
            return "";
        }
        int b = 0;
        while (b < data.length() && this.isWhiteSpaceChar(data.charAt(b))) {
            ++b;
        }
        int e = data.length() - 1;
        while (e > 0 && e > b && this.isWhiteSpaceChar(data.charAt(e))) {
            --e;
        }
        data = data.substring(b, e + 1);
        return data;
    }

    private class SecutityDTDResolver
    implements EntityResolver {
        private InputStream mIs;

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            this.mIs = UMFactory.getProperties().getInputStream(systemId);
            if (this.mIs == null) {
                return null;
            }
            InputSource source = new InputSource(this.mIs);
            source.setSystemId(systemId);
            return source;
        }

        public void closeStream() throws IOException {
            if (this.mIs != null) {
                this.mIs.close();
            }
        }
    }
}

