/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp;

import com.sap.security.api.IUserMaint;
import com.sap.security.api.NoSuchUserException;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.persistence.IInternalPrincipalDatabag;
import com.sap.security.core.persistence.IInternalPrincipalDatabagMaint;
import com.sap.security.core.persistence.IPrincipalDatabag;
import com.sap.security.core.persistence.datasource.IDataSource;
import com.sap.security.core.persistence.datasource.IDataSourceTransaction;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.datasource.imp.CompanyGroups;
import com.sap.security.core.persistence.imp.PrincipalDatabagFactory;
import com.sap.security.core.persistence.imp.SearchCriteria;
import com.sap.security.core.util.IUMTrace;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CompanyGroupsTransaction
implements IDataSourceTransaction {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/CompanyGroupsTransaction.java#2 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)";
    public static final IUMTrace mTrace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/CompanyGroupsTransaction.java#2 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)");
    private IDataSource mDatasource;
    private Hashtable mUsersToClear;
    private Hashtable mUsersToAdd;
    private Vector mDeleteAllUsers;

    public CompanyGroupsTransaction(IDataSource datasource) {
        this.mDatasource = datasource;
        this.mDeleteAllUsers = new Vector();
    }

    public void createPrincipalDatabag(IInternalPrincipalDatabag principal) throws PersistenceException {
        String[] idParts;
        if (principal != null && (idParts = principal.getIDParts())[0].equals("GRUP") && CompanyGroups.isCompanyGroupDatasource(idParts[1])) {
            throw new PersistenceException("Group " + principal.getUniqueID() + " of company " + idParts[2] + " cannot be created.");
        }
    }

    public void deletePrincipalDatabag(IPrincipalDatabag principal) throws PersistenceException {
        String[] idParts;
        if (principal != null && (idParts = principal.getIDParts())[0].equals("GRUP") && CompanyGroups.isCompanyGroupDatasource(idParts[1])) {
            throw new PersistenceException("Group " + principal.getUniqueID() + " of company " + idParts[2] + " cannot be deleted.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updatePrincipalDatabag(IInternalPrincipalDatabagMaint principalMaint) throws PersistenceException {
        Vector values;
        String attribute;
        String namespace;
        String[] idParts;
        String id;
        if (principalMaint == null || (id = principalMaint.getUniqueID()) == null || !(idParts = principalMaint.getIDParts())[0].equals("GRUP") || !CompanyGroups.isCompanyGroupDatasource(idParts[1])) return;
        if (this.mUsersToAdd == null) {
            this.mUsersToAdd = new Hashtable();
        }
        if (this.mUsersToClear == null) {
            this.mUsersToClear = new Hashtable();
        }
        String companyID = idParts[2];
        Enumeration en = principalMaint.getNameSpaces(2);
        while (en.hasMoreElements()) {
            namespace = (String)en.nextElement();
            Enumeration en2 = principalMaint.getAttributesOnNamespace(namespace, 2);
            while (en2.hasMoreElements()) {
                attribute = (String)en2.nextElement();
                if (namespace.equals("com.sap.security.core.usermanagement.relation")) {
                    if (!attribute.equals("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE")) throw new PersistenceException("Attribute " + attribute + " on namespace " + namespace + " of group " + id + " of company " + idParts[2] + " cannot be modified.");
                    values = principalMaint.getAttributeValues(namespace, attribute, 2);
                    if (!this.mDeleteAllUsers.contains(companyID)) {
                        this.mDeleteAllUsers.add(companyID);
                    }
                    if (values == null) continue;
                    Vector dummy = (Vector)this.mUsersToAdd.get(companyID);
                    if (dummy == null) {
                        dummy = new Vector();
                    }
                    int size = values.size();
                    int i = 0;
                    while (i < size) {
                        if (!(values.elementAt(i) instanceof String)) throw new PersistenceException(values.elementAt(i) + " is not a unique ID of a user!");
                        if (!((String)values.elementAt(i)).startsWith("USER")) throw new PersistenceException(values.elementAt(i) + " is not a unique ID of a user!");
                        if (!dummy.contains(values.elementAt(i))) {
                            dummy.add(values.elementAt(i));
                        }
                        ++i;
                    }
                    this.mUsersToAdd.put(companyID, dummy);
                    continue;
                }
                if (attribute.equals("PRINCIPAL_MODIFY_DATE") || !namespace.equals("com.sap.security.core.usermanagement")) continue;
                throw new PersistenceException("Attributes on namespace " + namespace + " of group " + id + " of company " + idParts[2] + " cannot be modified.");
            }
        }
        Enumeration en2 = principalMaint.getNameSpaces(3);
        while (en2.hasMoreElements()) {
            namespace = (String)en2.nextElement();
            Enumeration en22 = principalMaint.getAttributesOnNamespace(namespace, 3);
            while (en22.hasMoreElements()) {
                attribute = (String)en22.nextElement();
                if (namespace.equals("com.sap.security.core.usermanagement.relation")) {
                    if (!attribute.equals("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE")) throw new PersistenceException("Attribute " + attribute + " on namespace " + namespace + " of group " + id + " of company " + idParts[2] + " cannot be modified.");
                    if (!this.mDeleteAllUsers.contains(companyID)) {
                        this.mDeleteAllUsers.add(companyID);
                    }
                    this.mUsersToAdd.put(companyID, new Vector());
                    this.mUsersToClear.put(companyID, new Vector());
                    continue;
                }
                if (attribute.equals("PRINCIPAL_MODIFY_DATE") || !namespace.equals("com.sap.security.core.usermanagement")) continue;
                throw new PersistenceException("Attributes on namespace " + namespace + " of group " + id + " of company " + idParts[2] + " cannot be modified.");
            }
        }
        Enumeration en3 = principalMaint.getNameSpaces(0);
        while (en3.hasMoreElements()) {
            namespace = (String)en3.nextElement();
            Enumeration en23 = principalMaint.getAttributesOnNamespace(namespace, 0);
            while (en23.hasMoreElements()) {
                attribute = (String)en23.nextElement();
                if (namespace.equals("com.sap.security.core.usermanagement.relation")) {
                    if (!attribute.equals("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE")) throw new PersistenceException("Attribute " + attribute + " on namespace " + namespace + " of group " + id + " of company " + idParts[2] + " cannot be modified.");
                    values = principalMaint.getAttributeValues(namespace, attribute, 0);
                    if (values == null) continue;
                    Vector dummy = (Vector)this.mUsersToAdd.get(companyID);
                    if (dummy == null) {
                        dummy = new Vector();
                    }
                    int size = values.size();
                    int i = 0;
                    while (i < size) {
                        if (!(values.elementAt(i) instanceof String)) throw new PersistenceException(values.elementAt(i) + " is not a unique ID of a user!");
                        if (!((String)values.elementAt(i)).startsWith("USER")) throw new PersistenceException(values.elementAt(i) + " is not a unique ID of a user!");
                        if (!dummy.contains(values.elementAt(i))) {
                            dummy.add(values.elementAt(i));
                        }
                        ++i;
                    }
                    this.mUsersToAdd.put(companyID, dummy);
                    continue;
                }
                if (attribute.equals("PRINCIPAL_MODIFY_DATE") || !namespace.equals("com.sap.security.core.usermanagement")) continue;
                throw new PersistenceException("Attributes on namespace " + namespace + " of group " + id + " of company " + idParts[2] + " cannot be modified.");
            }
        }
        Enumeration en4 = principalMaint.getNameSpaces(1);
        while (en4.hasMoreElements()) {
            namespace = (String)en4.nextElement();
            Enumeration en24 = principalMaint.getAttributesOnNamespace(namespace, 1);
            while (en24.hasMoreElements()) {
                attribute = (String)en24.nextElement();
                if (namespace.equals("com.sap.security.core.usermanagement.relation")) {
                    if (!attribute.equals("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE")) throw new PersistenceException("Attribute " + attribute + " on namespace " + namespace + " of group " + id + " of company " + idParts[2] + " cannot be modified.");
                    values = principalMaint.getAttributeValues(namespace, attribute, 1);
                    if (values == null) continue;
                    Vector dummy = (Vector)this.mUsersToClear.get(companyID);
                    if (dummy == null) {
                        dummy = new Vector();
                    }
                    int size = values.size();
                    int i = 0;
                    while (i < size) {
                        if (!(values.elementAt(i) instanceof String)) throw new PersistenceException(values.elementAt(i) + " is not a unique ID of a user!");
                        if (!((String)values.elementAt(i)).startsWith("USER")) throw new PersistenceException(values.elementAt(i) + " is not a unique ID of a user!");
                        if (!dummy.contains(values.elementAt(i))) {
                            dummy.add(values.elementAt(i));
                        }
                        ++i;
                    }
                    this.mUsersToClear.put(companyID, dummy);
                    continue;
                }
                if (attribute.equals("PRINCIPAL_MODIFY_DATE") || !namespace.equals("com.sap.security.core.usermanagement")) continue;
                throw new PersistenceException("Attributes on namespace " + namespace + " of group " + id + " of company " + idParts[2] + " cannot be modified.");
            }
        }
    }

    public void commit() throws PersistenceException {
        int i;
        String companyID;
        Enumeration en;
        IUserMaint dummy;
        SearchCriteria sc = new SearchCriteria(true, "USER");
        int size = this.mDeleteAllUsers.size();
        int j = 0;
        while (j < size) {
            if (!((String)this.mDeleteAllUsers.elementAt(j)).equals("GUEST_USERS_COMPANY")) {
                sc.addEqualsElement("com.sap.security.core.usermanagement", "company", (String)this.mDeleteAllUsers.elementAt(j), true);
            }
            ++j;
        }
        Vector usersOfThisCompany = PrincipalDatabagFactory.getInstance().searchPrincipalDatabags(sc);
        size = usersOfThisCompany.size();
        int i2 = 0;
        while (i2 < size) {
            try {
                dummy = UMFactory.getUserFactory().getMutableUser((String)usersOfThisCompany.elementAt(i2));
                dummy.setCompany("");
                dummy.commit();
            }
            catch (NoSuchUserException nsuex) {
                if (mTrace.beDebug()) {
                    mTrace.debugT("commit", nsuex);
                }
            }
            catch (UMException umex) {
                throw new PersistenceException(umex);
            }
            ++i2;
        }
        if (this.mUsersToAdd != null) {
            en = this.mUsersToAdd.keys();
            while (en.hasMoreElements()) {
                companyID = (String)en.nextElement();
                Vector usersToAdd = (Vector)this.mUsersToAdd.get(companyID);
                if (usersToAdd == null) continue;
                size = usersToAdd.size();
                i = 0;
                while (i < size) {
                    try {
                        dummy = UMFactory.getUserFactory().getMutableUser((String)usersToAdd.elementAt(i));
                        if (!companyID.equals("GUEST_USERS_COMPANY")) {
                            dummy.setCompany(companyID);
                        } else {
                            dummy.setCompany("");
                        }
                        dummy.commit();
                    }
                    catch (NoSuchUserException nsuex) {
                        if (mTrace.beDebug()) {
                            mTrace.debugT("commit", nsuex);
                        }
                    }
                    catch (UMException umex) {
                        throw new PersistenceException(umex);
                    }
                    ++i;
                }
            }
        }
        if (this.mUsersToClear != null) {
            en = this.mUsersToClear.keys();
            while (en.hasMoreElements()) {
                Vector usersToClear;
                companyID = (String)en.nextElement();
                if (companyID.equals("GUEST_USERS_COMPANY") || (usersToClear = (Vector)this.mUsersToClear.get(companyID)) == null) continue;
                size = usersToClear.size();
                i = 0;
                while (i < size) {
                    try {
                        dummy = UMFactory.getUserFactory().getMutableUser((String)usersToClear.elementAt(i));
                        dummy.setCompany("");
                        dummy.commit();
                    }
                    catch (NoSuchUserException nsuex) {
                        if (mTrace.beDebug()) {
                            mTrace.debugT("commit", nsuex);
                        }
                    }
                    catch (UMException umex) {
                        throw new PersistenceException(umex);
                    }
                    ++i;
                }
            }
        }
    }

    public void rollback() {
        this.mUsersToAdd = null;
        this.mUsersToClear = null;
        this.mDeleteAllUsers = new Vector();
    }

    public boolean bindNewPrincipalDatabag(IInternalPrincipalDatabag principal) throws PersistenceException {
        return false;
    }
}

