/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.persistence.datasource.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.ISearchAttribute;
import com.sap.security.api.IUser;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.imp.GroupFactory;
import com.sap.security.core.persistence.IInternalPrincipalDatabag;
import com.sap.security.core.persistence.IPrincipalDatabag;
import com.sap.security.core.persistence.datasource.IDataSource;
import com.sap.security.core.persistence.datasource.IDataSourceTransaction;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.datasource.imp.CompanyGroupsTransaction;
import com.sap.security.core.persistence.datasource.imp.DSAttributeModel;
import com.sap.security.core.persistence.datasource.imp.DSConfigurationModel;
import com.sap.security.core.persistence.datasource.imp.DSNameSpaceModel;
import com.sap.security.core.persistence.datasource.imp.DSPrincipalModel;
import com.sap.security.core.persistence.datasource.imp.DataSourceBaseImplementation;
import com.sap.security.core.persistence.imp.PrincipalDatabagFactory;
import com.sap.security.core.persistence.imp.SearchCriteria;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.imp.Util;
import com.sapmarkets.tpd.TradingPartnerDirectoryCommon;
import com.sapmarkets.tpd.master.AddressInterface;
import com.sapmarkets.tpd.master.PartnerID;
import com.sapmarkets.tpd.master.TradingPartnerDirectoryInterface;
import com.sapmarkets.tpd.master.TradingPartnerInterface;
import com.sapmarkets.tpd.util.TpdException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class CompanyGroups
extends DataSourceBaseImplementation
implements IDataSource {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/CompanyGroups.java#2 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)";
    private static IUMTrace mTrace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/persistence/datasource/imp/CompanyGroups.java#2 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)");
    private static final String IMPLEMENTATION_CLASS = "com.sap.security.core.persistence.datasource.imp.CompanyGroups";
    public static final String DISPLAYNAME_TEMPLATE = "ume.company_groups.displayname_template";
    public static final String GUEST_COMPANY_ENABLED = "ume.company_groups.guestusercompany_enabled";
    public static final String GUEST_COMPANY_NAME = "ume.company_groups.guestusercompany_name";
    public static final String COMPANY_GROUPS_ENABLED = "ume.company_groups.enabled";
    public static final String DEFAULT_DISPLAYNAME_TEMPLATE = "{companyName} ({companyID})";
    public static final String DESCRIPTION_TEMPLATE = "ume.company_groups.description_template";
    public static final String DEFAULT_DESCRIPTION_TEMPLATE = "Company {companyName}";
    public static final String COMPANY_ATTRIBUTE = "company";
    private static final String mID = "COMPANY_GROUPS_DATASOURCE";
    public static final String DATASOURCE_ID = "COMPANY_GROUPS_DATASOURCE";
    public static final String GUEST_COMPANY_GROUP_ID = "GUEST_USERS_COMPANY";
    public static final String GUEST_COMPANY_GROUP_NAME = "Guest Users";
    private static final String mDisplayName = "Built-in Company Groups Adapter";
    private TradingPartnerDirectoryInterface mTradingPartnerDirectory;

    public String getId() {
        return "COMPANY_GROUPS_DATASOURCE";
    }

    public void init(DSConfigurationModel dsConf) throws PersistenceException {
        DSConfigurationModel newConfig = new DSConfigurationModel("COMPANY_GROUPS_DATASOURCE", IMPLEMENTATION_CLASS, false, true, mDisplayName);
        DSPrincipalModel principalModel1 = new DSPrincipalModel("GRUP");
        DSNameSpaceModel namespaceModel1 = new DSNameSpaceModel("com.sap.security.core.usermanagement");
        DSAttributeModel attributeModel1 = new DSAttributeModel("uniquename", 1, true);
        DSAttributeModel attributeModel2 = new DSAttributeModel("description", 1, true);
        DSAttributeModel attributeModel3 = new DSAttributeModel("displayname", 1, true);
        DSAttributeModel attributeModel4 = new DSAttributeModel(COMPANY_ATTRIBUTE, 1, true);
        DSAttributeModel attributeModel5 = new DSAttributeModel("PRINCIPAL_CREATION_DATE", 1, true);
        DSAttributeModel attributeModel6 = new DSAttributeModel("PRINCIPAL_MODIFY_DATE", 1, false);
        namespaceModel1.setAttribute(attributeModel1);
        namespaceModel1.setAttribute(attributeModel2);
        namespaceModel1.setAttribute(attributeModel3);
        namespaceModel1.setAttribute(attributeModel4);
        namespaceModel1.setAttribute(attributeModel5);
        namespaceModel1.setAttribute(attributeModel6);
        DSNameSpaceModel namespaceModel2 = new DSNameSpaceModel("com.sap.security.core.usermanagement.relation");
        DSAttributeModel attributeModel7 = new DSAttributeModel("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", 1, false);
        namespaceModel2.setAttribute(attributeModel7);
        principalModel1.setNameSpace(namespaceModel1);
        principalModel1.setNameSpace(namespaceModel2);
        newConfig.setResponsibleFor(principalModel1);
        super.init(newConfig);
        this.mTradingPartnerDirectory = TradingPartnerDirectoryCommon.getTPD();
        this.isInitialized = true;
    }

    public boolean checkCredentials(Hashtable credentials) {
        return false;
    }

    protected String getPrivateIDPart(IPrincipalDatabag principal) throws PersistenceException {
        return "SUPER_GROUP_PRIVATE_PART";
    }

    public IInternalPrincipalDatabag[] initPrincipalDatabags(IInternalPrincipalDatabag[] principals) throws PersistenceException {
        int length = principals.length;
        int i = 0;
        while (i < length) {
            if (principals[i] != null) {
                this.populatePrincipalDatabag(principals[i], null);
            }
            ++i;
        }
        return principals;
    }

    public void populatePrincipalDatabags(IInternalPrincipalDatabag[] principals, AttributeList populateAttributes) throws PersistenceException {
        principals = this.initPrincipalDatabags(principals);
    }

    public boolean populatePrincipalDatabag(IInternalPrincipalDatabag principal, String nameSpace, String attribute) throws PersistenceException {
        if (principal != null) {
            try {
                String[] idParts = principal.getIDParts();
                String type = idParts[0];
                String datasourceID = idParts[1];
                String companyID = idParts[2];
                if (type.equals("GRUP") && datasourceID.equals("COMPANY_GROUPS_DATASOURCE")) {
                    TradingPartnerEnumeration en = new TradingPartnerEnumeration();
                    while (en.hasMoreElements()) {
                        TradingPartnerInterface partnerId = (TradingPartnerInterface)en.nextElement();
                        if (partnerId == null || !companyID.equals(partnerId.getId())) continue;
                        String partnerName = partnerId.getName();
                        principal.setAttributeValues("com.sap.security.core.usermanagement", "uniquename", this.convertToVector(partnerId.getId()));
                        String description = this.calculateTemplate(partnerId.getId(), partnerName, UMFactory.getProperties().get(DESCRIPTION_TEMPLATE, DEFAULT_DESCRIPTION_TEMPLATE));
                        if (description == null) {
                            description = partnerId.getId();
                        }
                        principal.setAttributeValues("com.sap.security.core.usermanagement", "description", this.convertToVector(description));
                        String displayName = this.calculateTemplate(partnerId.getId(), partnerName, UMFactory.getProperties().get(DISPLAYNAME_TEMPLATE, DEFAULT_DISPLAYNAME_TEMPLATE));
                        if (displayName == null) {
                            displayName = partnerId.getId();
                        }
                        principal.setAttributeValues("com.sap.security.core.usermanagement", "displayname", this.convertToVector(displayName));
                        String now = Util.getTimeStamp();
                        principal.setAttributeValues("com.sap.security.core.usermanagement", "PRINCIPAL_CREATION_DATE", this.convertToVector(now));
                        principal.setAttributeValues("com.sap.security.core.usermanagement", "PRINCIPAL_MODIFY_DATE", this.convertToVector(now));
                        principal.setAttributeValues("com.sap.security.core.usermanagement", COMPANY_ATTRIBUTE, this.convertToVector(partnerId.getId()));
                        if (principal.getAttributeValues(nameSpace, attribute) == null) {
                            principal.setAttributeValues(nameSpace, attribute, new Vector());
                        }
                        if (nameSpace.equals("com.sap.security.core.usermanagement.relation") && attribute.equals("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE")) {
                            SearchCriteria sc = new SearchCriteria("USER");
                            if (idParts[2].equals(GUEST_COMPANY_GROUP_ID)) {
                                sc.addEqualsElement("com.sap.security.core.usermanagement", COMPANY_ATTRIBUTE, "", true);
                            } else {
                                sc.addEqualsElement("com.sap.security.core.usermanagement", COMPANY_ATTRIBUTE, idParts[2], true);
                            }
                            Vector res = PrincipalDatabagFactory.getInstance().searchPrincipalDatabags(sc);
                            if (res != null) {
                                principal.setAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", res);
                            }
                        }
                        if (principal.getIDParts()[1].equals(this.getId())) {
                            principal.setExists(true);
                        }
                        return true;
                    }
                }
            }
            catch (TpdException tpdex) {
                throw new PersistenceException(tpdex);
            }
        }
        return false;
    }

    public static boolean isCompanyGroupDatasource(String dataSourceID) {
        return dataSourceID.equals("COMPANY_GROUPS_DATASOURCE");
    }

    public IDataSourceTransaction beginTransaction() {
        return new CompanyGroupsTransaction(this);
    }

    public boolean principalDatabagExists(IPrincipalDatabag principal) throws PersistenceException {
        boolean exists = false;
        if (principal != null) {
            try {
                String[] idParts = principal.getIDParts();
                String type = idParts[0];
                String datasourceID = idParts[1];
                String companyID = idParts[2];
                if (type.equals("GRUP") && datasourceID.equals("COMPANY_GROUPS_DATASOURCE")) {
                    TradingPartnerEnumeration en = new TradingPartnerEnumeration();
                    while (en.hasMoreElements()) {
                        TradingPartnerInterface partnerId = (TradingPartnerInterface)en.nextElement();
                        if (partnerId == null || !companyID.equals(partnerId.getId())) continue;
                        return true;
                    }
                }
            }
            catch (TpdException tpdex) {
                throw new PersistenceException(tpdex);
            }
        }
        return exists;
    }

    public static void invalidateCompanyGroup(String companyID) {
        if (companyID != null && !companyID.equals("")) {
            StringBuffer newID = new StringBuffer();
            newID.append("GRUP");
            newID.append(".");
            newID.append("COMPANY_GROUPS_DATASOURCE");
            newID.append(".");
            newID.append(companyID);
            GroupFactory.invalidateGroupInCache(companyID);
        }
    }

    public Vector searchPrincipalDatabags(SearchCriteria criteria) throws PersistenceException {
        String methodName = "searchPrincipalDatabags";
        String type = criteria.getPrincipalType();
        SearchCriteria newSc = new SearchCriteria(criteria.isOrMode(), type);
        int size = criteria.getElementSize();
        boolean notResponsibleAttributeFound = false;
        Vector<Object> userIds = new Vector<Object>();
        int i = 0;
        while (i < size && (criteria.isOrMode() || !notResponsibleAttributeFound)) {
            block23: {
                String attribute;
                ISearchAttribute se;
                block24: {
                    se = criteria.getAttribute(i);
                    String namespace = se.getAttributeNameSpace();
                    attribute = se.getAttributeName();
                    Object attributeValue = se.getAttributeValue();
                    if (namespace.equals("com.sap.security.core.usermanagement.relation") && attribute.equals("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE") && ((String)attributeValue).startsWith("USER")) {
                        userIds.add(attributeValue);
                    }
                    if (!type.equals("GRUP")) break block23;
                    if ((!namespace.equals("com.sap.security.core.usermanagement") || !attribute.equals("description") && !attribute.equals("displayname") && !attribute.equals(COMPANY_ATTRIBUTE) && !attribute.equals("uniquename")) && (!namespace.equals("com.sap.security.core.usermanagement.relation") || !attribute.equals("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE") || !((String)attributeValue).startsWith("USER"))) break block24;
                    int operatore = se.getOperator();
                    switch (operatore) {
                        case 0: {
                            newSc.addEqualsElement(namespace, attribute, se.getAttributeValue(), se.isCaseSensitive());
                            break block23;
                        }
                        case 1: {
                            newSc.addLikeElement(namespace, attribute, se.getAttributeValue(), se.isCaseSensitive());
                            break block23;
                        }
                        case 2: {
                            newSc.addGreaterThanElement(namespace, attribute, se.getAttributeValue(), se.isCaseSensitive());
                            break block23;
                        }
                        case 3: {
                            newSc.addLessThanElement(namespace, attribute, se.getAttributeValue(), se.isCaseSensitive());
                            break block23;
                        }
                        default: {
                            throw new PersistenceException("Unknown search operator!");
                        }
                    }
                }
                if (se.getAttributeValue() != null && !attribute.equals("PRINCIPAL_TYPE_ATTRIBUTE")) {
                    notResponsibleAttributeFound = true;
                }
            }
            ++i;
        }
        if (!criteria.isOrMode() && notResponsibleAttributeFound) {
            return null;
        }
        Vector<String> result = new Vector<String>();
        if (type.equals("GRUP")) {
            if (newSc.getElementSize() == 1) {
                return null;
            }
            int size2 = userIds.size();
            String[] companyIds = new String[size2];
            int i2 = 0;
            while (i2 < size2) {
                try {
                    IUser dummy = UMFactory.getUserFactory().getUser((String)userIds.elementAt(i2));
                    String companyID = dummy.getCompany();
                    companyIds[i2] = companyID != null ? (companyID.equals("") ? GUEST_COMPANY_GROUP_ID : companyID) : null;
                }
                catch (UMException umex) {
                    throw new PersistenceException(umex);
                }
                ++i2;
            }
            try {
                TradingPartnerEnumeration en = new TradingPartnerEnumeration();
                while (en.hasMoreElements()) {
                    String displayName;
                    TradingPartnerInterface partnerId = (TradingPartnerInterface)en.nextElement();
                    if (partnerId == null) continue;
                    String partnerName = partnerId.getName();
                    String description = this.calculateTemplate(partnerId.getId(), partnerName, UMFactory.getProperties().get(DESCRIPTION_TEMPLATE, DEFAULT_DESCRIPTION_TEMPLATE));
                    if (description == null) {
                        description = partnerId.getId();
                    }
                    if ((displayName = this.calculateTemplate(partnerId.getId(), partnerName, UMFactory.getProperties().get(DISPLAYNAME_TEMPLATE, DEFAULT_DISPLAYNAME_TEMPLATE))) == null) {
                        displayName = partnerId.getId();
                    }
                    Properties p = new Properties();
                    ((Hashtable)p).put("com.sap.security.core.usermanagement.description", new String[]{description});
                    ((Hashtable)p).put("com.sap.security.core.usermanagement.displayname", new String[]{displayName});
                    ((Hashtable)p).put("com.sap.security.core.usermanagement.uniquename", new String[]{partnerId.getId()});
                    ((Hashtable)p).put("com.sap.security.core.usermanagement.company", new String[]{partnerId.getId()});
                    Vector userMembers = new Vector();
                    int i3 = 0;
                    while (i3 < size2) {
                        if (companyIds[i3] != null && companyIds[i3].equals(partnerId.getId())) {
                            userMembers.add(userIds.elementAt(i3));
                        }
                        ++i3;
                    }
                    ((Hashtable)p).put("com.sap.security.core.usermanagement.relation.PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", userMembers.toArray(new String[userMembers.size()]));
                    if (!this.objectMatchesSearch(p, newSc)) continue;
                    StringBuffer newID = new StringBuffer();
                    newID.append("GRUP");
                    newID.append(".");
                    newID.append("COMPANY_GROUPS_DATASOURCE");
                    newID.append(".");
                    newID.append(partnerId.getId());
                    String uniqueID = newID.toString();
                    if (uniqueID.length() > 255) {
                        if (!mTrace.beWarning()) continue;
                        mTrace.warningT(methodName, "Unique ID of group \"" + uniqueID + "\" is longer than the maximum " + 255 + " therefore this group will not be returned as result though it matches the search criteria.");
                        continue;
                    }
                    result.add(uniqueID);
                }
            }
            catch (TpdException tpdex) {
                throw new PersistenceException(tpdex);
            }
            return result;
        }
        return null;
    }

    private boolean objectMatchesSearch(Properties object, SearchCriteria criteria) throws PersistenceException {
        if (object == null) {
            return false;
        }
        int size = criteria.getElementSize();
        boolean orMode = criteria.isOrMode();
        if (orMode) {
            boolean found = false;
            int counter = 0;
            while (!found && counter < size) {
                ISearchAttribute se = criteria.getAttribute(counter);
                if (!se.getAttributeNameSpace().equals("com.sap.security.core.usermanagement") || !se.getAttributeName().equals("PRINCIPAL_TYPE_ATTRIBUTE")) {
                    if (se.getAttributeValue() != null) {
                        found = this.objectMatchesSearchElement(object, se);
                    } else {
                        SearchCriteria searchC = new SearchCriteria(criteria.getPrincipalType());
                        searchC.addLikeElement(se.getAttributeNameSpace(), se.getAttributeName(), "*", se.isCaseSensitive());
                        searchC.addEqualsElement(se.getAttributeNameSpace(), se.getAttributeName(), new byte[0], se.isCaseSensitive());
                        found = !this.objectMatchesSearchElement(object, searchC.getAttribute(0)) && !this.objectMatchesSearchElement(object, searchC.getAttribute(1));
                    }
                }
                ++counter;
            }
            return found;
        }
        boolean allMatched = true;
        int counter = 0;
        while (allMatched && counter < size) {
            ISearchAttribute se = criteria.getAttribute(counter);
            if (!se.getAttributeNameSpace().equals("com.sap.security.core.usermanagement") || !se.getAttributeName().equals("PRINCIPAL_TYPE_ATTRIBUTE")) {
                if (se.getAttributeValue() != null) {
                    allMatched = allMatched && this.objectMatchesSearchElement(object, se);
                } else {
                    SearchCriteria searchC = new SearchCriteria(criteria.getPrincipalType());
                    searchC.addLikeElement(se.getAttributeNameSpace(), se.getAttributeName(), "*", se.isCaseSensitive());
                    searchC.addEqualsElement(se.getAttributeNameSpace(), se.getAttributeName(), new byte[0], se.isCaseSensitive());
                    allMatched = allMatched && !this.objectMatchesSearchElement(object, searchC.getAttribute(0)) && !this.objectMatchesSearchElement(object, searchC.getAttribute(1));
                }
            } else if (criteria.getElementSize() == 1) {
                return false;
            }
            ++counter;
        }
        return allMatched;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private boolean objectMatchesSearchElement(Properties p, ISearchAttribute se) throws PersistenceException {
        o = se.getAttributeValue();
        caseSensitive = se.isCaseSensitive();
        header = se.getAttributeNameSpace() + "." + se.getAttributeName();
        splitValues = (String[])p.get(header);
        found = false;
        size = splitValues.length;
        counter = 0;
        while (!found && counter < size) {
            block20: {
                block21: {
                    if (!(o instanceof String)) break block21;
                    value = splitValues[counter];
                    switch (se.getOperator()) {
                        case 0: {
                            if (caseSensitive) {
                                found = value.equals((String)o);
                                break;
                            }
                            found = value.equalsIgnoreCase((String)o);
                            break;
                        }
                        case 1: {
                            if (o.equals("*")) {
                                found = true;
                                break;
                            }
                            strt = caseSensitive != false ? new StringTokenizer((String)o, "*", false) : new StringTokenizer(((String)o).toUpperCase(), "*", false);
                            startsWith = ((String)o).startsWith("*") == false;
                            endsWith = ((String)o).endsWith("*") == false;
                            lastIndex = -1;
                            found = true;
                            isFirstElement = true;
                            while (strt.hasMoreTokens()) {
                                if (found) {
                                    currentToken = strt.nextToken();
                                    currentIndex = caseSensitive != false ? value.indexOf(currentToken) : value.toUpperCase().indexOf(currentToken);
                                    found = isFirstElement && startsWith ? (caseSensitive ? value.startsWith(currentToken) : value.toUpperCase().startsWith(currentToken)) : (!strt.hasMoreTokens() && endsWith ? (caseSensitive ? value.endsWith(currentToken) : value.toUpperCase().endsWith(currentToken)) : currentIndex > lastIndex);
                                    lastIndex = currentIndex;
                                    isFirstElement = false;
                                    continue;
                                }
                                break block20;
                            }
                            break block20;
                        }
                        case 2: {
                            if (caseSensitive) {
                                found = value.compareTo((String)o) > 0;
                                break;
                            }
                            found = value.toLowerCase().compareTo(((String)o).toLowerCase()) > 0;
                            break;
                        }
                        case 3: {
                            if (caseSensitive) {
                                found = value.compareTo((String)o) < 0;
                                break;
                            }
                            found = value.toLowerCase().compareTo(((String)o).toLowerCase()) < 0;
                            break;
                        }
                        default: {
                            errorMessage = "Unsupported search element operator found!";
                            throw new PersistenceException(errorMessage);
                        }
                    }
                    break block20;
                }
                if (!(o instanceof byte[])) {
                    errorMessage = "Unsupported object type: " + o.getClass();
                    throw new PersistenceException(errorMessage);
                }
                blob = Util.decodeToByteArray(splitValues[counter]);
                switch (se.getOperator()) {
                    case 0: {
                        found = blob.equals((byte[])o);
                        ** break;
                    }
                    case 1: {
                        errorMessage = "Unsupported search element operator found: like cannot be used for blobs!";
                        throw new PersistenceException(errorMessage);
                    }
                    case 2: {
                        errorMessage = "Unsupported search element operator found: greater than cannot be used for blobs!";
                        throw new PersistenceException(errorMessage);
                    }
                    case 3: {
                        errorMessage = "Unsupported search element operator found: less than cannot be used for blobs!";
                        throw new PersistenceException(errorMessage);
                    }
                }
                errorMessage = "Unsupported search element operator found!";
                throw new PersistenceException(errorMessage);
            }
            ++counter;
        }
        return found;
    }

    private String calculateTemplate(String companyID, String companyName, String templateString) {
        String displayNameTemplate = templateString;
        boolean allTokensOK = true;
        String currentToken = null;
        int startIndex = displayNameTemplate.indexOf(123);
        int endIndex = displayNameTemplate.indexOf(125, startIndex);
        boolean hasMoreTokens = endIndex > startIndex;
        StringBuffer result = new StringBuffer();
        int index = 0;
        while (hasMoreTokens && allTokensOK) {
            result.append(displayNameTemplate.substring(index, startIndex));
            currentToken = displayNameTemplate.substring(startIndex + 1, endIndex);
            if (currentToken.equalsIgnoreCase("companyName")) {
                if (companyName != null) {
                    result.append(companyName);
                } else {
                    allTokensOK = false;
                }
            } else if (currentToken.equalsIgnoreCase("companyID")) {
                if (companyID != null) {
                    result.append(companyID);
                } else {
                    allTokensOK = false;
                }
            }
            index = endIndex + 1;
            startIndex = displayNameTemplate.indexOf(123, index);
            endIndex = displayNameTemplate.indexOf(125, startIndex);
            boolean bl = hasMoreTokens = endIndex > startIndex && startIndex != -1;
            if (hasMoreTokens) continue;
            result.append(displayNameTemplate.substring(index, displayNameTemplate.length()));
        }
        if (index == 0) {
            result.append(displayNameTemplate);
        }
        if (allTokensOK) {
            return result.toString();
        }
        return null;
    }

    public void populatePrincipalDatabag(IInternalPrincipalDatabag principal, AttributeList populateAttributes) throws PersistenceException {
        if (principal != null) {
            try {
                String[] idParts = principal.getIDParts();
                String type = idParts[0];
                String datasourceID = idParts[1];
                String companyID = idParts[2];
                if (type.equals("GRUP") && datasourceID.equals("COMPANY_GROUPS_DATASOURCE")) {
                    TradingPartnerEnumeration en = new TradingPartnerEnumeration();
                    while (en.hasMoreElements()) {
                        TradingPartnerInterface partnerId = (TradingPartnerInterface)en.nextElement();
                        if (partnerId == null || !companyID.equals(partnerId.getId())) continue;
                        String partnerName = partnerId.getName();
                        principal.setAttributeValues("com.sap.security.core.usermanagement", "uniquename", this.convertToVector(partnerId.getId()));
                        String description = this.calculateTemplate(partnerId.getId(), partnerName, UMFactory.getProperties().get(DESCRIPTION_TEMPLATE, DEFAULT_DESCRIPTION_TEMPLATE));
                        if (description == null) {
                            description = partnerId.getId();
                        }
                        principal.setAttributeValues("com.sap.security.core.usermanagement", "description", this.convertToVector(description));
                        String displayName = this.calculateTemplate(partnerId.getId(), partnerName, UMFactory.getProperties().get(DISPLAYNAME_TEMPLATE, DEFAULT_DISPLAYNAME_TEMPLATE));
                        if (displayName == null) {
                            displayName = partnerId.getId();
                        }
                        principal.setAttributeValues("com.sap.security.core.usermanagement", "displayname", this.convertToVector(displayName));
                        principal.setAttributeValues("com.sap.security.core.usermanagement", COMPANY_ATTRIBUTE, this.convertToVector(partnerId.getId()));
                        String now = Util.getTimeStamp();
                        principal.setAttributeValues("com.sap.security.core.usermanagement", "PRINCIPAL_CREATION_DATE", this.convertToVector(now));
                        principal.setAttributeValues("com.sap.security.core.usermanagement", "PRINCIPAL_MODIFY_DATE", this.convertToVector(now));
                        if (populateAttributes != null) {
                            int size = populateAttributes.getSize();
                            String attributeName = null;
                            String nameSpace = null;
                            int i = 0;
                            while (i < size) {
                                attributeName = populateAttributes.getAttributeNameOfAttributeAt(i);
                                nameSpace = populateAttributes.getNameSpaceOfAttributeAt(i);
                                if (principal.getAttributeValues(nameSpace, attributeName) == null) {
                                    if (nameSpace.equals("com.sap.security.core.usermanagement.relation") && attributeName.equals("PRINCIPAL_RELATION_MEMBER_ATTRIBUTE")) {
                                        SearchCriteria sc = new SearchCriteria("USER");
                                        if (idParts[2].equals(GUEST_COMPANY_GROUP_ID)) {
                                            sc.addEqualsElement("com.sap.security.core.usermanagement", COMPANY_ATTRIBUTE, "", true);
                                        } else {
                                            sc.addEqualsElement("com.sap.security.core.usermanagement", COMPANY_ATTRIBUTE, idParts[2], true);
                                        }
                                        Vector res = PrincipalDatabagFactory.getInstance().searchPrincipalDatabags(sc);
                                        if (res != null) {
                                            principal.setAttributeValues("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", res);
                                        }
                                    } else {
                                        principal.setAttributeValues(nameSpace, attributeName, new Vector());
                                    }
                                }
                                ++i;
                            }
                        }
                        if (!principal.getIDParts()[1].equals(this.getId())) continue;
                        principal.setExists(true);
                    }
                }
            }
            catch (TpdException tpdex) {
                throw new PersistenceException(tpdex);
            }
        }
    }

    public Vector getAttributeNamespaces(IPrincipalDatabag principal) throws PersistenceException {
        Vector<String> namespaces = new Vector<String>();
        if (principal != null) {
            try {
                String[] idParts = principal.getIDParts();
                String type = idParts[0];
                String datasourceID = idParts[1];
                String companyID = idParts[2];
                if (type.equals("GRUP") && datasourceID.equals("COMPANY_GROUPS_DATASOURCE")) {
                    TradingPartnerEnumeration en = new TradingPartnerEnumeration();
                    while (en.hasMoreElements()) {
                        TradingPartnerInterface partnerId = (TradingPartnerInterface)en.nextElement();
                        if (partnerId == null || !companyID.equals(partnerId.getId())) continue;
                        namespaces.add("com.sap.security.core.usermanagement");
                        namespaces.add("com.sap.security.core.usermanagement.relation");
                        return namespaces;
                    }
                }
            }
            catch (TpdException tpdex) {
                throw new PersistenceException(tpdex);
            }
        }
        return namespaces;
    }

    public Vector getAttributeNames(IPrincipalDatabag principal, String nameSpace) throws PersistenceException {
        Vector<String> attributes = new Vector<String>();
        if (principal != null) {
            try {
                String[] idParts = principal.getIDParts();
                String type = idParts[0];
                String datasourceID = idParts[1];
                String companyID = idParts[2];
                if (type.equals("GRUP") && datasourceID.equals("COMPANY_GROUPS_DATASOURCE")) {
                    TradingPartnerEnumeration en = new TradingPartnerEnumeration();
                    while (en.hasMoreElements()) {
                        TradingPartnerInterface partnerId = (TradingPartnerInterface)en.nextElement();
                        if (partnerId == null || !companyID.equals(partnerId.getId())) continue;
                        if (nameSpace.equals("com.sap.security.core.usermanagement")) {
                            attributes.add("uniquename");
                            attributes.add("description");
                            attributes.add("displayname");
                            attributes.add(COMPANY_ATTRIBUTE);
                            attributes.add("PRINCIPAL_CREATION_DATE");
                            attributes.add("PRINCIPAL_MODIFY_DATE");
                        }
                        return attributes;
                    }
                }
            }
            catch (TpdException tpdex) {
                throw new PersistenceException(tpdex);
            }
        }
        return attributes;
    }

    protected Vector convertToVector(Object o) {
        Vector<Object> newVector = new Vector<Object>();
        if (o == null) {
            return newVector;
        }
        newVector.add(o);
        return newVector;
    }

    private class TradingPartnerEnumeration
    implements Enumeration {
        Enumeration mEnumeration;
        boolean mFinished;
        boolean mGuestCompanyEnabled = UMFactory.getProperties().getBoolean("ume.company_groups.guestusercompany_enabled", true);
        String mGuestCompanyName;

        public TradingPartnerEnumeration() throws TpdException {
            if (this.mGuestCompanyEnabled) {
                this.mGuestCompanyName = UMFactory.getProperties().get(CompanyGroups.GUEST_COMPANY_NAME, CompanyGroups.GUEST_COMPANY_GROUP_NAME);
            }
            this.mEnumeration = CompanyGroups.this.mTradingPartnerDirectory.getPartners();
            this.mFinished = false;
        }

        public boolean hasMoreElements() {
            if (this.mGuestCompanyEnabled) {
                return this.mEnumeration.hasMoreElements() || !this.mFinished;
            }
            return this.mEnumeration.hasMoreElements();
        }

        public Object nextElement() {
            if (this.mGuestCompanyEnabled) {
                if (this.mEnumeration.hasMoreElements()) {
                    return this.mEnumeration.nextElement();
                }
                if (!this.mFinished) {
                    this.mFinished = true;
                    return new GuestTradingPartner();
                }
                return this.mEnumeration.nextElement();
            }
            return this.mEnumeration.nextElement();
        }

        class GuestTradingPartner
        implements TradingPartnerInterface {
            GuestTradingPartner() {
            }

            public AddressInterface getAddress() {
                throw new UnsupportedOperationException();
            }

            public String getCreateTimestamp() {
                throw new UnsupportedOperationException();
            }

            public String getCurrency() {
                throw new UnsupportedOperationException();
            }

            public String getDescription() {
                throw new UnsupportedOperationException();
            }

            public boolean getDisabled() {
                throw new UnsupportedOperationException();
            }

            public String getDisplayName() {
                throw new UnsupportedOperationException();
            }

            public String getDUNS() {
                throw new UnsupportedOperationException();
            }

            public String getEmail() {
                throw new UnsupportedOperationException();
            }

            public String getFax() {
                throw new UnsupportedOperationException();
            }

            public String[] getGroupNames() {
                throw new UnsupportedOperationException();
            }

            public String getId() {
                return CompanyGroups.GUEST_COMPANY_GROUP_ID;
            }

            public String getLanguage() {
                throw new UnsupportedOperationException();
            }

            public String getLogoURL() {
                throw new UnsupportedOperationException();
            }

            public String getModifyTimestamp() {
                throw new UnsupportedOperationException();
            }

            public String getMpid() {
                throw new UnsupportedOperationException();
            }

            public String getName() {
                return TradingPartnerEnumeration.this.mGuestCompanyName;
            }

            public String getOrgId() {
                throw new UnsupportedOperationException();
            }

            public PartnerID getPartnerID() {
                throw new UnsupportedOperationException();
            }

            public String[] getRoleIDs() throws TpdException {
                throw new UnsupportedOperationException();
            }

            public String getTandC() {
                throw new UnsupportedOperationException();
            }

            public String getTelephone() {
                throw new UnsupportedOperationException();
            }

            public String getTimezone() {
                throw new UnsupportedOperationException();
            }

            public String getTPOrderBy() {
                throw new UnsupportedOperationException();
            }

            public String getTPShortName() {
                throw new UnsupportedOperationException();
            }

            public String getType() {
                throw new UnsupportedOperationException();
            }

            public String getVisibility() {
                throw new UnsupportedOperationException();
            }

            public String getWebsite() {
                throw new UnsupportedOperationException();
            }

            public boolean isSameTradingPartner(TradingPartnerInterface arg0) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

