/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.logon.imp;

import com.sap.engine.lib.security.PasswordChangeCallback;
import com.sap.security.api.UMFactory;
import com.sap.security.api.logon.WebCallback;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.util.Base64;
import com.sap.security.core.util.IUMTrace;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class WebLoginCallbackHandler
implements CallbackHandler {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/logon/imp/WebLoginCallbackHandler.java#2 $ from $DateTime: 2004/11/04 13:54:08 $ ($Change: 17563 $)";
    private static IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/logon/imp/WebLoginCallbackHandler.java#2 $ from $DateTime: 2004/11/04 13:54:08 $ ($Change: 17563 $)");
    char[] pwd = null;
    String userID = null;
    HttpServletRequest req;
    HttpServletResponse resp;

    public WebLoginCallbackHandler(HttpServletRequest req, HttpServletResponse resp) {
        String[] uidpw;
        this.req = req;
        this.resp = resp;
        if (!UMFactory.getProperties().getBoolean("ume.logon.post_parameters_only", false) || "POST".equals(req.getMethod())) {
            this.userID = this.req.getParameter("j_user");
            if (null != this.req.getParameter("j_password")) {
                this.pwd = this.req.getParameter("j_password").toCharArray();
            }
            if (this.userID == null) {
                this.userID = (String)this.req.getAttribute("j_user");
                if (null != this.req.getAttribute("j_password")) {
                    this.pwd = ((String)this.req.getAttribute("j_password")).toCharArray();
                }
            }
        } else {
            trace.infoT("WebLoginCallbackHandler", "ume.logon.post_parameters_only enabled, but not a POST request.");
        }
        if ((uidpw = this.parseUidPwFromAuthHeader(req.getHeader("Authorization"))) != null) {
            this.userID = uidpw[0];
            this.pwd = uidpw[1].toCharArray();
        }
    }

    public WebLoginCallbackHandler(String userID, char[] pwd) {
        this.pwd = pwd;
        this.userID = userID;
    }

    public void handle(Callback[] callbacks) {
        int i = 0;
        while (i < callbacks.length) {
            this.handle(callbacks[i]);
            ++i;
        }
    }

    protected void handle(Callback callback) {
        if (callback instanceof PasswordChangeCallback) {
            PasswordChangeCallback pwdfccc = (PasswordChangeCallback)callback;
            pwdfccc.setPassword(null);
        } else if (callback instanceof PasswordCallback) {
            PasswordCallback pwdcb = (PasswordCallback)callback;
            pwdcb.setPassword(this.pwd);
        } else if (callback instanceof NameCallback) {
            NameCallback ncb = (NameCallback)callback;
            ncb.setName(this.userID);
        } else if (callback instanceof WebCallback) {
            WebCallback wcb = (WebCallback)callback;
            wcb.setRequest(this.req);
            wcb.setResponse(this.resp);
            wcb.setPassword(this.pwd);
            wcb.setUser(this.userID);
        } else {
            trace.warningT("handle", "Callback " + callback + " not handled.");
        }
    }

    private String[] parseUidPwFromAuthHeader(String authorization) {
        if (authorization == null) {
            return null;
        }
        int startAuthSub = authorization.indexOf(32);
        if (startAuthSub <= 0) {
            return null;
        }
        String method = authorization.substring(0, startAuthSub);
        if ("Basic".equals(method)) {
            String[] erg = new String[2];
            String userpass = authorization.substring(authorization.indexOf(32) + 1);
            userpass = new String(Base64.decode(userpass));
            erg[0] = userpass.substring(0, userpass.indexOf(58));
            erg[1] = userpass.substring(userpass.indexOf(58) + 1);
            return erg;
        }
        return null;
    }
}

