/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.logon.imp;

import com.sap.security.api.ISecurityPolicy;
import com.sap.security.api.UMFactory;
import com.sap.security.api.logon.ISecurityPolicyFactory;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.logon.imp.SecurityPolicy;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class SecurityPolicyFactory
implements ISecurityPolicyFactory {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/logon/imp/SecurityPolicyFactory.java#3 $ from $DateTime: 2004/06/09 16:32:18 $ ($Change: 16222 $)";
    private static final IUMParameters mySAPProperties = UMFactory.getProperties();
    private static SecurityPolicyFactory instance = null;
    private static final String useridInPasswordAllowed = "ume.logon.security_policy.userid_in_password_allowed";
    private static final String oldpassInNewpassAllowed = "ume.logon.security_policy.oldpass_in_newpass_allowed";
    private static final String passwordMinLength = "ume.logon.security_policy.password_min_length";
    private static final String passwordMaxLength = "ume.logon.security_policy.password_max_length";
    private static final String passwordMixCaseRequired = "ume.logon.security_policy.password_mix_case_required";
    private static final String passwordAlphaNumericRequired = "ume.logon.security_policy.password_alpha_numeric_required";
    private static final String passwordSpecialCharRequired = "ume.logon.security_policy.password_special_char_required";
    private static final String passwordChangeAllowed = "ume.logon.security_policy.password_change_allowed";
    private static final String passwordChangeRequired = "ume.logon.security_policy.password_change_required";
    private static final String lockAfterInvalidAttempts = "ume.logon.security_policy.lock_after_invalid_attempts";
    private static final String autoUnlockTime = "ume.logon.security_policy.auto_unlock_time";
    private static final String passwordExpireDays = "ume.logon.security_policy.password_expire_days";
    private static final String certLogonRequired = "ume.logon.security_policy.cert_logon_required";
    private static final String cookieLifeTime = "ume.logon.security_policy.cookie_life_time";
    private static final String logonIdMaxLength = "ume.logon.security_policy.useridmaxlength";
    private static final String logonIdMinLength = "ume.logon.security_policy.useridminlength";
    private static final String logonIdLowerCaseRequired = "ume.logon.security_policy.userid_lowercase";
    private static final String logonIdNumericDigitsRequired = "ume.logon.security_policy.userid_digits";
    private static final String logonIdSpecialCharsRequired = "ume.logon.security_policy.userid_special_char_required";
    public static final char uidOrgIdSeparator = ':';
    static /* synthetic */ Class class$com$sap$security$core$logon$imp$SecurityPolicyFactory;

    public static SecurityPolicyFactory getInstance() {
        Class clazz = class$com$sap$security$core$logon$imp$SecurityPolicyFactory == null ? (class$com$sap$security$core$logon$imp$SecurityPolicyFactory = SecurityPolicyFactory.class$("com.sap.security.core.logon.imp.SecurityPolicyFactory")) : class$com$sap$security$core$logon$imp$SecurityPolicyFactory;
        synchronized (clazz) {
            if (instance == null) {
                instance = new SecurityPolicyFactory();
            }
        }
        return instance;
    }

    public static ISecurityPolicy getSecurityPolicy(String logonId) {
        SecurityPolicy sp = new SecurityPolicy();
        sp.setUserName(logonId);
        return sp;
    }

    public ISecurityPolicy getSecurityPolicy() {
        SecurityPolicy sp = (SecurityPolicy)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SecurityPolicy sp = new SecurityPolicy();
                SecurityPolicyFactory.setSecurityValues(sp);
                return sp;
            }
        });
        return sp;
    }

    private static void setSecurityValues(SecurityPolicy sp) {
        sp.setLockAfterInvalidAttempts(mySAPProperties.getNumber(lockAfterInvalidAttempts, 6));
        sp.setAutoUnlockTime(mySAPProperties.getNumber(autoUnlockTime, 60));
        sp.setPasswordMinLength(mySAPProperties.getNumber(passwordMinLength, 6));
        sp.setPasswordMaxLength(mySAPProperties.getNumber(passwordMaxLength, 10));
        sp.setPasswordMixCaseRequired(mySAPProperties.getNumber(passwordMixCaseRequired, 0));
        sp.setPasswordAlphaNumericRequired(mySAPProperties.getNumber(passwordAlphaNumericRequired, 0));
        sp.setPasswordSpecialCharRequired(mySAPProperties.getNumber(passwordSpecialCharRequired, 0));
        sp.setPasswordExpiredDays(mySAPProperties.getNumber(passwordExpireDays, 99999));
        sp.setPasswordChangeAllowed(mySAPProperties.getBoolean(passwordChangeAllowed, true));
        sp.setPasswordChangeRequired(mySAPProperties.getBoolean(passwordChangeRequired, true));
        sp.setUseridInPasswordAllowed(mySAPProperties.getBoolean(useridInPasswordAllowed, true));
        sp.setOldInNewAllowed(mySAPProperties.getBoolean(oldpassInNewpassAllowed, true));
        sp.setCertLogonRequired(mySAPProperties.getBoolean(certLogonRequired, false));
        sp.setCookieLifeTime(mySAPProperties.getNumber(cookieLifeTime, 172800));
        sp.setLogonIdMaxLength(mySAPProperties.getNumber(logonIdMaxLength, 20));
        sp.setLogonIdMinLength(mySAPProperties.getNumber(logonIdMinLength, 6));
        sp.setLogonIdLowerCaseRequired(mySAPProperties.getNumber(logonIdLowerCaseRequired, 0));
        sp.setLogonIdNumericDigitsRequired(mySAPProperties.getNumber(logonIdNumericDigitsRequired, 0));
        sp.setLogonIdSpecialCharRequired(mySAPProperties.getNumber(logonIdSpecialCharsRequired, 0));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

