/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.logon.imp;

import com.sap.security.api.ISecurityPolicy;
import com.sap.security.api.InvalidLogonIdException;
import com.sap.security.api.InvalidPasswordException;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.codesecurity.permission.ProtectedCallPermission;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.SecurityUtils;
import com.sap.tc.logging.Location;
import java.security.Permission;

public class SecurityPolicy
implements ISecurityPolicy {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/logon/imp/SecurityPolicy.java#4 $ from $DateTime: 2004/06/09 16:32:18 $ ($Change: 16222 $)";
    private static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/logon/imp/SecurityPolicy.java#4 $ from $DateTime: 2004/06/09 16:32:18 $ ($Change: 16222 $)");
    Location myLoc = Location.getLocation((Class)(class$com$sap$security$core$logon$imp$SecurityPolicy == null ? (class$com$sap$security$core$logon$imp$SecurityPolicy = SecurityPolicy.class$("com.sap.security.core.logon.imp.SecurityPolicy")) : class$com$sap$security$core$logon$imp$SecurityPolicy));
    private String logonId = null;
    public static final String CHANGE_PASSWORD_NOT_ALLOWED = "CHANGE_PASSWORD_NOT_ALLOWED";
    public static final String USERID_CONTAINED_IN_PASSWORD = "USERID_CONTAINED_IN_PASSWORD";
    public static final String PASSWORD_TOO_LONG = "PASSWORD_TOO_LONG";
    public static final String PASSWORD_TOO_SHORT = "PASSWORD_TOO_SHORT";
    public static final String ALPHANUM_REQUIRED_FOR_PSWD = "ALPHANUM_REQUIRED_FOR_PSWD";
    public static final String NUMERIC_REQUIRED = "NUMERIC_REQUIRED";
    public static final String SPEC_CHARS_REQUIRED_FOR_PSWD = "SPEC_CHARS_REQUIRED_FOR_PSWD";
    public static final String TOO_MANY_INVALID_LOGON_ATTEMPTS = "TOO_MANY_INVALID_LOGON_ATTEMPTS";
    public static final String ACCOUNT_LOCKED_ADMIN = "ACCOUNT_LOCKED_ADMIN";
    public static final String ACCOUNT_LOCKED_LOGON = "ACCOUNT_LOCKED_LOGON";
    public static final String WRONG_OLD_PASSWORD = "WRONG_OLD_PASSWORD";
    public static final String OLDPASSWORD_IN_NEWPASSWORD = "OLDPASSWORD_IN_NEWPASSWORD";
    public static final String MISSING_UID = "MISSING_UID";
    public static final String MISSING_PASSWORD = "MISSING_PASSWORD";
    public static final String MISSING_NEW_PASSWORD = "MISSING_NEW_PASSWORD";
    public static final String MISSING_PASSWORD_CONFIRM = "MISSING_PASSWORD_CONFIRM";
    public static final String NEW_PASSWORDS_UNMATCHED = "NEW_PASSWORDS_UNMATCHED";
    public static final String USER_AUTH_FAILED = "USER_AUTH_FAILED";
    public static final String USER_IS_CURRENTLY_NOT_VALID = "USER_IS_CURRENTLY_NOT_VALID";
    public static final String NO_CERTIFICATE = "NO_CERTIFICATE";
    public static final String NO_USER_CERTIFICATE = "NO_USER_CERTIFICATE";
    public static final String CERT_GET_ERROR = "CERT_GET_ERROR";
    public static final String CERT_NOT_UNIQUE = "CERT_NOT_UNIQUE";
    public static final String WRONG_PASSWORD = "WRONG_PASSWORD";
    public static final String NEW_PASSWORD_INVALID = "NEW_PASSWORD_INVALID";
    public static final String PASSWORD_EXPIRED = "PASSWORD_EXPIRED";
    public static final String USER_ALREADY_EXIST = "USER_ALREADY_EXIST";
    public static final String CERT_AUTH_FAILED = "CERT_AUTH_FAILED";
    public static final String USERID_NOT_FOUND = "USERID_NOT_FOUND";
    public static final String INVALID_UID = "INVALID_UID";
    public static final String SAPSTAR_ACTIVATED = "SAPSTAR_ACTIVATED";
    public static final String NUMERIC_NOT_ALLOWED = "NUMERIC_NOT_ALLOWED";
    public static final String ALPHA_NOT_ALLOWED = "ALPHA_NOT_ALLOWED";
    public static final String LOWERCASE_NOT_ALLOWED = "LOWER_CASE_NOT_ALLOWED";
    public static final String WHITESPACES_NOT_ALLOWED = "WHITESPACES_NOT_ALLOWED";
    public static final String SPECIAL_CHARS_NOT_ALLOWED = "SPECIAL_CHARS_NOT_ALLOWED";
    public static final String LOGONID_IS_NULL = "LOGONID_IS_NULL";
    public static final String LOGONID_TOO_LONG = "LOGONID_TOO_LONG";
    public static final String LOGONID_TOO_SHORT = "LOGONID_TOO_SHORT";
    public static final String MINLENGTH_GREATER_MAXLENGTH = "MINLENGTH_GREATER_MAXLENGTH";
    public static final String MIN_LOGINID_LENGTH_TOO_SHOORT = "MIN_LOGINID_LENGTH_TOO_SHOORT";
    public static final String MAX_LOGINID_LENGTH_TOO_SHOORT = "MAX_LOGINID_LENGTH_TOO_SHOORT";
    public static final String CORRUPT_SECURITY_POLICY_CONFIGURATION = "CORRUPT_SECURITY_POLICY_CONFIGURATION";
    public static final String LOWERCASE_REQUIRED = "LOWERCASE_REQUIRED";
    public static final String MIXED_CASE_REQUIRED_FOR_PSWD = "MIXED_CASE_REQUIRED_FOR_PSWD";
    private int _lockAfterInvalidAttempts = 0;
    private int _autoUnlockTime = 0;
    private int _passwordMinLength = 0;
    private int _passwordMaxLength = 0;
    private int _passwordMixCaseRequired = 0;
    private int _passwordAlphaNumericRequired = 0;
    private int _passwordSpecialCharRequired = 0;
    private int _passwordExpiredDays = 0;
    private boolean _passwordChangeAllowed = true;
    private boolean _passwordChangeRequired = true;
    private boolean _useridInPasswordAllowed = true;
    private boolean _oldInNewAllowed = true;
    private int _logonIdMinLength = 0;
    private int _logonIdMaxLength = 0;
    private int _logonIdLowerCaseRequired = 0;
    private int _logonIdNumericDigitsRequired = 0;
    private int _logonIdSpecialCharsRequired = 0;
    private boolean _certLogonRequired = false;
    private int _cookieLifeTime = 0;
    private static final String SM_CLASSNAME = (class$com$sap$security$core$logon$imp$SecurityPolicy == null ? (class$com$sap$security$core$logon$imp$SecurityPolicy = SecurityPolicy.class$("com.sap.security.core.logon.imp.SecurityPolicy")) : class$com$sap$security$core$logon$imp$SecurityPolicy).getName();
    private static final String SM_METH_SETSECURITYPOLICY = "setSecurityPolicy";
    static /* synthetic */ Class class$com$sap$security$core$logon$imp$SecurityPolicy;

    public void setLockAfterInvalidAttempts(int count) {
        this.checkPermission();
        this._lockAfterInvalidAttempts = count;
    }

    public void setOldInNewAllowed(boolean allow) {
        this.checkPermission();
        this._oldInNewAllowed = allow;
    }

    public void setAutoUnlockTime(int time) {
        this._autoUnlockTime = time;
    }

    public void setPasswordMinLength(int length) {
        this.checkPermission();
        this._passwordMinLength = length;
    }

    public void setPasswordMaxLength(int length) {
        this.checkPermission();
        this._passwordMaxLength = length;
    }

    public void setUseridInPasswordAllowed(boolean b) {
        this.checkPermission();
        this._useridInPasswordAllowed = b;
    }

    public void setPasswordMixCaseRequired(int b) {
        this.checkPermission();
        this._passwordMixCaseRequired = b;
    }

    public void setLogonIdLowerCaseRequired(int b) {
        this.checkPermission();
        this._logonIdLowerCaseRequired = b;
    }

    public void setLogonIdSpecialCharRequired(int b) {
        this.checkPermission();
        this._logonIdSpecialCharsRequired = b;
    }

    public void setPasswordAlphaNumericRequired(int b) {
        this.checkPermission();
        this._passwordAlphaNumericRequired = b;
    }

    public void setPasswordSpecialCharRequired(int b) {
        this.checkPermission();
        this._passwordSpecialCharRequired = b;
    }

    public void setLogonIdNumericDigitsRequired(int b) {
        this.checkPermission();
        this._logonIdNumericDigitsRequired = b;
    }

    public void setPasswordExpiredDays(int days) {
        this.checkPermission();
        this._passwordExpiredDays = days;
    }

    public void setPasswordChangeAllowed(boolean a) {
        this.checkPermission();
        this._passwordChangeAllowed = a;
    }

    public void setPasswordChangeRequired(boolean a) {
        this.checkPermission();
        this._passwordChangeRequired = a;
    }

    public void setCertLogonRequired(boolean a) {
        this.checkPermission();
        this._certLogonRequired = a;
    }

    public void setCookieLifeTime(int lifeTime) {
        this.checkPermission();
        this._cookieLifeTime = lifeTime;
    }

    public boolean isPasswordValid(String pass, String logonId) throws InvalidPasswordException {
        this.setUserName(logonId);
        return this.isPasswordValid(pass);
    }

    public boolean isPasswordValid(String pass) throws InvalidPasswordException {
        boolean pswdValid = true;
        String pwdMsg = this.validatePassword(pass, this.logonId);
        if (pwdMsg != null) {
            pswdValid = false;
            throw new InvalidPasswordException(pwdMsg);
        }
        return pswdValid;
    }

    public String validatePassword(String pass, String logonId) {
        this.setUserName(logonId);
        return this.validatePassword(pass);
    }

    public String validatePassword(String pass) {
        String tPass;
        String tUserId;
        String pswdMsg = null;
        if (!(this.getUseridInPasswordAllowed() || this.logonId == null || (tUserId = this.logonId.toUpperCase()).indexOf(tPass = pass.toUpperCase()) < 0 && tPass.indexOf(tUserId) < 0)) {
            pswdMsg = USERID_CONTAINED_IN_PASSWORD;
        }
        return this.validateWord(pass, this.getPasswordAlphaNumericRequired(), this.getPasswordAlphaNumericRequired(), this.getPasswordMaxLength(), this.getPasswordMinLength(), this.getPasswordMixCaseRequired(), this.getPasswordMixCaseRequired(), this.getPasswordSpecialCharRequired());
    }

    private String validateLogonId(String logonId) {
        return this.validateWord(logonId, 0, this.getLogonIdNumericDigitsRequired(), this.getLogonIdMaxLength(), this.getLogonIdMinLength(), this.getLogonIdLowerCaseRequired(), 0, this.getLogonIdSpecialCharRequired());
    }

    public int getLockAfterInvalidAttempts() {
        return this._lockAfterInvalidAttempts;
    }

    public boolean getOldInNewAllowed() {
        return this._oldInNewAllowed;
    }

    public int getAutoUnlockTime() {
        return this._autoUnlockTime;
    }

    public int getPasswordMinLength() {
        return this._passwordMinLength;
    }

    public int getPasswordMaxLength() {
        return this._passwordMaxLength;
    }

    public boolean getUseridInPasswordAllowed() {
        return this._useridInPasswordAllowed;
    }

    public int getPasswordMixCaseRequired() {
        return this._passwordMixCaseRequired;
    }

    public int getLogonIdLowerCaseRequired() {
        return this._logonIdLowerCaseRequired;
    }

    public int getLogonIdSpecialCharRequired() {
        return this._logonIdSpecialCharsRequired;
    }

    public int getPasswordAlphaNumericRequired() {
        return this._passwordAlphaNumericRequired;
    }

    public int getPasswordSpecialCharRequired() {
        return this._passwordSpecialCharRequired;
    }

    public int getLogonIdNumericDigitsRequired() {
        return this._logonIdNumericDigitsRequired;
    }

    public int getPasswordExpiredDays() {
        return this._passwordExpiredDays;
    }

    public boolean getPasswordChangeAllowed() {
        return this._passwordChangeAllowed;
    }

    public boolean getPasswordChangeRequired() {
        return this._passwordChangeRequired;
    }

    public boolean getCertLogonRequired() {
        return this._certLogonRequired;
    }

    public int getCookieLifeTime() {
        return this._cookieLifeTime;
    }

    public void setUserName(String logonId) {
        this.checkPermission();
        this.logonId = logonId;
    }

    public int getLogonIdMinLength() {
        return this._logonIdMinLength;
    }

    public void setLogonIdMinLength(int length) {
        this.checkPermission();
        this._logonIdMinLength = length;
    }

    public int getLogonIdMaxLength() {
        return this._logonIdMaxLength;
    }

    public void setLogonIdMaxLength(int length) {
        this.checkPermission();
        this._logonIdMaxLength = length;
    }

    public boolean isLogonIdValid(String logonId) throws InvalidLogonIdException {
        String mn = "isLogonIdValid(String logonId)";
        if (logonId == null) {
            this.myLoc.errorT(mn, LOGONID_IS_NULL);
            throw new InvalidLogonIdException(LOGONID_IS_NULL);
        }
        if (logonId.length() > this.getLogonIdMaxLength()) {
            this.myLoc.errorT(mn, LOGONID_IS_NULL);
            throw new InvalidLogonIdException(LOGONID_TOO_LONG);
        }
        if (logonId.length() < this.getLogonIdMinLength()) {
            this.myLoc.errorT(mn, LOGONID_IS_NULL);
            throw new InvalidLogonIdException(LOGONID_TOO_SHORT);
        }
        this.checkSecPolLogonIdConfig();
        String pwdMsg = this.validateLogonId(logonId);
        if (pwdMsg != null) {
            this.myLoc.errorT(mn, pwdMsg);
            throw new InvalidLogonIdException(pwdMsg);
        }
        return true;
    }

    public String generatePassword() {
        return this.generateWord(this.getPasswordAlphaNumericRequired(), this.getPasswordAlphaNumericRequired(), this.getPasswordMaxLength(), this.getPasswordMinLength(), this.getPasswordMixCaseRequired(), this.getPasswordMixCaseRequired(), this.getPasswordSpecialCharRequired());
    }

    private void checkPermission() {
        SecurityManager sm = UMFactory.getSecurityManager();
        if (sm != null) {
            ProtectedCallPermission p = new ProtectedCallPermission(SM_CLASSNAME, SM_METH_SETSECURITYPOLICY);
            sm.checkPermission((Permission)p);
        }
    }

    public String generateLogonId() throws InvalidLogonIdException {
        String mn = "generateLogonId()";
        this.checkSecPolLogonIdConfig();
        String word = this.generateWord(0, this.getLogonIdNumericDigitsRequired(), this.getLogonIdMaxLength(), this.getLogonIdMinLength(), this.getLogonIdLowerCaseRequired(), 0, this.getLogonIdSpecialCharRequired());
        if (word.length() > this.getLogonIdMaxLength()) {
            throw new InvalidLogonIdException(LOGONID_TOO_LONG);
        }
        try {
            UMFactory.getUserFactory().getUserByLogonID(word);
            return this.generateLogonId();
        }
        catch (UMException e) {
            trace.debugT(mn, "no user found", e);
            return word;
        }
    }

    private void checkSecPolLogonIdConfig() throws InvalidLogonIdException {
        String mn = "checkSecPolLogonIdConfig()";
        if (this.getLogonIdMinLength() < 0) {
            this.myLoc.errorT(mn, MIN_LOGINID_LENGTH_TOO_SHOORT);
            throw new InvalidLogonIdException(MIN_LOGINID_LENGTH_TOO_SHOORT);
        }
        if (this.getLogonIdMaxLength() <= 0) {
            this.myLoc.errorT(mn, MAX_LOGINID_LENGTH_TOO_SHOORT);
            throw new InvalidLogonIdException(MAX_LOGINID_LENGTH_TOO_SHOORT);
        }
        if (this.getLogonIdMaxLength() < this.getLogonIdMinLength()) {
            this.myLoc.errorT(mn, MINLENGTH_GREATER_MAXLENGTH);
            throw new InvalidLogonIdException(MINLENGTH_GREATER_MAXLENGTH);
        }
        if (this.getLogonIdLowerCaseRequired() + this.getLogonIdNumericDigitsRequired() + this.getLogonIdSpecialCharRequired() > this.getLogonIdMaxLength()) {
            this.myLoc.errorT(mn, CORRUPT_SECURITY_POLICY_CONFIGURATION);
            throw new InvalidLogonIdException(CORRUPT_SECURITY_POLICY_CONFIGURATION);
        }
    }

    private String generateWord(int pAlpha, int pNumeric, int maxlen, int minlen, int pLowerCase, int pUpperCase, int specialchar) {
        int remaininglen;
        int len = 0;
        len = minlen == 0 ? (maxlen == 0 ? 8 : maxlen) : (maxlen == 0 ? minlen : maxlen);
        StringBuffer allowedChars = new StringBuffer();
        allowedChars.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
        String alpha = null;
        String numeric = null;
        String ucase = null;
        String lcase = null;
        String spchar = null;
        if (pAlpha >= 0) {
            alpha = SecurityUtils.getUCaseLetterChars(pAlpha);
        }
        if (pNumeric >= 0) {
            numeric = SecurityUtils.getNumericChars(pNumeric);
            allowedChars.append("1234567890");
        }
        if (pLowerCase >= 0) {
            lcase = SecurityUtils.getLCaseLetterChars(pLowerCase);
            allowedChars.append("abcdefghijklmnopqrstuvwxyz");
        }
        if (pUpperCase >= 0) {
            ucase = SecurityUtils.getUCaseLetterChars(pUpperCase);
        }
        if (specialchar >= 0) {
            spchar = SecurityUtils.getSpecialChars(specialchar);
            allowedChars.append("~!@#$%&*?");
        }
        StringBuffer retval = new StringBuffer();
        int length = 0;
        if (alpha != null) {
            length += alpha.length();
            retval.append(alpha);
        }
        if (numeric != null) {
            length += numeric.length();
            retval.append(numeric);
        }
        if (ucase != null) {
            length += ucase.length();
            retval.append(ucase);
        }
        if (lcase != null) {
            length += lcase.length();
            retval.append(lcase);
        }
        if (spchar != null) {
            length += spchar.length();
            retval.append(spchar);
        }
        if ((remaininglen = len - length) > 0) {
            retval.append(SecurityUtils.generateRandomChars(remaininglen, allowedChars.toString()));
        }
        return SecurityUtils.randomize(retval.toString());
    }

    private String validateWord(String word, int pAlpha, int pNumeric, int maxlen, int minlen, int pLowerCase, int pUpperCase, int specialchar) {
        int special_char;
        int alpha;
        String ch;
        if (word.length() != word.trim().length()) {
            return WHITESPACES_NOT_ALLOWED;
        }
        if (word.length() > maxlen) {
            return PASSWORD_TOO_LONG;
        }
        if (word.length() < minlen) {
            return PASSWORD_TOO_SHORT;
        }
        if (pLowerCase > 0 || pUpperCase > 0) {
            int uppercase = 0;
            int lowercase = 0;
            int i = 0;
            while (i < word.length()) {
                ch = word.substring(i, i + 1);
                if ("ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(ch) >= 0) {
                    ++uppercase;
                }
                if ("abcdefghijklmnopqrstuvwxyz".indexOf(ch) >= 0) {
                    ++lowercase;
                }
                ++i;
            }
            if (uppercase < pUpperCase || lowercase < pLowerCase) {
                return LOWERCASE_REQUIRED;
            }
        }
        if (pLowerCase < 0) {
            int lowercase = 0;
            int i = 0;
            while (i < word.length()) {
                String ch2 = word.substring(i, i + 1);
                if ("abcdefghijklmnopqrstuvwxyz".indexOf(ch2) >= 0) {
                    ++lowercase;
                }
                ++i;
            }
            if (lowercase != 0) {
                return LOWERCASE_NOT_ALLOWED;
            }
        }
        if (pAlpha > 0 || pNumeric > 0) {
            alpha = 0;
            int numeric = 0;
            String alphaValues = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
            int i = 0;
            while (i < word.length()) {
                String ch3 = word.substring(i, i + 1);
                if (alphaValues.indexOf(ch3) >= 0) {
                    ++alpha;
                }
                if ("1234567890".indexOf(ch3) >= 0) {
                    ++numeric;
                }
                ++i;
            }
            if (alpha < pAlpha || numeric < pNumeric) {
                return NUMERIC_REQUIRED;
            }
        }
        if (pAlpha < 0) {
            alpha = 0;
            String alphaValues = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
            int i = 0;
            while (i < word.length()) {
                ch = word.substring(i, i + 1);
                if (alphaValues.indexOf(ch) >= 0) {
                    ++alpha;
                }
                ++i;
            }
            if (alpha != 0 || pAlpha >= 0) {
                return ALPHA_NOT_ALLOWED;
            }
        }
        if (pNumeric < 0) {
            int numeric = 0;
            int i = 0;
            while (i < word.length()) {
                String ch4 = word.substring(i, i + 1);
                if ("1234567890".indexOf(ch4) >= 0) {
                    ++numeric;
                }
                ++i;
            }
            if (numeric != 0 || pNumeric >= 0) {
                return NUMERIC_NOT_ALLOWED;
            }
        }
        if (specialchar > 0) {
            special_char = 0;
            String alphaNumValues = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890";
            int i = 0;
            while (i < word.length()) {
                ch = word.substring(i, i + 1);
                if (alphaNumValues.indexOf(ch) < 0) {
                    ++special_char;
                }
                ++i;
            }
            if (special_char < specialchar) {
                return SPEC_CHARS_REQUIRED_FOR_PSWD;
            }
        }
        if (specialchar < 0) {
            special_char = 0;
            String alphaNumValues = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890";
            int i = 0;
            while (i < word.length()) {
                ch = word.substring(i, i + 1);
                if (alphaNumValues.indexOf(ch) < 0) {
                    ++special_char;
                }
                ++i;
            }
            if (special_char != 0) {
                return SPECIAL_CHARS_NOT_ALLOWED;
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

