/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.logon.imp;

import com.sap.engine.lib.security.http.HttpGetterCallback;
import com.sap.engine.lib.security.http.HttpSetterCallback;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.logon.imp.WebLoginCallbackHandler;
import com.sap.security.core.util.IUMTrace;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.security.auth.callback.Callback;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SAPJ2EECallbackHandler
extends WebLoginCallbackHandler {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/logon/imp/SAPJ2EECallbackHandler.java#2 $ from $DateTime: 2005/01/21 16:34:10 $ ($Change: 17855 $)";
    private static IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/logon/imp/SAPJ2EECallbackHandler.java#2 $ from $DateTime: 2005/01/21 16:34:10 $ ($Change: 17855 $)");
    HashMap _cookies = new HashMap();

    public SAPJ2EECallbackHandler(HttpServletRequest req, HttpServletResponse resp) {
        super(req, resp);
        this.parseCookies();
    }

    public void handle(Callback[] callbacks) {
        int i = 0;
        while (i < callbacks.length) {
            if (callbacks[i] instanceof HttpSetterCallback) {
                HttpSetterCallback hsc = (HttpSetterCallback)callbacks[i];
                this.handleSetterCb(hsc);
            } else if (callbacks[i] instanceof HttpGetterCallback) {
                HttpGetterCallback hgc = (HttpGetterCallback)callbacks[i];
                this.handleGetterCb(hgc);
            } else {
                super.handle(callbacks[i]);
            }
            ++i;
        }
    }

    private void parseCookies() {
        Cookie[] pils = this.req.getCookies();
        if (pils == null) {
            return;
        }
        int i = 0;
        while (i < pils.length) {
            this._cookies.put(pils[i].getName(), pils[i]);
            ++i;
        }
    }

    private void handleGetterCb(HttpGetterCallback hgc) {
        if (this.req == null) {
            hgc.setValue(null);
            return;
        }
        switch (hgc.getType()) {
            case 7: {
                hgc.setValue((Object)new Boolean(this.req.isSecure()));
                break;
            }
            case 5: {
                hgc.setValue((Object)this.req.getRemoteAddr());
                break;
            }
            case 2: {
                String name = hgc.getName();
                if (this._cookies.get(name) != null) {
                    Cookie cookie = (Cookie)this._cookies.get(name);
                    hgc.setValue((Object)cookie.getValue());
                    break;
                }
                hgc.setValue(null);
                break;
            }
            case 1: {
                String name = hgc.getName();
                if ("host".equalsIgnoreCase(name)) {
                    hgc.setValue((Object)this.req.getServerName());
                    break;
                }
                hgc.setValue((Object)this.req.getHeader(name));
                break;
            }
            case 6: {
                hgc.setValue((Object)this.req.getMethod());
                break;
            }
            case 3: {
                String[] names = new String[]{this.req.getParameter(hgc.getName())};
                hgc.setValue((Object)names);
                break;
            }
            case 10: {
                hgc.setValue(null);
                break;
            }
            case 4: {
                Object cert = this.req.getAttribute("javax.servlet.request.X509Certificate");
                if (cert == null) {
                    trace.warningT("handleGetterCb", "No certificate received");
                }
                hgc.setValue(cert);
                break;
            }
            default: {
                throw new IllegalArgumentException("hgc.getType()==" + hgc.getType() + " not yet supported");
            }
        }
    }

    private void handleSetterCb(HttpSetterCallback hsc) {
        if (this.resp == null) {
            return;
        }
        switch (hsc.getType()) {
            case 2: {
                Cookie cookie = new Cookie(hsc.getName(), (String)hsc.getValue());
                cookie.setPath("/");
                this.resp.addCookie(cookie);
                break;
            }
            case 1: {
                String headerName = hsc.getName();
                String headerValue = (String)hsc.getValue();
                if ("Set-Cookie".equals(headerName)) {
                    Cookie[] newCookies = this.getCookiesFromString(headerValue);
                    int i = 0;
                    while (i < newCookies.length) {
                        this.resp.addCookie(newCookies[i]);
                        ++i;
                    }
                    break;
                }
                this.resp.addHeader(headerName, headerValue);
                break;
            }
            case 10: {
                break;
            }
            default: {
                throw new IllegalArgumentException("hsc.getType()==" + hsc.getType() + " not yet supported");
            }
        }
    }

    private Cookie[] getCookiesFromString(String headerValue) {
        StringTokenizer komma = new StringTokenizer(headerValue, ",");
        int tokens = komma.countTokens();
        Cookie[] cookies = new Cookie[tokens];
        int i = 0;
        while (i < tokens) {
            String cookieStr = komma.nextToken();
            int attsep = cookieStr.indexOf(";");
            int length = cookieStr.length();
            String nameVal = cookieStr.substring(0, attsep);
            String attrs = attsep + 1 <= length ? cookieStr.substring(attsep + 1, cookieStr.length()) : null;
            cookies[i] = new Cookie(nameVal.substring(0, nameVal.indexOf("=")), nameVal.substring(nameVal.indexOf("=") + 1, nameVal.length()));
            if (attrs != null) {
                StringTokenizer attrtok = new StringTokenizer(attrs, ";");
                while (attrtok.hasMoreTokens()) {
                    String attr = attrtok.nextToken();
                    if (attr.toLowerCase().startsWith("domain=")) {
                        cookies[i].setDomain(attr.substring(7, attr.length()));
                        continue;
                    }
                    if (attr.toLowerCase().startsWith("comment=")) {
                        cookies[i].setComment(attr.substring(8, attr.length()));
                        continue;
                    }
                    if (attr.toLowerCase().startsWith("max-age=")) {
                        cookies[i].setComment(attr.substring(8, attr.length()));
                        continue;
                    }
                    if (attr.toLowerCase().startsWith("path=")) {
                        cookies[i].setPath(attr.substring(5, attr.length()));
                        continue;
                    }
                    if (attr.toLowerCase().startsWith("secure")) {
                        cookies[i].setSecure(true);
                        continue;
                    }
                    if (!attr.toLowerCase().startsWith("httponly")) continue;
                    cookies[i].setValue(cookies[i].getValue() + ";HttpOnly");
                }
            }
            ++i;
        }
        return cookies;
    }

    public void reset() {
        this.req = null;
        this.resp = null;
    }
}

