/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.logon.imp;

import com.sap.engine.lib.security.LoginExceptionDetails;
import com.sap.security.api.IUser;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.logon.AuthSchemePrincipal;
import com.sap.security.api.logon.IAuthScheme;
import com.sap.security.api.ticket.InfoUnit;
import com.sap.security.api.ticket.TicketException;
import com.sap.security.core.IEngineResourceHelper;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.logon.imp.AuthSchemeFactory;
import com.sap.security.core.logon.imp.JUMAuthenticator;
import com.sap.security.core.logon.imp.SAPJ2EECallbackHandler;
import com.sap.security.core.session.imp.SSOSession;
import com.sap.security.core.ticket.imp.Ticket;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.SecurityAudit;
import com.sap.util.monitor.jarm.IMonitor;
import com.sap.util.monitor.jarm.TaskMonitor;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.GenericCredential;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SAPJ2EEAuthenticator
extends JUMAuthenticator {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/logon/imp/SAPJ2EEAuthenticator.java#8 $ from $DateTime: 2005/01/21 16:34:10 $ ($Change: 17855 $)";
    private static IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/logon/imp/SAPJ2EEAuthenticator.java#8 $ from $DateTime: 2005/01/21 16:34:10 $ ($Change: 17855 $)");
    final String[] LOGON_FAILURE_CODES = new String[]{"USER_AUTH_FAILED", "PASSWORD_EXPIRED", "USER_IS_CURRENTLY_NOT_VALID", "USER_AUTH_FAILED", "CERT_AUTH_FAILED", "CERT_AUTH_FAILED", null, null, null, "USER_AUTH_FAILED"};
    static /* synthetic */ Class class$com$sap$security$api$logon$AuthSchemePrincipal;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IUser getLoggedInUser(HttpServletRequest req, HttpServletResponse resp) {
        String authscheme;
        IMonitor monitor;
        block16: {
            String METHOD = "getLoggedInUser";
            String MONITOR_STRING = "UME:SAPJ2EEAuthenticator:getLoggedInUser";
            Principal p = req.getUserPrincipal();
            Subject subject = null;
            monitor = null;
            String lmStack = null;
            IUser iuser = null;
            try {
                try {
                    monitor = TaskMonitor.getRequestMonitor(null, (String)"UME:SAPJ2EEAuthenticator:getLoggedInUser");
                    monitor.startComponent("UME:SAPJ2EEAuthenticator:getLoggedInUser");
                    if (p == null) {
                        lmStack = UMFactory.getProperties().get("ume.login.context");
                        SAPJ2EECallbackHandler cbh = (SAPJ2EECallbackHandler)this.getHandler(req, resp);
                        if (trace.beDebug()) {
                            trace.debugT(METHOD, "no user in session, relogin");
                        }
                        LoginContext context = new LoginContext(lmStack, cbh);
                        context.login();
                        req.getSession(true);
                        cbh.reset();
                        subject = context.getSubject();
                        p = this.getPrincipalFromSubject(subject);
                        iuser = this.getIUserFromPrincipal(p);
                        String authscheme2 = this.getAuthscheme(subject);
                        this.enrichUser(p, iuser, subject, authscheme2 == null ? "default" : authscheme2);
                    } else {
                        if (trace.beDebug()) {
                            trace.debugT(METHOD, "found user in session");
                        }
                        iuser = this.getIUserFromPrincipal(p);
                        authscheme = this.getAuthscheme(null);
                        this.enrichUser(p, iuser, req, authscheme == null ? "default" : authscheme);
                    }
                    authscheme = iuser;
                    Object var16_18 = null;
                    if (monitor == null) return authscheme;
                    if (iuser == null) break block16;
                }
                catch (LoginException e) {
                    trace.warningT(METHOD, e);
                    IUser context = null;
                    Object var16_19 = null;
                    if (monitor == null) return context;
                    if (iuser != null) {
                        monitor.setUser(iuser.getUniqueName());
                    }
                    monitor.endComponent("UME:SAPJ2EEAuthenticator:getLoggedInUser");
                    monitor.endRequest("UME:SAPJ2EEAuthenticator:getLoggedInUser");
                    return context;
                }
                catch (SecurityException e) {
                    trace.warningT(METHOD, e);
                    IUser authscheme2 = null;
                    Object var16_20 = null;
                    if (monitor == null) return authscheme2;
                    if (iuser != null) {
                        monitor.setUser(iuser.getUniqueName());
                    }
                    monitor.endComponent("UME:SAPJ2EEAuthenticator:getLoggedInUser");
                    monitor.endRequest("UME:SAPJ2EEAuthenticator:getLoggedInUser");
                    return authscheme2;
                }
                catch (UMException e) {
                    trace.warningT(METHOD, e);
                    IUser iUser = null;
                    Object var16_21 = null;
                    if (monitor == null) return iUser;
                    if (iuser != null) {
                        monitor.setUser(iuser.getUniqueName());
                    }
                    monitor.endComponent("UME:SAPJ2EEAuthenticator:getLoggedInUser");
                    monitor.endRequest("UME:SAPJ2EEAuthenticator:getLoggedInUser");
                    return iUser;
                }
                catch (TicketException e) {
                    trace.warningT(METHOD, e);
                    IUser iUser = null;
                    Object var16_22 = null;
                    if (monitor == null) return iUser;
                    if (iuser != null) {
                        monitor.setUser(iuser.getUniqueName());
                    }
                    monitor.endComponent("UME:SAPJ2EEAuthenticator:getLoggedInUser");
                    monitor.endRequest("UME:SAPJ2EEAuthenticator:getLoggedInUser");
                    return iUser;
                }
            }
            catch (Throwable throwable) {
                Object var16_23 = null;
                if (monitor == null) throw throwable;
                if (iuser != null) {
                    monitor.setUser(iuser.getUniqueName());
                }
                monitor.endComponent("UME:SAPJ2EEAuthenticator:getLoggedInUser");
                monitor.endRequest("UME:SAPJ2EEAuthenticator:getLoggedInUser");
                throw throwable;
            }
            monitor.setUser(iuser.getUniqueName());
        }
        monitor.endComponent("UME:SAPJ2EEAuthenticator:getLoggedInUser");
        monitor.endRequest("UME:SAPJ2EEAuthenticator:getLoggedInUser");
        return authscheme;
    }

    private IUser getIUserFromPrincipal(Principal p) throws UMException {
        if (p == null) {
            return null;
        }
        return UMFactory.getUserFactory().getUserByLogonID(p.getName());
    }

    private String getLoginModulStackFromTicket(HttpServletRequest req) {
        String ticket_string = SSOSession.getSSOTicket(req);
        if (ticket_string == null) {
            return null;
        }
        Ticket t = new Ticket();
        t.setMode(Ticket.MODE_VERIFY);
        t.setEnforceVerify(false);
        try {
            IAuthScheme ias;
            t.setTicket(ticket_string);
            InfoUnit iu = t.getInfoUnit(136);
            String authscheme = "default";
            if (iu != null) {
                authscheme = iu.getString("UTF8");
            }
            if ((ias = InternalUMFactory.getAuthSchemeFactory().getAuthScheme(authscheme)) == null) {
                ias = InternalUMFactory.getAuthSchemeFactory().getAuthScheme("default");
            }
            if (ias == null) {
                trace.errorT("getLoginModulStackFromTicket", "FATAL ERROR: No authscheme \"default\" configured");
                throw new IllegalStateException("No authscheme \"default\" present.");
            }
            return ias.getAuthenticationTemplate();
        }
        catch (TicketException e) {
            trace.debugT("getLoginModulStackFromTicket", e);
            return null;
        }
        catch (UnsupportedEncodingException e) {
            trace.warningT("getLoginModulStackFromTicket", "couldn't get authscheme from ticket", e);
            IAuthScheme ias = InternalUMFactory.getAuthSchemeFactory().getAuthScheme("default");
            if (ias == null) {
                trace.errorT("getLoginModulStackFromTicket", "FATAL ERROR: No authscheme \"default\" configured");
                throw new IllegalStateException("No authscheme \"default\" present.");
            }
            return ias.getAuthenticationTemplate();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Subject logon(HttpServletRequest req, HttpServletResponse resp, String authscheme) throws LoginException {
        Subject subject;
        IMonitor monitor;
        block22: {
            String METHOD = "logon";
            monitor = null;
            String monitorString = "UME:SAPJ2EEAuthenticator:logon";
            String monitorLogon = "UME:SAPJ2EEAuthenticator:logon:context.login";
            String monitorGetPrincipal = "UME:SAPJ2EEAuthenticator:logon:getIUserFromPrincipal";
            String monitorEnrich = "UME:SAPJ2EEAuthenticator:logon:enrich";
            IUser user = null;
            if (authscheme == null) {
                authscheme = "default";
            }
            try {
                try {
                    monitor = TaskMonitor.getRequestMonitor(null, (String)"UME:SAPJ2EEAuthenticator:logon");
                    Principal p = null;
                    monitor.startComponent("UME:SAPJ2EEAuthenticator:logon");
                    SAPJ2EECallbackHandler cbh = (SAPJ2EECallbackHandler)this.getHandler(req, resp);
                    try {
                        monitor.startComponent(1, "UME:SAPJ2EEAuthenticator:logon:context.login");
                        String lmStack = this.getLoginModulStackForAuthscheme(authscheme);
                        LoginContext context = new LoginContext(lmStack, cbh);
                        context.login();
                        cbh.reset();
                        subject = context.getSubject();
                        p = this.getPrincipalFromSubject(subject);
                        Object var17_20 = null;
                    }
                    catch (Throwable throwable) {
                        Object var17_21 = null;
                        monitor.endComponent(1, "UME:SAPJ2EEAuthenticator:logon:context.login");
                        throw throwable;
                    }
                    monitor.endComponent(1, "UME:SAPJ2EEAuthenticator:logon:context.login");
                    try {
                        monitor.startComponent(1, "UME:SAPJ2EEAuthenticator:logon:getIUserFromPrincipal");
                        user = this.getIUserFromPrincipal(p);
                        Object var19_24 = null;
                    }
                    catch (Throwable throwable) {
                        Object var19_25 = null;
                        monitor.endComponent(1, "UME:SAPJ2EEAuthenticator:logon:getIUserFromPrincipal");
                        throw throwable;
                    }
                    monitor.endComponent(1, "UME:SAPJ2EEAuthenticator:logon:getIUserFromPrincipal");
                    try {
                        monitor.startComponent(1, "UME:SAPJ2EEAuthenticator:logon:enrich");
                        this.enrichUser(p, user, subject, authscheme);
                        subject.getPrincipals().add((Principal)user);
                        if (SecurityAudit.isLogged("LOGIN.OK")) {
                            HashMap<String, String> secAuditDetails = new HashMap<String, String>();
                            if (UMFactory.getProperties().getBoolean("ume.logon.security_policy.log_client_hostaddress", true)) {
                                secAuditDetails.put("IP Address", req.getRemoteAddr());
                            }
                            if (UMFactory.getProperties().getBoolean("ume.logon.security_policy.log_client_hostname", false)) {
                                secAuditDetails.put("Host", req.getRemoteHost());
                            }
                            SecurityAudit.log("LOGIN.OK", user.getUniqueID(), secAuditDetails);
                        }
                        Object var21_28 = null;
                    }
                    catch (Throwable throwable) {
                        Object var21_29 = null;
                        monitor.endComponent(1, "UME:SAPJ2EEAuthenticator:logon:enrich");
                        throw throwable;
                    }
                    monitor.endComponent(1, "UME:SAPJ2EEAuthenticator:logon:enrich");
                    Object var23_31 = null;
                    if (monitor == null) return subject;
                    if (user == null) break block22;
                }
                catch (SecurityException e) {
                    if (!trace.beDebug()) throw new LoginException(e.toString());
                    trace.debugT(METHOD, e);
                    throw new LoginException(e.toString());
                }
                catch (UMException e) {
                    if (!trace.beDebug()) throw new LoginException(e.toString());
                    trace.debugT(METHOD, e);
                    throw new LoginException(e.toString());
                }
                catch (TicketException e) {
                    if (!trace.beDebug()) throw new LoginException(e.toString());
                    trace.debugT(METHOD, e);
                    throw new LoginException(e.toString());
                }
                catch (LoginException e) {
                    if (SecurityAudit.isLogged("LOGIN.ERROR")) {
                        HashMap<String, String> secAuditDetails = new HashMap<String, String>();
                        if (UMFactory.getProperties().getBoolean("ume.logon.security_policy.log_client_hostaddress", true)) {
                            secAuditDetails.put("IP Address", req.getRemoteAddr());
                        }
                        if (UMFactory.getProperties().getBoolean("ume.logon.security_policy.log_client_hostname", false)) {
                            secAuditDetails.put("Host", req.getRemoteHost());
                        }
                        secAuditDetails.put("UserID", req.getParameter("j_user"));
                        secAuditDetails.put("Reason", e.getMessage());
                        secAuditDetails.put("Login Method", authscheme);
                        SecurityAudit.log("LOGIN.ERROR", null, secAuditDetails);
                    }
                    LoginException e1 = this.getLoginException(e);
                    e1.fillInStackTrace();
                    throw e1;
                }
            }
            catch (Throwable throwable) {
                Object var23_32 = null;
                if (monitor == null) throw throwable;
                if (user != null) {
                    monitor.setUser(user.getUniqueName());
                }
                monitor.endComponent("UME:SAPJ2EEAuthenticator:logon");
                monitor.endRequest("UME:SAPJ2EEAuthenticator:logon");
                throw throwable;
            }
            monitor.setUser(user.getUniqueName());
        }
        monitor.endComponent("UME:SAPJ2EEAuthenticator:logon");
        monitor.endRequest("UME:SAPJ2EEAuthenticator:logon");
        return subject;
    }

    private LoginException getLoginException(LoginException e) {
        try {
            if (e instanceof LoginExceptionDetails) {
                byte b = ((LoginExceptionDetails)e).getExceptionCause();
                if (b < 0 || b > 9) {
                    trace.warningT("getLoginException", "Can't map exception.", e);
                    return new LoginException(this.LOGON_FAILURE_CODES[0]);
                }
                return new LoginException(this.LOGON_FAILURE_CODES[b]);
            }
        }
        catch (Exception e1) {
            trace.warningT("getLoginException", "Problem in getLoginException", e1);
        }
        return e;
    }

    private Principal getPrincipalFromSubject(Subject subject) {
        if (subject == null) {
            return null;
        }
        Iterator<Principal> it = subject.getPrincipals().iterator();
        while (it.hasNext()) {
            Principal p = it.next();
            if (p instanceof AuthSchemePrincipal) continue;
            return p;
        }
        return null;
    }

    private void enrichUser(Principal p, IUser user, HttpServletRequest req, String authscheme) throws SecurityException, TicketException {
        Object o;
        String ticket;
        String METHOD = "enrichUser";
        boolean bTicketEnrichDone = false;
        Cookie[] ca = req.getCookies();
        if (ca != null) {
            int i = 0;
            while (i < ca.length) {
                if (ca[i].getName().equals("MYSAPSSO2")) {
                    user.setTransientAttribute("com.sap.security.core.usermanagement", "MYSAPSSO2_STRING", (Object)SAPJ2EEAuthenticator.replacePercentHex(ca[i].getValue()));
                    user.setTransientAttribute("com.sap.security.core.usermanagement", "$MYSAPSSO$", null);
                    bTicketEnrichDone = true;
                }
                ++i;
            }
            user.setTransientAttribute("com.sap.security.core.usermanagement", "j_authscheme", (Object)authscheme);
        }
        if (!bTicketEnrichDone && (ticket = this.getTicket(null, p)) != null) {
            user.setTransientAttribute("com.sap.security.core.usermanagement", "MYSAPSSO2_STRING", (Object)ticket);
            user.setTransientAttribute("com.sap.security.core.usermanagement", "$MYSAPSSO$", null);
        }
        if ((o = req.getAttribute("javax.servlet.request.X509Certificate")) != null && o instanceof X509Certificate[]) {
            user.setTransientAttribute("com.sap.security.core.usermanagement", "$X509CERT$", o);
        } else if (req.isSecure()) {
            Object[] objectArray;
            if (o != null) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = ":";
                objectArray = objectArray2;
                objectArray2[1] = o;
            } else {
                objectArray = new Object[]{};
            }
            trace.infoT("enrichUser", "Invalid or no certificate in request{0} {1}", objectArray);
        }
    }

    private void enrichUser(Principal p, IUser user, Subject subject, String authscheme) throws SecurityException, TicketException {
        Set<Object> sCreds;
        if (subject == null) {
            return;
        }
        String ticket = this.getTicket(subject, p);
        if (ticket != null) {
            user.setTransientAttribute("com.sap.security.core.usermanagement", "MYSAPSSO2_STRING", (Object)ticket);
            user.setTransientAttribute("com.sap.security.core.usermanagement", "$MYSAPSSO$", null);
        }
        if ((sCreds = subject.getPublicCredentials()) != null) {
            Iterator<Object> iCreds = sCreds.iterator();
            while (iCreds.hasNext()) {
                Object o = iCreds.next();
                if (!(o instanceof X509Certificate[])) continue;
                user.setTransientAttribute("com.sap.security.core.usermanagement", "$X509CERT$", o);
            }
        }
        user.setTransientAttribute("com.sap.security.core.usermanagement", "j_authscheme", (Object)authscheme);
    }

    public void logout(HttpServletRequest req, HttpServletResponse resp) {
        String METHOD = "logout";
        String strAuthscheme = this.getAuthscheme(null);
        String auth_config = null;
        IEngineResourceHelper ierh = InternalUMFactory.getEngineResourceHelper();
        AuthSchemeFactory asf = InternalUMFactory.getAuthSchemeFactory();
        SAPJ2EECallbackHandler cbh = new SAPJ2EECallbackHandler(req, resp);
        if (strAuthscheme != null) {
            IAuthScheme authscheme = asf.getAuthScheme(strAuthscheme);
            auth_config = authscheme == null ? UMFactory.getProperties().get("ume.login.context", "client_cert") : authscheme.getAuthenticationTemplate();
        } else {
            auth_config = this.getLoginModulStackFromTicket(req);
            if (auth_config == null) {
                return;
            }
        }
        IUser user = this.getLoggedInUser(req, resp);
        ierh.logoutFromSecuritySession(auth_config, cbh);
        cbh.reset();
        if (SecurityAudit.isLogged("LOGOFF.OK")) {
            SecurityAudit.log("LOGOFF.OK", user != null ? user.getUniqueID() : null, null);
        }
    }

    private String getLoginModulStackForAuthscheme(String authscheme) {
        IAuthScheme ias = InternalUMFactory.getAuthSchemeFactory().getAuthScheme(authscheme);
        if (ias == null) {
            throw new IllegalStateException("no authscheme with name " + authscheme + " known");
        }
        return ias.getAuthenticationTemplate();
    }

    private CallbackHandler getHandler(HttpServletRequest req, HttpServletResponse resp) {
        return new SAPJ2EECallbackHandler(req, resp);
    }

    private String getAuthscheme(Subject subject) {
        Set set;
        Object p = null;
        boolean bMustBe = false;
        IEngineResourceHelper ierh = InternalUMFactory.getEngineResourceHelper();
        if (subject == null) {
            subject = ierh.getCurrentSubject();
            if (subject == null) {
                return null;
            }
        } else {
            bMustBe = true;
        }
        if ((set = subject.getPrincipals(class$com$sap$security$api$logon$AuthSchemePrincipal == null ? (class$com$sap$security$api$logon$AuthSchemePrincipal = SAPJ2EEAuthenticator.class$("com.sap.security.api.logon.AuthSchemePrincipal")) : class$com$sap$security$api$logon$AuthSchemePrincipal)) != null && set.size() > 0) {
            return ((Principal)set.iterator().next()).getName();
        }
        if (bMustBe) {
            return null;
        }
        String auth_template = ierh.getAuthenticationConfiguration();
        if (auth_template == null) {
            trace.warningT("getAuthscheme", "No authentication template attached to session/subject");
            return null;
        }
        IAuthScheme authscheme = InternalUMFactory.getAuthSchemeFactory().getAuthSchemeByAuthTemplate(auth_template);
        if (authscheme == null) {
            return null;
        }
        return authscheme.getName();
    }

    private static String replacePercentHex(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        StringBuffer bufTicket = new StringBuffer(value);
        int i = 0;
        while (i < bufTicket.length()) {
            if (bufTicket.charAt(i) == '%') {
                int c = Integer.parseInt(bufTicket.substring(i + 1, i + 3), 16);
                String s = new String(new byte[]{(byte)c});
                bufTicket.replace(i, i + 3, s);
            }
            ++i;
        }
        return bufTicket.toString();
    }

    private String getTicket(Subject subject, Principal p) throws SecurityException {
        Set<Object> sCreds;
        String ticket = null;
        IEngineResourceHelper ierh = InternalUMFactory.getEngineResourceHelper();
        if (subject == null) {
            if (ierh == null) {
                return ticket;
            }
            subject = ierh.getCurrentSubject();
        }
        if (subject == null) {
            return ticket;
        }
        if (p == null) {
            p = this.getPrincipalFromSubject(subject);
        }
        if ((sCreds = subject.getPrivateCredentials()) != null) {
            Iterator<Object> iCreds = sCreds.iterator();
            while (iCreds.hasNext()) {
                Object o = iCreds.next();
                if (!(o instanceof GenericCredential)) continue;
                GenericCredential gc = (GenericCredential)o;
                String oid = gc.getMechType();
                if (!p.getName().equals(gc.getName()) || !"1.3.6.1.4.1.694.2.1.3".equals(oid)) continue;
                ticket = new String(gc.getCredentialData());
            }
        }
        return ticket;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

