/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.logon.imp;

import com.sap.security.api.AuthenticationFailedException;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserAccount;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.UserLockedException;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.logon.imp.DefaultPrincipal;
import com.sap.security.core.logon.imp.WebCallback;
import com.sap.security.core.util.IUMTrace;
import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class RemoteUserLoginModule
implements LoginModule {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/logon/imp/RemoteUserLoginModule.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";
    private static IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/logon/imp/RemoteUserLoginModule.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)");
    private CallbackHandler callbackHandler;
    private boolean commitSucceeded = false;
    private String headerName = null;
    private Map options;
    private Map sharedState;
    private Subject subject;
    private boolean succeeded = false;
    IUserAccount userAccount = null;
    private String userID;
    private DefaultPrincipal userPrincipal;
    IUser user = null;

    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.userID = null;
            this.userPrincipal = null;
        } else {
            this.logout();
        }
        return true;
    }

    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        this.userPrincipal = new DefaultPrincipal(this.userAccount);
        if (!this.subject.getPrincipals().contains(this.userPrincipal)) {
            if (!this.subject.isReadOnly()) {
                this.subject.getPrincipals().add(this.userPrincipal);
                trace.infoT("HeaderVariableLoginModule", "added DefaultPrincipal to Subject");
            } else {
                trace.warningT("HeaderVariableLoginModule", "Subject is read only, can't add Principal");
            }
        }
        this.userID = null;
        this.commitSucceeded = true;
        return true;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.headerName = (String)options.get("Header");
        if (this.headerName == null) {
            this.headerName = UMFactory.getProperties().get("ume.logon.header", "remote-user");
        }
    }

    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to garner authentication information from the user");
        }
        Callback[] callbacks = new Callback[]{new WebCallback()};
        try {
            this.callbackHandler.handle(callbacks);
            this.userID = ((WebCallback)((Object)callbacks[0])).getRequest().getRemoteUser();
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("Error: " + uce.getCallback().toString() + " not available to garner authentication information " + "from the user");
        }
        if (this.userID == null || this.userID.trim().equals("")) {
            trace.infoT("HeaderVariableLoginModule", "HTTP Header Variable " + this.headerName + " not filled");
            this.succeeded = false;
        } else {
            try {
                this.succeeded = false;
                this.userAccount = UMFactory.getUserAccountFactory().getUserAccountByLogonId(this.userID);
                this.user = this.userAccount.getAssignedUser();
                this.subject.getPrincipals().add((Principal)this.user);
                this.succeeded = true;
                trace.infoT("DefaultLoginModule", "user entered userID: " + this.userID);
            }
            catch (AuthenticationFailedException afex) {
                trace.errorT("HeaderVariableLoginModule", "Authentication error: credentials could not be verified.", afex);
            }
            catch (UserLockedException ulex) {
                trace.errorT("HeaderVariableLoginModule", "Authentication error: user is locked.", ulex);
            }
            catch (UMException umex) {
                trace.errorT("HeaderVariableLoginModule", "Authentication error.", umex);
            }
        }
        if (!this.succeeded) {
            trace.warningT("HeaderVariableLoginModule", "authentication failed");
            this.userID = null;
            throw new FailedLoginException("Password Incorrect");
        }
        return this.succeeded;
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.userPrincipal);
        this.succeeded = false;
        this.succeeded = this.commitSucceeded;
        this.userID = null;
        this.userPrincipal = null;
        return true;
    }
}

