/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.logon.imp;

import com.sap.security.api.logon.IAuthScheme;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.logon.imp.WebLoginCallbackHandler;
import com.sap.security.core.util.IUMTrace;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LoginContext {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/logon/imp/LoginContext.java#2 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)";
    private static IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/logon/imp/LoginContext.java#2 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)");
    IAuthScheme authscheme = null;
    public static final AppConfigurationEntry.LoginModuleControlFlag OPTIONAL = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
    public static final AppConfigurationEntry.LoginModuleControlFlag SUFFICIENT = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
    public static final AppConfigurationEntry.LoginModuleControlFlag REQUISITE = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
    public static final AppConfigurationEntry.LoginModuleControlFlag REQUIRED = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;

    public LoginContext(IAuthScheme authscheme) {
        this.authscheme = authscheme;
    }

    public Subject personalizeRequest(HttpServletRequest req, HttpServletResponse resp) throws LoginException {
        Subject subject = new Subject(false, new HashSet(8), new HashSet(), new HashSet());
        Hashtable checker = new Hashtable(5);
        HashMap sharedMap = new HashMap(10);
        Throwable onthewayException = null;
        boolean bOverallAuthFailed = false;
        boolean bOneModuleSucceeded = false;
        WebLoginCallbackHandler callbackhandler = new WebLoginCallbackHandler(req, resp);
        AppConfigurationEntry[] ces = this.authscheme.getModules();
        int i = 0;
        while (i < ces.length) {
            block14: {
                String name = ces[i].getLoginModuleName();
                Object module = checker.get(ces[i].getLoginModuleName());
                if (module == null) {
                    Class<?> clazz = null;
                    try {
                        clazz = Class.forName(ces[i].getLoginModuleName(), true, Thread.currentThread().getContextClassLoader());
                        module = clazz.newInstance();
                    }
                    catch (ClassCastException ex) {
                        throw new LoginException("Logon failed, handler has wrong type");
                    }
                    catch (ClassNotFoundException cnfe) {
                        trace.errorT("personalizeRequest", "Can't load LoginModule " + name, cnfe);
                        throw new LoginException("Logon failed, missing handler");
                    }
                    catch (InstantiationException ie) {
                        throw new LoginException("Logon failed, instantiation failed");
                    }
                    catch (IllegalAccessException ie) {
                        throw new LoginException("Logon failed, access to class denied");
                    }
                    checker.put(name, module);
                }
                Map<String, ?> moduleOptionsMap = ces[i].getOptions();
                if (module instanceof LoginModule) {
                    LoginModule loginmodule = (LoginModule)module;
                    loginmodule.initialize(subject, callbackhandler, sharedMap, moduleOptionsMap);
                    try {
                        loginmodule.login();
                        loginmodule.commit();
                        bOneModuleSucceeded = true;
                        if (ces[i].getControlFlag() == SUFFICIENT) {
                        }
                        break block14;
                    }
                    catch (LoginException le) {
                        if (ces[i].getControlFlag() == REQUIRED) {
                            bOverallAuthFailed = true;
                            onthewayException = le;
                            break block14;
                        }
                        if (ces[i].getControlFlag() != REQUISITE) break block14;
                        bOverallAuthFailed = true;
                        onthewayException = le;
                    }
                    break;
                }
            }
            ++i;
        }
        if (bOverallAuthFailed || !bOneModuleSucceeded) {
            Enumeration enumeration = checker.elements();
            while (enumeration.hasMoreElements()) {
                LoginModule lm = (LoginModule)enumeration.nextElement();
                lm.abort();
            }
            throw new LoginException(onthewayException != null ? onthewayException.getMessage() : "USER_AUTH_FAILED");
        }
        return subject;
    }

    public void unpersonalizeRequest(Subject user) {
    }
}

