/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.logon.imp;

import com.sap.security.api.IUser;
import com.sap.security.api.IUserAccount;
import com.sap.security.api.NoSuchUserException;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.logon.IAuthScheme;
import com.sap.security.api.logon.ILogonAuthentication;
import com.sap.security.api.logon.ILogonFrontend;
import com.sap.security.api.session.ISSOSession;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.imp.UserAccountFactory;
import com.sap.security.core.logon.imp.DefaultPrincipal;
import com.sap.security.core.logon.imp.LoginContext;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.SecurityAudit;
import com.sap.tc.logging.Location;
import com.sap.util.monitor.jarm.IMonitor;
import com.sap.util.monitor.jarm.TaskMonitor;
import iaik.security.provider.IAIK;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;

public class JUMAuthenticator
implements ILogonAuthentication {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/logon/imp/JUMAuthenticator.java#5 $ from $DateTime: 2004/11/04 13:54:08 $ ($Change: 17563 $)";
    private static IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/logon/imp/JUMAuthenticator.java#5 $ from $DateTime: 2004/11/04 13:54:08 $ ($Change: 17563 $)");
    private static final Location myLoc = Location.getLocation((Class)(class$com$sap$security$core$logon$imp$JUMAuthenticator == null ? (class$com$sap$security$core$logon$imp$JUMAuthenticator = JUMAuthenticator.class$("com.sap.security.core.logon.imp.JUMAuthenticator")) : class$com$sap$security$core$logon$imp$JUMAuthenticator));
    private static final IUMParameters mySAPProperties = UMFactory.getProperties();
    public static final String AUTHSCHEME_DEFAULT = "default";
    public static final String LOGIN_AUTHSCHEMES_DEFAULT = "login.authschemes.default";
    public static final String USE_HTTPS_LOGON = "ume.logon.use_https";
    public static final String USE_HTTPS_REDIRECT = "ume.logon.use_https_redirect";
    public static final String ALLOW_CERT_LOGON = "ume.logon.allow_cert";
    public static final String UM_HTTPS_PORT = "ume.logon.https_port";
    public static final String UM_LOGON_SCHEMA = "ume.logon.schema";
    public static final String HTML_REDIRECT = "ume.logon.html_redirect";
    public static final String EXTERNAL_LOGON_URL = "ume.logon.external_url";
    public static final String UM_APPLICATION_SERVER = "ume.logon.application_server";
    public static final String UM_APPLICATION_SERVER_HTTPS_PORT = "ume.logon.application_server.https_port";
    public static final String ENCODE_REDIRECT_URL = "ume.logon.encode_redirect_url";
    public static final String UM_DEFAULT_REDIRECT_URL = "ume.logon.default_redirect_url";
    public static final String UM_ADMIN_SELFREG = "ume.logon.selfreg";
    public static final String UM_ADMIN_LOGON_HELP = "ume.logon.logon_help";
    public static final String UM_ADMIN_LOGON_PWD_RESET = "ume.logon.pwd_reset";
    private static final String CERT_LOGON_SERVLET = "/logon/logonCertServlet";
    private static final String DEFAULT_LOGON_SERVLET = "/logon/logonServlet";
    private static final String INVALID_LOGON_SCHEMA = "INVALID_LOGON_SCHEMA";
    private static final String uidPasswordLogonAction = "uidPasswordLogon";
    private static IUMParameters conf = null;
    private static ThreadLocal mycontext = new ThreadLocal();
    static /* synthetic */ Class class$com$sap$security$core$logon$imp$JUMAuthenticator;
    static /* synthetic */ Class class$com$sap$security$api$IUser;
    static /* synthetic */ Class class$com$sap$security$core$logon$imp$DefaultPrincipal;

    public JUMAuthenticator() {
        String methodName = "Contructor";
        if (trace.bePath()) {
            trace.entering(methodName);
            trace.exiting(methodName);
        }
    }

    public boolean isAuthSchemeSufficient(IUser user, String authSchemeName) {
        IAuthScheme authScheme = InternalUMFactory.getAuthSchemeFactory().getAuthScheme(authSchemeName);
        int maxWeight = -1;
        String[] authschemes = (String[])user.getTransientAttribute("com.sap.security.core.usermanagement", "j_authscheme");
        if (authschemes != null) {
            int j = 0;
            while (j < authschemes.length) {
                IAuthScheme currentAS = InternalUMFactory.getAuthSchemeFactory().getAuthScheme(authschemes[j]);
                if (currentAS != null && currentAS.getPriority() > maxWeight) {
                    maxWeight = currentAS.getPriority();
                }
                ++j;
            }
        }
        if (authScheme == null) {
            throw new IllegalStateException(INVALID_LOGON_SCHEMA);
        }
        return maxWeight >= authScheme.getPriority();
    }

    public IAuthScheme[] getAuthSchemes() {
        return InternalUMFactory.getAuthSchemeFactory().getAuthSchemes();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IUser getLoggedInUser(HttpServletRequest req, HttpServletResponse resp) {
        IUser iUser;
        IMonitor monitor;
        block13: {
            monitor = null;
            String monitorString = "UME:getLoggedInUser";
            IUser user = null;
            try {
                monitor = TaskMonitor.getRequestMonitor(null, (String)"UME:getLoggedInUser");
                monitor.startComponent("UME:getLoggedInUser");
                ISSOSession sess = InternalUMFactory.getSessionFactory().getSSOSession(req, resp);
                if (!sess.isNew()) {
                    String user_id = (String)sess.getAttribute("com.sap.security.user_id");
                    if (user_id != null) {
                        try {
                            user = UMFactory.getUserFactory().getUserByLogonID(user_id);
                            String authSchemeName = (String)sess.getAttribute("j_authscheme");
                            if (user.getTransientAttribute("com.sap.security.core.usermanagement", "j_authscheme") == null) {
                                user.setTransientAttribute("com.sap.security.core.usermanagement", "j_authscheme", (Object)authSchemeName);
                            }
                            JUMAuthenticator.setUserThreadAttribute(user_id);
                            user.setTransientAttribute("com.sap.security.core.usermanagement", "MYSAPSSO2_STRING", sess.getAttribute("$MYSAPSSO$"));
                            user.setTransientAttribute("com.sap.security.core.usermanagement", "$MYSAPSSO$", null);
                        }
                        catch (NoSuchUserException ex) {
                            trace.infoT("getLoggedInUser", ex);
                        }
                        catch (UMException ex) {
                            trace.infoT("getLoggedInUser", ex);
                        }
                    } else {
                        JUMAuthenticator.setUserThreadAttribute(null);
                    }
                }
                if (req.getParameter("login_submit") != null && user == null) {
                    try {
                        Subject sub = this.logon(req, resp, req.getParameter("j_authscheme"));
                        user = (IUser)sub.getPrincipals().iterator().next();
                    }
                    catch (Exception ex) {
                        trace.warningT("getLoggedInUser", "Parameter \"login_submit\" set, but logon failed.", ex);
                    }
                }
                iUser = user;
                Object var11_12 = null;
                if (monitor == null) return iUser;
                if (user == null) break block13;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (monitor == null) throw throwable;
                if (user != null) {
                    monitor.setUser(user.getUniqueName());
                }
                monitor.endComponent("UME:getLoggedInUser");
                monitor.endRequest("UME:getLoggedInUser");
                throw throwable;
            }
            monitor.setUser(user.getUniqueName());
        }
        monitor.endComponent("UME:getLoggedInUser");
        monitor.endRequest("UME:getLoggedInUser");
        return iUser;
    }

    public ILogonFrontend getLogonFrontend(String authSchemeName) {
        IAuthScheme authScheme = InternalUMFactory.getAuthSchemeFactory().getAuthScheme(authSchemeName);
        return authScheme != null ? authScheme.getLogonFrontend() : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IUser forceLoggedInUser(HttpServletRequest req, HttpServletResponse resp) {
        IUser iUser;
        IUser user;
        IMonitor monitor;
        block45: {
            IUser it;
            block44: {
                IUser iUser2;
                block41: {
                    block42: {
                        monitor = null;
                        String monitorString = "UME:forceLoggedInUser";
                        user = null;
                        try {
                            monitor = TaskMonitor.getRequestMonitor(null, (String)"UME:forceLoggedInUser");
                            monitor.startComponent("UME:forceLoggedInUser");
                            String methodName = "forceLoggedInUser";
                            if (trace.bePath()) {
                                trace.entering(methodName);
                            }
                            if ((user = this.getLoggedInUser(req, resp)) != null) {
                                if (trace.bePath()) {
                                    trace.exiting(methodName);
                                }
                                iUser2 = user;
                                Object var20_9 = null;
                                if (monitor == null) return iUser2;
                                if (user == null) break block41;
                                break block42;
                            }
                            int baseauthenabled = mySAPProperties.getNumber("ume.login.basicauthentication", 1);
                            if (baseauthenabled == 1 || baseauthenabled == 2) {
                                block43: {
                                    String authorization = req.getHeader("Authorization");
                                    if (authorization != null) {
                                        try {
                                            Subject subject = this.logon(req, resp, null);
                                            Set principals = subject.getPrincipals(class$com$sap$security$api$IUser == null ? (class$com$sap$security$api$IUser = JUMAuthenticator.class$("com.sap.security.api.IUser")) : class$com$sap$security$api$IUser);
                                            if (principals != null && (it = principals.iterator()).hasNext()) {
                                                user = (IUser)it.next();
                                            }
                                            if (user == null) break block43;
                                            if (trace.bePath()) {
                                                trace.exiting(methodName);
                                            }
                                            it = user;
                                            break block44;
                                        }
                                        catch (LoginException lex) {
                                            trace.infoT(methodName, "Basic authentication header found, but cannot login.", lex);
                                        }
                                    }
                                }
                                if (baseauthenabled == 2) {
                                    String basicRealm = mySAPProperties.get("ume.login.basicauthentication.realm", "Authentication");
                                    resp.setHeader("WWW-Authenticate", "Basic Realm=" + basicRealm);
                                    try {
                                        resp.sendError(401);
                                    }
                                    catch (IOException ioex) {
                                        if (trace.beError()) {
                                            trace.errorT("forceLoggedInUser", "forceLoggedInUser(): " + ioex.toString(), ioex);
                                        }
                                        if (trace.bePath()) {
                                            trace.exiting(methodName);
                                        }
                                        it = null;
                                        Object var20_11 = null;
                                        if (monitor == null) return it;
                                        if (user != null) {
                                            monitor.setUser(user.getUniqueName());
                                        }
                                        monitor.endComponent("UME:forceLoggedInUser");
                                        monitor.endRequest("UME:forceLoggedInUser");
                                        return it;
                                    }
                                }
                            }
                            boolean httpsLogon = mySAPProperties.getBoolean(USE_HTTPS_LOGON, false);
                            boolean httpsRedirect = mySAPProperties.getBoolean(USE_HTTPS_REDIRECT, httpsLogon);
                            String forceLoggedInURL = this.getExternalLogonURL(req);
                            if (forceLoggedInURL.indexOf(CERT_LOGON_SERVLET) >= 0) {
                                httpsLogon = true;
                            }
                            if (trace.beDebug()) {
                                StringBuffer msgBuf1 = new StringBuffer(USE_HTTPS_LOGON);
                                msgBuf1.append("=");
                                msgBuf1.append(httpsLogon);
                                trace.debugT("forceLoggedInUser", new String(msgBuf1));
                                StringBuffer msgBuf2 = new StringBuffer(USE_HTTPS_REDIRECT);
                                msgBuf2.append("=");
                                msgBuf2.append(httpsRedirect);
                                trace.debugT("forceLoggedInUser", new String(msgBuf2));
                            }
                            try {
                                int index3;
                                int index2;
                                if (httpsLogon) {
                                    String dp = null;
                                    if (forceLoggedInURL.indexOf("://") > 0) {
                                        int index1 = forceLoggedInURL.indexOf("//");
                                        index2 = forceLoggedInURL.indexOf(":", index1 + 2);
                                        index3 = forceLoggedInURL.indexOf("/", index1 + 2);
                                        dp = index2 > 0 && index2 < index3 ? forceLoggedInURL.substring(index1, index2) : forceLoggedInURL.substring(index1, index3);
                                        forceLoggedInURL = "https:" + dp + forceLoggedInURL.substring(index3);
                                    } else {
                                        forceLoggedInURL = "https://" + req.getServerName() + forceLoggedInURL;
                                    }
                                }
                                String invokedURL = req.getRequestURI();
                                if (req.getQueryString() != null) {
                                    invokedURL = invokedURL + "?" + URLEncoder.encode(URLDecoder.decode(req.getQueryString()));
                                }
                                if (forceLoggedInURL.indexOf("://") >= 0) {
                                    StringBuffer reqUtilURL = HttpUtils.getRequestURL((HttpServletRequest)req);
                                    String callingURL = reqUtilURL.toString();
                                    if (trace.beDebug()) {
                                        trace.debugT(methodName, "Calling URL=" + callingURL);
                                    }
                                    int index = callingURL.indexOf("//");
                                    int endindex = callingURL.indexOf("/", index + 2);
                                    if (index >= 0) {
                                        String protocol = callingURL.substring(0, index);
                                        String domainport = callingURL.substring(index, endindex);
                                        String appServer = mySAPProperties.get(UM_APPLICATION_SERVER, null);
                                        if (appServer != null) {
                                            domainport = "//" + appServer;
                                        }
                                        invokedURL = protocol + domainport + invokedURL;
                                    }
                                }
                                if (httpsRedirect && !invokedURL.substring(0, 4).equalsIgnoreCase("https") && invokedURL.indexOf("http") >= 0) {
                                    int index1 = invokedURL.indexOf("//");
                                    index2 = invokedURL.indexOf(":", index1 + 2);
                                    index3 = invokedURL.indexOf("/", index1 + 2);
                                    if (index2 > 0 && index2 < index3) {
                                        String domain_name = invokedURL.substring(index1, index2);
                                        String url = invokedURL.substring(index3);
                                        String port = mySAPProperties.get(UM_APPLICATION_SERVER_HTTPS_PORT, null);
                                        if (port != null) {
                                            domain_name = domain_name + ":" + port;
                                        }
                                        invokedURL = "https:" + domain_name + url;
                                    }
                                }
                                if (trace.beDebug()) {
                                    trace.debugT(methodName, "invokedURL=" + invokedURL);
                                }
                                boolean encodeURL = mySAPProperties.getBoolean(ENCODE_REDIRECT_URL, true);
                                String encodedurl = invokedURL;
                                if (encodeURL) {
                                    encodedurl = URLEncoder.encode(URLDecoder.decode(invokedURL));
                                }
                                String redirectURL = null;
                                if (forceLoggedInURL.endsWith("=")) {
                                    redirectURL = forceLoggedInURL + encodedurl;
                                } else {
                                    String redirectEncoded = "redirectURL=" + encodedurl;
                                    redirectURL = forceLoggedInURL.indexOf("?") >= 0 ? forceLoggedInURL + "&" + redirectEncoded : forceLoggedInURL + "?" + redirectEncoded;
                                }
                                if (trace.beDebug()) {
                                    StringBuffer msgBuf = new StringBuffer("forceLoggedInUser(): Redirecting to: ");
                                    msgBuf.append(redirectURL);
                                    trace.debugT("forceLoggedInUser", new String(msgBuf));
                                }
                                JUMAuthenticator.doRedirect(redirectURL, req, resp);
                            }
                            catch (Exception e) {
                                myLoc.traceThrowableT(500, "UME:forceLoggedInUser", (Throwable)e);
                                trace.logFatalT("Fatal error occured during logon.", new Object[]{req, resp});
                            }
                            if (trace.bePath()) {
                                trace.exiting(methodName);
                            }
                            iUser = null;
                            break block45;
                        }
                        catch (Throwable throwable) {
                            Object var20_13 = null;
                            if (monitor == null) throw throwable;
                            if (user != null) {
                                monitor.setUser(user.getUniqueName());
                            }
                            monitor.endComponent("UME:forceLoggedInUser");
                            monitor.endRequest("UME:forceLoggedInUser");
                            throw throwable;
                        }
                    }
                    monitor.setUser(user.getUniqueName());
                }
                monitor.endComponent("UME:forceLoggedInUser");
                monitor.endRequest("UME:forceLoggedInUser");
                return iUser2;
            }
            Object var20_10 = null;
            if (monitor == null) return it;
            if (user != null) {
                monitor.setUser(user.getUniqueName());
            }
            monitor.endComponent("UME:forceLoggedInUser");
            monitor.endRequest("UME:forceLoggedInUser");
            return it;
        }
        Object var20_12 = null;
        if (monitor == null) return iUser;
        if (user != null) {
            monitor.setUser(user.getUniqueName());
        }
        monitor.endComponent("UME:forceLoggedInUser");
        monitor.endRequest("UME:forceLoggedInUser");
        return iUser;
    }

    public void forceLogoffUser(HttpServletRequest req, HttpServletResponse resp, String appUrl) {
        String methodName = "forceLogoffUser";
        if (trace.bePath()) {
            trace.entering(methodName);
        }
        this.logout(req, resp);
        boolean httpsLogon = mySAPProperties.getBoolean(USE_HTTPS_LOGON, false);
        boolean httpsRedirect = mySAPProperties.getBoolean(USE_HTTPS_REDIRECT, httpsLogon);
        String forceLoggedInURL = this.getExternalLogonURL(req);
        if (forceLoggedInURL.indexOf(CERT_LOGON_SERVLET) >= 0) {
            httpsLogon = true;
        }
        if (trace.beDebug()) {
            StringBuffer msgBuf1 = new StringBuffer(USE_HTTPS_LOGON);
            msgBuf1.append("=");
            msgBuf1.append(httpsLogon);
            trace.debugT(methodName, new String(msgBuf1));
            StringBuffer msgBuf2 = new StringBuffer(USE_HTTPS_REDIRECT);
            msgBuf2.append("=");
            msgBuf2.append(httpsRedirect);
            trace.debugT(methodName, new String(msgBuf2));
        }
        try {
            String invokedURL;
            int index3;
            int index2;
            if (httpsLogon) {
                String dp = null;
                if (forceLoggedInURL.indexOf("://") > 0) {
                    int index1 = forceLoggedInURL.indexOf("//");
                    index2 = forceLoggedInURL.indexOf(":", index1 + 2);
                    index3 = forceLoggedInURL.indexOf("/", index1 + 2);
                    dp = index2 > 0 && index2 < index3 ? forceLoggedInURL.substring(index1, index2) : forceLoggedInURL.substring(index1, index3);
                    forceLoggedInURL = "https:" + dp + forceLoggedInURL.substring(index3);
                } else {
                    forceLoggedInURL = "https://" + req.getServerName() + forceLoggedInURL;
                }
            }
            if ((invokedURL = appUrl) == null) {
                invokedURL = req.getRequestURI();
                if (req.getQueryString() != null) {
                    invokedURL = invokedURL + "?" + URLEncoder.encode(URLDecoder.decode(req.getQueryString()));
                }
            }
            if (forceLoggedInURL.indexOf("://") >= 0) {
                StringBuffer reqUtilURL = HttpUtils.getRequestURL((HttpServletRequest)req);
                String callingURL = reqUtilURL.toString();
                if (trace.beDebug()) {
                    trace.debugT(methodName, "Calling URL=" + callingURL);
                }
                int index = callingURL.indexOf("//");
                int endindex = callingURL.indexOf("/", index + 2);
                if (index >= 0) {
                    String protocol = callingURL.substring(0, index);
                    String domainport = callingURL.substring(index, endindex);
                    String appServer = mySAPProperties.get(UM_APPLICATION_SERVER, null);
                    if (appServer != null) {
                        domainport = "//" + appServer;
                    }
                    invokedURL = protocol + domainport + invokedURL;
                }
            }
            if (httpsRedirect && !invokedURL.substring(0, 4).equalsIgnoreCase("https") && invokedURL.indexOf("http") >= 0) {
                int index1 = invokedURL.indexOf("//");
                index2 = invokedURL.indexOf(":", index1 + 2);
                index3 = invokedURL.indexOf("/", index1 + 2);
                if (index2 > 0 && index2 < index3) {
                    String domain_name = invokedURL.substring(index1, index2);
                    String url = invokedURL.substring(index3);
                    String port = mySAPProperties.get(UM_APPLICATION_SERVER_HTTPS_PORT, null);
                    if (port != null) {
                        domain_name = domain_name + ":" + port;
                    }
                    invokedURL = "https:" + domain_name + url;
                }
            }
            if (trace.beDebug()) {
                trace.debugT(methodName, "invokedURL=" + invokedURL);
            }
            boolean encodeURL = mySAPProperties.getBoolean(ENCODE_REDIRECT_URL, true);
            String encodedurl = invokedURL;
            if (encodeURL) {
                encodedurl = URLEncoder.encode(URLDecoder.decode(invokedURL));
            }
            String redirectURL = null;
            redirectURL = forceLoggedInURL.endsWith("=") ? forceLoggedInURL + encodedurl : (forceLoggedInURL.indexOf("?") >= 0 ? forceLoggedInURL + "logoff=&" + "redirectURL" + "=" + encodedurl : forceLoggedInURL + "?logoff=&" + "redirectURL" + "=" + encodedurl);
            if (trace.beDebug()) {
                StringBuffer msgBuf = new StringBuffer(methodName + ": Redirecting to: ");
                msgBuf.append(redirectURL);
                trace.debugT(methodName, new String(msgBuf));
            }
            JUMAuthenticator.doRedirect(redirectURL, req, resp);
            req.getSession().invalidate();
        }
        catch (Exception e) {
            trace.errorT(methodName, "forceLoggedInUser(): " + e.toString(), e);
        }
        if (trace.bePath()) {
            trace.exiting(methodName);
        }
    }

    public synchronized void initialize(Properties confWhichIsNeverUsed) {
        String methodName = "initialize";
        if (trace.bePath()) {
            trace.entering(methodName);
        }
        JUMAuthenticator jUMAuthenticator = this;
        synchronized (jUMAuthenticator) {
            conf = UMFactory.getProperties();
            trace.infoT("init", "Adding IAIK Security Provider.");
            Security.addProvider((Provider)new IAIK());
        }
        if (trace.bePath()) {
            trace.exiting(methodName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Subject logon(HttpServletRequest req, HttpServletResponse resp, String authscheme) throws LoginException {
        Subject subject;
        IMonitor monitor;
        block43: {
            monitor = null;
            String monitorString = "UME:logon";
            String uaccName = null;
            try {
                IAuthScheme scheme;
                monitor = TaskMonitor.getRequestMonitor(null, (String)"UME:logon");
                monitor.startComponent("UME:logon");
                if (authscheme == null) {
                    authscheme = UMFactory.getProperties().get(LOGIN_AUTHSCHEMES_DEFAULT, AUTHSCHEME_DEFAULT);
                }
                if ((scheme = this.getAuthSchemeForName(authscheme)) == null) {
                    if (!SecurityAudit.isLogged("LOGIN.ERROR")) throw new LoginException("Invalid scheme: " + authscheme);
                    HashMap<String, String> secAuditDetails = new HashMap<String, String>();
                    if (UMFactory.getProperties().getBoolean("ume.logon.security_policy.log_client_hostaddress", true)) {
                        secAuditDetails.put("IP Address", req.getRemoteAddr());
                    }
                    if (UMFactory.getProperties().getBoolean("ume.logon.security_policy.log_client_hostname", false)) {
                        secAuditDetails.put("Host", req.getRemoteHost());
                    }
                    secAuditDetails.put("UserID", "" + req.getParameter("j_user"));
                    secAuditDetails.put("Reason", "Invalid scheme: " + authscheme);
                    secAuditDetails.put("Login Method", "" + authscheme);
                    SecurityAudit.log("LOGIN.ERROR", null, secAuditDetails);
                    throw new LoginException("Invalid scheme: " + authscheme);
                }
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Subject subject2 = null;
                LoginException exceptionOnTheRun = null;
                try {
                    Object var14_14;
                    try {
                        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                        LoginContext sapLoginContext = new LoginContext(scheme);
                        subject2 = sapLoginContext.personalizeRequest(req, resp);
                    }
                    catch (LoginException lex) {
                        exceptionOnTheRun = lex;
                        if (SecurityAudit.isLogged("LOGIN.ERROR")) {
                            HashMap<String, String> secAuditDetails = new HashMap<String, String>();
                            if (UMFactory.getProperties().getBoolean("ume.logon.security_policy.log_client_hostaddress", true)) {
                                secAuditDetails.put("IP Address", req.getRemoteAddr());
                            }
                            if (UMFactory.getProperties().getBoolean("ume.logon.security_policy.log_client_hostname", false)) {
                                secAuditDetails.put("Host", req.getRemoteHost());
                            }
                            secAuditDetails.put("UserID", "" + req.getParameter("j_user"));
                            secAuditDetails.put("Reason", lex.getMessage());
                            secAuditDetails.put("Login Method", "" + authscheme);
                            SecurityAudit.log("LOGIN.ERROR", null, secAuditDetails);
                        }
                        trace.infoT("logon", "Can't personalize request. Error in Login Context.", lex);
                        var14_14 = null;
                        Thread.currentThread().setContextClassLoader(cl);
                    }
                    var14_14 = null;
                    Thread.currentThread().setContextClassLoader(cl);
                }
                catch (Throwable throwable) {
                    Object var14_15 = null;
                    Thread.currentThread().setContextClassLoader(cl);
                    throw throwable;
                }
                IUserAccount uacc = null;
                try {
                    if (exceptionOnTheRun != null) {
                        throw exceptionOnTheRun;
                    }
                    Set defaultPrincipals = subject2.getPrincipals(class$com$sap$security$core$logon$imp$DefaultPrincipal == null ? (class$com$sap$security$core$logon$imp$DefaultPrincipal = JUMAuthenticator.class$("com.sap.security.core.logon.imp.DefaultPrincipal")) : class$com$sap$security$core$logon$imp$DefaultPrincipal);
                    if (defaultPrincipals != null) {
                        Iterator it = defaultPrincipals.iterator();
                        if (it.hasNext()) {
                            DefaultPrincipal dp = (DefaultPrincipal)it.next();
                            uacc = dp.getUserAccount();
                        } else {
                            Set<Principal> principals = subject2.getPrincipals();
                            if (principals != null) {
                                Iterator<Principal> it2 = principals.iterator();
                                if (it2.hasNext()) {
                                    Principal principito = it2.next();
                                    uacc = UMFactory.getUserAccountFactory().getUserAccountByLogonId(principito.getName());
                                }
                            } else {
                                trace.infoT("login", "login of the login modules succeded, but no principals were sent.");
                            }
                        }
                    }
                    if (null == uacc) {
                        HashMap<String, String> secAuditDetails;
                        if (scheme != null) {
                            if (!SecurityAudit.isLogged("LOGIN.ERROR")) throw new LoginException("USER_AUTH_FAILED");
                            secAuditDetails = new HashMap<String, String>();
                            if (UMFactory.getProperties().getBoolean("ume.logon.security_policy.log_client_hostaddress", true)) {
                                secAuditDetails.put("IP Address", req.getRemoteAddr());
                            }
                            if (UMFactory.getProperties().getBoolean("ume.logon.security_policy.log_client_hostname", false)) {
                                secAuditDetails.put("Host", req.getRemoteHost());
                            }
                            SecurityAudit.log("LOGIN.ERROR", null, secAuditDetails);
                            throw new LoginException("USER_AUTH_FAILED");
                        }
                        trace.errorT("login", "Iteration through logonHandlers failed.");
                        if (!SecurityAudit.isLogged("LOGIN.ERROR")) throw new LoginException("USER_AUTH_FAILED");
                        secAuditDetails = new HashMap();
                        if (UMFactory.getProperties().getBoolean("ume.logon.security_policy.log_client_hostaddress", true)) {
                            secAuditDetails.put("IP Address", req.getRemoteAddr());
                        }
                        if (UMFactory.getProperties().getBoolean("ume.logon.security_policy.log_client_hostname", false)) {
                            secAuditDetails.put("Host", req.getRemoteHost());
                        }
                        secAuditDetails.put("Reason", "Iteration through logonHandlers failed.");
                        SecurityAudit.log("LOGIN.ERROR", null, secAuditDetails);
                        throw new LoginException("USER_AUTH_FAILED");
                    }
                    uaccName = uacc.getLogonUid();
                    IUser user = uacc.getAssignedUser();
                    defaultPrincipals = subject2.getPrincipals(class$com$sap$security$api$IUser == null ? (class$com$sap$security$api$IUser = JUMAuthenticator.class$("com.sap.security.api.IUser")) : class$com$sap$security$api$IUser);
                    if (defaultPrincipals != null) {
                        Iterator it = defaultPrincipals.iterator();
                        try {
                            if (it.hasNext()) {
                                user = (IUser)it.next();
                            } else {
                                subject2.getPrincipals().add((Principal)user);
                            }
                        }
                        catch (ClassCastException cce) {
                            trace.warningT("login", "tried to get IUser object from Principal. Using assigned user from account.");
                        }
                    }
                    if (exceptionOnTheRun != null) {
                        throw exceptionOnTheRun;
                    }
                    IUserAccount mutUacc = uacc.isMutable() ? uacc : UMFactory.getUserAccountFactory().getMutableUserAccount(uacc.getUniqueID());
                    if (mutUacc != null) {
                        mutUacc.setLastSuccessfulLogonDate(new Date());
                        mutUacc.incrementSuccessfulLogonCounts();
                        mutUacc.resetFailedLogonAttempts();
                        try {
                            mutUacc.commit();
                        }
                        catch (UMException umex) {
                            trace.warningT("login", "Can't save Security Policy data: " + umex.getMessage());
                        }
                    } else {
                        trace.warningT("login", "Can't get mutable user of " + uacc.getLogonUid() + ". Can't save Security Policy data.");
                    }
                    ISSOSession session = InternalUMFactory.getSessionFactory().getSSOSession(req, resp);
                    HashMap<Object, String> map = new HashMap<Object, String>();
                    map.put("j_authscheme", scheme.getName());
                    map.put("com.sap.security.user_id", uacc.getLogonUid());
                    map.put(class$com$sap$security$api$IUser == null ? (class$com$sap$security$api$IUser = JUMAuthenticator.class$("com.sap.security.api.IUser")) : class$com$sap$security$api$IUser, (String)user);
                    session.setAttributes(map);
                    JUMAuthenticator.setUserThreadAttribute(uacc.getLogonUid());
                    user.setTransientAttribute("com.sap.security.core.usermanagement", "j_authscheme", (Object)scheme.getName());
                    user.setTransientAttribute("com.sap.security.core.usermanagement", "MYSAPSSO2_STRING", session.getAttribute("$MYSAPSSO$"));
                    user.setTransientAttribute("com.sap.security.core.usermanagement", "$MYSAPSSO$", null);
                    this.setLanguage(req, user);
                    if (SecurityAudit.isLogged("LOGIN.OK")) {
                        HashMap<String, String> secAuditDetails = new HashMap<String, String>();
                        if (UMFactory.getProperties().getBoolean("ume.logon.security_policy.log_client_hostaddress", true)) {
                            secAuditDetails.put("IP Address", req.getRemoteAddr());
                        }
                        if (UMFactory.getProperties().getBoolean("ume.logon.security_policy.log_client_hostname", false)) {
                            secAuditDetails.put("Host", req.getRemoteHost());
                        }
                        SecurityAudit.log("LOGIN.OK", uacc.getUniqueID(), secAuditDetails);
                    }
                }
                catch (UMException umex) {
                    throw new LoginException(umex.getMessage());
                }
                subject = subject2;
                Object var19_25 = null;
                if (monitor == null) return subject;
                if (uaccName == null) break block43;
            }
            catch (Throwable throwable) {
                Object var19_26 = null;
                if (monitor == null) throw throwable;
                if (uaccName != null) {
                    monitor.setUser(uaccName);
                }
                monitor.endComponent("UME:logon");
                monitor.endRequest("UME:logon");
                throw throwable;
            }
            monitor.setUser(uaccName);
        }
        monitor.endComponent("UME:logon");
        monitor.endRequest("UME:logon");
        return subject;
    }

    private void setLanguage(HttpServletRequest req, IUser user) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                if ("ume.logon.locale".equals(cookies[i].getName())) {
                    user.setTransientAttribute("com.sap.security.core.usermanagement", "ume.logon.locale", (Object)cookies[i].getValue());
                }
                ++i;
            }
        }
    }

    public void logout(HttpServletRequest req, HttpServletResponse resp) {
        ISSOSession session = InternalUMFactory.getSessionFactory().getSSOSession(req, resp);
        try {
            String logonID = (String)session.getAttribute("com.sap.security.user_id");
            String uniqueID = UMFactory.getUserAccountFactory().getUserAccountByLogonId(logonID).getUniqueID();
            IUserAccount mutUacc = UMFactory.getUserAccountFactory().getMutableUserAccount(uniqueID);
            if (mutUacc != null) {
                mutUacc.setLastLogoutDate(new Date());
                mutUacc.commit();
            } else {
                trace.warningT("login", "Can't get mutable user of " + logonID + ". Can't save Security Policy data.");
            }
            UserAccountFactory.userAccountLogOutPerformed(logonID);
            if (SecurityAudit.isLogged("LOGOFF.OK")) {
                SecurityAudit.log("LOGOFF.OK", mutUacc.getUniqueID(), null);
            }
        }
        catch (UMException ex) {
            trace.warningT("login", "Can't save Security Policy data. Reason: " + ex.getMessage());
        }
        ISSOSession iSSOSession = session;
        synchronized (iSSOSession) {
            session.invalidate();
        }
        JUMAuthenticator.setUserThreadAttribute(null);
    }

    private IAuthScheme getAuthSchemeForName(String name) {
        return InternalUMFactory.getAuthSchemeFactory().getAuthScheme(name);
    }

    private String getExternalLogonURL(HttpServletRequest req) {
        String url = mySAPProperties.get(EXTERNAL_LOGON_URL, DEFAULT_LOGON_SERVLET).trim();
        if (url.indexOf(DEFAULT_LOGON_SERVLET) < 0 && url.indexOf(CERT_LOGON_SERVLET) < 0) {
            int ind = url.indexOf("://");
            if (ind < 0) {
                url = "http://" + url;
                ind = 4;
            }
            if (ind > 0) {
                if ((ind = url.indexOf("/", ind + 3)) < 0) {
                    url = url + DEFAULT_LOGON_SERVLET;
                } else if (ind + 1 == url.length()) {
                    url = url + DEFAULT_LOGON_SERVLET.substring(1);
                }
            }
        }
        return url;
    }

    public static void doRedirect(String redirectURL, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean html_redirect;
        String methodname = "doRedirect";
        if (redirectURL == null || redirectURL.equals("")) {
            redirectURL = mySAPProperties.get(UM_DEFAULT_REDIRECT_URL, "/");
        } else {
            String schema = (String)req.getAttribute("schema");
            if (schema == null) {
                schema = (String)req.getSession().getAttribute("schema");
            }
            String uid = null;
            String pswd = null;
            uid = (String)req.getAttribute("j_user");
            pswd = (String)req.getAttribute("j_password");
            String parms = "";
            if (schema != null) {
                parms = parms + "&schema=" + schema;
            }
            if (uid != null) {
                parms = parms + "&xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx=&uidPasswordLogon=&j_user=" + uid;
            }
            if (pswd != null) {
                parms = parms + "&j_password=" + pswd;
            }
            if (parms.length() > 0) {
                parms = parms.substring(1);
            }
            if (parms.length() > 0) {
                int ind = redirectURL.indexOf("?");
                redirectURL = ind >= 0 ? redirectURL.substring(0, ind + 1) + parms + "&" + redirectURL.substring(ind + 1) : redirectURL + "?" + parms;
            }
        }
        if (trace.beInfo()) {
            trace.infoT(methodname, "Redirect: " + redirectURL);
        }
        if (!(html_redirect = mySAPProperties.getBoolean(HTML_REDIRECT, false))) {
            resp.sendRedirect(redirectURL);
            if (trace.beInfo()) {
                trace.infoT(methodname, "redirecting to " + redirectURL);
            }
        } else {
            try {
                PrintWriter out = resp.getWriter();
                out.println("<!doctype html public \"-//W3C//DTD HTML 4.0 Transitional//EN\">");
                out.println("<html><head><title>Logging in...</title></HEAD>");
                out.println("<script>");
                out.println("window.location.replace('" + redirectURL + "')");
                out.println("</script>");
                out.println("<BODY>");
                out.println("</BODY></HTML>");
                out.close();
                if (trace.beInfo()) {
                    trace.infoT(methodname, "html redirecting to " + redirectURL);
                }
            }
            catch (IOException e) {
                StringBuffer msgBuf = new StringBuffer("Error on redirection to ");
                msgBuf.append(redirectURL);
                msgBuf.append(":");
                msgBuf.append(e.toString());
                trace.errorT(methodname, e);
            }
        }
    }

    private static void setUserThreadAttribute(String logonId) {
        if (mycontext != null) {
            mycontext.set(logonId);
        }
    }

    private static String getUserThreadAttribute() {
        if (mycontext != null) {
            return (String)mycontext.get();
        }
        return null;
    }

    public boolean isAuthenticated(IUser user) {
        if (user != null) {
            String[] attrs = user.getAttribute("$serviceUser$", "SERVICEUSER_ATTRIBUTE");
            if (attrs != null && attrs.length > 0 && attrs[0].equals("IS_SERVICEUSER")) {
                return true;
            }
            Object authSchemeDingens = user.getTransientAttribute("com.sap.security.core.usermanagement", "j_authscheme");
            if ("anonymous".equals(authSchemeDingens)) {
                return true;
            }
            Object ticketString = user.getTransientAttribute("com.sap.security.core.usermanagement", "MYSAPSSO2_STRING");
            if (ticketString != null && authSchemeDingens != null) {
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

