/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.logon.imp;

import com.sap.security.api.UMFactory;
import com.sap.security.api.logon.IAuthScheme;
import com.sap.security.api.logon.ILogonFrontend;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.logon.imp.SimpleAuthScheme;
import com.sap.security.core.logon.imp.SimpleLogonFrontend;
import com.sap.security.core.util.IUMTrace;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.login.AppConfigurationEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class AuthSchemeFactory {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/logon/imp/AuthSchemeFactory.java#3 $ from $DateTime: 2004/06/09 16:32:18 $ ($Change: 16222 $)";
    private static final Location myLoc = Location.getLocation((Class)(class$com$sap$security$core$logon$imp$AuthSchemeFactory == null ? (class$com$sap$security$core$logon$imp$AuthSchemeFactory = AuthSchemeFactory.class$("com.sap.security.core.logon.imp.AuthSchemeFactory")) : class$com$sap$security$core$logon$imp$AuthSchemeFactory));
    private static final String AUTHSCHEME = "authscheme";
    private static final String AUTHSCHEMES = "authschemes";
    private static final String CONTROLFLAG = "controlFlag";
    private static final String FRONTENDTARGET = "frontendtarget";
    private static final String FRONTENDTYPE = "frontendtype";
    private static final String LOGINMODULE = "loginmodule";
    private static final String LOGINMODULENAME = "loginModuleName";
    private static final String AUTHTEMPLATE = "authentication-template";
    private static final String OPTIONS = "options";
    private static final String PRIORITY = "priority";
    private static final String AS_REF = "authscheme-ref";
    private static final String AS_REFS = "authscheme-refs";
    private HashMap authSchemes = null;
    private Map authSchemeByAuthTemplate = null;
    private InputStream configFileName = null;
    private static IUMTrace trace = null;
    static /* synthetic */ Class class$com$sap$security$core$logon$imp$AuthSchemeFactory;

    public AuthSchemeFactory(InputStream configFileName) {
        trace = InternalUMFactory.getTrace(VERSIONSTRING);
        this.configFileName = configFileName;
        this.authSchemes = new HashMap();
        this.authSchemeByAuthTemplate = new HashMap();
        this.loadAuthSchemes();
        if (this.authSchemes.isEmpty()) {
            trace.errorT("AuthSchemeFactory", "NO auth scheme loaded. Using default auth scheme.");
            SimpleLogonFrontend frontend = new SimpleLogonFrontend(2, "standardogon.default");
            SimpleAuthScheme defAuthScheme = new SimpleAuthScheme(UMFactory.getProperties().get("ume.login.context", "ticket"), (ILogonFrontend)frontend, 1, "default");
            this.authSchemes.put(defAuthScheme.getName(), defAuthScheme);
        }
    }

    public void refresh() {
        this.authSchemeByAuthTemplate = new HashMap();
        this.authSchemes = new HashMap();
        this.loadAuthSchemes();
    }

    public IAuthScheme[] getAuthSchemes() {
        Object[] os = this.authSchemes.keySet().toArray();
        IAuthScheme[] authschemes = new IAuthScheme[os.length];
        int i = 0;
        while (i < os.length) {
            authschemes[i] = (IAuthScheme)this.authSchemes.get(os[i]);
            ++i;
        }
        return authschemes;
    }

    public IAuthScheme getAuthScheme(String name) {
        if (name == null) {
            return null;
        }
        return (IAuthScheme)this.authSchemes.get(name);
    }

    public IAuthScheme getAuthSchemeByAuthTemplate(String name) {
        if (name == null) {
            return null;
        }
        return (IAuthScheme)this.authSchemeByAuthTemplate.get(name);
    }

    private void loadAuthSchemes() {
        Document document;
        Element eAuthSchemes;
        String methodName = "loadAuthSchemes";
        if (trace.bePath()) {
            trace.entering(methodName);
        }
        if ((eAuthSchemes = XMLUtil.getElementChildByName((document = XMLUtil.loadXMLFile(this.configFileName)).getDocumentElement(), AUTHSCHEMES)) != null) {
            NodeList nlAuthschemes = eAuthSchemes.getChildNodes();
            int i = 0;
            while (i < nlAuthschemes.getLength()) {
                Node nAuthScheme = nlAuthschemes.item(i);
                if (nAuthScheme.getNodeType() == 1) {
                    Vector vAppConfEntries = new Vector(5);
                    String auth_template = XMLUtil.getElementChildContentByName(nAuthScheme, AUTHTEMPLATE);
                    String priority = XMLUtil.getElementChildContentByName(nAuthScheme, PRIORITY);
                    String frontendType = XMLUtil.getElementChildContentByName(nAuthScheme, FRONTENDTYPE);
                    String frontendTarget = XMLUtil.getElementChildContentByName(nAuthScheme, FRONTENDTARGET);
                    SimpleLogonFrontend frontend = null;
                    if (frontendType != null && frontendTarget != null) {
                        frontend = new SimpleLogonFrontend(Integer.parseInt(frontendType), frontendTarget);
                    }
                    SimpleAuthScheme authScheme = new SimpleAuthScheme(auth_template, (ILogonFrontend)frontend, priority != null ? Integer.parseInt(priority) : 0, XMLUtil.getAttributeValue(nAuthScheme, "name"));
                    this.authSchemes.put(authScheme.getName(), authScheme);
                    this.authSchemeByAuthTemplate.put(auth_template, authScheme);
                }
                ++i;
            }
        } else {
            trace.warningT(methodName, "No \"authschemes\" section found!");
        }
        Element eRefAuthSchemes = XMLUtil.getElementChildByName(document.getDocumentElement(), AS_REFS);
        if (eRefAuthSchemes != null) {
            NodeList nlRefs = eRefAuthSchemes.getChildNodes();
            int i = 0;
            while (i < nlRefs.getLength()) {
                if (nlRefs.item(i).getNodeType() == 1) {
                    Node nRef = nlRefs.item(i);
                    String name = XMLUtil.getElementChildContentByName(nRef, AUTHSCHEME);
                    IAuthScheme tempAS = this.getAuthScheme(name);
                    if (tempAS != null) {
                        AuthSchemeReference asr = new AuthSchemeReference(XMLUtil.getAttributeValue(nRef, "name"), tempAS);
                        this.authSchemes.put(asr.getName(), asr);
                    } else {
                        trace.errorT(methodName, "Tried to reference non-existing authscheme\"" + name + "\"!");
                    }
                }
                ++i;
            }
        } else {
            trace.warningT(methodName, "No \"authscheme-ref\" section found!");
        }
        if (trace.bePath()) {
            trace.exiting(methodName);
        }
    }

    private AppConfigurationEntry.LoginModuleControlFlag getControlFlag(String flag) {
        AppConfigurationEntry.LoginModuleControlFlag rc = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
        if (flag != null) {
            if ("optional".equals(flag.trim().toLowerCase())) {
                rc = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
            } else if ("required".equals(flag.trim().toLowerCase())) {
                rc = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
            } else if ("requisite".equals(flag.trim().toLowerCase())) {
                rc = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
            } else if ("sufficient".equals(flag.trim().toLowerCase())) {
                rc = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
            }
        }
        return rc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class XMLUtil {
        static /* synthetic */ Class class$com$sap$security$core$logon$imp$AuthSchemeFactory$XMLUtil;

        XMLUtil() {
        }

        static Document loadXMLFile(InputStream inputStream) {
            String methodName = "XMLUtil.loadXMLFile";
            DocumentBuilderFactory factory = null;
            ClassLoader current = Thread.currentThread().getContextClassLoader();
            ClassLoader mine = (class$com$sap$security$core$logon$imp$AuthSchemeFactory$XMLUtil == null ? (class$com$sap$security$core$logon$imp$AuthSchemeFactory$XMLUtil = XMLUtil.class$("com.sap.security.core.logon.imp.AuthSchemeFactory$XMLUtil")) : class$com$sap$security$core$logon$imp$AuthSchemeFactory$XMLUtil).getClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(mine);
                factory = DocumentBuilderFactory.newInstance();
                Object var6_5 = null;
                Thread.currentThread().setContextClassLoader(current);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                Thread.currentThread().setContextClassLoader(current);
                throw throwable;
            }
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder parser = null;
            try {
                parser = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException pcex) {
                myLoc.traceThrowableT(500, methodName, "Can't create DocumentBuilder.", (Throwable)pcex);
                trace.logFatalT("Exception during instantiation of XML parser.", new Object[]{inputStream});
            }
            Document document = null;
            try {
                document = parser.parse(inputStream, "ISO-8859-1");
            }
            catch (IOException ioex) {
                String errorMessage = "Error while opening config file: " + ioex.getMessage();
                myLoc.traceThrowableT(500, methodName, errorMessage, (Throwable)ioex);
                trace.logFatalT("Exception during parsin.", new Object[]{inputStream});
            }
            catch (SAXException saxex) {
                String errorMessage = "Error while parsing config file: " + saxex.getMessage();
                myLoc.traceThrowableT(500, methodName, "Can't create DocumentBuilder.", (Throwable)saxex);
                trace.logFatalT("Exception during parsin.", new Object[]{inputStream});
            }
            return document;
        }

        static Element[] getElementChildrenByName(Node node, String name) {
            Vector<Element> stapel = new Vector<Element>();
            Element element = XMLUtil.getFirstChildElement(node);
            String nodeName = null;
            while (element != null && (nodeName = element.getNodeName()) != null) {
                if (nodeName.equals(name)) {
                    stapel.add(element);
                }
                element = XMLUtil.getNextSiblingElement(element);
            }
            Element[] rc = new Element[stapel.size()];
            int i = 0;
            while (i < rc.length) {
                rc[i] = (Element)stapel.get(i);
                ++i;
            }
            return rc;
        }

        static Element getElementChildByName(Node node, String name) {
            Element element = XMLUtil.getFirstChildElement(node);
            String nodeName = null;
            while (!(element == null || (nodeName = element.getNodeName()) != null && nodeName.equals(name))) {
                element = XMLUtil.getNextSiblingElement(element);
            }
            return element;
        }

        static String getElementChildContentByName(Node node, String name) {
            Node child;
            Element element = XMLUtil.getElementChildByName(node, name);
            if (element != null && (child = element.getFirstChild()) != null && (child.getNodeType() == 3 || child.getNodeType() == 4)) {
                String result = ((Text)child).getData();
                return XMLUtil.trimWhiteSpace(result);
            }
            return null;
        }

        static String getElementContent(Element element) {
            Node child;
            if (element != null && (child = element.getFirstChild()) != null && (child.getNodeType() == 3 || child.getNodeType() == 4)) {
                String result = ((Text)child).getData();
                return XMLUtil.trimWhiteSpace(result);
            }
            return null;
        }

        static Element getFirstChildElement(Node node) {
            if (node != null) {
                if ((node = node.getFirstChild()) == null) {
                    return null;
                }
                if (node.getNodeType() == 1) {
                    return (Element)node;
                }
                return XMLUtil.getNextSiblingElement(node);
            }
            return null;
        }

        static Element getNextSiblingElement(Node node) {
            if (node != null) {
                node = node.getNextSibling();
                while (node != null && node.getNodeType() != 1) {
                    node = node.getNextSibling();
                }
                return (Element)node;
            }
            return null;
        }

        static String getAttributeValue(Node node, String name) {
            String rc = null;
            NamedNodeMap attrs = node.getAttributes();
            Node attr = attrs.getNamedItem(name);
            if (attr != null) {
                rc = attr.getNodeValue();
            }
            return rc;
        }

        static boolean isWhiteSpaceChar(char ch) {
            return ch == ' ' || ch == '\r' || ch == '\n' || ch == '\t';
        }

        static String trimWhiteSpace(String data) {
            if (data == null) {
                return "";
            }
            int b = 0;
            while (b < data.length() && XMLUtil.isWhiteSpaceChar(data.charAt(b))) {
                ++b;
            }
            int e = data.length() - 1;
            while (e > 0 && e > b && XMLUtil.isWhiteSpaceChar(data.charAt(e))) {
                --e;
            }
            data = data.substring(b, e + 1);
            return data;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    class AuthSchemeReference
    implements IAuthScheme {
        private String name = null;
        private IAuthScheme authScheme = null;

        AuthSchemeReference(String name, IAuthScheme authScheme) {
            this.name = name;
            this.authScheme = authScheme;
        }

        public String getName() {
            return this.name;
        }

        public int getPriority() {
            return this.authScheme.getPriority();
        }

        public AppConfigurationEntry[] getModules() {
            return this.authScheme.getModules();
        }

        public ILogonFrontend getLogonFrontend() {
            return this.authScheme.getLogonFrontend();
        }

        public String toString() {
            return "Reference " + this.name + " to " + this.authScheme;
        }

        public String getAuthenticationTemplate() {
            return this.authScheme.getAuthenticationTemplate();
        }
    }
}

