/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.logon.imp;

import com.sap.security.api.IUser;
import com.sap.security.api.IUserAccount;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.logon.IAnonymousUserFactory;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.util.IUMTrace;
import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;

public class AnonymousUser
implements IAnonymousUserFactory {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/logon/imp/AnonymousUser.java#5 $ from $DateTime: 2005/01/27 17:07:03 $ ($Change: 17889 $)";
    private static IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/logon/imp/AnonymousUser.java#5 $ from $DateTime: 2005/01/27 17:07:03 $ ($Change: 17889 $)");
    public static String ANONYMOUS_USER = "anonymous";
    public static String ANONYMOUS_USER_MODE = "ume.login.anonymous_user.mode";
    public static String GUEST_USER_UNIQUEIDS = "ume.login.guest_user.uniqueids";
    public static String GUEST_USER_UNIQUEID = "ume.login.guest_user.uniqueid";
    public static String GUEST_USER_DEFAULTID = "ume.login.guest_user.defaultid";
    public static String GUEST_USER_PARAMETER_NAME = "ume.login.guest_user.parameter_name";
    private static AnonymousUser instance = null;
    private boolean m_bGuestUserEnabled = true;
    private HashSet m_hsGuestUserLogonIds;
    private HashSet m_hsGuestUserUniqueIds;
    private HashSet m_hsGuestAccountUniqueIds;
    private String m_sGuestUserUniqueId;
    private String m_sGuestUserDefaultId;
    static /* synthetic */ Class class$com$sap$security$core$logon$imp$AnonymousUser;

    private AnonymousUser() throws UMException {
        String guestuserids = UMFactory.getProperties().get(GUEST_USER_UNIQUEIDS);
        this.m_hsGuestUserLogonIds = new HashSet();
        this.m_hsGuestUserUniqueIds = new HashSet();
        this.m_hsGuestAccountUniqueIds = new HashSet();
        if (guestuserids != null) {
            StringTokenizer st = new StringTokenizer(guestuserids, ",");
            while (st.hasMoreTokens()) {
                String nextGU = st.nextToken().trim();
                IUser nextGUser = null;
                try {
                    nextGUser = UMFactory.getUserFactory().getUserByLogonID(nextGU);
                }
                catch (UMException umex) {
                    trace.fatalT("initialize", " Cannot find guest user: " + nextGU, umex);
                    throw new UMException((Throwable)umex);
                }
                if (nextGUser == null) continue;
                this.m_hsGuestUserLogonIds.add(nextGU.toUpperCase());
                this.m_hsGuestUserUniqueIds.add(nextGUser.getUniqueID());
                IUserAccount[] uaccs = nextGUser.getUserAccounts();
                if (uaccs != null && uaccs.length > 0) {
                    this.m_hsGuestAccountUniqueIds.add(uaccs[0].getUniqueID());
                }
                if (this.m_sGuestUserDefaultId != null) continue;
                this.m_sGuestUserDefaultId = nextGU;
            }
        }
    }

    public static AnonymousUser getInstance() throws UMException {
        Class clazz = class$com$sap$security$core$logon$imp$AnonymousUser == null ? (class$com$sap$security$core$logon$imp$AnonymousUser = AnonymousUser.class$("com.sap.security.core.logon.imp.AnonymousUser")) : class$com$sap$security$core$logon$imp$AnonymousUser;
        synchronized (clazz) {
            if (instance == null) {
                instance = new AnonymousUser();
            }
        }
        return instance;
    }

    public static synchronized boolean isInitialized() throws UMException {
        return instance != null;
    }

    public String getDefaultUserId() {
        return this.m_sGuestUserDefaultId;
    }

    public Collection getGuestUserLogonIds() {
        return (Collection)this.m_hsGuestUserLogonIds.clone();
    }

    public Collection getGuestUserUniqueIds() {
        return (Collection)this.m_hsGuestUserUniqueIds.clone();
    }

    public IUser getAnonymousUser() {
        if (this.m_bGuestUserEnabled) {
            if (this.m_sGuestUserDefaultId != null) {
                try {
                    IUser user = UMFactory.getUserFactory().getUserByLogonID(this.m_sGuestUserDefaultId);
                    if (user != null) {
                        user.setTransientAttribute("com.sap.security.core.usermanagement", "j_authscheme", (Object)"anonymous");
                        return user;
                    }
                    trace.errorT("getAnonymousUser", "The default anonymous (guest) user with logon id \"" + this.m_sGuestUserDefaultId + "\" was not found!");
                }
                catch (UMException umex) {
                    trace.errorT("getAnonymousUser", "The default anonymous (guest) user with logon id \"" + this.m_sGuestUserDefaultId + "\" was not found!", umex);
                }
            } else {
                trace.warningT("getAnonymousUser", "The logon id for default anonymous (guest) user is not set in properties.");
            }
            return null;
        }
        return null;
    }

    public IUser getAnonymousUser(String logonID) throws UMException {
        IUser anonymousUser = null;
        if (this.m_bGuestUserEnabled) {
            if (logonID != null && this.m_hsGuestUserLogonIds.contains(logonID.toUpperCase())) {
                anonymousUser = UMFactory.getUserFactory().getUserByLogonID(logonID);
            } else {
                trace.warningT("getAnonymousUser", "User " + logonID + " is not in guest user list!");
                anonymousUser = this.getAnonymousUser();
            }
        }
        return anonymousUser;
    }

    public boolean isAnonymousUser(String logonID) {
        if (!this.m_bGuestUserEnabled) {
            return false;
        }
        if (logonID == null) {
            return false;
        }
        if (this.m_hsGuestUserLogonIds.contains(logonID = logonID.toUpperCase())) {
            return true;
        }
        return this.m_hsGuestUserUniqueIds.contains(logonID);
    }

    public boolean isAnonymousUserUniqueId(String uniqueId) {
        return this.m_hsGuestUserUniqueIds.contains(uniqueId.toUpperCase());
    }

    public boolean isAnonymousUserAccountUniqueId(String uniqueId) {
        return this.m_hsGuestAccountUniqueIds.contains(uniqueId.toUpperCase());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

