/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.locking.imp;

import com.sap.engine.frame.core.locking.AdministrativeLocking;
import com.sap.security.api.UMFactory;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.locking.LockException;
import com.sap.security.core.locking.TechnicalLockException;
import com.sap.security.core.util.Base64;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.imp.Util;

public class LockManager {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/locking/imp/LockManager.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";
    private static AdministrativeLocking mLocking;
    public static final String MAX_WAIT_TIME = "ume.locking.max_wait_time";
    public static final String LOCKING_ENABLED = "ume.locking.enabled";
    public static final String UME_AREA_CORE_DESCRIPTION = "UME internal locking";
    public static final String UME_AREA_API_DESCRIPTION = "UME external locking";
    public static final String UME_CORE_NAMESPACE_CHARACTER = "$";
    public static final String UME_API_NAMESPACE_CHARACTER = "$";
    public static final String UME_AREA_CORE = "$library.com.sap.security.core";
    public static final String UME_AREA_API = "$library.com.sap.security.api";
    private static IUMTrace mTrace;
    private static LockManager mInstance;
    private int mMaxWaitTime = UMFactory.getProperties().getNumber("ume.locking.max_wait_time", 30) * 1000;
    private boolean mLockingEnabled = UMFactory.getProperties().getBoolean("ume.locking.enabled", true);

    private LockManager() {
    }

    public static synchronized LockManager getInstance() {
        if (mInstance == null) {
            mInstance = new LockManager();
        }
        return mInstance;
    }

    public static void setAdministrativeLocking(AdministrativeLocking locking) {
        mLocking = locking;
        try {
            mLocking.reserveNamespace(UME_AREA_CORE, UME_AREA_CORE_DESCRIPTION);
        }
        catch (com.sap.engine.frame.core.locking.TechnicalLockException e) {
            mTrace.warningT("setAdministrativeLocking", "Cannot register UME CORE namespace \"$\" for administrative locking", e);
        }
        try {
            mLocking.reserveNamespace(UME_AREA_API, UME_AREA_API_DESCRIPTION);
        }
        catch (com.sap.engine.frame.core.locking.TechnicalLockException e) {
            mTrace.warningT("setAdministrativeLocking", "Cannot register UME API namespace \"$\" for administrative locking", e);
        }
    }

    public boolean isLockingEnabled() {
        return this.mLockingEnabled && mLocking != null;
    }

    public String getReadLock(String area, String principalID) throws LockException, TechnicalLockException {
        if (this.mLockingEnabled) {
            return this.getLock(area, principalID, 'S', this.mMaxWaitTime);
        }
        return null;
    }

    public String getReadLocks(String area, String[] principalIDs) throws LockException, TechnicalLockException {
        if (this.mLockingEnabled) {
            return this.getLocks(area, principalIDs, 'S', this.mMaxWaitTime);
        }
        return null;
    }

    public String getWriteLocks(String area, String[] principalIDs) throws LockException, TechnicalLockException {
        if (this.mLockingEnabled) {
            return this.getLocks(area, principalIDs, 'E', this.mMaxWaitTime);
        }
        return null;
    }

    public String getWriteLock(String area, String principalID) throws LockException, TechnicalLockException {
        if (this.mLockingEnabled) {
            return this.getLock(area, principalID, 'E', this.mMaxWaitTime);
        }
        return null;
    }

    public void releaseLocks(String ownerID) {
        block3: {
            if (!this.mLockingEnabled || ownerID == null || mLocking == null) {
                return;
            }
            try {
                mLocking.unlockAll(ownerID, false);
            }
            catch (Exception e) {
                if (!mTrace.beInfo()) break block3;
                mTrace.infoT("releaseLock", "Error during releasing locks of owner \"" + ownerID + "\".", e);
            }
        }
    }

    private String escapePrincipalID(String principalID) {
        String obj = Base64.encode(Util.createMD5HashValue(principalID.getBytes()));
        if (mTrace.beDebug()) {
            mTrace.debugT("escapePrincipalID", "Mapped principalid for locking: \"" + principalID + "\"-->\"" + obj + "\"");
        }
        return obj;
    }

    private String[] escapePrincipalIDs(String[] principalIDs) {
        int size = principalIDs.length;
        String[] objs = new String[size];
        int i = 0;
        while (i < size) {
            objs[i] = this.escapePrincipalID(principalIDs[i]);
            ++i;
        }
        return objs;
    }

    private String getLocks(String area, String[] principalIDs, char mode, int timeout) throws LockException, TechnicalLockException {
        if (mLocking == null || principalIDs == null) {
            return null;
        }
        try {
            int size = principalIDs.length;
            if (size == 0) {
                return null;
            }
            principalIDs = this.escapePrincipalIDs(principalIDs);
            String owner = mLocking.createUniqueOwner();
            String[] namespaces = new String[size];
            int i = 0;
            while (i < size) {
                namespaces[i] = area;
                ++i;
            }
            char[] modes = new char[size];
            int i2 = 0;
            while (i2 < size) {
                modes[i2] = mode;
                ++i2;
            }
            if (timeout >= 0) {
                mLocking.lock(owner, namespaces, principalIDs, modes, timeout);
            } else {
                mLocking.lock(owner, namespaces, principalIDs, modes);
            }
            return owner;
        }
        catch (com.sap.engine.frame.core.locking.LockException lex) {
            throw new LockException(lex);
        }
        catch (Exception e) {
            throw new TechnicalLockException(e);
        }
    }

    private String getLock(String area, String principalID, char mode, int timeout) throws LockException, TechnicalLockException {
        if (mLocking == null || principalID == null) {
            return null;
        }
        try {
            String owner = mLocking.createUniqueOwner();
            principalID = this.escapePrincipalID(principalID);
            if (timeout >= 0) {
                mLocking.lock(owner, area, principalID, mode, timeout);
            } else {
                mLocking.lock(owner, area, principalID, mode);
            }
            return owner;
        }
        catch (com.sap.engine.frame.core.locking.LockException lex) {
            throw new LockException(lex);
        }
        catch (Exception e) {
            throw new TechnicalLockException(e);
        }
    }

    static {
        mTrace = InternalUMFactory.getTrace(VERSIONSTRING);
    }
}

