/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserAccount;
import com.sap.security.api.IUserFactory;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.UMRuntimeException;
import com.sap.security.core.imp.AbstractWrapper;
import com.sap.security.core.imp.UserFactory;
import com.sap.util.monitor.jarm.ConfMonitor;
import com.sap.util.monitor.jarm.IMonitor;
import com.sap.util.monitor.jarm.TaskMonitor;
import java.lang.ref.WeakReference;
import java.security.AccessControlException;
import java.security.Permission;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;

public class UserWrapper
extends AbstractWrapper
implements IUser {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/UserWrapper.java#3 $ from $DateTime: 2004/07/30 14:01:42 $ ($Change: 16956 $)";

    public UserWrapper(IUser user, AttributeList attrList) {
        super(user.getUniqueID(), attrList);
        this.mReadonlyPrincipal = new WeakReference<IUser>(user);
    }

    public UserWrapper(String uniqueID, AttributeList attrList) {
        super(uniqueID, attrList);
    }

    public Iterator getParents(String[] principalTypeIdentifiers, boolean recursive) {
        return this.getCachedUser().getParents(principalTypeIdentifiers, recursive);
    }

    public String getUid() {
        return this.getCachedUser().getUniqueID();
    }

    public String getJobTitle() {
        return this.getCachedUser().getJobTitle();
    }

    public String getDepartment() {
        return this.getCachedUser().getDepartment();
    }

    public String getDisplayName() {
        return this.getCachedUser().getDisplayName();
    }

    public String getTitle() {
        return this.getCachedUser().getTitle();
    }

    public String getSalutation() {
        return this.getCachedUser().getSalutation();
    }

    public String getFirstName() {
        return this.getCachedUser().getFirstName();
    }

    public String getLastName() {
        return this.getCachedUser().getLastName();
    }

    public String getStreet() {
        return this.getCachedUser().getStreet();
    }

    public String getCity() {
        return this.getCachedUser().getCity();
    }

    public String getZip() {
        return this.getCachedUser().getZip();
    }

    public String getState() {
        return this.getCachedUser().getState();
    }

    public String getCountry() {
        return this.getCachedUser().getCountry();
    }

    public Locale getLocale() {
        return this.getCachedUser().getLocale();
    }

    public TimeZone getTimeZone() {
        return this.getCachedUser().getTimeZone();
    }

    public String getCurrency() {
        return this.getCachedUser().getCurrency();
    }

    public String getTelephone() {
        return this.getCachedUser().getTelephone();
    }

    public String getCellPhone() {
        return this.getCachedUser().getCellPhone();
    }

    public String getFax() {
        return this.getCachedUser().getFax();
    }

    public String getEmail() {
        return this.getCachedUser().getEmail();
    }

    public boolean isCompanyUser() {
        return this.getCachedUser().isCompanyUser();
    }

    public String getCompany() {
        return this.getCachedUser().getCompany();
    }

    public IUserFactory getUserFactory() {
        return this.getCachedUser().getUserFactory();
    }

    public boolean hasPermission(Permission permission) {
        return this.getCachedUser().hasPermission(permission);
    }

    public void checkPermission(Permission permission) throws AccessControlException {
        this.getCachedUser().checkPermission(permission);
    }

    public IUserAccount[] getUserAccounts() throws UMException {
        return this.getCachedUser().getUserAccounts();
    }

    public int getAccessibilityLevel() {
        return this.getCachedUser().getAccessibilityLevel();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Iterator getRoles(boolean recursive) {
        Iterator iterator;
        IMonitor monitor = null;
        String monitorString = "UME:AbstractPrincipal:getRoles";
        try {
            if (ConfMonitor.getComponentLevel() == 2) {
                monitor = TaskMonitor.getRequestMonitor((String)this.getUniqueName(), (String)"UME:AbstractPrincipal:getRoles");
                monitor.startComponent("UME:AbstractPrincipal:getRoles");
            }
            iterator = this.getCachedUser().getRoles(recursive);
            Object var6_5 = null;
            if (monitor == null) return iterator;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (monitor == null) throw throwable;
            monitor.endComponent("UME:AbstractPrincipal:getRoles");
            monitor.endRequest("UME:AbstractPrincipal:getRoles");
            throw throwable;
        }
        monitor.endComponent("UME:AbstractPrincipal:getRoles");
        monitor.endRequest("UME:AbstractPrincipal:getRoles");
        return iterator;
    }

    public Iterator getParentGroups(boolean recursive) {
        return this.getCachedUser().getParentGroups(recursive);
    }

    public boolean isMemberOfRole(String roleId, boolean recursive) {
        return this.getCachedUser().isMemberOfRole(roleId, recursive);
    }

    public boolean isMemberOfGroup(String groupId, boolean recursive) {
        return this.getCachedUser().isMemberOfGroup(groupId, recursive);
    }

    public String getUniqueName() {
        return this.getCachedUser().getUniqueName();
    }

    public boolean equals(Object another) {
        if (!(another instanceof IUser)) {
            return false;
        }
        IUser u = (IUser)another;
        return this.mUniqueID.equals(u.getUniqueID());
    }

    public int hashCode() {
        return this.mUniqueID.hashCode();
    }

    public String getName() {
        return this.getCachedUser().getName();
    }

    public String getUniqueID() {
        return this.mUniqueID;
    }

    public Date created() {
        return this.getCachedUser().created();
    }

    public Date lastModified() {
        return this.getCachedUser().lastModified();
    }

    public String[] getAttribute(String namespace, String name) {
        return this.getCachedUser().getAttribute(namespace, name);
    }

    public byte[] getBinaryAttribute(String namespace, String name) {
        return this.getCachedUser().getBinaryAttribute(namespace, name);
    }

    public String[] getAttributeNamespaces() {
        return this.getCachedUser().getAttributeNamespaces();
    }

    public String[] getAttributeNames(String namespace) {
        return this.getCachedUser().getAttributeNames(namespace);
    }

    public boolean isExistenceChecked() {
        return this.getCachedUser().isExistenceChecked();
    }

    public void refresh() throws UMException {
        UMFactory.getUserFactory().invalidateCacheEntry(this.mUniqueID);
        this.mReadonlyPrincipal = null;
    }

    private IUser getCachedUser() {
        try {
            IUser u = null;
            if (this.mReadonlyPrincipal != null) {
                u = (IUser)this.mReadonlyPrincipal.get();
            }
            if (u == null) {
                u = this.mAttributeList == null ? ((UserFactory)UMFactory.getUserFactory()).getReadonlyUser(this.mUniqueID) : ((UserFactory)UMFactory.getUserFactory()).getReadonlyUser(this.mUniqueID, this.mAttributeList);
                this.mReadonlyPrincipal = new WeakReference<IUser>(u);
            }
            return u;
        }
        catch (UMException umex) {
            throw new UMRuntimeException((Throwable)umex);
        }
    }

    public IUser getWrappedPrincipal() {
        return this.getCachedUser();
    }

    public boolean isMutable() {
        return this.getCachedUser().isMutable();
    }

    public String getAttributeType(String namespace, String attributeName) {
        return this.getCachedUser().getAttributeType(namespace, attributeName);
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("Transient data:\n");
        if (this.mTransientPrincipalDatabag != null) {
            res.append(this.mTransientPrincipalDatabag.toString());
        } else {
            res.append("No transient data set.\n");
        }
        res.append("Persistent data:\n");
        res.append(this.getCachedUser().toString());
        return res.toString();
    }

    public Iterator getUserAccountUniqueIDs() throws UMException {
        return this.getCachedUser().getUserAccountUniqueIDs();
    }
}

