/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.imp;

import com.sap.security.api.AttributeValueAlreadyExistsException;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserMaint;
import com.sap.security.api.NoSuchUserException;
import com.sap.security.api.PrincipalNotAccessibleException;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.UserAlreadyExistsException;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.admin.UserAdminHelper;
import com.sap.security.core.imp.AbstractPrincipal;
import com.sap.security.core.imp.PrincipalFactory;
import com.sap.security.core.imp.User;
import com.sap.security.core.imp.UserFactory;
import com.sap.security.core.imp.UserWrapper;
import com.sap.security.core.persistence.IDistributedTransaction;
import com.sap.security.core.persistence.IInternalPrincipalDatabag;
import com.sap.security.core.persistence.IInternalPrincipalDatabagMaint;
import com.sap.security.core.persistence.IPrincipalDatabag;
import com.sap.security.core.persistence.IPrincipalDatabagMaint;
import com.sap.security.core.persistence.datasource.DuplicateKeyException;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.datasource.imp.CompanyGroups;
import com.sap.security.core.persistence.imp.PrincipalDatabag;
import com.sap.security.core.persistence.imp.PrincipalDatabagMaint;
import com.sap.security.core.persistence.replication.imp.MessagingHandler;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.imp.Util;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;

public class UserMaint
extends User
implements IUserMaint {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/UserMaint.java#2 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)";
    public static final IUMTrace mTrace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/UserMaint.java#2 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)");
    private boolean mCompanyIdChanged;

    public UserMaint(String uniqueID) {
        super(uniqueID);
        this.mPrincipalDatabag = this.mFactory.getModifyPrincipalDatabag(this.mPrincipalDatabag);
        this.mPrepared = true;
        this.mCompanyIdChanged = false;
    }

    public void setAccessibilityLevel(int value) throws UMException {
        ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", "accessibilitylevel", this.convertToVector("" + value));
    }

    public UserMaint(IUser copyForm) {
        this();
        User user = (User)((UserWrapper)copyForm).getWrappedPrincipal();
        IInternalPrincipalDatabag templatesDatabag = (IInternalPrincipalDatabag)user.getPrincipalDatabag();
        String[] namespaces = user.getAttributeNamespaces();
        int i = 0;
        while (i < namespaces.length) {
            String[] attributes = user.getAttributeNames(namespaces[i]);
            int j = 0;
            while (j < attributes.length) {
                Vector values = templatesDatabag.getAttributeValues(namespaces[i], attributes[j]);
                if (values == null) {
                    try {
                        this.mFactory.populatePrincipalDatabagAttribute(templatesDatabag, namespaces[i], attributes[j]);
                    }
                    catch (PersistenceException persex) {
                        throw new PrincipalNotAccessibleException((Throwable)((Object)persex));
                    }
                }
                if ((values = templatesDatabag.getAttributeValues(namespaces[i], attributes[j])) != null) {
                    ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues(namespaces[i], attributes[j], values);
                }
                ++j;
            }
            ++i;
        }
        this.mCompanyIdChanged = false;
    }

    public UserMaint() {
        PrincipalDatabagMaint newPrincipal = new PrincipalDatabagMaint(null);
        newPrincipal.setAttributeValues("com.sap.security.core.usermanagement", "PRINCIPAL_TYPE_ATTRIBUTE", this.convertToVector("USER"));
        this.mPrincipalDatabag = newPrincipal;
        this.mPrepared = true;
        this.mCompanyIdChanged = false;
    }

    public UserMaint(IPrincipalDatabagMaint principalMaint) {
        this.mPrincipalDatabag = principalMaint;
        this.mPrepared = true;
        this.mCompanyIdChanged = false;
    }

    public boolean setTitle(String title) {
        if (title != null) {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", "title", this.convertToVector(title));
        } else {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).deleteAttributeMaintValues("com.sap.security.core.usermanagement", "title");
        }
        return true;
    }

    public boolean setSalutation(String salutation) {
        if (salutation != null) {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", "salutation", this.convertToVector(salutation));
        } else {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).deleteAttributeMaintValues("com.sap.security.core.usermanagement", "salutation");
        }
        return true;
    }

    public boolean setJobTitle(String jobtitle) {
        if (jobtitle != null) {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", "jobtitle", this.convertToVector(jobtitle));
        } else {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).deleteAttributeMaintValues("com.sap.security.core.usermanagement", "jobtitle");
        }
        return true;
    }

    public boolean setDepartment(String department) {
        if (department != null) {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", "department", this.convertToVector(department));
        } else {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).deleteAttributeMaintValues("com.sap.security.core.usermanagement", "department");
        }
        return true;
    }

    public boolean setDisplayName(String displayName) {
        if (displayName != null) {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", "displayname", this.convertToVector(displayName));
        } else {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).deleteAttributeMaintValues("com.sap.security.core.usermanagement", "displayname");
        }
        return true;
    }

    public boolean setFirstName(String firstname) {
        if (firstname != null) {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", "firstname", this.convertToVector(firstname));
        } else {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).deleteAttributeMaintValues("com.sap.security.core.usermanagement", "firstname");
        }
        return true;
    }

    public boolean setLastName(String lastname) {
        if (lastname != null) {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", "lastname", this.convertToVector(lastname));
        } else {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).deleteAttributeMaintValues("com.sap.security.core.usermanagement", "lastname");
        }
        return true;
    }

    public boolean setStreet(String street) {
        if (street != null) {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", "streetaddress", this.convertToVector(street));
        } else {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).deleteAttributeMaintValues("com.sap.security.core.usermanagement", "streetaddress");
        }
        return true;
    }

    public boolean setCity(String city) {
        if (city != null) {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", "city", this.convertToVector(city));
        } else {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).deleteAttributeMaintValues("com.sap.security.core.usermanagement", "city");
        }
        return true;
    }

    public boolean setZip(String zip) {
        if (zip != null) {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", "zip", this.convertToVector(zip));
        } else {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).deleteAttributeMaintValues("com.sap.security.core.usermanagement", "zip");
        }
        return true;
    }

    public boolean setState(String state) {
        if (state != null) {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", "state", this.convertToVector(state));
        } else {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).deleteAttributeMaintValues("com.sap.security.core.usermanagement", "state");
        }
        return true;
    }

    public boolean setCountry(String country) {
        if (country != null) {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", "country", this.convertToVector(country));
        } else {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).deleteAttributeMaintValues("com.sap.security.core.usermanagement", "country");
        }
        return true;
    }

    public boolean setLocale(Locale locale) {
        if (locale != null) {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", "locale", this.convertToVector(locale.toString()));
        } else {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).deleteAttributeMaintValues("com.sap.security.core.usermanagement", "locale");
        }
        this.mLocale = null;
        return true;
    }

    public boolean setTimeZone(TimeZone timezone) {
        if (timezone != null) {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", "timezone", this.convertToVector(timezone.getID()));
        } else {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).deleteAttributeMaintValues("com.sap.security.core.usermanagement", "timezone");
        }
        return true;
    }

    public boolean setCurrency(String currency) {
        if (currency != null) {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", "currency", this.convertToVector(currency));
        } else {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).deleteAttributeMaintValues("com.sap.security.core.usermanagement", "currency");
        }
        return true;
    }

    public boolean setTelephone(String telephone) {
        if (telephone != null) {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", "telephone", this.convertToVector(telephone));
        } else {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).deleteAttributeMaintValues("com.sap.security.core.usermanagement", "telephone");
        }
        return true;
    }

    public boolean setCellPhone(String cellphone) {
        if (cellphone != null) {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", "mobile", this.convertToVector(cellphone));
        } else {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).deleteAttributeMaintValues("com.sap.security.core.usermanagement", "mobile");
        }
        return true;
    }

    public boolean setFax(String fax) {
        if (fax != null) {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", "fax", this.convertToVector(fax));
        } else {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).deleteAttributeMaintValues("com.sap.security.core.usermanagement", "fax");
        }
        return true;
    }

    public boolean setEmail(String email) {
        if (email != null) {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", "email", this.convertToVector(email));
        } else {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).deleteAttributeMaintValues("com.sap.security.core.usermanagement", "email");
        }
        return true;
    }

    public boolean setCompany(String companyid) {
        this.mCompanyIdChanged = true;
        if (companyid != null) {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).setAttributeMaintValues("com.sap.security.core.usermanagement", "company", this.convertToVector(companyid));
        } else {
            ((IPrincipalDatabagMaint)this.mPrincipalDatabag).deleteAttributeMaintValues("com.sap.security.core.usermanagement", "company");
        }
        return true;
    }

    private String calculateUniqueName(String prefix, String lastname, String firstname) throws UMException {
        int maxTotalLength = 12;
        prefix = prefix.trim();
        int idLength = maxTotalLength - prefix.length();
        String id = null;
        if (lastname != null) {
            String fullName = lastname.trim().toUpperCase();
            if (firstname != null) {
                fullName = fullName + firstname.trim().toUpperCase();
            }
            id = fullName.length() > idLength ? prefix + fullName.substring(0, idLength) : prefix + fullName;
        }
        int loops = -1;
        try {
            while (true) {
                if (id != null) {
                    UMFactory.getUserFactory().getUserByUniqueName(id);
                }
                String time = "" + System.currentTimeMillis();
                int size = time.length();
                id = prefix;
                int i = size - 1;
                while (i > 0 && id.length() < maxTotalLength) {
                    id = id + time.charAt(i);
                    --i;
                }
                ++loops;
            }
        }
        catch (NoSuchUserException nsuex) {
            if (loops > 0) {
                // empty if block
            }
            if (mTrace.beDebug()) {
                mTrace.debugT("calculateUniqueName", nsuex);
            }
            return id;
        }
    }

    public void commit() throws UMException {
        if (this.mPrincipalDatabag.containsIllegalData()) {
            throw new UMException("Namespaces, attributes and values must not contain leading or trailing spaces.");
        }
        IDistributedTransaction dTrans = this.mFactory.createDistributedTransaction();
        boolean newUser = this.mPrincipalDatabag.getUniqueID() == null;
        try {
            if (newUser) {
                block15: {
                    try {
                        String uniqueName = this.getUniqueName();
                        if (uniqueName == null || uniqueName.equals("")) {
                            this.setUniqueName(this.calculateUniqueName("SMA", this.getLastName(), this.getFirstName()));
                        } else {
                            IUser u = UMFactory.getUserFactory().getUserByUniqueName(uniqueName);
                            if (u != null) {
                                throw new UMException("A user with the unique name " + this.getUniqueName() + " was created on the persistence in the meantime!");
                            }
                        }
                    }
                    catch (NoSuchUserException nsuex) {
                        if (!mTrace.beDebug()) break block15;
                        mTrace.debugT("commit", nsuex);
                    }
                }
                this.mPrincipalDatabag = this.mFactory.createPrincipalDatabag(dTrans, (IPrincipalDatabagMaint)this.mPrincipalDatabag);
            } else {
                this.mFactory.updatePrincipalDatabag((IPrincipalDatabagMaint)this.mPrincipalDatabag, dTrans);
            }
            dTrans.commit();
            if (newUser) {
                UserFactory.addUserPerformed(this.mPrincipalDatabag.getUniqueID());
                PrincipalDatabagMaint clearUpdateDatabag = new PrincipalDatabagMaint(this.mPrincipalDatabag.getUniqueID());
                clearUpdateDatabag.assimilatePrincipalDatabag((IInternalPrincipalDatabag)this.mPrincipalDatabag);
                this.mPrincipalDatabag = clearUpdateDatabag;
            } else {
                IUser u = ((UserFactory)UMFactory.getUserFactory()).getReadonlyUser(this.mPrincipalDatabag.getUniqueID(), Util.EMPTY_ATTRIBUTE_LIST);
                IPrincipalDatabag pd = ((AbstractPrincipal)u).getPrincipalDatabag();
                PrincipalDatabag npd = new PrincipalDatabag(this.mPrincipalDatabag.getUniqueID());
                npd.assimilatePrincipalDatabag((IInternalPrincipalDatabag)pd);
                npd.mergePrincipalDatabag((IInternalPrincipalDatabagMaint)this.mPrincipalDatabag);
                User us = new User(npd);
                ((UserFactory)UMFactory.getUserFactory()).replaceUserInCache(us);
                PrincipalFactory.invalidatePrincipalInCache(this.mPrincipalDatabag.getUniqueID());
                PrincipalFactory.editPrincipalPerformed(this.mPrincipalDatabag.getUniqueID());
                PrincipalDatabagMaint clearUpdateDatabag = new PrincipalDatabagMaint(this.mPrincipalDatabag.getUniqueID());
                clearUpdateDatabag.assimilatePrincipalDatabag(npd);
                this.mPrincipalDatabag = clearUpdateDatabag;
            }
            if (this.mCompanyIdChanged && UserAdminHelper.isCompanyConceptEnabled()) {
                CompanyGroups.invalidateCompanyGroup(this.getCompany());
            }
            if (!newUser) {
                MessagingHandler.getInstance().onUpdateMessage(new IUser[]{this});
            }
        }
        catch (DuplicateKeyException dkex) {
            if (newUser) {
                throw new UserAlreadyExistsException((Throwable)((Object)dkex), "User with unique name \"" + this.getUniqueName() + "\" already exists.");
            }
            throw new AttributeValueAlreadyExistsException((Throwable)((Object)dkex));
        }
    }

    public void save() throws UMException {
    }
}

