/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.FeatureNotAvailableException;
import com.sap.security.api.ISearchAttribute;
import com.sap.security.api.ISearchResult;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserAccount;
import com.sap.security.api.IUserAccountFactory;
import com.sap.security.api.IUserAccountSearchFilter;
import com.sap.security.api.IUserFactory;
import com.sap.security.api.IUserMaint;
import com.sap.security.api.IUserSearchFilter;
import com.sap.security.api.NoSuchUserException;
import com.sap.security.api.PrincipalIterator;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.UMRuntimeException;
import com.sap.security.api.UserAlreadyExistsException;
import com.sap.security.api.UserListener;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.imp.AbstractPrincipal;
import com.sap.security.core.imp.AbstractPrincipalSearchFilter;
import com.sap.security.core.imp.AbstractUserAccount;
import com.sap.security.core.imp.GroupFactory;
import com.sap.security.core.imp.PrincipalFactory;
import com.sap.security.core.imp.PrincipalIteratorImpl;
import com.sap.security.core.imp.PrincipalSearchFilter;
import com.sap.security.core.imp.RoleFactory;
import com.sap.security.core.imp.User;
import com.sap.security.core.imp.UserAccountFactory;
import com.sap.security.core.imp.UserMaint;
import com.sap.security.core.imp.UserSearchFilter;
import com.sap.security.core.imp.UserWrapper;
import com.sap.security.core.persistence.IDistributedTransaction;
import com.sap.security.core.persistence.IInternalPrincipalDatabag;
import com.sap.security.core.persistence.IPrincipalDatabag;
import com.sap.security.core.persistence.IPrincipalDatabagFactory;
import com.sap.security.core.persistence.datasource.PersistenceException;
import com.sap.security.core.persistence.imp.PrincipalDatabag;
import com.sap.security.core.persistence.imp.PrincipalDatabagFactory;
import com.sap.security.core.persistence.imp.PrincipalDatabagMaint;
import com.sap.security.core.persistence.imp.SearchCriteria;
import com.sap.security.core.persistence.replication.imp.MessagingHandler;
import com.sap.security.core.srvUser.imp.ServiceUserFactory;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.cache.ICache;
import com.sap.util.monitor.jarm.IMonitor;
import com.sap.util.monitor.jarm.TaskMonitor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class UserFactory
implements IUserFactory {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/UserFactory.java#6 $ from $DateTime: 2005/01/21 16:34:10 $ ($Change: 17855 $)";
    public static final IUMTrace mTrace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/UserFactory.java#6 $ from $DateTime: 2005/01/21 16:34:10 $ ($Change: 17855 $)");
    public static final String DEFAULT_USER_CACHING_TIME = "ume.cache.user.default_caching_time";
    public static final String INITIAL_USER_CACHE_SIZE = "ume.cache.user.initial_cache_size";
    private static ICache mCache;
    private static ICache mUNCache;
    private static Vector mAddUserListeners;
    private static Vector mDeleteUserListeners;
    static /* synthetic */ Class class$com$sap$security$core$imp$UserFactory;

    public synchronized void initialize(Properties properties) throws UMException {
    }

    public static ICache getCache() {
        return mCache;
    }

    public static synchronized void invalidateCache() {
        mCache.invalidate();
        mUNCache.invalidate();
        ServiceUserFactory.invalidateCache();
    }

    public static synchronized void invalidateUserInCache(String uniqueID) {
        mCache.invalidate(uniqueID);
    }

    public static synchronized void invalidateUserInCacheLocally(String uniqueID) {
        mCache.invalidateLocally(uniqueID);
    }

    public IUser getUser(String uniqueID) throws NoSuchUserException, PersistenceException {
        return this.getUser(uniqueID, User.USER_DEFAULT_ATTRIBUTES);
    }

    public void replaceUserInCache(IUser user) {
        String id = user.getUniqueID();
        mCache.invalidate(id);
        mCache.put(id, user);
    }

    public void replaceUserInCacheLocally(IUser user) {
        String id = user.getUniqueID();
        mCache.invalidateLocally(id);
        mCache.put(id, user);
    }

    public IUser getReadonlyUser(String uniqueID) throws NoSuchUserException, PersistenceException {
        return this.getReadonlyUser(uniqueID, User.USER_DEFAULT_ATTRIBUTES);
    }

    public IUser getReadonlyUser(String uniqueID, AttributeList attrlist) throws NoSuchUserException, PersistenceException {
        if (uniqueID == null) {
            throw new NoSuchUserException("Cannot find user when uniqueID is null!");
        }
        if (attrlist == null) {
            return this.getReadonlyUser(uniqueID);
        }
        IUser user = (IUser)mCache.get(uniqueID);
        AttributeList attributeToPopulate = attrlist;
        if (user == null || !((AbstractPrincipal)user).allAttributesPopulated(attrlist)) {
            try {
                if (!"IUser".equals(UMFactory.getPrincipalFactory().getPrincipalType(uniqueID))) {
                    throw new NoSuchUserException("The given id \"" + uniqueID + "\"is not a unique id of a user!");
                }
            }
            catch (UMException umex) {
                throw new NoSuchUserException((Throwable)umex);
            }
            if (user != null) {
                attributeToPopulate = ((AbstractPrincipal)user).getPopulatedAttributes().getNotContainedAttributes(attrlist);
                if (attributeToPopulate.getSize() != 0) {
                    IPrincipalDatabag pdb = PrincipalDatabagFactory.getInstance().getPrincipalDatabag(user.getUniqueID(), attributeToPopulate, true);
                    if (pdb == null) {
                        throw new NoSuchUserException("User \"" + user.getUniqueID() + "\" doesn't exist.");
                    }
                    IPrincipalDatabag pd = ((AbstractPrincipal)user).getPrincipalDatabag();
                    PrincipalDatabag npd = new PrincipalDatabag(user.getUniqueID());
                    npd.assimilatePrincipalDatabag((IInternalPrincipalDatabag)pd);
                    npd.mergePrincipalDatabag((IInternalPrincipalDatabag)pdb);
                    User usr = new User(npd);
                    this.replaceUserInCacheLocally(usr);
                    user = usr;
                }
                return user;
            }
            try {
                user = new User(uniqueID, attributeToPopulate);
            }
            catch (UMRuntimeException umrex) {
                throw new NoSuchUserException((Throwable)umrex);
            }
            mCache.put(uniqueID, user);
        }
        return user;
    }

    public IUser getUser(String uniqueID, AttributeList attributeList) throws NoSuchUserException, PersistenceException {
        IUser user = this.getReadonlyUser(uniqueID, attributeList);
        return new UserWrapper(user, attributeList);
    }

    public IUser getTrustedUser(String uniqueID) throws PersistenceException {
        return new UserWrapper(new User(uniqueID, false), User.USER_DEFAULT_ATTRIBUTES);
    }

    public IUser[] getUsers(String[] uniqueIDs) throws NoSuchUserException, PersistenceException {
        return this.getUsers(uniqueIDs, User.USER_DEFAULT_ATTRIBUTES);
    }

    public IUser[] getReadonlyUsers(String[] uniqueIDs) throws NoSuchUserException, PersistenceException {
        return this.getReadonlyUsers(uniqueIDs, User.USER_DEFAULT_ATTRIBUTES);
    }

    public IUser[] getReadonlyUsers(String[] uniqueIDs, AttributeList attributeList) throws NoSuchUserException, PersistenceException {
        IUser[] result = new IUser[uniqueIDs.length];
        IUser[] usersToMerge = new IUser[uniqueIDs.length];
        Vector<String> usersToPopulate = new Vector<String>();
        IUser user = null;
        AttributeList attributeToPopulate = new AttributeList(false);
        attributeToPopulate.addAttributeList(attributeList);
        int i = 0;
        while (i < uniqueIDs.length) {
            user = (IUser)mCache.get(uniqueIDs[i]);
            if (user == null) {
                try {
                    if (!"IUser".equals(UMFactory.getPrincipalFactory().getPrincipalType(uniqueIDs[i]))) {
                        throw new NoSuchUserException("The given id \"" + uniqueIDs[i] + "\"is not a unique id of a user!");
                    }
                }
                catch (UMException umex) {
                    throw new NoSuchUserException((Throwable)umex);
                }
            }
            if (user != null && ((AbstractPrincipal)user).allAttributesPopulated(attributeList)) {
                result[i] = user;
            } else {
                if (user != null) {
                    usersToMerge[i] = user;
                }
                usersToPopulate.add(uniqueIDs[i]);
            }
            ++i;
        }
        if (usersToPopulate.size() != 0) {
            IPrincipalDatabag[] users = PrincipalDatabagFactory.getInstance().getPrincipalDatabags(usersToPopulate.toArray(new String[usersToPopulate.size()]), attributeToPopulate, true);
            int dataBagCounter = 0;
            int i2 = 0;
            while (i2 < uniqueIDs.length) {
                if (result[i2] == null) {
                    User nu;
                    if (users[dataBagCounter] != null) {
                        if (usersToMerge[i2] != null) {
                            PrincipalDatabag pdb = new PrincipalDatabag(usersToMerge[i2].getUniqueID());
                            pdb.mergePrincipalDatabag((IInternalPrincipalDatabag)((AbstractPrincipal)usersToMerge[i2]).getPrincipalDatabag());
                            pdb.mergePrincipalDatabag((IInternalPrincipalDatabag)users[dataBagCounter]);
                            nu = new User(pdb);
                        } else {
                            nu = new User(users[dataBagCounter]);
                        }
                    } else {
                        throw new NoSuchUserException("User with id " + uniqueIDs[i2] + " not found!");
                    }
                    result[i2] = nu;
                    mCache.put(nu.getUniqueID(), nu);
                    ++dataBagCounter;
                }
                ++i2;
            }
        }
        return result;
    }

    public IUser[] getUsers(String[] uniqueIDs, AttributeList attributeList) throws NoSuchUserException, PersistenceException {
        IUser[] result = this.getReadonlyUsers(uniqueIDs, attributeList);
        int size = result.length;
        int i = 0;
        while (i < size) {
            result[i] = new UserWrapper(result[i], attributeList);
            ++i;
        }
        return result;
    }

    public void deleteUser(String uniqueID) throws UMException {
        String uname;
        IPrincipalDatabagFactory mFactory;
        block29: {
            if (uniqueID == null) {
                throw new UMException("Given unique ID is null!");
            }
            mFactory = PrincipalDatabagFactory.getInstance();
            uname = null;
            try {
                IUser user = this.getReadonlyUser(uniqueID);
                uname = user.getUniqueName();
            }
            catch (UMException umex) {
                if (mTrace.beInfo()) {
                    mTrace.infoT("deleteUser", umex);
                }
            }
            catch (UMRuntimeException umrex) {
                if (!mTrace.beInfo()) break block29;
                mTrace.infoT("deleteUser", umrex);
            }
        }
        String logonid = uname;
        try {
            int size;
            HashSet principalSets;
            Vector roles;
            Vector groups;
            Vector<String> logonIDs;
            Vector accounts;
            block30: {
                SearchCriteria sc = new SearchCriteria("UACC");
                sc.addEqualsElement("com.sap.security.core.usermanagement", "userid", uniqueID, true);
                accounts = mFactory.searchPrincipalDatabags(sc);
                logonIDs = new Vector<String>();
                if (!accounts.isEmpty()) {
                    logonid = UMFactory.getUserAccountFactory().getUserAccount((String)accounts.get(0)).getLogonUid();
                }
                SearchCriteria scGroups = new SearchCriteria("GRUP");
                scGroups.addEqualsElement("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", uniqueID, true);
                groups = mFactory.searchPrincipalDatabags(scGroups);
                SearchCriteria scRoles = new SearchCriteria("ROLE");
                scRoles.addEqualsElement("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", uniqueID, true);
                roles = mFactory.searchPrincipalDatabags(scRoles);
                principalSets = new HashSet();
                try {
                    String[] principalSetTypes = ((PrincipalFactory)UMFactory.getPrincipalFactory()).getKnownPrincipalSetTypes();
                    size = principalSetTypes.length;
                    int i = 0;
                    while (i < size) {
                        if (!principalSetTypes[i].equals("ROLE") && !principalSetTypes[i].equals("GRUP")) {
                            SearchCriteria searchFilter = new SearchCriteria(principalSetTypes[i]);
                            searchFilter.addEqualsElement("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", uniqueID, true);
                            principalSets.addAll(mFactory.searchPrincipalDatabags(searchFilter));
                        }
                        ++i;
                    }
                }
                catch (UMException umex) {
                    if (!mTrace.beInfo()) break block30;
                    mTrace.infoT("deleteUser", "Error during determination of direct parents of \"" + uniqueID + "\": " + umex.getMessage(), umex);
                }
            }
            IDistributedTransaction dTrans = mFactory.createDistributedTransaction();
            PrincipalDatabag pdb = new PrincipalDatabag(uniqueID);
            PrincipalDatabagMaint pdbMaint = null;
            size = accounts.size();
            int i = 0;
            while (i < size) {
                String _logonid = UMFactory.getUserAccountFactory().getUserAccount((String)accounts.elementAt(i)).getLogonUid();
                logonIDs.add(_logonid);
                pdbMaint = new PrincipalDatabagMaint((String)accounts.elementAt(i));
                mFactory.deletePrincipalDatabag(pdbMaint, dTrans);
                ++i;
            }
            int groupsSize = groups.size();
            int rolesSize = roles.size();
            String companyGroupIdStart = "GRUP.COMPANY_GROUPS_DATASOURCE";
            int j = 0;
            while (j < groupsSize) {
                if (UMFactory.getPrincipalFactory().isPrincipalAttributeModifiable((String)groups.elementAt(j), "com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE") && !((String)groups.elementAt(j)).startsWith(companyGroupIdStart)) {
                    pdbMaint = new PrincipalDatabagMaint((String)groups.elementAt(j));
                    pdbMaint.removeAttributeMaintValue("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", uniqueID);
                    mFactory.updatePrincipalDatabag(pdbMaint, dTrans);
                }
                ++j;
            }
            int j2 = 0;
            while (j2 < rolesSize) {
                if (UMFactory.getPrincipalFactory().isPrincipalAttributeModifiable((String)roles.elementAt(j2), "com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE")) {
                    pdbMaint = new PrincipalDatabagMaint((String)roles.elementAt(j2));
                    pdbMaint.removeAttributeMaintValue("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", uniqueID);
                    mFactory.updatePrincipalDatabag(pdbMaint, dTrans);
                }
                ++j2;
            }
            Iterator it = principalSets.iterator();
            while (it.hasNext()) {
                String pId = (String)it.next();
                if (!UMFactory.getPrincipalFactory().isPrincipalAttributeModifiable(pId, "com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE")) continue;
                pdbMaint = new PrincipalDatabagMaint(pId);
                pdbMaint.removeAttributeMaintValue("com.sap.security.core.usermanagement.relation", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", uniqueID);
                mFactory.updatePrincipalDatabag(pdbMaint, dTrans);
            }
            mFactory.deletePrincipalDatabag(pdb, dTrans);
            dTrans.commit();
            String[] aclManagers = UMFactory.getAllAclManagers();
            if (aclManagers.length > 0) {
                mTrace.infoT("deleteUser(String)", "Deleting user from ACL's: " + uniqueID);
                UMFactory.getAclManager((String)aclManagers[0]).deletePrincipal(uniqueID);
            }
            mCache.invalidate(uniqueID);
            if (uname != null) {
                mUNCache.invalidate(uname);
                ServiceUserFactory.invalidateUniqueNameMapping(uname);
            } else {
                mUNCache.invalidate();
                ServiceUserFactory.invalidateCache();
            }
            UserFactory.removeUserPerformed(uniqueID);
            int j3 = 0;
            while (j3 < groupsSize) {
                GroupFactory.unassignUserPerformed(uniqueID, (String)groups.elementAt(j3));
                GroupFactory.invalidateGroupInCache((String)groups.elementAt(j3));
                ++j3;
            }
            int j4 = 0;
            while (j4 < rolesSize) {
                RoleFactory.unassignUserPerformed((String)roles.elementAt(j4), uniqueID);
                RoleFactory.invalidateRoleInCache((String)roles.elementAt(j4));
                ++j4;
            }
            Iterator it2 = principalSets.iterator();
            while (it2.hasNext()) {
                String pId = (String)it2.next();
                PrincipalFactory.unassignPrincipalPerformed(pId, uniqueID);
                PrincipalFactory.invalidatePrincipalInCache(pId);
            }
            int i2 = 0;
            while (i2 < size) {
                UserAccountFactory.removeUserAccountPerformed((String)accounts.elementAt(i2));
                UserAccountFactory.invalidateUserAccountInCache((String)accounts.elementAt(i2));
                ++i2;
            }
            int i3 = 0;
            while (i3 < logonIDs.size()) {
                UserAccountFactory.invalidateLogonIDMapping((String)logonIDs.elementAt(i3));
                ++i3;
            }
            if (logonid != null) {
                MessagingHandler.getInstance().onDeleteMessage(new String[]{logonid}, null);
            } else if (mTrace.beInfo()) {
                mTrace.infoT("deleteUser", "No notification sent to replication because logonid couldn't be determined during deletion of user \"" + uniqueID + "\"");
            }
        }
        catch (UMRuntimeException umrex) {
            throw new UMException((Throwable)umrex);
        }
    }

    public void commitUsers(IUserMaint[] users) throws UMException {
        int size = users.length;
        try {
            int i = 0;
            while (i < size) {
                users[i].commit();
                ++i;
            }
        }
        catch (UMRuntimeException umrex) {
            throw new UMException((Throwable)umrex);
        }
    }

    public void rollbackUsers(IUserMaint[] users) {
        int size = users.length;
        int i = 0;
        while (i < size) {
            users[i].rollback();
            ++i;
        }
    }

    private Vector getDisplayNameTemplateAttributes() {
        Vector<String> result = new Vector<String>();
        String displayNameTemplate = UMFactory.getProperties().get("ume.users.displayname_template", "{lastname}, {firstname}");
        String currentToken = null;
        int startIndex = displayNameTemplate.indexOf(123);
        int endIndex = displayNameTemplate.indexOf(125, startIndex);
        boolean hasMoreTokens = endIndex > startIndex;
        int index = 0;
        while (hasMoreTokens) {
            currentToken = displayNameTemplate.substring(startIndex + 1, endIndex);
            result.add(currentToken);
            index = endIndex + 1;
            startIndex = displayNameTemplate.indexOf(123, index);
            endIndex = displayNameTemplate.indexOf(125, startIndex);
            boolean bl = hasMoreTokens = endIndex > startIndex && startIndex != -1;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ISearchResult searchUsers(IUserSearchFilter filter) throws UMException {
        PrincipalIteratorImpl principalIteratorImpl;
        if (((AbstractPrincipalSearchFilter)filter).containsIllegalData()) {
            throw new UMException("Namespaces, attributes and values must not contain leading or trailing spaces.");
        }
        IMonitor monitor = null;
        String monitorString = "UME:searchUsers";
        try {
            monitor = TaskMonitor.getRequestMonitor(null, (String)"UME:searchUsers");
            monitor.startComponent("UME:searchUsers");
            SearchCriteria sc = null;
            IUserAccountSearchFilter uaccFilter = null;
            if (((PrincipalSearchFilter)filter).isDisplayNameSet()) {
                sc = new SearchCriteria(true, "USER");
                int operatore = -1;
                Object value = null;
                boolean caseSensitive = true;
                boolean found = false;
                int i = 0;
                while (i < filter.getElementSize() && !found) {
                    ISearchAttribute sElement = filter.getSearchElementAt(i);
                    if (sElement.getAttributeName().equals("displayname") && sElement.getAttributeNameSpace().equals("com.sap.security.core.usermanagement")) {
                        found = true;
                        operatore = sElement.getOperator();
                        value = sElement.getAttributeValue();
                        caseSensitive = sElement.isCaseSensitive();
                    }
                    ++i;
                }
                if (!found) {
                    throw new UMException("Displayname attribute in searchfilter not found!");
                }
                uaccFilter = UMFactory.getUserAccountFactory().getUserAccountSearchFilter();
                Vector templateAttributes = this.getDisplayNameTemplateAttributes();
                int size = templateAttributes.size();
                switch (operatore) {
                    case 0: {
                        sc.addEqualsElement("com.sap.security.core.usermanagement", "uniquename", value, caseSensitive);
                        int i2 = 0;
                        while (i2 < size) {
                            sc.addEqualsElement("com.sap.security.core.usermanagement", (String)templateAttributes.elementAt(i2), value, caseSensitive);
                            ++i2;
                        }
                        sc.addEqualsElement("com.sap.security.core.usermanagement", "displayname", value, caseSensitive);
                        uaccFilter.setLogonUid((String)value, 0, caseSensitive);
                        break;
                    }
                    case 1: {
                        sc.addLikeElement("com.sap.security.core.usermanagement", "uniquename", value, caseSensitive);
                        int i3 = 0;
                        while (i3 < size) {
                            sc.addLikeElement("com.sap.security.core.usermanagement", (String)templateAttributes.elementAt(i3), value, caseSensitive);
                            ++i3;
                        }
                        sc.addLikeElement("com.sap.security.core.usermanagement", "displayname", value, caseSensitive);
                        uaccFilter.setLogonUid((String)value, 1, caseSensitive);
                        break;
                    }
                    case 2: {
                        sc.addGreaterThanElement("com.sap.security.core.usermanagement", "uniquename", value, caseSensitive);
                        int i4 = 0;
                        while (i4 < size) {
                            sc.addGreaterThanElement("com.sap.security.core.usermanagement", (String)templateAttributes.elementAt(i4), value, caseSensitive);
                            ++i4;
                        }
                        sc.addGreaterThanElement("com.sap.security.core.usermanagement", "displayname", value, caseSensitive);
                        uaccFilter.setLogonUid((String)value, 2, caseSensitive);
                        break;
                    }
                    case 3: {
                        sc.addLessThanElement("com.sap.security.core.usermanagement", "uniquename", value, caseSensitive);
                        int i5 = 0;
                        while (i5 < size) {
                            sc.addLessThanElement("com.sap.security.core.usermanagement", (String)templateAttributes.elementAt(i5), value, caseSensitive);
                            ++i5;
                        }
                        sc.addLessThanElement("com.sap.security.core.usermanagement", "displayname", value, caseSensitive);
                        uaccFilter.setLogonUid((String)value, 3, caseSensitive);
                    }
                }
            } else {
                sc = filter.getSearchMethod() == 0 ? new SearchCriteria(false, "USER") : new SearchCriteria(true, "USER");
                int i = 0;
                while (i < filter.getElementSize()) {
                    ISearchAttribute sElement = filter.getSearchElementAt(i);
                    String _namespace = sElement.getAttributeNameSpace();
                    String _name = sElement.getAttributeName();
                    Object _value = sElement.getAttributeValue();
                    switch (sElement.getOperator()) {
                        case 1: {
                            sc.addLikeElement(_namespace, _name, _value, sElement.isCaseSensitive());
                            break;
                        }
                        case 0: {
                            sc.addEqualsElement(_namespace, _name, _value, sElement.isCaseSensitive());
                            break;
                        }
                        case 2: {
                            sc.addGreaterThanElement(_namespace, _name, _value, sElement.isCaseSensitive());
                            break;
                        }
                        case 3: {
                            sc.addLessThanElement(_namespace, _name, _value, sElement.isCaseSensitive());
                            break;
                        }
                        default: {
                            sc.addEqualsElement(_namespace, _name, _value, sElement.isCaseSensitive());
                        }
                    }
                    ++i;
                }
            }
            sc.setSearchSizeLimit(filter.getMaxSearchResultSize());
            Vector results = PrincipalDatabagFactory.getInstance().searchPrincipalDatabags(sc);
            if (((PrincipalSearchFilter)filter).isDisplayNameSet() && uaccFilter != null) {
                ISearchResult sr = this.searchUsers(this.getUserSearchFilter(), uaccFilter);
                while (sr.hasNext()) {
                    Object id = sr.next();
                    if (results.contains(id)) continue;
                    results.add(id);
                }
            }
            PrincipalIteratorImpl principalIterator = new PrincipalIteratorImpl(results, PrincipalIterator.ITERATOR_TYPE_UNIQUEIDS_NOT_CHECKED);
            principalIterator.setState(sc.getSearchStatus());
            principalIteratorImpl = principalIterator;
            Object var19_24 = null;
            if (monitor == null) return principalIteratorImpl;
        }
        catch (Throwable throwable) {
            Object var19_25 = null;
            if (monitor == null) throw throwable;
            monitor.endComponent("UME:searchUsers");
            monitor.endRequest("UME:searchUsers");
            throw throwable;
        }
        monitor.endComponent("UME:searchUsers");
        monitor.endRequest("UME:searchUsers");
        return principalIteratorImpl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ISearchResult searchUsers(IUserSearchFilter ufilter, IUserAccountSearchFilter uafilter) throws UMException {
        ISearchResult iSearchResult;
        IMonitor monitor;
        block11: {
            PrincipalIteratorImpl principalIteratorImpl;
            block10: {
                if (((AbstractPrincipalSearchFilter)ufilter).containsIllegalData()) throw new UMException("Namespaces, attributes and values must not contain leading or trailing spaces.");
                if (((AbstractPrincipalSearchFilter)uafilter).containsIllegalData()) {
                    throw new UMException("Namespaces, attributes and values must not contain leading or trailing spaces.");
                }
                monitor = null;
                String monitorString = "UME:searchUsers:accountFilter";
                try {
                    try {
                        monitor = TaskMonitor.getRequestMonitor(null, (String)"UME:searchUsers:accountFilter");
                        monitor.startComponent("UME:searchUsers:accountFilter");
                        Vector<String> usersIDsOfAccounts = null;
                        ISearchResult accounts = null;
                        if (!((PrincipalSearchFilter)uafilter).isEmpty()) {
                            usersIDsOfAccounts = new Vector<String>();
                            accounts = UMFactory.getUserAccountFactory().search(uafilter);
                            IUserAccount dummy = null;
                            IUser dummy2 = null;
                            while (true) {
                                if (!accounts.hasNext()) {
                                    if (!((PrincipalSearchFilter)ufilter).isEmpty()) break;
                                    PrincipalIteratorImpl principalIterator = new PrincipalIteratorImpl(usersIDsOfAccounts, PrincipalIterator.ITERATOR_TYPE_UNIQUEIDS_NOT_CHECKED);
                                    principalIterator.setState(accounts.getState());
                                    principalIteratorImpl = principalIterator;
                                    Object var13_14 = null;
                                    if (monitor == null) return principalIteratorImpl;
                                    break block10;
                                }
                                dummy = UMFactory.getUserAccountFactory().getUserAccount((String)accounts.next());
                                dummy2 = dummy.getAssignedUser();
                                usersIDsOfAccounts.add(dummy2.getUniqueID());
                            }
                        }
                        ISearchResult srUser = this.searchUsers(ufilter);
                        if (usersIDsOfAccounts != null) {
                            Vector<String> userIDs = new Vector<String>();
                            while (true) {
                                if (!srUser.hasNext()) break;
                                String userID = (String)srUser.next();
                                if (!usersIDsOfAccounts.contains(userID)) continue;
                                userIDs.add(userID);
                            }
                            PrincipalIteratorImpl principalIterator = new PrincipalIteratorImpl(userIDs, PrincipalIterator.ITERATOR_TYPE_UNIQUEIDS_NOT_CHECKED);
                            principalIterator.setState(srUser.getState() | accounts.getState());
                            PrincipalIteratorImpl principalIteratorImpl2 = principalIterator;
                            Object var13_15 = null;
                            if (monitor == null) return principalIteratorImpl2;
                            monitor.endComponent("UME:searchUsers:accountFilter");
                            monitor.endRequest("UME:searchUsers:accountFilter");
                            return principalIteratorImpl2;
                        }
                        iSearchResult = srUser;
                        break block11;
                    }
                    catch (UMException umex) {
                        throw new UMRuntimeException((Throwable)umex);
                    }
                }
                catch (Throwable throwable) {
                    Object var13_17 = null;
                    if (monitor == null) throw throwable;
                    monitor.endComponent("UME:searchUsers:accountFilter");
                    monitor.endRequest("UME:searchUsers:accountFilter");
                    throw throwable;
                }
            }
            monitor.endComponent("UME:searchUsers:accountFilter");
            monitor.endRequest("UME:searchUsers:accountFilter");
            return principalIteratorImpl;
        }
        Object var13_16 = null;
        if (monitor == null) return iSearchResult;
        monitor.endComponent("UME:searchUsers:accountFilter");
        monitor.endRequest("UME:searchUsers:accountFilter");
        return iSearchResult;
    }

    public void saveUsers(IUserMaint[] users) throws UMException {
        int size = users.length;
        try {
            int i = 0;
            while (i < size) {
                users[i].save();
                ++i;
            }
        }
        catch (UMRuntimeException umrex) {
            throw new UMException((Throwable)umrex);
        }
    }

    public IUser getUserByLogonID(String logonid, AttributeList attrlist, String[] dataSources) throws UMException {
        IUserAccountFactory uacf = UMFactory.getUserAccountFactory();
        if (uacf != null) {
            IUserAccount ua = ((UserAccountFactory)uacf).getUserAccountByLogonId(logonid, dataSources, AbstractUserAccount.ABSTRACT_USER_ACCOUNT_DEFAULT_ATTRIBUTES);
            if (ua != null) {
                return this.getUser(ua.getAssignedUserID(), attrlist);
            }
            throw new NoSuchUserException("User account " + logonid + " does not exist.");
        }
        return null;
    }

    public IUser getUserByLogonID(String logonid, AttributeList attrList) throws UMException {
        return this.getUserByLogonID(logonid, attrList, null);
    }

    public IUser getUserByLogonID(String logonid) throws UMException {
        return this.getUserByLogonID(logonid, null);
    }

    public IUserMaint getMutableUser(String uniqueID) throws UMException {
        IPrincipalDatabagFactory mFactory = PrincipalDatabagFactory.getInstance();
        IUser u = this.getReadonlyUser(uniqueID);
        IPrincipalDatabag p = null;
        if (u != null) {
            p = ((AbstractPrincipal)u).getPrincipalDatabag();
        } else {
            p = new PrincipalDatabag(uniqueID);
            if (!mFactory.principalDatabagExists(p)) {
                throw new NoSuchUserException("user " + uniqueID + " does not exist");
            }
        }
        return new UserMaint(mFactory.getModifyPrincipalDatabag(p));
    }

    public void registerListener(UserListener userListener, int modifier) {
        boolean registered = false;
        if ((modifier & 1) == 1) {
            mAddUserListeners.add(userListener);
            registered = true;
        }
        if ((modifier & 2) == 2) {
            mDeleteUserListeners.add(userListener);
            registered = true;
        }
        if (!registered) {
            mTrace.warningT("registerListener", "userListener " + userListener + " could not be registered!");
        }
    }

    public void unregisterListener(UserListener userListener) {
        mAddUserListeners.remove(userListener);
        mDeleteUserListeners.remove(userListener);
    }

    public IUser getUserByUniqueName(String uniqueName) throws UMException {
        return this.getUserByUniqueName(uniqueName, User.USER_DEFAULT_ATTRIBUTES);
    }

    public IUser getUserByUniqueName(String uniqueName, AttributeList attrList) throws UMException {
        return this.getUserByUniqueName(uniqueName, attrList, null);
    }

    public IUser getUserByUniqueName(String uniqueName, AttributeList attrList, String[] datasources) throws UMException {
        if (uniqueName == null) {
            throw new NoSuchUserException("Cannot find user by unique name, given unique name is null!");
        }
        String uniqueID = (String)mUNCache.get(uniqueName);
        if (uniqueID != null) {
            return this.getUser(uniqueID);
        }
        SearchCriteria sc = new SearchCriteria("USER");
        sc.addEqualsElement("com.sap.security.core.usermanagement", "uniquename", uniqueName, false);
        sc.setDataSourcesToSearch(datasources);
        Vector results = PrincipalDatabagFactory.getInstance().searchPrincipalDatabags(sc);
        if (results == null || results.size() == 0) {
            throw new NoSuchUserException("User \"" + uniqueName + "\" does not exist.");
        }
        if (results.size() > 1) {
            throw new UMException("User found, but unique name \"" + uniqueName + "\" is not unique!");
        }
        mUNCache.put(uniqueName, (String)results.firstElement());
        return this.getUser((String)results.firstElement(), attrList);
    }

    public ISearchResult getUniqueIDs() throws PersistenceException {
        SearchCriteria sc = new SearchCriteria("USER");
        sc.addLikeElement("com.sap.security.core.usermanagement", "uniquename", "*", false);
        Vector result = PrincipalDatabagFactory.getInstance().searchPrincipalDatabags(sc);
        PrincipalIteratorImpl principalIterator = new PrincipalIteratorImpl(result, PrincipalIterator.ITERATOR_TYPE_UNIQUEIDS_NOT_CHECKED);
        principalIterator.setState(sc.getSearchStatus());
        return principalIterator;
    }

    public IUserMaint newUser(String uniqueName) throws UMException {
        if (uniqueName == null || uniqueName.equals("")) {
            uniqueName = "";
        } else {
            IUser user;
            block7: {
                user = null;
                try {
                    user = this.getUserByUniqueName(uniqueName);
                }
                catch (NoSuchUserException nsuex) {
                    if (mTrace.beDebug()) {
                        mTrace.debugT("newUser", nsuex);
                    }
                }
                catch (PersistenceException nsuex) {
                    if (!mTrace.beDebug()) break block7;
                    mTrace.debugT("newUser", (Throwable)((Object)nsuex));
                }
            }
            if (user != null) {
                throw new UserAlreadyExistsException("User with unique name \"" + uniqueName + "\" already exists.");
            }
        }
        UserMaint newUser = new UserMaint();
        newUser.setUniqueName(uniqueName);
        return newUser;
    }

    public static void addUserPerformed(String uniqueID) throws UMException {
        int size = mAddUserListeners.size();
        int i = 0;
        while (i < size) {
            ((UserListener)mAddUserListeners.elementAt(i)).userAdded(uniqueID);
            ++i;
        }
        PrincipalFactory.addPrincipalPerformed(uniqueID);
    }

    public static void removeUserPerformed(String uniqueID) throws UMException {
        int size = mDeleteUserListeners.size();
        int i = 0;
        while (i < size) {
            ((UserListener)mDeleteUserListeners.elementAt(i)).userRemoved(uniqueID);
            ++i;
        }
        PrincipalFactory.removePrincipalPerformed(uniqueID);
    }

    public IUserMaint newUser(String uniqueName, IUser copyFrom) throws UMException {
        if (uniqueName == null || uniqueName.equals("")) {
            uniqueName = "";
        } else {
            IUser user;
            block5: {
                user = null;
                try {
                    user = this.getUserByUniqueName(uniqueName);
                }
                catch (NoSuchUserException nsuex) {
                    if (!mTrace.beDebug()) break block5;
                    mTrace.debugT("newUser", nsuex);
                }
            }
            if (user != null) {
                throw new UserAlreadyExistsException();
            }
        }
        UserMaint newUser = new UserMaint(copyFrom);
        newUser.setUniqueName(uniqueName);
        return newUser;
    }

    public IUser getUserByNumber(long unumber) throws UMException, FeatureNotAvailableException {
        throw new FeatureNotAvailableException();
    }

    public IUser[] findUsersByNumbers(long[] unumbers) throws UMException, FeatureNotAvailableException {
        throw new FeatureNotAvailableException();
    }

    public IUserMaint[] newUsers(String[] uniqueNames) throws UMException {
        if (uniqueNames == null) {
            throw new UMRuntimeException("Cannot create new users without unique names!");
        }
        IUserMaint[] users = new IUserMaint[uniqueNames.length];
        int i = 0;
        while (i < uniqueNames.length) {
            users[i] = this.newUser(uniqueNames[i]);
            ++i;
        }
        return users;
    }

    public IUserSearchFilter getUserSearchFilter() throws UMException {
        return new UserSearchFilter();
    }

    public void invalidateCacheEntryByLogonId(String logonid) throws UMException {
        UMFactory.getUserAccountFactory().invalidateCacheEntryByLogonId(logonid);
        AttributeList accountAttributeList = new AttributeList(false);
        accountAttributeList.addAttribute("com.sap.security.core.usermanagement", "j_user");
        accountAttributeList.addAttribute("com.sap.security.core.usermanagement", "userid");
        IUserAccount ua = ((UserAccountFactory)UMFactory.getUserAccountFactory()).getUserAccountByLogonId(logonid, null, accountAttributeList);
        if (ua != null) {
            mCache.invalidateLocally(ua.getAssignedUserID());
        }
    }

    public void invalidateCacheEntryByUniqueName(String uniqueName) throws UMException {
        String uniqueID = (String)mUNCache.get(uniqueName);
        if (uniqueID == null) {
            SearchCriteria sc = new SearchCriteria(false, "USER");
            sc.addEqualsElement("com.sap.security.core.usermanagement", "uniquename", uniqueName, false);
            Vector sr = null;
            try {
                sr = PrincipalDatabagFactory.getInstance().searchPrincipalDatabags(sc);
            }
            catch (PersistenceException ex) {
                throw new UMException((Throwable)((Object)ex));
            }
            if (sr != null) {
                int size = sr.size();
                if (size == 1) {
                    uniqueID = (String)sr.elementAt(0);
                    mCache.invalidateLocally(uniqueID);
                    mUNCache.put(uniqueName, uniqueID);
                } else {
                    mUNCache.invalidateLocally(uniqueName);
                    int i = 0;
                    while (i < size) {
                        uniqueID = (String)sr.elementAt(i);
                        mCache.invalidateLocally(uniqueID);
                        ++i;
                    }
                }
            }
        } else {
            mCache.invalidateLocally(uniqueID);
        }
    }

    public void invalidateCacheEntry(String uniqueid) throws UMException {
        mCache.invalidateLocally(uniqueid);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        IUMParameters props = UMFactory.getProperties();
        int maxLifeTime = props.getNumber(DEFAULT_USER_CACHING_TIME, 28800);
        int initialSize = props.getNumber(INITIAL_USER_CACHE_SIZE, 500);
        mCache = InternalUMFactory.getCache(4, initialSize, maxLifeTime, (class$com$sap$security$core$imp$UserFactory == null ? (class$com$sap$security$core$imp$UserFactory = UserFactory.class$("com.sap.security.core.imp.UserFactory")) : class$com$sap$security$core$imp$UserFactory).getName() + "_mCache");
        mUNCache = InternalUMFactory.getCache(4, initialSize, maxLifeTime, (class$com$sap$security$core$imp$UserFactory == null ? (class$com$sap$security$core$imp$UserFactory = UserFactory.class$("com.sap.security.core.imp.UserFactory")) : class$com$sap$security$core$imp$UserFactory).getName() + "_mUNCache");
        mAddUserListeners = new Vector();
        mDeleteUserListeners = new Vector();
    }
}

