/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserAccount;
import com.sap.security.api.InvalidPasswordException;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.UMRuntimeException;
import com.sap.security.core.imp.AbstractWrapper;
import com.sap.security.core.imp.UserAccountFactory;
import java.lang.ref.WeakReference;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Iterator;

public class UserAccountWrapper
extends AbstractWrapper
implements IUserAccount {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/imp/UserAccountWrapper.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";

    public UserAccountWrapper(IUserAccount userAccount, AttributeList attrList) {
        super(userAccount.getUniqueID(), attrList);
        this.mReadonlyPrincipal = new WeakReference<IUserAccount>(userAccount);
    }

    public Iterator getParents(String[] principalTypeIdentifiers, boolean recursive) {
        return this.getCachedUserAccount().getParents(principalTypeIdentifiers, recursive);
    }

    public boolean equals(Object another) {
        if (!(another instanceof IUserAccount)) {
            return false;
        }
        IUserAccount u = (IUserAccount)another;
        return this.mUniqueID.equals(u.getUniqueID());
    }

    public int hashCode() {
        return this.mUniqueID.hashCode();
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("Transient data:\n");
        if (this.mTransientPrincipalDatabag != null) {
            res.append(this.mTransientPrincipalDatabag.toString());
        } else {
            res.append("No transient data set.\n");
        }
        res.append("Persistent data:\n");
        res.append(this.getCachedUserAccount().toString());
        return res.toString();
    }

    public String getLogonUid() {
        return this.getCachedUserAccount().getLogonUid();
    }

    public Date getValidFromDate() {
        return this.getCachedUserAccount().getValidFromDate();
    }

    public IUserAccount getWrappedPrincipal() {
        return this.getCachedUserAccount();
    }

    public void setValidFromDate(Date date) {
        this.getCachedUserAccount().setValidFromDate(date);
    }

    public Date getValidToDate() {
        return this.getCachedUserAccount().getValidToDate();
    }

    public IUser getAssignedUser() throws UMException {
        return this.getCachedUserAccount().getAssignedUser();
    }

    public void setValidToDate(Date date) {
        this.getCachedUserAccount().setValidToDate(date);
    }

    public boolean isLocked() {
        return this.getCachedUserAccount().isLocked();
    }

    public void setLocked(boolean lock, int reason) {
        this.getCachedUserAccount().setLocked(lock, reason);
    }

    public String getAssignedUserID() {
        return this.getCachedUserAccount().getAssignedUserID();
    }

    public int getLockReason() {
        return this.getCachedUserAccount().getLockReason();
    }

    public Date getLastFailedLogonDate() {
        return this.getCachedUserAccount().getLastFailedLogonDate();
    }

    public void setLastFailedLogonDate(Date timeStamp) {
        this.getCachedUserAccount().setLastFailedLogonDate(timeStamp);
    }

    public int getFailedLogonAttempts() {
        return this.getCachedUserAccount().getFailedLogonAttempts();
    }

    public void setFailedLogonAttempts(int i) {
        this.getCachedUserAccount().setFailedLogonAttempts(i);
    }

    public void incrementFailedLogonAttempts() {
        this.getCachedUserAccount().incrementFailedLogonAttempts();
    }

    public void resetFailedLogonAttempts() {
        this.getCachedUserAccount().resetFailedLogonAttempts();
    }

    public Date getLastSuccessfulLogonDate() {
        return this.getCachedUserAccount().getLastSuccessfulLogonDate();
    }

    public void setLastSuccessfulLogonDate(Date timeStamp) {
        this.getCachedUserAccount().setLastSuccessfulLogonDate(timeStamp);
    }

    public int getSuccessfulLogonCounts() {
        return this.getCachedUserAccount().getSuccessfulLogonCounts();
    }

    public void incrementSuccessfulLogonCounts() {
        this.getCachedUserAccount().incrementSuccessfulLogonCounts();
    }

    public void setSuccessfulLogonCounts(int i) {
        this.getCachedUserAccount().setSuccessfulLogonCounts(i);
    }

    public boolean isPasswordChangeRequired() {
        return this.getCachedUserAccount().isPasswordChangeRequired();
    }

    public Date getLastPasswordChangedDate() {
        return this.getCachedUserAccount().getLastPasswordChangedDate();
    }

    public void setPasswordChangeRequired(boolean chng) {
        this.getCachedUserAccount().setPasswordChangeRequired(chng);
    }

    public void setPassword(String pass) throws InvalidPasswordException {
        this.getCachedUserAccount().setPassword(pass);
    }

    public void setPassword(String oldpass, String newpass) throws InvalidPasswordException {
        this.getCachedUserAccount().setPassword(oldpass, newpass);
    }

    public void save() throws UMException {
        this.getCachedUserAccount().save();
    }

    public X509Certificate[] getCertificates() throws CertificateException, UMException {
        return this.getCachedUserAccount().getCertificates();
    }

    public void setCertificates(X509Certificate[] certificate) throws CertificateException, UMException {
        this.getCachedUserAccount().setCertificates(certificate);
    }

    public void deleteCertificates(X509Certificate[] certificate) throws CertificateException, UMException {
        this.getCachedUserAccount().deleteCertificates(certificate);
    }

    public boolean checkPassword(String pass) {
        return this.getCachedUserAccount().checkPassword(pass);
    }

    public void commit() throws UMException {
        this.getCachedUserAccount().commit();
    }

    public void rollback() {
        this.getCachedUserAccount().rollback();
    }

    public Date created() {
        return this.getCachedUserAccount().created();
    }

    public Date lastModified() {
        return this.getCachedUserAccount().lastModified();
    }

    public Date lockDate() {
        return this.getCachedUserAccount().lockDate();
    }

    public String getHashedPassword() throws UMException {
        return this.getCachedUserAccount().getHashedPassword();
    }

    public void setLastLogoutDate(Date timeStamp) {
        this.getCachedUserAccount().setLastLogoutDate(timeStamp);
    }

    public Date getPreviousSuccessfulLogonDate() {
        return this.getCachedUserAccount().getPreviousSuccessfulLogonDate();
    }

    public Iterator getRoles(boolean recursive) {
        return this.getCachedUserAccount().getRoles(recursive);
    }

    public Iterator getParentGroups(boolean recursive) {
        return this.getCachedUserAccount().getParentGroups(recursive);
    }

    public boolean isMemberOfRole(String roleId, boolean recursive) {
        return this.getCachedUserAccount().isMemberOfRole(roleId, recursive);
    }

    public boolean isMemberOfGroup(String groupId, boolean recursive) {
        return this.getCachedUserAccount().isMemberOfGroup(groupId, recursive);
    }

    public void addToGroup(String id) throws UMException {
        this.getCachedUserAccount().addToGroup(id);
    }

    public void removeFromGroup(String id) throws UMException {
        this.getCachedUserAccount().removeFromGroup(id);
    }

    public void addToRole(String id) throws UMException {
        this.getCachedUserAccount().addToRole(id);
    }

    public void removeFromRole(String id) throws UMException {
        this.getCachedUserAccount().removeFromRole(id);
    }

    public boolean setAttribute(String namespace, String name, String[] values) {
        return this.getCachedUserAccount().setAttribute(namespace, name, values);
    }

    public boolean setBinaryAttribute(String namespace, String name, byte[] value) {
        return this.getCachedUserAccount().setBinaryAttribute(namespace, name, value);
    }

    public boolean isModified() {
        return this.getCachedUserAccount().isModified();
    }

    public boolean setDisplayName(String displayName) throws UMException {
        return this.getCachedUserAccount().setDisplayName(displayName);
    }

    public String getUniqueID() {
        return this.mUniqueID;
    }

    public String[] getAttribute(String namespace, String name) {
        return this.getCachedUserAccount().getAttribute(namespace, name);
    }

    public byte[] getBinaryAttribute(String namespace, String name) {
        return this.getCachedUserAccount().getBinaryAttribute(namespace, name);
    }

    public String[] getAttributeNamespaces() {
        return this.getCachedUserAccount().getAttributeNamespaces();
    }

    public String[] getAttributeNames(String namespace) {
        return this.getCachedUserAccount().getAttributeNames(namespace);
    }

    public String getDisplayName() {
        return this.getCachedUserAccount().getDisplayName();
    }

    public boolean isExistenceChecked() {
        return this.getCachedUserAccount().isExistenceChecked();
    }

    public void refresh() throws UMException {
        UMFactory.getUserAccountFactory().invalidateCacheEntry(this.mUniqueID);
        this.mReadonlyPrincipal = null;
    }

    private IUserAccount getCachedUserAccount() {
        try {
            IUserAccount uacc = null;
            if (this.mReadonlyPrincipal != null) {
                uacc = (IUserAccount)this.mReadonlyPrincipal.get();
            }
            if (uacc == null) {
                uacc = this.mAttributeList == null ? ((UserAccountFactory)UMFactory.getUserAccountFactory()).getReadonlyUserAccount(this.mUniqueID) : ((UserAccountFactory)UMFactory.getUserAccountFactory()).getReadonlyUserAccount(this.mUniqueID, this.mAttributeList);
                this.mReadonlyPrincipal = new WeakReference<IUserAccount>(uacc);
            }
            return uacc;
        }
        catch (UMException umex) {
            throw new UMRuntimeException((Throwable)umex);
        }
    }

    public boolean isMutable() {
        return this.getCachedUserAccount().isMutable();
    }

    public String getAttributeType(String namespace, String attributeName) {
        return this.getCachedUserAccount().getAttributeType(namespace, attributeName);
    }
}

